/*
 * Decompiled with CFR 0.152.
 */
package dev.numeric;

import dev.numeric.PnSuperLUSolver;
import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.numeric.PnBandEigenSolver;
import jvx.numeric.PnLanczos;
import jvx.numeric.PnSparseMatrix;

public class PnBandEigenSolverSuperLU
extends PnBandEigenSolver
implements PnLanczos.PnMatrixVectorProductIf {
    protected PnSparseMatrix m_matrix;
    protected long m_factorization = 0L;

    public PnBandEigenSolverSuperLU() {
        this.setName("band-by-band SuperLU");
        if (((Object)((Object)this)).getClass() == PnBandEigenSolverSuperLU.class) {
            this.init();
        }
    }

    protected PnLanczos getLanczos() {
        return new PnLanczos((PnLanczos.PnMatrixVectorProductIf)this);
    }

    protected void shiftSpectrum(double shift) {
        PdVector[] entries = this.m_matrix.getEntries();
        int i = 0;
        while (i < this.m_matrix.getNumRows()) {
            PiVector indices = this.m_matrix.getColIndices(i);
            int j = 0;
            while (j < indices.getSize()) {
                if (indices.m_data[j] == i) {
                    int n = j;
                    entries[i].m_data[n] = entries[i].m_data[n] - shift;
                }
                ++j;
            }
            ++i;
        }
        this.destroy();
    }

    public void init() {
        super.init();
    }

    protected void destroy() {
        if (this.m_factorization != 0L) {
            PnSuperLUSolver.freeFactorization(this.m_factorization);
            this.m_factorization = 0L;
        }
    }

    public int getDimension() {
        return this.m_matrix.getNumRows();
    }

    public PdVector run(PdVector v) {
        if (this.m_factorization == 0L) {
            try {
                this.m_factorization = PnSuperLUSolver.factor(this.m_matrix.getNumCols(), this.m_matrix.getColIndices(), this.m_matrix.getNumEntries(), this.m_matrix.getEntries());
            }
            catch (Exception e) {
                PsDebug.error((String)"Unable to factorize matrix with SuperLU.", (Object)e);
            }
        }
        PdVector w = new PdVector(v.getSize());
        try {
            PnSuperLUSolver.solveUsingLU(this.m_factorization, w.m_data, v.m_data);
        }
        catch (Exception e) {
            PsDebug.error((String)"Unable to solve linear system using SuperLU.", (Object)e);
        }
        return w;
    }

    public Object getMatrix() {
        return this.m_matrix;
    }

    public void setMatrix(Object matrix) {
        this.m_matrix = (PnSparseMatrix)matrix;
    }

    public boolean isAvailable() {
        return PnSuperLUSolver.isAvailable();
    }

    public int getInputType() {
        return 1;
    }
}

