/*
 * Decompiled with CFR 0.152.
 */
package dev.numeric;

import dev.numeric.PnLUFactorization;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jvx.numeric.PnBandEigenSolver;
import jvx.numeric.PnLanczos;

public class PnBandEigenSolverDense
extends PnBandEigenSolver
implements PnLanczos.PnMatrixVectorProductIf {
    protected PdMatrix m_matrix;
    protected PnLUFactorization m_LU;

    public PnBandEigenSolverDense() {
        this.setName("band-by-band dense");
        if (((Object)((Object)this)).getClass() == PnBandEigenSolverDense.class) {
            this.init();
        }
    }

    protected void shiftSpectrum(double shift) {
        int i = 0;
        while (i < this.m_matrix.m_data.length) {
            this.m_matrix.m_data[i][i] = this.m_matrix.m_data[i][i] - shift;
            ++i;
        }
        this.m_LU = null;
    }

    protected PnLanczos getLanczos() {
        return new PnLanczos((PnLanczos.PnMatrixVectorProductIf)this);
    }

    public void init() {
        super.init();
    }

    protected void destroy() {
    }

    public int getDimension() {
        return this.m_matrix.getSize();
    }

    public PdVector run(PdVector v) {
        if (this.m_LU == null) {
            this.m_LU = new PnLUFactorization((PdMatrix)this.m_matrix.clone());
        }
        PdVector w = new PdVector(v.getSize());
        this.m_LU.solve(w, v);
        return w;
    }

    public Object getMatrix() {
        return this.m_matrix;
    }

    public void setMatrix(Object matrix) {
        this.m_matrix = (PdMatrix)matrix;
    }

    public boolean isAvailable() {
        return true;
    }

    public int getInputType() {
        return 0;
    }
}

