/*
 * Decompiled with CFR 0.152.
 */
package dev.number;

import jv.number.PuComplex;

public class PnSpecialComplexFunctions {
    public static final int DEFAULT_THETA_APPROX_ORDER = 3;
    public static final int DEFAULT_RIEMANN_ZETA_APPROX_ORDER = 50;
    private static final double PI_SQUARED = Math.PI * Math.PI;

    public static PuComplex fabry(PuComplex z, int order) {
        PuComplex sum = new PuComplex(z);
        PuComplex summand = new PuComplex(z);
        int n = 1;
        while (n <= order) {
            summand.pow((double)n);
            sum.add(summand);
            ++n;
        }
        return sum;
    }

    public static PuComplex riemannZeta(PuComplex s, int order) {
        PuComplex sum = new PuComplex(0.0);
        PuComplex summand = new PuComplex(0.0);
        int n = 1;
        while (n <= order) {
            summand.re = -Math.log(n);
            summand.im = 0.0;
            summand.mult(s);
            summand.exp();
            sum.add(summand);
            ++n;
        }
        return sum;
    }

    public static PuComplex riemannZeta(PuComplex z) {
        return PnSpecialComplexFunctions.riemannZeta(z, 50);
    }

    public static PuComplex weierstrassP(PuComplex z, PuComplex tau) {
        PuComplex theta_0_tau_sqr = PnSpecialComplexFunctions.jacobiTheta(PuComplex.ZERO, tau).sqr();
        PuComplex theta_0_tau_pow4 = PuComplex.mult((PuComplex)theta_0_tau_sqr, (PuComplex)theta_0_tau_sqr);
        PuComplex theta10_0_tau_sqr = PnSpecialComplexFunctions.theta10(PuComplex.ZERO, tau).sqr();
        PuComplex theta10_0_tau_pow4 = PuComplex.mult((PuComplex)theta10_0_tau_sqr, (PuComplex)theta10_0_tau_sqr);
        PuComplex theta01_z_tau_sqr = PnSpecialComplexFunctions.theta01(z, tau).sqr();
        PuComplex theta11_z_tau_sqr = PnSpecialComplexFunctions.theta11(z, tau).sqr();
        PuComplex quotient = theta01_z_tau_sqr.div(theta11_z_tau_sqr).mult(Math.PI * Math.PI);
        PuComplex firstSummand = quotient.mult(theta_0_tau_sqr).mult(theta10_0_tau_sqr);
        PuComplex secondSummand = theta_0_tau_pow4.add(theta10_0_tau_pow4).mult(3.289868133696453);
        return firstSummand.sub(secondSummand);
    }

    public static PuComplex jacobiTheta(PuComplex z, PuComplex tau, int order) {
        PuComplex sum = new PuComplex(0.0);
        PuComplex summand = new PuComplex(0.0);
        int n = -order;
        while (n <= order) {
            summand.re = -Math.PI * (double)n * ((double)n * tau.im + 2.0 * z.im);
            summand.im = Math.PI * (double)n * ((double)n * tau.re + 2.0 * z.re);
            summand.exp();
            sum.add(summand);
            ++n;
        }
        return sum;
    }

    public static PuComplex jacobiTheta(PuComplex z, PuComplex tau) {
        return PnSpecialComplexFunctions.jacobiTheta(z, tau, 3);
    }

    public static PuComplex theta01(PuComplex z, PuComplex tau) {
        return PnSpecialComplexFunctions.jacobiTheta(PuComplex.add((PuComplex)z, (double)0.5), tau);
    }

    public static PuComplex theta10(PuComplex z, PuComplex tau) {
        double expFactorIm = Math.PI * (0.25 * tau.re + z.re);
        double expFactorRe = -Math.PI * (0.25 * tau.im + z.im);
        PuComplex sum = new PuComplex(0.0);
        PuComplex summand = new PuComplex(0.0);
        int n = -3;
        while (n <= 3) {
            summand.re = -Math.PI * (double)n * ((double)(n + 1) * tau.im + 2.0 * z.im) + expFactorRe;
            summand.im = Math.PI * (double)n * ((double)(n + 1) * tau.re + 2.0 * z.re) + expFactorIm;
            summand.exp();
            sum.add(summand);
            ++n;
        }
        return sum;
    }

    public static PuComplex theta11(PuComplex z, PuComplex tau) {
        double expFactorIm = Math.PI * (0.25 * tau.re + z.re + 0.5);
        double expFactorRe = -Math.PI * (0.25 * tau.im + z.im);
        PuComplex sum = new PuComplex(0.0);
        PuComplex summand = new PuComplex(0.0);
        int n = -3;
        while (n <= 3) {
            summand.re = -Math.PI * (double)n * ((double)(n + 1) * tau.im + 2.0 * z.im) + expFactorRe;
            summand.im = Math.PI * (double)n * ((double)(n + 1) * tau.re + 2.0 * z.re + 1.0) + expFactorIm;
            summand.exp();
            sum.add(summand);
            ++n;
        }
        return sum;
    }

    public static PuComplex ellipticTheta(PuComplex z, PuComplex tau) {
        PuComplex enumerator = PnSpecialComplexFunctions.jacobiTheta(PuComplex.add((PuComplex)z, (double)0.5), tau);
        enumerator.mult(enumerator);
        PuComplex denominator = PnSpecialComplexFunctions.jacobiTheta(z, tau);
        denominator.mult(denominator);
        return enumerator.div(denominator);
    }
}

