/*
 * Decompiled with CFR 0.152.
 */
package dev.loader;

import java.io.BufferedReader;
import java.io.IOException;
import jv.loader.PgAbstractLoader;
import jv.loader.PsXmlLoader;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.project.PgJvxSrc;
import jv.rsrc.PsXmlNode;
import jv.rsrc.PsXmlSrc;
import jv.vecmath.PdVector;

public final class PgXvcLoader
extends PgAbstractLoader {
    public static PgJvxSrc[] read(String fileName) {
        BufferedReader in = PsUtil.open((String)fileName);
        if (in == null) {
            PsDebug.warning((String)("could not open = " + fileName));
            return null;
        }
        PgXvcLoader loader = new PgXvcLoader();
        PgJvxSrc[] geomArr = loader.read(in);
        try {
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (geomArr != null) {
            int i = 0;
            while (i < geomArr.length) {
                String name;
                if (geomArr[i] != null && ((name = geomArr[i].getName()) == null || name.toLowerCase().startsWith("object_"))) {
                    String fileBase = PsUtil.getFileBaseName((String)fileName);
                    if (i == 0) {
                        geomArr[i].setName(fileBase);
                    } else {
                        geomArr[i].setName(String.valueOf(fileBase) + "[" + i + "]");
                    }
                }
                ++i;
            }
        }
        return geomArr;
    }

    public PgJvxSrc[] read(BufferedReader in) {
        if (in == null) {
            PsDebug.warning((String)"missing buffered reader");
            return null;
        }
        PsXmlSrc src = PsXmlLoader.read((BufferedReader)in);
        if (src == null) {
            PsDebug.warning((String)"failed to parse XML stream");
            return null;
        }
        PgJvxSrc[] geom = this.parseRsrcTree(src);
        if (geom == null) {
            PsDebug.warning((String)"failed to interpret XVC tree");
            return null;
        }
        return geom;
    }

    protected PgJvxSrc[] parseRsrcTree(PsXmlSrc src) {
        PsXmlNode coord3d;
        PsXmlNode scene3d;
        int j;
        int i;
        PsXmlNode coord2d;
        PsXmlNode root = src.getRootNode();
        if (root == null) {
            PsDebug.warning((String)"missing root node.");
            return null;
        }
        if (root.getType() == null || !root.getType().equalsIgnoreCase("Canvas")) {
            PsDebug.warning((String)"missing <Canvas> element,\nthis is not a valid MuPAD xvc file.");
            return null;
        }
        PgJvxSrc geom = null;
        PgJvxSrc[][] animArr = null;
        PsXmlNode scene2d = PsXmlSrc.getRsrcNode((PsXmlNode)root, (String)"Scene2d");
        if (scene2d != null && (coord2d = PsXmlSrc.getRsrcNode((PsXmlNode)scene2d, (String)"CoordinateSystem2d")) != null) {
            PsXmlNode[] obj2d = PsXmlSrc.getRsrcNodes((PsXmlNode)coord2d, (String)"Obj2d");
            if (obj2d == null || obj2d.length == 0) {
                return null;
            }
            animArr = new PgJvxSrc[obj2d.length][];
            i = 0;
            while (i < obj2d.length) {
                PsXmlNode[] img2d = PsXmlSrc.getRsrcNodes((PsXmlNode)obj2d[i], (String)"Img2d");
                if (img2d != null) {
                    int len = img2d.length;
                    animArr[i] = new PgJvxSrc[len];
                    j = 0;
                    while (j < len) {
                        PsXmlNode pt2d;
                        PsXmlNode poly2d = PsXmlSrc.getRsrcNode((PsXmlNode)img2d[1], (String)"Poly2d");
                        if (poly2d != null) {
                            geom = new PgJvxSrc();
                            geom.setType(31);
                            geom.showPolygons(true);
                            PdVector[] vertex = PsXmlLoader.parseDoubleList((PsXmlNode)poly2d, (String)"P2", null);
                            if (vertex != null) {
                                geom.setDimOfVertices(vertex[0].getSize());
                                geom.setNumVertices(vertex.length);
                                geom.setVertices(vertex);
                            }
                        }
                        if ((pt2d = PsXmlSrc.getRsrcNode((PsXmlNode)img2d[1], (String)"Pt2d")) != null) {
                            geom = new PgJvxSrc();
                            geom.setType(31);
                            geom.showPolygons(true);
                            PdVector[] vertex = PsXmlLoader.parseDoubleList((PsXmlNode)pt2d, (String)"Pt2d", null);
                            if (vertex != null) {
                                geom.setDimOfVertices(vertex[0].getSize());
                                geom.setNumVertices(vertex.length);
                                geom.setVertices(vertex);
                            }
                        }
                        animArr[i][j] = geom;
                        ++j;
                    }
                }
                ++i;
            }
        }
        if ((scene3d = PsXmlSrc.getRsrcNode((PsXmlNode)root, (String)"Scene3d")) != null && (coord3d = PsXmlSrc.getRsrcNode((PsXmlNode)scene3d, (String)"CoordinateSystem3d")) != null) {
            PsXmlNode[] obj3d = PsXmlSrc.getRsrcNodes((PsXmlNode)coord3d, (String)"Obj3d");
            if (obj3d == null || obj3d.length == 0) {
                return null;
            }
            animArr = new PgJvxSrc[obj3d.length][];
            i = 0;
            while (i < obj3d.length) {
                geom = new PgJvxSrc();
                PsXmlNode[] img3d = PsXmlSrc.getRsrcNodes((PsXmlNode)obj3d[i], (String)"Img3d");
                if (img3d != null) {
                    int len = img3d.length;
                    animArr[i] = new PgJvxSrc[len];
                    j = 0;
                    while (j < len) {
                        PsXmlNode mesh3d = PsXmlSrc.getRsrcNode((PsXmlNode)img3d[j], (String)"Mesh3d");
                        if (mesh3d != null) {
                            PdVector[] vertex;
                            geom = new PgJvxSrc();
                            geom.setType(33);
                            geom.showElements(true);
                            int vDiscr = this.getAttributeAsInt(mesh3d, "VMesh");
                            int uDiscr = this.getAttributeAsInt(mesh3d, "UMesh");
                            if (vDiscr != -1 && uDiscr != -1) {
                                geom.makeQuadrConn(uDiscr, vDiscr, false, false);
                            }
                            if ((vertex = PsXmlLoader.parseDoubleList((PsXmlNode)mesh3d, (String)"P3", null)) != null) {
                                geom.setDimOfVertices(vertex[0].getSize());
                                geom.setNumVertices(vertex.length);
                                geom.setVertices(vertex);
                            }
                        }
                        animArr[i][j] = geom;
                        ++j;
                    }
                }
                ++i;
            }
        }
        return animArr[0];
    }

    private int getAttributeAsInt(PsXmlNode node, String att) {
        String val = node.getAttribute(att);
        if (val == null) {
            return -1;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            PsDebug.warning((String)("wrong format = " + val));
            return -1;
        }
    }
}

