/*
 * Decompiled with CFR 0.152.
 */
package dev.loader;

import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import jv.loader.PgAbstractLoader;
import jv.loader.PsXmlLoader;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.project.PgJvxSrc;
import jv.rsrc.PsXmlNode;
import jv.rsrc.PsXmlSrc;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PgXmlLoader
extends PgAbstractLoader {
    public static PgJvxSrc[] read(String fileName) {
        BufferedReader in = PsUtil.open((String)fileName);
        if (in == null) {
            PsDebug.warning((String)("could not open = " + fileName));
            return null;
        }
        PgXmlLoader loader = new PgXmlLoader();
        PgJvxSrc[] geoms = loader.read(in);
        try {
            in.close();
        }
        catch (IOException ie) {
            PsDebug.warning((String)("Could not close file input stream = " + fileName));
        }
        return geoms;
    }

    public PgJvxSrc[] read(BufferedReader in) {
        if (in == null) {
            PsDebug.warning((String)"missing reader");
            return null;
        }
        PsXmlSrc src = PsXmlLoader.read((BufferedReader)in);
        if (src == null) {
            PsDebug.warning((String)"failed to parse XML stream");
            return null;
        }
        PgJvxSrc[] geoms = this.parseRsrcTree(src);
        if (geoms == null) {
            PsDebug.warning((String)"failed to interpret JVX tree");
            return null;
        }
        return geoms;
    }

    private PgJvxSrc[] parseRsrcTree(PsXmlSrc src) {
        PsXmlNode[] nsCellList;
        PsXmlNode[] nsVertexList;
        PgJvxSrc geom = new PgJvxSrc();
        PsXmlNode root = src.getRootNode();
        if (root == null) {
            PsDebug.warning((String)"missing root node.");
            return null;
        }
        PsXmlNode nMesh = PsXmlSrc.getRsrcNode((PsXmlNode)root, (String)"mesh");
        CellType aCelltype = CellType.valueOf(nMesh.getAttribute("celltype").toUpperCase());
        CellType cellType = CellType.TRIANGLE;
        switch (aCelltype) {
            case TRIANGLE: {
                geom.setType(33);
                geom.setDimOfElements(3);
                cellType = CellType.TRIANGLE;
                break;
            }
            case TETRAHEDRON: {
                geom.setType(34);
                geom.setDimOfElements(4);
                cellType = CellType.TETRAHEDRON;
                break;
            }
            default: {
                PsDebug.warning((String)("Unknown cell type: " + (Object)((Object)aCelltype)));
                return null;
            }
        }
        String aDim = nMesh.getAttribute("dim");
        int dim = Integer.parseInt(aDim);
        geom.setDimOfVertices(dim);
        PsXmlNode nVertices = PsXmlSrc.getRsrcNode((PsXmlNode)nMesh, (String)"vertices");
        String aVerticesSize = nVertices.getAttribute("size");
        int verticesSize = Integer.parseInt(aVerticesSize);
        geom.setNumVertices(verticesSize);
        PsXmlNode[] psXmlNodeArray = nsVertexList = PsXmlSrc.getRsrcNodes((PsXmlNode)nVertices, (String)"vertex");
        int n = nsVertexList.length;
        int n2 = 0;
        while (n2 < n) {
            PsXmlNode n3 = psXmlNodeArray[n2];
            String aIndex = n3.getAttribute("index");
            int idx = Integer.parseInt(aIndex);
            switch (cellType) {
                case TRIANGLE: {
                    PdVector v;
                    double z;
                    String aX = n3.getAttribute("x");
                    String aY = n3.getAttribute("y");
                    double x = Double.parseDouble(aX);
                    double y = Double.parseDouble(aY);
                    if (dim == 3) {
                        String aZ = n3.getAttribute("z");
                        z = Double.parseDouble(aZ);
                        v = new PdVector(x, y, z);
                        geom.setVertex(idx, v);
                        break;
                    }
                    v = new PdVector(x, y);
                    geom.setVertex(idx, v);
                    break;
                }
                case TETRAHEDRON: {
                    String aX = n3.getAttribute("x");
                    String aY = n3.getAttribute("y");
                    String aZ = n3.getAttribute("z");
                    double x = Double.parseDouble(aX);
                    double y = Double.parseDouble(aY);
                    double z = Double.parseDouble(aZ);
                    PdVector v = new PdVector(x, y, z);
                    geom.setVertex(idx, v);
                    break;
                }
                default: {
                    return null;
                }
            }
            ++n2;
        }
        PsXmlNode nCells = PsXmlSrc.getRsrcNode((PsXmlNode)nMesh, (String)"cells");
        String aCellsSize = nCells.getAttribute("size");
        int cellsSize = Integer.parseInt(aCellsSize);
        geom.setNumElements(cellsSize);
        switch (cellType) {
            case TRIANGLE: {
                nsCellList = PsXmlSrc.getRsrcNodes((PsXmlNode)nCells, (String)"triangle");
                break;
            }
            case TETRAHEDRON: {
                nsCellList = PsXmlSrc.getRsrcNodes((PsXmlNode)nCells, (String)"tetrahedron");
                break;
            }
            default: {
                return null;
            }
        }
        PsXmlNode[] psXmlNodeArray2 = nsCellList;
        int n4 = nsCellList.length;
        int n5 = 0;
        while (n5 < n4) {
            PiVector v;
            PsXmlNode n6 = psXmlNodeArray2[n5];
            String aIndex = n6.getAttribute("index");
            int idx = Integer.parseInt(aIndex);
            switch (cellType) {
                case TRIANGLE: {
                    String aV0 = n6.getAttribute("v0");
                    String aV1 = n6.getAttribute("v1");
                    String aV2 = n6.getAttribute("v2");
                    int v0 = Integer.parseInt(aV0);
                    int v1 = Integer.parseInt(aV1);
                    int v2 = Integer.parseInt(aV2);
                    v = new PiVector(v0, v1, v2);
                    break;
                }
                case TETRAHEDRON: {
                    String aV0 = n6.getAttribute("v0");
                    String aV1 = n6.getAttribute("v1");
                    String aV2 = n6.getAttribute("v2");
                    String aV3 = n6.getAttribute("v3");
                    int v0 = Integer.parseInt(aV0);
                    int v1 = Integer.parseInt(aV1);
                    int v2 = Integer.parseInt(aV2);
                    int v3 = Integer.parseInt(aV3);
                    v = new PiVector(v0, v1, v2, v3);
                    break;
                }
                default: {
                    return null;
                }
            }
            geom.setElement(idx, v);
            ++n5;
        }
        return new PgJvxSrc[]{geom};
    }

    public boolean write(Writer writer, PgJvxSrc[] geomArr) throws IOException {
        CellType cellType;
        if (geomArr == null || geomArr.length == 0 || geomArr[0] == null) {
            PsDebug.warning((String)"missing geometry");
            return false;
        }
        PgJvxSrc geom = geomArr[0];
        int nov = geom.getNumVertices();
        int noe = geom.getNumElements();
        int doe = geom.getDimOfElements();
        int dov = geom.getDimOfVertices();
        switch (doe) {
            case 3: {
                if (dov != 2 && dov != 3) {
                    PsDebug.error((String)"Dolfin does not support triangle meshes in != 2,3 dimensions");
                    return false;
                }
                cellType = CellType.TRIANGLE;
                break;
            }
            case 4: {
                cellType = CellType.TETRAHEDRON;
                if (dov == 3) break;
                PsDebug.error((String)"Dolfin does not support tet meshes in != 3 dimensions");
                return false;
            }
            default: {
                PsDebug.error((String)"Cell type not supported");
                return false;
            }
        }
        PsXmlSrc xml = new PsXmlSrc();
        PsXmlNode root = new PsXmlNode("dolfin");
        xml.setRootNode(root);
        root.addAttribute("xmlns:dolfin", "http://www.fenics.org/dolfin/");
        PsXmlNode nMesh = root.addChild("mesh");
        switch (cellType) {
            case TRIANGLE: {
                nMesh.addAttribute("celltype", "triangle");
                break;
            }
            case TETRAHEDRON: {
                nMesh.addAttribute("celltype", "tetrahedron");
                break;
            }
        }
        nMesh.addAttribute("dim", String.valueOf(dov));
        PsXmlNode nVertices = nMesh.addChild("vertices");
        nVertices.addAttribute("size", String.valueOf(nov));
        int i = 0;
        while (i < nov) {
            PdVector v = geom.getVertex(i);
            PsXmlNode nVertex = nVertices.addChild("vertex");
            nVertex.addAttribute("index", String.valueOf(i));
            nVertex.addAttribute("x", String.valueOf(v.getEntry(0)));
            nVertex.addAttribute("y", String.valueOf(v.getEntry(1)));
            if (dov == 3) {
                nVertex.addAttribute("z", String.valueOf(v.getEntry(2)));
            }
            ++i;
        }
        PsXmlNode nCells = nMesh.addChild("cells");
        nCells.addAttribute("size", String.valueOf(noe));
        int i2 = 0;
        while (i2 < noe) {
            PsXmlNode nCell;
            switch (cellType) {
                case TRIANGLE: {
                    nCell = nCells.addChild("triangle");
                    break;
                }
                case TETRAHEDRON: {
                    nCell = nCells.addChild("tetrahedron");
                    break;
                }
                default: {
                    return false;
                }
            }
            PiVector e = geom.getElement(i2);
            nCell.addAttribute("index", String.valueOf(i2));
            nCell.addAttribute("v0", String.valueOf(e.getEntry(0)));
            nCell.addAttribute("v1", String.valueOf(e.getEntry(1)));
            nCell.addAttribute("v2", String.valueOf(e.getEntry(2)));
            if (doe == 4) {
                nCell.addAttribute("v3", String.valueOf(e.getEntry(3)));
            }
            ++i2;
        }
        boolean status = true;
        int i3 = 0;
        while (i3 < geom.getNumVectorFields()) {
            PdVector[] vf = geom.getVectors(i3);
            PsDebug.notify((String)("Storing vector field " + i3));
            status &= this.writeVectorField("vf_" + i3 + ".xml", vf);
            ++i3;
        }
        try {
            status &= PsXmlSrc.write((Writer)writer, (PsXmlSrc)xml);
        }
        catch (IOException ex) {
            PsDebug.warning((String)"failed to write XML tree", (Object)ex);
            status = false;
        }
        return status;
    }

    private boolean writeVectorField(String filename, PdVector[] vf) {
        PsXmlSrc xml = new PsXmlSrc();
        PsXmlNode root = new PsXmlNode("dolfin");
        xml.setRootNode(root);
        root.addAttribute("xmlns:dolfin", "http://fenicsproject.org");
        PsXmlNode nFunctionData = root.addChild("function_data");
        nFunctionData.addAttribute("size", Integer.toString(3 * vf.length));
        int i = 0;
        while (i < vf.length) {
            int j = 0;
            while (j < 3) {
                PsXmlNode nDof = nFunctionData.addChild("dof");
                nDof.addAttribute("cell_index", Integer.toString(i));
                nDof.addAttribute("index", Integer.toString(3 * i + j));
                nDof.addAttribute("cell_dof_index", Integer.toString(j));
                nDof.addAttribute("value", Double.toString(vf[i].getEntry(j)));
                ++j;
            }
            ++i;
        }
        try {
            FileWriter writer = new FileWriter(filename);
            PsXmlSrc.write((Writer)writer, (PsXmlSrc)xml);
            writer.close();
            return true;
        }
        catch (IOException ex) {
            PsDebug.warning((String)"failed to write XML tree", (Object)ex);
            return false;
        }
    }

    private static enum CellType {
        TRIANGLE,
        TETRAHEDRON;

    }
}

