/*
 * Decompiled with CFR 0.152.
 */
package dev.loader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import jv.loader.PgAbstractLoader;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.project.PgJvxSrc;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PgVdaLoader
extends PgAbstractLoader {
    private int m_lineNumber = 1;

    public PgJvxSrc[] read(BufferedReader in) {
        PsDebug.warning((String)"Read method of PgVdaLoader is not implemented yet.");
        return null;
    }

    public boolean write(Writer writer, PgJvxSrc[] geomArr) throws IOException {
        if (geomArr == null || geomArr.length == 0 || geomArr[0] == null) {
            PsDebug.warning((String)"missing geometry");
            return false;
        }
        this.m_lineNumber = 1;
        int numPolygons = 0;
        this.writeLine(writer, "VDAFILE = HEADER / 20");
        this.writeLine(writer, "************************************************************************");
        this.writeLine(writer, "VDAFS VERSION      : 2.0");
        this.writeLine(writer, "----------------------------ANGABEN UEBER DEN ABSENDER------------------");
        this.writeLine(writer, "SENDEFIRMA         :");
        this.writeLine(writer, "ANSPRECHPARTNER    :");
        this.writeLine(writer, "TELEFON            :");
        this.writeLine(writer, "ADRESSE            :");
        this.writeLine(writer, "ERZEUGENDES SYSTEM : JavaView " + PsConfig.getVersion());
        Date date = new Date();
        this.writeLine(writer, "ERZEUGUNGSDATUM    : " + date.toString());
        this.writeLine(writer, "SENDE-FILENAME     :");
        this.writeLine(writer, "----------------------------ANGABEN UEBER DAS TEIL----------------------");
        this.writeLine(writer, "PROJEKT            : ");
        this.writeLine(writer, "PROJEKTKENNUNG     :");
        this.writeLine(writer, "VARIANTE           :");
        this.writeLine(writer, "VERTRAULICHKEIT    :");
        this.writeLine(writer, "GUELTIGKEITSDATUM  :");
        this.writeLine(writer, "----------------------------ANGABEN UEBER/FUER DEN EMPFAENGER-----------");
        this.writeLine(writer, "EMPFAENGERFIRMA    :");
        this.writeLine(writer, "EMPFAENGERNAME/ABT :");
        this.writeLine(writer, "************************************************************************");
        this.writeLine(writer, "GENERAL = BEGINSET");
        int mantissa = 15;
        int i = 0;
        while (i < geomArr.length) {
            if (geomArr[i].getType() == 32 || geomArr[i].getType() == 31) {
                String line;
                if (geomArr[i].getType() == 32) {
                    PgJvxSrc polySet = geomArr[i];
                    int nop = polySet.getNumPolygons();
                    int j = 0;
                    while (j < nop) {
                        PiVector poly = polySet.getPolygon(j);
                        int nov = poly.getSize();
                        String polyName = Integer.toString(numPolygons);
                        while (polyName.length() < 7) {
                            polyName = "0" + polyName;
                        }
                        polyName = "C" + polyName;
                        this.writeLine(writer, String.valueOf(polyName) + " = CURVE / " + (nov - 1) + ",");
                        int cnt = 0;
                        while (cnt < nov) {
                            line = "";
                            int k = 0;
                            while (k < 8) {
                                if (cnt == nov) break;
                                String pStr = Integer.toString(cnt);
                                pStr = String.valueOf(pStr) + ".0, ";
                                while (pStr.length() < 9) {
                                    pStr = " " + pStr;
                                }
                                line = String.valueOf(line) + pStr;
                                ++cnt;
                                ++k;
                            }
                            this.writeLine(writer, line);
                        }
                        int k = 0;
                        while (k < nov - 1) {
                            String line2 = "2, ";
                            PdVector vertex = polySet.getVertex(poly.m_data[k]);
                            PdVector direction = PdVector.subNew((PdVector)polySet.getVertex(poly.m_data[k + 1]), (PdVector)vertex);
                            int m = 0;
                            while (m < 3) {
                                line2 = String.valueOf(line2) + PuString.doubleToString((double)vertex.m_data[m], (int)mantissa) + ", ";
                                line2 = String.valueOf(line2) + PuString.doubleToString((double)direction.m_data[m], (int)mantissa);
                                if (k != nov - 2 || m != 2) {
                                    line2 = String.valueOf(line2) + ", ";
                                }
                                this.writeLine(writer, line2);
                                line2 = "   ";
                                ++m;
                            }
                            ++k;
                        }
                        ++numPolygons;
                        ++j;
                    }
                } else {
                    PgJvxSrc polygon = geomArr[i];
                    int nov = polygon.getNumVertices();
                    String polyName = Integer.toString(numPolygons);
                    while (polyName.length() < 7) {
                        polyName = "0" + polyName;
                    }
                    polyName = "C" + polyName;
                    this.writeLine(writer, String.valueOf(polyName) + " = CURVE / " + (nov - 1) + ",");
                    int cnt = 0;
                    while (cnt < nov) {
                        String line3 = "";
                        int k = 0;
                        while (k < 8) {
                            if (cnt == nov) break;
                            String pStr = Integer.toString(cnt);
                            pStr = String.valueOf(pStr) + ".0, ";
                            while (pStr.length() < 9) {
                                pStr = " " + pStr;
                            }
                            line3 = String.valueOf(line3) + pStr;
                            ++cnt;
                            ++k;
                        }
                        this.writeLine(writer, line3);
                    }
                    int k = 0;
                    while (k < nov - 1) {
                        line = "2, ";
                        PdVector vertex = polygon.getVertex(k);
                        PdVector direction = PdVector.subNew((PdVector)polygon.getVertex(k + 1), (PdVector)vertex);
                        int m = 0;
                        while (m < 3) {
                            line = String.valueOf(line) + PuString.doubleToString((double)vertex.m_data[m], (int)mantissa) + ", ";
                            line = String.valueOf(line) + PuString.doubleToString((double)direction.m_data[m], (int)mantissa);
                            if (k != nov - 2 || m != 2) {
                                line = String.valueOf(line) + ", ";
                            }
                            this.writeLine(writer, line);
                            line = "   ";
                            ++m;
                        }
                        ++k;
                    }
                    ++numPolygons;
                }
            }
            ++i;
        }
        this.writeLine(writer, "GENERAL = ENDSET");
        this.writeLine(writer, "GENERAL = GROUP / " + numPolygons + ",");
        i = 0;
        while (i < numPolygons) {
            String polyName = Integer.toString(i);
            while (polyName.length() < 7) {
                polyName = "0" + polyName;
            }
            if (i < numPolygons - 1) {
                polyName = String.valueOf(polyName) + ",";
            }
            this.writeLine(writer, "C" + polyName);
            ++i;
        }
        this.writeLine(writer, "VDAFILE = END");
        return true;
    }

    private void writeLine(Writer writer, String line) {
        if (line.length() > 72) {
            PsDebug.warning((String)"Line exceeds the maximum line length.");
        }
        while (line.length() < 72) {
            line = String.valueOf(line) + " ";
        }
        String lnStr = Integer.toString(this.m_lineNumber);
        while (lnStr.length() < 8) {
            lnStr = "0" + lnStr;
        }
        ++this.m_lineNumber;
        try {
            writer.write(String.valueOf(line) + lnStr + "\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

