/*
 * Decompiled with CFR 0.152.
 */
package dev.loader;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.Vector;
import jv.geom.PgElementSet;
import jv.geom.PuCleanMesh;
import jv.loader.PgAbstractLoader;
import jv.number.PuDouble;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.project.PgGeometry;
import jv.project.PgJvxSrc;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.thirdParty.acmeGui.YesNoBox;

public class PgTriLoader
extends PgAbstractLoader {
    public PgJvxSrc[] read(BufferedReader in) {
        if (in == null) {
            PsDebug.warning((String)"missing reader");
            return null;
        }
        PgJvxSrc geom = new PgJvxSrc();
        if (!this.parse(in, geom)) {
            PsDebug.warning((String)"error during parsing of reader");
            return null;
        }
        if (geom.getNumElements() == 0) {
            geom.setType(30);
            geom.showVertices(true);
            geom.setGlobalVertexSize(1.0);
        } else {
            geom.setType(33);
            geom.assureNeighbours();
            geom.showEdges(true);
            geom.showElements(true);
        }
        this.m_geomArr = new PgJvxSrc[]{geom};
        return this.m_geomArr;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean parse(BufferedReader bufReader, PgJvxSrc geom) {
        try {
            String line = bufReader.readLine();
            int actVertexIndex = 0;
            int actElementIndex = 0;
            PgElementSet geom2 = new PgElementSet(3);
            Vector<Color> colors = new Vector<Color>();
            while (line != null) {
                String[] actLine = PuString.splitString((String)line, (char)' ');
                if (actLine.length != 10) {
                    PsDebug.warning((String)"Error during parsing of file - parsing aborted.");
                    return false;
                }
                geom.setNumVertices(actVertexIndex + 3);
                int i = 0;
                while (i < 3) {
                    PdVector actVertex = geom.getVertex(actVertexIndex + i);
                    int j = 0;
                    while (j < 3) {
                        actVertex.m_data[j] = PuDouble.parseDouble((String)actLine[i * 3 + j]);
                        ++j;
                    }
                    ++i;
                }
                String tmp = actLine[actLine.length - 1];
                tmp = tmp.substring(2);
                colors.addElement(new Color(Integer.parseInt(tmp, 16)));
                geom.setNumElements(++actElementIndex);
                geom.setElement(actElementIndex - 1, new PiVector(actVertexIndex, actVertexIndex + 1, actVertexIndex + 2));
                actVertexIndex += 3;
                line = bufReader.readLine();
            }
            Color[] c = new Color[colors.size()];
            int i = 0;
            while (i < c.length) {
                c[i] = (Color)colors.elementAt(i);
                ++i;
            }
            geom.setElementColors(c);
            geom.showElementColors(true);
            geom2.setJvx(geom);
            geom2.makeNeighbour();
            PuCleanMesh.identifyVertices((PgGeometry)geom2);
            geom = geom2.getJvx();
            return true;
        }
        catch (IOException e) {
            PsDebug.warning((String)("Exception thrown = " + e.toString() + "\n\tparsing broke abnormally"));
            return false;
        }
    }

    public boolean write(Writer writer, PgJvxSrc[] geomArr) throws IOException {
        if (geomArr == null || geomArr.length == 0 || geomArr[0] == null) {
            PsDebug.warning((String)"missing geometry");
            return false;
        }
        PgElementSet geom = new PgElementSet(3);
        geom.setJvx(geomArr[0]);
        YesNoBox e = new YesNoBox(PsConfig.getFrame(), "Mesh must be triagulated to be saved. Triangulate now?");
        e.setVisible(true);
        if (e.getAnswer() == 1) {
            PgElementSet.triangulate((PgElementSet)geom);
        } else if (e.getAnswer() == 2) {
            return false;
        }
        String temp = "";
        int num_elem = geom.getNumElements();
        PiVector elem = new PiVector(3);
        try {
            String writeStream = "";
            DecimalFormat df = new DecimalFormat("0.00000");
            Color[] colors = geom.getElementColors();
            boolean bGlobalColor = false;
            Color c = geom.getGlobalElementColor();
            if (colors == null) {
                bGlobalColor = true;
            }
            int i = 0;
            while (i < num_elem) {
                elem = geom.getElement(i);
                int k = 0;
                while (k < 3) {
                    int j = 0;
                    while (j < 3) {
                        double help;
                        if (i == 0 && j == 0 && k == 0) {
                            help = geom.getVertex(elem.getEntry(k)).getEntry(j);
                            double d = help = Math.abs(help) >= 0.0 && Math.abs(help) < 1.0E-5 ? 0.0 : help;
                            if (help >= 0.0) {
                                writeStream = Double.toString(help);
                                writeStream = df.format(help);
                                temp = (writeStream = writeStream.replace(',', '.')).length() > 7 ? writeStream.substring(0, 7) : writeStream;
                                writer.write(temp);
                            } else {
                                writeStream = Double.toString(help);
                                writeStream = df.format(help);
                                temp = (writeStream = writeStream.replace(',', '.')).length() > 8 ? writeStream.substring(0, 8) : writeStream;
                                writer.write(temp);
                            }
                        } else if (j == 0) {
                            help = geom.getVertex(elem.getEntry(k)).getEntry(j);
                            double d = help = Math.abs(help) >= 0.0 && Math.abs(help) < 1.0E-5 ? 0.0 : help;
                            if (help >= 0.0) {
                                writeStream = Double.toString(help);
                                writeStream = df.format(help);
                                temp = (writeStream = writeStream.replace(',', '.')).length() > 7 ? writeStream.substring(0, 7) : writeStream;
                                writer.write(temp);
                            } else {
                                writeStream = Double.toString(help);
                                writeStream = df.format(help);
                                temp = (writeStream = writeStream.replace(',', '.')).length() > 8 ? writeStream.substring(0, 8) : writeStream;
                                writer.write(temp);
                            }
                        } else {
                            help = geom.getVertex(elem.getEntry(k)).getEntry(j);
                            double d = help = Math.abs(help) >= 0.0 && Math.abs(help) < 1.0E-5 ? 0.0 : help;
                            if (help >= 0.0) {
                                writeStream = " " + Double.toString(help);
                                writeStream = df.format(help);
                                writeStream = writeStream.replace(',', '.');
                                temp = (writeStream = " " + writeStream).length() > 8 ? writeStream.substring(0, 8) : writeStream;
                                writer.write(temp);
                            } else {
                                writeStream = " " + Double.toString(help);
                                writeStream = df.format(help);
                                writeStream = writeStream.replace(',', '.');
                                temp = (writeStream = " " + writeStream).length() > 9 ? writeStream.substring(0, 9) : writeStream;
                                writer.write(temp);
                            }
                        }
                        ++j;
                    }
                    writeStream = "  ";
                    writer.write(writeStream);
                    ++k;
                }
                writeStream = "0x" + Integer.toHexString(bGlobalColor ? c.getRGB() : colors[i].getRGB()).toUpperCase().substring(2);
                writer.write(String.valueOf(writeStream) + "\r\n");
                ++i;
            }
        }
        catch (IOException ioe) {
            PsDebug.warning((String)"Error during parsing of file. Loading aborted.");
            return false;
        }
        return true;
    }

    public boolean write(Writer writer, PgJvxSrc[] geomArr, PdVector[] ex, PdVector[] pcVal, PdVector[][] pcDir) throws IOException {
        if (geomArr == null || geomArr.length == 0 || geomArr[0] == null) {
            PsDebug.warning((String)"missing geometry");
            return false;
        }
        return this.write(writer, geomArr);
    }
}

