/*
 * Decompiled with CFR 0.152.
 */
package dev.loader;

import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.Date;
import jv.geom.PgPolygon;
import jv.geom.PgPolygonSet;
import jv.loader.PgAbstractLoader;
import jv.number.PuDouble;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.project.PgJvxSrc;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PgPolyLoader
extends PgAbstractLoader {
    public PgJvxSrc[] read(BufferedReader in) {
        if (in == null) {
            PsDebug.warning((String)"missing reader");
            return null;
        }
        PgJvxSrc geom = new PgJvxSrc();
        if (!this.parse(in, geom)) {
            PsDebug.warning((String)"error during parsing of reader");
            return null;
        }
        geom.setType(31);
        geom.showVertices(true);
        geom.setGlobalVertexSize(1.0);
        geom.showPolygons(true);
        this.m_geomArr = new PgJvxSrc[]{geom};
        return this.m_geomArr;
    }

    protected boolean parse(BufferedReader bufReader, PgJvxSrc geom) {
        StreamTokenizer st = new StreamTokenizer(bufReader);
        st.ordinaryChars(47, 47);
        st.ordinaryChars(95, 95);
        st.eolIsSignificant(true);
        st.ordinaryChar(45);
        st.ordinaryChar(43);
        st.ordinaryChar(46);
        st.ordinaryChars(48, 48);
        st.ordinaryChars(49, 57);
        st.wordChars(94, 94);
        st.wordChars(38, 38);
        st.wordChars(36, 36);
        st.wordChars(40, 40);
        st.wordChars(41, 41);
        st.wordChars(126, 126);
        st.wordChars(64, 64);
        st.wordChars(45, 45);
        st.wordChars(43, 43);
        st.wordChars(42, 42);
        st.wordChars(48, 48);
        st.wordChars(49, 57);
        st.wordChars(46, 46);
        st.wordChars(44, 44);
        st.wordChars(59, 59);
        st.wordChars(95, 95);
        st.wordChars(58, 58);
        st.wordChars(95, 95);
        st.commentChar(35);
        try {
            do {
                st.nextToken();
            } while (st.ttype == 10);
            int nov = Integer.parseInt(st.sval);
            st.nextToken();
            PdVector[] vertex = new PdVector[nov];
            int dim = 0;
            int i = 0;
            while (i < nov) {
                vertex[i] = new PdVector(dim);
                int j = 0;
                do {
                    st.nextToken();
                    if (st.ttype != 10 && st.ttype != -1) {
                        double val = PuDouble.parseDouble((String)st.sval);
                        vertex[i].setEntry(j, val);
                    }
                    ++j;
                } while (st.ttype != 10 && st.ttype != -1);
                if (i == 0) {
                    dim = vertex[i].getSize();
                }
                ++i;
            }
            if (nov > 0) {
                geom.setDimOfVertices(vertex[0].getSize());
                geom.setNumVertices(nov);
                geom.setVertices(vertex);
            }
        }
        catch (IOException e) {
            PsDebug.warning((String)("Exception thrown = " + e.toString() + "\n\tparsing broke abnormally in line=" + st.lineno() + ",\n\treading st.sval=" + st.sval + ",\n\tst.ttype=" + st.ttype));
            return false;
        }
        return true;
    }

    public boolean write(Writer writer, PgJvxSrc[] geomArr) throws IOException {
        if (geomArr == null || geomArr.length == 0 || geomArr[0] == null) {
            PsDebug.warning((String)"missing geometry");
            return false;
        }
        PgJvxSrc geom = geomArr[0];
        writer.write("# Produced with JavaView v." + PsConfig.getVersion() + "\n");
        writer.write("# JavaView is " + PsConfig.getCopyright() + ", " + PsConfig.getHomepage() + "\n");
        writer.write("# by " + PsConfig.getAuthors() + "\n");
        writer.write("#     File Format = Poly (Tebis internal)\n");
        writer.write("#     Geometry    = " + geom.getName() + "\n");
        writer.write("#     Date        = " + new Date().toString() + "\n#\n");
        int numOfVertices = geom.getNumVertices();
        writer.write("#     Number of Vertices    = " + numOfVertices + "\n");
        writer.write("#\n# End of Header\n");
        PdVector[] vertex = geom.getVertices();
        writer.write(String.valueOf(String.valueOf(numOfVertices)) + "\n");
        int i = 0;
        while (i < numOfVertices) {
            writer.write(String.valueOf(PuString.toString((double[])vertex[i].m_data)) + "\n");
            ++i;
        }
        return true;
    }

    public static boolean writePgPolygonSetAsMultipleFiles(PgPolygonSet polyset, String baseFileName) {
        int np;
        int tmp = np = polyset.getNumPolygons();
        int ndigits = 0;
        while (tmp > 0) {
            tmp /= 10;
            ++ndigits;
        }
        PgPolyLoader loader = new PgPolyLoader();
        NumberFormat format = NumberFormat.getInstance();
        format.setMinimumIntegerDigits(ndigits);
        int dim = polyset.getDimOfVertices();
        PgPolygon poly = new PgPolygon(dim);
        PgJvxSrc[] jvx = new PgJvxSrc[1];
        PdVector[] vert = polyset.getVertices();
        int i = 0;
        while (i < np) {
            PiVector ipoly = polyset.getPolygon(i);
            int polysize = ipoly.getSize();
            poly.setNumVertices(polysize);
            PdVector[] polyvert = poly.getVertices();
            int j = 0;
            while (j < polysize) {
                polyvert[j].copyArray(vert[ipoly.m_data[j]]);
                ++j;
            }
            poly.setClosed(polyset.isClosed(i));
            jvx[0] = poly.getJvx();
            String filename = String.valueOf(baseFileName) + format.format(i) + ".poly";
            try {
                FileWriter writer = new FileWriter(filename);
                loader.write(writer, jvx);
                writer.close();
            }
            catch (IOException e) {
                PsDebug.warning((String)("could not write to file " + filename));
                return false;
            }
            ++i;
        }
        return true;
    }
}

