/*
 * Decompiled with CFR 0.152.
 */
package dev.loader;

import devCompress.PgJvzCode;
import devCompress.PuJvzDecoder;
import devCompress.PuJvzEncoder;
import java.awt.Color;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import jv.loader.PgAbstractLoader;
import jv.loader.PsXmlLoader;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.project.PgJvxSrc;
import jv.rsrc.PsAuthorInfo;
import jv.rsrc.PsGeometryInfo;
import jv.rsrc.PsXmlNode;
import jv.rsrc.PsXmlSrc;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PgJvzLoader
extends PgAbstractLoader {
    private int m_jvVersion = Integer.MAX_VALUE;
    private static final int UNKNOWN = -1;
    private static final int TRUE = 1;
    private static final int FALSE = 0;
    private static final char[] BASE64TABLE = new char[]{'+', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};

    public static PgJvxSrc[] read(String fileName) {
        BufferedReader in = PsUtil.open((String)fileName);
        if (in == null) {
            PsDebug.warning((String)("could not open = " + fileName));
            return null;
        }
        PgJvzLoader loader = new PgJvzLoader();
        PgJvxSrc[] geomArr = loader.read(in);
        try {
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        loader = null;
        if (geomArr != null) {
            int i = 0;
            while (i < geomArr.length) {
                String name;
                if (geomArr[i] != null && ((name = geomArr[i].getName()) == null || name.toLowerCase().startsWith("object_"))) {
                    String fileBase = PsUtil.getFileBaseName((String)fileName);
                    if (i == 0) {
                        geomArr[i].setName(fileBase);
                    } else {
                        geomArr[i].setName(String.valueOf(fileBase) + "[" + i + "]");
                    }
                }
                ++i;
            }
        }
        return geomArr;
    }

    public PgJvxSrc[] read(BufferedReader in) {
        if (in == null) {
            PsDebug.warning((String)"missing buffered reader");
            return null;
        }
        PsXmlSrc src = PsXmlLoader.read((BufferedReader)in);
        if (src == null) {
            PsDebug.warning((String)"failed to parse XML stream");
            return null;
        }
        PgJvxSrc[] geom = this.parseRsrcTree(src);
        if (geom == null) {
            PsDebug.warning((String)"failed to interpret JVX tree");
            return null;
        }
        return geom;
    }

    public boolean write(Writer writer, PgJvxSrc[] geom) {
        if (geom == null) {
            PsDebug.warning((String)"missing geometries.");
            return false;
        }
        PsXmlSrc src = this.fillRsrcTree(null, geom);
        if (src == null) {
            PsDebug.warning((String)"failed to generate XML tree");
            return false;
        }
        try {
            return PsXmlSrc.write((Writer)writer, (PsXmlSrc)src);
        }
        catch (IOException ex) {
            PsDebug.warning((String)"failed to write XML tree", (Object)ex);
            return false;
        }
    }

    public String write(PgJvxSrc[] geom) {
        if (geom == null || geom.length == 0) {
            PsDebug.warning((String)"missing geometries.");
            return null;
        }
        PsXmlSrc src = this.fillRsrcTree(null, geom);
        if (src == null) {
            PsDebug.warning((String)"failed to generate XML tree");
            return null;
        }
        return PsXmlSrc.write((PsXmlSrc)src);
    }

    /*
     * Unable to fully structure code
     */
    protected PgJvxSrc[] parseRsrcTree(PsXmlSrc src) {
        block320: {
            block311: {
                root = src.getRootNode();
                if (root == null) {
                    PsDebug.warning((String)"missing root node.");
                    return null;
                }
                if (root.getType() == null || !root.getType().equalsIgnoreCase("jvz-model")) {
                    PsDebug.warning((String)"missing <jvz-model> element,\nthis is not a valid JavaView-Z geometry file.");
                    return null;
                }
                meta = PsXmlSrc.getRsrcNodes((PsXmlNode)root, (String)"meta");
                if (meta != null && meta.length > 0) {
                    i = 0;
                    while (i < meta.length) {
                        val = meta[i].getAttribute("generator");
                        if (val != null && (generator = val).startsWith("JavaView v.")) {
                            version = generator.substring(generator.indexOf(".") + 1);
                            ver = PuString.splitString((String)version, (char)'.');
                            if (ver != null && ver.length <= 3) {
                                k = 0;
                                while (k < ver.length) {
                                    if (k == 0) {
                                        this.m_jvVersion = 100000 * Integer.parseInt(ver[k]);
                                    } else if (k == 1) {
                                        this.m_jvVersion += 1000 * Integer.parseInt(ver[k]);
                                    } else if (k == 2) {
                                        try {
                                            this.m_jvVersion += Integer.parseInt(ver[k]);
                                        }
                                        catch (NumberFormatException var10_15) {
                                            // empty catch block
                                        }
                                    }
                                    ++k;
                                }
                            } else {
                                PsDebug.warning((String)("void JavaView version information in meta tag, generator = " + generator));
                            }
                        }
                        if ((val = meta[i].getAttribute("dtd")) != null && (ver = PuString.splitString((String)val, (char)'.')) != null && ver.length > 0) {
                            jvxDtdVersion = new int[ver.length];
                            k = 0;
                            while (k < ver.length) {
                                jvxDtdVersion[k] = Integer.parseInt(ver[k]);
                                ++k;
                            }
                            dtdVer = PsConfig.getVersion((int)11);
                            k = 0;
                            while (k < Math.min(1, ver.length)) {
                                if (dtdVer[k] != jvxDtdVersion[k]) {
                                    if (dtdVer[k] > jvxDtdVersion[k]) break;
                                    PsDebug.message((String)("Parsing a JVX file with jvx.dtd version=" + val + " which is newer than\n" + "\tversion=" + dtdVer[0] + "." + dtdVer[1] + "." + dtdVer[2] + " implemented by the loader of this JavaView program." + "\n\tMight need to upgrade JavaView."), (boolean)false);
                                    break;
                                }
                                ++k;
                            }
                        }
                        ++i;
                    }
                }
                strVersion = null;
                strVersionType = null;
                version = PsXmlSrc.getRsrcNode((PsXmlNode)root, (String)"version");
                if (version == null) {
                    strVersion = "0.0";
                    strVersionType = "dump";
                } else {
                    strVersion = version.getContent();
                    strVersionType = version.getAttribute("type");
                }
                strTitle = PsXmlSrc.getRsrc((PsXmlNode)root, (String)"title");
                m_geom = null;
                attr = new String[]{"tag", "name", "url", "detail"};
                geometries = PsXmlSrc.getRsrcNode((PsXmlNode)root, (String)"geometries");
                if (geometries == null) break block311;
                geometry = PsXmlSrc.getRsrcNodes((PsXmlNode)geometries, (String)"geometry");
                if (geometry == null || geometry.length == 0) {
                    return null;
                }
                m_geom = new PgJvxSrc[geometry.length];
                i = 0;
                while (i < m_geom.length) {
                    block312: {
                        block313: {
                            block317: {
                                block319: {
                                    block318: {
                                        block314: {
                                            block316: {
                                                block315: {
                                                    geom = new PgJvzCode();
                                                    m_geom[i] = geom;
                                                    geom.setVersion(strVersion);
                                                    geom.setVersionType(strVersionType);
                                                    geom.setTitle(strTitle);
                                                    geomName = geometry[i].getAttribute("name");
                                                    if (geomName != null) {
                                                        geom.setName(geomName);
                                                    }
                                                    geom.setVisible(PgJvzLoader.parseVisibility(geometry[i].getAttribute("visible")) != 0);
                                                    labelAtt = null;
                                                    if (geometry[i].hasChild("labelAtt")) {
                                                        labelAttNode = geometry[i].getChild("labelAtt");
                                                        labelAtt = this.parseLabelAtt(labelAttNode);
                                                        if (labelAtt != null) {
                                                            geom.setLabelAttribute(5, labelAtt);
                                                            geom.showName(labelAtt.getEntry(5) == 1);
                                                            fontName = labelAttNode.getAttribute("name");
                                                            if (fontName != null) {
                                                                geom.setLabelFont(5, fontName);
                                                                geom.setLabelSize(5, labelAtt.getEntry(6));
                                                                geom.setLabelStyle(5, labelAtt.getEntry(7));
                                                            }
                                                        }
                                                        if (labelAttNode.hasChild("color")) {
                                                            colLabel = PsXmlLoader.parseColorRGB((PsXmlNode)labelAttNode, (String)"color");
                                                            geom.setLabelColor(5, colLabel);
                                                        }
                                                    }
                                                    if ((material = geometry[i].getChild("material")) != null) {
                                                        shading = material.getAttribute("shading");
                                                        if (shading != null && shading.equalsIgnoreCase("gouraud")) {
                                                            geom.showSmoothLighting(true);
                                                        } else {
                                                            geom.showSmoothLighting(false);
                                                        }
                                                        if (material.hasChild("specular")) {
                                                            specular = PsXmlLoader.parseColorRGB((PsXmlNode)material.getChild("specular"), (String)"color");
                                                            geom.setSpecularColor(specular);
                                                        }
                                                        if ((transparency = material.getChild("transparency")) != null) {
                                                            tp = PsXmlSrc.getRsrcAsDouble((PsXmlNode)material, (String)"transparency");
                                                            geom.setTransparency(tp);
                                                            vis = PgJvzLoader.parseVisibility(transparency.getAttribute("visible"));
                                                            if (this.m_jvVersion < 280000 && vis != 0) {
                                                                geom.showTransparency(true);
                                                            } else {
                                                                geom.showTransparency(vis == 1);
                                                            }
                                                        }
                                                    }
                                                    c = null;
                                                    d = 0.0;
                                                    pointSet = PsXmlSrc.getRsrcNode((PsXmlNode)geometry[i], (String)"pointSet");
                                                    bCompressedSurface = false;
                                                    if (pointSet != null) {
                                                        dimStr = pointSet.getAttribute("dim");
                                                        if (dimStr == null) {
                                                            PsDebug.warning((String)("missing dimension of geometry[" + i + "]"));
                                                            return null;
                                                        }
                                                        geom.setDimOfVertices(Integer.parseInt(dimStr));
                                                        geom.showVertices(PgJvzLoader.parseVisibility(pointSet.getAttribute("point")) != 0);
                                                        geom.showVertexColors(PgJvzLoader.parseVisibility(pointSet.getAttribute("color")) == 1);
                                                        geom.showVertexNormals(PgJvzLoader.parseVisibility(pointSet.getAttribute("normal")) == 1);
                                                        geom.showVertexNormalArrow(PgJvzLoader.parseVisibility(pointSet.getAttribute("normalArrow")) == 1);
                                                        geom.showVertexSizes(PgJvzLoader.parseVisibility(pointSet.getAttribute("thicknesses")) == 1);
                                                        geom.showTaggedVertices(PgJvzLoader.parseVisibility(pointSet.getAttribute("pointMark")) != 0);
                                                        geom.showVertexOutline(PgJvzLoader.parseVisibility(pointSet.getAttribute("pointOutline")) != 0);
                                                        geom.setType(30);
                                                        points = PsXmlSrc.getRsrcNode((PsXmlNode)pointSet, (String)"points");
                                                        if (points != null) {
                                                            if (points.hasChild("vertexData")) {
                                                                bCompressedSurface = true;
                                                            }
                                                            if (bCompressedSurface) {
                                                                geom.setNumStoredVertices(Integer.parseInt(points.getAttribute("num")));
                                                                bndBox = PsXmlSrc.getRsrcNode((PsXmlNode)points, (String)"bndBox");
                                                                geom.setBndBox(PsXmlLoader.parseDoubleList((PsXmlNode)bndBox, (String)"p", null));
                                                                geom.setAxisResolution(PsXmlLoader.parseIntegerList((PsXmlNode)points, (String)"resolution", null)[0].getEntries());
                                                                geom.setResizeFactor(PsXmlSrc.getRsrcAsDouble((PsXmlNode)points, (String)"resize"));
                                                                geom.setVertexDataCode(PgJvzLoader.stringToBytes(PsXmlSrc.getRsrc((PsXmlNode)points, (String)"vertexData")));
                                                                de = PsXmlSrc.getRsrcNode((PsXmlNode)points, (String)"discretizationError");
                                                                if (de != null) {
                                                                    geom.setDiscrErrorCode(PgJvzLoader.stringToBytes(de.getContent()));
                                                                }
                                                                if ((pi = PsXmlSrc.getRsrcNode((PsXmlNode)points, (String)"pointIndex")) != null) {
                                                                    geom.setVertexIndexCode(PgJvzLoader.stringToBytes(pi.getContent()));
                                                                }
                                                                if ((locInd = PsXmlSrc.getRsrcNode((PsXmlNode)points, (String)"indexOfMin")) != null) {
                                                                    geom.setLocalIndexCode(PgJvzLoader.stringToBytes(locInd.getContent()));
                                                                }
                                                            } else {
                                                                vertex = PsXmlLoader.parseDoubleList((PsXmlNode)points, (String)"p", (String[])attr);
                                                                if (vertex != null) {
                                                                    geom.setDimOfVertices(vertex[0].getSize());
                                                                    geom.setNumVertices(vertex.length);
                                                                    geom.setVertices(vertex);
                                                                } else {
                                                                    fun = PgJvzLoader.parseFunList(points, "pf", attr);
                                                                    if (fun != null) {
                                                                        geom.setDimOfVertices(fun[0].length);
                                                                        geom.setNumVertices(fun.length);
                                                                        geom.setVertexFunctions(fun);
                                                                    }
                                                                }
                                                            }
                                                            if (points.hasChild("thickness")) {
                                                                d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)points, (String)"thickness");
                                                                geom.setGlobalVertexSize(d);
                                                            }
                                                            if ((c = PsXmlLoader.parseColorRGB((PsXmlNode)points, (String)"color")) != null) {
                                                                geom.setGlobalVertexColor(c);
                                                            }
                                                            if ((c = PsXmlLoader.parseColorRGB((PsXmlNode)points, (String)"colorTag")) != null) {
                                                                geom.setGlobalVertexTagColor(c);
                                                            }
                                                            if (points.hasChild("labelAtt")) {
                                                                labelAttNode = points.getChild("labelAtt");
                                                                v0 = bAuto = PgJvzLoader.parseVisibility(labelAttNode.getAttribute("auto")) != 0;
                                                                if (!bAuto) {
                                                                    geom.setEnabledIndexLabels(false);
                                                                }
                                                                if ((labelAtt = this.parseLabelAtt(labelAttNode)) != null) {
                                                                    geom.setLabelAttribute(0, labelAtt);
                                                                    geom.showVertexLabels(labelAtt.getEntry(5) == 1);
                                                                    fontName = labelAttNode.getAttribute("name");
                                                                    if (fontName != null) {
                                                                        geom.setLabelFont(0, fontName);
                                                                        geom.setLabelSize(0, labelAtt.getEntry(6));
                                                                        geom.setLabelStyle(0, labelAtt.getEntry(7));
                                                                    }
                                                                }
                                                                if (labelAttNode.hasChild("color")) {
                                                                    colLabel = PsXmlLoader.parseColorRGB((PsXmlNode)labelAttNode, (String)"color");
                                                                    geom.setLabelColor(0, colLabel);
                                                                }
                                                            }
                                                        }
                                                        if ((colors = PsXmlSrc.getRsrcNode((PsXmlNode)pointSet, (String)"colors")) != null) {
                                                            if (bCompressedSurface) {
                                                                geom.setVertexColorCode(PgJvzLoader.stringToBytes(PsXmlSrc.getRsrc((PsXmlNode)colors, (String)"colorData")));
                                                            } else {
                                                                cList = PsXmlLoader.parseColorList((PsXmlNode)colors, (String)"c");
                                                                if (cList != null) {
                                                                    geom.setVertexColors(cList);
                                                                }
                                                            }
                                                        }
                                                        if ((normals = PsXmlSrc.getRsrcNode((PsXmlNode)pointSet, (String)"normals")) != null) {
                                                            if (bCompressedSurface) {
                                                                geom.setVertexNormalCode(PgJvzLoader.stringToBytes(PsXmlSrc.getRsrc((PsXmlNode)normals, (String)"nz")));
                                                            } else {
                                                                dList = PsXmlLoader.parseDoubleList((PsXmlNode)normals, (String)"n", null);
                                                                if (dList != null) {
                                                                    geom.setVertexNormals(dList);
                                                                }
                                                            }
                                                            if (normals.hasChild("thickness")) {
                                                                d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)normals, (String)"thickness");
                                                                geom.setGlobalVertexNormalSize(d);
                                                            }
                                                            if (normals.hasChild("length")) {
                                                                d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)normals, (String)"length");
                                                                geom.setGlobalVertexNormalLength(d);
                                                            }
                                                            if ((c = PsXmlLoader.parseColorRGB((PsXmlNode)normals, (String)"color")) != null) {
                                                                geom.setGlobalVertexNormalColor(c);
                                                            }
                                                        }
                                                        if ((textures = PsXmlSrc.getRsrcNode((PsXmlNode)pointSet, (String)"textures")) != null) {
                                                            textureBlend = textures.getAttribute("blend");
                                                            if (textureBlend != null) {
                                                                if (textureBlend.equals("replace")) {
                                                                    geom.setBlendingMode(0);
                                                                } else if (textureBlend.equals("material")) {
                                                                    geom.setBlendingMode(1);
                                                                } else if (textureBlend.equals("alpha")) {
                                                                    geom.setBlendingMode(2);
                                                                } else {
                                                                    PsDebug.warning((String)("Unknown texture attribute: blend = " + textureBlend));
                                                                }
                                                            } else {
                                                                geom.setBlendingMode(0);
                                                            }
                                                            textureFilter = textures.getAttribute("filter");
                                                            if (textureFilter != null) {
                                                                if (textureFilter.equals("direct")) {
                                                                    geom.setFilterType(0);
                                                                } else if (textureFilter.equals("linear")) {
                                                                    geom.setFilterType(1);
                                                                } else if (textureFilter.equals("quadratic")) {
                                                                    geom.setFilterType(2);
                                                                } else {
                                                                    PsDebug.warning((String)("Unknown texture attribute: filter = " + textureFilter));
                                                                }
                                                            } else {
                                                                geom.setFilterType(0);
                                                            }
                                                            textureSide = textures.getAttribute("side");
                                                            if (textureSide != null) {
                                                                if (textureSide.equals("both")) {
                                                                    geom.setTextureSide(3);
                                                                } else if (textureSide.equals("front")) {
                                                                    geom.setTextureSide(1);
                                                                } else if (textureSide.equals("back")) {
                                                                    geom.setTextureSide(2);
                                                                } else {
                                                                    PsDebug.warning((String)("Unknown texture attribute: side = " + textureSide));
                                                                }
                                                            } else {
                                                                geom.setTextureSide(3);
                                                            }
                                                            if (bCompressedSurface) {
                                                                geom.setVertexTextureCode(PgJvzLoader.stringToBytes(PsXmlSrc.getRsrc((PsXmlNode)textures, (String)"t")));
                                                            } else {
                                                                dList = PsXmlLoader.parseDoubleList((PsXmlNode)textures, (String)"t", null);
                                                                if (dList != null) {
                                                                    geom.setVertexTextures(dList);
                                                                }
                                                            }
                                                            image = textures.getChild("image");
                                                            if (image != null) {
                                                                imgUrl = PsXmlSrc.getRsrcNode((PsXmlNode)image, (String)"url");
                                                                if (imgUrl != null) {
                                                                    s = imgUrl.getContent();
                                                                } else {
                                                                    s = image.getContent();
                                                                    if (s != null) {
                                                                        PsDebug.warning((String)"Found <image> element not conforming to jvx.dtd, bug from previous JavaView.\n\tSolution: save JVX scene again with JavaView v.2.50 or later.");
                                                                    }
                                                                }
                                                                repeat = image.getAttribute("repeat");
                                                                if (repeat != null && !"no".equals(repeat)) {
                                                                    PsDebug.warning((String)"repeat mode in images not supported yet.");
                                                                }
                                                                if (s != null) {
                                                                    geom.setTextureImageName(s);
                                                                }
                                                            }
                                                            if ((imageCoords = textures.getChild("imageCoords")) != null && (imgVert = PsXmlLoader.parseDoubleList((PsXmlNode)imageCoords, (String)"p", null)) != null) {
                                                                geom.setTextureImageBnd(imgVert);
                                                            }
                                                            if ((texTiling = textures.getChild("tiling")) != null) {
                                                                tiling = PsXmlLoader.parsePiVector((PsXmlNode)texTiling, null);
                                                                if (tiling != null && tiling.getSize() == 2) {
                                                                    geom.setTextureTiling(new Dimension(tiling.getEntry(0), tiling.getEntry(1)));
                                                                } else {
                                                                    PsDebug.warning((String)"Found texture <tiling> element with missing or invalid data.");
                                                                }
                                                            }
                                                        }
                                                        if ((thicknesses = PsXmlSrc.getRsrcNode((PsXmlNode)pointSet, (String)"thicknesses")) != null && (dList = PsXmlLoader.parseDoubleList((PsXmlNode)thicknesses, (String)"th", null)) != null) {
                                                            size = new PdVector(dList.length);
                                                            k = 0;
                                                            while (k < dList.length) {
                                                                size.setEntry(k, dList[k].getEntry(0));
                                                                ++k;
                                                            }
                                                            geom.setVertexSizes(size);
                                                        }
                                                    }
                                                    if ((polygon = PsXmlSrc.getRsrcNode((PsXmlNode)geometry[i], (String)"polygon")) != null) {
                                                        geom.showPolygonStartArrow(PgJvzLoader.parseVisibility(polygon.getAttribute("arrowStart")) == 1);
                                                        geom.showPolygonEndArrow(PgJvzLoader.parseVisibility(polygon.getAttribute("arrow")) == 1);
                                                        geom.showPolygons(PgJvzLoader.parseVisibility(polygon.getAttribute("edge")) != 0);
                                                        bShowColors = PgJvzLoader.parseVisibility(polygon.getAttribute("color")) == 1;
                                                        v1 = bInduceColors = PgJvzLoader.parseVisibility(polygon.getAttribute("colorFromPoints")) == 1;
                                                        if (bInduceColors && geom.getVertexColors() == null) {
                                                            PsDebug.warning((String)"Missing vertex colors, found <colorFromPoints> attribute but missing <color> section of pointSet.\n");
                                                            bInduceColors = false;
                                                        }
                                                        geom.showPolygonColors(bShowColors);
                                                        geom.showElementColorFromVertices(bInduceColors);
                                                        geom.showPolygonNormals(PgJvzLoader.parseVisibility(polygon.getAttribute("normal")) == 1);
                                                        geom.showPolygonNormalArrow(PgJvzLoader.parseVisibility(polygon.getAttribute("normalArrow")) == 1);
                                                        geom.showPolygonSizes(PgJvzLoader.parseVisibility(polygon.getAttribute("thicknesses")) == 1);
                                                        geom.showSmoothElementColors(PgJvzLoader.parseVisibility(polygon.getAttribute("colorSmooth")) == 1);
                                                        geom.showTaggedPolygons(PgJvzLoader.parseVisibility(polygon.getAttribute("edgeMark")) != 0);
                                                        geom.setType(31);
                                                        edges = PsXmlSrc.getRsrcNode((PsXmlNode)polygon, (String)"edges");
                                                        if (edges != null) {
                                                            e = PsXmlLoader.parseIntegerList((PsXmlNode)edges, (String)"e", (String[])attr);
                                                            if (e != null) {
                                                                geom.setDimOfPolygons(-1);
                                                                geom.setNumPolygons(e.length);
                                                                geom.setPolygons(e);
                                                            }
                                                            if (edges.hasChild("thickness")) {
                                                                d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)edges, (String)"thickness");
                                                                geom.setGlobalPolygonSize(d);
                                                            }
                                                            if ((c = PsXmlLoader.parseColorRGB((PsXmlNode)edges, (String)"color")) != null) {
                                                                geom.setGlobalPolygonColor(c);
                                                            }
                                                            if ((c = PsXmlLoader.parseColorRGB((PsXmlNode)edges, (String)"colorTag")) != null) {
                                                                geom.setGlobalPolygonTagColor(c);
                                                            }
                                                            if (edges.hasChild("labelAtt")) {
                                                                labelAttNode = edges.getChild("labelAtt");
                                                                labelAtt = this.parseLabelAtt(labelAttNode);
                                                                if (labelAtt != null) {
                                                                    geom.setLabelAttribute(2, labelAtt);
                                                                    geom.showPolygonLabels(labelAtt.getEntry(5) == 1);
                                                                    fontName = labelAttNode.getAttribute("name");
                                                                    if (fontName != null) {
                                                                        geom.setLabelFont(2, fontName);
                                                                        geom.setLabelSize(2, labelAtt.getEntry(6));
                                                                        geom.setLabelStyle(2, labelAtt.getEntry(7));
                                                                    }
                                                                }
                                                                if (labelAttNode.hasChild("color")) {
                                                                    colLabel = PsXmlLoader.parseColorRGB((PsXmlNode)labelAttNode, (String)"color");
                                                                    geom.setLabelColor(2, colLabel);
                                                                }
                                                            }
                                                        }
                                                        if ((colors = PsXmlSrc.getRsrcNode((PsXmlNode)polygon, (String)"colors")) != null) {
                                                            cList = PsXmlLoader.parseColorList((PsXmlNode)colors, (String)"c");
                                                            if (cList != null) {
                                                                geom.setPolygonColors(cList);
                                                            }
                                                        } else if (bShowColors && !bInduceColors) {
                                                            PsDebug.warning((String)"Missing individual colors, found <color=show> attribute but neither individual edge nor vertex colors.\n");
                                                            bInduceColors = false;
                                                        }
                                                        if ((normals = PsXmlSrc.getRsrcNode((PsXmlNode)polygon, (String)"normals")) != null) {
                                                            dList = PsXmlLoader.parseDoubleList((PsXmlNode)normals, (String)"n", null);
                                                            if (dList != null) {
                                                                geom.setPolygonNormals(dList);
                                                            }
                                                            if (normals.hasChild("thickness")) {
                                                                d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)normals, (String)"thickness");
                                                                geom.setGlobalPolygonNormalSize(d);
                                                            }
                                                            if (normals.hasChild("length")) {
                                                                d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)normals, (String)"length");
                                                                geom.setGlobalPolygonNormalLength(d);
                                                            }
                                                            if ((c = PsXmlLoader.parseColorRGB((PsXmlNode)normals, (String)"color")) != null) {
                                                                geom.setGlobalPolygonNormalColor(c);
                                                            }
                                                        }
                                                        if ((thicknesses = PsXmlSrc.getRsrcNode((PsXmlNode)polygon, (String)"thicknesses")) != null && (dList = PsXmlLoader.parseDoubleList((PsXmlNode)thicknesses, (String)"th", null)) != null) {
                                                            size = new PdVector(dList.length);
                                                            k = 0;
                                                            while (k < dList.length) {
                                                                size.setEntry(k, dList[k].getEntry(0));
                                                                ++k;
                                                            }
                                                            geom.setPolygonSizes(size);
                                                        }
                                                    }
                                                    if ((lineSet = PsXmlSrc.getRsrcNode((PsXmlNode)geometry[i], (String)"lineSet")) != null) {
                                                        geom.showPolygonStartArrow(PgJvzLoader.parseVisibility(lineSet.getAttribute("arrowStart")) == 1);
                                                        geom.showPolygonEndArrow(PgJvzLoader.parseVisibility(lineSet.getAttribute("arrow")) == 1);
                                                        geom.showPolygons(PgJvzLoader.parseVisibility(lineSet.getAttribute("line")) != 0);
                                                        bShowColors = PgJvzLoader.parseVisibility(lineSet.getAttribute("color")) == 1;
                                                        v2 = bInduceColors = PgJvzLoader.parseVisibility(lineSet.getAttribute("colorFromPoints")) == 1;
                                                        if (bInduceColors && geom.getVertexColors() == null) {
                                                            PsDebug.warning((String)"Missing vertex colors, found <colorFromPoints> attribute but missing <color> section of pointSet.\n");
                                                            bInduceColors = false;
                                                        }
                                                        geom.showPolygonColors(bShowColors);
                                                        geom.showElementColorFromVertices(bInduceColors);
                                                        if (!bShowColors && bInduceColors && PgJvzLoader.parseVisibility(lineSet.getAttribute("color")) == -1 && this.m_jvVersion < 361000) {
                                                            PsDebug.warning((String)"Found <colorFromPoints> attribute but missing <color> attribute.\n\tSolution: save JVX scene again with JavaView v.3.61 or later.");
                                                            geom.showPolygonColors(true);
                                                        }
                                                        geom.showPolygonNormals(PgJvzLoader.parseVisibility(lineSet.getAttribute("normal")) == 1);
                                                        geom.showPolygonNormalArrow(PgJvzLoader.parseVisibility(lineSet.getAttribute("normalArrow")) == 1);
                                                        geom.showPolygonSizes(PgJvzLoader.parseVisibility(lineSet.getAttribute("thicknesses")) == 1);
                                                        geom.showSmoothElementColors(PgJvzLoader.parseVisibility(lineSet.getAttribute("colorSmooth")) == 1);
                                                        geom.showTaggedPolygons(PgJvzLoader.parseVisibility(lineSet.getAttribute("lineMark")) != 0);
                                                        geom.setType(32);
                                                        lines = PsXmlSrc.getRsrcNode((PsXmlNode)lineSet, (String)"lines");
                                                        if (lines != null) {
                                                            l = PsXmlLoader.parseIntegerList((PsXmlNode)lines, (String)"l", (String[])attr);
                                                            if (l != null) {
                                                                geom.setDimOfPolygons(-1);
                                                                geom.setNumPolygons(l.length);
                                                                geom.setPolygons(l);
                                                            }
                                                            if (lines.hasChild("thickness")) {
                                                                d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)lines, (String)"thickness");
                                                                geom.setGlobalPolygonSize(d);
                                                            }
                                                            if ((c = PsXmlLoader.parseColorRGB((PsXmlNode)lines, (String)"color")) != null) {
                                                                geom.setGlobalPolygonColor(c);
                                                            }
                                                            if ((c = PsXmlLoader.parseColorRGB((PsXmlNode)lines, (String)"colorTag")) != null) {
                                                                geom.setGlobalPolygonTagColor(c);
                                                            }
                                                            if (lines.hasChild("labelAtt")) {
                                                                labelAttNode = lines.getChild("labelAtt");
                                                                labelAtt = this.parseLabelAtt(labelAttNode);
                                                                if (labelAtt != null) {
                                                                    geom.setLabelAttribute(2, labelAtt);
                                                                    geom.showPolygonLabels(labelAtt.getEntry(5) == 1);
                                                                    fontName = labelAttNode.getAttribute("name");
                                                                    if (fontName != null) {
                                                                        geom.setLabelFont(2, fontName);
                                                                        geom.setLabelSize(2, labelAtt.getEntry(6));
                                                                        geom.setLabelStyle(2, labelAtt.getEntry(7));
                                                                    }
                                                                }
                                                                if (labelAttNode.hasChild("color")) {
                                                                    colLabel = PsXmlLoader.parseColorRGB((PsXmlNode)labelAttNode, (String)"color");
                                                                    geom.setLabelColor(2, colLabel);
                                                                }
                                                            }
                                                        }
                                                        if ((colors = PsXmlSrc.getRsrcNode((PsXmlNode)lineSet, (String)"colors")) != null) {
                                                            cList = PsXmlLoader.parseColorList((PsXmlNode)colors, (String)"c");
                                                            if (cList != null) {
                                                                geom.setPolygonColors(cList);
                                                            }
                                                        } else if (bShowColors && !bInduceColors) {
                                                            PsDebug.warning((String)"Missing individual colors, found <color=show> attribute but neither individual edge nor vertex colors.\n");
                                                            bInduceColors = false;
                                                        }
                                                        if ((normals = PsXmlSrc.getRsrcNode((PsXmlNode)lineSet, (String)"normals")) != null) {
                                                            dList = PsXmlLoader.parseDoubleList((PsXmlNode)normals, (String)"n", null);
                                                            if (dList != null) {
                                                                geom.setPolygonNormals(dList);
                                                            }
                                                            if (normals.hasChild("thickness")) {
                                                                d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)normals, (String)"thickness");
                                                                geom.setGlobalPolygonNormalSize(d);
                                                            }
                                                            if (normals.hasChild("length")) {
                                                                d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)normals, (String)"length");
                                                                geom.setGlobalPolygonNormalLength(d);
                                                            }
                                                            if ((c = PsXmlLoader.parseColorRGB((PsXmlNode)normals, (String)"color")) != null) {
                                                                geom.setGlobalPolygonNormalColor(c);
                                                            }
                                                        }
                                                        if ((thicknesses = PsXmlSrc.getRsrcNode((PsXmlNode)lineSet, (String)"thicknesses")) != null && (dList = PsXmlLoader.parseDoubleList((PsXmlNode)thicknesses, (String)"th", null)) != null) {
                                                            size = new PdVector(dList.length);
                                                            k = 0;
                                                            while (k < dList.length) {
                                                                size.setEntry(k, dList[k].getEntry(0));
                                                                ++k;
                                                            }
                                                            geom.setPolygonSizes(size);
                                                        }
                                                    }
                                                    if ((faceSet = PsXmlSrc.getRsrcNode((PsXmlNode)geometry[i], (String)"faceSet")) != null) {
                                                        geom.showElements(PgJvzLoader.parseVisibility(faceSet.getAttribute("face")) != 0);
                                                        geom.showEdges(PgJvzLoader.parseVisibility(faceSet.getAttribute("edge")) != 0);
                                                        geom.showElementNormals(PgJvzLoader.parseVisibility(faceSet.getAttribute("normal")) == 1);
                                                        geom.showElementNormalArrow(PgJvzLoader.parseVisibility(faceSet.getAttribute("normalArrow")) == 1);
                                                        bShowColors = PgJvzLoader.parseVisibility(faceSet.getAttribute("color")) == 1;
                                                        v3 = bInduceColors = PgJvzLoader.parseVisibility(faceSet.getAttribute("colorFromPoints")) == 1;
                                                        if (bInduceColors && (!bCompressedSurface && geom.getVertexColors() == null || bCompressedSurface && geom.getVertexColorCode() == null)) {
                                                            PsDebug.warning((String)"Missing vertex colors, found <colorFromPoints> attribute but missing <color> section of pointSet.\n");
                                                            bInduceColors = false;
                                                        }
                                                        geom.showElementColors(bShowColors);
                                                        geom.showElementColorFromVertices(bInduceColors);
                                                        if (!bShowColors && bInduceColors && PgJvzLoader.parseVisibility(faceSet.getAttribute("color")) == -1 && this.m_jvVersion < 361000) {
                                                            PsDebug.warning((String)"Found <colorFromPoints> attribute but missing <color> attribute.\n\tSolution: save JVX scene again with JavaView v.3.61 or later.");
                                                            geom.showElementColors(true);
                                                        }
                                                        geom.showElementBackColor(PgJvzLoader.parseVisibility(faceSet.getAttribute("colorBackGlobal")) == 1);
                                                        geom.showElementBackColors(PgJvzLoader.parseVisibility(faceSet.getAttribute("colorBackLocal")) == 1);
                                                        geom.showSmoothElementColors(PgJvzLoader.parseVisibility(faceSet.getAttribute("colorSmooth")) == 1);
                                                        geom.showEdgeColors(PgJvzLoader.parseVisibility(faceSet.getAttribute("colorEdge")) == 1);
                                                        geom.showEdgeColorFromElements(PgJvzLoader.parseVisibility(faceSet.getAttribute("colorEdgeInduced")) == 1);
                                                        bShowBackface = PgJvzLoader.parseVisibility(faceSet.getAttribute("backface")) != 0;
                                                        geom.showBackface(bShowBackface);
                                                        geom.showBoundaries(PgJvzLoader.parseVisibility(faceSet.getAttribute("boundary")) == 1);
                                                        geom.showSilhouette(PgJvzLoader.parseVisibility(faceSet.getAttribute("silhouette")) == 1);
                                                        geom.showTaggedElements(PgJvzLoader.parseVisibility(faceSet.getAttribute("faceMark")) != 0);
                                                        geom.setType(33);
                                                        faces = PsXmlSrc.getRsrcNode((PsXmlNode)faceSet, (String)"faces");
                                                        if (faces != null) {
                                                            if (bCompressedSurface) {
                                                                noe = faces.getAttribute("num");
                                                                if (noe != null && noe != "") {
                                                                    geom.setNumStoredElements(Integer.parseInt(noe));
                                                                }
                                                                contexts = PsXmlSrc.getRsrcNode((PsXmlNode)faces, (String)"contexts");
                                                                numThresholds = Integer.parseInt(contexts.getAttribute("num"));
                                                                geom.setNumContexts(numThresholds + 1);
                                                                if (numThresholds > 0) {
                                                                    geom.setContextThresholds(PsXmlLoader.parseIntegerList((PsXmlNode)faces, (String)"contexts", null)[0].getEntries());
                                                                } else {
                                                                    geom.setContextThresholds(new int[0]);
                                                                }
                                                                geom.setVertexSymbolCode(PgJvzLoader.stringToBytes(PsXmlSrc.getRsrc((PsXmlNode)faces, (String)"traverseData")));
                                                                geom.setSplitSymbolCode(PgJvzLoader.stringToBytes(PsXmlSrc.getRsrc((PsXmlNode)faces, (String)"splitData")));
                                                                geom.setElementSymbolCode(PgJvzLoader.stringToBytes(PsXmlSrc.getRsrc((PsXmlNode)faces, (String)"faceData")));
                                                                geom.setElementIndexCode(PgJvzLoader.stringToBytes(PsXmlSrc.getRsrc((PsXmlNode)faces, (String)"elementIndex")));
                                                            } else {
                                                                element = PsXmlLoader.parseIntegerList((PsXmlNode)faces, (String)"f", (String[])attr);
                                                                if (element != null) {
                                                                    geom.setDimOfElements(-1);
                                                                    geom.setNumElements(element.length);
                                                                    geom.setElements(element);
                                                                }
                                                            }
                                                            c = PsXmlLoader.parseColorRGB((PsXmlNode)faces, (String)"color");
                                                            if (c != null) {
                                                                geom.setGlobalElementColor(c);
                                                            }
                                                            if ((c = PsXmlLoader.parseColorRGB((PsXmlNode)faces, (String)"colorBack")) != null) {
                                                                geom.setGlobalElementBackColor(c);
                                                            }
                                                            if ((c = PsXmlLoader.parseColorRGB((PsXmlNode)faces, (String)"colorTag")) != null) {
                                                                geom.setGlobalElementTagColor(c);
                                                            }
                                                            if (faces.hasChild("creaseAngle")) {
                                                                creaseAngle = PsXmlSrc.getRsrcAsDouble((PsXmlNode)faces, (String)"creaseAngle");
                                                                geom.setCreaseAngle(creaseAngle);
                                                            }
                                                            if (faces.hasChild("labelAtt")) {
                                                                labelAttNode = faces.getChild("labelAtt");
                                                                labelAtt = this.parseLabelAtt(labelAttNode);
                                                                if (labelAtt != null) {
                                                                    geom.setLabelAttribute(3, labelAtt);
                                                                    geom.showElementLabels(labelAtt.getEntry(5) == 1);
                                                                    fontName = labelAttNode.getAttribute("name");
                                                                    if (fontName != null) {
                                                                        geom.setLabelFont(3, fontName);
                                                                        geom.setLabelSize(3, labelAtt.getEntry(6));
                                                                        geom.setLabelStyle(3, labelAtt.getEntry(7));
                                                                    }
                                                                }
                                                                if (labelAttNode.hasChild("color")) {
                                                                    colLabel = PsXmlLoader.parseColorRGB((PsXmlNode)labelAttNode, (String)"color");
                                                                    geom.setLabelColor(3, colLabel);
                                                                }
                                                            }
                                                        }
                                                        if ((neighbours = PsXmlSrc.getRsrcNode((PsXmlNode)faceSet, (String)"neighbours")) != null) {
                                                            neighbour = PsXmlLoader.parseIntegerList((PsXmlNode)neighbours, (String)"nb", null);
                                                            if (neighbour != null) {
                                                                geom.setNeighbours(neighbour);
                                                            } else {
                                                                this.m_bIsEnabledOptimization = PgJvzLoader.parseVisibility(neighbours.getAttribute("auto")) == 1;
                                                            }
                                                        } else if (!bCompressedSurface) {
                                                            this.m_bIsEnabledOptimization = true;
                                                            PsDebug.message((String)("JVX surface (name=" + geom.getName() + ") with no neighbour information found, identifying equal vertices."), (boolean)false);
                                                        }
                                                        edges = PsXmlSrc.getRsrcNode((PsXmlNode)faceSet, (String)"edges");
                                                        if (edges != null) {
                                                            iList = PsXmlLoader.parseIntegerList((PsXmlNode)edges, (String)"e", null);
                                                            if (iList != null) {
                                                                geom.setEdges(iList);
                                                            }
                                                            if (edges.hasChild("thickness")) {
                                                                d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)edges, (String)"thickness");
                                                                geom.setGlobalEdgeSize(d);
                                                            }
                                                            if ((c = PsXmlLoader.parseColorRGB((PsXmlNode)edges, (String)"color")) != null) {
                                                                geom.setGlobalEdgeColor(c);
                                                            }
                                                            if ((c = PsXmlLoader.parseColorRGB((PsXmlNode)edges, (String)"colorTag")) != null) {
                                                                geom.setGlobalEdgeTagColor(c);
                                                            }
                                                            if (edges.hasChild("labelAtt")) {
                                                                labelAttNode = edges.getChild("labelAtt");
                                                                labelAtt = this.parseLabelAtt(labelAttNode);
                                                                if (labelAtt != null) {
                                                                    geom.setLabelAttribute(1, labelAtt);
                                                                    geom.showEdgeLabels(labelAtt.getEntry(5) == 1);
                                                                    fontName = labelAttNode.getAttribute("name");
                                                                    if (fontName != null) {
                                                                        geom.setLabelFont(1, fontName);
                                                                        geom.setLabelSize(1, labelAtt.getEntry(6));
                                                                        geom.setLabelStyle(1, labelAtt.getEntry(7));
                                                                    }
                                                                }
                                                                if (labelAttNode.hasChild("color")) {
                                                                    colLabel = PsXmlLoader.parseColorRGB((PsXmlNode)labelAttNode, (String)"color");
                                                                    geom.setLabelColor(1, colLabel);
                                                                }
                                                            }
                                                        }
                                                        if ((colors = PsXmlSrc.getRsrcNode((PsXmlNode)faceSet, (String)"colors")) != null) {
                                                            if (bCompressedSurface) {
                                                                geom.setElementColorCode(PgJvzLoader.stringToBytes(PsXmlSrc.getRsrc((PsXmlNode)colors, (String)"colorData")));
                                                            } else {
                                                                cList = PsXmlLoader.parseColorList((PsXmlNode)colors, (String)"c");
                                                                if (cList != null) {
                                                                    geom.setElementColors(cList);
                                                                }
                                                            }
                                                        } else if (bShowColors && !bInduceColors) {
                                                            PsDebug.warning((String)"Missing individual colors, found <color=show> attribute but neither individual element nor vertex colors.\n");
                                                            bInduceColors = false;
                                                        }
                                                        backColors = PsXmlSrc.getRsrcNode((PsXmlNode)faceSet, (String)"colorsBack");
                                                        if (backColors != null) {
                                                            if (bCompressedSurface) {
                                                                geom.setElementBackColorCode(PgJvzLoader.stringToBytes(PsXmlSrc.getRsrc((PsXmlNode)backColors, (String)"colorData")));
                                                            } else {
                                                                cList = PsXmlLoader.parseColorList((PsXmlNode)backColors, (String)"c");
                                                                if (cList != null) {
                                                                    geom.setElementBackColors(cList);
                                                                }
                                                            }
                                                        }
                                                        if ((normals = PsXmlSrc.getRsrcNode((PsXmlNode)faceSet, (String)"normals")) != null) {
                                                            if (bCompressedSurface) {
                                                                geom.setElementNormalCode(PgJvzLoader.stringToBytes(PsXmlSrc.getRsrc((PsXmlNode)normals, (String)"nz")));
                                                            } else {
                                                                dList = PsXmlLoader.parseDoubleList((PsXmlNode)normals, (String)"n", null);
                                                                if (dList != null) {
                                                                    geom.setElementNormals(dList);
                                                                }
                                                            }
                                                            if (normals.hasChild("thickness")) {
                                                                d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)normals, (String)"thickness");
                                                                geom.setGlobalElementNormalSize(d);
                                                            }
                                                            if (normals.hasChild("length")) {
                                                                d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)normals, (String)"length");
                                                                geom.setGlobalElementNormalLength(d);
                                                            }
                                                            if ((c = PsXmlLoader.parseColorRGB((PsXmlNode)normals, (String)"color")) != null) {
                                                                geom.setGlobalElementNormalColor(c);
                                                            }
                                                        } else if ((!bShowBackface || geom.isShowingElementNormals()) && geom.getDimOfVertices() == 3) {
                                                            geom.makeElementNormals();
                                                        }
                                                        textures = PsXmlSrc.getRsrcNode((PsXmlNode)faceSet, (String)"textures");
                                                        v4 = bShowTexture = PgJvzLoader.parseVisibility(faceSet.getAttribute("texture")) == 1;
                                                        if (textures == null) {
                                                            geom.showVertexTexture(bShowTexture);
                                                        } else {
                                                            geom.showElementTexture(bShowTexture);
                                                            textureBlend = textures.getAttribute("blend");
                                                            if (textureBlend != null) {
                                                                if (textureBlend.equals("replace")) {
                                                                    geom.setBlendingMode(0);
                                                                } else if (textureBlend.equals("material")) {
                                                                    geom.setBlendingMode(1);
                                                                } else if (textureBlend.equals("alpha")) {
                                                                    geom.setBlendingMode(2);
                                                                } else {
                                                                    PsDebug.warning((String)("Unknown texture attribute: blend = " + textureBlend));
                                                                }
                                                            } else {
                                                                geom.setBlendingMode(0);
                                                            }
                                                            textureFilter = textures.getAttribute("filter");
                                                            if (textureFilter != null) {
                                                                if (textureFilter.equals("direct")) {
                                                                    geom.setFilterType(0);
                                                                } else if (textureFilter.equals("linear")) {
                                                                    geom.setFilterType(1);
                                                                } else if (textureFilter.equals("quadratic")) {
                                                                    geom.setFilterType(2);
                                                                } else {
                                                                    PsDebug.warning((String)("Unknown texture attribute: filter = " + textureFilter));
                                                                }
                                                            } else {
                                                                geom.setFilterType(0);
                                                            }
                                                            textureSide = textures.getAttribute("side");
                                                            if (textureSide != null) {
                                                                if (textureSide.equals("both")) {
                                                                    geom.setTextureSide(3);
                                                                } else if (textureSide.equals("front")) {
                                                                    geom.setTextureSide(1);
                                                                } else if (textureSide.equals("back")) {
                                                                    geom.setTextureSide(2);
                                                                } else {
                                                                    PsDebug.warning((String)("Unknown texture attribute: side = " + textureSide));
                                                                }
                                                            } else {
                                                                geom.setTextureSide(3);
                                                            }
                                                            if (bCompressedSurface) {
                                                                geom.setElementTextureCode(PgJvzLoader.stringToBytes(PsXmlSrc.getRsrc((PsXmlNode)textures, (String)"t")));
                                                            } else {
                                                                texCoord = PsXmlLoader.parseDoubleList((PsXmlNode)textures, (String)"t", null);
                                                                noe = geom.getNumElements();
                                                                if (texCoord != null && noe > 0) {
                                                                    geom.assureElementTextures();
                                                                    texture = geom.getElementTextures();
                                                                    num = 0;
                                                                    elem = geom.getElements();
                                                                    k = 0;
                                                                    while (k < noe) {
                                                                        elemSize = elem[k].getSize();
                                                                        kk = 0;
                                                                        while (kk < elemSize) {
                                                                            texture[k][kk].copy(texCoord[num++]);
                                                                            ++kk;
                                                                        }
                                                                        ++k;
                                                                    }
                                                                    if (num != texCoord.length) {
                                                                        PsDebug.warning((String)"element texture coordinates do not match elements.");
                                                                        geom.setElementTextures(null);
                                                                    } else {
                                                                        geom.setVertexTextures(null);
                                                                    }
                                                                }
                                                            }
                                                            image = textures.getChild("image");
                                                            if (image != null) {
                                                                imgUrl = PsXmlSrc.getRsrcNode((PsXmlNode)image, (String)"url");
                                                                if (imgUrl != null) {
                                                                    s = imgUrl.getContent();
                                                                } else {
                                                                    s = image.getContent();
                                                                    if (s != null) {
                                                                        PsDebug.warning((String)"Found <image> element not conforming to jvx.dtd, bug from previous JavaView.\n\tSolution: save JVX scene again with JavaView v.2.50 or later.");
                                                                    }
                                                                }
                                                                repeat = image.getAttribute("repeat");
                                                                if (repeat != null && !"no".equals(repeat)) {
                                                                    PsDebug.warning((String)"repeat mode in images not supported yet.");
                                                                }
                                                                if (s != null) {
                                                                    geom.setTextureImageName(s);
                                                                }
                                                            }
                                                            if ((imageCoords = textures.getChild("imageCoords")) != null && (imgVert = PsXmlLoader.parseDoubleList((PsXmlNode)imageCoords, (String)"p", null)) != null) {
                                                                geom.setTextureImageBnd(imgVert);
                                                            }
                                                            if ((texTiling = textures.getChild("tiling")) != null) {
                                                                tiling = PsXmlLoader.parsePiVector((PsXmlNode)texTiling, null);
                                                                if (tiling != null && tiling.getSize() == 2) {
                                                                    geom.setTextureTiling(new Dimension(tiling.getEntry(0), tiling.getEntry(1)));
                                                                } else {
                                                                    PsDebug.warning((String)"Found texture <tiling> element with missing or invalid data.");
                                                                }
                                                            }
                                                        }
                                                        boundaries = PsXmlSrc.getRsrcNode((PsXmlNode)faceSet, (String)"boundaries");
                                                        if (boundaries != null) {
                                                            if (boundaries.hasChild("thickness")) {
                                                                d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)boundaries, (String)"thickness");
                                                                geom.setGlobalBndSize(d);
                                                            }
                                                            if ((c = PsXmlLoader.parseColorRGB((PsXmlNode)boundaries, (String)"color")) != null) {
                                                                geom.setGlobalBndColor(c);
                                                            }
                                                            if ((c = PsXmlLoader.parseColorRGB((PsXmlNode)boundaries, (String)"colorTag")) != null) {
                                                                geom.setGlobalBndTagColor(c);
                                                            }
                                                        }
                                                    }
                                                    if ((vectorField = PsXmlSrc.getRsrcNodes((PsXmlNode)geometry[i], (String)"vectorField")) != null && vectorField.length > 0) {
                                                        if (bCompressedSurface) {
                                                            geom.setNumVectorFields(vectorField.length);
                                                            geom.setNumStoredVectorFields(vectorField.length);
                                                            geom.showVectorFields(true);
                                                            j = 0;
                                                            while (j < vectorField.length) {
                                                                geom.setVectorFieldName(j, vectorField[j].getAttribute("name"));
                                                                base = vectorField[j].getAttribute("base");
                                                                if (base != null) {
                                                                    geom.setVectorElementBased(j, base.equals("element"));
                                                                }
                                                                geom.showVectorField(j, PgJvzLoader.parseVisibility(vectorField[j].getAttribute("vector")) != 0);
                                                                geom.showVectorFieldMaterials(j, PgJvzLoader.parseVisibility(vectorField[j].getAttribute("material")) != 0);
                                                                geom.showVectorArrows(j, PgJvzLoader.parseVisibility(vectorField[j].getAttribute("arrow")) == 1);
                                                                geom.showVectorColors(j, PgJvzLoader.parseVisibility(vectorField[j].getAttribute("color")) == 1);
                                                                vectorData = PsXmlSrc.getRsrcNode((PsXmlNode)vectorField[j], (String)"vectorData");
                                                                if (vectorData != null) {
                                                                    geom.setVectorFieldCode(j, PgJvzLoader.stringToBytes(PsXmlSrc.getRsrc((PsXmlNode)vectorField[j], (String)"vd")));
                                                                    if (vectorData.hasChild("thickness")) {
                                                                        d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)vectorData, (String)"thickness");
                                                                        geom.setGlobalVectorSize(j, d);
                                                                    }
                                                                    if (vectorData.hasChild("length")) {
                                                                        d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)vectorData, (String)"length");
                                                                        geom.setGlobalVectorLength(j, d);
                                                                    }
                                                                    if ((c = PsXmlLoader.parseColorRGB((PsXmlNode)vectorData, (String)"color")) != null) {
                                                                        geom.setGlobalVectorColor(j, c);
                                                                    }
                                                                }
                                                                if ((colors = PsXmlSrc.getRsrcNode((PsXmlNode)vectorField[j], (String)"colors")) != null && (cList = PsXmlLoader.parseColorList((PsXmlNode)colors, (String)"c")) != null) {
                                                                    geom.setVectorColors(j, cList);
                                                                }
                                                                ++j;
                                                            }
                                                        }
                                                        geom.setNumVectorFields(vectorField.length);
                                                        geom.showVectorFields(true);
                                                        j = 0;
                                                        while (j < vectorField.length) {
                                                            vfName = vectorField[j].getAttribute("name");
                                                            if (vfName != null) {
                                                                geom.setVectorFieldName(j, vfName);
                                                            }
                                                            if ((base = vectorField[j].getAttribute("base")) != null) {
                                                                geom.setVectorElementBased(j, base.equals("element"));
                                                            }
                                                            geom.showVectorField(j, PgJvzLoader.parseVisibility(vectorField[j].getAttribute("vector")) != 0);
                                                            geom.showVectorFieldMaterials(j, PgJvzLoader.parseVisibility(vectorField[j].getAttribute("material")) != 0);
                                                            geom.showVectorArrows(j, PgJvzLoader.parseVisibility(vectorField[j].getAttribute("arrow")) == 1);
                                                            geom.showVectorColors(j, PgJvzLoader.parseVisibility(vectorField[j].getAttribute("color")) == 1);
                                                            vectors = PsXmlSrc.getRsrcNode((PsXmlNode)vectorField[j], (String)"vectors");
                                                            if (vectors != null) {
                                                                dList = PsXmlLoader.parseDoubleList((PsXmlNode)vectors, (String)"v", (String[])attr);
                                                                if (dList != null && (num = dList.length) > 0) {
                                                                    geom.setNumVectors(j, num, dList[0].getSize());
                                                                    geom.setVectors(j, dList);
                                                                }
                                                                if (vectors.hasChild("thickness")) {
                                                                    d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)vectors, (String)"thickness");
                                                                    geom.setGlobalVectorSize(j, d);
                                                                }
                                                                if (vectors.hasChild("length")) {
                                                                    d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)vectors, (String)"length");
                                                                    geom.setGlobalVectorLength(j, d);
                                                                }
                                                                if ((c = PsXmlLoader.parseColorRGB((PsXmlNode)vectors, (String)"color")) != null) {
                                                                    geom.setGlobalVectorColor(j, c);
                                                                }
                                                            }
                                                            if ((colors = PsXmlSrc.getRsrcNode((PsXmlNode)vectorField[j], (String)"colors")) != null && (cList = PsXmlLoader.parseColorList((PsXmlNode)colors, (String)"c")) != null) {
                                                                geom.setVectorColors(j, cList);
                                                            }
                                                            ++j;
                                                        }
                                                    }
                                                    if ((center = PsXmlSrc.getRsrcNode((PsXmlNode)geometry[i], (String)"center")) != null) {
                                                        visib = center.getAttribute("visible");
                                                        geom.showCenter(visib == null || visib.equalsIgnoreCase("show") != false);
                                                        cen = PsXmlLoader.parsePdVector((PsXmlNode)center, (String)"p", null);
                                                        geom.setCenter(cen);
                                                    }
                                                    if ((primitive = PsXmlSrc.getRsrcNode((PsXmlNode)geometry[i], (String)"primitive")) != null) {
                                                        PsDebug.warning((String)"parsing of primitives not implemented yet.");
                                                    }
                                                    if ((transform = geometry[i].getChild("transform")) == null) break block312;
                                                    if (transform.hasChild("modelMat") && (modelMat = PsXmlLoader.parsePdMatrix((PsXmlNode)transform, (String)"modelMat")) != null) {
                                                        geom.setModelMatrix(modelMat);
                                                    }
                                                    if ((ambient = transform.getChild("ambient")) == null) break block312;
                                                    ambientDim = ambient.getAttribute("dim");
                                                    ambientSpace = ambient.getAttribute("space");
                                                    ambientProj = ambient.getAttribute("projection");
                                                    if (ambientSpace == null || ambientDim == null || ambientProj == null) break block313;
                                                    dim = Integer.parseInt(ambientDim);
                                                    if (!ambientSpace.equalsIgnoreCase("euclidean")) break block314;
                                                    if (dim == 1) {
                                                        geom.setAmbientSpace(0);
                                                    } else if (dim == 2) {
                                                        geom.setAmbientSpace(1);
                                                    } else if (dim == 3) {
                                                        geom.setAmbientSpace(3);
                                                    } else if (dim == 4) {
                                                        geom.setAmbientSpace(6);
                                                    } else if (dim == 5) {
                                                        geom.setAmbientSpace(9);
                                                    } else {
                                                        PsDebug.warning((String)"combination of ambient space and dimension not allowed");
                                                        return null;
                                                    }
                                                    if (!ambientProj.equalsIgnoreCase("parallel")) break block315;
                                                    geom.setAmbientProjection(0);
                                                    break block313;
                                                }
                                                if (!ambientProj.equalsIgnoreCase("stereographic")) break block316;
                                                geom.setAmbientProjection(1);
                                                break block313;
                                            }
                                            PsDebug.warning((String)"combination of ambient space and projection not allowed");
                                            return null;
                                        }
                                        if (!ambientSpace.equalsIgnoreCase("spherical")) break block317;
                                        if (dim == 2) {
                                            geom.setAmbientSpace(2);
                                        } else if (dim == 3) {
                                            geom.setAmbientSpace(4);
                                        } else if (dim == 4) {
                                            geom.setAmbientSpace(7);
                                        } else if (dim == 5) {
                                            geom.setAmbientSpace(10);
                                        } else {
                                            PsDebug.warning((String)"combination of ambient space and dimension not allowed");
                                            return null;
                                        }
                                        if (!ambientProj.equalsIgnoreCase("parallel")) break block318;
                                        geom.setAmbientProjection(0);
                                        break block313;
                                    }
                                    if (!ambientProj.equalsIgnoreCase("stereographic")) break block319;
                                    geom.setAmbientProjection(1);
                                    break block313;
                                }
                                PsDebug.warning((String)"combination of ambient space and projection not allowed");
                                return null;
                            }
                            if (!ambientSpace.equalsIgnoreCase("hyperbolic")) ** GOTO lbl856
                            if (dim == 3) {
                                geom.setAmbientSpace(5);
                            } else if (dim == 4) {
                                geom.setAmbientSpace(8);
                            } else if (dim == 5) {
                                geom.setAmbientSpace(11);
                            } else {
                                PsDebug.warning((String)"combination of ambient space and dimension not allowed");
                                return null;
                            }
                            if (ambientProj.equalsIgnoreCase("parallel")) {
                                geom.setAmbientProjection(0);
                            } else if (ambientProj.equalsIgnoreCase("poincare")) {
                                geom.setAmbientProjection(1);
                            } else if (ambientProj.equalsIgnoreCase("klein")) {
                                geom.setAmbientProjection(2);
                            } else if (ambientProj.equalsIgnoreCase("uhs")) {
                                geom.setAmbientProjection(3);
                            } else {
                                PsDebug.warning((String)"combination of ambient space and projection not allowed");
                                return null;
lbl856:
                                // 1 sources

                                if (ambientSpace.equalsIgnoreCase("lorentz")) {
                                    PsDebug.warning((String)("not implemented yet, ambient space = " + ambientSpace));
                                    return null;
                                }
                                PsDebug.warning((String)("unknown ambient space = " + ambientSpace));
                                return null;
                            }
                        }
                        ambientMat = PsXmlLoader.parsePdMatrix((PsXmlNode)ambient, (String)"ambientMat");
                        ambientInvMat = PsXmlLoader.parsePdMatrix((PsXmlNode)ambient, (String)"ambientInvMat");
                        if (ambientMat != null && ambientInvMat != null) {
                            geom.setAmbientMatrix(ambientMat, ambientInvMat);
                        }
                    }
                    if (bCompressedSurface) {
                        decoder = new PuJvzDecoder();
                        m_geom[i] = decoder.decodeGeometry(geom);
                    }
                    ++i;
                }
                break block320;
            }
            PsDebug.warning((String)"missing XML node <geometries>.");
        }
        authors = PsXmlSrc.getRsrcNode((PsXmlNode)root, (String)"authors");
        authorInfo = null;
        if (authors != null) {
            authorInfo = new PsAuthorInfo();
            authorInfo.setXmlNode(authors);
        }
        description = PsXmlSrc.getRsrcNode((PsXmlNode)root, (String)"description");
        geometryInfo = null;
        if (description != null) {
            geometryInfo = new PsGeometryInfo();
            geometryInfo.setXmlNode(description, null);
        }
        if (m_geom != null) {
            i = 0;
            while (i < m_geom.length) {
                if (authorInfo != null) {
                    m_geom[i].setAuthorInfo(authorInfo);
                }
                if (geometryInfo != null) {
                    m_geom[i].setGeometryInfo(geometryInfo);
                }
                ++i;
            }
        }
        return m_geom;
    }

    protected PsXmlSrc fillRsrcTree(PsXmlSrc src, PgJvxSrc[] m_geom) {
        PsXmlNode description;
        PsGeometryInfo geometryInfo;
        PsXmlNode authors;
        PsAuthorInfo author;
        PsXmlNode root;
        if (m_geom == null || m_geom.length == 0 || m_geom[0] == null) {
            return null;
        }
        boolean bIncludeHeader = true;
        boolean bIncludeAuthor = true;
        boolean bIncludeInfo = true;
        boolean bIncludeNormals = true;
        boolean bIncludeColors = true;
        boolean bIncludeTexture = true;
        boolean bIncludeVectors = true;
        if (this.m_geometryOption != null) {
            bIncludeHeader = this.m_geometryOption.get(0);
            bIncludeAuthor = this.m_geometryOption.get(1);
            bIncludeInfo = this.m_geometryOption.get(2);
            bIncludeNormals = this.m_geometryOption.get(3);
            bIncludeColors = this.m_geometryOption.get(4);
            bIncludeTexture = this.m_geometryOption.get(5);
            bIncludeVectors = this.m_geometryOption.get(6);
        }
        if (src == null) {
            src = new PsXmlSrc();
        }
        if ((root = src.getRootNode()) == null) {
            root = new PsXmlNode("jvz-model");
            src.setRootNode(root);
        }
        PgJvxSrc geom = m_geom[0];
        src.setDocName("jvz-model");
        src.setDocType("http://www.javaview.de/rsrc/jvz.dtd");
        if (bIncludeHeader) {
            PsXmlNode meta = root.addChild("meta");
            meta.addAttribute("generator", PsConfig.getProgramAndVersion());
            meta = root.addChild("meta");
            int[] dtdVer = PsConfig.getVersion((int)11);
            String ver = String.valueOf(String.valueOf(dtdVer[0])) + ".";
            if (dtdVer[1] < 10) {
                ver = String.valueOf(ver) + "0";
            }
            ver = String.valueOf(ver) + String.valueOf(dtdVer[1]);
            if (dtdVer[2] != 0) {
                ver = String.valueOf(ver) + ".";
                if (dtdVer[2] < 10) {
                    ver = String.valueOf(ver) + "00";
                } else if (dtdVer[2] < 100) {
                    ver = String.valueOf(ver) + "0";
                }
                ver = String.valueOf(ver) + String.valueOf(dtdVer[2]);
            }
            meta.addAttribute("dtd", ver);
            meta = root.addChild("meta");
            meta.addAttribute("date", new Date().toString());
            PsXmlNode version = root.addChild("version", geom.getVersion());
            version.addAttribute("type", geom.getVersionType());
            if (geom.getTitle() != null) {
                root.addChild("title", geom.getTitle());
            } else {
                root.addChild("title", geom.getName());
            }
        }
        if (bIncludeAuthor && (author = geom.getAuthorInfo()) != null && author.getNumAuthors() > 0 && (authors = author.getXmlNode()) != null) {
            root.addChild(authors);
        }
        if (bIncludeInfo && (geometryInfo = geom.getGeometryInfo()) != null && (description = geometryInfo.getXmlNode()) != null) {
            root.addChild(description);
        }
        PsXmlNode geometries = root.addChild("geometries");
        int i = 0;
        while (i < m_geom.length) {
            boolean bHasAmbient;
            PdVector cen;
            PdVector[] bounds;
            PsXmlNode colors;
            PsXmlNode colors2;
            PsXmlNode thicknesses;
            PsXmlNode normals;
            PsXmlNode colors3;
            PsXmlNode labelAttNode;
            PiVector labelAtt;
            PuJvzEncoder coder;
            int geomType;
            geom = m_geom[i];
            PsXmlNode geometry = geometries.addChild("geometry");
            geometry.addAttribute("name", geom.getName());
            if (!geom.isVisible()) {
                geometry.addAttribute("visible", "hide");
            }
            if ((geomType = geom.getType()) == -1) {
                PsDebug.error((String)("geom = " + geom.getName() + " has unknown geometry type, JVX may not conform to jvx.dtd."));
                geomType = 30;
            }
            PgJvzCode jvzCode = null;
            if (geomType == 33 && (jvzCode = (coder = new PuJvzEncoder()).encodeGeometry(geom)) != null) {
                geom = jvzCode;
            }
            if (geomType == 30 || geomType == 31 || geomType == 32 || geomType == 33) {
                PsXmlNode pointSet = geometry.addChild("pointSet");
                pointSet.addAttribute("dim", String.valueOf(geom.getDimOfVertices()));
                if (geom.isShowingVertices()) {
                    pointSet.addAttribute("point", "show");
                } else {
                    pointSet.addAttribute("point", "hide");
                }
                if (bIncludeColors && geom.isShowingVertexColors() && geom.getVertexColors() != null) {
                    pointSet.addAttribute("color", "show");
                }
                if (bIncludeNormals && geom.isShowingVertexNormals() && geom.getVertexNormals() != null) {
                    pointSet.addAttribute("normal", "show");
                }
                if (bIncludeNormals && geom.isShowingVertexNormalArrow() && geom.getVertexNormals() != null) {
                    pointSet.addAttribute("normalArrow", "show");
                }
                if (geom.isShowingVertexSizes() && geom.getVertexSizes() != null) {
                    pointSet.addAttribute("thicknesses", "show");
                }
                if (!geom.isShowingTaggedVertices()) {
                    pointSet.addAttribute("pointMark", "hide");
                }
                if (!geom.isShowingVertexOutline()) {
                    pointSet.addAttribute("pointOutline", "hide");
                }
                PsXmlNode points = pointSet.addChild("points");
                if (jvzCode != null) {
                    PsXmlNode bndBox = points.addChild("bndBox");
                    PdVector[] bounds2 = jvzCode.getBndBox();
                    bndBox.addChild("p", PuString.toString((double[])bounds2[0].getEntries()));
                    bndBox.addChild("p", PuString.toString((double[])bounds2[1].getEntries()));
                    points.addChild("resolution", PuString.toString((int[])jvzCode.getAxisResolution()));
                    points.addChild("resize", jvzCode.getResizeFactor());
                    String vdString = PgJvzLoader.bytesToString(jvzCode.getVertexDataCode());
                    PsXmlNode vertexData = points.addChild("vertexData", vdString);
                    vertexData.addAttribute("length", String.valueOf(vdString.length()));
                    String code = PgJvzLoader.bytesToString(jvzCode.getDiscrErrorCode());
                    if (code != null) {
                        PsXmlNode discretizationError = points.addChild("discretizationError", code);
                        discretizationError.addAttribute("length", String.valueOf(code.length()));
                    }
                    if ((code = PgJvzLoader.bytesToString(jvzCode.getVertexIndexCode())) != null) {
                        PsXmlNode pointIndex = points.addChild("pointIndex", code);
                        pointIndex.addAttribute("length", String.valueOf(code.length()));
                    }
                    if ((code = PgJvzLoader.bytesToString(jvzCode.getLocalIndexCode())) != null) {
                        PsXmlNode localIndex = points.addChild("indexOfMin", code);
                        localIndex.addAttribute("length", String.valueOf(code.length()));
                    }
                    points.addAttribute("num", Integer.toString(jvzCode.getNumVertices()));
                } else {
                    PsXmlLoader.addVectorList((PsXmlNode)points, (String)"p", (PdVector[])geom.getVertices(), (int)geom.getNumVertices());
                }
                points.addChild("thickness", geom.getGlobalVertexSize());
                if (geom.getGlobalVertexColor() != null) {
                    PsXmlLoader.addColor((PsXmlNode)points, (String)"color", (Color)geom.getGlobalVertexColor());
                }
                if (geom.getGlobalVertexTagColor() != null) {
                    PsXmlLoader.addColor((PsXmlNode)points, (String)"colorTag", (Color)geom.getGlobalVertexTagColor());
                }
                if (geom.isShowingIndices() || geom.isShowingVertexLabels() || !geom.isEnabledIndexLabels()) {
                    labelAtt = geom.getLabelAttribute(0);
                    labelAttNode = null;
                    if (labelAtt != null) {
                        labelAtt = (PiVector)labelAtt.clone();
                        labelAtt.setSize(8);
                        labelAtt.setEntry(5, 1);
                        labelAtt.setEntry(6, (int)geom.getLabelSize(0));
                        labelAtt.setEntry(7, geom.getLabelStyle(0));
                        labelAttNode = PgJvzLoader.fillLabelAttr(labelAtt, geom.getLabelFont(0));
                    } else {
                        labelAttNode = PgJvzLoader.fillLabelAttr(true);
                    }
                    if (!geom.isEnabledIndexLabels()) {
                        labelAttNode.addAttribute("auto", "hide");
                    }
                    PsXmlLoader.addColor((PsXmlNode)labelAttNode, (String)"color", (Color)geom.getLabelColor(0));
                    points.addChild(labelAttNode);
                }
                if (bIncludeColors && geom.getVertexColors() != null) {
                    colors3 = pointSet.addChild("colors");
                    colors3.addAttribute("type", "rgb");
                    if (jvzCode != null) {
                        String colString = PgJvzLoader.bytesToString(jvzCode.getVertexColorCode());
                        if (colString != null) {
                            PsXmlNode colorData = colors3.addChild("colorData", colString);
                            colorData.addAttribute("length", Integer.toString(colString.length()));
                            colors3.addAttribute("num", Integer.toString(jvzCode.getNumVertices()));
                        }
                    } else {
                        PsXmlLoader.addVectorList((PsXmlNode)colors3, (String)"c", (Color[])geom.getVertexColors(), (int)geom.getNumVertices());
                    }
                }
                if (bIncludeNormals && geom.getVertexNormals() != null) {
                    normals = pointSet.addChild("normals");
                    if (jvzCode != null) {
                        String vnString = PgJvzLoader.bytesToString(jvzCode.getVertexNormalCode());
                        if (vnString != null) {
                            PsXmlNode cn = normals.addChild("nz", vnString);
                            cn.addAttribute("length", Integer.toString(vnString.length()));
                            normals.addAttribute("num", Integer.toString(jvzCode.getNumVertices()));
                        }
                    } else {
                        PsXmlLoader.addVectorList((PsXmlNode)normals, (String)"n", (PdVector[])geom.getVertexNormals(), (int)geom.getNumVertices());
                        normals.addAttribute("num", Integer.toString(geom.getNumVertices()));
                    }
                    normals.addChild("thickness", geom.getGlobalVertexNormalSize());
                    normals.addChild("length", geom.getGlobalVertexNormalLength());
                    if (geom.getGlobalVertexNormalColor() != null) {
                        PsXmlLoader.addColor((PsXmlNode)normals, (String)"color", (Color)geom.getGlobalVertexNormalColor());
                    }
                }
                if (bIncludeTexture && geom.getVertexTextures() != null) {
                    PsXmlNode textures = pointSet.addChild("textures");
                    textures.addAttribute("dim", String.valueOf(2));
                    if (geom.getBlendingMode() == 1) {
                        textures.addAttribute("blend", "material");
                    } else if (geom.getBlendingMode() == 2) {
                        textures.addAttribute("blend", "alpha");
                    }
                    if (geom.getFilterType() == 1) {
                        textures.addAttribute("filter", "linear");
                    } else if (geom.getFilterType() == 2) {
                        textures.addAttribute("filter", "quadratic");
                    }
                    if (geom.getTextureSide() == 1) {
                        textures.addAttribute("side", "front");
                    } else if (geom.getTextureSide() == 2) {
                        textures.addAttribute("side", "back");
                    }
                    if (jvzCode != null) {
                        String texString = PgJvzLoader.bytesToString(jvzCode.getVertexTextureCode());
                        if (texString != null) {
                            PsXmlNode tex = textures.addChild("t", texString);
                            tex.addAttribute("length", String.valueOf(texString.length()));
                            textures.addAttribute("num", Integer.toString(jvzCode.getNumVertices()));
                        }
                    } else {
                        PsXmlLoader.addVectorList((PsXmlNode)textures, (String)"t", (PdVector[])geom.getVertexTextures(), (int)geom.getNumVertices());
                    }
                    if (geom.getTextureImage() != null) {
                        PsXmlNode image = textures.addChild("image");
                        image.addAttribute("repeat", "no");
                        String textureFileName = geom.getTextureImageName();
                        if (textureFileName == null) {
                            textureFileName = String.valueOf(geom.getName()) + "_texture.gif";
                        }
                        image.addChild("url", textureFileName);
                        PdVector[] imgVert = geom.getTextureImageBnd();
                        if (imgVert[0].getEntry(0) != 0.0 || imgVert[0].getEntry(1) != 0.0 || imgVert[1].getEntry(0) != 1.0 || imgVert[1].getEntry(1) != 1.0) {
                            PsXmlNode imageCoords = textures.addChild("imageCoords");
                            PsXmlLoader.addVectorList((PsXmlNode)imageCoords, (String)"p", (PdVector[])imgVert, (int)2);
                        }
                    }
                    Dimension dimRepeat = geom.getTextureTiling();
                    textures.addChild("tiling", String.valueOf(Integer.toString(dimRepeat.width)) + " " + Integer.toString(dimRepeat.height));
                }
                if (geom.getVertexSizes() != null) {
                    thicknesses = pointSet.addChild("thicknesses");
                    PsXmlLoader.addVectorList((PsXmlNode)thicknesses, (String)"th", (PdVector)geom.getVertexSizes(), (int)geom.getNumVertices());
                }
            }
            if (geomType == 31) {
                PsXmlNode polygon = geometry.addChild("polygon");
                if (geom.isShowingPolygons()) {
                    polygon.addAttribute("edge", "show");
                } else {
                    polygon.addAttribute("edge", "hide");
                }
                if (geom.isShowingPolygonStartArrow()) {
                    polygon.addAttribute("arrowStart", "show");
                }
                if (geom.isShowingPolygonEndArrow()) {
                    polygon.addAttribute("arrow", "show");
                }
                if (bIncludeColors && geom.isShowingPolygonColors() && (geom.getPolygonColors() != null || geom.isShowingElementColorFromVertices())) {
                    polygon.addAttribute("color", "show");
                }
                if (bIncludeColors && geom.isShowingElementColorFromVertices()) {
                    polygon.addAttribute("colorFromPoints", "show");
                }
                if (bIncludeColors && geom.isShowingSmoothElementColors()) {
                    polygon.addAttribute("colorSmooth", "show");
                }
                if (bIncludeNormals && geom.isShowingPolygonNormals()) {
                    polygon.addAttribute("normal", "show");
                }
                if (bIncludeNormals && geom.isShowingPolygonNormalArrow()) {
                    polygon.addAttribute("normalArrow", "show");
                }
                if (!geom.isShowingTaggedPolygons()) {
                    polygon.addAttribute("edgeMark", "hide");
                }
                if (geom.isShowingPolygonSizes() && geom.getPolygonSizes() != null) {
                    polygon.addAttribute("thicknesses", "show");
                }
                PsXmlNode edges = polygon.addChild("edges");
                PsXmlLoader.addVectorList((PsXmlNode)edges, (String)"e", (PiVector[])geom.getPolygons(), (int)geom.getNumPolygons());
                edges.addChild("thickness", geom.getGlobalPolygonSize());
                if (geom.getGlobalPolygonColor() != null) {
                    PsXmlLoader.addColor((PsXmlNode)edges, (String)"color", (Color)geom.getGlobalPolygonColor());
                }
                if (geom.getGlobalPolygonTagColor() != null) {
                    PsXmlLoader.addColor((PsXmlNode)edges, (String)"colorTag", (Color)geom.getGlobalPolygonTagColor());
                }
                if (geom.isShowingIndices() || geom.isShowingPolygonLabels()) {
                    labelAtt = geom.getLabelAttribute(2);
                    labelAttNode = null;
                    if (labelAtt != null) {
                        labelAtt = (PiVector)labelAtt.clone();
                        labelAtt.setSize(8);
                        labelAtt.setEntry(5, 1);
                        labelAtt.setEntry(6, (int)geom.getLabelSize(2));
                        labelAtt.setEntry(7, geom.getLabelStyle(2));
                        labelAttNode = PgJvzLoader.fillLabelAttr(labelAtt, geom.getLabelFont(2));
                    } else {
                        labelAttNode = PgJvzLoader.fillLabelAttr(true);
                    }
                    PsXmlLoader.addColor((PsXmlNode)labelAttNode, (String)"color", (Color)geom.getLabelColor(2));
                    edges.addChild(labelAttNode);
                }
                if (bIncludeColors && geom.getPolygonColors() != null) {
                    colors3 = polygon.addChild("colors");
                    colors3.addAttribute("type", "rgb");
                    PsXmlLoader.addVectorList((PsXmlNode)colors3, (String)"c", (Color[])geom.getPolygonColors(), (int)geom.getNumPolygons());
                }
                if (bIncludeNormals && geom.getPolygonNormals() != null) {
                    normals = polygon.addChild("normals");
                    PsXmlLoader.addVectorList((PsXmlNode)normals, (String)"n", (PdVector[])geom.getPolygonNormals(), (int)geom.getNumPolygons());
                    normals.addChild("thickness", geom.getGlobalPolygonNormalSize());
                    normals.addChild("length", geom.getGlobalPolygonNormalLength());
                    if (geom.getGlobalPolygonNormalColor() != null) {
                        PsXmlLoader.addColor((PsXmlNode)normals, (String)"color", (Color)geom.getGlobalPolygonNormalColor());
                    }
                }
                if (geom.getPolygonSizes() != null) {
                    thicknesses = polygon.addChild("thicknesses");
                    PsXmlLoader.addVectorList((PsXmlNode)thicknesses, (String)"th", (PdVector)geom.getPolygonSizes(), (int)geom.getNumPolygons());
                }
            }
            if (geomType == 32) {
                PsXmlNode lineSet = geometry.addChild("lineSet");
                if (geom.isShowingPolygons()) {
                    lineSet.addAttribute("line", "show");
                } else {
                    lineSet.addAttribute("line", "hide");
                }
                if (geom.isShowingPolygonStartArrow()) {
                    lineSet.addAttribute("arrowStart", "show");
                }
                if (geom.isShowingPolygonEndArrow()) {
                    lineSet.addAttribute("arrow", "show");
                }
                if (bIncludeColors && geom.isShowingPolygonColors() && (geom.getPolygonColors() != null || geom.isShowingElementColorFromVertices())) {
                    lineSet.addAttribute("color", "show");
                }
                if (bIncludeColors && geom.isShowingElementColorFromVertices()) {
                    lineSet.addAttribute("colorFromPoints", "show");
                }
                if (bIncludeColors && geom.isShowingSmoothElementColors()) {
                    lineSet.addAttribute("colorSmooth", "show");
                }
                if (bIncludeNormals && geom.isShowingPolygonNormals()) {
                    lineSet.addAttribute("normal", "show");
                }
                if (bIncludeNormals && geom.isShowingPolygonNormalArrow()) {
                    lineSet.addAttribute("normalArrow", "show");
                }
                if (!geom.isShowingTaggedPolygons()) {
                    lineSet.addAttribute("lineMark", "hide");
                }
                if (geom.isShowingPolygonSizes() && geom.getPolygonSizes() != null) {
                    lineSet.addAttribute("thicknesses", "show");
                }
                PsXmlNode lines = lineSet.addChild("lines");
                PsXmlLoader.addVectorList((PsXmlNode)lines, (String)"l", (PiVector[])geom.getPolygons(), (int)geom.getNumPolygons());
                lines.addChild("thickness", geom.getGlobalPolygonSize());
                if (geom.getGlobalPolygonColor() != null) {
                    PsXmlLoader.addColor((PsXmlNode)lines, (String)"color", (Color)geom.getGlobalPolygonColor());
                }
                if (geom.getGlobalPolygonTagColor() != null) {
                    PsXmlLoader.addColor((PsXmlNode)lines, (String)"colorTag", (Color)geom.getGlobalPolygonTagColor());
                }
                if (geom.isShowingIndices() || geom.isShowingPolygonLabels()) {
                    labelAtt = geom.getLabelAttribute(2);
                    labelAttNode = null;
                    if (labelAtt != null) {
                        labelAtt = (PiVector)labelAtt.clone();
                        labelAtt.setSize(8);
                        labelAtt.setEntry(5, 1);
                        labelAtt.setEntry(6, (int)geom.getLabelSize(2));
                        labelAtt.setEntry(7, geom.getLabelStyle(2));
                        labelAttNode = PgJvzLoader.fillLabelAttr(labelAtt, geom.getLabelFont(2));
                    } else {
                        labelAttNode = PgJvzLoader.fillLabelAttr(true);
                    }
                    PsXmlLoader.addColor((PsXmlNode)labelAttNode, (String)"color", (Color)geom.getLabelColor(2));
                    lines.addChild(labelAttNode);
                }
                if (bIncludeColors && geom.getPolygonColors() != null) {
                    colors3 = lineSet.addChild("colors");
                    colors3.addAttribute("type", "rgb");
                    PsXmlLoader.addVectorList((PsXmlNode)colors3, (String)"c", (Color[])geom.getPolygonColors(), (int)geom.getNumPolygons());
                }
                if (bIncludeNormals && geom.getPolygonNormals() != null) {
                    normals = lineSet.addChild("normals");
                    PsXmlLoader.addVectorList((PsXmlNode)normals, (String)"n", (PdVector[])geom.getPolygonNormals(), (int)geom.getNumPolygons());
                    normals.addChild("thickness", geom.getGlobalPolygonNormalSize());
                    normals.addChild("length", geom.getGlobalPolygonNormalLength());
                    if (geom.getGlobalPolygonNormalColor() != null) {
                        PsXmlLoader.addColor((PsXmlNode)normals, (String)"color", (Color)geom.getGlobalPolygonNormalColor());
                    }
                }
                if (geom.getPolygonSizes() != null) {
                    thicknesses = lineSet.addChild("thicknesses");
                    PsXmlLoader.addVectorList((PsXmlNode)thicknesses, (String)"th", (PdVector)geom.getPolygonSizes(), (int)geom.getNumPolygons());
                }
            }
            if (geomType == 33) {
                PsXmlNode colorData;
                PsXmlNode elementSet = geometry.addChild("faceSet");
                if (geom.isShowingEdges()) {
                    elementSet.addAttribute("edge", "show");
                } else {
                    elementSet.addAttribute("edge", "hide");
                }
                if (geom.isShowingElements()) {
                    elementSet.addAttribute("face", "show");
                } else {
                    elementSet.addAttribute("face", "hide");
                }
                if (bIncludeColors && geom.isShowingElementColors() && (geom.getElementColors() != null || geom.isShowingElementColorFromVertices())) {
                    elementSet.addAttribute("color", "show");
                }
                if (geom.isShowingElementBackColor()) {
                    elementSet.addAttribute("colorBackGlobal", "show");
                }
                if (bIncludeColors && geom.isShowingElementBackColors() && geom.getElementBackColors() != null) {
                    elementSet.addAttribute("colorBackLocal", "show");
                }
                if (bIncludeColors && geom.isShowingElementColorFromVertices()) {
                    elementSet.addAttribute("colorFromPoints", "show");
                }
                if (bIncludeColors && geom.isShowingSmoothElementColors()) {
                    elementSet.addAttribute("colorSmooth", "show");
                }
                if (bIncludeColors && geom.isShowingEdgeColors()) {
                    elementSet.addAttribute("colorEdge", "show");
                }
                if (bIncludeColors && geom.isShowingEdgeColorFromElements()) {
                    elementSet.addAttribute("colorEdgeInduced", "show");
                }
                if (bIncludeNormals && geom.isShowingElementNormals() && geom.getElementNormals() != null) {
                    elementSet.addAttribute("normal", "show");
                }
                if (bIncludeNormals && geom.isShowingElementNormalArrow() && geom.getElementNormals() != null) {
                    elementSet.addAttribute("normalArrow", "show");
                }
                if (bIncludeTexture && (geom.isShowingVertexTexture() && geom.getVertexTextures() != null || geom.isShowingElementTexture() && geom.getElementTextures() != null)) {
                    elementSet.addAttribute("texture", "show");
                }
                if (!geom.isShowingBackface()) {
                    elementSet.addAttribute("backface", "hide");
                }
                if (geom.isShowingBoundaries()) {
                    elementSet.addAttribute("boundary", "show");
                }
                if (geom.isShowingSilhouette()) {
                    elementSet.addAttribute("silhouette", "show");
                }
                if (!geom.isShowingTaggedElements()) {
                    elementSet.addAttribute("faceMark", "hide");
                }
                PsXmlNode faces = elementSet.addChild("faces");
                if (jvzCode != null) {
                    faces.addAttribute("num", Integer.toString(jvzCode.getNumStoredElements()));
                    int[] contextThresholds = jvzCode.getContextThresholds();
                    PsXmlNode contexts = faces.addChild("contexts", PuString.toString((int[])contextThresholds));
                    contexts.addAttribute("num", String.valueOf(contextThresholds.length));
                    String tdString = PgJvzLoader.bytesToString(jvzCode.getVertexSymbolCode());
                    PsXmlNode traverseData = faces.addChild("traverseData", tdString);
                    traverseData.addAttribute("length", String.valueOf(tdString.length()));
                    String sdString = PgJvzLoader.bytesToString(jvzCode.getSplitSymbolCode());
                    PsXmlNode splitData = faces.addChild("splitData", sdString);
                    splitData.addAttribute("length", String.valueOf(sdString.length()));
                    String fdString = PgJvzLoader.bytesToString(jvzCode.getElementSymbolCode());
                    PsXmlNode faceData = faces.addChild("faceData", fdString);
                    faceData.addAttribute("length", String.valueOf(fdString.length()));
                    String eiString = PgJvzLoader.bytesToString(jvzCode.getElementIndexCode());
                    if (eiString != null) {
                        PsXmlNode elementIndex = faces.addChild("elementIndex", eiString);
                        elementIndex.addAttribute("length", String.valueOf(eiString.length()));
                    }
                } else {
                    PsXmlLoader.addVectorList((PsXmlNode)faces, (String)"f", (PiVector[])geom.getElements(), (int)geom.getNumElements());
                }
                if (geom.getGlobalElementColor() != null) {
                    PsXmlLoader.addColor((PsXmlNode)faces, (String)"color", (Color)geom.getGlobalElementColor());
                }
                if (geom.isShowingElementBackColor()) {
                    PsXmlLoader.addColor((PsXmlNode)faces, (String)"colorBack", (Color)geom.getGlobalElementBackColor());
                }
                if (geom.getGlobalElementTagColor() != null) {
                    PsXmlLoader.addColor((PsXmlNode)faces, (String)"colorTag", (Color)geom.getGlobalElementTagColor());
                }
                double creaseAngle = geom.getCreaseAngle();
                faces.addChild("creaseAngle", creaseAngle);
                if (geom.isShowingIndices() || geom.isShowingElementLabels()) {
                    PiVector labelAtt2 = geom.getLabelAttribute(3);
                    PsXmlNode labelAttNode2 = null;
                    if (labelAtt2 != null) {
                        labelAtt2 = (PiVector)labelAtt2.clone();
                        labelAtt2.setSize(8);
                        labelAtt2.setEntry(5, 1);
                        labelAtt2.setEntry(6, (int)geom.getLabelSize(3));
                        labelAtt2.setEntry(7, geom.getLabelStyle(3));
                        labelAttNode2 = PgJvzLoader.fillLabelAttr(labelAtt2, geom.getLabelFont(3));
                    } else {
                        labelAttNode2 = PgJvzLoader.fillLabelAttr(true);
                    }
                    PsXmlLoader.addColor((PsXmlNode)labelAttNode2, (String)"color", (Color)geom.getLabelColor(3));
                    faces.addChild(labelAttNode2);
                }
                if (jvzCode == null && geom.getNeighbours() != null) {
                    PsXmlNode neighbours = elementSet.addChild("neighbours");
                    PsXmlLoader.addVectorList((PsXmlNode)neighbours, (String)"nb", (PiVector[])geom.getNeighbours(), (int)geom.getNumElements());
                }
                PsXmlNode edges = elementSet.addChild("edges");
                if (geom.getNumEdges() > 0) {
                    PsXmlLoader.addVectorList((PsXmlNode)edges, (String)"e", (PiVector[])geom.getEdges(), (int)geom.getNumEdges());
                }
                edges.addChild("thickness", geom.getGlobalEdgeSize());
                if (geom.getGlobalEdgeColor() != null) {
                    PsXmlLoader.addColor((PsXmlNode)edges, (String)"color", (Color)geom.getGlobalEdgeColor());
                }
                if (geom.getGlobalEdgeTagColor() != null) {
                    PsXmlLoader.addColor((PsXmlNode)edges, (String)"colorTag", (Color)geom.getGlobalEdgeTagColor());
                }
                if (geom.isShowingIndices() || geom.isShowingEdgeLabels()) {
                    PiVector labelAtt3 = geom.getLabelAttribute(1);
                    PsXmlNode labelAttNode3 = null;
                    if (labelAtt3 != null) {
                        labelAtt3 = (PiVector)labelAtt3.clone();
                        labelAtt3.setSize(8);
                        labelAtt3.setEntry(5, 1);
                        labelAtt3.setEntry(6, (int)geom.getLabelSize(1));
                        labelAtt3.setEntry(7, geom.getLabelStyle(1));
                        labelAttNode3 = PgJvzLoader.fillLabelAttr(labelAtt3, geom.getLabelFont(1));
                    } else {
                        labelAttNode3 = PgJvzLoader.fillLabelAttr(true);
                    }
                    PsXmlLoader.addColor((PsXmlNode)labelAttNode3, (String)"color", (Color)geom.getLabelColor(1));
                    edges.addChild(labelAttNode3);
                }
                if (bIncludeColors && geom.getElementColors() != null) {
                    if (jvzCode != null) {
                        String colString = PgJvzLoader.bytesToString(jvzCode.getElementColorCode());
                        if (colString != null) {
                            colors2 = elementSet.addChild("colors");
                            colorData = colors2.addChild("colorData", colString);
                            colorData.addAttribute("length", Integer.toString(colString.length()));
                            colors2.addAttribute("num", Integer.toString(jvzCode.getNumElements()));
                        }
                    } else {
                        colors = elementSet.addChild("colors");
                        colors.addAttribute("type", "rgb");
                        PsXmlLoader.addVectorList((PsXmlNode)colors, (String)"c", (Color[])geom.getElementColors(), (int)geom.getNumElements());
                    }
                }
                if (bIncludeColors && geom.getElementBackColors() != null) {
                    colors = elementSet.addChild("colorsBack");
                    if (jvzCode != null) {
                        String colString = PgJvzLoader.bytesToString(jvzCode.getElementBackColorCode());
                        colorData = colors.addChild("colorData", colString);
                        colorData.addAttribute("length", Integer.toString(colString.length()));
                        colors.addAttribute("num", Integer.toString(jvzCode.getNumElements()));
                    } else {
                        colors.addAttribute("type", "rgb");
                        PsXmlLoader.addVectorList((PsXmlNode)colors, (String)"c", (Color[])geom.getElementBackColors(), (int)geom.getNumElements());
                    }
                }
                if (bIncludeNormals && geom.getElementNormals() != null) {
                    PsXmlNode normals2 = elementSet.addChild("normals");
                    if (jvzCode != null) {
                        String enString = PgJvzLoader.bytesToString(jvzCode.getElementNormalCode());
                        if (enString != null) {
                            PsXmlNode cn = normals2.addChild("nz", enString);
                            cn.addAttribute("length", String.valueOf(enString.length()));
                            normals2.addAttribute("num", Integer.toString(jvzCode.getNumElements()));
                        }
                    } else {
                        PsXmlLoader.addVectorList((PsXmlNode)normals2, (String)"n", (PdVector[])geom.getElementNormals(), (int)geom.getNumElements());
                    }
                    normals2.addChild("thickness", geom.getGlobalElementNormalSize());
                    normals2.addChild("length", geom.getGlobalElementNormalLength());
                    if (geom.getGlobalElementNormalColor() != null) {
                        PsXmlLoader.addColor((PsXmlNode)normals2, (String)"color", (Color)geom.getGlobalElementNormalColor());
                    }
                }
                if (bIncludeTexture && geom.getElementTextures() != null) {
                    PsXmlNode textures = elementSet.addChild("textures");
                    textures.addAttribute("dim", String.valueOf(2));
                    if (geom.getBlendingMode() == 1) {
                        textures.addAttribute("blend", "material");
                    } else if (geom.getBlendingMode() == 2) {
                        textures.addAttribute("blend", "alpha");
                    }
                    if (geom.getFilterType() == 1) {
                        textures.addAttribute("filter", "linear");
                    } else if (geom.getFilterType() == 2) {
                        textures.addAttribute("filter", "quadratic");
                    }
                    if (geom.getTextureSide() == 1) {
                        textures.addAttribute("side", "front");
                    } else if (geom.getTextureSide() == 2) {
                        textures.addAttribute("side", "back");
                    }
                    if (jvzCode != null) {
                        String texString = PgJvzLoader.bytesToString(jvzCode.getElementTextureCode());
                        if (texString != null) {
                            PsXmlNode tex = textures.addChild("t", texString);
                            tex.addAttribute("length", String.valueOf(texString.length()));
                        }
                    } else {
                        PsXmlLoader.addVectorList((PsXmlNode)textures, (String)"t", (PdVector[][])geom.getElementTextures(), (int)geom.getNumElements());
                    }
                    if (geom.getTextureImage() != null) {
                        PsXmlNode image = textures.addChild("image");
                        image.addAttribute("repeat", "no");
                        String textureFileName = geom.getTextureImageName();
                        if (textureFileName == null) {
                            textureFileName = String.valueOf(geom.getName()) + "_texture.gif";
                        }
                        image.addChild("url", textureFileName);
                        PdVector[] imgVert = geom.getTextureImageBnd();
                        if (imgVert[0].getEntry(0) != 0.0 || imgVert[0].getEntry(1) != 0.0 || imgVert[1].getEntry(0) != 1.0 || imgVert[1].getEntry(1) != 1.0) {
                            PsXmlNode imageCoords = textures.addChild("imageCoords");
                            PsXmlLoader.addVectorList((PsXmlNode)imageCoords, (String)"p", (PdVector[])imgVert, (int)2);
                        }
                    }
                    Dimension dimRepeat = geom.getTextureTiling();
                    textures.addChild("tiling", String.valueOf(Integer.toString(dimRepeat.width)) + " " + Integer.toString(dimRepeat.height));
                }
                if (geom.isShowingBoundaries() || geom.isShowingSilhouette()) {
                    PsXmlNode boundaries = elementSet.addChild("boundaries");
                    boundaries.addChild("thickness", geom.getGlobalBndSize());
                    if (geom.getGlobalBndColor() != null) {
                        PsXmlLoader.addColor((PsXmlNode)boundaries, (String)"color", (Color)geom.getGlobalBndColor());
                    }
                    if (geom.getGlobalBndTagColor() != null) {
                        PsXmlLoader.addColor((PsXmlNode)boundaries, (String)"colorTag", (Color)geom.getGlobalBndTagColor());
                    }
                }
            }
            if (bIncludeVectors && geom.getNumVectorFields() != 0) {
                if (jvzCode != null) {
                    int novf = jvzCode.getNumStoredVectorFields();
                    int k = 0;
                    while (k < novf) {
                        PsXmlNode vectorField = geometry.addChild("vectorField");
                        if (jvzCode.getVectorFieldName(k) != null) {
                            vectorField.addAttribute("name", jvzCode.getVectorFieldName(k));
                        }
                        if (!jvzCode.isShowingVectorFields() || !jvzCode.isShowingVectorField(k)) {
                            vectorField.addAttribute("vector", "hide");
                        }
                        if (!jvzCode.isShowingVectorFieldMaterials(k)) {
                            vectorField.addAttribute("material", "hide");
                        }
                        if (jvzCode.isShowingVectorArrows(k)) {
                            vectorField.addAttribute("arrow", "show");
                        }
                        if (jvzCode.isShowingVectorColors(k)) {
                            vectorField.addAttribute("color", "show");
                        }
                        if (jvzCode.isVectorElementBased(k)) {
                            vectorField.addAttribute("base", "element");
                        } else {
                            vectorField.addAttribute("base", "vertex");
                        }
                        String vdString = PgJvzLoader.bytesToString(jvzCode.getVectorCode(k));
                        PsXmlNode vectorData = vectorField.addChild("vectorData");
                        PsXmlNode vd = vectorData.addChild("vd", vdString);
                        vd.addAttribute("length", String.valueOf(vdString.length()));
                        vectorData.addChild("thickness", jvzCode.getGlobalVectorSize(k));
                        vectorData.addChild("length", jvzCode.getGlobalVectorLength(k));
                        if (jvzCode.getGlobalVectorColor(k) != null) {
                            PsXmlLoader.addColor((PsXmlNode)vectorData, (String)"color", (Color)jvzCode.getGlobalVectorColor(k));
                        }
                        if (jvzCode.getVectorFieldColors(k) != null) {
                            colors2 = vectorField.addChild("colors");
                            colors2.addAttribute("type", "rgb");
                            PsXmlLoader.addVectorList((PsXmlNode)colors2, (String)"c", (Color[])jvzCode.getVectorFieldColors(k), (int)jvzCode.getNumVectors(k));
                        }
                        ++k;
                    }
                } else {
                    int novf = geom.getNumVectorFields();
                    int k = 0;
                    while (k < novf) {
                        PsXmlNode vectorField = geometry.addChild("vectorField");
                        if (geom.getVectorFieldName(k) != null) {
                            vectorField.addAttribute("name", geom.getVectorFieldName(k));
                        }
                        if (!geom.isShowingVectorFields() || !geom.isShowingVectorField(k)) {
                            vectorField.addAttribute("vector", "hide");
                        }
                        if (!geom.isShowingVectorFieldMaterials(k)) {
                            vectorField.addAttribute("material", "hide");
                        }
                        if (geom.isShowingVectorArrows(k)) {
                            vectorField.addAttribute("arrow", "show");
                        }
                        if (geom.isShowingVectorColors(k)) {
                            vectorField.addAttribute("color", "show");
                        }
                        if (geom.isVectorElementBased(k)) {
                            vectorField.addAttribute("base", "element");
                        } else {
                            vectorField.addAttribute("base", "vertex");
                        }
                        PdVector[] vArr = geom.getVectors(k);
                        if (vArr == null || vArr.length == 0) {
                            PsDebug.warning((String)("missing vectors of vector field[" + k + "]"));
                        } else {
                            PsXmlNode vectors = vectorField.addChild("vectors");
                            PsXmlLoader.addVectorList((PsXmlNode)vectors, (String)"v", (PdVector[])vArr, (int)vArr.length);
                            vectors.addChild("thickness", geom.getGlobalVectorSize(k));
                            vectors.addChild("length", geom.getGlobalVectorLength(k));
                            if (geom.getGlobalVectorColor(k) != null) {
                                PsXmlLoader.addColor((PsXmlNode)vectors, (String)"color", (Color)geom.getGlobalVectorColor(k));
                            }
                            if (geom.getVectorFieldColors(k) != null) {
                                colors = vectorField.addChild("colors");
                                colors.addAttribute("type", "rgb");
                                PsXmlLoader.addVectorList((PsXmlNode)colors, (String)"c", (Color[])geom.getVectorFieldColors(k), (int)vArr.length);
                            }
                        }
                        ++k;
                    }
                }
            }
            if ((bounds = geom.getBounds()) != null && bounds.length == 2) {
                PsXmlNode bndbox = geometry.addChild("bndbox");
                if (geom.isShowingBndBox()) {
                    bndbox.addAttribute("visible", "show");
                } else {
                    bndbox.addAttribute("visible", "hide");
                }
                bndbox.addChild("p", PuString.toString((double[])bounds[0].getEntries()));
                bndbox.addChild("p", PuString.toString((double[])bounds[1].getEntries()));
            }
            if ((cen = geom.getCenter()) != null) {
                PsXmlNode center = geometry.addChild("center");
                if (geom.isShowingCenter()) {
                    center.addAttribute("visible", "show");
                } else {
                    center.addAttribute("visible", "hide");
                }
                center.addChild("p", PuString.toString((double[])cen.getEntries()));
            }
            if (geom.isShowingName()) {
                PiVector labelAtt4 = geom.getLabelAttribute(5);
                labelAttNode = null;
                if (labelAtt4 != null) {
                    labelAtt4 = (PiVector)labelAtt4.clone();
                    labelAtt4.setSize(8);
                    labelAtt4.setEntry(5, 1);
                    labelAtt4.setEntry(6, (int)geom.getLabelSize(5));
                    labelAtt4.setEntry(7, geom.getLabelStyle(5));
                    labelAttNode = PgJvzLoader.fillLabelAttr(labelAtt4, geom.getLabelFont(5));
                } else {
                    labelAttNode = PgJvzLoader.fillLabelAttr(true);
                }
                PsXmlLoader.addColor((PsXmlNode)labelAttNode, (String)"color", (Color)geom.getLabelColor(5));
                geometry.addChild(labelAttNode);
            }
            if (geom.isShowingTransparency() || geom.isShowingSmoothLighting()) {
                PsXmlNode material = geometry.addChild("material");
                if (geom.isShowingSmoothLighting()) {
                    material.addAttribute("shading", "gouraud");
                }
                material.addChild("ambientIntensity", 0.2);
                PsXmlLoader.addColor((PsXmlNode)material, (String)"diffuse", (String)"color", (Color)new Color(0.8f, 0.8f, 0.8f));
                PsXmlLoader.addColor((PsXmlNode)material, (String)"emissive", (String)"color", (Color)Color.black);
                material.addChild("shininess", geom.getShininess());
                PsXmlLoader.addColor((PsXmlNode)material, (String)"specular", (String)"color", (Color)geom.getSpecularColor());
                PsXmlNode transparency = material.addChild("transparency", geom.getTransparency());
                if (geom.isShowingTransparency()) {
                    transparency.addAttribute("visible", "show");
                }
            }
            boolean bHasModel = geom.hasModelMatrix();
            boolean bl = bHasAmbient = geom.hasAmbientMatrix() || geom.getAmbientSpace() != 1 && geom.getAmbientSpace() != 3;
            if (bHasModel || bHasAmbient) {
                PsXmlNode transform = geometry.addChild("transform");
                if (bHasModel) {
                    PsXmlLoader.addMatrix((PsXmlNode)transform, (String)"modelMat", (PdMatrix)geom.getModelMatrix());
                }
                if (bHasAmbient) {
                    int ambSpace = geom.getAmbientSpace();
                    int ambProj = geom.getAmbientProjection();
                    int ambientDim = geom.getDimOfVertices();
                    PsXmlNode ambient = transform.addChild("ambient");
                    ambient.addAttribute("dim", String.valueOf(ambientDim));
                    if (ambSpace == 0 | ambSpace == 1 | ambSpace == 3 | ambSpace == 6 | ambSpace == 9) {
                        ambient.addAttribute("space", "euclidean");
                    } else if (ambSpace == 2 | ambSpace == 4 | ambSpace == 7 | ambSpace == 10) {
                        ambient.addAttribute("space", "spherical");
                    } else if (ambSpace == 5 | ambSpace == 8 | ambSpace == 11) {
                        ambient.addAttribute("space", "hyperbolic");
                    } else {
                        PsDebug.warning((String)("unknown ambient space = " + ambSpace));
                        return null;
                    }
                    if (ambProj == 0) {
                        ambient.addAttribute("projection", "parallel");
                    } else if (ambProj == 1) {
                        ambient.addAttribute("projection", "stereographic");
                    } else if (ambProj == 1) {
                        ambient.addAttribute("projection", "poincare");
                    } else if (ambProj == 2) {
                        ambient.addAttribute("projection", "klein");
                    } else if (ambProj == 3) {
                        ambient.addAttribute("projection", "uhs");
                    } else if (ambProj == 2) {
                        ambient.addAttribute("projection", "klein");
                    } else {
                        PsDebug.warning((String)("unknown ambient projection = " + ambProj));
                        return null;
                    }
                    PsXmlLoader.addMatrix((PsXmlNode)ambient, (String)"ambientMat", (PdMatrix)geom.getAmbientMatrix());
                    PsXmlLoader.addMatrix((PsXmlNode)ambient, (String)"ambientInvMat", (PdMatrix)geom.getAmbientInvMatrix());
                }
            }
            ++i;
        }
        return src;
    }

    protected static int parseVisibility(String attr) {
        if (attr == null) {
            return -1;
        }
        if (attr.equalsIgnoreCase("show")) {
            return 1;
        }
        return 0;
    }

    protected static String fillVisibility(boolean isVisible) {
        if (isVisible) {
            return "show";
        }
        return "hide";
    }

    protected static PsXmlNode fillLabelAttr(boolean isVisible) {
        PsXmlNode labelAtt = new PsXmlNode("labelAtt");
        labelAtt.addAttribute("visible", PgJvzLoader.fillVisibility(isVisible));
        return labelAtt;
    }

    protected static PsXmlNode fillLabelAttr(PiVector att, String name) {
        int xOffset = att.getEntry(0);
        int yOffset = att.getEntry(1);
        int horAlign = att.getEntry(2);
        int verAlign = att.getEntry(3);
        int font = att.getEntry(4);
        int isVisible = att.getEntry(5);
        int size = att.getEntry(6);
        int style = att.getEntry(7);
        PsXmlNode labelAtt = new PsXmlNode("labelAtt");
        labelAtt.addAttribute("visible", PgJvzLoader.fillVisibility(isVisible == 1));
        switch (horAlign) {
            case 0: {
                labelAtt.addAttribute("horAlign", "head");
                break;
            }
            case 1: {
                labelAtt.addAttribute("horAlign", "center");
                break;
            }
            case 2: {
                labelAtt.addAttribute("horAlign", "tail");
            }
        }
        switch (verAlign) {
            case 2: {
                labelAtt.addAttribute("verAlign", "top");
                break;
            }
            case 1: {
                labelAtt.addAttribute("verAlign", "middle");
                break;
            }
            case 0: {
                labelAtt.addAttribute("verAlign", "bottom");
            }
        }
        switch (font) {
            case 0: {
                labelAtt.addAttribute("font", "text");
                break;
            }
            case 1: {
                labelAtt.addAttribute("font", "fixed");
                break;
            }
            case 3: {
                labelAtt.addAttribute("font", "header2");
                break;
            }
            case 4: {
                labelAtt.addAttribute("font", "header4");
                break;
            }
            case 2: {
                labelAtt.addAttribute("font", "menu");
            }
        }
        labelAtt.addChild("xOffset", String.valueOf(xOffset));
        labelAtt.addChild("yOffset", String.valueOf(yOffset));
        if (name != null) {
            labelAtt.addAttribute("name", name);
            switch (style) {
                case 0: {
                    labelAtt.addAttribute("style", "plain");
                    break;
                }
                case 1: {
                    labelAtt.addAttribute("style", "bold");
                    break;
                }
                case 2: {
                    labelAtt.addAttribute("style", "italic");
                    break;
                }
                case 3: {
                    labelAtt.addAttribute("style", "bold+italic");
                }
            }
            labelAtt.addChild("size", String.valueOf(size));
        }
        return labelAtt;
    }

    protected PiVector parseLabelAtt(PsXmlNode attr) {
        String font;
        if (attr == null) {
            return null;
        }
        PiVector labelAtt = new PiVector(8);
        String visible = attr.getAttribute("visible");
        if (visible != null && "hide".equalsIgnoreCase(visible)) {
            labelAtt.setEntry(5, 0);
        } else {
            labelAtt.setEntry(5, 1);
        }
        String horAlign = attr.getAttribute("horAlign");
        if (horAlign == null || "head".equalsIgnoreCase(horAlign)) {
            labelAtt.setEntry(2, 0);
        } else if ("center".equalsIgnoreCase(horAlign)) {
            labelAtt.setEntry(2, 1);
        } else if ("tail".equalsIgnoreCase(horAlign)) {
            labelAtt.setEntry(2, 2);
        }
        String verAlign = attr.getAttribute("verAlign");
        if ("bottom".equalsIgnoreCase(verAlign)) {
            labelAtt.setEntry(3, 0);
            if (this.m_jvVersion > 221000 && this.m_jvVersion < 299030) {
                PsDebug.warning((String)"Encountered void use of attribute \"verAlign\" produced with a JavaView beta.\n\tSave JVX file with a newer JavaView such as v.2.99.030");
                labelAtt.setEntry(3, 2);
            }
        } else if (verAlign == null || "middle".equalsIgnoreCase(verAlign)) {
            labelAtt.setEntry(3, 1);
        } else if ("top".equalsIgnoreCase(verAlign)) {
            labelAtt.setEntry(3, 2);
            if (this.m_jvVersion > 221000 && this.m_jvVersion < 299030) {
                PsDebug.warning((String)"Encountered void use of attribute \"verAlign\" produced with a JavaView beta.\n\tSave JVX file with a newer JavaView such as v.2.99.030");
                labelAtt.setEntry(3, 0);
            }
        } else if ("head".equalsIgnoreCase(verAlign)) {
            PsDebug.warning((String)"Encountered void use of attribute \"verAlign\".\n\tSave JVX file with a newer JavaView such as v.2.99.030");
            labelAtt.setEntry(3, 1);
        }
        if ((font = attr.getAttribute("font")) == null) {
            labelAtt.setEntry(4, 0);
        } else if ("text".equalsIgnoreCase(font)) {
            labelAtt.setEntry(4, 0);
        } else if ("fixed".equalsIgnoreCase(font)) {
            labelAtt.setEntry(4, 1);
        } else if ("header2".equalsIgnoreCase(font)) {
            labelAtt.setEntry(4, 3);
        } else if ("header4".equalsIgnoreCase(font)) {
            labelAtt.setEntry(4, 4);
        } else if ("menu".equalsIgnoreCase(font)) {
            labelAtt.setEntry(4, 2);
        }
        try {
            PsXmlNode yOffset;
            PsXmlNode xOffset = PsXmlSrc.getRsrcNode((PsXmlNode)attr, (String)"xOffset");
            if (xOffset != null) {
                labelAtt.setEntry(0, Integer.parseInt(xOffset.getContent()));
            }
            if ((yOffset = PsXmlSrc.getRsrcNode((PsXmlNode)attr, (String)"yOffset")) != null) {
                labelAtt.setEntry(1, Integer.parseInt(yOffset.getContent()));
            }
        }
        catch (NumberFormatException e) {
            PsDebug.warning((String)"wrong format parsing offset");
            return null;
        }
        String name = attr.getAttribute("name");
        if (name != null) {
            String style = attr.getAttribute("style");
            if (style == null) {
                labelAtt.setEntry(7, 0);
            } else if (style.equals("plain")) {
                labelAtt.setEntry(7, 0);
            } else if (style.equals("bold")) {
                labelAtt.setEntry(7, 1);
            } else if (style.equals("italic")) {
                labelAtt.setEntry(7, 2);
            } else if (style.equals("bold+italic")) {
                labelAtt.setEntry(7, 3);
            }
            if (attr.hasChild("size")) {
                int size = (int)PsXmlSrc.getRsrcAsDouble((PsXmlNode)attr, (String)"size");
                labelAtt.setEntry(6, size);
            } else {
                labelAtt.setEntry(6, 12);
            }
        }
        return labelAtt;
    }

    public static String[][] parseFunList(PsXmlNode parentNode, String type, String[] attr) {
        PsXmlNode[] p = PsXmlSrc.getRsrcNodes((PsXmlNode)parentNode, (String)type);
        if (p == null || p.length == 0) {
            return null;
        }
        String[][] vertex = new String[p.length][];
        int j = 0;
        while (j < p.length) {
            String pStr = p[j].getContent();
            if (pStr != null) {
                String[] comp = PuString.splitString((String)pStr, (char)' ');
                vertex[j] = new String[comp.length];
                int k = 0;
                while (k < comp.length) {
                    vertex[j][k] = comp[k];
                    ++k;
                }
            }
            ++j;
        }
        return vertex;
    }

    public static String bytesToString(byte[] message) {
        if (message == null) {
            return null;
        }
        int strlen = (int)Math.ceil((double)message.length * 8.0 / 6.0);
        StringBuffer str = new StringBuffer((int)Math.ceil((double)message.length * 8.0 / 6.0));
        int mask1 = 252;
        int mask2 = 0;
        int i = 0;
        int val = 0;
        while (str.length() < strlen) {
            val = i < message.length - 1 ? (mask1 & message[i]) << 8 | mask2 & message[i + 1] : (mask1 & message[i]) << 8;
            switch (mask1) {
                case 252: {
                    val >>= 10;
                    mask1 = 3;
                    mask2 = 240;
                    break;
                }
                case 3: {
                    val >>= 4;
                    ++i;
                    mask1 = 15;
                    mask2 = 192;
                    break;
                }
                case 15: {
                    val >>= 6;
                    ++i;
                    mask1 = 63;
                    mask2 = 0;
                    break;
                }
                case 63: {
                    val >>= 8;
                    ++i;
                    mask1 = 252;
                    mask2 = 0;
                    break;
                }
                default: {
                    return null;
                }
            }
            str.append(BASE64TABLE[0xFFFF & val]);
        }
        return str.toString();
    }

    public static byte[] stringToBytes(String message) {
        if (message == null) {
            return null;
        }
        int bytes = 6 * message.length() / 8;
        byte[] code = new byte[bytes + 2];
        int index = 0;
        int offset = 2;
        int i = 0;
        while (i < message.length()) {
            int c = PgJvzLoader.base64ToInt(message.charAt(i));
            if (offset == 0 || offset == 2) {
                int n = index;
                code[n] = (byte)(code[n] | c << offset);
            } else {
                int n = index;
                code[n] = (byte)(code[n] | c >> 8 - offset);
                int n2 = index + 1;
                code[n2] = (byte)(code[n2] | c << offset);
            }
            if ((offset += 2) == 8) {
                offset = 0;
            }
            if (offset != 4) {
                ++index;
            }
            ++i;
        }
        byte[] code2 = new byte[bytes];
        System.arraycopy(code, 0, code2, 0, bytes);
        return code2;
    }

    private static int base64ToInt(char c) {
        char i = c;
        if (i == '+') {
            return 0;
        }
        if (i <= '9') {
            return i - 46;
        }
        if (i <= 'Z') {
            return i - 53;
        }
        return i - 59;
    }
}

