/*
 * Decompiled with CFR 0.152.
 */
package dev.loader;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import jv.loader.PgAbstractLoader;
import jv.number.PuDouble;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.project.PgJvxSrc;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public final class PgInpLoader
extends PgAbstractLoader {
    private static final int NODE = 0;
    private static final int FACE = 1;
    protected int m_numVertices = 0;
    protected int m_numElements = 0;
    protected Vector m_vVertex;
    protected int m_dimOfElements = -1;
    protected Vector m_vElement;

    public static PgJvxSrc[] read(String fileName) {
        BufferedReader in = PsUtil.open((String)fileName);
        if (in == null) {
            PsDebug.warning((String)("could not open = " + fileName));
            return null;
        }
        PgInpLoader loader = new PgInpLoader();
        PgJvxSrc[] geomArr = loader.read(in);
        try {
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (geomArr != null && geomArr.length > 0 && geomArr[0] != null) {
            geomArr[0].setName(PsUtil.getFileBaseName((String)fileName));
        }
        return geomArr;
    }

    public PgJvxSrc[] read(BufferedReader in) {
        if (in == null) {
            PsDebug.warning((String)"missing reader");
            return null;
        }
        if (!this.parse(in)) {
            PsDebug.warning((String)"error during parsing of reader");
            return null;
        }
        PgJvxSrc geom = new PgJvxSrc();
        geom.setEnabledInstanceSharing(true);
        geom.setType(33);
        PiVector index = new PiVector(this.m_numVertices);
        if (this.m_numVertices > 0) {
            PdVector v = (PdVector)this.m_vVertex.elementAt(0);
            PdVector[] vertex = new PdVector[this.m_numVertices];
            int i = 0;
            Enumeration elements = this.m_vVertex.elements();
            while (elements.hasMoreElements()) {
                vertex[i] = (PdVector)elements.nextElement();
                index.m_data[i] = (int)vertex[i].getFirstEntry();
                vertex[i].removeEntry(0);
                ++i;
            }
            geom.setNumVertices(this.m_numVertices);
            geom.setDimOfVertices(v.getSize());
            geom.setVertices(vertex);
            this.m_vVertex = null;
        }
        if (this.m_numElements > 0) {
            geom.setDimOfElements(this.m_dimOfElements);
            geom.setNumElements(this.m_numElements);
            PiVector[] element = new PiVector[this.m_numElements];
            int i = 0;
            Enumeration elements = this.m_vElement.elements();
            while (elements.hasMoreElements()) {
                PiVector e;
                element[i] = e = (PiVector)elements.nextElement();
                e.removeEntry(0);
                int j = 0;
                while (j < e.getSize()) {
                    e.m_data[j] = index.getIndexOf(e.m_data[j]);
                    ++j;
                }
                ++i;
            }
            geom.setElements(element);
            this.m_vElement = null;
        }
        geom.showEdges(false);
        geom.showElements(true);
        geom.setEnabledInstanceSharing(false);
        return new PgJvxSrc[]{geom};
    }

    protected boolean parse(BufferedReader bufReader) {
        int maxFaceSize = 200;
        int maxVertexSize = 4;
        double[] coord = new double[maxVertexSize];
        int[] face = new int[maxFaceSize];
        this.m_vVertex = new Vector();
        this.m_vElement = new Vector();
        this.m_numVertices = 0;
        this.m_numElements = 0;
        int mode = -1;
        int lineNo = 0;
        try {
            String line;
            while ((line = bufReader.readLine()) != null) {
                String word;
                int num;
                StringTokenizer st = new StringTokenizer(line);
                ++lineNo;
                if (line.startsWith("**")) continue;
                if (line.startsWith("*NODE")) {
                    mode = 0;
                    continue;
                }
                if (line.startsWith("*ELEMENT")) {
                    mode = 1;
                    continue;
                }
                if (mode == 0) {
                    num = 0;
                    while (st.hasMoreTokens()) {
                        word = st.nextToken(", ");
                        coord[num] = PuDouble.parseDouble((String)word);
                        ++num;
                    }
                    if (num > 0) {
                        ++this.m_numVertices;
                        PdVector v = new PdVector(num);
                        v.copy(coord, num);
                        this.m_vVertex.addElement(v);
                    } else {
                        PsDebug.warning((String)("vertex with no coords in line=" + lineNo));
                    }
                }
                if (mode != 1) continue;
                num = 0;
                while (st.hasMoreTokens()) {
                    word = st.nextToken().trim();
                    if (word.endsWith(",")) {
                        word = word.substring(0, word.length() - 1);
                    }
                    face[num] = Integer.parseInt(word);
                    ++num;
                }
                if (num <= 0) continue;
                PiVector f = new PiVector(num);
                f.copy(face, num);
                this.m_vElement.addElement(f);
                ++this.m_numElements;
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }
}

