/*
 * Decompiled with CFR 0.152.
 */
package dev.loader;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.BitSet;
import java.util.StringTokenizer;
import jv.loader.PgLoaderIf;
import jv.loader.PvDisplayOption;
import jv.number.PuDouble;
import jv.object.PsDebug;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PgGpLoader
implements PgLoaderIf {
    private int m_numTags;
    private String m_keyString;
    private int m_lineNo;
    protected PgJvxSrc[] m_geomArr;

    public boolean write(Writer writer, PgJvxSrc[] geomArr) throws IOException {
        if (geomArr == null || geomArr.length == 0 || geomArr[0] == null) {
            PsDebug.warning((String)"missing geometry");
            return false;
        }
        writer.write("// GP geometry and parameterization file\n");
        writer.write("// File format by Matthias Nieser and Ulrich Reitebuch (2010)\n\n");
        int numGeometries = geomArr.length;
        writer.write("#" + numGeometries + " geometries\n\n");
        int g = 0;
        while (g < numGeometries) {
            this.writeGeometry(writer, geomArr[g]);
            ++g;
        }
        return true;
    }

    private void writeGeometry(Writer writer, PgJvxSrc geom) throws IOException {
        PiVector[] elements;
        int num = 0;
        ++num;
        if (geom.getVertices() != null) {
            ++num;
        }
        if (geom.getElements() != null) {
            ++num;
        }
        writer.write("#" + num + " elementset\n");
        writer.write("Name: " + geom.getName() + "\n");
        writer.write(10);
        PdVector[] vertices = geom.getVertices();
        if (vertices != null) {
            int numV = vertices.length;
            writer.write("#" + numV + " vertices\n");
            int v = 0;
            while (v < numV) {
                PdVector vertex = vertices[v];
                int dim = vertex.getSize();
                int i = 0;
                while (i < dim) {
                    writer.write(String.valueOf(i > 0 ? " " : "") + vertex.m_data[i]);
                    ++i;
                }
                writer.write(10);
                ++v;
            }
            writer.write(10);
        }
        if ((elements = geom.getElements()) != null) {
            int numE = elements.length;
            writer.write("#" + numE + " elements\n");
            int e = 0;
            while (e < numE) {
                PiVector element = elements[e];
                int dim = element.getSize();
                int i = 0;
                while (i < dim) {
                    writer.write(String.valueOf(i > 0 ? " " : "") + element.m_data[i]);
                    ++i;
                }
                writer.write(10);
                ++e;
            }
            writer.write(10);
        }
    }

    private PgJvxSrc[] parse(BufferedReader in) throws IOException {
        this.m_lineNo = 0;
        String line = this.readLine(in);
        if (!this.parseLine(line) || !this.m_keyString.equals("geometries")) {
            this.error("geometries tag expected");
            return null;
        }
        int numGeometries = this.m_numTags;
        PgJvxSrc[] geoms = new PgJvxSrc[numGeometries];
        int i = 0;
        while (i < numGeometries) {
            line = this.readLine(in);
            if (!this.parseLine(line) || !this.m_keyString.equals("elementset")) {
                this.error("geometry tag expected");
                return null;
            }
            geoms[i] = new PgJvxSrc(3);
            if (!this.parseGeometry(in, this.m_numTags, geoms[i])) {
                return null;
            }
            ++i;
        }
        return geoms;
    }

    private boolean parseGeometry(BufferedReader in, int numTags, PgJvxSrc geom) throws IOException {
        int tag = 0;
        while (tag < numTags) {
            String line = this.readLine(in);
            if (line == null) {
                this.error("Geometry expected");
                return false;
            }
            if (this.parseLine(line)) {
                int i;
                int dim;
                StringTokenizer t;
                if (this.m_keyString.equals("vertices")) {
                    int numV = this.m_numTags;
                    geom.setNumVertices(numV);
                    int v = 0;
                    while (v < numV) {
                        line = this.readLine(in);
                        if (line == null) {
                            this.error("vertex expected");
                            return false;
                        }
                        t = new StringTokenizer(line);
                        dim = t.countTokens();
                        PdVector vertex = new PdVector(dim);
                        i = 0;
                        while (i < dim) {
                            try {
                                vertex.m_data[i] = PuDouble.parseDouble((String)t.nextToken());
                            }
                            catch (NumberFormatException e) {
                                this.error("Invalid vertex format");
                                return false;
                            }
                            ++i;
                        }
                        geom.setVertex(v, vertex);
                        ++v;
                    }
                } else if (this.m_keyString.equals("elements")) {
                    int numE = this.m_numTags;
                    geom.setNumElements(numE);
                    int e = 0;
                    while (e < numE) {
                        line = this.readLine(in);
                        if (line == null) {
                            this.error("element expected");
                            return false;
                        }
                        t = new StringTokenizer(line);
                        dim = t.countTokens();
                        PiVector element = new PiVector(dim);
                        i = 0;
                        while (i < dim) {
                            try {
                                element.m_data[i] = Integer.parseInt(t.nextToken());
                            }
                            catch (NumberFormatException f) {
                                this.error("Invalid vertex format");
                                return false;
                            }
                            ++i;
                        }
                        geom.setElement(e, element);
                        ++e;
                    }
                } else if (!this.skip(in, this.m_numTags)) {
                    return false;
                }
            } else if (line.startsWith("Name: ")) {
                String name = line.substring(6);
                geom.setName(name);
            }
            ++tag;
        }
        return true;
    }

    private boolean skip(BufferedReader in, int numTags) throws IOException {
        int i = 0;
        while (i < numTags) {
            int num;
            String line = this.readLine(in);
            if (line == null) {
                this.error("tag expected");
                return false;
            }
            if (this.parseLine(line) && !this.skip(in, num = this.m_numTags)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void error(String errorMsg) {
        PsDebug.warning((String)("Error in line " + this.m_lineNo + ": " + errorMsg));
    }

    private boolean parseLine(String line) {
        if (!line.startsWith("#")) {
            return false;
        }
        int ind = line.indexOf(32);
        if (ind < 0 || line.length() <= ind - 1) {
            return false;
        }
        try {
            this.m_numTags = Integer.parseInt(line.substring(1, ind));
        }
        catch (NumberFormatException e) {
            return false;
        }
        this.m_keyString = line.substring(ind + 1);
        return true;
    }

    private String readLine(BufferedReader in) throws IOException {
        String line;
        do {
            ++this.m_lineNo;
            line = in.readLine();
            if (line != null) continue;
            return null;
        } while ((line = line.trim()).length() == 0 || line.startsWith("//"));
        return line;
    }

    public boolean load(BufferedReader in) {
        PgJvxSrc[] geoms;
        block7: {
            if (in == null) {
                PsDebug.warning((String)"missing reader");
                return false;
            }
            geoms = this.parse(in);
            if (geoms != null) break block7;
            PsDebug.warning((String)"error during parsing of reader");
            return false;
        }
        try {
            int i = 0;
            while (i < geoms.length) {
                PgJvxSrc geom = geoms[i];
                if (geom.getNumElements() == 0) {
                    geom.setType(30);
                    geom.showVertices(true);
                    geom.setGlobalVertexSize(1.0);
                } else {
                    geom.setType(33);
                    geom.assureNeighbours();
                    geom.showEdges(true);
                    geom.showElements(true);
                }
                ++i;
            }
            this.m_geomArr = geoms;
        }
        catch (IOException e) {
            PsDebug.warning((String)("Cannot read file: " + e.getMessage()));
            return false;
        }
        return true;
    }

    public boolean write(DataOutputStream writer, PgJvxSrc[] geomArr) throws IOException {
        return this.write(new OutputStreamWriter(writer), geomArr);
    }

    public boolean isEnabledOptimization() {
        return false;
    }

    public void setGeometryOption(BitSet option) {
    }

    public PvDisplayOption getDisplayOption() {
        return null;
    }

    public void setDisplayOption(PvDisplayOption option) {
    }

    public boolean isAnimation() {
        return false;
    }

    public void setAnimation(boolean flag) {
    }

    public PgJvxSrc[][] getAnimations() {
        return null;
    }

    public PgJvxSrc[] getGeometries() {
        return this.m_geomArr;
    }

    public PgGeometryIf[] getSpecializedGeometries() {
        return null;
    }

    public PgJvxSrc[] read(BufferedReader in) {
        if (!this.load(in)) {
            return null;
        }
        return this.getGeometries();
    }
}

