/*
 * Decompiled with CFR 0.152.
 */
package dev.loader;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import jv.loader.PgAbstractLoader;
import jv.number.PuDouble;
import jv.number.PuString;
import jv.object.PsDebug;
import jv.project.PgJvxSrc;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PgFemLoader
extends PgAbstractLoader {
    protected boolean parse(BufferedReader bufReader, PgJvxSrc geom) {
        block12: {
            if (bufReader == null) {
                return false;
            }
            if (bufReader.ready()) break block12;
            return false;
        }
        try {
            String line = bufReader.readLine();
            while (!line.startsWith("$NGR")) {
                line = bufReader.readLine();
            }
            line = bufReader.readLine();
            String[] actLine = PuString.splitString((String)line, (char)' ');
            int numElements = Integer.parseInt(actLine[1]);
            Color[] elemColors = new Color[numElements];
            line = bufReader.readLine();
            actLine = PuString.splitString((String)line, (char)' ');
            int[] elemGroups = new int[Integer.parseInt(actLine[1])];
            line = bufReader.readLine();
            line = bufReader.readLine();
            int i = 0;
            while (i < elemGroups.length) {
                line = bufReader.readLine();
                actLine = PuString.splitString((String)line, (char)' ');
                elemGroups[i] = Integer.parseInt(actLine[3]);
                ++i;
            }
            while (!line.startsWith("$EKN")) {
                line = bufReader.readLine();
            }
            line = bufReader.readLine();
            line = bufReader.readLine();
            geom.setNumElements(numElements);
            PiVector[] elems = geom.getElements();
            int i2 = 0;
            while (i2 < numElements) {
                line = bufReader.readLine();
                actLine = PuString.splitString((String)line, (char)' ');
                int j = 2;
                while (j < actLine.length) {
                    elems[i2].addEntry(Integer.parseInt(actLine[j]) - 1);
                    ++j;
                }
                elemColors[i2] = new Color(elemGroups[Integer.parseInt(actLine[1]) - 1]);
                ++i2;
            }
            while (!line.startsWith("$COOR")) {
                line = bufReader.readLine();
            }
            line = bufReader.readLine();
            actLine = PuString.splitString((String)line, (char)' ');
            int numVertices = Integer.parseInt(actLine[1]);
            line = bufReader.readLine();
            line = bufReader.readLine();
            line = bufReader.readLine();
            geom.setNumVertices(numVertices);
            PdVector[] vertices = geom.getVertices();
            int i3 = 0;
            while (i3 < numVertices) {
                line = bufReader.readLine();
                actLine = PuString.splitString((String)line, (char)' ');
                int j = 0;
                while (j < 3) {
                    vertices[i3].setEntry(j, PuDouble.parseDouble((String)actLine[j + 2]));
                    ++j;
                }
                ++i3;
            }
            geom.setElementColors(elemColors);
        }
        catch (IOException ioe) {
            PsDebug.warning((String)"Error during parsing of file. Loading aborted.");
        }
        return true;
    }

    public boolean write(Writer writer, PgJvxSrc[] geomArr) throws IOException {
        int colorCorrection = 0x1000000;
        if (geomArr == null || geomArr.length == 0 || geomArr[0] == null) {
            PsDebug.warning((String)"missing geometry");
            return false;
        }
        PgJvxSrc geom = geomArr[0];
        PiVector[] elements = geom.getElements();
        Vector<Integer> groupsLength = new Vector<Integer>();
        Vector<Integer> groupsColor = new Vector<Integer>();
        Color[] colors = geom.getElementColors();
        int[] group = new int[elements.length];
        groupsLength.addElement(new Integer(elements[0].m_data.length));
        groupsColor.addElement(new Integer(colors[0].getRGB() + colorCorrection));
        int i = 1;
        while (i < elements.length) {
            int l = new Integer(elements[i].m_data.length);
            int c = new Integer(colors[i].getRGB() + colorCorrection);
            int k = 0;
            boolean foundGroup = false;
            while (k < groupsLength.size()) {
                int gLength = (Integer)groupsLength.elementAt(k);
                int gColor = (Integer)groupsLength.elementAt(k);
                if (gLength == l && gColor == c) {
                    group[i] = k;
                    foundGroup = true;
                    break;
                }
                ++k;
            }
            if (!foundGroup) {
                groupsLength.addElement(new Integer(l));
                groupsColor.addElement(new Integer(c));
                group[i] = k;
            }
            ++i;
        }
        writer.write("=======================================================================================\r\n");
        writer.write("\r\n");
        writer.write("$NGR \r\n");
        writer.write(" ELEMENTE:" + this.padLeft(Integer.toString(elements.length), 13, ' ') + "\r\n");
        writer.write(" ELEMENTGRUPPEN:" + this.padLeft(Integer.toString(groupsLength.size()), 7, ' ') + "\r\n");
        writer.write("\r\n");
        writer.write("   ELEMENTGRUPPE        TYP          MATERIALGESETZ         FARBE\r\n");
        i = 0;
        while (i < groupsLength.size()) {
            writer.write(String.valueOf(this.padLeft(Integer.toString(i + 1), 9, ' ')) + "               " + this.padRight((Integer)groupsLength.elementAt(i) == 3 ? "SHEL3" : "SHEL4", 13, ' ') + "ISOTROP" + this.padLeft(((Integer)groupsColor.elementAt(i)).toString(), 21, ' ') + "\r\n");
            ++i;
        }
        writer.write("\r\n");
        writer.write("=======================================================================================\r\n");
        writer.write("\r\n");
        writer.write("$EKN \r\n");
        writer.write("  NELE  NGR   EK1    EK2    EK3    EK4    EK5    EK6    EK7    EK8    EK9   EK10 \r\n");
        writer.write("             EK11   EK12   EK13   EK14   EK15   EK16   EK17   EK18   EK19   EK20 \r\n");
        i = 0;
        while (i < elements.length) {
            int n = elements[i].getSize();
            StringBuffer s = new StringBuffer();
            s.append(this.padLeft(Integer.toString(i + 1), 6, ' '));
            s.append(this.padLeft(Integer.toString(group[i] + 1), 4, ' '));
            int j = 0;
            while (j < n && j < 10) {
                s.append(this.padLeft(Integer.toString(elements[i].getEntry(j) + 1), 7, ' '));
                ++j;
            }
            writer.write(String.valueOf(s.toString()) + "\r\n");
            if (n > 10) {
                StringBuffer s2 = new StringBuffer();
                s2.append(this.padLeft(Integer.toString(elements[i].getEntry(10) + 1), 17, ' '));
                if (n > 11) {
                    int j2 = 11;
                    while (j2 < n) {
                        s.append(this.padLeft(Integer.toString(elements[i].getEntry(j2) + 1), 7, ' '));
                        ++j2;
                    }
                }
                writer.write(String.valueOf(s2.toString()) + "\r\n");
            }
            ++i;
        }
        writer.write("\r\n");
        PdVector[] vertices = geom.getVertices();
        writer.write("=======================================================================================\r\n");
        writer.write("\r\n");
        writer.write("$COOR \r\n");
        writer.write(" GESAMTKNOTEN:" + this.padLeft(Integer.toString(vertices.length), 8, ' ') + "\r\n");
        writer.write(" ECKKNOTEN:" + this.padLeft(Integer.toString(vertices.length), 11, ' ') + "\r\n");
        writer.write("\r\n");
        writer.write("   LFN   NODE          X              Y              Z\r\n");
        int i2 = 0;
        while (i2 < vertices.length) {
            String s1 = this.trimDouble(vertices[i2].m_data[0], 13);
            String s2 = this.trimDouble(vertices[i2].m_data[1], 13);
            String s3 = this.trimDouble(vertices[i2].m_data[2], 13);
            writer.write(String.valueOf(this.padLeft(Integer.toString(i2 + 1), 6, ' ')) + this.padLeft(Integer.toString(i2 + 1), 7, ' ') + "    " + this.padLeft(s1, 13, ' ') + "  " + this.padLeft(s2, 13, ' ') + "  " + this.padLeft(s3, 13, ' ') + "\r\n");
            ++i2;
        }
        writer.write("\r\n");
        writer.write("=======================================================================================\r\n");
        return true;
    }

    public PgJvxSrc[] read(BufferedReader in) {
        if (in == null) {
            PsDebug.warning((String)"missing reader");
            return null;
        }
        PgJvxSrc geom = new PgJvxSrc();
        if (!this.parse(in, geom)) {
            PsDebug.warning((String)"error during parsing of reader");
            return null;
        }
        geom.setType(33);
        geom.showEdges(true);
        geom.showElements(true);
        geom.showElementColors(true);
        this.m_geomArr = new PgJvxSrc[]{geom};
        return this.m_geomArr;
    }

    public String padLeft(String s, int n, char c) {
        int strLength;
        StringBuffer buf = new StringBuffer();
        int i = strLength = s.length();
        while (i < n) {
            buf.append(c);
            ++i;
        }
        buf.append(s);
        return buf.toString();
    }

    public String padRight(String s, int n, char c) {
        StringBuffer buf = new StringBuffer();
        int strLength = s.length();
        buf.append(s);
        int i = strLength;
        while (i < n) {
            buf.append(c);
            ++i;
        }
        return buf.toString();
    }

    public String trimDouble(double d, int n) {
        String s1 = Double.toString(d);
        if (s1.length() > n) {
            String s2 = s1.substring(0, n);
            int i = s1.length() - 1;
            while (i > s1.length() - 5) {
                if (s1.charAt(i) == 'E') {
                    s2 = s2.substring(0, s2.length() - (s1.length() - i));
                    s2 = s2.concat(s1.substring(i, s1.length()));
                    return s2;
                }
                --i;
            }
            return s2;
        }
        return this.padLeft(s1, n, ' ');
    }
}

