/*
 * Decompiled with CFR 0.152.
 */
package dev.geom;

import jv.geom.PgElementSet;
import jv.number.PuBoolean;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgVertexStar;
import jvx.geom.PwRefineElementSet;
import jvx.project.PjWorkshop;

public class PwWeave
extends PjWorkshop {
    protected PgElementSet m_elementSet;
    protected PuDouble m_faceParameter = new PuDouble("Face", (PsUpdateIf)this);
    protected PuDouble m_distParameter = new PuDouble("Dist", (PsUpdateIf)this);
    protected PuDouble m_heightParameter = new PuDouble("Height", (PsUpdateIf)this);
    protected PuInteger m_iterations = new PuInteger("Iterations (P)", (PsUpdateIf)this);
    protected PuDouble m_damping = new PuDouble("Damping (P)", (PsUpdateIf)this);
    protected PuBoolean m_bLowerToZero;
    protected PuBoolean m_bNormalOnly;
    protected PuBoolean m_dual = new PuBoolean("dual (O+E)", (PsUpdateIf)this);
    protected PuBoolean m_bInterpolateEdges;
    protected PuBoolean m_bBilinear;
    protected PuBoolean m_bPlanarFace;
    protected PuBoolean m_bIndentCenter;
    private boolean m_bApplyModeling = true;
    public static final int OFFSET_CONNECT = 0;
    public static final int PLANAR_QUADS = 1;
    public static final int ELEVATION = 2;
    public static final int EXTEND = 3;
    public int m_mode = 0;
    private static boolean m_bRefineAlways = true;

    public PwWeave() {
        super(PsConfig.getMessage((int)51068));
        this.m_bLowerToZero = new PuBoolean("low = 0 (O+E+P+X)", (PsUpdateIf)this);
        this.m_bNormalOnly = new PuBoolean("Optimize normal only (P)", (PsUpdateIf)this);
        this.m_bInterpolateEdges = new PuBoolean("interpolate edges (O)", (PsUpdateIf)this);
        this.m_bBilinear = new PuBoolean("bilinear (O)", (PsUpdateIf)this);
        this.m_bPlanarFace = new PuBoolean("vertex normal (O+E)", (PsUpdateIf)this);
        this.m_bIndentCenter = new PuBoolean("Indent center (P)", (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == PwWeave.class) {
            this.init();
        }
    }

    public void init() {
        this.m_faceParameter.setDefBounds(0.0, 1.0, 0.01, 0.05);
        this.m_faceParameter.setDefValue(0.75);
        this.m_faceParameter.init();
        this.m_distParameter.setDefBounds(0.0, 1.0, 0.01, 0.05);
        this.m_distParameter.setDefValue(0.25);
        this.m_distParameter.init();
        this.m_heightParameter.setDefBounds(0.0, 1.0, 0.01, 0.05);
        this.m_heightParameter.setDefValue(0.1);
        this.m_heightParameter.init();
        this.m_iterations.setDefBounds(0, 128, 1, 16);
        this.m_iterations.setDefValue(0);
        this.m_iterations.init();
        this.m_damping.setDefBounds(0.0, 1.0, 0.01, 0.1);
        this.m_damping.setDefValue(0.1);
        this.m_damping.init();
    }

    public void reset() {
        super.reset();
        this.compute();
        this.update(null);
    }

    public boolean update(Object event) {
        if (event == this.m_elementSet) {
            if (this.isUpdateSender()) {
                return true;
            }
            this.setGeometry((PgGeometry)this.m_elementSet);
            this.compute();
            this.update(null);
            return true;
        }
        if (event == this.m_faceParameter || event == this.m_distParameter || event == this.m_heightParameter || event == this.m_dual || event == this.m_iterations || event == this.m_bLowerToZero || event == this.m_bNormalOnly || event == this.m_bInterpolateEdges || event == this.m_bBilinear || event == this.m_bPlanarFace || event == this.m_bIndentCenter) {
            this.m_elementSet.copy((PsObject)this.m_geomSave);
            this.compute();
            this.update(null);
            return true;
        }
        return super.update(event);
    }

    public boolean compute() {
        if (this.m_elementSet == null) {
            PsDebug.warning((String)"missing geometry.");
            return false;
        }
        this.m_elementSet.copy((PsObject)this.m_geomSave);
        if (!this.m_bApplyModeling) {
            return true;
        }
        int localIndex = 0;
        if (this.m_dual.getState()) {
            localIndex = 2;
        }
        if (this.m_mode == 1) {
            PwWeave.computePlanarSurface(this.m_elementSet, this.m_faceParameter.getValue(), this.m_distParameter.getValue(), this.m_heightParameter.getValue(), this.m_iterations.getValue(), this.m_damping.getValue(), this.m_bLowerToZero.getState(), this.m_bNormalOnly.getState(), this.m_bIndentCenter.getState());
        } else if (this.m_mode == 0) {
            PwWeave.computeSurface(this.m_elementSet, this.m_faceParameter.getValue(), this.m_distParameter.getValue(), this.m_heightParameter.getValue(), localIndex, !this.m_bInterpolateEdges.getState(), this.m_bLowerToZero.getState(), this.m_bBilinear.getState(), this.m_bPlanarFace.getState());
        } else if (this.m_mode == 2) {
            PwWeave.computeElevationSurface(this.m_elementSet, this.m_faceParameter.getValue(), this.m_distParameter.getValue(), this.m_heightParameter.getValue(), localIndex, this.m_bLowerToZero.getState(), this.m_bPlanarFace.getState());
        } else if (this.m_mode == 3) {
            PwWeave.computeExtendSurface(this.m_elementSet, this.m_distParameter.getValue(), this.m_heightParameter.getValue(), this.m_bLowerToZero.getState());
        }
        return true;
    }

    public void setGeometry(PgGeometry geom) {
        super.setGeometry(geom);
        this.m_elementSet = (PgElementSet)geom;
    }

    public void setEnabledModeling(boolean flag) {
        this.m_bApplyModeling = flag;
    }

    public boolean isEnabledModeling() {
        return this.m_bApplyModeling;
    }

    public static void computeSurface(PgElementSet geom, double faceParam, double distParam, double heightParam, int localIndex, boolean bPlanarizeAtEdge, boolean bLowerToZero, boolean bBilinear, boolean bParallelFace) {
        if (m_bRefineAlways || geom.getDimOfElements() != 4) {
            PwRefineElementSet.quadrisection((PgElementSet)geom, (int)4);
        }
        if (!geom.hasElementNormals()) {
            geom.makeElementNormals();
        }
        if (!geom.hasVertexNormals()) {
            geom.makeVertexNormals();
        }
        int nov = geom.getNumVertices();
        int noe = geom.getNumElements();
        double faceSize = faceParam;
        double bndDistance = distParam * faceParam;
        double heightPlus = heightParam;
        double heightMinus = -heightParam;
        if (bLowerToZero) {
            heightMinus = 0.0;
        }
        int newNoe = 4 * noe;
        int numEdges = geom.getNumEdges();
        int newNov = 2 * noe + 2 * numEdges;
        int[] vertexProcessed = new int[nov];
        int i = 0;
        while (i < noe) {
            PiVector element = geom.getElement(i);
            if (vertexProcessed[element.m_data[localIndex]] != 1) {
                vertexProcessed[element.m_data[localIndex]] = 1;
                newNov += 2;
            }
            ++i;
        }
        PgVertexStar vs = new PgVertexStar();
        PdVector[] newVertex = new PdVector[newNov];
        PiVector[] newEl = new PiVector[newNoe];
        int i2 = 0;
        while (i2 < newNoe) {
            newEl[i2] = new PiVector(4);
            newEl[i2].setConstant(-1);
            ++i2;
        }
        int nextVertexIndex = 0;
        int i3 = 0;
        while (i3 < noe) {
            PdVector normal;
            PdVector nv2;
            PiVector element = geom.getElement(i3);
            PdVector nv1 = PdVector.blendNew((double)(1.0 - faceSize), (PdVector)geom.getVertex(element.m_data[localIndex]), (double)faceSize, (PdVector)geom.getVertex(element.m_data[(localIndex + 2) % 4]));
            if (bBilinear) {
                nv1 = PdVector.blendNew((double)(1.0 - 2.0 * faceSize + faceSize * faceSize), (PdVector)geom.getVertex(element.m_data[localIndex]), (double)(faceSize * faceSize), (PdVector)geom.getVertex(element.m_data[(localIndex + 2) % 4]));
                nv1.blendBase(nv1, faceSize - faceSize * faceSize, geom.getVertex(element.m_data[(localIndex + 1) % 4]));
                nv1.blendBase(nv1, faceSize - faceSize * faceSize, geom.getVertex(element.m_data[(localIndex + 3) % 4]));
            }
            PdVector nor = geom.getVertexNormal(element.m_data[localIndex]);
            if (bParallelFace) {
                nv2 = PdVector.blendNew((double)1.0, (PdVector)nv1, (double)heightMinus, (PdVector)nor);
                nv1.blendBase(nv1, heightPlus, nor);
            } else {
                nv2 = PdVector.blendNew((double)1.0, (PdVector)nv1, (double)heightMinus, (PdVector)geom.getElementNormal(i3));
                nv1.blendBase(nv1, heightPlus, geom.getElementNormal(i3));
            }
            newEl[4 * i3 + 0].m_data[2] = nextVertexIndex;
            newEl[4 * i3 + 1].m_data[2] = nextVertexIndex + 1;
            newEl[4 * i3 + 2].m_data[1] = nextVertexIndex;
            newEl[4 * i3 + 3].m_data[3] = nextVertexIndex + 1;
            newVertex[nextVertexIndex] = nv1;
            newVertex[nextVertexIndex + 1] = nv2;
            nextVertexIndex += 2;
            if (vertexProcessed[element.m_data[localIndex]] != 2) {
                PdVector nv3 = PdVector.copyNew((PdVector)geom.getVertex(element.m_data[localIndex]));
                PdVector nv4 = PdVector.blendNew((double)1.0, (PdVector)nv3, (double)heightMinus, (PdVector)nor);
                nv3.blendBase(nv3, heightPlus, nor);
                vs.makeVertexStar(geom, element.m_data[localIndex], i3);
                int vsSize = vs.getSize();
                int j = 0;
                while (j < vsSize) {
                    int elInd = vs.getElement().m_data[j];
                    newEl[4 * elInd + 0].m_data[0] = nextVertexIndex;
                    newEl[4 * elInd + 1].m_data[0] = nextVertexIndex + 1;
                    ++j;
                }
                newVertex[nextVertexIndex] = nv3;
                newVertex[nextVertexIndex + 1] = nv4;
                nextVertexIndex += 2;
                vertexProcessed[element.m_data[localIndex]] = 2;
            }
            if (newEl[4 * i3 + 0].m_data[1] == -1) {
                normal = PdVector.copyNew((PdVector)geom.getElementNormal(i3));
                int neighInd = geom.getNeighbour((int)i3).m_data[(localIndex + 3) % 4];
                if (neighInd != -1) {
                    normal.add(geom.getElementNormal(neighInd));
                    normal.normalize();
                    newEl[4 * neighInd + 0].m_data[3] = nextVertexIndex;
                    newEl[4 * neighInd + 1].m_data[3] = nextVertexIndex + 1;
                    newEl[4 * neighInd + 2].m_data[0] = nextVertexIndex;
                }
                if (bParallelFace) {
                    normal.copy(nor);
                }
                PdVector nv5 = PdVector.blendNew((double)faceSize, (PdVector)geom.getVertex(element.m_data[(localIndex + 1) % 4]), (double)(1.0 - faceSize), (PdVector)geom.getVertex(element.m_data[localIndex]));
                PdVector nv6 = PdVector.blendNew((double)1.0, (PdVector)nv5, (double)heightMinus, (PdVector)normal);
                nv5.blendBase(nv5, heightPlus, normal);
                newEl[4 * i3 + 0].m_data[1] = nextVertexIndex;
                newEl[4 * i3 + 1].m_data[1] = nextVertexIndex + 1;
                newEl[4 * i3 + 3].m_data[0] = nextVertexIndex + 1;
                newVertex[nextVertexIndex] = nv5;
                newVertex[nextVertexIndex + 1] = nv6;
                nextVertexIndex += 2;
            }
            if (newEl[4 * i3 + 0].m_data[3] == -1) {
                normal = PdVector.copyNew((PdVector)geom.getElementNormal(i3));
                int neighInd = geom.getNeighbour((int)i3).m_data[(localIndex + 2) % 4];
                if (neighInd != -1) {
                    normal.add(geom.getElementNormal(neighInd));
                    normal.normalize();
                    newEl[4 * neighInd + 0].m_data[1] = nextVertexIndex;
                    newEl[4 * neighInd + 1].m_data[1] = nextVertexIndex + 1;
                    newEl[4 * neighInd + 3].m_data[0] = nextVertexIndex + 1;
                }
                if (bParallelFace) {
                    normal.copy(nor);
                }
                PdVector nv7 = PdVector.blendNew((double)faceSize, (PdVector)geom.getVertex(element.m_data[(localIndex + 3) % 4]), (double)(1.0 - faceSize), (PdVector)geom.getVertex(element.m_data[localIndex]));
                PdVector nv8 = PdVector.blendNew((double)1.0, (PdVector)nv7, (double)heightMinus, (PdVector)normal);
                nv7.blendBase(nv7, heightPlus, normal);
                newEl[4 * i3 + 0].m_data[3] = nextVertexIndex;
                newEl[4 * i3 + 1].m_data[3] = nextVertexIndex + 1;
                newEl[4 * i3 + 2].m_data[0] = nextVertexIndex;
                newVertex[nextVertexIndex] = nv7;
                newVertex[nextVertexIndex + 1] = nv8;
                nextVertexIndex += 2;
            }
            if (newEl[4 * i3 + 3].m_data[1] == -1) {
                int neighInd = geom.getNeighbour((int)i3).m_data[(localIndex + 0) % 4];
                if (neighInd != -1) {
                    newEl[4 * neighInd + 2].m_data[2] = nextVertexIndex + 1;
                    newEl[4 * neighInd + 2].m_data[3] = nextVertexIndex;
                }
                PdVector nv9 = PdVector.blendNew((double)bndDistance, (PdVector)geom.getVertex(element.m_data[(localIndex + 2) % 4]), (double)(1.0 - bndDistance), (PdVector)geom.getVertex(element.m_data[(localIndex + 1) % 4]));
                PdVector nv10 = PdVector.blendNew((double)(1.0 - faceSize), (PdVector)geom.getVertex(element.m_data[(localIndex + 1) % 4]), (double)faceSize, (PdVector)geom.getVertex(element.m_data[(localIndex + 2) % 4]));
                newEl[4 * i3 + 3].m_data[1] = nextVertexIndex;
                newEl[4 * i3 + 3].m_data[2] = nextVertexIndex + 1;
                newVertex[nextVertexIndex] = nv9;
                newVertex[nextVertexIndex + 1] = nv10;
                nextVertexIndex += 2;
            } else if (bPlanarizeAtEdge) {
                int ind9 = newEl[4 * i3 + 3].m_data[1];
                int ind10 = newEl[4 * i3 + 3].m_data[2];
                int neighInd = geom.getNeighbour((int)i3).m_data[(localIndex + 0) % 4];
                newVertex[ind10].blend(0.5, newVertex[newEl[4 * i3 + 1].m_data[2]], 0.5, newVertex[newEl[4 * neighInd + 0].m_data[2]]);
                newVertex[ind9].blend(0.5, newVertex[newEl[4 * i3 + 1].m_data[1]], 0.5, newVertex[newEl[4 * neighInd + 0].m_data[3]]);
                newVertex[ind9].blend(bndDistance, newVertex[ind10], 1.0 - bndDistance, newVertex[ind9]);
            }
            if (newEl[4 * i3 + 2].m_data[2] == -1) {
                int neighInd = geom.getNeighbour((int)i3).m_data[(localIndex + 1) % 4];
                if (neighInd != -1) {
                    newEl[4 * neighInd + 3].m_data[1] = nextVertexIndex + 1;
                    newEl[4 * neighInd + 3].m_data[2] = nextVertexIndex;
                }
                PdVector nv11 = PdVector.blendNew((double)faceSize, (PdVector)geom.getVertex(element.m_data[(localIndex + 2) % 4]), (double)(1.0 - faceSize), (PdVector)geom.getVertex(element.m_data[(localIndex + 3) % 4]));
                PdVector nv12 = PdVector.blendNew((double)(1.0 - bndDistance), (PdVector)geom.getVertex(element.m_data[(localIndex + 3) % 4]), (double)bndDistance, (PdVector)geom.getVertex(element.m_data[(localIndex + 2) % 4]));
                newEl[4 * i3 + 2].m_data[2] = nextVertexIndex;
                newEl[4 * i3 + 2].m_data[3] = nextVertexIndex + 1;
                newVertex[nextVertexIndex] = nv11;
                newVertex[nextVertexIndex + 1] = nv12;
                nextVertexIndex += 2;
            } else if (bPlanarizeAtEdge) {
                int ind11 = newEl[4 * i3 + 2].m_data[2];
                int ind12 = newEl[4 * i3 + 2].m_data[3];
                int neighInd = geom.getNeighbour((int)i3).m_data[(localIndex + 1) % 4];
                newVertex[ind11].blend(0.5, newVertex[newEl[4 * i3 + 0].m_data[2]], 0.5, newVertex[newEl[4 * neighInd + 1].m_data[2]]);
                newVertex[ind12].blend(0.5, newVertex[newEl[4 * i3 + 0].m_data[3]], 0.5, newVertex[newEl[4 * neighInd + 1].m_data[1]]);
                newVertex[ind12].blend(bndDistance, newVertex[ind11], 1.0 - bndDistance, newVertex[ind12]);
            }
            ++i3;
        }
        boolean bHasElementColors = geom.hasElementColors();
        boolean bHasElementBackColors = geom.hasElementBackColors();
        geom.setNumElements(newNoe);
        if (bHasElementColors) {
            geom.assureElementColors();
            int i4 = noe - 1;
            while (i4 >= 0) {
                int j = 0;
                while (j < 4) {
                    geom.setElementColor(4 * i4 + j, geom.getElementColor(i4));
                    ++j;
                }
                --i4;
            }
        }
        if (bHasElementBackColors) {
            geom.assureElementBackColors();
            int i5 = noe - 1;
            while (i5 >= 0) {
                int j = 0;
                while (j < 4) {
                    geom.setElementBackColor(4 * i5 + j, geom.getElementBackColor(i5));
                    ++j;
                }
                --i5;
            }
        }
        geom.setNumVertices(newNov);
        geom.setElements(newEl);
        geom.setVertices(newVertex);
        geom.makeNeighbour();
        geom.makeVertexNormals();
        geom.makeElementNormals();
    }

    public static PdVector computeOffsetPosition(PdVector corner, PdVector normal1, double dist1, PdVector normal2, double dist2, PdVector normal3, double dist3) {
        PdVector position = PdVector.copyNew((PdVector)corner);
        PdVector dir = PdVector.crossNew((PdVector)normal2, (PdVector)normal3);
        dir.normalize();
        double dp = PdVector.dot((PdVector)dir, (PdVector)normal1);
        position.add(dist1 / dp, dir);
        dir = PdVector.crossNew((PdVector)normal3, (PdVector)normal1);
        dir.normalize();
        dp = PdVector.dot((PdVector)dir, (PdVector)normal2);
        position.add(dist2 / dp, dir);
        dir = PdVector.crossNew((PdVector)normal1, (PdVector)normal2);
        dir.normalize();
        dp = PdVector.dot((PdVector)dir, (PdVector)normal3);
        position.add(dist3 / dp, dir);
        return position;
    }

    public static void computeExtendSurface(PgElementSet geom, double distParam, double heightParam, boolean bLowerToZero) {
        if (m_bRefineAlways || geom.getDimOfElements() != 4) {
            PwRefineElementSet.quadrisection((PgElementSet)geom, (int)4);
        }
        if (!geom.hasElementNormals()) {
            geom.makeElementNormals();
        }
        if (!geom.hasVertexNormals()) {
            geom.makeVertexNormals();
        }
        int nov = geom.getNumVertices();
        int noe = geom.getNumElements();
        double heightPlus = heightParam;
        double heightCenter = 0.0;
        double heightMinus = -heightParam;
        if (!bLowerToZero) {
            heightCenter = heightMinus;
            heightMinus = -3.0 * heightPlus;
        }
        int newNoe = 4 * noe;
        int numEdges = geom.getNumEdges();
        int newNov = 2 * noe + 2 * numEdges;
        int[] vertexProcessed = new int[nov];
        int i = 0;
        while (i < noe) {
            PiVector element = geom.getElement(i);
            if (vertexProcessed[element.m_data[0]] != 1) {
                vertexProcessed[element.m_data[0]] = 1;
                newNov += 2;
            }
            ++i;
        }
        PgVertexStar vs = new PgVertexStar();
        PdVector[] newVertex = new PdVector[newNov];
        PiVector[] newEl = new PiVector[newNoe];
        int i2 = 0;
        while (i2 < newNoe) {
            newEl[i2] = new PiVector(4);
            newEl[i2].setConstant(-1);
            ++i2;
        }
        int nextVertexIndex = 0;
        int i3 = 0;
        while (i3 < noe) {
            PdVector edgeDir;
            PdVector nnor1;
            PdVector nnor0;
            PiVector element = geom.getElement(i3);
            PiVector neigh = geom.getNeighbour(i3);
            PdVector nor = geom.getElementNormal(i3);
            if (neigh.m_data[0] < 0) {
                nnor0 = PdVector.crossNew((PdVector)PdVector.subNew((PdVector)geom.getVertex(element.m_data[2]), (PdVector)geom.getVertex(element.m_data[1])), (PdVector)nor);
                nnor0.normalize();
            } else {
                nnor0 = geom.getElementNormal(neigh.m_data[0]);
            }
            if (neigh.m_data[1] < 0) {
                nnor1 = PdVector.crossNew((PdVector)PdVector.subNew((PdVector)geom.getVertex(element.m_data[3]), (PdVector)geom.getVertex(element.m_data[2])), (PdVector)nor);
                nnor1.normalize();
            } else {
                nnor1 = geom.getElementNormal(neigh.m_data[1]);
            }
            PdVector nv1 = PwWeave.computeOffsetPosition(geom.getVertex(element.m_data[2]), nor, heightPlus, nnor0, heightMinus, nnor1, heightMinus);
            PdVector nv2 = PwWeave.computeOffsetPosition(geom.getVertex(element.m_data[2]), nor, heightCenter, nnor0, heightMinus, nnor1, heightMinus);
            newEl[4 * i3 + 0].m_data[2] = nextVertexIndex;
            newEl[4 * i3 + 1].m_data[2] = nextVertexIndex + 1;
            newEl[4 * i3 + 2].m_data[1] = nextVertexIndex;
            newEl[4 * i3 + 3].m_data[3] = nextVertexIndex + 1;
            newVertex[nextVertexIndex] = nv1;
            newVertex[nextVertexIndex + 1] = nv2;
            nextVertexIndex += 2;
            if (vertexProcessed[element.m_data[0]] != 2) {
                PdVector nv3 = PdVector.copyNew((PdVector)geom.getVertex(element.m_data[0]));
                PdVector nv4 = PdVector.blendNew((double)1.0, (PdVector)nv3, (double)heightCenter, (PdVector)nor);
                nv3.blendBase(nv3, heightPlus, nor);
                vs.makeVertexStar(geom, element.m_data[0], i3);
                int vsSize = vs.getSize();
                int j = 0;
                while (j < vsSize) {
                    int elInd = vs.getElement().m_data[j];
                    newEl[4 * elInd + 0].m_data[0] = nextVertexIndex;
                    newEl[4 * elInd + 1].m_data[0] = nextVertexIndex + 1;
                    ++j;
                }
                newVertex[nextVertexIndex] = nv3;
                newVertex[nextVertexIndex + 1] = nv4;
                nextVertexIndex += 2;
                vertexProcessed[element.m_data[0]] = 2;
            }
            if (newEl[4 * i3 + 0].m_data[1] == -1) {
                int neighInd = geom.getNeighbour((int)i3).m_data[3];
                if (neighInd != -1) {
                    newEl[4 * neighInd + 0].m_data[3] = nextVertexIndex;
                    newEl[4 * neighInd + 1].m_data[3] = nextVertexIndex + 1;
                    newEl[4 * neighInd + 2].m_data[0] = nextVertexIndex;
                }
                edgeDir = PdVector.subNew((PdVector)geom.getVertex(element.m_data[2]), (PdVector)geom.getVertex(element.m_data[1]));
                PdVector nv5 = PwWeave.computeOffsetPosition(geom.getVertex(element.m_data[1]), nor, heightPlus, nnor0, heightMinus, edgeDir, -distParam);
                PdVector nv6 = PwWeave.computeOffsetPosition(geom.getVertex(element.m_data[1]), nor, heightCenter, nnor0, heightMinus, edgeDir, distParam);
                newEl[4 * i3 + 0].m_data[1] = nextVertexIndex;
                newEl[4 * i3 + 1].m_data[1] = nextVertexIndex + 1;
                newEl[4 * i3 + 3].m_data[0] = nextVertexIndex + 1;
                newVertex[nextVertexIndex] = nv5;
                newVertex[nextVertexIndex + 1] = nv6;
                nextVertexIndex += 2;
            }
            if (newEl[4 * i3 + 0].m_data[3] == -1) {
                int neighInd = geom.getNeighbour((int)i3).m_data[2];
                if (neighInd != -1) {
                    newEl[4 * neighInd + 0].m_data[1] = nextVertexIndex;
                    newEl[4 * neighInd + 1].m_data[1] = nextVertexIndex + 1;
                    newEl[4 * neighInd + 3].m_data[0] = nextVertexIndex + 1;
                }
                edgeDir = PdVector.subNew((PdVector)geom.getVertex(element.m_data[2]), (PdVector)geom.getVertex(element.m_data[3]));
                PdVector nv7 = PwWeave.computeOffsetPosition(geom.getVertex(element.m_data[3]), nor, heightPlus, nnor1, heightMinus, edgeDir, distParam);
                PdVector nv8 = PwWeave.computeOffsetPosition(geom.getVertex(element.m_data[3]), nor, heightCenter, nnor1, heightMinus, edgeDir, -distParam);
                newEl[4 * i3 + 0].m_data[3] = nextVertexIndex;
                newEl[4 * i3 + 1].m_data[3] = nextVertexIndex + 1;
                newEl[4 * i3 + 2].m_data[0] = nextVertexIndex;
                newVertex[nextVertexIndex] = nv7;
                newVertex[nextVertexIndex + 1] = nv8;
                nextVertexIndex += 2;
            }
            if (newEl[4 * i3 + 3].m_data[1] == -1) {
                int neighInd = geom.getNeighbour((int)i3).m_data[0];
                if (neighInd != -1) {
                    newEl[4 * neighInd + 2].m_data[2] = nextVertexIndex + 1;
                    newEl[4 * neighInd + 2].m_data[3] = nextVertexIndex;
                }
                edgeDir = PdVector.subNew((PdVector)geom.getVertex(element.m_data[2]), (PdVector)geom.getVertex(element.m_data[1]));
                PdVector nv9 = PwWeave.computeOffsetPosition(geom.getVertex(element.m_data[1]), nor, heightCenter, nnor0, heightPlus, edgeDir, distParam);
                PdVector nv10 = PwWeave.computeOffsetPosition(geom.getVertex(element.m_data[2]), nor, heightCenter, nnor0, heightPlus, nnor1, heightMinus);
                newEl[4 * i3 + 3].m_data[1] = nextVertexIndex;
                newEl[4 * i3 + 3].m_data[2] = nextVertexIndex + 1;
                newVertex[nextVertexIndex] = nv9;
                newVertex[nextVertexIndex + 1] = nv10;
                nextVertexIndex += 2;
            } else {
                PdVector nv10 = PwWeave.computeOffsetPosition(geom.getVertex(element.m_data[2]), nor, heightCenter, nnor0, heightPlus, nnor1, heightMinus);
                if (PdVector.sqrDist((PdVector)newVertex[newEl[4 * i3 + 3].m_data[1]], (PdVector)newVertex[newEl[4 * i3 + 3].m_data[2]]) > PdVector.sqrDist((PdVector)newVertex[newEl[4 * i3 + 3].m_data[1]], (PdVector)nv10)) {
                    newVertex[newEl[4 * i3 + 3].m_data[2]] = nv10;
                }
            }
            if (newEl[4 * i3 + 2].m_data[2] == -1) {
                int neighInd = geom.getNeighbour((int)i3).m_data[1];
                if (neighInd != -1) {
                    newEl[4 * neighInd + 3].m_data[1] = nextVertexIndex + 1;
                    newEl[4 * neighInd + 3].m_data[2] = nextVertexIndex;
                }
                edgeDir = PdVector.subNew((PdVector)geom.getVertex(element.m_data[2]), (PdVector)geom.getVertex(element.m_data[3]));
                PdVector nv11 = PwWeave.computeOffsetPosition(geom.getVertex(element.m_data[2]), nor, heightPlus, nnor0, heightMinus, nnor1, heightCenter);
                PdVector nv12 = PwWeave.computeOffsetPosition(geom.getVertex(element.m_data[3]), nor, heightPlus, nnor1, heightCenter, edgeDir, distParam);
                newEl[4 * i3 + 2].m_data[2] = nextVertexIndex;
                newEl[4 * i3 + 2].m_data[3] = nextVertexIndex + 1;
                newVertex[nextVertexIndex] = nv11;
                newVertex[nextVertexIndex + 1] = nv12;
                nextVertexIndex += 2;
            } else {
                PdVector nv11 = PwWeave.computeOffsetPosition(geom.getVertex(element.m_data[2]), nor, heightPlus, nnor0, heightMinus, nnor1, heightCenter);
                if (PdVector.sqrDist((PdVector)newVertex[newEl[4 * i3 + 2].m_data[3]], (PdVector)newVertex[newEl[4 * i3 + 2].m_data[2]]) > PdVector.sqrDist((PdVector)newVertex[newEl[4 * i3 + 2].m_data[3]], (PdVector)nv11)) {
                    newVertex[newEl[4 * i3 + 2].m_data[2]] = nv11;
                }
            }
            ++i3;
        }
        boolean bHasElementColors = geom.hasElementColors();
        boolean bHasElementBackColors = geom.hasElementBackColors();
        geom.setNumElements(newNoe);
        if (bHasElementColors) {
            geom.assureElementColors();
            int i4 = noe - 1;
            while (i4 >= 0) {
                int j = 0;
                while (j < 4) {
                    geom.setElementColor(4 * i4 + j, geom.getElementColor(i4));
                    ++j;
                }
                --i4;
            }
        }
        if (bHasElementBackColors) {
            geom.assureElementBackColors();
            int i5 = noe - 1;
            while (i5 >= 0) {
                int j = 0;
                while (j < 4) {
                    geom.setElementBackColor(4 * i5 + j, geom.getElementBackColor(i5));
                    ++j;
                }
                --i5;
            }
        }
        geom.setNumVertices(newNov);
        geom.setElements(newEl);
        geom.setVertices(newVertex);
        geom.makeNeighbour();
        geom.makeVertexNormals();
        geom.makeElementNormals();
    }

    public static void computeElevationSurface(PgElementSet geom, double faceParam, double distParam, double heightParam, int localIndex, boolean bLowerToZero, boolean bParallelFace) {
        if (m_bRefineAlways || geom.getDimOfElements() != 4) {
            PwRefineElementSet.quadrisection((PgElementSet)geom, (int)4);
        }
        if (!geom.hasElementNormals()) {
            geom.makeElementNormals();
        }
        if (!geom.hasVertexNormals()) {
            geom.makeVertexNormals();
        }
        int nov = geom.getNumVertices();
        int noe = geom.getNumElements();
        double faceSize = faceParam;
        double bndDistance = distParam * faceParam;
        double heightPlus = heightParam;
        double heightMinus = -heightParam;
        if (bLowerToZero) {
            heightMinus = 0.0;
        }
        int newNoe = 6 * noe;
        double heightPlusSmall = heightPlus * (1.0 - faceSize);
        double heightMinusSmall = heightMinus * (1.0 - faceSize);
        int numEdges = geom.getNumEdges();
        int newNov = 2 * noe + 2 * numEdges;
        int[] vertexProcessed = new int[nov];
        int i = 0;
        while (i < noe) {
            PiVector element = geom.getElement(i);
            if (vertexProcessed[element.m_data[localIndex]] != 1) {
                vertexProcessed[element.m_data[localIndex]] = 1;
                newNov += 2;
            }
            ++i;
        }
        PgVertexStar vs = new PgVertexStar();
        PdVector[] newVertex = new PdVector[newNov];
        PiVector[] newEl = new PiVector[newNoe];
        int i2 = 0;
        while (i2 < noe) {
            newEl[i2 * 6 + 0] = new PiVector(3);
            newEl[i2 * 6 + 1] = new PiVector(3);
            newEl[i2 * 6 + 2] = new PiVector(3);
            newEl[i2 * 6 + 3] = new PiVector(3);
            newEl[i2 * 6 + 4] = new PiVector(4);
            newEl[i2 * 6 + 5] = new PiVector(4);
            int j = 0;
            while (j < 6) {
                newEl[6 * i2 + j].setConstant(-1);
                ++j;
            }
            ++i2;
        }
        int nextVertexIndex = 0;
        int i3 = 0;
        while (i3 < noe) {
            PdVector normal;
            PdVector nv2;
            PiVector element = geom.getElement(i3);
            PdVector nv1 = PdVector.blendNew((double)(1.0 - faceSize), (PdVector)geom.getVertex(element.m_data[localIndex]), (double)faceSize, (PdVector)geom.getVertex(element.m_data[(localIndex + 2) % 4]));
            PdVector nor = geom.getVertexNormal(element.m_data[localIndex]);
            if (bParallelFace) {
                nv2 = PdVector.blendNew((double)1.0, (PdVector)nv1, (double)heightMinusSmall, (PdVector)nor);
                nv1.blendBase(nv1, heightPlusSmall, nor);
            } else {
                nv2 = PdVector.blendNew((double)1.0, (PdVector)nv1, (double)heightMinusSmall, (PdVector)geom.getElementNormal(i3));
                nv1.blendBase(nv1, heightPlusSmall, geom.getElementNormal(i3));
            }
            newEl[6 * i3 + 0].m_data[2] = nextVertexIndex;
            newEl[6 * i3 + 1].m_data[1] = nextVertexIndex;
            newEl[6 * i3 + 2].m_data[2] = nextVertexIndex + 1;
            newEl[6 * i3 + 3].m_data[1] = nextVertexIndex + 1;
            newEl[6 * i3 + 4].m_data[1] = nextVertexIndex;
            newEl[6 * i3 + 5].m_data[3] = nextVertexIndex + 1;
            newVertex[nextVertexIndex] = nv1;
            newVertex[nextVertexIndex + 1] = nv2;
            nextVertexIndex += 2;
            if (vertexProcessed[element.m_data[localIndex]] != 2) {
                PdVector nv3 = PdVector.copyNew((PdVector)geom.getVertex(element.m_data[localIndex]));
                PdVector nv4 = PdVector.blendNew((double)1.0, (PdVector)nv3, (double)heightMinus, (PdVector)nor);
                nv3.blendBase(nv3, heightPlus, nor);
                vs.makeVertexStar(geom, element.m_data[localIndex], i3);
                int vsSize = vs.getSize();
                int j = 0;
                while (j < vsSize) {
                    int elInd = vs.getElement().m_data[j];
                    newEl[6 * elInd + 0].m_data[0] = nextVertexIndex;
                    newEl[6 * elInd + 1].m_data[0] = nextVertexIndex;
                    newEl[6 * elInd + 2].m_data[0] = nextVertexIndex + 1;
                    newEl[6 * elInd + 3].m_data[0] = nextVertexIndex + 1;
                    ++j;
                }
                newVertex[nextVertexIndex] = nv3;
                newVertex[nextVertexIndex + 1] = nv4;
                nextVertexIndex += 2;
                vertexProcessed[element.m_data[localIndex]] = 2;
            }
            if (newEl[6 * i3 + 0].m_data[1] == -1) {
                normal = PdVector.copyNew((PdVector)geom.getElementNormal(i3));
                int neighInd = geom.getNeighbour((int)i3).m_data[(localIndex + 3) % 4];
                if (neighInd != -1) {
                    normal.add(geom.getElementNormal(neighInd));
                    normal.normalize();
                    newEl[6 * neighInd + 1].m_data[2] = nextVertexIndex;
                    newEl[6 * neighInd + 3].m_data[2] = nextVertexIndex + 1;
                    newEl[6 * neighInd + 4].m_data[0] = nextVertexIndex;
                }
                if (bParallelFace) {
                    normal.copy(nor);
                }
                PdVector nv5 = PdVector.blendNew((double)faceSize, (PdVector)geom.getVertex(element.m_data[(localIndex + 1) % 4]), (double)(1.0 - faceSize), (PdVector)geom.getVertex(element.m_data[localIndex]));
                PdVector nv6 = PdVector.blendNew((double)1.0, (PdVector)nv5, (double)heightMinusSmall, (PdVector)normal);
                nv5.blendBase(nv5, heightPlusSmall, normal);
                newEl[6 * i3 + 0].m_data[1] = nextVertexIndex;
                newEl[6 * i3 + 2].m_data[1] = nextVertexIndex + 1;
                newEl[6 * i3 + 5].m_data[0] = nextVertexIndex + 1;
                newVertex[nextVertexIndex] = nv5;
                newVertex[nextVertexIndex + 1] = nv6;
                nextVertexIndex += 2;
            }
            if (newEl[6 * i3 + 1].m_data[2] == -1) {
                normal = PdVector.copyNew((PdVector)geom.getElementNormal(i3));
                int neighInd = geom.getNeighbour((int)i3).m_data[(localIndex + 2) % 4];
                if (neighInd != -1) {
                    normal.add(geom.getElementNormal(neighInd));
                    normal.normalize();
                    newEl[6 * neighInd + 0].m_data[1] = nextVertexIndex;
                    newEl[6 * neighInd + 2].m_data[1] = nextVertexIndex + 1;
                    newEl[6 * neighInd + 5].m_data[0] = nextVertexIndex + 1;
                }
                if (bParallelFace) {
                    normal.copy(nor);
                }
                PdVector nv7 = PdVector.blendNew((double)faceSize, (PdVector)geom.getVertex(element.m_data[(localIndex + 3) % 4]), (double)(1.0 - faceSize), (PdVector)geom.getVertex(element.m_data[localIndex]));
                PdVector nv8 = PdVector.blendNew((double)1.0, (PdVector)nv7, (double)heightMinusSmall, (PdVector)normal);
                nv7.blendBase(nv7, heightPlusSmall, normal);
                newEl[6 * i3 + 1].m_data[2] = nextVertexIndex;
                newEl[6 * i3 + 3].m_data[2] = nextVertexIndex + 1;
                newEl[6 * i3 + 4].m_data[0] = nextVertexIndex;
                newVertex[nextVertexIndex] = nv7;
                newVertex[nextVertexIndex + 1] = nv8;
                nextVertexIndex += 2;
            }
            if (newEl[6 * i3 + 5].m_data[1] == -1) {
                int neighInd = geom.getNeighbour((int)i3).m_data[(localIndex + 0) % 4];
                if (neighInd != -1) {
                    newEl[6 * neighInd + 4].m_data[2] = nextVertexIndex + 1;
                    newEl[6 * neighInd + 4].m_data[3] = nextVertexIndex;
                }
                PdVector nv9 = PdVector.blendNew((double)bndDistance, (PdVector)geom.getVertex(element.m_data[(localIndex + 2) % 4]), (double)(1.0 - bndDistance), (PdVector)geom.getVertex(element.m_data[(localIndex + 1) % 4]));
                PdVector nv10 = PdVector.blendNew((double)(1.0 - faceSize), (PdVector)geom.getVertex(element.m_data[(localIndex + 1) % 4]), (double)faceSize, (PdVector)geom.getVertex(element.m_data[(localIndex + 2) % 4]));
                newEl[6 * i3 + 5].m_data[1] = nextVertexIndex;
                newEl[6 * i3 + 5].m_data[2] = nextVertexIndex + 1;
                newVertex[nextVertexIndex] = nv9;
                newVertex[nextVertexIndex + 1] = nv10;
                nextVertexIndex += 2;
            }
            if (newEl[6 * i3 + 4].m_data[2] == -1) {
                int neighInd = geom.getNeighbour((int)i3).m_data[(localIndex + 1) % 4];
                if (neighInd != -1) {
                    newEl[6 * neighInd + 5].m_data[1] = nextVertexIndex + 1;
                    newEl[6 * neighInd + 5].m_data[2] = nextVertexIndex;
                }
                PdVector nv11 = PdVector.blendNew((double)faceSize, (PdVector)geom.getVertex(element.m_data[(localIndex + 2) % 4]), (double)(1.0 - faceSize), (PdVector)geom.getVertex(element.m_data[(localIndex + 3) % 4]));
                PdVector nv12 = PdVector.blendNew((double)(1.0 - bndDistance), (PdVector)geom.getVertex(element.m_data[(localIndex + 3) % 4]), (double)bndDistance, (PdVector)geom.getVertex(element.m_data[(localIndex + 2) % 4]));
                newEl[6 * i3 + 4].m_data[2] = nextVertexIndex;
                newEl[6 * i3 + 4].m_data[3] = nextVertexIndex + 1;
                newVertex[nextVertexIndex] = nv11;
                newVertex[nextVertexIndex + 1] = nv12;
                nextVertexIndex += 2;
            }
            ++i3;
        }
        boolean bHasElementColors = geom.hasElementColors();
        boolean bHasElementBackColors = geom.hasElementBackColors();
        geom.setNumElements(newNoe);
        if (bHasElementColors) {
            geom.assureElementColors();
            int i4 = noe - 1;
            while (i4 >= 0) {
                int j = 0;
                while (j < 6) {
                    geom.setElementColor(6 * i4 + j, geom.getElementColor(i4));
                    ++j;
                }
                --i4;
            }
        }
        if (bHasElementBackColors) {
            geom.assureElementBackColors();
            int i5 = noe - 1;
            while (i5 >= 0) {
                int j = 0;
                while (j < 6) {
                    geom.setElementBackColor(6 * i5 + j, geom.getElementBackColor(i5));
                    ++j;
                }
                --i5;
            }
        }
        geom.setNumVertices(newNov);
        geom.setElements(newEl);
        geom.setVertices(newVertex);
        geom.makeNeighbour();
        geom.makeVertexNormals();
        geom.makeElementNormals();
    }

    public static void computePlanarSurface(PgElementSet geom, double faceParam, double distParam, double heightParam, int numIterations, double damping, boolean bLowerToZero, boolean bNormalOnly, boolean bIndentCenter) {
        int j;
        boolean bIndentOnIntersection = !bIndentCenter;
        int noe = geom.getNumElements();
        if (!geom.hasElementNormals()) {
            geom.makeElementNormals();
        }
        int newNov = 2 * noe;
        int newNoe = 0;
        int i = 0;
        while (i < noe) {
            PiVector el = geom.getElement(i);
            int elSize = el.getSize();
            newNov += 4 * elSize;
            newNoe += 4 * elSize;
            newNoe += 2 * elSize;
            newNov += 2 * elSize;
            PiVector neigh = geom.getNeighbour(i);
            int j2 = 0;
            while (j2 < elSize) {
                if (neigh.m_data[j2] < 0) {
                    newNov += 2;
                }
                ++j2;
            }
            ++i;
        }
        PdVector[] newVertex = new PdVector[newNov];
        PiVector[] newElement = new PiVector[newNoe];
        PdVector center = new PdVector(3);
        int i2 = 0;
        while (i2 < noe) {
            geom.getCenterOfElement(center, i2);
            PdVector normal = geom.getElementNormal(i2);
            newVertex[2 * i2] = bLowerToZero ? PdVector.blendNew((double)1.0, (PdVector)center, (double)0.0, (PdVector)normal) : PdVector.blendNew((double)1.0, (PdVector)center, (double)(-heightParam), (PdVector)normal);
            newVertex[2 * i2 + 1] = PdVector.blendNew((double)1.0, (PdVector)center, (double)heightParam, (PdVector)normal);
            ++i2;
        }
        i2 = 0;
        while (i2 < numIterations) {
            PwWeave.optimize(geom, newVertex, bLowerToZero, bNormalOnly, damping);
            ++i2;
        }
        int nextFreeIndex = 2 * noe;
        int nextElIndex = 0;
        PiVector firstIndex = new PiVector(noe);
        PdVector[][] nor = new PdVector[2][2];
        int i3 = 0;
        while (i3 < noe) {
            int idx;
            firstIndex.m_data[i3] = nextFreeIndex;
            PiVector el = geom.getElement(i3);
            int elSize = el.getSize();
            PiVector neigh = geom.getNeighbour(i3);
            j = 0;
            while (j < elSize) {
                idx = 0;
                while (idx < 2) {
                    if (j > 0) {
                        nor[0][idx].copy(nor[1][idx]);
                    } else {
                        PdVector edge = PdVector.subNew((PdVector)geom.getVertex(el.m_data[(j + 2) % elSize]), (PdVector)geom.getVertex(el.m_data[(j + 1) % elSize]));
                        PdVector dir1 = PdVector.copyNew((PdVector)newVertex[2 * i3 + idx]);
                        if (neigh.m_data[j] == -1) {
                            dir1.sub(geom.getVertex(el.m_data[(j + 1) % elSize]));
                        } else {
                            dir1.sub(newVertex[2 * neigh.m_data[j] + (idx + 1) % 2]);
                        }
                        nor[0][idx] = PdVector.crossNew((PdVector)edge, (PdVector)dir1);
                        nor[0][idx].normalize();
                    }
                    PdVector edge2 = PdVector.subNew((PdVector)geom.getVertex(el.m_data[(j + 3) % elSize]), (PdVector)geom.getVertex(el.m_data[(j + 2) % elSize]));
                    PdVector dir2 = PdVector.copyNew((PdVector)newVertex[2 * i3 + idx]);
                    if (neigh.m_data[(j + 1) % elSize] == -1) {
                        dir2.sub(geom.getVertex(el.m_data[(j + 2) % elSize]));
                    } else {
                        dir2.sub(newVertex[2 * neigh.m_data[(j + 1) % elSize] + (idx + 1) % 2]);
                    }
                    nor[1][idx] = PdVector.crossNew((PdVector)edge2, (PdVector)dir2);
                    nor[1][idx].normalize();
                    ++idx;
                }
                idx = 0;
                while (idx < 2) {
                    PdVector dir = PdVector.crossNew((PdVector)nor[0][idx], (PdVector)nor[1][idx]);
                    double sqrEps = 0.001;
                    if (dir.sqrLength() < sqrEps) {
                        dir.blend(0.5, nor[0][idx], 0.5, nor[1][idx]);
                        dir.normalize();
                        dir.blendBase(geom.getVertex(el.m_data[(j + 2) % elSize]), PdVector.dot((PdVector)PdVector.subNew((PdVector)newVertex[2 * i3 + idx], (PdVector)geom.getVertex(el.m_data[(j + 2) % elSize])), (PdVector)dir), dir);
                        dir.sub(newVertex[2 * i3 + idx]);
                    }
                    dir.normalize();
                    PdVector diff = PdVector.subNew((PdVector)newVertex[2 * i3 + idx], (PdVector)newVertex[2 * i3 + (idx + 1) % 2]);
                    double f = PdVector.dot((PdVector)diff, (PdVector)nor[0][(idx + 1) % 2]) / PdVector.dot((PdVector)dir, (PdVector)nor[0][(idx + 1) % 2]);
                    f += PdVector.dot((PdVector)diff, (PdVector)nor[1][(idx + 1) % 2]) / PdVector.dot((PdVector)dir, (PdVector)nor[1][(idx + 1) % 2]);
                    f /= 2.0;
                    double dist = PdVector.dist((PdVector)newVertex[2 * i3 + idx], (PdVector)geom.getVertex(el.m_data[(j + 2) % elSize]));
                    if (f > dist) {
                        f = dist;
                    }
                    if (-f > dist) {
                        f = -dist;
                    }
                    newVertex[nextFreeIndex + 2 * ((j + 1) % elSize) + idx] = PdVector.blendNew((double)1.0, (PdVector)newVertex[2 * i3 + idx], (double)(f *= -faceParam), (PdVector)dir);
                    ++idx;
                }
                ++j;
            }
            j = 0;
            while (j < elSize) {
                idx = 0;
                while (idx < 2) {
                    PdVector centerDir = neigh.m_data[j] == -1 ? PdVector.blendNew((double)0.5, (PdVector)geom.getVertex(el.m_data[(j + 1) % elSize]), (double)0.5, (PdVector)geom.getVertex(el.m_data[(j + 2) % elSize])) : PdVector.copyNew((PdVector)newVertex[2 * neigh.m_data[j] + (idx + 1) % 2]);
                    centerDir.sub(newVertex[2 * i3 + idx]);
                    centerDir.normalize();
                    double a = PdVector.dot((PdVector)PdVector.subNew((PdVector)newVertex[2 * i3 + idx], (PdVector)newVertex[nextFreeIndex + 2 * ((j + 1) % elSize) + idx]), (PdVector)centerDir);
                    a = PdVector.sqrDist((PdVector)newVertex[2 * i3 + idx], (PdVector)newVertex[nextFreeIndex + 2 * ((j + 1) % elSize) + idx]) - a * a;
                    a = Math.sqrt(a);
                    double b = PdVector.dot((PdVector)PdVector.subNew((PdVector)newVertex[2 * i3 + idx], (PdVector)newVertex[nextFreeIndex + 2 * j + idx]), (PdVector)centerDir);
                    b = PdVector.sqrDist((PdVector)newVertex[2 * i3 + idx], (PdVector)newVertex[nextFreeIndex + 2 * j + idx]) - b * b;
                    b = Math.sqrt(b);
                    newVertex[nextFreeIndex + 2 * j + idx + 2 * elSize] = PdVector.blendNew((double)(b / (a + b)), (PdVector)newVertex[nextFreeIndex + 2 * ((j + 1) % elSize) + idx], (double)(a / (a + b)), (PdVector)newVertex[nextFreeIndex + 2 * j + idx]);
                    newElement[nextElIndex] = new PiVector(2 * i3 + idx, nextFreeIndex + 2 * ((j + 1) % elSize) + idx, nextFreeIndex + 2 * ((j + 1) % elSize) + elSize * 2 + idx);
                    newElement[++nextElIndex] = new PiVector(2 * i3 + idx, nextFreeIndex + 2 * ((j + 1) % elSize) + elSize * 2 + idx, nextFreeIndex + 2 * ((j + 2) % elSize) + idx);
                    ++nextElIndex;
                    ++idx;
                }
                ++j;
            }
            nextFreeIndex += 4 * elSize;
            ++i3;
        }
        i3 = 0;
        while (i3 < noe) {
            PiVector element = geom.getElement(i3);
            PiVector neigh = geom.getNeighbour(i3);
            int elSize = element.getSize();
            j = 0;
            while (j < elSize) {
                double distParam2 = 0.0;
                if (neigh.m_data[j] < 0) {
                    distParam2 = 0.0;
                    PdVector dir = PdVector.subNew((PdVector)geom.getVertex(element.m_data[(j + 2) % elSize]), (PdVector)geom.getVertex(element.m_data[(j + 1) % elSize]));
                    dir.normalize();
                    double dp = PdVector.dot((PdVector)dir, (PdVector)PdVector.subNew((PdVector)newVertex[firstIndex.m_data[i3] + 2 * ((j + 1) % elSize)], (PdVector)geom.getVertex(element.m_data[(j + 1) % elSize])));
                    PdVector start = PdVector.blendNew((double)1.0, (PdVector)geom.getVertex(element.m_data[(j + 1) % elSize]), (double)dp, (PdVector)dir);
                    dp = PdVector.dot((PdVector)dir, (PdVector)PdVector.subNew((PdVector)newVertex[firstIndex.m_data[i3] + 2 * ((j + 0) % elSize) + 2 * elSize], (PdVector)geom.getVertex(element.m_data[(j + 1) % elSize])));
                    PdVector end = PdVector.blendNew((double)1.0, (PdVector)geom.getVertex(element.m_data[(j + 1) % elSize]), (double)dp, (PdVector)dir);
                    newVertex[nextFreeIndex] = PdVector.blendNew((double)distParam2, (PdVector)end, (double)(1.0 - distParam2), (PdVector)start);
                    newVertex[nextFreeIndex + 1] = PdVector.blendNew((double)distParam, (PdVector)start, (double)(1.0 - distParam), (PdVector)end);
                    newElement[nextElIndex] = new PiVector(firstIndex.m_data[i3] + 2 * ((j + 1) % elSize), firstIndex.m_data[i3] + 2 * ((j + 0) % elSize) + 2 * elSize, nextFreeIndex + 1, nextFreeIndex);
                    ++nextElIndex;
                    dp = PdVector.dot((PdVector)dir, (PdVector)PdVector.subNew((PdVector)newVertex[firstIndex.m_data[i3] + 2 * ((j + 0) % elSize) + 1], (PdVector)geom.getVertex(element.m_data[(j + 1) % elSize])));
                    end = PdVector.blendNew((double)1.0, (PdVector)geom.getVertex(element.m_data[(j + 1) % elSize]), (double)dp, (PdVector)dir);
                    dp = PdVector.dot((PdVector)dir, (PdVector)PdVector.subNew((PdVector)newVertex[firstIndex.m_data[i3] + 2 * ((j + 0) % elSize) + 2 * elSize + 1], (PdVector)geom.getVertex(element.m_data[(j + 1) % elSize])));
                    start = PdVector.blendNew((double)1.0, (PdVector)geom.getVertex(element.m_data[(j + 1) % elSize]), (double)dp, (PdVector)dir);
                    newVertex[nextFreeIndex + 2] = PdVector.blendNew((double)distParam, (PdVector)end, (double)(1.0 - distParam), (PdVector)start);
                    newVertex[nextFreeIndex + 3] = PdVector.blendNew((double)distParam2, (PdVector)start, (double)(1.0 - distParam2), (PdVector)end);
                    newElement[nextElIndex] = new PiVector(firstIndex.m_data[i3] + 2 * ((j + 0) % elSize) + 2 * elSize + 1, firstIndex.m_data[i3] + 2 * ((j + 0) % elSize) + 1, nextFreeIndex + 3, nextFreeIndex + 2);
                    ++nextElIndex;
                    nextFreeIndex += 4;
                } else if (neigh.m_data[j] > i3) {
                    int ni = neigh.m_data[j];
                    int ns = geom.getElement(ni).getSize();
                    int oli = geom.getOppVertexLocInd(i3, j);
                    PiVector el = geom.getElement(i3);
                    PdVector edge = PdVector.subNew((PdVector)geom.getVertex(el.m_data[(j + 2) % elSize]), (PdVector)geom.getVertex(el.m_data[(j + 1) % elSize]));
                    PdVector dir1 = PdVector.copyNew((PdVector)newVertex[2 * i3 + 1]);
                    dir1.sub(newVertex[2 * neigh.m_data[j] + 0]);
                    PdVector ln1 = PdVector.crossNew((PdVector)edge, (PdVector)dir1);
                    ln1.normalize();
                    PdVector dir2 = PdVector.copyNew((PdVector)newVertex[2 * i3 + 0]);
                    dir2.sub(newVertex[2 * neigh.m_data[j] + 1]);
                    PdVector ln2 = PdVector.crossNew((PdVector)edge, (PdVector)dir2);
                    ln2.normalize();
                    double a = PdVector.dot((PdVector)PdVector.subNew((PdVector)newVertex[firstIndex.m_data[i3] + 2 * ((j + 1) % elSize)], (PdVector)newVertex[2 * i3 + 1]), (PdVector)ln1);
                    double b = PdVector.dot((PdVector)PdVector.subNew((PdVector)newVertex[firstIndex.m_data[ni] + 2 * ((oli + 0) % ns) + 1], (PdVector)newVertex[2 * i3 + 1]), (PdVector)ln1);
                    PdVector start = bIndentOnIntersection ? PdVector.blendNew((double)(b / (b - a)), (PdVector)newVertex[firstIndex.m_data[i3] + 2 * ((j + 1) % elSize)], (double)(a / (a - b)), (PdVector)newVertex[firstIndex.m_data[ni] + 2 * ((oli + 0) % ns) + 1]) : PdVector.blendNew((double)0.5, (PdVector)newVertex[firstIndex.m_data[i3] + 2 * ((j + 1) % elSize)], (double)0.5, (PdVector)newVertex[firstIndex.m_data[ni] + 2 * ((oli + 0) % ns) + 1]);
                    a = PdVector.dot((PdVector)PdVector.subNew((PdVector)newVertex[firstIndex.m_data[i3] + 2 * ((j + 0) % elSize) + 2 * elSize], (PdVector)newVertex[2 * i3 + 1]), (PdVector)ln1);
                    b = PdVector.dot((PdVector)PdVector.subNew((PdVector)newVertex[firstIndex.m_data[ni] + 2 * ((oli + 0) % ns) + 2 * ns + 1], (PdVector)newVertex[2 * i3 + 1]), (PdVector)ln1);
                    PdVector end = bIndentOnIntersection ? PdVector.blendNew((double)(b / (b - a)), (PdVector)newVertex[firstIndex.m_data[i3] + 2 * ((j + 0) % elSize) + 2 * elSize], (double)(a / (a - b)), (PdVector)newVertex[firstIndex.m_data[ni] + 2 * ((oli + 0) % ns) + 2 * ns + 1]) : PdVector.blendNew((double)0.5, (PdVector)newVertex[firstIndex.m_data[i3] + 2 * ((j + 0) % elSize) + 2 * elSize], (double)0.5, (PdVector)newVertex[firstIndex.m_data[ni] + 2 * ((oli + 0) % ns) + 2 * ns + 1]);
                    newVertex[nextFreeIndex] = PdVector.blendNew((double)distParam2, (PdVector)end, (double)(1.0 - distParam2), (PdVector)start);
                    newVertex[nextFreeIndex + 1] = PdVector.blendNew((double)distParam, (PdVector)start, (double)(1.0 - distParam), (PdVector)end);
                    newElement[nextElIndex] = new PiVector(firstIndex.m_data[i3] + 2 * ((j + 1) % elSize), firstIndex.m_data[i3] + 2 * ((j + 0) % elSize) + 2 * elSize, nextFreeIndex + 1, nextFreeIndex);
                    newElement[++nextElIndex] = new PiVector(nextFreeIndex, nextFreeIndex + 1, firstIndex.m_data[ni] + 2 * ((oli + 0) % ns) + 2 * ns + 1, firstIndex.m_data[ni] + 2 * ((oli + 0) % ns) + 1);
                    ++nextElIndex;
                    a = PdVector.dot((PdVector)PdVector.subNew((PdVector)newVertex[firstIndex.m_data[i3] + 2 * ((j + 0) % elSize) + 2 * elSize + 1], (PdVector)newVertex[2 * i3 + 0]), (PdVector)ln2);
                    b = PdVector.dot((PdVector)PdVector.subNew((PdVector)newVertex[firstIndex.m_data[ni] + 2 * ((oli + 0) % ns) + 2 * ns], (PdVector)newVertex[2 * i3 + 0]), (PdVector)ln2);
                    start = bIndentOnIntersection ? PdVector.blendNew((double)(b / (b - a)), (PdVector)newVertex[firstIndex.m_data[i3] + 2 * ((j + 0) % elSize) + 2 * elSize + 1], (double)(a / (a - b)), (PdVector)newVertex[firstIndex.m_data[ni] + 2 * ((oli + 0) % ns) + 2 * ns]) : PdVector.blendNew((double)0.5, (PdVector)newVertex[firstIndex.m_data[i3] + 2 * ((j + 0) % elSize) + 2 * elSize + 1], (double)0.5, (PdVector)newVertex[firstIndex.m_data[ni] + 2 * ((oli + 0) % ns) + 2 * ns]);
                    a = PdVector.dot((PdVector)PdVector.subNew((PdVector)newVertex[firstIndex.m_data[i3] + 2 * ((j + 0) % elSize) + 1], (PdVector)newVertex[2 * i3 + 0]), (PdVector)ln2);
                    b = PdVector.dot((PdVector)PdVector.subNew((PdVector)newVertex[firstIndex.m_data[ni] + 2 * ((oli + 1) % ns)], (PdVector)newVertex[2 * i3 + 0]), (PdVector)ln2);
                    end = bIndentOnIntersection ? PdVector.blendNew((double)(b / (b - a)), (PdVector)newVertex[firstIndex.m_data[i3] + 2 * ((j + 0) % elSize) + 1], (double)(a / (a - b)), (PdVector)newVertex[firstIndex.m_data[ni] + 2 * ((oli + 1) % ns)]) : PdVector.blendNew((double)0.5, (PdVector)newVertex[firstIndex.m_data[i3] + 2 * ((j + 0) % elSize) + 1], (double)0.5, (PdVector)newVertex[firstIndex.m_data[ni] + 2 * ((oli + 1) % ns)]);
                    newVertex[nextFreeIndex + 2] = PdVector.blendNew((double)distParam, (PdVector)end, (double)(1.0 - distParam), (PdVector)start);
                    newVertex[nextFreeIndex + 3] = PdVector.blendNew((double)distParam2, (PdVector)start, (double)(1.0 - distParam2), (PdVector)end);
                    newElement[nextElIndex] = new PiVector(firstIndex.m_data[i3] + 2 * ((j + 0) % elSize) + 2 * elSize + 1, firstIndex.m_data[i3] + 2 * ((j + 0) % elSize) + 1, nextFreeIndex + 3, nextFreeIndex + 2);
                    newElement[++nextElIndex] = new PiVector(nextFreeIndex + 2, nextFreeIndex + 3, firstIndex.m_data[ni] + 2 * ((oli + 1) % ns), firstIndex.m_data[ni] + 2 * ((oli + 0) % ns) + 2 * ns);
                    ++nextElIndex;
                    nextFreeIndex += 4;
                }
                ++j;
            }
            ++i3;
        }
        geom.setNumVertices(newNov);
        geom.setVertices(newVertex);
        geom.setNumElements(newNoe);
        geom.setElements(newElement);
        geom.makeNeighbour();
        geom.makeElementNormals();
        geom.makeVertexNormals();
    }

    private static void optimize(PgElementSet geom, PdVector[] newVertex, boolean bLowerToZero, boolean bNormalOnly, double damping) {
        int noe = geom.getNumElements();
        int dim = 3;
        PdVector[] diff = PdVector.realloc(null, (int)(2 * noe), (int)dim);
        PdVector nor = new PdVector(dim);
        PdVector[] edge = new PdVector[2];
        int i = 0;
        while (i < noe) {
            PiVector element = geom.getElement(i);
            int elSize = element.getSize();
            PiVector neigh = geom.getNeighbour(i);
            int j = 0;
            while (j < elSize) {
                int neighIndex = neigh.m_data[j];
                if (neighIndex != -1) {
                    int idx = 0;
                    while (idx < 2) {
                        int k = 0;
                        while (k < 2) {
                            edge[k] = PdVector.subNew((PdVector)newVertex[2 * neighIndex + (idx + 1) % 2], (PdVector)geom.getVertex(element.m_data[(j + k + 1) % elSize]));
                            ++k;
                        }
                        nor.cross(edge[0], edge[1]);
                        nor.normalize();
                        double dist = PdVector.dot((PdVector)nor, (PdVector)PdVector.subNew((PdVector)newVertex[2 * i + idx], (PdVector)newVertex[2 * neighIndex + (idx + 1) % 2]));
                        diff[2 * i + idx].add(-dist, nor);
                        ++idx;
                    }
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 2 * noe) {
            if (i % 2 != 0 || !bLowerToZero) {
                if (bNormalOnly) {
                    double d = PdVector.dot((PdVector)geom.getElementNormal(i / 2), (PdVector)diff[i]);
                    diff[i].copy(geom.getElementNormal(i / 2));
                    diff[i].multScalar(d);
                }
                newVertex[i].add(damping, diff[i]);
            }
            ++i;
        }
    }
}

