/*
 * Decompiled with CFR 0.152.
 */
package dev.geom;

import dev.geom.PwUnitDistanceGraph;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.object.PsUpdateIf;
import jvx.project.PjWorkshop_IP;

public class PwUnitDistanceGraph_IP
extends PjWorkshop_IP
implements ActionListener,
ItemListener {
    protected PwUnitDistanceGraph m_wsUnitDistanceGraph;
    protected Button m_bInit;
    protected Button m_bInitByBoundary;
    protected Button m_bInitByPolygons;
    protected Button m_bSelected;
    protected Button m_bBreadthFirst;
    protected Button m_bDepthFirst;
    protected Button m_bBoundaryHeuristic;
    protected Button m_bHistogram;
    protected Button m_bComputeJammed;
    protected Button m_bAddSmallFaces;
    protected Button m_bAddAllFaces;
    protected Panel m_sliderPanel;

    public PwUnitDistanceGraph_IP() {
        this.setTitle("Unit Distance Graph");
        if (this.getClass() == PwUnitDistanceGraph_IP.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_sliderPanel = new Panel(new GridLayout(2, 1));
        this.add(this.m_sliderPanel);
        Panel pButtons = new Panel();
        pButtons.setLayout(new GridLayout(5, 2));
        this.m_bInit = new Button("Initial projection");
        this.m_bInit.addActionListener(this);
        pButtons.add(this.m_bInit);
        this.m_bInitByBoundary = new Button("Init by Boundary");
        this.m_bInitByBoundary.addActionListener(this);
        pButtons.add(this.m_bInitByBoundary);
        this.m_bInitByPolygons = new Button("Init by Cycles");
        this.m_bInitByPolygons.addActionListener(this);
        pButtons.add(this.m_bInitByPolygons);
        this.m_bSelected = new Button("add by selection");
        this.m_bSelected.addActionListener(this);
        pButtons.add(this.m_bSelected);
        this.m_bBreadthFirst = new Button("Breadth First");
        this.m_bBreadthFirst.addActionListener(this);
        pButtons.add(this.m_bBreadthFirst);
        this.m_bDepthFirst = new Button("Depth First");
        this.m_bDepthFirst.addActionListener(this);
        pButtons.add(this.m_bDepthFirst);
        this.m_bBoundaryHeuristic = new Button("Boundary Heuristic");
        this.m_bBoundaryHeuristic.addActionListener(this);
        pButtons.add(this.m_bBoundaryHeuristic);
        this.m_bHistogram = new Button("Print Histogram");
        this.m_bHistogram.addActionListener(this);
        pButtons.add(this.m_bHistogram);
        this.m_bAddSmallFaces = new Button("Add Small Faces Geoemtry");
        this.m_bAddSmallFaces.addActionListener(this);
        pButtons.add(this.m_bAddSmallFaces);
        this.m_bAddAllFaces = new Button("Add All Faces Geoemtry");
        this.m_bAddAllFaces.addActionListener(this);
        pButtons.add(this.m_bAddAllFaces);
        this.add(pButtons);
    }

    public Dimension getDialogSize() {
        return new Dimension(400, 560);
    }

    public String getNotice() {
        return "Experimental for Unit Distance Graph - first add two points to the graph geometry, than initialize. If there is no new vertex, change distance of the inital vertices or unit distance and initialize again. If initialization results in a quad with too acute angles, just keep one neighboured pair of vertices and initialize once more. Finally start to grow.";
    }

    public void setParent(PsUpdateIf parent) {
        super.setParent(parent);
        this.m_wsUnitDistanceGraph = (PwUnitDistanceGraph)parent;
        this.m_sliderPanel.add((Component)this.m_wsUnitDistanceGraph.m_dDistance.newInspector("_IP"));
        this.m_sliderPanel.add((Component)this.m_wsUnitDistanceGraph.m_iRemoveBnd.newInspector("_IP"));
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.m_bInit) {
            this.m_wsUnitDistanceGraph.initPoints();
            this.m_wsUnitDistanceGraph.m_graph.update((Object)this.m_wsUnitDistanceGraph.m_graph);
        } else if (source == this.m_bInitByBoundary) {
            this.m_wsUnitDistanceGraph.initByBoundary();
            this.m_wsUnitDistanceGraph.m_graph.update((Object)this.m_wsUnitDistanceGraph.m_graph);
        } else if (source == this.m_bInitByPolygons) {
            this.m_wsUnitDistanceGraph.initByPolygons();
            this.m_wsUnitDistanceGraph.m_graph.update((Object)this.m_wsUnitDistanceGraph.m_graph);
        } else if (source == this.m_bSelected) {
            this.m_wsUnitDistanceGraph.compute();
            this.m_wsUnitDistanceGraph.m_graph.update((Object)this.m_wsUnitDistanceGraph.m_graph);
        } else if (source == this.m_bBreadthFirst) {
            this.m_wsUnitDistanceGraph.growDiskBreadthFirst();
            this.m_wsUnitDistanceGraph.m_graph.update((Object)this.m_wsUnitDistanceGraph.m_graph);
        } else if (source == this.m_bDepthFirst) {
            this.m_wsUnitDistanceGraph.growDiskDepthFirst();
            this.m_wsUnitDistanceGraph.m_graph.update((Object)this.m_wsUnitDistanceGraph.m_graph);
        } else if (source == this.m_bBoundaryHeuristic) {
            this.m_wsUnitDistanceGraph.growByBoundaryHeuristic();
            this.m_wsUnitDistanceGraph.m_graph.update((Object)this.m_wsUnitDistanceGraph.m_graph);
        } else if (source == this.m_bHistogram) {
            this.m_wsUnitDistanceGraph.printHistogram();
        } else if (source == this.m_bAddSmallFaces) {
            this.m_wsUnitDistanceGraph.addFacesGeometry(true);
        } else if (source == this.m_bAddAllFaces) {
            this.m_wsUnitDistanceGraph.addFacesGeometry(false);
        } else if (source == this.m_bComputeJammed) {
            this.m_wsUnitDistanceGraph.computeJammed();
        } else {
            super.actionPerformed(event);
        }
    }
}

