/*
 * Decompiled with CFR 0.152.
 */
package dev.geom;

import devProjection.PnProjection;
import jv.geom.PgBndPolygon;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygonSet;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.vecmath.PdBary;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PwBoundary;
import jvx.geom.PwCleanMesh;
import jvx.project.PjWorkshop;

public class PwUnitDistanceGraph
extends PjWorkshop {
    public PuDouble m_dDistance = new PuDouble("Distance");
    public PuInteger m_iRemoveBnd;
    public PgElementSet m_elementSet;
    public PgPolygonSet m_graph;
    private PiVector[] m_boundary;
    private PiVector m_histogram;
    private PiVector[] m_removedBoundary;

    public PwUnitDistanceGraph() {
        super("Unit Distance Graph");
        this.m_dDistance.setDefBounds(0.0, 12.0, 0.01, 0.1);
        this.m_dDistance.setDefValue(1.0);
        this.m_dDistance.addUpdateListener((PsUpdateIf)this);
        this.m_dDistance.init();
        this.m_iRemoveBnd = new PuInteger("BndRemove Size");
        this.m_iRemoveBnd.setDefBounds(0, 8, 1, 1);
        this.m_iRemoveBnd.setDefValue(6);
        this.m_iRemoveBnd.addUpdateListener((PsUpdateIf)this);
        this.m_iRemoveBnd.init();
        this.m_histogram = new PiVector(3);
        if (((Object)((Object)this)).getClass() == PwUnitDistanceGraph.class) {
            this.init();
        }
    }

    public void setDisplay(PvDisplayIf display) {
        super.setDisplay(display);
        if (this.m_display != null && this.m_graph != null && !this.m_display.containsGeometry((PgGeometryIf)this.m_graph)) {
            this.m_display.addGeometry((PgGeometryIf)this.m_graph);
        }
    }

    public void setGeometry(PgGeometry geom) {
        super.setGeometry(geom);
        this.m_elementSet = (PgElementSet)geom;
        if (this.m_elementSet.getDimOfElements() != 3) {
            PgElementSet.triangulate((PgElementSet)this.m_elementSet);
            PsDebug.message((String)"Geometry was not triangulated - now it is.");
            if (!this.m_elementSet.hasElementNormals()) {
                this.m_elementSet.makeElementNormals();
                PsDebug.message((String)"Geometry did not have element normals - now it has.");
            }
        }
        this.m_graph = new PgPolygonSet(3);
        this.m_graph.setName("unitDistanceGraph");
        this.m_graph.showVertices(true);
        if (this.m_display != null && this.m_graph != null && !this.m_display.containsGeometry((PgGeometryIf)this.m_graph)) {
            this.m_display.addGeometry((PgGeometryIf)this.m_graph);
        }
    }

    public boolean update(Object event) {
        if (event == this.m_dDistance) {
            return true;
        }
        if (event == this.m_iRemoveBnd) {
            return true;
        }
        return super.update(event);
    }

    public void compute() {
        int nov = this.m_graph.getNumVertices();
        boolean bFound = false;
        int i = 0;
        while (i < nov - 1) {
            if (this.m_graph.hasTagVertex(i, 1)) {
                int j = i + 1;
                while (j < nov) {
                    if (this.m_graph.hasTagVertex(j, 1)) {
                        this.addPoints(i, j);
                        bFound = true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (!bFound) {
            PsDebug.message((String)"There should be at least two selected vertices in the graph.");
        }
    }

    public void growDiskBreadthFirst() {
        if (this.m_graph.getNumVertices() < 2) {
            PsDebug.message((String)"Graph should have at least two vertices at start, close enough to each other.");
            return;
        }
        int i = 0;
        int j = 0;
        boolean bRun = true;
        while (bRun) {
            if (j == i) {
                j = 0;
                ++i;
            }
            this.addPoints(i, j);
            if (++j != this.m_graph.getNumVertices() - 1) continue;
            bRun = false;
        }
    }

    public void growDiskDepthFirst() {
        int nov = this.m_graph.getNumVertices();
        if (nov < 2) {
            PsDebug.message((String)"Graph should have at least two vertices at start, close enough to each other.");
            return;
        }
        int i = nov - 1;
        int j = i - 1;
        while (i != 0) {
            this.addPoints(i, j);
            if (nov != this.m_graph.getNumVertices()) {
                nov = this.m_graph.getNumVertices();
                i = nov - 1;
                j = i - 1;
            } else {
                --j;
            }
            if (j >= 0) continue;
            j = --i - 1;
        }
    }

    public void growByBoundaryHeuristic() {
        int maxRemove = this.m_iRemoveBnd.getValue();
        int numPoly = this.m_boundary.length;
        int mode = 2;
        int i = numPoly - 1;
        int j = numPoly - 2;
        while (mode != 0) {
            if (mode == 2 && i < 1) {
                mode = 1;
                i = numPoly - 1;
            }
            if (mode == 2) {
                this.checkBoundaryPair(i, j);
                if (this.m_boundary.length != numPoly) {
                    this.removeShortEdges(maxRemove);
                    numPoly = this.m_boundary.length;
                    i = numPoly - 1;
                    j = numPoly - 2;
                } else if (--j < 0) {
                    j = --i - 1;
                }
            }
            if (mode != 1) continue;
            if (i < 0) {
                mode = 0;
                continue;
            }
            this.checkBoundary(i);
            if (this.m_boundary.length != numPoly) {
                this.removeShortEdges(maxRemove);
                numPoly = this.m_boundary.length;
                i = numPoly - 1;
                j = numPoly - 2;
                mode = 2;
                continue;
            }
            --i;
        }
    }

    private void checkBoundaryPair(int bnd0, int bnd1) {
        PiVector poly0 = this.m_boundary[bnd0];
        PiVector poly1 = this.m_boundary[bnd1];
        int nov = this.m_graph.getNumVertices();
        int polySize0 = poly0.getSize();
        int polySize1 = poly1.getSize();
        int i = 0;
        while (i < polySize0) {
            boolean found = false;
            int j = 0;
            while (j < polySize1) {
                if (poly1.m_data[j] == poly0.m_data[i]) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                j = 0;
                while (j < polySize1) {
                    found = false;
                    int k = 0;
                    while (k < polySize0) {
                        if (poly0.m_data[k] == poly1.m_data[j]) {
                            found = true;
                            break;
                        }
                        ++k;
                    }
                    if (!found) {
                        this.addPoints(poly0.m_data[i], poly1.m_data[j]);
                        if (nov != this.m_graph.getNumVertices()) {
                            return;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void checkBoundary(int bndIndex) {
        PiVector poly = this.m_boundary[bndIndex];
        int nov = this.m_graph.getNumVertices();
        int polySize = poly.getSize();
        int i = polySize / 2;
        while (i > 0) {
            int j = 0;
            while (j < polySize) {
                this.addPoints(poly.m_data[j], poly.m_data[(j + i) % polySize]);
                if (nov != this.m_graph.getNumVertices()) {
                    return;
                }
                ++j;
            }
            --i;
        }
    }

    private void addPoints(int index0, int index1) {
        PdVector vertex0 = this.m_graph.getVertex(index0);
        PdVector vertex1 = this.m_graph.getVertex(index1);
        double unit = this.m_dDistance.getValue();
        double distV = PdVector.dist((PdVector)vertex0, (PdVector)vertex1) / 2.0;
        if (distV > unit) {
            return;
        }
        PdVector vDir = PdVector.subNew((PdVector)vertex1, (PdVector)vertex0);
        vDir.multScalar(0.5);
        PdVector midPoint = PdVector.blendNew((double)1.0, (PdVector)vertex0, (double)1.0, (PdVector)vDir);
        if (!vDir.normalize()) {
            return;
        }
        int noe = this.m_elementSet.getNumElements();
        int e = 0;
        while (e < noe) {
            PdVector normal = this.m_elementSet.getElementNormal(e);
            PiVector t = this.m_elementSet.getElement(e);
            double[] distM = new double[3];
            int i = 0;
            while (i < 3) {
                distM[i] = PdVector.dot((PdVector)PdVector.subNew((PdVector)this.m_elementSet.getVertex(t.m_data[i]), (PdVector)midPoint), (PdVector)vDir);
                ++i;
            }
            if (!(distM[0] < 0.0 && distM[1] < 0.0 && distM[2] < 0.0 || distM[0] > 0.0 && distM[1] > 0.0 && distM[2] > 0.0)) {
                PdVector[] ePoint = new PdVector[2];
                int found = 0;
                int i2 = 0;
                while (i2 < 3) {
                    if (distM[i2] * distM[(i2 + 1) % 3] < 0.0 || distM[i2] == 0.0 && distM[(i2 + 1) % 3] != 0.0 || distM[i2] >= 0.0 && distM[(i2 + 1) % 3] == 0.0) {
                        ePoint[found] = PdVector.blendNew((double)(-distM[(i2 + 1) % 3] / (distM[i2] - distM[(i2 + 1) % 3])), (PdVector)this.m_elementSet.getVertex(t.m_data[i2]), (double)(distM[i2] / (distM[i2] - distM[(i2 + 1) % 3])), (PdVector)this.m_elementSet.getVertex(t.m_data[(i2 + 1) % 3]));
                        ++found;
                    }
                    ++i2;
                }
                if (found >= 2) {
                    PdVector cPoint;
                    double distL;
                    PdVector cDir = PdVector.crossNew((PdVector)normal, (PdVector)vDir);
                    cDir.normalize();
                    double[] distE = new double[2];
                    int i3 = 0;
                    while (i3 < 2) {
                        distE[i3] = PdVector.dot((PdVector)PdVector.subNew((PdVector)ePoint[i3], (PdVector)midPoint), (PdVector)cDir);
                        ++i3;
                    }
                    if (distE[1] - distE[0] != 0.0 && !(distV * distV + (distL = PdVector.dist((PdVector)midPoint, (PdVector)(cPoint = PdVector.blendNew((double)(-distE[1] / (distE[0] - distE[1])), (PdVector)ePoint[0], (double)(distE[0] / (distE[0] - distE[1])), (PdVector)ePoint[1])))) * distL > unit * unit)) {
                        double a = Math.sqrt(unit * unit - distL * distL - distV * distV);
                        if (distE[0] <= a && a <= distE[1] || distE[0] >= a && a >= distE[1]) {
                            this.addPoint(index0, index1, e, PdVector.blendNew((double)1.0, (PdVector)cPoint, (double)a, (PdVector)cDir));
                        }
                        if (distE[0] <= -a && -a <= distE[1] || distE[0] >= -a && -a >= distE[1]) {
                            this.addPoint(index0, index1, e, PdVector.blendNew((double)1.0, (PdVector)cPoint, (double)(-a), (PdVector)cDir));
                        }
                    }
                }
            }
            ++e;
        }
    }

    private void addPoint(int index0, int index1, int elementIndex, PdVector vertex) {
        int nov = this.m_graph.getNumVertices();
        double unit = this.m_dDistance.getValue();
        int i = 0;
        while (i < nov) {
            if (i != index0 && i != index1 && PdVector.dist((PdVector)vertex, (PdVector)this.m_graph.getVertex(i)) < unit) {
                return;
            }
            ++i;
        }
        this.m_graph.addVertex(vertex);
        this.m_graph.assureVertexNormals();
        this.m_graph.setVertexNormal(this.m_graph.getNumVertices() - 1, (PdVector)this.m_elementSet.getElementNormal(elementIndex).clone());
        this.m_graph.addPolygon(new PiVector(index0, nov, index1));
        this.maintainBoundary(index0, index1, this.m_graph.getNumVertices() - 1);
    }

    private void maintainBoundary(int index0, int index1, int indexNew) {
        int numBnd;
        int[] polyIndex = new int[]{-1, -1};
        int[] locIndex = new int[]{-1, -1};
        if (this.m_boundary == null) {
            return;
        }
        int numPoly = this.m_boundary.length;
        int i = 0;
        while (i < numPoly) {
            int polySize = this.m_boundary[i].getSize();
            int j = 0;
            while (j < polySize) {
                if (this.m_boundary[i].m_data[j] == index0 || this.m_boundary[i].m_data[j] == index1) {
                    double aPart;
                    PdVector e0 = PdVector.subNew((PdVector)this.m_graph.getVertex(this.m_boundary[i].m_data[(j + polySize - 1) % polySize]), (PdVector)this.m_graph.getVertex(this.m_boundary[i].m_data[j]));
                    PdVector e1 = PdVector.subNew((PdVector)this.m_graph.getVertex(this.m_boundary[i].m_data[(j + 1) % polySize]), (PdVector)this.m_graph.getVertex(this.m_boundary[i].m_data[j]));
                    PdVector eN = PdVector.subNew((PdVector)this.m_graph.getVertex(indexNew), (PdVector)this.m_graph.getVertex(this.m_boundary[i].m_data[j]));
                    PdVector n = this.m_graph.getVertexNormal(this.m_boundary[i].m_data[j]);
                    e0.add(-PdVector.dot((PdVector)e0, (PdVector)n), n);
                    e1.add(-PdVector.dot((PdVector)e1, (PdVector)n), n);
                    eN.add(-PdVector.dot((PdVector)eN, (PdVector)n), n);
                    double aTotal = PdVector.angleWithOrientation((PdVector)e0, (PdVector)e1, (PdVector)n);
                    if (aTotal < 0.0) {
                        aTotal += Math.PI * 2;
                    }
                    if ((aPart = PdVector.angleWithOrientation((PdVector)e0, (PdVector)eN, (PdVector)n)) < 0.0) {
                        aPart += Math.PI * 2;
                    }
                    if (aPart < aTotal) {
                        if (this.m_boundary[i].m_data[j] == index0) {
                            if (polyIndex[0] != -1) {
                                PsDebug.message((String)("Found more than one possible boundary location (vertex " + indexNew + ")!"));
                            }
                            polyIndex[0] = i;
                            locIndex[0] = j;
                        } else {
                            if (polyIndex[1] != -1) {
                                PsDebug.message((String)("Found more than one possible boundary location (vertex " + indexNew + ")!"));
                            }
                            polyIndex[1] = i;
                            locIndex[1] = j;
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        if (polyIndex[0] == -1 || polyIndex[1] == -1) {
            PsDebug.message((String)("Found no possible boundary location (vertex " + indexNew + ")!"));
            return;
        }
        if (polyIndex[0] == polyIndex[1]) {
            numBnd = this.m_boundary.length;
            PiVector[] newBnd = new PiVector[numBnd + 1];
            int i2 = 0;
            while (i2 < numBnd) {
                newBnd[i2] = this.m_boundary[i2];
                ++i2;
            }
            PiVector poly = this.m_boundary[polyIndex[0]];
            int polySize = poly.getSize();
            PiVector split0 = new PiVector((locIndex[1] - locIndex[0] + polySize) % polySize + 2);
            int i3 = 0;
            while (i3 < (locIndex[1] - locIndex[0] + polySize) % polySize + 1) {
                split0.m_data[i3] = poly.m_data[(locIndex[0] + i3) % polySize];
                ++i3;
            }
            split0.m_data[(locIndex[1] - locIndex[0] + polySize) % polySize + 1] = indexNew;
            PiVector split1 = new PiVector((locIndex[0] - locIndex[1] + polySize) % polySize + 2);
            int i4 = 0;
            while (i4 < (locIndex[0] - locIndex[1] + polySize) % polySize + 1) {
                split1.m_data[i4] = poly.m_data[(locIndex[1] + i4) % polySize];
                ++i4;
            }
            split1.m_data[(locIndex[0] - locIndex[1] + polySize) % polySize + 1] = indexNew;
            newBnd[polyIndex[0]] = split0;
            newBnd[numBnd] = split1;
            this.m_boundary = newBnd;
        } else {
            numBnd = this.m_boundary.length;
            PiVector[] newBnd = new PiVector[numBnd - 1];
            int found = 0;
            int lower = -1;
            int i5 = 0;
            while (i5 < numBnd) {
                if (i5 == polyIndex[0] || i5 == polyIndex[1]) {
                    if (found == 0) {
                        lower = i5;
                    }
                    ++found;
                }
                if (found < 2) {
                    newBnd[i5] = this.m_boundary[i5];
                } else if (i5 < numBnd - 1) {
                    newBnd[i5] = this.m_boundary[i5 + 1];
                }
                ++i5;
            }
            int ps0 = this.m_boundary[polyIndex[0]].getSize();
            int ps1 = this.m_boundary[polyIndex[1]].getSize();
            PiVector joined = new PiVector(ps0 + ps1 + 4);
            int i6 = 0;
            while (i6 <= ps0) {
                joined.m_data[i6] = this.m_boundary[polyIndex[0]].m_data[(locIndex[0] + i6) % ps0];
                ++i6;
            }
            joined.m_data[ps0 + 1] = indexNew;
            i6 = 0;
            while (i6 <= ps1) {
                joined.m_data[ps0 + 2 + i6] = this.m_boundary[polyIndex[1]].m_data[(locIndex[1] + i6) % ps1];
                ++i6;
            }
            joined.m_data[ps0 + ps1 + 3] = indexNew;
            newBnd[lower] = joined;
            this.m_boundary = newBnd;
        }
    }

    protected void initPoints() {
        int nov = this.m_graph.getNumVertices();
        if (nov < 1) {
            return;
        }
        if (nov < 3) {
            this.m_boundary = null;
            this.m_histogram.setConstant(0);
            this.m_removedBoundary = null;
        }
        this.m_graph.assureVertexNormals();
        PdBary[] b = PnProjection.projectPointSetOntoElementSet((PgPointSet)this.m_graph, this.m_elementSet);
        int i = 0;
        while (i < nov) {
            this.m_graph.setVertexNormal(i, (PdVector)this.m_elementSet.getElementNormal(b[i].m_elementInd).clone());
            ++i;
        }
        if (nov == 2) {
            this.addPoints(0, 1);
            nov = this.m_graph.getNumVertices();
            if (nov == 3) {
                this.m_boundary = new PiVector[2];
                this.m_boundary[0] = new PiVector(0, 1, 2);
                this.m_boundary[1] = new PiVector(0, 2, 1);
            } else if (nov == 4) {
                this.m_boundary = new PiVector[2];
                this.m_boundary[0] = new PiVector(0, 2, 1, 3);
                this.m_boundary[1] = new PiVector(0, 3, 1, 2);
            }
        }
    }

    protected void initByPolygons() {
        PgPolygonSet gc = (PgPolygonSet)this.m_graph.clone();
        PwCleanMesh.joinPolygons((PgPolygonSet)gc);
        int nop = gc.getNumPolygons();
        this.m_boundary = new PiVector[2 * nop];
        int i = 0;
        while (i < nop) {
            this.m_boundary[2 * i] = (PiVector)gc.getPolygon(i).clone();
            int s = this.m_boundary[2 * i].getSize();
            if (this.m_boundary[2 * i].m_data[0] == this.m_boundary[2 * i].m_data[s - 1]) {
                this.m_boundary[2 * i].setSize(s - 1);
            }
            this.m_boundary[2 * i + 1] = (PiVector)gc.getPolygon(i).clone();
            if (this.m_boundary[2 * i + 1].m_data[0] == this.m_boundary[2 * i + 1].m_data[s - 1]) {
                this.m_boundary[2 * i + 1].setSize(s - 1);
            }
            this.m_boundary[2 * i + 1].invert();
            ++i;
        }
    }

    protected void initByBoundary() {
        double dist = this.m_dDistance.getValue();
        PgElementSet ce = (PgElementSet)this.m_elementSet.clone();
        int nov = ce.getNumVertices();
        int i = 0;
        while (i < nov) {
            ++i;
        }
        PwBoundary.makeBoundary((PgElementSet)ce);
        PgBndPolygon[] bnd = ce.getBoundaries();
        int numBnd = bnd.length;
        int b = 0;
        while (b < numBnd) {
            PiVector vi = bnd[b].getVertexInd();
            int bl = vi.getSize();
            PdVector startVertex = (PdVector)ce.getVertex(vi.m_data[0]).clone();
            int nop = this.m_graph.getNumVertices();
            this.m_graph.addVertex(startVertex);
            this.m_graph.setVertexNormal(nop, (PdVector)ce.getElementNormal(bnd[b].getElementInd().m_data[0]).clone());
            PdVector currentVertex = startVertex;
            int i2 = 1;
            while (i2 < bl) {
                PdVector v0 = ce.getVertex(vi.m_data[i2 - 1]);
                PdVector v1 = ce.getVertex(vi.m_data[i2]);
                PdVector dir = PdVector.subNew((PdVector)v1, (PdVector)v0);
                double edgeLength = dir.length();
                if (!dir.normalize()) {
                    PsDebug.message((String)"Error in tracing boundary, edge direction cannot be normalized.");
                } else {
                    PdVector diff = PdVector.subNew((PdVector)v0, (PdVector)currentVertex);
                    double projected = PdVector.dot((PdVector)diff, (PdVector)dir);
                    PdVector projectedCenter = PdVector.blendNew((double)1.0, (PdVector)v0, (double)(-projected), (PdVector)dir);
                    double lineDist = PdVector.dist((PdVector)currentVertex, (PdVector)projectedCenter);
                    if (lineDist > dist) {
                        PsDebug.message((String)("Error in tracing boundary, distance became too big - polygon " + b + "."));
                    } else {
                        double radius = Math.sqrt(dist * dist - lineDist * lineDist);
                        if (radius >= projected && radius <= projected + edgeLength) {
                            PdVector newPoint = PdVector.blendNew((double)1.0, (PdVector)projectedCenter, (double)radius, (PdVector)dir);
                            if (!(PdVector.dist((PdVector)currentVertex, (PdVector)startVertex) > dist / 2.0) || !(PdVector.dist((PdVector)newPoint, (PdVector)startVertex) < dist)) {
                                int numPoints = this.m_graph.getNumVertices();
                                this.m_graph.addVertex(newPoint);
                                this.m_graph.assureVertexNormals();
                                this.m_graph.setVertexNormal(numPoints, (PdVector)ce.getElementNormal(bnd[b].getElementInd().m_data[i2 - 1]).clone());
                                this.m_graph.addPolygon(new PiVector(numPoints - 1, numPoints));
                                currentVertex = newPoint;
                                --i2;
                            }
                        }
                    }
                }
                ++i2;
            }
            ++b;
        }
        PwCleanMesh.joinPolygons((PgPolygonSet)this.m_graph);
        this.initByPolygons();
    }

    private void removeShortEdges(int max) {
        if (this.m_graph.getNumVertices() < 2 * max) {
            return;
        }
        int numBnd = this.m_boundary.length;
        if (numBnd == 0) {
            return;
        }
        int numNew = 0;
        boolean[] bRemove = new boolean[numBnd];
        int i = 0;
        while (i < numBnd) {
            int bndSize = this.m_boundary[i].getSize();
            if (bndSize > max) {
                bRemove[i] = false;
                ++numNew;
            } else {
                double as = 0.0;
                int j = 0;
                while (j < bndSize) {
                    double a = PdVector.angleWithOrientation((PdVector)PdVector.subNew((PdVector)this.m_graph.getVertex(this.m_boundary[i].m_data[(j - 1 + bndSize) % bndSize]), (PdVector)this.m_graph.getVertex(this.m_boundary[i].m_data[j])), (PdVector)PdVector.subNew((PdVector)this.m_graph.getVertex(this.m_boundary[i].m_data[(j + 1 + bndSize) % bndSize]), (PdVector)this.m_graph.getVertex(this.m_boundary[i].m_data[j])), (PdVector)this.m_graph.getVertexNormal(this.m_boundary[i].m_data[j]));
                    if (a < 0.0) {
                        a += Math.PI * 2;
                    }
                    as += a;
                    ++j;
                }
                if (as < Math.PI * (double)bndSize) {
                    bRemove[i] = true;
                } else {
                    bRemove[i] = false;
                    ++numNew;
                }
            }
            ++i;
        }
        if (numNew == numBnd) {
            return;
        }
        PiVector[] newBnd = new PiVector[numNew];
        numNew = 0;
        int i2 = 0;
        while (i2 < numBnd) {
            if (!bRemove[i2]) {
                newBnd[numNew] = this.m_boundary[i2];
                ++numNew;
            } else {
                if (this.m_histogram.getSize() < this.m_boundary[i2].getSize() + 1) {
                    this.m_histogram.setSize(this.m_boundary[i2].getSize() + 1);
                }
                int n = this.m_boundary[i2].getSize();
                this.m_histogram.m_data[n] = this.m_histogram.m_data[n] + 1;
                if (this.m_removedBoundary == null) {
                    this.m_removedBoundary = new PiVector[]{this.m_boundary[i2]};
                } else {
                    int nr = this.m_removedBoundary.length;
                    this.m_removedBoundary = PiVector.realloc((PiVector[])this.m_removedBoundary, (int)(nr + 1));
                    this.m_removedBoundary[nr] = this.m_boundary[i2];
                }
            }
            ++i2;
        }
        this.m_boundary = newBnd;
    }

    protected void printHistogram() {
        PiVector histogram = (PiVector)this.m_histogram.clone();
        int numPoly = this.m_boundary.length;
        int i = 0;
        while (i < numPoly) {
            if (histogram.getSize() < this.m_boundary[i].getSize() + 1) {
                histogram.setSize(this.m_boundary[i].getSize() + 1);
            }
            int n = this.m_boundary[i].getSize();
            histogram.m_data[n] = histogram.m_data[n] + 1;
            ++i;
        }
        PsDebug.message((String)"================================================");
        PsDebug.message((String)"Histogram of cell sizes:");
        PsDebug.message((String)"================================================");
        i = 0;
        while (i < histogram.getSize()) {
            if (histogram.m_data[i] != 0) {
                PsDebug.message((String)(String.valueOf(histogram.m_data[i]) + " cells of size " + i));
            }
            ++i;
        }
        PsDebug.message((String)"================================================");
        int nov = this.m_graph.getNumVertices();
        PiVector valence = new PiVector(nov);
        int nop = this.m_graph.getNumPolygons();
        int i2 = 0;
        while (i2 < nop) {
            PiVector poly = this.m_graph.getPolygon(i2);
            int polySize = poly.getSize();
            int j = 0;
            while (j < polySize - 1) {
                int n = poly.m_data[j];
                valence.m_data[n] = valence.m_data[n] + 1;
                int n2 = poly.m_data[j + 1];
                valence.m_data[n2] = valence.m_data[n2] + 1;
                ++j;
            }
            ++i2;
        }
        PiVector valenceHistogram = new PiVector(12);
        int i3 = 0;
        while (i3 < nov) {
            if (valenceHistogram.getSize() < valence.m_data[i3] + 1) {
                valenceHistogram.setSize(valence.m_data[i3] + 1);
            }
            int n = valence.m_data[i3];
            valenceHistogram.m_data[n] = valenceHistogram.m_data[n] + 1;
            ++i3;
        }
        PsDebug.message((String)"Histogram of vertex valences:");
        PsDebug.message((String)"================================================");
        i3 = 0;
        while (i3 < valenceHistogram.getSize()) {
            if (valenceHistogram.m_data[i3] != 0) {
                PsDebug.message((String)(String.valueOf(valenceHistogram.m_data[i3]) + " points with valence " + i3));
            }
            ++i3;
        }
        PsDebug.message((String)"================================================");
    }

    protected void addFacesGeometry(boolean bRemovedOnly) {
        if (this.m_display == null) {
            return;
        }
        if (bRemovedOnly && (this.m_removedBoundary == null || this.m_removedBoundary.length == 0)) {
            PsDebug.message((String)"No removed boundaries found - don't add ElementSet");
            return;
        }
        if (!(bRemovedOnly || this.m_boundary != null && this.m_boundary.length != 0 || this.m_removedBoundary != null && this.m_removedBoundary.length != 0)) {
            PsDebug.message((String)"No boundaries found - don't add ElementSet");
            return;
        }
        PgElementSet faceSet = this.computeFaces(bRemovedOnly);
        this.m_display.addGeometry((PgGeometryIf)faceSet);
        this.m_display.update((Object)faceSet);
    }

    private PgElementSet computeFaces(boolean bRemovedOnly) {
        int norb;
        PgElementSet faceSet = new PgElementSet(3);
        faceSet.showVertices(false);
        int nov = this.m_graph.getNumVertices();
        faceSet.setNumVertices(nov);
        int i = 0;
        while (i < nov) {
            faceSet.setVertex(i, (PdVector)this.m_graph.getVertex(i).clone());
            ++i;
        }
        int noe = norb = this.m_removedBoundary.length;
        if (!bRemovedOnly) {
            noe += this.m_boundary.length;
        }
        faceSet.setNumElements(noe);
        int i2 = 0;
        while (i2 < this.m_removedBoundary.length) {
            faceSet.setElement(i2, (PiVector)this.m_removedBoundary[i2].clone());
            ++i2;
        }
        if (!bRemovedOnly) {
            int numBnd = this.m_boundary.length;
            int i3 = 0;
            while (i3 < numBnd) {
                faceSet.setElement(norb + i3, (PiVector)this.m_boundary[i3].clone());
                ++i3;
            }
        }
        return faceSet;
    }

    protected void computeJammed() {
        int nov = this.m_graph.getNumVertices();
        PiVector[] neigh = new PiVector[nov];
        int i = 0;
        while (i < nov) {
            neigh[i] = new PiVector();
            ++i;
        }
        int nop = this.m_graph.getNumPolygons();
        int i2 = 0;
        while (i2 < nop) {
            PiVector poly = this.m_graph.getPolygon(i2);
            int size = poly.getSize();
            int j = 0;
            while (j < size - 1) {
                neigh[poly.m_data[j]].addEntry(poly.m_data[j + 1]);
                neigh[poly.m_data[j + 1]].addEntry(poly.m_data[j]);
                ++j;
            }
            ++i2;
        }
        int numGood = 0;
        int i3 = 0;
        while (i3 < nov) {
            PdVector normal = this.m_graph.getVertexNormal(i3);
            boolean bGood = true;
            int nn = neigh[i3].getSize();
            int j = 0;
            while (j < nn) {
                boolean bFoundPositive = false;
                PdVector e1 = PdVector.subNew((PdVector)this.m_graph.getVertex(neigh[i3].m_data[j]), (PdVector)this.m_graph.getVertex(i3));
                e1.add(-PdVector.dot((PdVector)normal, (PdVector)e1), normal);
                int k = 1;
                while (k < nn) {
                    PdVector e2 = PdVector.subNew((PdVector)this.m_graph.getVertex(neigh[i3].m_data[(j + k) % nn]), (PdVector)this.m_graph.getVertex(i3));
                    e2.add(-PdVector.dot((PdVector)normal, (PdVector)e2), normal);
                    if (PdVector.angleWithOrientation((PdVector)e1, (PdVector)e2, (PdVector)normal) > 0.0) {
                        bFoundPositive = true;
                    }
                    ++k;
                }
                if (!bFoundPositive) {
                    bGood = false;
                }
                ++j;
            }
            if (bGood) {
                ++numGood;
            }
            ++i3;
        }
        PsDebug.message((String)("Jammed points: " + numGood + " of " + nov));
    }
}

