/*
 * Decompiled with CFR 0.152.
 */
package dev.geom;

import jv.anim.PsAnimation;
import jv.anim.PsTimeEvent;
import jv.anim.PsTimeListenerIf;
import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PwModel;
import jvx.project.PjWorkshop;

public class PwUnfoldAnimation
extends PjWorkshop
implements PsTimeListenerIf {
    protected PgElementSet m_geom;
    protected PsAnimation m_unfoldAnimation = new PsAnimation();
    protected PgElementSet m_unfoldedGeom;
    protected PdVector[] m_unfoldedVertices;
    protected PdVector[] m_unfoldedTextures;
    protected double m_factor;
    protected double m_z;

    public PwUnfoldAnimation(String name) {
        super(name);
        this.m_unfoldAnimation.setName("Texture animation");
        this.m_unfoldAnimation.addTimeListener((PsTimeListenerIf)this);
        this.m_unfoldAnimation.setTimeInterval(0.0, 1.0, 0.02, 0.1);
        this.m_unfoldAnimation.getAnimationPanel().setVisible(true);
        this.m_unfoldedGeom = new PgElementSet(3);
        this.m_unfoldedGeom.setName("Unfolded geometry");
        if (((Object)((Object)this)).getClass() == PwUnfoldAnimation.class) {
            this.init();
        }
    }

    public void reset() {
        super.reset();
        if (this.m_geom == null || this.m_geomSave == null) {
            return;
        }
        this.m_geom.copy((PsObject)this.m_geomSave);
    }

    public void start() {
        PvDisplayIf disp = this.getDisplay();
        if (disp != null) {
            disp.addGeometry((PgGeometryIf)this.m_unfoldedGeom);
        }
    }

    public void setGeometry(PgGeometry geom) {
        if (geom == null || !(geom instanceof PgElementSet)) {
            PsDebug.warning((String)"Geom is not an element set.");
            return;
        }
        super.setGeometry(geom);
        this.m_geom = (PgElementSet)geom;
        this.unfoldGeometry();
    }

    private void unfoldGeometry() {
        if (!this.m_geom.hasElementTextures()) {
            PsDebug.warning((String)"No element textures set.");
            return;
        }
        this.m_unfoldedGeom.copy((PsObject)this.m_geom);
        PwModel.shrink((PgElementSet)this.m_unfoldedGeom, (double)1.0);
        int numElements = this.m_unfoldedGeom.getNumElements();
        int numVertices = this.m_unfoldedGeom.getNumVertices();
        this.m_unfoldedVertices = PdVector.copyNew((PdVector[])this.m_unfoldedGeom.getVertices());
        PdVector[][] elementTexture = this.m_geom.getElementTextures();
        this.m_unfoldedGeom.assureVertexTextures();
        this.m_unfoldedTextures = this.m_unfoldedGeom.getVertexTextures();
        int i = 0;
        while (i < numElements) {
            PiVector element = this.m_unfoldedGeom.getElement(i);
            int elSize = element.getSize();
            int j = 0;
            while (j < elSize) {
                this.m_unfoldedTextures[element.m_data[j]] = PdVector.copyNew((PdVector)elementTexture[i][j]);
                ++j;
            }
            ++i;
        }
        this.m_unfoldedGeom.showVertexTexture(true);
        this.m_unfoldedGeom.showElementTexture(false);
        this.m_unfoldedGeom.setElementTextures(null);
        double diameter = this.m_geom.getDiameter();
        PdVector max = new PdVector(2);
        PdVector min = new PdVector(2);
        PdVector.max((PdVector)max, (PdVector[])this.m_unfoldedTextures, (int)numVertices);
        PdVector.min((PdVector)min, (PdVector[])this.m_unfoldedTextures, (int)numVertices);
        max.sub(min);
        this.m_factor = 4.0 * diameter / max.length();
        PdVector[] bnd = this.m_geom.getBounds();
        this.m_z = bnd[1].m_data[2] + 0.2 * diameter;
    }

    public boolean setTime(PsTimeEvent timeEvent) {
        double time = timeEvent.getTime();
        int numVertices = this.m_unfoldedGeom.getNumVertices();
        int i = 0;
        while (i < numVertices) {
            double[] coord = this.m_unfoldedTextures[i].m_data;
            this.m_unfoldedGeom.getVertex(i).blend(1.0 - time, this.m_unfoldedVertices[i], time, new PdVector(this.m_factor * coord[0], this.m_factor * coord[1], this.m_z));
            ++i;
        }
        this.m_unfoldedGeom.update((Object)this.m_unfoldedGeom);
        return true;
    }

    public PsAnimation getAnimation() {
        return this.m_unfoldAnimation;
    }

    public boolean hasAnimation() {
        return this.m_unfoldAnimation != null;
    }

    public void setAnimation(PsAnimation anAnimation) {
        this.m_unfoldAnimation = anAnimation;
    }
}

