/*
 * Decompiled with CFR 0.152.
 */
package dev.geom;

import java.awt.Color;
import java.util.Vector;
import jv.geom.PgEdgeStar;
import jv.geom.PgElementSet;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgVertexStar;
import jvx.project.PjWorkshop;

public class PwTex2Triang
extends PjWorkshop {
    private static final boolean m_bComputeHierarchy = false;
    private static final int m_returnLevel = 0;
    private static final boolean m_bBarycentricNames = false;
    private static final boolean m_bNoConnectivity = false;
    private static boolean m_bPointCloud = false;

    public PwTex2Triang() {
        super(PsConfig.getMessage((boolean)true, (int)51000, (String)"Texture to Triangulation"));
        if (((Object)((Object)this)).getClass() == PwTex2Triang.class) {
            this.init();
        }
    }

    public static PgElementSet tex2Triang(PgElementSet geom, int quantization) {
        if (geom.getDimOfElements() != 3) {
            PsDebug.warning((String)"Geometry is not triangulated.");
            return null;
        }
        if (!geom.hasElementTextures()) {
            PsDebug.warning((String)"Geometry does not have element texture.");
            return null;
        }
        PwTex2Triang.rotateTextures(geom);
        PiVector[][] intTex = PwTex2Triang.quantizeElementTexture(geom, quantization);
        return PwTex2Triang.ints2Triang(geom, quantization, intTex);
    }

    public static PgElementSet quantizedTex2Triang(PgElementSet geom, PiVector[][] quantizedTexture, int quantization) {
        if (geom.getDimOfElements() != 3) {
            PsDebug.warning((String)"Geometry is not triangulated.");
            return null;
        }
        int noe = geom.getNumElements();
        if (quantizedTexture == null || quantizedTexture.length != noe) {
            PsDebug.warning((String)"Quantized texture does not exist or has wrong length.");
            return null;
        }
        PwTex2Triang.rotateData(quantizedTexture);
        PwTex2Triang.assurePositiveTexs(geom, quantizedTexture, quantization);
        int i = 0;
        while (i < noe) {
            int j = 0;
            while (j < 3) {
                int k = 0;
                while (k < 2) {
                    int n = k++;
                    quantizedTexture[i][j].m_data[n] = quantizedTexture[i][j].m_data[n] + quantization;
                }
                ++j;
            }
            ++i;
        }
        return PwTex2Triang.ints2Triang(geom, quantization, quantizedTexture);
    }

    private static void assurePositiveTexs(PgElementSet geom, PiVector[][] texture, int quantization) {
        int numElements = geom.getNumElements();
        int minimumU = Integer.MAX_VALUE;
        int minimumV = Integer.MAX_VALUE;
        int e = 0;
        while (e < numElements) {
            int i = 0;
            while (i < 3) {
                int u = texture[e][i].m_data[0];
                int v = texture[e][i].m_data[1];
                if (u < minimumU) {
                    minimumU = u;
                }
                if (v < minimumV) {
                    minimumV = v;
                }
                ++i;
            }
            ++e;
        }
        int shiftU = 0;
        if (minimumU < 0) {
            shiftU = quantization * (int)Math.ceil(-minimumU / quantization);
        }
        int shiftV = 0;
        if (minimumV < 0) {
            shiftV = quantization * (int)Math.ceil(-minimumV / quantization);
        }
        int e2 = 0;
        while (e2 < numElements) {
            int i = 0;
            while (i < 3) {
                texture[e2][i].m_data[0] = texture[e2][i].m_data[0] + shiftU;
                texture[e2][i].m_data[1] = texture[e2][i].m_data[1] + shiftV;
                ++i;
            }
            ++e2;
        }
    }

    private static PgElementSet ints2Triang(PgElementSet geom, int quantization, PiVector[][] intTex) {
        return PwTex2Triang.ints2Triang(geom, quantization, intTex, 0, null);
    }

    private static PgElementSet ints2Triang(PgElementSet geom, int quantization, PiVector[][] intTex, int numRefineLevels, PiVector levels) {
        int numAddedVertices;
        int dim = geom.getDimOfVertices();
        PgElementSet triangGeom = new PgElementSet(dim);
        int i = 0;
        while (i < intTex.length) {
            int j = 0;
            while (j < intTex[i].length) {
                int k = 0;
                while (k < intTex[i][j].getSize()) {
                    int n = k++;
                    intTex[i][j].m_data[n] = intTex[i][j].m_data[n] << numRefineLevels;
                }
                ++j;
            }
            ++i;
        }
        triangGeom.setName("Triangulation of " + geom.getName());
        Vector assignmentVector = new Vector();
        Vector newVertexTexVector = new Vector();
        int numNew = PwTex2Triang.addGridVertices(geom, intTex, quantization, assignmentVector, newVertexTexVector, triangGeom);
        boolean[] bGridPoint = new boolean[numNew];
        int i2 = 0;
        while (i2 < numNew) {
            bGridPoint[i2] = ((int[][])newVertexTexVector.elementAt(i2))[0][1] % quantization == 0 && ((int[][])newVertexTexVector.elementAt(i2))[0][2] % quantization == 0;
            ++i2;
        }
        numNew = PwTex2Triang.addEdgeIntersections(geom, intTex, quantization, assignmentVector, newVertexTexVector, triangGeom, numNew);
        int[][] vertexInElement = PwTex2Triang.collectVerticesToElements(geom, assignmentVector);
        Vector edgeCollapseVector = new Vector();
        numNew = PwTex2Triang.addinteriorVertices(geom, vertexInElement, quantization, numNew, newVertexTexVector, assignmentVector, intTex, edgeCollapseVector);
        int i3 = numAddedVertices = triangGeom.getNumVertices();
        while (i3 < numNew) {
            int[][] tex = (int[][])newVertexTexVector.elementAt(i3);
            int elIndex = tex[0][0];
            PdMatrix M = new PdMatrix(3, 3);
            int j = 0;
            while (j < 3) {
                M.m_data[0][j] = intTex[elIndex][j].m_data[0];
                M.m_data[1][j] = intTex[elIndex][j].m_data[1];
                M.m_data[2][j] = 1.0;
                ++j;
            }
            PdVector b = new PdVector((double)tex[0][1], (double)tex[0][2], 1.0);
            M.invert();
            b.leftMultMatrix(M);
            PiVector element = geom.getElement(elIndex);
            PdVector newVertex = PdVector.blendNew((double)b.m_data[0], (PdVector)geom.getVertex(element.m_data[0]), (double)b.m_data[1], (PdVector)geom.getVertex(element.m_data[1]));
            newVertex.blendBase(newVertex, b.m_data[2], geom.getVertex(element.m_data[2]));
            triangGeom.addVertex(newVertex);
            ++i3;
        }
        if (levels != null) {
            PwTex2Triang.computeHierarchyLevels(triangGeom, newVertexTexVector, quantization, numRefineLevels, levels);
        }
        int[][] neighbourVertex = PwTex2Triang.joinConnectivityInformation(newVertexTexVector, numNew);
        PwTex2Triang.getElements(triangGeom, neighbourVertex, numNew);
        if (!m_bPointCloud) {
            int i4 = 0;
            while (i4 < bGridPoint.length) {
                if (bGridPoint[i4]) {
                    triangGeom.setTagVertex(i4, 1);
                }
                ++i4;
            }
            if (levels != null) {
                i4 = 0;
                while (i4 < triangGeom.getNumVertices()) {
                    String name = triangGeom.getVertex(i4).getName();
                    if (name == null) {
                        name = "";
                    }
                    triangGeom.getVertex(i4).setName(String.valueOf(name) + "#" + levels.m_data[i4]);
                    ++i4;
                }
            }
            PwTex2Triang.removeEdgeVertices(triangGeom, numNew, edgeCollapseVector);
            triangGeom.assureDimOfElements();
            int numTriangles = triangGeom.getNumElements();
            int i5 = 0;
            while (i5 < numTriangles) {
                PwTex2Triang.removeDuplicatePiVectorEntries(triangGeom.getElement(i5));
                ++i5;
            }
            triangGeom.makeNeighbour();
            int noe = triangGeom.getNumElements();
            int i6 = 0;
            while (i6 < noe) {
                if (triangGeom.getElement(i6).getSize() > 3) {
                    triangGeom.setTagElement(i6, 1);
                }
                ++i6;
            }
            triangGeom.makeElementNormals();
            triangGeom.makeVertexNormals();
            triangGeom.setGlobalElementColor(Color.white);
        }
        return triangGeom;
    }

    private static void computeHierarchyLevels(PgElementSet triangGeom, Vector newVertexTexVector, int quantization, int numRefineLevels, PiVector levels) {
        if (levels == null) {
            return;
        }
        int numQuadVertices = triangGeom.getNumVertices();
        int size = newVertexTexVector.size();
        if (size != numQuadVertices) {
            PsDebug.warning((String)"Wrong size.");
            return;
        }
        levels.setSize(triangGeom.getNumVertices());
        int i = 0;
        while (i < size) {
            int[][] ci = (int[][])newVertexTexVector.elementAt(i);
            if (ci.length > 0) {
                int level = PwTex2Triang.numberOfTrailingZeros(ci[0][1] / quantization | ci[0][2] / quantization);
                level = Math.min(level, numRefineLevels);
                levels.m_data[i] = numRefineLevels - level;
            }
            ++i;
        }
    }

    private static int numberOfTrailingZeros(int i) {
        if (i == 0) {
            return 32;
        }
        int n = 31;
        int y = i << 16;
        if (y != 0) {
            n -= 16;
            i = y;
        }
        if ((y = i << 8) != 0) {
            n -= 8;
            i = y;
        }
        if ((y = i << 4) != 0) {
            n -= 4;
            i = y;
        }
        if ((y = i << 2) != 0) {
            n -= 2;
            i = y;
        }
        return n - (i << 1 >>> 31);
    }

    private static boolean removeDuplicatePiVectorEntries(PiVector v) {
        int pos = 0;
        int size = v.getSize();
        int i = 0;
        while (i < size) {
            int indexOf = v.getIndexOf(v.m_data[i]);
            if (indexOf < 0 || indexOf >= pos) {
                v.m_data[pos++] = v.m_data[i];
            }
            ++i;
        }
        v.setSize(pos);
        return pos != size;
    }

    /*
     * Unable to fully structure code
     */
    private static PiVector[][] quantizeElementTexture(PgElementSet geom, int quantization) {
        noe = geom.getNumElements();
        tex = geom.getElementTextures();
        max = new int[]{0x7FFFFFFF, 0x7FFFFFFF};
        i = 0;
        while (i < noe) {
            j = 0;
            while (j < 3) {
                k = 0;
                while (k < 2) {
                    if (tex[i][j].m_data[k] < (double)max[k]) {
                        max[k] = (int)tex[i][j].m_data[k];
                        if (tex[i][j].m_data[k] < 0.0) {
                            v0 = k;
                            max[v0] = max[v0] - 1;
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        ** GOTO lbl28
        {
            v1 = i;
            max[v1] = max[v1] - 1;
            do {
                if (max[i] % quantization != 0) continue block3;
                ++i;
lbl28:
                // 2 sources

            } while (i < 2);
        }
        intTex = new PiVector[noe][];
        i = 0;
        while (i < noe) {
            intTex[i] = PiVector.realloc(null, (int)3, (int)2);
            j = 0;
            while (j < 3) {
                k = 0;
                while (k < 2) {
                    intTex[i][j].m_data[k] = (int)(tex[i][j].m_data[k] - (double)max[k]);
                    v2 = k++;
                    tex[i][j].m_data[v2] = tex[i][j].m_data[v2] / (double)quantization;
                }
                ++j;
            }
            ++i;
        }
        return intTex;
    }

    /*
     * Unable to fully structure code
     */
    private static int addGridVertices(PgElementSet geom, PiVector[][] intTex, int quantization, Vector assignmentVector, Vector newVertexTexVector, PgElementSet triangGeom) {
        nov = geom.getNumVertices();
        numNew = 0;
        vs = new PgVertexStar();
        elementPerVertex = PgVertexStar.getElementPerVertex((PgElementSet)geom).m_data;
        v = 0;
        while (v < nov) {
            block28: {
                vs.makeVertexStar(geom, v, elementPerVertex[v]);
                elInd = vs.getElement();
                locInd = vs.getVertexLocInd();
                numVSEl = vs.getSize();
                if (intTex[elInd.m_data[0]][locInd.m_data[0]].m_data[0] % quantization != 0 && intTex[elInd.m_data[0]][locInd.m_data[0]].m_data[1] % quantization != 0 && (intTex[elInd.m_data[0]][locInd.m_data[0]].m_data[0] + intTex[elInd.m_data[0]][locInd.m_data[0]].m_data[1]) % quantization != 0) break block28;
                bGridPoint = intTex[elInd.m_data[0]][locInd.m_data[0]].m_data[0] % quantization == 0 && intTex[elInd.m_data[0]][locInd.m_data[0]].m_data[1] % quantization == 0;
                numAssignments = 0;
                newIntTex = new int[numVSEl][9];
                k = 0;
                while (k < numVSEl) {
                    block30: {
                        block31: {
                            block32: {
                                block29: {
                                    el = elInd.m_data[k];
                                    if (!bGridPoint) break block29;
                                    assignmentVector.addElement(new int[]{el, numNew});
                                    ++numAssignments;
                                    newIntTex[k][0] = el;
                                    newIntTex[k][1] = intTex[el][locInd.m_data[k]].m_data[0];
                                    newIntTex[k][2] = intTex[el][locInd.m_data[k]].m_data[1];
                                    break block30;
                                }
                                coordIndex = -1;
                                m = 0;
                                while (m < 2) {
                                    if (intTex[el][locInd.m_data[k]].m_data[(m + 1) % 2] % quantization == 0) {
                                        coordIndex = m;
                                    }
                                    ++m;
                                }
                                if (coordIndex != -1) break block31;
                                if (intTex[el][locInd.m_data[k]].m_data[0] + intTex[el][locInd.m_data[k]].m_data[1] >= intTex[el][(locInd.m_data[k] + 1) % 3].m_data[0] + intTex[el][(locInd.m_data[k] + 1) % 3].m_data[1] || intTex[el][locInd.m_data[k]].m_data[0] + intTex[el][locInd.m_data[k]].m_data[1] >= intTex[el][(locInd.m_data[k] + 2) % 3].m_data[0] + intTex[el][(locInd.m_data[k] + 2) % 3].m_data[1]) break block32;
                                newIntTex[k][0] = -1;
                                break block30;
                            }
                            if (intTex[el][locInd.m_data[k]].m_data[0] + intTex[el][locInd.m_data[k]].m_data[1] <= intTex[el][(locInd.m_data[k] + 1) % 3].m_data[0] + intTex[el][(locInd.m_data[k] + 1) % 3].m_data[1] || intTex[el][locInd.m_data[k]].m_data[0] + intTex[el][locInd.m_data[k]].m_data[1] <= intTex[el][(locInd.m_data[k] + 2) % 3].m_data[0] + intTex[el][(locInd.m_data[k] + 2) % 3].m_data[1]) ** GOTO lbl-1000
                            newIntTex[k][0] = -1;
                            break block30;
                        }
                        if (intTex[el][locInd.m_data[k]].m_data[(coordIndex + 1) % 2] < intTex[el][(locInd.m_data[k] + 1) % 3].m_data[(coordIndex + 1) % 2] && intTex[el][locInd.m_data[k]].m_data[(coordIndex + 1) % 2] < intTex[el][(locInd.m_data[k] + 2) % 3].m_data[(coordIndex + 1) % 2]) {
                            newIntTex[k][0] = -1;
                        } else if (intTex[el][locInd.m_data[k]].m_data[(coordIndex + 1) % 2] > intTex[el][(locInd.m_data[k] + 1) % 3].m_data[(coordIndex + 1) % 2] && intTex[el][locInd.m_data[k]].m_data[(coordIndex + 1) % 2] > intTex[el][(locInd.m_data[k] + 2) % 3].m_data[(coordIndex + 1) % 2]) {
                            newIntTex[k][0] = -1;
                        } else lbl-1000:
                        // 2 sources

                        {
                            assignmentVector.addElement(new int[]{el, numNew});
                            ++numAssignments;
                            newIntTex[k][0] = el;
                            if (coordIndex == -1) {
                                newIntTex[k][1] = intTex[el][locInd.m_data[k]].m_data[0];
                                v0 = newIntTex[k];
                                v0[1] = v0[1] - intTex[el][locInd.m_data[k]].m_data[0] % quantization;
                                newIntTex[k][2] = intTex[el][locInd.m_data[k]].m_data[1];
                                v1 = newIntTex[k];
                                v1[2] = v1[2] - intTex[el][locInd.m_data[k]].m_data[1] % quantization;
                                rotatedEdge = new int[]{intTex[el][(locInd.m_data[k] + 1) % 3].m_data[1] - intTex[el][(locInd.m_data[k] + 2) % 3].m_data[1], intTex[el][(locInd.m_data[k] + 2) % 3].m_data[0] - intTex[el][(locInd.m_data[k] + 1) % 3].m_data[0]};
                                if (rotatedEdge[0] * (intTex[el][locInd.m_data[k]].m_data[0] - intTex[el][(locInd.m_data[k] + 1) % 3].m_data[0]) + rotatedEdge[1] * (intTex[el][locInd.m_data[k]].m_data[1] - intTex[el][(locInd.m_data[k] + 1) % 3].m_data[1]) < 0) {
                                    rotatedEdge[0] = rotatedEdge[0] * -1;
                                    rotatedEdge[1] = rotatedEdge[1] * -1;
                                }
                                if (rotatedEdge[0] * (intTex[el][locInd.m_data[k]].m_data[0] - intTex[el][(locInd.m_data[k] + 1) % 3].m_data[0]) + rotatedEdge[1] * (intTex[el][locInd.m_data[k]].m_data[1] - intTex[el][(locInd.m_data[k] + 1) % 3].m_data[1]) < rotatedEdge[0] * (newIntTex[k][1] - intTex[el][(locInd.m_data[k] + 1) % 3].m_data[0]) + rotatedEdge[1] * (newIntTex[k][2] + quantization - intTex[el][(locInd.m_data[k] + 1) % 3].m_data[1])) {
                                    v2 = newIntTex[k];
                                    v2[1] = v2[1] + quantization / 4;
                                    v3 = newIntTex[k];
                                    v3[2] = v3[2] + quantization * 3 / 4;
                                } else {
                                    v4 = newIntTex[k];
                                    v4[1] = v4[1] + quantization * 3 / 4;
                                    v5 = newIntTex[k];
                                    v5[2] = v5[2] + quantization / 4;
                                }
                            } else {
                                newIntTex[k][1 + (coordIndex + 1) % 2] = intTex[el][locInd.m_data[k]].m_data[(coordIndex + 1) % 2];
                                newIntTex[k][1 + coordIndex] = intTex[el][locInd.m_data[k]].m_data[coordIndex];
                                v6 = newIntTex[k];
                                v7 = 1 + coordIndex;
                                v6[v7] = v6[v7] - intTex[el][locInd.m_data[k]].m_data[coordIndex] % quantization;
                                rotatedEdge = new int[]{intTex[el][(locInd.m_data[k] + 1) % 3].m_data[1] - intTex[el][(locInd.m_data[k] + 2) % 3].m_data[1], intTex[el][(locInd.m_data[k] + 2) % 3].m_data[0] - intTex[el][(locInd.m_data[k] + 1) % 3].m_data[0]};
                                if (rotatedEdge[0] * (intTex[el][locInd.m_data[k]].m_data[0] - intTex[el][(locInd.m_data[k] + 1) % 3].m_data[0]) + rotatedEdge[1] * (intTex[el][locInd.m_data[k]].m_data[1] - intTex[el][(locInd.m_data[k] + 1) % 3].m_data[1]) < 0) {
                                    rotatedEdge[0] = rotatedEdge[0] * -1;
                                    rotatedEdge[1] = rotatedEdge[1] * -1;
                                }
                                if (rotatedEdge[0] * (intTex[el][locInd.m_data[k]].m_data[0] - intTex[el][(locInd.m_data[k] + 1) % 3].m_data[0]) + rotatedEdge[1] * (intTex[el][locInd.m_data[k]].m_data[1] - intTex[el][(locInd.m_data[k] + 1) % 3].m_data[1]) < rotatedEdge[0] * (newIntTex[k][1] - intTex[el][(locInd.m_data[k] + 1) % 3].m_data[0]) + rotatedEdge[1] * (newIntTex[k][2] - intTex[el][(locInd.m_data[k] + 1) % 3].m_data[1])) {
                                    v8 = newIntTex[k];
                                    v9 = 1 + coordIndex;
                                    v8[v9] = v8[v9] + quantization / 4;
                                } else {
                                    v10 = newIntTex[k];
                                    v11 = 1 + coordIndex;
                                    v10[v11] = v10[v11] + quantization * 3 / 4;
                                }
                            }
                        }
                    }
                    ++k;
                }
                if (numAssignments > 0) {
                    orientation = 1;
                    if (numVSEl > 1 && geom.getNeighbour((int)elInd.m_data[0]).m_data[(locInd.m_data[0] + 2) % 3] != elInd.m_data[1]) {
                        orientation = -1;
                    }
                    newIntTex2 = new int[numAssignments][9];
                    numAssignments = 0;
                    if (orientation == -1) {
                        k = 0;
                        while (k < numVSEl) {
                            if (newIntTex[k][0] != -1) {
                                newIntTex2[numAssignments][0] = newIntTex[k][0];
                                newIntTex2[numAssignments][1] = newIntTex[k][1];
                                newIntTex2[numAssignments][2] = newIntTex[k][2];
                                ++numAssignments;
                            }
                            ++k;
                        }
                    } else {
                        k = numVSEl - 1;
                        while (k >= 0) {
                            if (newIntTex[k][0] != -1) {
                                newIntTex2[numAssignments][0] = newIntTex[k][0];
                                newIntTex2[numAssignments][1] = newIntTex[k][1];
                                newIntTex2[numAssignments][2] = newIntTex[k][2];
                                ++numAssignments;
                            }
                            --k;
                        }
                    }
                    k = 0;
                    while (k < numAssignments) {
                        m = 0;
                        while (m < 6) {
                            newIntTex2[k][3 + m] = -1;
                            ++m;
                        }
                        ++k;
                    }
                    newVertexTexVector.addElement(newIntTex2);
                    ++numNew;
                    newVertex = PdVector.copyNew((PdVector)geom.getVertex(v));
                    triangGeom.addVertex(newVertex);
                    if (!vs.isClosed()) {
                        triangGeom.setTagVertex(triangGeom.getNumVertices() - 1, 14);
                    } else {
                        triangGeom.clearTagVertex(triangGeom.getNumVertices() - 1, 14);
                    }
                }
            }
            ++v;
        }
        return numNew;
    }

    private static int addEdgeIntersections(PgElementSet geom, PiVector[][] intTex, int quantization, Vector assignmentVector, Vector newVertexTexVector, PgElementSet triangGeom, int numNew) {
        PgEdgeStar[] edgeStar = geom.makeEdgeStars();
        int numEdges = geom.getNumEdges();
        int i = 0;
        while (i < numEdges) {
            PdVector newVertex;
            int edgeLocInd;
            double b;
            long n;
            long m;
            int end;
            int start;
            int[] elIndex = edgeStar[i].getElementInd();
            int numAdjacentElements = edgeStar[i].getValence();
            int localIndex = edgeStar[i].getNeighbourLocInd()[0];
            if (intTex[elIndex[0]][(localIndex + 1) % 3].m_data[0] < intTex[elIndex[0]][(localIndex + 2) % 3].m_data[0]) {
                start = intTex[elIndex[0]][(localIndex + 1) % 3].m_data[0] / quantization;
                end = intTex[elIndex[0]][(localIndex + 2) % 3].m_data[0] / quantization;
                if (intTex[elIndex[0]][(localIndex + 2) % 3].m_data[0] % quantization == 0) {
                    --end;
                }
            } else {
                start = intTex[elIndex[0]][(localIndex + 2) % 3].m_data[0] / quantization;
                end = intTex[elIndex[0]][(localIndex + 1) % 3].m_data[0] / quantization;
                if (intTex[elIndex[0]][(localIndex + 1) % 3].m_data[0] % quantization == 0) {
                    --end;
                }
            }
            PiVector element = geom.getElement(elIndex[0]);
            int j = start + 1;
            while (j <= end) {
                m = j * quantization - intTex[elIndex[0]][(localIndex + 1) % 3].m_data[0];
                n = intTex[elIndex[0]][(localIndex + 2) % 3].m_data[0] - intTex[elIndex[0]][(localIndex + 1) % 3].m_data[0];
                b = (double)m / (double)n;
                edgeLocInd = edgeStar[i].getNeighbourLocInd()[0];
                newVertex = PdVector.blendNew((double)(1.0 - b), (PdVector)geom.getVertex(element.m_data[(edgeLocInd + 1) % 3]), (double)b, (PdVector)geom.getVertex(element.m_data[(edgeLocInd + 2) % 3]));
                triangGeom.addVertex(newVertex);
                if (numAdjacentElements == 1) {
                    triangGeom.setTagVertex(triangGeom.getNumVertices() - 1, 14);
                } else {
                    triangGeom.clearTagVertex(triangGeom.getNumVertices() - 1, 14);
                }
                numNew = PwTex2Triang.addEdgeVertex(intTex, elIndex, numAdjacentElements, localIndex, numNew, n, m, quantization, assignmentVector, newVertexTexVector, edgeStar[i], 0);
                ++j;
            }
            if (intTex[elIndex[0]][(localIndex + 1) % 3].m_data[1] < intTex[elIndex[0]][(localIndex + 2) % 3].m_data[1]) {
                start = intTex[elIndex[0]][(localIndex + 1) % 3].m_data[1] / quantization;
                end = intTex[elIndex[0]][(localIndex + 2) % 3].m_data[1] / quantization;
                if (intTex[elIndex[0]][(localIndex + 2) % 3].m_data[1] % quantization == 0) {
                    --end;
                }
            } else {
                start = intTex[elIndex[0]][(localIndex + 2) % 3].m_data[1] / quantization;
                end = intTex[elIndex[0]][(localIndex + 1) % 3].m_data[1] / quantization;
                if (intTex[elIndex[0]][(localIndex + 1) % 3].m_data[1] % quantization == 0) {
                    --end;
                }
            }
            element = geom.getElement(elIndex[0]);
            j = start + 1;
            while (j <= end) {
                m = j * quantization - intTex[elIndex[0]][(localIndex + 1) % 3].m_data[1];
                n = intTex[elIndex[0]][(localIndex + 2) % 3].m_data[1] - intTex[elIndex[0]][(localIndex + 1) % 3].m_data[1];
                if ((m * (long)intTex[elIndex[0]][(localIndex + 2) % 3].m_data[0] + (n - m) * (long)intTex[elIndex[0]][(localIndex + 1) % 3].m_data[0]) % (n * (long)quantization) != 0L || intTex[elIndex[0]][(localIndex + 1) % 3].m_data[0] == intTex[elIndex[0]][(localIndex + 2) % 3].m_data[0]) {
                    b = 1.0 * (double)m / (1.0 * (double)n);
                    edgeLocInd = edgeStar[i].getNeighbourLocInd()[0];
                    newVertex = PdVector.blendNew((double)(1.0 - b), (PdVector)geom.getVertex(element.m_data[(edgeLocInd + 1) % 3]), (double)b, (PdVector)geom.getVertex(element.m_data[(edgeLocInd + 2) % 3]));
                    triangGeom.addVertex(newVertex);
                    if (numAdjacentElements == 1) {
                        triangGeom.setTagVertex(triangGeom.getNumVertices() - 1, 14);
                    } else {
                        triangGeom.clearTagVertex(triangGeom.getNumVertices() - 1, 14);
                    }
                    numNew = PwTex2Triang.addEdgeVertex(intTex, elIndex, numAdjacentElements, localIndex, numNew, n, m, quantization, assignmentVector, newVertexTexVector, edgeStar[i], 1);
                }
                ++j;
            }
            if (intTex[elIndex[0]][(localIndex + 1) % 3].m_data[0] + intTex[elIndex[0]][(localIndex + 1) % 3].m_data[1] < intTex[elIndex[0]][(localIndex + 2) % 3].m_data[0] + intTex[elIndex[0]][(localIndex + 2) % 3].m_data[1]) {
                start = (intTex[elIndex[0]][(localIndex + 1) % 3].m_data[0] + intTex[elIndex[0]][(localIndex + 1) % 3].m_data[1]) / quantization;
                end = (intTex[elIndex[0]][(localIndex + 2) % 3].m_data[0] + intTex[elIndex[0]][(localIndex + 2) % 3].m_data[1]) / quantization;
                if ((intTex[elIndex[0]][(localIndex + 2) % 3].m_data[0] + intTex[elIndex[0]][(localIndex + 2) % 3].m_data[1]) % quantization == 0) {
                    --end;
                }
            } else {
                start = (intTex[elIndex[0]][(localIndex + 2) % 3].m_data[0] + intTex[elIndex[0]][(localIndex + 2) % 3].m_data[1]) / quantization;
                end = (intTex[elIndex[0]][(localIndex + 1) % 3].m_data[0] + intTex[elIndex[0]][(localIndex + 1) % 3].m_data[1]) / quantization;
                if ((intTex[elIndex[0]][(localIndex + 1) % 3].m_data[0] + intTex[elIndex[0]][(localIndex + 1) % 3].m_data[1]) % quantization == 0) {
                    --end;
                }
            }
            element = geom.getElement(elIndex[0]);
            j = start + 1;
            while (j <= end) {
                m = j * quantization - (intTex[elIndex[0]][(localIndex + 1) % 3].m_data[0] + intTex[elIndex[0]][(localIndex + 1) % 3].m_data[1]);
                n = intTex[elIndex[0]][(localIndex + 2) % 3].m_data[0] + intTex[elIndex[0]][(localIndex + 2) % 3].m_data[1] - (intTex[elIndex[0]][(localIndex + 1) % 3].m_data[0] + intTex[elIndex[0]][(localIndex + 1) % 3].m_data[1]);
                if ((m * (long)intTex[elIndex[0]][(localIndex + 2) % 3].m_data[0] + (n - m) * (long)intTex[elIndex[0]][(localIndex + 1) % 3].m_data[0]) % (n * (long)quantization) != 0L) {
                    b = 1.0 * (double)m / (1.0 * (double)n);
                    edgeLocInd = edgeStar[i].getNeighbourLocInd()[0];
                    newVertex = PdVector.blendNew((double)(1.0 - b), (PdVector)geom.getVertex(element.m_data[(edgeLocInd + 1) % 3]), (double)b, (PdVector)geom.getVertex(element.m_data[(edgeLocInd + 2) % 3]));
                    triangGeom.addVertex(newVertex);
                    if (numAdjacentElements == 1) {
                        triangGeom.setTagVertex(triangGeom.getNumVertices() - 1, 14);
                    } else {
                        triangGeom.clearTagVertex(triangGeom.getNumVertices() - 1, 14);
                    }
                    numNew = PwTex2Triang.addEdgeVertex(intTex, elIndex, numAdjacentElements, localIndex, numNew, n, m, quantization, assignmentVector, newVertexTexVector, edgeStar[i], -1);
                }
                ++j;
            }
            ++i;
        }
        return numNew;
    }

    private static int addEdgeVertex(PiVector[][] intTex, int[] elIndex, int numAdjacentElements, int localIndex, int numNew, long n, long m, int quantization, Vector assignmentVector, Vector newVertexTexVector, PgEdgeStar edgeStar, int ci) {
        PiVector[] edgeVector = PiVector.realloc(null, (int)2, (int)2);
        edgeVector[0].sub(intTex[elIndex[0]][(localIndex + 2) % 3], intTex[elIndex[0]][(localIndex + 1) % 3]);
        int[][] newIntTex = new int[numAdjacentElements][9];
        int k = 0;
        while (k < numAdjacentElements) {
            PiVector notEdge;
            PiVector rotatedEdge;
            int p = 0;
            while (p < 6) {
                newIntTex[k][3 + p] = -1;
                ++p;
            }
            int coordIndex = ci;
            int localIndex1 = edgeStar.getNeighbourLocInd()[k];
            if (k == 0) {
                edgeVector[1].sub(intTex[elIndex[0]][(localIndex + 2) % 3], intTex[elIndex[0]][(localIndex + 1) % 3]);
            } else {
                edgeVector[1].sub(intTex[elIndex[k]][(localIndex1 + 1) % 3], intTex[elIndex[k]][(localIndex1 + 2) % 3]);
                long distL = Math.min((long)(edgeVector[0].m_data[0] - edgeVector[1].m_data[0]) * (long)(edgeVector[0].m_data[0] - edgeVector[1].m_data[0]) + (long)(edgeVector[0].m_data[1] - edgeVector[1].m_data[1]) * (long)(edgeVector[0].m_data[1] - edgeVector[1].m_data[1]), (long)(edgeVector[0].m_data[0] + edgeVector[1].m_data[0]) * (long)(edgeVector[0].m_data[0] + edgeVector[1].m_data[0]) + (long)(edgeVector[0].m_data[1] + edgeVector[1].m_data[1]) * (long)(edgeVector[0].m_data[1] + edgeVector[1].m_data[1]));
                long dist1L = Math.min((long)(-edgeVector[0].m_data[1] - edgeVector[1].m_data[0]) * (long)(-edgeVector[0].m_data[1] - edgeVector[1].m_data[0]) + (long)(edgeVector[0].m_data[0] + edgeVector[0].m_data[1] - edgeVector[1].m_data[1]) * (long)(edgeVector[0].m_data[0] + edgeVector[0].m_data[1] - edgeVector[1].m_data[1]), (long)(-edgeVector[0].m_data[1] + edgeVector[1].m_data[0]) * (long)(-edgeVector[0].m_data[1] + edgeVector[1].m_data[0]) + (long)(edgeVector[0].m_data[0] + edgeVector[0].m_data[1] + edgeVector[1].m_data[1]) * (long)(edgeVector[0].m_data[0] + edgeVector[0].m_data[1] + edgeVector[1].m_data[1]));
                long dist2L = Math.min((long)(-edgeVector[0].m_data[0] - edgeVector[0].m_data[1] - edgeVector[1].m_data[0]) * (long)(-edgeVector[0].m_data[0] - edgeVector[0].m_data[1] - edgeVector[1].m_data[0]) + (long)(edgeVector[0].m_data[0] - edgeVector[1].m_data[1]) * (long)(edgeVector[0].m_data[0] - edgeVector[1].m_data[1]), (long)(-edgeVector[0].m_data[0] - edgeVector[0].m_data[1] + edgeVector[1].m_data[0]) * (long)(-edgeVector[0].m_data[0] - edgeVector[0].m_data[1] + edgeVector[1].m_data[0]) + (long)(edgeVector[0].m_data[0] + edgeVector[1].m_data[1]) * (long)(edgeVector[0].m_data[0] + edgeVector[1].m_data[1]));
                if (dist1L < distL && dist1L < dist2L && --coordIndex == -2) {
                    coordIndex = 1;
                }
                if (dist2L < distL && dist2L < dist1L && ++coordIndex == 2) {
                    coordIndex = -1;
                }
            }
            int[] lc = new int[2];
            if (k == 0) {
                lc[0] = (localIndex + 1) % 3;
                lc[1] = (localIndex + 2) % 3;
            } else {
                lc[0] = (localIndex1 + 2) % 3;
                lc[1] = (localIndex1 + 1) % 3;
            }
            newIntTex[k][0] = elIndex[k];
            if (coordIndex == -1) {
                if ((m * (long)intTex[elIndex[k]][lc[1]].m_data[0] + (n - m) * (long)intTex[elIndex[k]][lc[0]].m_data[0]) % (n * (long)quantization) == 0L) {
                    newIntTex[k][1] = (int)((m * (long)intTex[elIndex[k]][lc[1]].m_data[0] + (n - m) * (long)intTex[elIndex[k]][lc[0]].m_data[0]) / (n * (long)quantization));
                    int[] nArray = newIntTex[k];
                    nArray[1] = nArray[1] * quantization;
                    newIntTex[k][2] = (int)((m * (long)intTex[elIndex[k]][lc[1]].m_data[1] + (n - m) * (long)intTex[elIndex[k]][lc[0]].m_data[1]) / (n * (long)quantization));
                    int[] nArray2 = newIntTex[k];
                    nArray2[2] = nArray2[2] * quantization;
                } else {
                    newIntTex[k][1] = (int)((m * (long)intTex[elIndex[k]][lc[1]].m_data[0] + (n - m) * (long)intTex[elIndex[k]][lc[0]].m_data[0]) / (n * (long)quantization));
                    int[] nArray = newIntTex[k];
                    nArray[1] = nArray[1] * quantization;
                    newIntTex[k][2] = (int)((m * (long)intTex[elIndex[k]][lc[1]].m_data[1] + (n - m) * (long)intTex[elIndex[k]][lc[0]].m_data[1]) / (n * (long)quantization));
                    int[] nArray3 = newIntTex[k];
                    nArray3[2] = nArray3[2] + 1;
                    int[] nArray4 = newIntTex[k];
                    nArray4[2] = nArray4[2] * quantization;
                    rotatedEdge = new PiVector(edgeVector[1].m_data[1], -edgeVector[1].m_data[0]);
                    PiVector triangleEdge = PiVector.subNew((PiVector)intTex[elIndex[k]][localIndex1], (PiVector)intTex[elIndex[k]][lc[0]]);
                    notEdge = new PiVector(newIntTex[k][1] - intTex[elIndex[k]][lc[0]].m_data[0], newIntTex[k][2] - intTex[elIndex[k]][lc[0]].m_data[1]);
                    if (PiVector.dot((PiVector)rotatedEdge, (PiVector)triangleEdge) == 0) {
                        int idx = 0;
                        while (idx < 2) {
                            rotatedEdge.m_data[(idx + 1) % 2] = intTex[elIndex[k]][(localIndex1 + 2) % 3].m_data[idx] - intTex[elIndex[k]][(localIndex1 + 1) % 3].m_data[idx];
                            ++idx;
                        }
                        rotatedEdge.m_data[1] = rotatedEdge.m_data[1] * -1;
                        triangleEdge.copy(rotatedEdge);
                    }
                    if (PiVector.dot((PiVector)rotatedEdge, (PiVector)triangleEdge) == 0) {
                        int idx = 0;
                        while (idx < 2) {
                            rotatedEdge.m_data[(idx + 1) % 2] = intTex[elIndex[k]][(localIndex1 + 2) % 3].m_data[idx] - intTex[elIndex[k]][(localIndex1 + 1) % 3].m_data[idx];
                            ++idx;
                        }
                        rotatedEdge.m_data[1] = rotatedEdge.m_data[1] * -1;
                        triangleEdge.copy(rotatedEdge);
                    }
                    if (PiVector.dot((PiVector)rotatedEdge, (PiVector)triangleEdge) > 0 && PiVector.dot((PiVector)rotatedEdge, (PiVector)notEdge) < 0 || PiVector.dot((PiVector)rotatedEdge, (PiVector)triangleEdge) < 0 && PiVector.dot((PiVector)rotatedEdge, (PiVector)notEdge) > 0) {
                        int[] nArray5 = newIntTex[k];
                        nArray5[1] = nArray5[1] + quantization / 4;
                        int[] nArray6 = newIntTex[k];
                        nArray6[2] = nArray6[2] - quantization / 4;
                    } else {
                        int[] nArray7 = newIntTex[k];
                        nArray7[1] = nArray7[1] + quantization * 3 / 4;
                        int[] nArray8 = newIntTex[k];
                        nArray8[2] = nArray8[2] - quantization * 3 / 4;
                    }
                }
            } else {
                newIntTex[k][1 + coordIndex] = (int)((m * (long)intTex[elIndex[k]][lc[1]].m_data[coordIndex] + (n - m) * (long)intTex[elIndex[k]][lc[0]].m_data[coordIndex] + n * (long)quantization / 2L) / (n * (long)quantization));
                int[] nArray = newIntTex[k];
                int n2 = 1 + coordIndex;
                nArray[n2] = nArray[n2] * quantization;
                if ((m * (long)intTex[elIndex[k]][lc[1]].m_data[(coordIndex + 1) % 2] + (n - m) * (long)intTex[elIndex[k]][lc[0]].m_data[(coordIndex + 1) % 2]) % (n * (long)quantization) == 0L) {
                    newIntTex[k][1 + (coordIndex + 1) % 2] = (int)((m * (long)intTex[elIndex[k]][lc[1]].m_data[(coordIndex + 1) % 2] + (n - m) * (long)intTex[elIndex[k]][lc[0]].m_data[(coordIndex + 1) % 2]) / n);
                } else {
                    newIntTex[k][1 + (coordIndex + 1) % 2] = (int)((m * (long)intTex[elIndex[k]][lc[1]].m_data[(coordIndex + 1) % 2] + (n - m) * (long)intTex[elIndex[k]][lc[0]].m_data[(coordIndex + 1) % 2]) / (n * (long)quantization));
                    int[] nArray9 = newIntTex[k];
                    int n3 = 1 + (coordIndex + 1) % 2;
                    nArray9[n3] = nArray9[n3] * quantization;
                    rotatedEdge = new PiVector(edgeVector[1].m_data[1], -edgeVector[1].m_data[0]);
                    PiVector triangleEdge = PiVector.subNew((PiVector)intTex[elIndex[k]][localIndex1], (PiVector)intTex[elIndex[k]][lc[0]]);
                    notEdge = new PiVector(newIntTex[k][1] - intTex[elIndex[k]][lc[0]].m_data[0], newIntTex[k][2] - intTex[elIndex[k]][lc[0]].m_data[1]);
                    if (PiVector.dot((PiVector)rotatedEdge, (PiVector)triangleEdge) == 0) {
                        int idx = 0;
                        while (idx < 2) {
                            rotatedEdge.m_data[(idx + 1) % 2] = intTex[elIndex[k]][(localIndex1 + 2) % 3].m_data[idx] - intTex[elIndex[k]][(localIndex1 + 1) % 3].m_data[idx];
                            ++idx;
                        }
                        rotatedEdge.m_data[1] = rotatedEdge.m_data[1] * -1;
                        triangleEdge.copy(rotatedEdge);
                    }
                    if (PiVector.dot((PiVector)rotatedEdge, (PiVector)triangleEdge) == 0) {
                        int idx = 0;
                        while (idx < 2) {
                            rotatedEdge.m_data[(idx + 1) % 2] = intTex[elIndex[k]][(localIndex1 + 2) % 3].m_data[idx] - intTex[elIndex[k]][(localIndex1 + 1) % 3].m_data[idx];
                            ++idx;
                        }
                        rotatedEdge.m_data[1] = rotatedEdge.m_data[1] * -1;
                        triangleEdge.copy(rotatedEdge);
                    }
                    if (PiVector.dot((PiVector)rotatedEdge, (PiVector)triangleEdge) > 0 && PiVector.dot((PiVector)rotatedEdge, (PiVector)notEdge) < 0 || PiVector.dot((PiVector)rotatedEdge, (PiVector)triangleEdge) < 0 && PiVector.dot((PiVector)rotatedEdge, (PiVector)notEdge) > 0) {
                        int[] nArray10 = newIntTex[k];
                        int n4 = 1 + (coordIndex + 1) % 2;
                        nArray10[n4] = nArray10[n4] + quantization / 4;
                    } else {
                        int[] nArray11 = newIntTex[k];
                        int n5 = 1 + (coordIndex + 1) % 2;
                        nArray11[n5] = nArray11[n5] + quantization * 3 / 4;
                    }
                }
            }
            assignmentVector.addElement(new int[]{elIndex[k], numNew});
            ++k;
        }
        newVertexTexVector.addElement(newIntTex);
        return ++numNew;
    }

    private static int[][] collectVerticesToElements(PgElementSet geom, Vector assignmentVector) {
        int[] a;
        int noe = geom.getNumElements();
        int[][] vertexInElement = new int[noe][];
        int[] numVerticesInElement = new int[noe];
        int i = 0;
        while (i < noe) {
            numVerticesInElement[i] = 0;
            ++i;
        }
        int numNew = assignmentVector.size();
        int i2 = 0;
        while (i2 < numNew) {
            a = (int[])assignmentVector.elementAt(i2);
            int n = a[0];
            numVerticesInElement[n] = numVerticesInElement[n] + 1;
            ++i2;
        }
        i2 = 0;
        while (i2 < noe) {
            vertexInElement[i2] = new int[numVerticesInElement[i2]];
            numVerticesInElement[i2] = 0;
            ++i2;
        }
        i2 = 0;
        while (i2 < numNew) {
            a = (int[])assignmentVector.elementAt(i2);
            vertexInElement[a[0]][numVerticesInElement[a[0]]] = a[1];
            int n = a[0];
            numVerticesInElement[n] = numVerticesInElement[n] + 1;
            ++i2;
        }
        return vertexInElement;
    }

    private static int[][] joinConnectivityInformation(Vector newVertexTexVector, int numNew) {
        int[][] neighbourVertex = new int[numNew][];
        int i = 0;
        while (i < numNew) {
            int[][] tc = (int[][])newVertexTexVector.elementAt(i);
            int numAdjacentElements = tc.length;
            int numNeighbourVertices = 0;
            int[] startLocal = new int[numAdjacentElements];
            int j = 0;
            while (j < numAdjacentElements) {
                startLocal[j] = 0;
                ++j;
            }
            j = 0;
            while (j < numAdjacentElements) {
                int k = 0;
                while (k < 6) {
                    if (tc[j][3 + k] != -1) {
                        ++numNeighbourVertices;
                        if (tc[j][3 + (k + 5) % 6] == -1) {
                            startLocal[j] = k;
                        }
                    }
                    ++k;
                }
                ++j;
            }
            int[] neighbours = new int[numNeighbourVertices];
            numNeighbourVertices = 0;
            int j2 = 0;
            while (j2 < numAdjacentElements) {
                int k = 0;
                while (k < 6) {
                    if (tc[j2][3 + (k + startLocal[j2]) % 6] != -1) {
                        neighbours[numNeighbourVertices] = tc[j2][3 + (k + startLocal[j2]) % 6];
                        ++numNeighbourVertices;
                    }
                    ++k;
                }
                ++j2;
            }
            int cNumNeighbours = 1;
            int j3 = 1;
            while (j3 < numNeighbourVertices) {
                if (neighbours[j3] != neighbours[j3 - 1] && neighbours[j3] != neighbours[0]) {
                    ++cNumNeighbours;
                }
                ++j3;
            }
            if (numNeighbourVertices == 0) {
                PsDebug.warning((String)("No Neighbour Vertices: " + i));
                neighbourVertex[i] = new int[0];
            } else {
                int[] cNeighbours = new int[cNumNeighbours];
                cNumNeighbours = 1;
                cNeighbours[0] = neighbours[0];
                int j4 = 1;
                while (j4 < numNeighbourVertices) {
                    if (neighbours[j4] != neighbours[j4 - 1] && neighbours[j4] != neighbours[0]) {
                        cNeighbours[cNumNeighbours] = neighbours[j4];
                        ++cNumNeighbours;
                    }
                    ++j4;
                }
                neighbourVertex[i] = cNeighbours;
            }
            ++i;
        }
        return neighbourVertex;
    }

    private static int addinteriorVertices(PgElementSet geom, int[][] vertexInElement, int quantization, int numNew, Vector newVertexTexVector, Vector assignmentVector, PiVector[][] intTex, Vector edgeCollapseVector) {
        int noe = geom.getNumElements();
        int[] texOrient = new int[noe];
        int numPositive = 0;
        int numNegative = 0;
        int i = 0;
        while (i < noe) {
            int orientation;
            PdVector v1 = new PdVector((double)(intTex[i][1].m_data[0] - intTex[i][0].m_data[0]), (double)(intTex[i][1].m_data[1] - intTex[i][0].m_data[1]), 0.0);
            PdVector v2 = new PdVector((double)(intTex[i][2].m_data[0] - intTex[i][0].m_data[0]), (double)(intTex[i][2].m_data[1] - intTex[i][0].m_data[1]), 0.0);
            PdVector cross = PdVector.crossNew((PdVector)v1, (PdVector)v2);
            if (cross.m_data[2] > 0.0) {
                orientation = 1;
                ++numPositive;
            } else if (cross.m_data[2] < 0.0) {
                orientation = -1;
                ++numNegative;
            } else {
                orientation = 0;
            }
            texOrient[i] = orientation;
            ++i;
        }
        i = 0;
        while (i < noe) {
            if (texOrient[i] == 0) {
                texOrient[i] = numNegative > numPositive ? -1 : 1;
            }
            ++i;
        }
        i = 0;
        while (i < noe) {
            if (vertexInElement[i] != null && vertexInElement[i].length != 0) {
                int m;
                int numAdjacentElements;
                int[][] tc;
                int current;
                int last;
                int k;
                int numVerticesOnBnd = vertexInElement[i].length;
                int[] min = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE};
                int[] max = new int[2];
                int[][] vertexTexCoord = new int[numVerticesOnBnd][2];
                int j = 0;
                while (j < numVerticesOnBnd) {
                    int[][] tc2 = (int[][])newVertexTexVector.elementAt(vertexInElement[i][j]);
                    int numAdjacentElements2 = tc2.length;
                    int k2 = 0;
                    while (k2 < numAdjacentElements2) {
                        if (tc2[k2][0] == i) {
                            int m2 = 0;
                            while (m2 < 2) {
                                vertexTexCoord[j][m2] = tc2[k2][m2 + 1];
                                if (vertexTexCoord[j][m2] > max[m2]) {
                                    max[m2] = vertexTexCoord[j][m2];
                                }
                                if (vertexTexCoord[j][m2] < min[m2]) {
                                    min[m2] = vertexTexCoord[j][m2];
                                }
                                ++m2;
                            }
                        }
                        ++k2;
                    }
                    ++j;
                }
                j = 0;
                while (j < 2) {
                    int n = j;
                    min[n] = min[n] / quantization;
                    int n2 = j;
                    max[n2] = max[n2] / (quantization / 4);
                    if (max[j] % 4 != 0) {
                        int n3 = j;
                        max[n3] = max[n3] + 4;
                    }
                    int n4 = j;
                    max[n4] = max[n4] / 4;
                    max[j] = (max[j] - min[j]) * 4 + 1;
                    ++j;
                }
                int[][] localSubGrid = new int[max[0]][max[1]];
                int j2 = 0;
                while (j2 < max[0]) {
                    int k3 = 0;
                    while (k3 < max[1]) {
                        localSubGrid[j2][k3] = -1;
                        ++k3;
                    }
                    ++j2;
                }
                j2 = 0;
                while (j2 < numVerticesOnBnd) {
                    localSubGrid[(vertexTexCoord[j2][0] - quantization * min[0]) * 4 / quantization][(vertexTexCoord[j2][1] - quantization * min[1]) * 4 / quantization] = vertexInElement[i][j2];
                    ++j2;
                }
                j2 = 0;
                while (j2 < max[0]) {
                    int mn = -1;
                    int mx = -1;
                    k = 0;
                    while (k < max[1]) {
                        if (localSubGrid[j2][k] != -1) {
                            mx = k;
                            if (mn == -1) {
                                mn = k;
                            }
                        }
                        ++k;
                    }
                    k = mn / 4 + 1;
                    while (k < (mx + 3) / 4) {
                        if (localSubGrid[j2][4 * k] == -1) {
                            newVertexTexVector.addElement(new int[][]{{i, quantization * (min[0] + j2 / 4), quantization * (min[1] + k), -1, -1, -1, -1, -1, -1}});
                            assignmentVector.addElement(new int[]{i, numNew});
                            localSubGrid[j2][4 * k] = numNew++;
                        }
                        ++k;
                    }
                    j2 += 4;
                }
                j2 = 0;
                while (j2 < max[0]) {
                    last = -1;
                    current = -1;
                    k = 0;
                    while (k < max[1]) {
                        if (localSubGrid[j2][k] != -1) {
                            current = localSubGrid[j2][k];
                            if (last != -1) {
                                tc = (int[][])newVertexTexVector.elementAt(current);
                                numAdjacentElements = tc.length;
                                m = 0;
                                while (m < numAdjacentElements) {
                                    if (tc[m][0] == i) {
                                        tc[m][6] = last;
                                    }
                                    ++m;
                                }
                                tc = (int[][])newVertexTexVector.elementAt(last);
                                numAdjacentElements = tc.length;
                                m = 0;
                                while (m < numAdjacentElements) {
                                    if (tc[m][0] == i) {
                                        tc[m][3] = current;
                                    }
                                    ++m;
                                }
                            }
                            last = current;
                        }
                        ++k;
                    }
                    j2 += 4;
                }
                j2 = 0;
                while (j2 < max[1]) {
                    last = -1;
                    current = -1;
                    k = 0;
                    while (k < max[0]) {
                        if (localSubGrid[k][j2] != -1) {
                            current = localSubGrid[k][j2];
                            if (last != -1) {
                                tc = (int[][])newVertexTexVector.elementAt(current);
                                numAdjacentElements = tc.length;
                                m = 0;
                                while (m < numAdjacentElements) {
                                    if (tc[m][0] == i) {
                                        if (texOrient[i] == -1) {
                                            tc[m][7] = last;
                                        } else {
                                            tc[m][5] = last;
                                        }
                                    }
                                    ++m;
                                }
                                tc = (int[][])newVertexTexVector.elementAt(last);
                                numAdjacentElements = tc.length;
                                m = 0;
                                while (m < numAdjacentElements) {
                                    if (tc[m][0] == i) {
                                        if (texOrient[i] == -1) {
                                            tc[m][4] = current;
                                        } else {
                                            tc[m][8] = current;
                                        }
                                    }
                                    ++m;
                                }
                            }
                            last = current;
                        }
                        ++k;
                    }
                    j2 += 4;
                }
                j2 = 4;
                while (j2 < max[0] + max[1]) {
                    last = -1;
                    current = -1;
                    k = 0;
                    while (k < max[0]) {
                        if (j2 - k >= 0 && j2 - k < max[1] && localSubGrid[k][j2 - k] != -1) {
                            current = localSubGrid[k][j2 - k];
                            if (last != -1) {
                                tc = (int[][])newVertexTexVector.elementAt(current);
                                numAdjacentElements = tc.length;
                                m = 0;
                                while (m < numAdjacentElements) {
                                    if (tc[m][0] == i) {
                                        if (texOrient[i] == -1) {
                                            tc[m][8] = last;
                                        } else {
                                            tc[m][4] = last;
                                        }
                                    }
                                    ++m;
                                }
                                tc = (int[][])newVertexTexVector.elementAt(last);
                                numAdjacentElements = tc.length;
                                m = 0;
                                while (m < numAdjacentElements) {
                                    if (tc[m][0] == i) {
                                        if (texOrient[i] == -1) {
                                            tc[m][5] = current;
                                        } else {
                                            tc[m][7] = current;
                                        }
                                    }
                                    ++m;
                                }
                            }
                            last = current;
                        }
                        ++k;
                    }
                    j2 += 4;
                }
                j2 = 0;
                while (j2 < numVerticesOnBnd) {
                    if (localSubGrid[(vertexTexCoord[j2][0] - quantization * min[0]) * 4 / quantization][(vertexTexCoord[j2][1] - quantization * min[1]) * 4 / quantization] != vertexInElement[i][j2]) {
                        int tInd0 = localSubGrid[(vertexTexCoord[j2][0] - quantization * min[0]) * 4 / quantization][(vertexTexCoord[j2][1] - quantization * min[1]) * 4 / quantization];
                        int tInd1 = vertexInElement[i][j2];
                        int[][] tc0 = (int[][])newVertexTexVector.elementAt(tInd0);
                        int[][] tc1 = (int[][])newVertexTexVector.elementAt(tInd1);
                        edgeCollapseVector.addElement(new PiVector(tInd0, tInd1));
                        int numAdjacentElements0 = tc0.length;
                        int numAdjacentElements1 = tc1.length;
                        int k4 = 0;
                        block26: while (k4 < numAdjacentElements0) {
                            if (tc0[k4][0] == i) {
                                int m3 = 0;
                                while (m3 < numAdjacentElements1) {
                                    if (tc1[m3][0] == i) {
                                        int n = 0;
                                        while (n < 6) {
                                            int q;
                                            int p;
                                            int numAdjacentElements2;
                                            int[][] tc2;
                                            int tInd2 = tc0[k4][3 + n];
                                            if (tInd2 != -1) {
                                                tc2 = (int[][])newVertexTexVector.elementAt(tInd2);
                                                numAdjacentElements2 = tc2.length;
                                                p = 0;
                                                block29: while (p < numAdjacentElements2) {
                                                    if (tc2[p][0] == i) {
                                                        q = 0;
                                                        while (q < 6) {
                                                            if (tc2[p][3 + q] == tInd0) {
                                                                tc2[p][3 + q] = -1;
                                                                break block29;
                                                            }
                                                            ++q;
                                                        }
                                                        break;
                                                    }
                                                    ++p;
                                                }
                                            }
                                            if ((tInd2 = tc1[m3][3 + n]) != -1) {
                                                tc2 = (int[][])newVertexTexVector.elementAt(tInd2);
                                                numAdjacentElements2 = tc2.length;
                                                p = 0;
                                                block31: while (p < numAdjacentElements2) {
                                                    if (tc2[p][0] == i) {
                                                        q = 0;
                                                        while (q < 6) {
                                                            if (tc2[p][3 + q] == tInd1) {
                                                                tc2[p][3 + q] = -1;
                                                                break block31;
                                                            }
                                                            ++q;
                                                        }
                                                        break;
                                                    }
                                                    ++p;
                                                }
                                            }
                                            tc0[k4][3 + n] = -1;
                                            tc1[m3][3 + n] = -1;
                                            ++n;
                                        }
                                        tc0[k4][7] = tInd1;
                                        tc1[m3][4] = tInd0;
                                        break block26;
                                    }
                                    ++m3;
                                }
                                break;
                            }
                            ++k4;
                        }
                    }
                    ++j2;
                }
            }
            ++i;
        }
        return numNew;
    }

    private static void getElements(PgElementSet triangGeom, int[][] neighbourVertex, int numNew) {
        int start;
        if (m_bPointCloud) {
            int i = 0;
            while (i < numNew) {
                if (neighbourVertex[i].length < 3) {
                    triangGeom.setTagVertex(i, 2);
                }
                ++i;
            }
            return;
        }
        Vector<PiVector> elements = new Vector<PiVector>();
        boolean[][] bFilled = new boolean[numNew][];
        int i = 0;
        while (i < numNew) {
            bFilled[i] = new boolean[neighbourVertex[i].length];
            int j = 0;
            while (j < neighbourVertex[i].length) {
                bFilled[i][j] = false;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < numNew) {
            if (triangGeom.hasTagVertex(i, 14)) {
                int size = 1;
                int[] nv = neighbourVertex[i];
                if (nv.length != 0) {
                    start = i;
                    int end = nv[nv.length - 1];
                    boolean bContinue = true;
                    while (bContinue) {
                        int locInd = -1;
                        nv = neighbourVertex[end];
                        int j = 0;
                        while (j < nv.length) {
                            if (nv[j] == start) {
                                locInd = j;
                                break;
                            }
                            ++j;
                        }
                        if (bFilled[end][locInd]) {
                            PsDebug.message((String)"There is an error in the connectivity.");
                            size = -1;
                            break;
                        }
                        bFilled[end][locInd] = true;
                        if (locInd == 0 && triangGeom.hasTagVertex(end, 14)) {
                            bContinue = false;
                        } else {
                            start = end;
                            end = nv[(locInd + nv.length - 1) % nv.length];
                        }
                        ++size;
                    }
                    if (size > 2) {
                        PiVector newElement = new PiVector(size);
                        newElement.setEntry(0, i);
                        size = 1;
                        nv = neighbourVertex[i];
                        start = i;
                        end = nv[nv.length - 1];
                        bContinue = true;
                        while (bContinue) {
                            newElement.setEntry(size, end);
                            int locInd = -1;
                            nv = neighbourVertex[end];
                            int j = 0;
                            while (j < nv.length) {
                                if (nv[j] == start) {
                                    locInd = j;
                                    break;
                                }
                                ++j;
                            }
                            if (locInd == 0 && triangGeom.hasTagVertex(end, 14)) {
                                bContinue = false;
                            } else {
                                start = end;
                                end = nv[(locInd + nv.length - 1) % nv.length];
                            }
                            ++size;
                        }
                        elements.addElement(newElement);
                    }
                }
            }
            ++i;
        }
        i = 0;
        while (i < numNew) {
            int[] nv = neighbourVertex[i];
            int j = 0;
            while (j < nv.length) {
                if (!bFilled[i][j]) {
                    start = i;
                    int[] nv2 = nv;
                    int size = 1;
                    int locInd = j;
                    int end = nv2[(locInd + nv2.length - 1) % nv2.length];
                    while (end != i) {
                        nv2 = neighbourVertex[end];
                        int k = 0;
                        while (k < nv2.length) {
                            if (nv2[k] == start) {
                                locInd = k;
                                break;
                            }
                            ++k;
                        }
                        if (bFilled[end][locInd]) {
                            PsDebug.message((String)"There is an error in the connectivity.");
                            size = -1;
                            break;
                        }
                        bFilled[end][locInd] = true;
                        start = end;
                        end = nv2[(locInd + nv2.length - 1) % nv2.length];
                        ++size;
                    }
                    if (size > 2) {
                        start = i;
                        nv2 = nv;
                        PiVector newElement = new PiVector(size);
                        newElement.m_data[0] = start;
                        size = 1;
                        locInd = j;
                        end = nv2[(locInd + nv2.length - 1) % nv2.length];
                        while (end != i) {
                            newElement.m_data[size] = end;
                            nv2 = neighbourVertex[end];
                            int k = 0;
                            while (k < nv2.length) {
                                if (nv2[k] == start) {
                                    locInd = k;
                                    break;
                                }
                                ++k;
                            }
                            start = end;
                            end = nv2[(locInd + nv2.length - 1) % nv2.length];
                            ++size;
                        }
                        elements.addElement(newElement);
                    }
                }
                ++j;
            }
            ++i;
        }
        PiVector[] elemArray = new PiVector[elements.size()];
        int i2 = 0;
        while (i2 < elemArray.length) {
            elemArray[i2] = (PiVector)elements.elementAt(i2);
            ++i2;
        }
        triangGeom.setNumElements(elemArray.length);
        triangGeom.setElements(elemArray);
        i2 = 0;
        while (i2 < numNew) {
            if (triangGeom.hasTagVertex(i2, 14)) {
                triangGeom.setTagVertex(i2, 1);
            }
            ++i2;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void removeEdgeVertices(PgElementSet triangGeom, int numNew, Vector edgeCollapseVector) {
        bChanged = true;
        numNeighVertices = new PiVector(numNew);
        i = 0;
        while (i < numNew) {
            numNeighVertices.m_data[i] = triangGeom.hasTagVertex(i, 14) != false ? 1 : 0;
            ++i;
        }
        numTriangles = triangGeom.getNumElements();
        i = 0;
        while (i < numTriangles) {
            element = triangGeom.getElement(i);
            elSize = element.getSize();
            j = 0;
            while (j < elSize) {
                v0 = element.m_data[j];
                numNeighVertices.m_data[v0] = numNeighVertices.m_data[v0] + 1;
                ++j;
            }
            ++i;
        }
        numEdgeCollapses = edgeCollapseVector.size();
        ec = new PiVector(numNew);
        i = 0;
        while (i < numNew) {
            ec.m_data[i] = i;
            ++i;
        }
        i = 0;
        while (i < numEdgeCollapses) {
            edge = (PiVector)edgeCollapseVector.elementAt(i);
            ind0 = 0;
            if (edge.m_data[0] > edge.m_data[1]) {
                ind0 = 1;
            }
            if (ec.m_data[edge.m_data[(ind0 + 1) % 2]] != edge.m_data[ind0]) {
                if (ec.m_data[edge.m_data[(ind0 + 1) % 2]] == edge.m_data[(ind0 + 1) % 2]) {
                    ec.m_data[edge.m_data[(ind0 + 1) % 2]] = edge.m_data[ind0];
                } else {
                    vertexIndex0 = ec.m_data[edge.m_data[(ind0 + 1) % 2]];
                    vertexIndex1 = edge.m_data[ind0];
                    vertexIndex2 = edge.m_data[(ind0 + 1) % 2];
                    do {
                        if (vertexIndex0 < vertexIndex1) {
                            ec.m_data[vertexIndex2] = vertexIndex1;
                            vertexIndex2 = vertexIndex1;
                            if (vertexIndex1 == ec.m_data[vertexIndex1]) {
                                ec.m_data[vertexIndex1] = vertexIndex0;
                                vertexIndex1 = vertexIndex0;
                                continue;
                            }
                            vertexIndex1 = ec.m_data[vertexIndex1];
                            continue;
                        }
                        if (vertexIndex0 > vertexIndex1) {
                            ec.m_data[vertexIndex2] = vertexIndex0;
                            vertexIndex2 = vertexIndex0;
                            if (vertexIndex0 == ec.m_data[vertexIndex0]) {
                                ec.m_data[vertexIndex0] = vertexIndex1;
                                vertexIndex0 = vertexIndex1;
                                continue;
                            }
                            vertexIndex0 = ec.m_data[vertexIndex0];
                            continue;
                        }
                        ec.m_data[vertexIndex2] = vertexIndex0;
                    } while (vertexIndex0 != vertexIndex1);
                }
            }
            ++i;
        }
        i = 0;
        ** GOTO lbl70
        {
            ec.m_data[i] = ec.m_data[ec.m_data[i]];
            do {
                if (ec.m_data[i] != ec.m_data[ec.m_data[i]]) continue block6;
                ++i;
lbl70:
                // 2 sources

            } while (i < numNew);
        }
        i = 0;
        while (i < numNew) {
            if (ec.m_data[i] != i) {
                v1 = ec.m_data[i];
                numNeighVertices.m_data[v1] = numNeighVertices.m_data[v1] + numNeighVertices.m_data[i];
                v2 = ec.m_data[i];
                numNeighVertices.m_data[v2] = numNeighVertices.m_data[v2] - 2;
                numNeighVertices.m_data[i] = 0;
            }
            ++i;
        }
        i = 0;
        while (i < numTriangles) {
            element = triangGeom.getElement(i);
            elSize = element.getSize();
            j = 0;
            while (j < elSize) {
                element.m_data[j] = ec.m_data[element.m_data[j]];
                ++j;
            }
            elSize = element.getSize();
            newSize = 1;
            j = 1;
            while (j < elSize) {
                if (element.m_data[j] != element.m_data[newSize - 1]) {
                    element.m_data[newSize] = element.m_data[j];
                    ++newSize;
                }
                ++j;
            }
            while (element.m_data[newSize - 1] == element.m_data[0] && newSize > 1) {
                --newSize;
            }
            element.setSize(newSize);
            elSize = element.getSize();
            if (elSize == 1) {
                v3 = element.m_data[0];
                numNeighVertices.m_data[v3] = numNeighVertices.m_data[v3] - 2;
                triangGeom.setTagElement(i, 2);
            } else if (elSize == 2) {
                j = 0;
                while (j < 2) {
                    v4 = element.m_data[j];
                    numNeighVertices.m_data[v4] = numNeighVertices.m_data[v4] - 1;
                    ++j;
                }
                triangGeom.setTagElement(i, 2);
            }
            ++i;
        }
        while (bChanged) {
            bChanged = false;
            i = 0;
            while (i < numNew) {
                if (!triangGeom.hasTagVertex(i, 1) && numNeighVertices.m_data[i] < 3) {
                    triangGeom.setTagVertex(i, 2);
                }
                ++i;
            }
            newNoe = triangGeom.getNumElements();
            i = 0;
            while (i < newNoe) {
                if (!triangGeom.hasTagElement(i, 2)) {
                    element = triangGeom.getElement(i);
                    size = element.getSize();
                    newSize = 0;
                    j = 0;
                    while (j < size) {
                        if (!triangGeom.hasTagVertex(element.m_data[j], 2)) {
                            if (newSize > 0 && (element.m_data[j] == element.m_data[newSize - 1] || j == size - 1 && element.m_data[j] == element.m_data[0])) {
                                v5 = element.m_data[j];
                                numNeighVertices.m_data[v5] = numNeighVertices.m_data[v5] - 1;
                                if (numNeighVertices.m_data[element.m_data[j]] < 3) {
                                    bChanged = true;
                                }
                            } else {
                                element.m_data[newSize] = element.m_data[j];
                                ++newSize;
                            }
                        }
                        ++j;
                    }
                    element.setSize(newSize);
                    if (newSize < 3) {
                        triangGeom.setTagElement(i, 2);
                        j = 0;
                        while (j < newSize) {
                            v6 = element.m_data[j];
                            numNeighVertices.m_data[v6] = numNeighVertices.m_data[v6] - 1;
                            if (numNeighVertices.m_data[element.m_data[j]] < 3) {
                                bChanged = true;
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        i = 0;
        while (i < numNew) {
            triangGeom.clearTagVertex(i, 1);
            ++i;
        }
        triangGeom.removeMarkedElements();
        triangGeom.removeMarkedVertices();
        triangGeom.removeUnusedVertices();
    }

    public static void rotateTextures(PgElementSet geom) {
        int noe = geom.getNumElements();
        PdVector[][] tex = geom.getElementTextures();
        int i = 0;
        while (i < noe) {
            int elSize = geom.getElement(i).getSize();
            int j = 0;
            while (j < elSize) {
                double x = tex[i][j].m_data[0];
                double y = tex[i][j].m_data[1];
                tex[i][j].m_data[0] = x - y;
                tex[i][j].m_data[1] = x + y;
                ++j;
            }
            ++i;
        }
    }

    public static void rotateData(PiVector[][] intTex) {
        int noe = intTex.length;
        int i = 0;
        while (i < noe) {
            int elSize = intTex[i].length;
            int j = 0;
            while (j < elSize) {
                int x = intTex[i][j].m_data[0];
                int y = intTex[i][j].m_data[1];
                intTex[i][j].m_data[0] = x - y;
                intTex[i][j].m_data[1] = x + y;
                ++j;
            }
            ++i;
        }
    }
}

