/*
 * Decompiled with CFR 0.152.
 */
package dev.geom;

import dev.geom.MeshInfo;
import java.awt.Color;
import java.util.Vector;
import jv.geom.PgEdgeStar;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;
import jv.vecmath.PuVectorGeom;
import jvx.geom.PgVertexStar;
import jvx.project.PjWorkshop;

public class PwTex2Quad
extends PjWorkshop {
    private static final int m_quantizationBits = 10;
    public static final int HIERARCHY_POWER_OF_TWO = 0;
    public static final int HIERARCHY_FLAT = 1;
    public static int m_hierarchyMode = 0;

    public PwTex2Quad() {
        super(PsConfig.getMessage((boolean)true, (int)51000, (String)"Texture to Quadrangulation"));
        if (((Object)((Object)this)).getClass() == PwTex2Quad.class) {
            this.init();
        }
    }

    public static PgElementSet tex2Quad(PgElementSet geom, int numRefineLevels) {
        return PwTex2Quad.tex2Quad(geom, numRefineLevels, null);
    }

    public static PgElementSet tex2Quad(PgElementSet geom, int numRefineLevels, PiVector levels) {
        if (geom.getDimOfElements() != 3) {
            PsDebug.warning((String)"Geometry is not triangulated.");
            return null;
        }
        int noe = geom.getNumElements();
        if (!geom.hasElementTextures()) {
            PsDebug.warning((String)"Geometry does not have element texture.");
            return null;
        }
        int quantization = 1024;
        PiVector[][] intTex = PwTex2Quad.quantizeElementTexture(geom, quantization);
        int maxIntCoord = 0;
        int i = 0;
        while (i < noe) {
            int j = 0;
            while (j < 3) {
                int k = 0;
                while (k < 2) {
                    if (intTex[i][j].m_data[k] > maxIntCoord) {
                        maxIntCoord = intTex[i][j].m_data[k];
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        if (maxIntCoord % quantization != 0) {
            maxIntCoord += quantization - maxIntCoord % quantization;
        }
        PwTex2Quad.checkIntTexture(geom, intTex, quantization, maxIntCoord += quantization);
        if (!PwTex2Quad.compareTextureEdges(geom, intTex)) {
            PsDebug.warning((String)"Textures do not fit together good enough at edges.");
            return null;
        }
        return PwTex2Quad.ints2Quad(geom, quantization, intTex, numRefineLevels, levels);
    }

    public static PgElementSet quantizedTex2Quad(PgElementSet geom, PiVector[][] quantizedTexture, int quantization, int numRefineLevels) {
        return PwTex2Quad.quantizedTex2Quad(geom, quantizedTexture, quantization, numRefineLevels, null);
    }

    public static PgElementSet quantizedTex2Quad(PgElementSet geom, PiVector[][] quantizedTexture, int quantization, int numRefineLevels, PiVector levels) {
        if (geom.getDimOfElements() != 3) {
            PsDebug.warning((String)"Geometry is not triangulated.");
            return null;
        }
        int noe = geom.getNumElements();
        if (quantizedTexture == null || quantizedTexture.length != noe) {
            PsDebug.warning((String)"Quantized texture does not exist or has wrong length.");
            return null;
        }
        PwTex2Quad.assurePositiveTexs(geom, quantizedTexture, quantization << numRefineLevels);
        return PwTex2Quad.ints2Quad(geom, quantization, quantizedTexture, numRefineLevels, levels);
    }

    private static void assurePositiveTexs(PgElementSet geom, PiVector[][] texture, int quantization) {
        int numElements = geom.getNumElements();
        int minimumU = Integer.MAX_VALUE;
        int minimumV = Integer.MAX_VALUE;
        int e = 0;
        while (e < numElements) {
            int i = 0;
            while (i < 3) {
                int u = texture[e][i].m_data[0];
                int v = texture[e][i].m_data[1];
                if (u < minimumU) {
                    minimumU = u;
                }
                if (v < minimumV) {
                    minimumV = v;
                }
                ++i;
            }
            ++e;
        }
        int shiftU = 0;
        if (minimumU < 0) {
            shiftU = quantization * (-minimumU / quantization + 1);
        }
        int shiftV = 0;
        if (minimumV < 0) {
            shiftV = quantization * (-minimumV / quantization + 1);
        }
        int e2 = 0;
        while (e2 < numElements) {
            int i = 0;
            while (i < 3) {
                texture[e2][i].m_data[0] = texture[e2][i].m_data[0] + shiftU;
                texture[e2][i].m_data[1] = texture[e2][i].m_data[1] + shiftV;
                ++i;
            }
            ++e2;
        }
    }

    private static PgElementSet ints2Quad(PgElementSet geom, int quantization, PiVector[][] intTex, int numRefineLevels, PiVector levels) {
        int dim = geom.getDimOfVertices();
        PgElementSet quadGeom = new PgElementSet(dim);
        quadGeom.setName("Quads of " + geom.getName());
        int i = 0;
        while (i < intTex.length) {
            int j = 0;
            while (j < intTex[i].length) {
                int k = 0;
                while (k < intTex[i][j].getSize()) {
                    if (m_hierarchyMode == 0) {
                        int n = k;
                        intTex[i][j].m_data[n] = intTex[i][j].m_data[n] << numRefineLevels;
                    } else {
                        int n = k;
                        intTex[i][j].m_data[n] = intTex[i][j].m_data[n] * numRefineLevels;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        Vector assignmentVector = new Vector();
        Vector newVertexTexVector = new Vector();
        PwTex2Quad.addGridVertices(geom, intTex, quantization, assignmentVector, newVertexTexVector, quadGeom);
        int numGridVertices = newVertexTexVector.size();
        PwTex2Quad.addEdgeIntersections(geom, intTex, quantization, assignmentVector, newVertexTexVector, quadGeom);
        int[][] vertexInElement = PwTex2Quad.collectVerticesToElements(geom, assignmentVector);
        Vector edgeCollapseVector = new Vector();
        PwTex2Quad.addinteriorVertices(geom, vertexInElement, quantization, newVertexTexVector, assignmentVector, intTex, edgeCollapseVector);
        int numAddedVertices = quadGeom.getNumVertices();
        PdMatrix M = new PdMatrix(3, 3);
        PdVector b = new PdVector(3);
        int size = newVertexTexVector.size();
        int i2 = numAddedVertices;
        while (i2 < size) {
            MeshInfo[] tex = (MeshInfo[])newVertexTexVector.elementAt(i2);
            int elIndex = tex[0].m_element;
            int j = 0;
            while (j < 3) {
                M.m_data[0][j] = intTex[elIndex][j].m_data[0];
                M.m_data[1][j] = intTex[elIndex][j].m_data[1];
                M.m_data[2][j] = 1.0;
                ++j;
            }
            b.set((double)tex[0].m_tex[0], (double)tex[0].m_tex[1], 1.0);
            M.invert();
            b.leftMultMatrix(M);
            PiVector element = geom.getElement(elIndex);
            PdVector newVertex = PdVector.blendNew((double)b.m_data[0], (PdVector)geom.getVertex(element.m_data[0]), (double)b.m_data[1], (PdVector)geom.getVertex(element.m_data[1]), (double)b.m_data[2], (PdVector)geom.getVertex(element.m_data[2]));
            quadGeom.addVertex(newVertex);
            ++i2;
        }
        if (levels != null) {
            PwTex2Quad.computeHierarchyLevels(quadGeom, newVertexTexVector, quantization, numRefineLevels);
        }
        int[][] neighbourVertex = PwTex2Quad.joinConnectivityInformation(newVertexTexVector);
        PwTex2Quad.getElements(quadGeom, neighbourVertex, newVertexTexVector.size());
        int i3 = 0;
        while (i3 < numGridVertices) {
            MeshInfo ci = ((MeshInfo[])newVertexTexVector.elementAt(i3))[0];
            if (ci.m_tex[0] % quantization == 0 && ci.m_tex[1] % quantization == 0) {
                quadGeom.setTagVertex(i3, 1);
            }
            ++i3;
        }
        PwTex2Quad.removeEdgeVertices(quadGeom, newVertexTexVector.size(), edgeCollapseVector);
        quadGeom.assureDimOfElements();
        if (levels != null) {
            PwTex2Quad.fillLevelVector(levels, quadGeom);
        }
        i3 = 0;
        while (i3 < quadGeom.getNumVertices()) {
            quadGeom.clearTagVertex(i3, 14);
            ++i3;
        }
        quadGeom.assureDimOfElements();
        quadGeom.makeNeighbour();
        quadGeom.makeElementNormals();
        quadGeom.makeVertexNormals();
        quadGeom.setGlobalElementColor(Color.white);
        i3 = 0;
        while (i3 < intTex.length) {
            int j = 0;
            while (j < intTex[i3].length) {
                int k = 0;
                while (k < intTex[i3][j].getSize()) {
                    int n = k++;
                    intTex[i3][j].m_data[n] = intTex[i3][j].m_data[n] >> numRefineLevels;
                }
                ++j;
            }
            ++i3;
        }
        return quadGeom;
    }

    private static void computeHierarchyLevels(PgElementSet quadGeom, Vector newVertexTexVector, int quantization, int numRefineLevels) {
        int numQuadVertices = quadGeom.getNumVertices();
        int size = newVertexTexVector.size();
        if (size != numQuadVertices) {
            PsDebug.warning((String)"Wrong size.");
            return;
        }
        PiVector levels = new PiVector(quadGeom.getNumVertices());
        if (m_hierarchyMode == 0) {
            int quantizationBits = PwTex2Quad.numberOfTrailingZeros(quantization);
            int i = 0;
            while (i < size) {
                MeshInfo[] ci = (MeshInfo[])newVertexTexVector.elementAt(i);
                if (ci.length > 0) {
                    int level = PwTex2Quad.numberOfTrailingZeros(ci[0].m_tex[0] | ci[0].m_tex[1]);
                    level = Math.min(level, quantizationBits + numRefineLevels);
                    levels.m_data[i] = quantizationBits + numRefineLevels - level;
                    quadGeom.getVertex(i).setName("" + levels.m_data[i]);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < size) {
                MeshInfo[] ci = (MeshInfo[])newVertexTexVector.elementAt(i);
                if (ci.length > 0) {
                    int level = 0;
                    int j = 0;
                    while (j < 2) {
                        if (ci[0].m_tex[j] % (numRefineLevels * quantization) != 0) {
                            ++level;
                        }
                        ++j;
                    }
                    levels.m_data[i] = level;
                    if (ci[0].m_tex[0] % quantization != 0 || ci[0].m_tex[1] % quantization != 0) {
                        levels.m_data[i] = -1;
                    }
                    quadGeom.getVertex(i).setName("" + levels.m_data[i]);
                }
                ++i;
            }
        }
    }

    private static void fillLevelVector(PiVector levels, PgElementSet quadGeom) {
        int numVertices = quadGeom.getNumVertices();
        levels.setSize(numVertices);
        levels.setConstant(-1);
        int i = 0;
        while (i < numVertices) {
            if (m_hierarchyMode == 0 && quadGeom.hasTagVertex(i, 14)) {
                levels.m_data[i] = -1;
            } else {
                String name = quadGeom.getVertex(i).getName();
                if (name == null) {
                    PsDebug.warning((String)("Assignment of vertex levels failed at new vertex " + i + "."));
                    break;
                }
                levels.m_data[i] = Integer.parseInt(name);
            }
            quadGeom.getVertex(i).setName(null);
            ++i;
        }
    }

    private static int numberOfTrailingZeros(int i) {
        if (i == 0) {
            return 32;
        }
        int n = 31;
        int y = i << 16;
        if (y != 0) {
            n -= 16;
            i = y;
        }
        if ((y = i << 8) != 0) {
            n -= 8;
            i = y;
        }
        if ((y = i << 4) != 0) {
            n -= 4;
            i = y;
        }
        if ((y = i << 2) != 0) {
            n -= 2;
            i = y;
        }
        return n - (i << 1 >>> 31);
    }

    private static PiVector[][] quantizeElementTexture(PgElementSet geom, int quantization) {
        int noe = geom.getNumElements();
        PdVector[][] tex = geom.getElementTextures();
        int[] max = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE};
        int i = 0;
        while (i < noe) {
            int j = 0;
            while (j < 3) {
                int k = 0;
                while (k < 2) {
                    if (tex[i][j].m_data[k] < (double)max[k]) {
                        max[k] = (int)tex[i][j].m_data[k];
                        if (tex[i][j].m_data[k] < 0.0) {
                            int n = k;
                            max[n] = max[n] - 1;
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        PiVector[][] intTex = new PiVector[noe][];
        int i2 = 0;
        while (i2 < noe) {
            intTex[i2] = PiVector.realloc(null, (int)3, (int)2);
            int j = 0;
            while (j < 3) {
                int k = 0;
                while (k < 2) {
                    intTex[i2][j].m_data[k] = (int)((tex[i2][j].m_data[k] - (double)max[k]) * (double)quantization + 0.5);
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
        return intTex;
    }

    private static void checkIntTexture(PgElementSet geom, PiVector[][] intTex, int quantization, int maxIntCoord) {
        int nov = geom.getNumVertices();
        int[] elementPerVertex = PgVertexStar.getElementPerVertex((PgElementSet)geom).m_data;
        PgVertexStar vs = new PgVertexStar();
        PdVector texNormal = new PdVector(0.0, 0.0, 1.0);
        PdVector e1 = new PdVector(2);
        PdVector e2 = new PdVector(2);
        int v = 0;
        while (v < nov) {
            vs.makeVertexStar(geom, v, elementPerVertex[v]);
            PiVector elInd = vs.getElement();
            PiVector locInd = vs.getVertexLocInd();
            int numVSEl = vs.getSize();
            double angle = 0.0;
            int k = 0;
            while (k < numVSEl) {
                int elem = elInd.m_data[k];
                PiVector tex1 = intTex[elem][locInd.m_data[k]];
                PiVector tex2 = intTex[elem][(locInd.m_data[k] + 1) % 3];
                PiVector tex3 = intTex[elem][(locInd.m_data[k] + 2) % 3];
                e1.set((double)(tex2.m_data[0] - tex1.m_data[0]), (double)(tex2.m_data[1] - tex1.m_data[1]));
                e2.set((double)(tex3.m_data[0] - tex1.m_data[0]), (double)(tex3.m_data[1] - tex1.m_data[1]));
                double a = PdVector.angleWithOrientation((PdVector)e1, (PdVector)e2, (PdVector)texNormal);
                if (a < 0.0) {
                    geom.setTagElement(elem, 1);
                } else {
                    geom.clearTagElement(elem, 1);
                }
                angle += a;
                if (Math.abs(a) < 1.0E-10) {
                    PsDebug.warning((String)("Texture triangle " + elem + " is degenerated. Angle: " + a + " Sign " + (float)PuMath.sign((double)PdVector.dot((PdVector)e1, (PdVector)e2))));
                }
                ++k;
            }
            angle *= 57.29577951308232;
            int numRightAngles = ((int)(angle = Math.abs(angle)) + 45) / 90;
            if (numRightAngles != 4 && numRightAngles != 0 && vs.isClosed()) {
                PiVector tex = intTex[elInd.m_data[0]][locInd.m_data[0]];
                int d0 = tex.m_data[0] % quantization;
                int d1 = tex.m_data[1] % quantization;
                int nearest = -1;
                if (d0 < quantization / 8) {
                    if (d1 < quantization / 8) {
                        nearest = 0;
                    } else if (quantization - d1 < quantization / 8) {
                        nearest = 1;
                    }
                } else if (quantization - d0 < quantization / 8) {
                    if (d1 < quantization / 8) {
                        nearest = 3;
                    } else if (quantization - d1 < quantization / 8) {
                        nearest = 2;
                    }
                } else if (Math.abs(d0 - quantization / 2) < quantization / 8 && Math.abs(d1 - quantization / 2) < quantization / 8) {
                    nearest = 4;
                }
                if (nearest == -1) {
                    PsDebug.warning((String)("Vertex " + v + " angle: " + angle + " Texture coordinates (mod 1) " + (double)d0 / (double)quantization + "; " + (double)d1 / (double)quantization));
                } else {
                    tex.m_data[0] = tex.m_data[0] - tex.m_data[0] % quantization;
                    tex.m_data[1] = tex.m_data[1] - tex.m_data[1] % quantization;
                    if (nearest == 1 || nearest == 2) {
                        tex.m_data[0] = tex.m_data[0] + quantization;
                    }
                    if (nearest == 2 || nearest == 3) {
                        tex.m_data[1] = tex.m_data[1] + quantization;
                    }
                    if (nearest == 4) {
                        tex.m_data[0] = tex.m_data[0] + quantization / 2;
                        tex.m_data[1] = tex.m_data[1] + quantization / 2;
                    }
                }
            }
            int k2 = 0;
            while (k2 < numVSEl - 1) {
                int[] locIndOther = new int[]{-1, -1};
                PiVector el0 = geom.getElement(elInd.m_data[k2]);
                PiVector el1 = geom.getElement(elInd.m_data[k2 + 1]);
                int m = 1;
                while (m < 3) {
                    int n = 1;
                    while (n < 3) {
                        if (el0.m_data[(locInd.m_data[k2] + m) % 3] == el1.m_data[(locInd.m_data[k2 + 1] + n) % 3]) {
                            locIndOther[0] = (locInd.m_data[k2] + m) % 3;
                            locIndOther[1] = (locInd.m_data[k2 + 1] + n) % 3;
                        }
                        ++n;
                    }
                    ++m;
                }
                PiVector[] edgeVector = PiVector.realloc(null, (int)2, (int)2);
                int m2 = 0;
                while (m2 < 2) {
                    edgeVector[m2].sub(intTex[elInd.m_data[k2 + m2]][locIndOther[m2]], intTex[elInd.m_data[k2 + m2]][locInd.m_data[k2 + m2]]);
                    ++m2;
                }
                PiVector currIntTex = intTex[elInd.m_data[k2 + 1]][locInd.m_data[k2 + 1]];
                int rotation = 0;
                int[] rotatedCoord = new int[]{currIntTex.m_data[0], currIntTex.m_data[1]};
                int sp = PiVector.dot((PiVector)edgeVector[0], (PiVector)edgeVector[1]);
                if (edgeVector[0].m_data[0] * edgeVector[1].m_data[1] - edgeVector[0].m_data[1] * edgeVector[1].m_data[0] > sp) {
                    sp = edgeVector[0].m_data[0] * edgeVector[1].m_data[1] - edgeVector[0].m_data[1] * edgeVector[1].m_data[0];
                    rotation = 1;
                    rotatedCoord[0] = currIntTex.m_data[1];
                    rotatedCoord[1] = maxIntCoord - currIntTex.m_data[0];
                }
                if (-PiVector.dot((PiVector)edgeVector[0], (PiVector)edgeVector[1]) > sp) {
                    sp = -PiVector.dot((PiVector)edgeVector[0], (PiVector)edgeVector[1]);
                    rotation = 2;
                    rotatedCoord[0] = maxIntCoord - currIntTex.m_data[0];
                    rotatedCoord[1] = maxIntCoord - currIntTex.m_data[1];
                }
                if (-edgeVector[0].m_data[0] * edgeVector[1].m_data[1] + edgeVector[0].m_data[1] * edgeVector[1].m_data[0] > sp) {
                    rotation = 3;
                    rotatedCoord[0] = maxIntCoord - currIntTex.m_data[1];
                    rotatedCoord[1] = currIntTex.m_data[0];
                }
                if (intTex[elInd.m_data[k2]][locInd.m_data[k2]].m_data[0] % quantization != rotatedCoord[0] % quantization || intTex[elInd.m_data[k2]][locInd.m_data[k2]].m_data[1] % quantization != rotatedCoord[1] % quantization) {
                    int m3 = 0;
                    while (m3 < 2) {
                        if (intTex[elInd.m_data[k2]][locInd.m_data[k2]].m_data[m3] % quantization != rotatedCoord[m3] % quantization) {
                            int before = rotatedCoord[m3];
                            if (rotatedCoord[m3] % quantization > quantization * 3 / 4 && intTex[elInd.m_data[k2]][locInd.m_data[k2]].m_data[m3] % quantization < quantization / 4) {
                                int n = m3;
                                rotatedCoord[n] = rotatedCoord[n] + quantization;
                            }
                            if (rotatedCoord[m3] % quantization < quantization / 4 && intTex[elInd.m_data[k2]][locInd.m_data[k2]].m_data[m3] % quantization > quantization * 3 / 4) {
                                int n = m3;
                                rotatedCoord[n] = rotatedCoord[n] - quantization;
                            }
                            int n = m3;
                            rotatedCoord[n] = rotatedCoord[n] - rotatedCoord[m3] % quantization;
                            int n2 = m3;
                            rotatedCoord[n2] = rotatedCoord[n2] + intTex[elInd.m_data[k2]][locInd.m_data[k2]].m_data[m3] % quantization;
                            if (Math.abs(rotatedCoord[m3] - before) > quantization / 4) {
                                PsDebug.message((String)("Rotation " + rotation + " diff " + (rotatedCoord[m3] - before)));
                            }
                        }
                        ++m3;
                    }
                }
                if (rotation == 0) {
                    if (Math.abs(currIntTex.m_data[0] - rotatedCoord[0]) > quantization / 4 || Math.abs(currIntTex.m_data[1] - rotatedCoord[1]) > quantization / 4) {
                        PsDebug.message((String)("Rotation: " + rotation + " - Large Difference." + " Vertex: " + v + " Elements: " + elInd.m_data[k2] + " and " + elInd.m_data[k2 + 1]));
                    }
                    currIntTex.m_data[0] = rotatedCoord[0];
                    currIntTex.m_data[1] = rotatedCoord[1];
                } else if (rotation == 1) {
                    if (Math.abs(currIntTex.m_data[0] - maxIntCoord + rotatedCoord[1]) > quantization / 4 || Math.abs(currIntTex.m_data[1] - rotatedCoord[0]) > quantization / 4) {
                        PsDebug.message((String)("Rotation: " + rotation + " - Large Difference." + " Vertex: " + v + " Elements: " + elInd.m_data[k2] + " and " + elInd.m_data[k2 + 1]));
                    }
                    currIntTex.m_data[0] = maxIntCoord - rotatedCoord[1];
                    currIntTex.m_data[1] = rotatedCoord[0];
                } else if (rotation == 2) {
                    if (Math.abs(currIntTex.m_data[0] - maxIntCoord + rotatedCoord[0]) > quantization / 4 || Math.abs(currIntTex.m_data[1] - maxIntCoord + rotatedCoord[1]) > quantization / 4) {
                        PsDebug.message((String)("Rotation: " + rotation + " - Large Difference." + " Vertex: " + v + " Elements: " + elInd.m_data[k2] + " and " + elInd.m_data[k2 + 1]));
                    }
                    currIntTex.m_data[0] = maxIntCoord - rotatedCoord[0];
                    currIntTex.m_data[1] = maxIntCoord - rotatedCoord[1];
                } else if (rotation == 3) {
                    if (Math.abs(currIntTex.m_data[0] - rotatedCoord[1]) > quantization / 4 || Math.abs(currIntTex.m_data[1] - maxIntCoord + rotatedCoord[0]) > quantization / 4) {
                        PsDebug.message((String)("Rotation: " + rotation + " - Large Difference." + " Vertex: " + v + " Elements: " + elInd.m_data[k2] + " and " + elInd.m_data[k2 + 1]));
                    }
                    currIntTex.m_data[0] = rotatedCoord[1];
                    currIntTex.m_data[1] = maxIntCoord - rotatedCoord[0];
                }
                ++k2;
            }
            ++v;
        }
    }

    private static boolean compareTextureEdges(PgElementSet geom, PiVector[][] intTex) {
        int nov = geom.getNumVertices();
        int[] elementPerVertex = PgVertexStar.getElementPerVertex((PgElementSet)geom).m_data;
        PgVertexStar vs = new PgVertexStar();
        int v = 0;
        while (v < nov) {
            vs.makeVertexStar(geom, v, elementPerVertex[v]);
            PiVector elInd = vs.getElement();
            PiVector locInd = vs.getVertexLocInd();
            int numVSEl = vs.getSize();
            int k = 0;
            while (k < numVSEl - 1) {
                int[] locIndOther = new int[]{-1, -1};
                PiVector el0 = geom.getElement(elInd.m_data[k]);
                PiVector el1 = geom.getElement(elInd.m_data[k + 1]);
                int m = 1;
                while (m < 3) {
                    int n = 1;
                    while (n < 3) {
                        if (el0.m_data[(locInd.m_data[k] + m) % 3] == el1.m_data[(locInd.m_data[k + 1] + n) % 3]) {
                            locIndOther[0] = (locInd.m_data[k] + m) % 3;
                            locIndOther[1] = (locInd.m_data[k + 1] + n) % 3;
                        }
                        ++n;
                    }
                    ++m;
                }
                PiVector[] edgeVector = PiVector.realloc(null, (int)2, (int)2);
                int m2 = 0;
                while (m2 < 2) {
                    edgeVector[m2].sub(intTex[elInd.m_data[k + m2]][locIndOther[m2]], intTex[elInd.m_data[k + m2]][locInd.m_data[k + m2]]);
                    ++m2;
                }
                if (PiVector.dot((PiVector)edgeVector[0], (PiVector)edgeVector[0]) != PiVector.dot((PiVector)edgeVector[1], (PiVector)edgeVector[1])) {
                    PsDebug.warning((String)"Edge has adjacent triangles with not compatible texture information.");
                    return false;
                }
                ++k;
            }
            ++v;
        }
        return true;
    }

    private static void addGridVertices(PgElementSet geom, PiVector[][] intTex, int quantization, Vector assignmentVector, Vector newVertexTexVector, PgElementSet quadGeom) {
        int nov = geom.getNumVertices();
        int numNew = 0;
        PgVertexStar vs = new PgVertexStar();
        int[] elementPerVertex = PgVertexStar.getElementPerVertex((PgElementSet)geom).m_data;
        int v = 0;
        while (v < nov) {
            vs.makeVertexStar(geom, v, elementPerVertex[v]);
            PiVector elInd = vs.getElement();
            PiVector locInd = vs.getVertexLocInd();
            int starSize = vs.getSize();
            if (intTex[elInd.m_data[0]][locInd.m_data[0]].m_data[0] % quantization == 0 || intTex[elInd.m_data[0]][locInd.m_data[0]].m_data[1] % quantization == 0) {
                boolean bGridPoint = intTex[elInd.m_data[0]][locInd.m_data[0]].m_data[0] % quantization == 0 && intTex[elInd.m_data[0]][locInd.m_data[0]].m_data[1] % quantization == 0;
                int numAssignments = 0;
                MeshInfo[] newIntTex = new MeshInfo[starSize];
                int k = 0;
                while (k < starSize) {
                    newIntTex[k] = new MeshInfo();
                    int el = elInd.m_data[k];
                    PiVector thisElIntTex = intTex[el][locInd.m_data[k]];
                    PiVector nextElIntTex = intTex[el][(locInd.m_data[k] + 1) % 3];
                    PiVector prevElIntTex = intTex[el][(locInd.m_data[k] + 2) % 3];
                    if (bGridPoint) {
                        assignmentVector.addElement(new int[]{el, numNew});
                        ++numAssignments;
                        newIntTex[k].m_element = el;
                        newIntTex[k].m_tex[0] = thisElIntTex.m_data[0];
                        newIntTex[k].m_tex[1] = thisElIntTex.m_data[1];
                    } else {
                        int coordIndex = -1;
                        int m = 0;
                        while (m < 2) {
                            if (thisElIntTex.m_data[m] % quantization != 0) {
                                coordIndex = m;
                            }
                            ++m;
                        }
                        if (coordIndex < 0) {
                            PsDebug.warning((String)"no non-grid tex coordinate found.");
                            return;
                        }
                        if (thisElIntTex.m_data[(coordIndex + 1) % 2] < nextElIntTex.m_data[(coordIndex + 1) % 2] && thisElIntTex.m_data[(coordIndex + 1) % 2] < prevElIntTex.m_data[(coordIndex + 1) % 2] || thisElIntTex.m_data[(coordIndex + 1) % 2] > nextElIntTex.m_data[(coordIndex + 1) % 2] && thisElIntTex.m_data[(coordIndex + 1) % 2] > prevElIntTex.m_data[(coordIndex + 1) % 2]) {
                            newIntTex[k].m_element = -1;
                        } else {
                            assignmentVector.addElement(new int[]{el, numNew});
                            ++numAssignments;
                            newIntTex[k].m_element = el;
                            newIntTex[k].m_tex[(coordIndex + 1) % 2] = thisElIntTex.m_data[(coordIndex + 1) % 2];
                            newIntTex[k].m_tex[coordIndex] = thisElIntTex.m_data[coordIndex] - thisElIntTex.m_data[coordIndex] % quantization;
                            int[] rotatedEdge = new int[]{nextElIntTex.m_data[1] - prevElIntTex.m_data[1], prevElIntTex.m_data[0] - nextElIntTex.m_data[0]};
                            if (rotatedEdge[0] * (thisElIntTex.m_data[0] - nextElIntTex.m_data[0]) + rotatedEdge[1] * (thisElIntTex.m_data[1] - nextElIntTex.m_data[1]) < 0) {
                                rotatedEdge[0] = rotatedEdge[0] * -1;
                                rotatedEdge[1] = rotatedEdge[1] * -1;
                            }
                            if (rotatedEdge[0] * (thisElIntTex.m_data[0] - nextElIntTex.m_data[0]) + rotatedEdge[1] * (thisElIntTex.m_data[1] - nextElIntTex.m_data[1]) < rotatedEdge[0] * (newIntTex[k].m_tex[0] - nextElIntTex.m_data[0]) + rotatedEdge[1] * (newIntTex[k].m_tex[1] - nextElIntTex.m_data[1])) {
                                int n = coordIndex;
                                newIntTex[k].m_tex[n] = newIntTex[k].m_tex[n] + quantization / 4;
                            } else {
                                int n = coordIndex;
                                newIntTex[k].m_tex[n] = newIntTex[k].m_tex[n] + quantization * 3 / 4;
                            }
                        }
                    }
                    ++k;
                }
                if (numAssignments > 0) {
                    int orientation = 1;
                    if (starSize > 1 && geom.getNeighbour((int)elInd.m_data[0]).m_data[(locInd.m_data[0] + 2) % 3] != elInd.m_data[1]) {
                        orientation = -1;
                    }
                    MeshInfo[] newIntTex2 = new MeshInfo[numAssignments];
                    int j = 0;
                    int k2 = 0;
                    while (k2 < starSize) {
                        if (newIntTex[k2].m_element != -1) {
                            newIntTex2[j++] = orientation == -1 ? newIntTex[k2] : newIntTex[starSize - 1 - k2];
                        }
                        ++k2;
                    }
                    newVertexTexVector.addElement(newIntTex2);
                    ++numNew;
                    quadGeom.addVertex(PdVector.copyNew((PdVector)geom.getVertex(v)));
                    if (!vs.isClosed()) {
                        quadGeom.setTagVertex(quadGeom.getNumVertices() - 1, 14);
                    } else {
                        quadGeom.clearTagVertex(quadGeom.getNumVertices() - 1, 14);
                    }
                }
            }
            ++v;
        }
    }

    private static void addEdgeIntersections(PgElementSet geom, PiVector[][] intTex, int quantization, Vector assignmentVector, Vector newVertexTexVector, PgElementSet quadGeom) {
        geom.allocateEdgeStars();
        PgEdgeStar[] edgeStars = geom.getEdgeStars();
        int numEdges = geom.getNumEdges();
        PiVector edge = new PiVector(2);
        PiVector edgeK = new PiVector(2);
        PiVector rotatedEdge = new PiVector(2);
        PiVector triangleEdge = new PiVector(2);
        PiVector notEdge = new PiVector(2);
        int i = 0;
        while (i < numEdges) {
            PgEdgeStar edgeStar = edgeStars[i];
            int[] elemInd = edgeStar.getElementInd();
            int edgeValence = edgeStar.getValence();
            int localInd = edgeStar.getNeighbourLocInd()[0];
            PiVector nextIntTex = intTex[elemInd[0]][(localInd + 1) % 3];
            PiVector prevIntTex = intTex[elemInd[0]][(localInd + 2) % 3];
            PiVector element = geom.getElement(elemInd[0]);
            int p = 0;
            while (p < 2) {
                int start = Math.min(prevIntTex.m_data[p], nextIntTex.m_data[p]) / quantization;
                int end = Math.max(prevIntTex.m_data[p] - 1, nextIntTex.m_data[p] - 1) / quantization;
                int j = start + 1;
                while (j <= end) {
                    long m = j * quantization - nextIntTex.m_data[p];
                    long n = prevIntTex.m_data[p] - nextIntTex.m_data[p];
                    if (p != 1 || nextIntTex.m_data[0] == prevIntTex.m_data[0] || (m * (long)prevIntTex.m_data[0] + (n - m) * (long)nextIntTex.m_data[0]) % (n * (long)quantization) != 0L) {
                        double b = (double)m / (double)n;
                        quadGeom.addVertex(PdVector.blendNew((double)(1.0 - b), (PdVector)geom.getVertex(element.m_data[(localInd + 1) % 3]), (double)b, (PdVector)geom.getVertex(element.m_data[(localInd + 2) % 3])));
                        if (edgeValence == 1) {
                            quadGeom.setTagVertex(quadGeom.getNumVertices() - 1, 14);
                        } else {
                            quadGeom.clearTagVertex(quadGeom.getNumVertices() - 1, 14);
                        }
                        edge.sub(intTex[elemInd[0]][(localInd + 2) % 3], intTex[elemInd[0]][(localInd + 1) % 3]);
                        MeshInfo[] newIntTex = new MeshInfo[edgeValence];
                        int k = 0;
                        while (k < edgeValence) {
                            int localIndexK = edgeStar.getNeighbourLocInd()[k];
                            int lc0 = (localIndexK + 1) % 3;
                            int lc1 = (localIndexK + 2) % 3;
                            if (k != 0) {
                                lc0 = (localIndexK + 2) % 3;
                                lc1 = (localIndexK + 1) % 3;
                            }
                            PiVector[] intTexK = intTex[elemInd[k]];
                            edgeK.sub(intTexK[lc1], intTexK[lc0]);
                            int coordIndex = p;
                            if (k != 0 && Math.abs(edge.dot(edgeK)) < Math.abs(edge.m_data[0] * edgeK.m_data[1] - edge.m_data[1] * edgeK.m_data[0])) {
                                coordIndex = 1 - p;
                            }
                            newIntTex[k] = new MeshInfo();
                            newIntTex[k].m_element = elemInd[k];
                            newIntTex[k].m_tex[coordIndex] = (int)((m * (long)intTexK[lc1].m_data[coordIndex] + (n - m) * (long)intTexK[lc0].m_data[coordIndex]) / n);
                            if ((m * (long)intTexK[lc1].m_data[(coordIndex + 1) % 2] + (n - m) * (long)intTexK[lc0].m_data[(coordIndex + 1) % 2]) % (n * (long)quantization) == 0L) {
                                newIntTex[k].m_tex[(coordIndex + 1) % 2] = (int)((m * (long)intTexK[lc1].m_data[(coordIndex + 1) % 2] + (n - m) * (long)intTexK[lc0].m_data[(coordIndex + 1) % 2]) / n);
                            } else {
                                newIntTex[k].m_tex[(coordIndex + 1) % 2] = (int)((m * (long)intTexK[lc1].m_data[(coordIndex + 1) % 2] + (n - m) * (long)intTexK[lc0].m_data[(coordIndex + 1) % 2]) / (n * (long)quantization));
                                int n2 = (coordIndex + 1) % 2;
                                newIntTex[k].m_tex[n2] = newIntTex[k].m_tex[n2] * quantization;
                                rotatedEdge.set(edgeK.m_data[1], -edgeK.m_data[0]);
                                triangleEdge.sub(intTexK[localIndexK], intTexK[lc0]);
                                notEdge.set(newIntTex[k].m_tex[0] - intTexK[lc0].m_data[0], newIntTex[k].m_tex[1] - intTexK[lc0].m_data[1]);
                                if (rotatedEdge.dot(triangleEdge) == 0) {
                                    rotatedEdge.set(intTexK[(localIndexK + 2) % 3].m_data[1] - intTexK[(localIndexK + 1) % 3].m_data[1], -intTexK[(localIndexK + 2) % 3].m_data[0] + intTexK[(localIndexK + 1) % 3].m_data[0]);
                                    triangleEdge.copyArray(rotatedEdge);
                                }
                                if (PiVector.dot((PiVector)rotatedEdge, (PiVector)triangleEdge) > 0 && PiVector.dot((PiVector)rotatedEdge, (PiVector)notEdge) < 0 || PiVector.dot((PiVector)rotatedEdge, (PiVector)triangleEdge) < 0 && PiVector.dot((PiVector)rotatedEdge, (PiVector)notEdge) > 0) {
                                    int n3 = (coordIndex + 1) % 2;
                                    newIntTex[k].m_tex[n3] = newIntTex[k].m_tex[n3] + quantization / 4;
                                } else {
                                    int n4 = (coordIndex + 1) % 2;
                                    newIntTex[k].m_tex[n4] = newIntTex[k].m_tex[n4] + quantization * 3 / 4;
                                }
                            }
                            assignmentVector.addElement(new int[]{elemInd[k], newVertexTexVector.size()});
                            ++k;
                        }
                        newVertexTexVector.addElement(newIntTex);
                    }
                    ++j;
                }
                ++p;
            }
            ++i;
        }
    }

    private static int[][] collectVerticesToElements(PgElementSet geom, Vector assignmentVector) {
        int[] a;
        int noe = geom.getNumElements();
        int[][] vertexInElement = new int[noe][];
        int[] numVerticesInElement = new int[noe];
        int i = 0;
        while (i < noe) {
            numVerticesInElement[i] = 0;
            ++i;
        }
        int numNew = assignmentVector.size();
        int i2 = 0;
        while (i2 < numNew) {
            a = (int[])assignmentVector.elementAt(i2);
            int n = a[0];
            numVerticesInElement[n] = numVerticesInElement[n] + 1;
            ++i2;
        }
        i2 = 0;
        while (i2 < noe) {
            vertexInElement[i2] = new int[numVerticesInElement[i2]];
            numVerticesInElement[i2] = 0;
            ++i2;
        }
        i2 = 0;
        while (i2 < numNew) {
            a = (int[])assignmentVector.elementAt(i2);
            vertexInElement[a[0]][numVerticesInElement[a[0]]] = a[1];
            int n = a[0];
            numVerticesInElement[n] = numVerticesInElement[n] + 1;
            ++i2;
        }
        return vertexInElement;
    }

    private static int[][] joinConnectivityInformation(Vector newVertexTexVector) {
        int size = newVertexTexVector.size();
        int[][] neighbourVertex = new int[size][];
        int i = 0;
        while (i < size) {
            MeshInfo[] mi = (MeshInfo[])newVertexTexVector.elementAt(i);
            int numAdjacentElements = mi.length;
            int numNeighbourVertices = 0;
            int[] startLocal = new int[numAdjacentElements];
            int j = 0;
            while (j < numAdjacentElements) {
                startLocal[j] = 0;
                ++j;
            }
            j = 0;
            while (j < numAdjacentElements) {
                int k = 0;
                while (k < 4) {
                    if (mi[j].m_neighbour[k] != -1) {
                        ++numNeighbourVertices;
                        if (mi[j].m_neighbour[(k + 3) % 4] == -1) {
                            startLocal[j] = k;
                        }
                    }
                    ++k;
                }
                ++j;
            }
            int[] neighbours = new int[numNeighbourVertices];
            numNeighbourVertices = 0;
            int j2 = 0;
            while (j2 < numAdjacentElements) {
                int k = 0;
                while (k < 4) {
                    if (mi[j2].m_neighbour[(k + startLocal[j2]) % 4] != -1) {
                        neighbours[numNeighbourVertices] = mi[j2].m_neighbour[(k + startLocal[j2]) % 4];
                        ++numNeighbourVertices;
                    }
                    ++k;
                }
                ++j2;
            }
            int cNumNeighbours = 1;
            int j3 = 1;
            while (j3 < numNeighbourVertices) {
                if (neighbours[j3] != neighbours[j3 - 1] && neighbours[j3] != neighbours[0]) {
                    ++cNumNeighbours;
                }
                ++j3;
            }
            int[] cNeighbours = new int[cNumNeighbours];
            cNumNeighbours = 1;
            if (cNeighbours.length <= 0 || neighbours.length <= 0) {
                neighbourVertex[i] = cNeighbours;
            } else {
                cNeighbours[0] = neighbours[0];
                int j4 = 1;
                while (j4 < numNeighbourVertices) {
                    if (neighbours[j4] != neighbours[j4 - 1] && neighbours[j4] != neighbours[0]) {
                        cNeighbours[cNumNeighbours] = neighbours[j4];
                        ++cNumNeighbours;
                    }
                    ++j4;
                }
                neighbourVertex[i] = cNeighbours;
            }
            ++i;
        }
        return neighbourVertex;
    }

    private static void addinteriorVertices(PgElementSet geom, int[][] vertexInElement, int quantization, Vector newVertexTexVector, Vector assignmentVector, PiVector[][] intTex, Vector edgeCollapseVector) {
        int noe = geom.getNumElements();
        int[] texOrient = new int[noe];
        int numPositive = 0;
        int numNegative = 0;
        PdVector v1 = new PdVector(2);
        PdVector v2 = new PdVector(2);
        PdVector cross = new PdVector(3);
        int i = 0;
        while (i < noe) {
            v1.set((double)(intTex[i][1].m_data[0] - intTex[i][0].m_data[0]), (double)(intTex[i][1].m_data[1] - intTex[i][0].m_data[1]));
            v2.set((double)(intTex[i][2].m_data[0] - intTex[i][0].m_data[0]), (double)(intTex[i][2].m_data[1] - intTex[i][0].m_data[1]));
            cross.cross(v1, v2);
            texOrient[i] = 0;
            if (cross.m_data[2] > 0.0) {
                texOrient[i] = 1;
                ++numPositive;
            } else if (cross.m_data[2] < 0.0) {
                texOrient[i] = -1;
                ++numNegative;
            }
            ++i;
        }
        i = 0;
        while (i < noe) {
            if (texOrient[i] == 0) {
                texOrient[i] = numNegative > numPositive ? -1 : 1;
            }
            ++i;
        }
        i = 0;
        while (i < noe) {
            if (vertexInElement[i] != null && vertexInElement[i].length != 0) {
                int m;
                int current;
                int last;
                int k;
                int numVerticesOnBnd = vertexInElement[i].length;
                int[] min = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE};
                int[] max = new int[2];
                int[][] vertexTexCoord = new int[numVerticesOnBnd][2];
                int j = 0;
                while (j < numVerticesOnBnd) {
                    MeshInfo[] mi = (MeshInfo[])newVertexTexVector.elementAt(vertexInElement[i][j]);
                    int numAdjacentElements = mi.length;
                    int k2 = 0;
                    while (k2 < numAdjacentElements) {
                        if (mi[k2].m_element == i) {
                            int m2 = 0;
                            while (m2 < 2) {
                                vertexTexCoord[j][m2] = mi[k2].m_tex[m2];
                                if (vertexTexCoord[j][m2] > max[m2]) {
                                    max[m2] = vertexTexCoord[j][m2];
                                }
                                if (vertexTexCoord[j][m2] < min[m2]) {
                                    min[m2] = vertexTexCoord[j][m2];
                                }
                                ++m2;
                            }
                        }
                        ++k2;
                    }
                    ++j;
                }
                j = 0;
                while (j < 2) {
                    int n = j;
                    min[n] = min[n] / quantization;
                    int n2 = j;
                    max[n2] = max[n2] / (quantization / 4);
                    if (max[j] % 4 != 0) {
                        int n3 = j;
                        max[n3] = max[n3] + 4;
                    }
                    int n4 = j;
                    max[n4] = max[n4] / 4;
                    max[j] = (max[j] - min[j]) * 4 + 1;
                    ++j;
                }
                int[][] localSubGrid = new int[max[0]][max[1]];
                int j2 = 0;
                while (j2 < max[0]) {
                    int k3 = 0;
                    while (k3 < max[1]) {
                        localSubGrid[j2][k3] = -1;
                        ++k3;
                    }
                    ++j2;
                }
                j2 = 0;
                while (j2 < numVerticesOnBnd) {
                    localSubGrid[(vertexTexCoord[j2][0] - quantization * min[0]) * 4 / quantization][(vertexTexCoord[j2][1] - quantization * min[1]) * 4 / quantization] = vertexInElement[i][j2];
                    ++j2;
                }
                j2 = 0;
                while (j2 < max[0]) {
                    int mn = -1;
                    int mx = -1;
                    k = 0;
                    while (k < max[1]) {
                        if (localSubGrid[j2][k] != -1) {
                            mx = k;
                            if (mn == -1) {
                                mn = k;
                            }
                        }
                        ++k;
                    }
                    k = mn / 4 + 1;
                    while (k < (mx + 3) / 4) {
                        if (localSubGrid[j2][4 * k] == -1) {
                            int size = newVertexTexVector.size();
                            MeshInfo mi = new MeshInfo(i, quantization * (min[0] + j2 / 4), quantization * (min[1] + k), -1, -1, -1, -1);
                            newVertexTexVector.addElement(new MeshInfo[]{mi});
                            assignmentVector.addElement(new int[]{i, size});
                            localSubGrid[j2][4 * k] = size;
                        }
                        ++k;
                    }
                    j2 += 4;
                }
                j2 = 0;
                while (j2 < max[0]) {
                    last = -1;
                    current = -1;
                    k = 0;
                    while (k < max[1]) {
                        if (localSubGrid[j2][k] != -1) {
                            current = localSubGrid[j2][k];
                            if (last != -1) {
                                MeshInfo[] mi = (MeshInfo[])newVertexTexVector.elementAt(current);
                                int numAdjacentElements = mi.length;
                                m = 0;
                                while (m < numAdjacentElements) {
                                    if (mi[m].m_element == i) {
                                        mi[m].m_neighbour[2] = last;
                                    }
                                    ++m;
                                }
                                mi = (MeshInfo[])newVertexTexVector.elementAt(last);
                                numAdjacentElements = mi.length;
                                m = 0;
                                while (m < numAdjacentElements) {
                                    if (mi[m].m_element == i) {
                                        mi[m].m_neighbour[0] = current;
                                    }
                                    ++m;
                                }
                            }
                            last = current;
                        }
                        ++k;
                    }
                    j2 += 4;
                }
                j2 = 0;
                while (j2 < max[1]) {
                    last = -1;
                    k = 0;
                    while (k < max[0]) {
                        if (localSubGrid[k][j2] != -1) {
                            current = localSubGrid[k][j2];
                            if (last != -1) {
                                MeshInfo[] mi = (MeshInfo[])newVertexTexVector.elementAt(current);
                                int numAdjacentElements = mi.length;
                                m = 0;
                                while (m < numAdjacentElements) {
                                    if (mi[m].m_element == i) {
                                        if (texOrient[i] == -1) {
                                            mi[m].m_neighbour[3] = last;
                                        } else {
                                            mi[m].m_neighbour[1] = last;
                                        }
                                    }
                                    ++m;
                                }
                                mi = (MeshInfo[])newVertexTexVector.elementAt(last);
                                numAdjacentElements = mi.length;
                                m = 0;
                                while (m < numAdjacentElements) {
                                    if (mi[m].m_element == i) {
                                        if (texOrient[i] == -1) {
                                            mi[m].m_neighbour[1] = current;
                                        } else {
                                            mi[m].m_neighbour[3] = current;
                                        }
                                    }
                                    ++m;
                                }
                            }
                            last = current;
                        }
                        ++k;
                    }
                    j2 += 4;
                }
                j2 = 0;
                while (j2 < numVerticesOnBnd) {
                    if (localSubGrid[(vertexTexCoord[j2][0] - quantization * min[0]) * 4 / quantization][(vertexTexCoord[j2][1] - quantization * min[1]) * 4 / quantization] != vertexInElement[i][j2]) {
                        int tInd0 = localSubGrid[(vertexTexCoord[j2][0] - quantization * min[0]) * 4 / quantization][(vertexTexCoord[j2][1] - quantization * min[1]) * 4 / quantization];
                        int tInd1 = vertexInElement[i][j2];
                        MeshInfo[] mi0 = (MeshInfo[])newVertexTexVector.elementAt(tInd0);
                        MeshInfo[] mi1 = (MeshInfo[])newVertexTexVector.elementAt(tInd1);
                        edgeCollapseVector.addElement(new PiVector(tInd0, tInd1));
                        int numAdjacentElements0 = mi0.length;
                        int numAdjacentElements1 = mi1.length;
                        int k4 = 0;
                        block22: while (k4 < numAdjacentElements0) {
                            if (mi0[k4].m_element == i) {
                                int m3 = 0;
                                while (m3 < numAdjacentElements1) {
                                    if (mi1[m3].m_element == i) {
                                        int n = 0;
                                        while (n < 4) {
                                            int q;
                                            int p;
                                            int ne;
                                            MeshInfo[] mi2;
                                            if (mi1[m3].m_neighbour[n] != -1) {
                                                mi2 = (MeshInfo[])newVertexTexVector.elementAt(mi1[m3].m_neighbour[n]);
                                                ne = mi2.length;
                                                p = 0;
                                                while (p < ne) {
                                                    if (mi2[p].m_element == i) {
                                                        q = 0;
                                                        while (q < 4) {
                                                            if (mi2[p].m_neighbour[q] == tInd1) {
                                                                mi2[p].m_neighbour[q] = -1;
                                                            }
                                                            ++q;
                                                        }
                                                    }
                                                    ++p;
                                                }
                                                mi1[m3].m_neighbour[n] = -1;
                                            }
                                            if (mi0[k4].m_neighbour[n] != -1) {
                                                mi2 = (MeshInfo[])newVertexTexVector.elementAt(mi0[k4].m_neighbour[n]);
                                                ne = mi2.length;
                                                p = 0;
                                                while (p < ne) {
                                                    if (mi2[p].m_element == i) {
                                                        q = 0;
                                                        while (q < 4) {
                                                            if (mi2[p].m_neighbour[q] == tInd0) {
                                                                mi2[p].m_neighbour[q] = -1;
                                                            }
                                                            ++q;
                                                        }
                                                    }
                                                    ++p;
                                                }
                                                mi0[k4].m_neighbour[n] = -1;
                                            }
                                            ++n;
                                        }
                                        mi0[k4].m_neighbour[3] = tInd1;
                                        mi1[m3].m_neighbour[1] = tInd0;
                                        break block22;
                                    }
                                    ++m3;
                                }
                                break;
                            }
                            ++k4;
                        }
                    }
                    ++j2;
                }
            }
            ++i;
        }
    }

    private static void getElements(PgElementSet quadGeom, int[][] neighbourVertex, int numNew) {
        int start;
        Vector<PiVector> elements = new Vector<PiVector>();
        boolean[][] bFilled = new boolean[numNew][];
        int i = 0;
        while (i < numNew) {
            bFilled[i] = new boolean[neighbourVertex[i].length];
            int j = 0;
            while (j < neighbourVertex[i].length) {
                bFilled[i][j] = false;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < numNew) {
            if (quadGeom.hasTagVertex(i, 14)) {
                int size = 1;
                int[] nv = neighbourVertex[i];
                start = i;
                int end = nv[nv.length - 1];
                boolean bContinue = true;
                while (bContinue) {
                    int locInd = -1;
                    nv = neighbourVertex[end];
                    int j = 0;
                    while (j < nv.length) {
                        if (nv[j] == start) {
                            locInd = j;
                            break;
                        }
                        ++j;
                    }
                    if (locInd == -1) {
                        PsDebug.message((String)"There is an error in the connectivity.");
                        size = -1;
                        break;
                    }
                    if (bFilled[end][locInd]) {
                        PsDebug.message((String)"There is an error in the connectivity.");
                        size = -1;
                        break;
                    }
                    bFilled[end][locInd] = true;
                    if (locInd == 0 && quadGeom.hasTagVertex(end, 14)) {
                        bContinue = false;
                    } else {
                        start = end;
                        end = nv[(locInd + nv.length - 1) % nv.length];
                    }
                    ++size;
                }
                if (size > 2) {
                    PiVector newElement = new PiVector(size);
                    newElement.setEntry(0, i);
                    size = 1;
                    nv = neighbourVertex[i];
                    start = i;
                    end = nv[nv.length - 1];
                    bContinue = true;
                    while (bContinue) {
                        newElement.setEntry(size, end);
                        int locInd = -1;
                        nv = neighbourVertex[end];
                        int j = 0;
                        while (j < nv.length) {
                            if (nv[j] == start) {
                                locInd = j;
                                break;
                            }
                            ++j;
                        }
                        if (locInd == 0 && quadGeom.hasTagVertex(end, 14)) {
                            bContinue = false;
                        } else {
                            start = end;
                            end = nv[(locInd + nv.length - 1) % nv.length];
                        }
                        ++size;
                    }
                    elements.addElement(newElement);
                }
            }
            ++i;
        }
        i = 0;
        while (i < numNew) {
            int[] nv = neighbourVertex[i];
            int j = 0;
            while (j < nv.length) {
                if (!bFilled[i][j]) {
                    start = i;
                    int[] nv2 = nv;
                    int size = 1;
                    int locInd = j;
                    int end = nv2[(locInd + nv2.length - 1) % nv2.length];
                    while (end != i) {
                        nv2 = neighbourVertex[end];
                        int k = 0;
                        while (k < nv2.length) {
                            if (nv2[k] == start) {
                                locInd = k;
                                break;
                            }
                            ++k;
                        }
                        if (bFilled[end][locInd]) {
                            PsDebug.message((String)"There is an error in the connectivity.");
                            size = -1;
                            break;
                        }
                        bFilled[end][locInd] = true;
                        start = end;
                        end = nv2[(locInd + nv2.length - 1) % nv2.length];
                        ++size;
                    }
                    if (size > 2) {
                        start = i;
                        nv2 = nv;
                        PiVector newElement = new PiVector(size);
                        newElement.m_data[0] = start;
                        size = 1;
                        locInd = j;
                        end = nv2[(locInd + nv2.length - 1) % nv2.length];
                        while (end != i) {
                            newElement.m_data[size] = end;
                            nv2 = neighbourVertex[end];
                            int k = 0;
                            while (k < nv2.length) {
                                if (nv2[k] == start) {
                                    locInd = k;
                                    break;
                                }
                                ++k;
                            }
                            start = end;
                            end = nv2[(locInd + nv2.length - 1) % nv2.length];
                            ++size;
                        }
                        elements.addElement(newElement);
                    }
                }
                ++j;
            }
            ++i;
        }
        PiVector[] elemArray = new PiVector[elements.size()];
        int i2 = 0;
        while (i2 < elemArray.length) {
            elemArray[i2] = (PiVector)elements.elementAt(i2);
            ++i2;
        }
        quadGeom.setNumElements(elemArray.length);
        quadGeom.setElements(elemArray);
        i2 = 0;
        while (i2 < numNew) {
            quadGeom.hasTagVertex(i2, 14);
            ++i2;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void removeEdgeVertices(PgElementSet quadGeom, int numNew, Vector edgeCollapseVector) {
        bChanged = true;
        numNeighVertices = new PiVector(numNew);
        i = 0;
        while (i < numNew) {
            numNeighVertices.m_data[i] = quadGeom.hasTagVertex(i, 14) != false ? 1 : 0;
            ++i;
        }
        numTriangles = quadGeom.getNumElements();
        i = 0;
        while (i < numTriangles) {
            element = quadGeom.getElement(i);
            elSize = element.getSize();
            j = 0;
            while (j < elSize) {
                v0 = element.m_data[j];
                numNeighVertices.m_data[v0] = numNeighVertices.m_data[v0] + 1;
                ++j;
            }
            ++i;
        }
        numEdgeCollapses = edgeCollapseVector.size();
        ec = new PiVector(numNew);
        i = 0;
        while (i < numNew) {
            ec.m_data[i] = i;
            ++i;
        }
        i = 0;
        while (i < numEdgeCollapses) {
            edge = (PiVector)edgeCollapseVector.elementAt(i);
            ind0 = 0;
            if (edge.m_data[0] > edge.m_data[1]) {
                ind0 = 1;
            }
            if (ec.m_data[edge.m_data[(ind0 + 1) % 2]] != edge.m_data[ind0]) {
                if (ec.m_data[edge.m_data[(ind0 + 1) % 2]] == edge.m_data[(ind0 + 1) % 2]) {
                    ec.m_data[edge.m_data[(ind0 + 1) % 2]] = edge.m_data[ind0];
                } else {
                    vertexIndex0 = ec.m_data[edge.m_data[(ind0 + 1) % 2]];
                    vertexIndex1 = edge.m_data[ind0];
                    vertexIndex2 = edge.m_data[(ind0 + 1) % 2];
                    do {
                        if (vertexIndex0 < vertexIndex1) {
                            ec.m_data[vertexIndex2] = vertexIndex1;
                            vertexIndex2 = vertexIndex1;
                            if (vertexIndex1 == ec.m_data[vertexIndex1]) {
                                ec.m_data[vertexIndex1] = vertexIndex0;
                                vertexIndex1 = vertexIndex0;
                                continue;
                            }
                            vertexIndex1 = ec.m_data[vertexIndex1];
                            continue;
                        }
                        if (vertexIndex0 > vertexIndex1) {
                            ec.m_data[vertexIndex2] = vertexIndex0;
                            vertexIndex2 = vertexIndex0;
                            if (vertexIndex0 == ec.m_data[vertexIndex0]) {
                                ec.m_data[vertexIndex0] = vertexIndex1;
                                vertexIndex0 = vertexIndex1;
                                continue;
                            }
                            vertexIndex0 = ec.m_data[vertexIndex0];
                            continue;
                        }
                        ec.m_data[vertexIndex2] = vertexIndex0;
                    } while (vertexIndex0 != vertexIndex1);
                }
            }
            ++i;
        }
        i = 0;
        ** GOTO lbl70
        {
            ec.m_data[i] = ec.m_data[ec.m_data[i]];
            do {
                if (ec.m_data[i] != ec.m_data[ec.m_data[i]]) continue block6;
                ++i;
lbl70:
                // 2 sources

            } while (i < numNew);
        }
        i = 0;
        while (i < numNew) {
            if (ec.m_data[i] != i) {
                v1 = ec.m_data[i];
                numNeighVertices.m_data[v1] = numNeighVertices.m_data[v1] + numNeighVertices.m_data[i];
                v2 = ec.m_data[i];
                numNeighVertices.m_data[v2] = numNeighVertices.m_data[v2] - 2;
                numNeighVertices.m_data[i] = 0;
            }
            ++i;
        }
        i = 0;
        while (i < numTriangles) {
            element = quadGeom.getElement(i);
            elSize = element.getSize();
            j = 0;
            while (j < elSize) {
                element.m_data[j] = ec.m_data[element.m_data[j]];
                ++j;
            }
            elSize = element.getSize();
            newSize = 1;
            j = 1;
            while (j < elSize) {
                if (element.m_data[j] != element.m_data[newSize - 1]) {
                    element.m_data[newSize] = element.m_data[j];
                    ++newSize;
                }
                ++j;
            }
            while (element.m_data[newSize - 1] == element.m_data[0] && newSize > 1) {
                --newSize;
            }
            element.setSize(newSize);
            elSize = element.getSize();
            if (elSize == 1) {
                v3 = element.m_data[0];
                numNeighVertices.m_data[v3] = numNeighVertices.m_data[v3] - 2;
                quadGeom.setTagElement(i, 2);
            } else if (elSize == 2) {
                j = 0;
                while (j < 2) {
                    v4 = element.m_data[j];
                    numNeighVertices.m_data[v4] = numNeighVertices.m_data[v4] - 1;
                    ++j;
                }
                quadGeom.setTagElement(i, 2);
            }
            ++i;
        }
        while (bChanged) {
            bChanged = false;
            i = 0;
            while (i < numNew) {
                if (!quadGeom.hasTagVertex(i, 1) && numNeighVertices.m_data[i] < 3) {
                    quadGeom.setTagVertex(i, 2);
                }
                ++i;
            }
            newNoe = quadGeom.getNumElements();
            i = 0;
            while (i < newNoe) {
                if (!quadGeom.hasTagElement(i, 2)) {
                    element = quadGeom.getElement(i);
                    size = element.getSize();
                    newSize = 0;
                    j = 0;
                    while (j < size) {
                        if (!quadGeom.hasTagVertex(element.m_data[j], 2)) {
                            if (newSize > 0 && (element.m_data[j] == element.m_data[newSize - 1] || j == size - 1 && element.m_data[j] == element.m_data[0])) {
                                v5 = element.m_data[j];
                                numNeighVertices.m_data[v5] = numNeighVertices.m_data[v5] - 1;
                                if (numNeighVertices.m_data[element.m_data[j]] < 3) {
                                    bChanged = true;
                                }
                            } else {
                                element.m_data[newSize] = element.m_data[j];
                                ++newSize;
                            }
                        }
                        ++j;
                    }
                    element.setSize(newSize);
                    if (newSize < 3) {
                        quadGeom.setTagElement(i, 2);
                        j = 0;
                        while (j < newSize) {
                            v6 = element.m_data[j];
                            numNeighVertices.m_data[v6] = numNeighVertices.m_data[v6] - 1;
                            if (numNeighVertices.m_data[element.m_data[j]] < 3) {
                                bChanged = true;
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        i = 0;
        while (i < numNew) {
            quadGeom.clearTagVertex(i, 1);
            ++i;
        }
        quadGeom.removeMarkedElements();
        quadGeom.removeMarkedVertices();
        quadGeom.removeUnusedVertices();
    }

    public static void addParameterVectorFields(PgElementSet geom) {
        if (geom == null) {
            return;
        }
        int noe = geom.getNumElements();
        PgVectorField[] vf = new PgVectorField[2];
        int i = 0;
        while (i < 2) {
            vf[i] = new PgVectorField(geom.getDimOfVertices(), 1);
            vf[i].setGeometry((PgPointSet)geom);
            vf[i].setNumVectors(noe);
            ++i;
        }
        int run = 0;
        while (run < 2) {
            int i2 = 0;
            while (i2 < noe) {
                int j;
                PiVector element = geom.getElement(i2);
                PdVector[] dir = new PdVector[2];
                if (run == 0 && element.getSize() == 4) {
                    dir[0] = PdVector.blendNew((double)0.5, (PdVector)geom.getVertex(element.m_data[1]), (double)0.5, (PdVector)geom.getVertex(element.m_data[2]));
                    dir[0].blendBase(dir[0], -0.5, geom.getVertex(element.m_data[0]));
                    dir[0].blendBase(dir[0], -0.5, geom.getVertex(element.m_data[3]));
                    dir[1] = PdVector.blendNew((double)0.5, (PdVector)geom.getVertex(element.m_data[2]), (double)0.5, (PdVector)geom.getVertex(element.m_data[3]));
                    dir[1].blendBase(dir[1], -0.5, geom.getVertex(element.m_data[0]));
                    dir[1].blendBase(dir[1], -0.5, geom.getVertex(element.m_data[1]));
                    j = 0;
                    while (j < 2) {
                        vf[j].setVector(i2, dir[j]);
                        ++j;
                    }
                }
                if (run == 1 && element.getSize() != 4) {
                    dir[0] = new PdVector(3);
                    dir[1] = new PdVector(3);
                    int k = 0;
                    while (k < element.getSize()) {
                        int neigh = geom.getNeighbour(i2).getEntry(k);
                        if (neigh >= 0) {
                            dir[0].add(vf[0].getVector(neigh));
                            dir[1].add(vf[1].getVector(neigh));
                            if (dir[0].length() > 1.0E-10) break;
                        }
                        ++k;
                    }
                    j = 0;
                    while (j < 2) {
                        vf[j].setVector(i2, dir[j]);
                        ++j;
                    }
                }
                ++i2;
            }
            ++run;
        }
        int i3 = 0;
        while (i3 < 2) {
            int j = 0;
            while (j < vf[i3].getNumVectors()) {
                PdVector temp = new PdVector(3);
                PuVectorGeom.rotatePointAroundVector((PdVector)temp, (PdVector)vf[i3].getVector(j), (PdVector)geom.getElementNormal(j), (double)1.5707963267948966);
                vf[i3].setVector(j, temp);
                vf[i3].getVector(j).normalize();
                ++j;
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < 2) {
            geom.addVectorField(vf[i3]);
            ++i3;
        }
    }

    public static void triangulateAndAddParameterVectorFields(PgElementSet geom) {
        if (geom == null) {
            return;
        }
        if (geom.getDimOfElements() != 4) {
            geom.assureDimOfElements();
            if (geom.getDimOfElements() != 4) {
                PsDebug.warning((String)"geometry is not quadrangulated.");
                return;
            }
        }
        int noe = geom.getNumElements();
        geom.setNumElements(2 * noe);
        PgVectorField[] vf = new PgVectorField[2];
        int i = 0;
        while (i < 2) {
            vf[i] = new PgVectorField(geom.getDimOfVertices(), 1);
            vf[i].setGeometry((PgPointSet)geom);
            vf[i].setNumVectors(2 * noe);
            ++i;
        }
        geom.setDimOfElements(-1);
        int i2 = 0;
        while (i2 < noe) {
            PiVector element = geom.getElement(i2);
            PdVector[] dir = new PdVector[4];
            dir[0] = PdVector.subNew((PdVector)geom.getVertex(element.m_data[1]), (PdVector)geom.getVertex(element.m_data[0]));
            dir[1] = PdVector.subNew((PdVector)geom.getVertex(element.m_data[2]), (PdVector)geom.getVertex(element.m_data[1]));
            int j = 0;
            while (j < 2) {
                vf[j].setVector(i2, dir[j]);
                ++j;
            }
            geom.setElement(noe + i2, element.m_data[2], element.m_data[3], element.m_data[0]);
            dir[2] = PdVector.subNew((PdVector)geom.getVertex(element.m_data[2]), (PdVector)geom.getVertex(element.m_data[3]));
            dir[3] = PdVector.subNew((PdVector)geom.getVertex(element.m_data[3]), (PdVector)geom.getVertex(element.m_data[0]));
            j = 0;
            while (j < 2) {
                vf[j].setVector(noe + i2, dir[2 + j]);
                ++j;
            }
            geom.setElement(i2, element.m_data[0], element.m_data[1], element.m_data[2]);
            ++i2;
        }
        geom.setDimOfElements(3);
        geom.makeNeighbour();
        i2 = 0;
        while (i2 < 2) {
            int j = 0;
            while (j < vf[i2].getNumVectors()) {
                PdVector temp = new PdVector(3);
                PuVectorGeom.rotatePointAroundVector((PdVector)temp, (PdVector)vf[i2].getVector(j), (PdVector)geom.getElementNormal(j), (double)1.5707963267948966);
                vf[i2].setVector(j, temp);
                vf[i2].getVector(j).normalize();
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < 2) {
            geom.addVectorField(vf[i2]);
            ++i2;
        }
    }

    public static void addParameterVectorFieldsTriang(PgElementSet geom) {
        if (geom == null) {
            return;
        }
        if (geom.getDimOfElements() != 3) {
            geom.assureDimOfElements();
            if (geom.getDimOfElements() != 3) {
                PsDebug.warning((String)"geometry is not quadrangulated.");
                return;
            }
        }
        int noe = geom.getNumElements();
        PgVectorField[] vf = new PgVectorField[2];
        int i = 0;
        while (i < 2) {
            vf[i] = new PgVectorField(geom.getDimOfVertices(), 1);
            vf[i].setGeometry((PgPointSet)geom);
            vf[i].setNumVectors(noe);
            ++i;
        }
        int i2 = 0;
        while (i2 < noe) {
            PiVector element = geom.getElement(i2);
            PdVector[] dir = new PdVector[]{PdVector.subNew((PdVector)geom.getVertex(element.m_data[1]), (PdVector)geom.getVertex(element.m_data[0])), PdVector.subNew((PdVector)geom.getVertex(element.m_data[2]), (PdVector)geom.getVertex(element.m_data[0]))};
            int j = 0;
            while (j < 2) {
                vf[j].setVector(i2, dir[j]);
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < 2) {
            geom.addVectorField(vf[i2]);
            ++i2;
        }
    }
}

