/*
 * Decompiled with CFR 0.152.
 */
package dev.geom;

import dev.util.kdtree.PuKdTree;
import java.io.PrintWriter;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.number.PuInteger;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.object.PsUtil;
import jv.project.PgGeometry;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.project.PjWorkshop;
import jvx.util.PuAVLTree;
import jvx.util.PuBinaryTreeNode;
import jvx.util.PuComparePdVectorsLexi;
import jvx.util.PuCompare_If;

public class PwSortXY
extends PjWorkshop {
    public boolean m_bLogQuality = true;
    public boolean m_bLogNum = true;
    public static final int INIT_ROW_BY_ROW = 0;
    public static final int INIT_COL_BY_COL = 1;
    public static final int INIT_RANDOM = 2;
    protected int m_initMode = 0;
    public static final int SORT_BY_X_TO_COLUMNS = 0;
    public static final int SORT_BY_Y_TO_ROWS = 1;
    public static final int SORT_ROWS_BY_X = 2;
    public static final int SORT_COLUMNS_BY_Y = 3;
    public static final int SWAP_NEIGHBOUR = 4;
    public static final int SWAP_NEIGHBOUR_UNTIL_STABLE = 5;
    public static final int SORT_ROWS_AND_COLUMNS_UNTIL_STABLE = 6;
    public static final int SORT_COLUMNS_AND_ROWS_UNTIL_STABLE = 7;
    public static final int SWAP_BEST_PAIR = 8;
    public static final int SWAP_BEST_PAIR_UNTIL_STABLE = 9;
    protected int m_sortMode = 2;
    protected double m_sum_jx = 0.0;
    protected double m_sum_iy = 0.0;
    protected double m_sum_jx_iy = 0.0;
    PgElementSet m_elementSet;
    protected int m_rootNov = 1;
    protected int[][] m_vertexIndex;
    private PdVector[] m_sortXVector;
    private PdVector[] m_sortYVector;
    PuComparePdVectorsLexi m_comparator = new PuComparePdVectorsLexi();
    public static final int MODE_X_EVEN = 0;
    public static final int MODE_Y_EVEN = 1;
    public static final int MODE_X_ODD = 2;
    public static final int MODE_Y_ODD = 3;
    public PuInteger m_iLinearSize;
    public PiVector[] m_nearest;

    public PwSortXY() {
        super("X-Y-Sorting");
        this.m_vertexIndex = new int[1][1];
        this.m_iLinearSize = new PuInteger("Linear Size", (PsUpdateIf)this);
        this.m_iLinearSize.setDefBounds(12, 128, 1, 16);
        this.m_iLinearSize.setDefValue(42);
        this.m_iLinearSize.init();
    }

    public void setGeometry(PgGeometry geom) {
        super.setGeometry(geom);
        this.m_elementSet = (PgElementSet)geom;
        this.m_elementSet.setDimOfVertices(2);
    }

    public boolean update(Object event) {
        if (event == this.m_iLinearSize) {
            return true;
        }
        return super.update(event);
    }

    public void assureSquareNumber() {
        PdVector vertex;
        int nov = this.m_elementSet.getNumVertices();
        if (nov == this.m_rootNov * this.m_rootNov) {
            return;
        }
        this.m_rootNov = 1;
        while (this.m_rootNov * this.m_rootNov < nov) {
            ++this.m_rootNov;
        }
        this.m_vertexIndex = new int[this.m_rootNov][this.m_rootNov];
        this.initByIndexRowByRow();
        PdVector[] bnd = this.m_elementSet.getBounds();
        int numNew = this.m_rootNov * this.m_rootNov - nov;
        if (numNew == 0) {
            return;
        }
        nov = this.m_rootNov * this.m_rootNov;
        this.m_elementSet.setNumVertices(nov);
        double dx = (bnd[1].m_data[0] - bnd[0].m_data[0]) / (double)(this.m_rootNov - 1);
        double dy = (bnd[1].m_data[1] - bnd[0].m_data[1]) / (double)(this.m_rootNov - 1);
        int i = 0;
        while (i < (numNew + 1) / 2) {
            vertex = new PdVector(this.m_elementSet.getDimOfVertices());
            vertex.m_data[1] = bnd[1].m_data[1];
            vertex.m_data[0] = bnd[1].m_data[0] - (double)i * dx;
            this.m_elementSet.setVertex(nov - numNew + i, vertex);
            ++i;
        }
        numNew -= (numNew + 1) / 2;
        i = 0;
        while (i < numNew) {
            vertex = new PdVector(this.m_elementSet.getDimOfVertices());
            vertex.m_data[1] = bnd[1].m_data[1] - (double)(i + 1) * dy;
            vertex.m_data[0] = bnd[1].m_data[0];
            this.m_elementSet.setVertex(nov - numNew + i, vertex);
            ++i;
        }
    }

    public void setQuads() {
        this.m_elementSet.setDimOfElements(4);
        this.m_elementSet.setNumElements((this.m_rootNov - 1) * (this.m_rootNov - 1));
        int i = 0;
        while (i < this.m_rootNov - 1) {
            int j = 0;
            while (j < this.m_rootNov - 1) {
                this.m_elementSet.setElement(i + j * (this.m_rootNov - 1), this.m_vertexIndex[i][j], this.m_vertexIndex[i + 1][j], this.m_vertexIndex[i + 1][j + 1], this.m_vertexIndex[i][j + 1]);
                ++j;
            }
            ++i;
        }
        this.m_elementSet.makeNeighbour();
    }

    public void initByIndexRowByRow() {
        int i = 0;
        while (i < this.m_rootNov) {
            int j = 0;
            while (j < this.m_rootNov) {
                this.m_vertexIndex[j][i] = j * this.m_rootNov + i;
                ++j;
            }
            ++i;
        }
    }

    public void initByIndexColByCol() {
        int i = 0;
        while (i < this.m_rootNov) {
            int j = 0;
            while (j < this.m_rootNov) {
                this.m_vertexIndex[i][j] = j * this.m_rootNov + i;
                ++j;
            }
            ++i;
        }
    }

    public void initByRandom() {
        int sqr = this.m_rootNov * this.m_rootNov;
        int[] permutation = new int[sqr];
        boolean[] used = new boolean[sqr];
        int i = 0;
        while (i < sqr) {
            int idx = (int)(Math.random() * (double)(sqr - i));
            while (idx != 0 || used[permutation[i]]) {
                if (!used[permutation[i]]) {
                    --idx;
                }
                int n = i;
                permutation[n] = permutation[n] + 1;
            }
            used[permutation[i]] = true;
            ++i;
        }
        int j = 0;
        while (j < this.m_rootNov) {
            int i2 = 0;
            while (i2 < this.m_rootNov) {
                this.m_vertexIndex[i2][j] = permutation[j * this.m_rootNov + i2];
                ++i2;
            }
            ++j;
        }
    }

    public void initializeMatrix() {
        this.assureSquareNumber();
        if (this.m_initMode == 0) {
            this.initByIndexRowByRow();
        } else if (this.m_initMode == 1) {
            this.initByIndexColByCol();
        } else if (this.m_initMode == 2) {
            this.initByRandom();
        }
    }

    public void initializeSortVectors() {
        int sqr = this.m_rootNov * this.m_rootNov;
        this.m_sortXVector = new PdVector[sqr];
        this.m_sortYVector = new PdVector[sqr];
        int i = 0;
        while (i < sqr) {
            PdVector vertex = this.m_elementSet.getVertex(i);
            this.m_sortXVector[i] = new PdVector(vertex.m_data[0], vertex.m_data[1], (double)i);
            this.m_sortYVector[i] = new PdVector(vertex.m_data[1], vertex.m_data[0], (double)i);
            ++i;
        }
    }

    public void computeQuality() {
        this.m_sum_jx = 0.0;
        this.m_sum_iy = 0.0;
        int i = 0;
        while (i < this.m_rootNov) {
            int j = 0;
            while (j < this.m_rootNov) {
                PdVector vertex = this.m_elementSet.getVertex(this.m_vertexIndex[i][j]);
                this.m_sum_jx += (double)j * vertex.m_data[0];
                this.m_sum_iy += (double)i * vertex.m_data[1];
                ++j;
            }
            ++i;
        }
        this.m_sum_jx_iy = this.m_sum_jx + this.m_sum_iy;
    }

    public boolean isStable() {
        int j;
        if (this.m_sortXVector == null || this.m_sortYVector == null || this.m_sortXVector.length < this.m_rootNov * this.m_rootNov || this.m_sortYVector.length < this.m_rootNov * this.m_rootNov) {
            this.initializeSortVectors();
        }
        int i = 0;
        while (i < this.m_rootNov) {
            j = 0;
            while (j < this.m_rootNov - 1) {
                if (this.m_comparator.compare((Object)this.m_sortXVector[this.m_vertexIndex[i][j]], (Object)this.m_sortXVector[this.m_vertexIndex[i][j + 1]]) > 0) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.m_rootNov) {
            j = 0;
            while (j < this.m_rootNov - 1) {
                if (this.m_comparator.compare((Object)this.m_sortYVector[this.m_vertexIndex[j][i]], (Object)this.m_sortYVector[this.m_vertexIndex[j + 1][i]]) > 0) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public void sort() {
        this.assureSquareNumber();
        this.initializeSortVectors();
        if (this.m_sortMode == 0) {
            this.sortXToColumns();
        } else if (this.m_sortMode == 1) {
            this.sortYToRows();
        } else if (this.m_sortMode == 2) {
            this.sortRowsByX();
        } else if (this.m_sortMode == 3) {
            this.sortColumnsByY();
        } else if (this.m_sortMode == 4) {
            this.swapMaxNeighbours();
        } else if (this.m_sortMode == 5) {
            this.swapNeighboursUntilStable();
        } else if (this.m_sortMode == 8) {
            this.swapMaxPair();
        } else if (this.m_sortMode == 9) {
            this.swapMaxUntilStable();
        } else if (this.m_sortMode == 6) {
            this.sort_x_y_untilStable();
        } else if (this.m_sortMode == 7) {
            this.sort_y_x_untilStable();
        }
        this.setQuads();
    }

    public void sortXToColumns() {
        PuAVLTree tree = new PuAVLTree((PuCompare_If)this.m_comparator);
        int sqr = this.m_rootNov * this.m_rootNov;
        int i = 0;
        while (i < sqr) {
            tree.insert((Object)this.m_sortXVector[i]);
            ++i;
        }
        PuBinaryTreeNode[] list = tree.getSortedList();
        int i2 = 0;
        while (i2 < this.m_rootNov) {
            int j = 0;
            while (j < this.m_rootNov) {
                PdVector v = (PdVector)list[i2 * this.m_rootNov + j].getValue();
                this.m_vertexIndex[j][i2] = (int)v.m_data[2];
                ++j;
            }
            ++i2;
        }
    }

    public void sortYToRows() {
        PuAVLTree tree = new PuAVLTree((PuCompare_If)this.m_comparator);
        int sqr = this.m_rootNov * this.m_rootNov;
        int i = 0;
        while (i < sqr) {
            tree.insert((Object)this.m_sortYVector[i]);
            ++i;
        }
        PuBinaryTreeNode[] list = tree.getSortedList();
        int i2 = 0;
        while (i2 < this.m_rootNov) {
            int j = 0;
            while (j < this.m_rootNov) {
                PdVector v = (PdVector)list[i2 * this.m_rootNov + j].getValue();
                this.m_vertexIndex[i2][j] = (int)v.m_data[2];
                ++j;
            }
            ++i2;
        }
    }

    public void sortRowsByX() {
        int i = 0;
        while (i < this.m_rootNov) {
            PuAVLTree tree = new PuAVLTree((PuCompare_If)this.m_comparator);
            int j = 0;
            while (j < this.m_rootNov) {
                tree.insert((Object)this.m_sortXVector[this.m_vertexIndex[i][j]]);
                ++j;
            }
            PuBinaryTreeNode[] list = tree.getSortedList();
            int j2 = 0;
            while (j2 < this.m_rootNov) {
                PdVector v = (PdVector)list[j2].getValue();
                this.m_vertexIndex[i][j2] = (int)v.m_data[2];
                ++j2;
            }
            ++i;
        }
    }

    public void sortColumnsByY() {
        int i = 0;
        while (i < this.m_rootNov) {
            PuAVLTree tree = new PuAVLTree((PuCompare_If)this.m_comparator);
            int j = 0;
            while (j < this.m_rootNov) {
                tree.insert((Object)this.m_sortYVector[this.m_vertexIndex[j][i]]);
                ++j;
            }
            PuBinaryTreeNode[] list = tree.getSortedList();
            int j2 = 0;
            while (j2 < this.m_rootNov) {
                PdVector v = (PdVector)list[j2].getValue();
                this.m_vertexIndex[j2][i] = (int)v.m_data[2];
                ++j2;
            }
            ++i;
        }
    }

    public void swapMaxNeighbours() {
        double max = -1.0;
        double current = -1.0;
        int i1 = -1;
        int i2 = -1;
        int j1 = -1;
        int j2 = -1;
        int i = 0;
        while (i < this.m_rootNov) {
            int j = 0;
            while (j < this.m_rootNov - 1) {
                if (this.m_comparator.compare((Object)this.m_sortXVector[this.m_vertexIndex[i][j]], (Object)this.m_sortXVector[this.m_vertexIndex[i][j + 1]]) > 0 && (current = this.m_sortXVector[this.m_vertexIndex[i][j]].m_data[0] - this.m_sortXVector[this.m_vertexIndex[i][j + 1]].m_data[0]) > max) {
                    max = current;
                    i1 = i;
                    i2 = i;
                    j1 = j;
                    j2 = j + 1;
                }
                if (this.m_comparator.compare((Object)this.m_sortYVector[this.m_vertexIndex[j][i]], (Object)this.m_sortYVector[this.m_vertexIndex[j + 1][i]]) > 0 && (current = this.m_sortYVector[this.m_vertexIndex[j][i]].m_data[0] - this.m_sortYVector[this.m_vertexIndex[j + 1][i]].m_data[0]) > max) {
                    max = current;
                    i1 = j;
                    i2 = j + 1;
                    j1 = i;
                    j2 = i;
                }
                ++j;
            }
            ++i;
        }
        if (max < 0.0) {
            return;
        }
        int tmp = this.m_vertexIndex[i1][j1];
        this.m_vertexIndex[i1][j1] = this.m_vertexIndex[i2][j2];
        this.m_vertexIndex[i2][j2] = tmp;
    }

    public void swapMaxPair() {
        double max = -1.0;
        double maxIdx = -1.0;
        double current = -1.0;
        int i1 = -1;
        int i2 = -1;
        int j1 = -1;
        int j2 = -1;
        int i = 0;
        while (i < this.m_rootNov) {
            int j = 0;
            while (j < this.m_rootNov) {
                int m = 0;
                while (m < this.m_rootNov) {
                    int n = 0;
                    while (n < this.m_rootNov) {
                        if (!(i == m && j == n || i > m || i == m && j > n)) {
                            boolean better = false;
                            current = (double)(m - i) * (this.m_sortXVector[this.m_vertexIndex[i][j]].m_data[1] - this.m_sortXVector[this.m_vertexIndex[m][n]].m_data[1]) + (double)(n - j) * (this.m_sortXVector[this.m_vertexIndex[i][j]].m_data[0] - this.m_sortXVector[this.m_vertexIndex[m][n]].m_data[0]);
                            if (!(current < 0.0) && !(current < max)) {
                                max = current;
                                if (max > 0.0) {
                                    better = true;
                                } else {
                                    if (i == m && ((current = (double)(n - j) * (this.m_sortXVector[this.m_vertexIndex[i][j]].m_data[1] - this.m_sortXVector[this.m_vertexIndex[m][n]].m_data[1])) > 0.0 || current == 0.0 && (double)(n - j) * (this.m_sortXVector[this.m_vertexIndex[i][j]].m_data[2] - this.m_sortXVector[this.m_vertexIndex[m][n]].m_data[2]) > 0.0) && (double)Math.abs(n - j) > maxIdx) {
                                        better = true;
                                        maxIdx = Math.abs(n - j);
                                    }
                                    if (j == n && ((current = (double)(m - i) * (this.m_sortXVector[this.m_vertexIndex[i][j]].m_data[0] - this.m_sortXVector[this.m_vertexIndex[m][n]].m_data[0])) > 0.0 || current == 0.0 && (double)(m - i) * (this.m_sortXVector[this.m_vertexIndex[i][j]].m_data[2] - this.m_sortXVector[this.m_vertexIndex[m][n]].m_data[2]) > 0.0) && (double)Math.abs(m - i) > maxIdx) {
                                        better = true;
                                        maxIdx = Math.abs(m - i);
                                    }
                                }
                                if (better) {
                                    i1 = i;
                                    i2 = m;
                                    j1 = j;
                                    j2 = n;
                                }
                            }
                        }
                        ++n;
                    }
                    ++m;
                }
                ++j;
            }
            ++i;
        }
        if (max < 0.0) {
            return;
        }
        if (max == 0.0 && maxIdx < 0.0) {
            return;
        }
        int tmp = this.m_vertexIndex[i1][j1];
        this.m_vertexIndex[i1][j1] = this.m_vertexIndex[i2][j2];
        this.m_vertexIndex[i2][j2] = tmp;
    }

    public void evenOddSort(int mode) {
        int i = 0;
        while (i < this.m_rootNov) {
            int j = 0;
            while (j < this.m_rootNov - 1) {
                block8: {
                    int tmp;
                    block7: {
                        if (mode != 0 && mode != 2) break block7;
                        if (j % 2 == 0 && mode == 2 || j % 2 == 1 && mode == 0) break block8;
                        if (this.m_comparator.compare((Object)this.m_sortXVector[this.m_vertexIndex[i][j]], (Object)this.m_sortXVector[this.m_vertexIndex[i][j + 1]]) > 0) {
                            tmp = this.m_vertexIndex[i][j + 1];
                            this.m_vertexIndex[i][j + 1] = this.m_vertexIndex[i][j];
                            this.m_vertexIndex[i][j] = tmp;
                        }
                    }
                    if (!(mode != 1 && mode != 3 || j % 2 == 0 && mode == 2 || j % 2 == 1 && mode == 0 || this.m_comparator.compare((Object)this.m_sortYVector[this.m_vertexIndex[j][i]], (Object)this.m_sortYVector[this.m_vertexIndex[j + 1][i]]) <= 0)) {
                        tmp = this.m_vertexIndex[j + 1][i];
                        this.m_vertexIndex[j + 1][i] = this.m_vertexIndex[j][i];
                        this.m_vertexIndex[j][i] = tmp;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public void evenOddUntilStable() {
        int mode = 0;
        int num = 0;
        while (!this.isStable()) {
            this.evenOddSort(mode);
            mode = (mode + 1) % 4;
            ++num;
            if (!this.m_bLogQuality) continue;
            this.computeQuality();
            PsDebug.message((String)("Sum " + this.m_sum_jx_iy));
        }
        if (this.m_bLogNum) {
            PsDebug.message((String)("Num even/odd steps: " + num));
        }
    }

    public void swapNeighboursUntilStable() {
        int num = 0;
        while (!this.isStable()) {
            this.swapMaxNeighbours();
            ++num;
            if (!this.m_bLogQuality) continue;
            this.computeQuality();
            PsDebug.message((String)("Sum " + this.m_sum_jx_iy));
        }
        if (this.m_bLogNum) {
            PsDebug.message((String)("Num swaps: " + num));
        }
    }

    public void swapMaxUntilStable() {
        int num = 0;
        while (!this.isStable()) {
            this.swapMaxPair();
            ++num;
            if (!this.m_bLogQuality) continue;
            this.computeQuality();
            PsDebug.message((String)("Sum " + this.m_sum_jx_iy));
        }
        if (this.m_bLogNum) {
            PsDebug.message((String)("Num swaps: " + num));
        }
    }

    public void sort_x_y_untilStable() {
        int num = 0;
        while (!this.isStable()) {
            this.sortRowsByX();
            ++num;
            if (this.m_bLogQuality) {
                this.computeQuality();
                PsDebug.message((String)("Sum " + this.m_sum_jx_iy));
            }
            if (this.isStable()) break;
            this.sortColumnsByY();
            ++num;
            if (!this.m_bLogQuality) continue;
            this.computeQuality();
            PsDebug.message((String)("Sum " + this.m_sum_jx_iy));
        }
        if (this.m_bLogNum) {
            PsDebug.message((String)("Num sortings: " + num));
        }
    }

    public void sort_y_x_untilStable() {
        int num = 0;
        while (!this.isStable()) {
            this.sortColumnsByY();
            ++num;
            if (this.m_bLogQuality) {
                this.computeQuality();
                PsDebug.message((String)("Sum " + this.m_sum_jx_iy));
            }
            if (this.isStable()) break;
            this.sortRowsByX();
            ++num;
            if (!this.m_bLogQuality) continue;
            this.computeQuality();
            PsDebug.message((String)("Sum " + this.m_sum_jx_iy));
        }
        if (this.m_bLogNum) {
            PsDebug.message((String)("Num sortings: " + num));
        }
    }

    public void randomPoints() {
        int n = this.m_iLinearSize.getValue();
        int sqrNum = n * n;
        this.m_elementSet.setNumVertices(sqrNum);
        int i = 0;
        while (i < sqrNum) {
            this.m_elementSet.getVertex((int)i).m_data[0] = Math.random();
            this.m_elementSet.getVertex((int)i).m_data[1] = Math.random();
            ++i;
        }
        this.assureSquareNumber();
        this.initializeSortVectors();
        this.initByRandom();
        this.setQuads();
    }

    public void evaluateKDTree() {
        PuKdTree tree = new PuKdTree((PgPointSet)this.m_elementSet);
        int num = this.m_elementSet.getNumVertices();
        this.m_nearest = new PiVector[num];
        int i = 0;
        while (i < num) {
            this.m_nearest[i] = tree.getNearestNeighbors(i, 8, -1.0, false);
            ++i;
        }
    }

    public String evaluateNeighbourhoodQuality() {
        int n = this.m_iLinearSize.getValue();
        PiVector neigh = new PiVector(8);
        double[] q = new double[8];
        int i = 1;
        while (i < n - 1) {
            int j = 1;
            while (j < n - 1) {
                neigh.m_data[0] = this.m_elementSet.getElement((int)((j - 1) * (n - 1) + i - 1)).m_data[0];
                neigh.m_data[1] = this.m_elementSet.getElement((int)((j - 1) * (n - 1) + i - 1)).m_data[1];
                neigh.m_data[2] = this.m_elementSet.getElement((int)((j - 1) * (n - 1) + i)).m_data[1];
                neigh.m_data[3] = this.m_elementSet.getElement((int)((j - 1) * (n - 1) + i - 1)).m_data[3];
                neigh.m_data[4] = this.m_elementSet.getElement((int)((j - 1) * (n - 1) + i)).m_data[2];
                neigh.m_data[5] = this.m_elementSet.getElement((int)(j * (n - 1) + i - 1)).m_data[3];
                neigh.m_data[6] = this.m_elementSet.getElement((int)(j * (n - 1) + i - 1)).m_data[2];
                neigh.m_data[7] = this.m_elementSet.getElement((int)(j * (n - 1) + i)).m_data[2];
                int idx = this.m_elementSet.getElement((int)((j - 1) * (n - 1) + i - 1)).m_data[2];
                int found = 0;
                if (neigh.getIndexOf(this.m_nearest[idx].m_data[7]) > -1) {
                    ++found;
                }
                q[0] = q[0] + (double)found;
                if (neigh.getIndexOf(this.m_nearest[idx].m_data[6]) > -1) {
                    ++found;
                }
                q[1] = q[1] + (double)found;
                if (neigh.getIndexOf(this.m_nearest[idx].m_data[5]) > -1) {
                    ++found;
                }
                q[2] = q[2] + (double)found;
                if (neigh.getIndexOf(this.m_nearest[idx].m_data[4]) > -1) {
                    ++found;
                }
                q[3] = q[3] + (double)found;
                if (neigh.getIndexOf(this.m_nearest[idx].m_data[3]) > -1) {
                    ++found;
                }
                q[4] = q[4] + (double)found;
                if (neigh.getIndexOf(this.m_nearest[idx].m_data[2]) > -1) {
                    ++found;
                }
                q[5] = q[5] + (double)found;
                if (neigh.getIndexOf(this.m_nearest[idx].m_data[1]) > -1) {
                    ++found;
                }
                q[6] = q[6] + (double)found;
                if (neigh.getIndexOf(this.m_nearest[idx].m_data[0]) > -1) {
                    ++found;
                }
                q[7] = q[7] + (double)found;
                ++j;
            }
            ++i;
        }
        String output = "Quote 1: " + q[0] / (double)((n - 2) * (n - 2)) + " Quote 2: " + q[1] / (double)((n - 2) * (n - 2)) + " Quote 3: " + q[2] / (double)((n - 2) * (n - 2)) + " Quote 4: " + q[3] / (double)((n - 2) * (n - 2)) + " Quote 5: " + q[4] / (double)((n - 2) * (n - 2)) + " Quote 6: " + q[5] / (double)((n - 2) * (n - 2)) + " Quote 7: " + q[6] / (double)((n - 2) * (n - 2)) + " Quote 8: " + q[7] / (double)((n - 2) * (n - 2));
        return output;
    }

    public void runExperiments() {
        this.m_bLogNum = false;
        this.m_bLogQuality = false;
        int numRandomPointSets = 1024;
        int numRandomPermutations = 32;
        PrintWriter writer1 = PsUtil.writeFile((String)"C:\\Test\\NeighbourhoodGrid\\randomPoints_swapMax.txt");
        PrintWriter writer3 = PsUtil.writeFile((String)"C:\\Test\\NeighbourhoodGrid\\randomPoints_direct.txt");
        PrintWriter writer2 = PsUtil.writeFile((String)"C:\\Test\\NeighbourhoodGrid\\randomPoints_xy.txt");
        PrintWriter writer4 = PsUtil.writeFile((String)"C:\\Test\\NeighbourhoodGrid\\randomPoints_evenOdd.txt");
        long tStart = System.currentTimeMillis();
        int i = 0;
        while (i < numRandomPointSets) {
            this.randomPoints();
            this.assureSquareNumber();
            this.initializeMatrix();
            this.initializeSortVectors();
            this.setQuads();
            this.m_elementSet.update((Object)this.m_elementSet);
            this.evaluateKDTree();
            this.initializeMatrix();
            this.initializeSortVectors();
            this.initByRandom();
            this.setQuads();
            this.m_elementSet.update((Object)this.m_elementSet);
            this.sortXToColumns();
            this.sortColumnsByY();
            this.setQuads();
            this.m_elementSet.update((Object)this.m_elementSet);
            String qs1 = this.evaluateNeighbourhoodQuality();
            writer3.println("points " + i + ": " + qs1);
            writer3.flush();
            writer2.println("points " + i);
            writer4.println("points " + i);
            int j = 0;
            while (j < numRandomPermutations) {
                this.initializeMatrix();
                this.initializeSortVectors();
                this.initByRandom();
                this.setQuads();
                this.m_elementSet.update((Object)this.m_elementSet);
                this.sort_x_y_untilStable();
                this.setQuads();
                this.m_elementSet.update((Object)this.m_elementSet);
                String qs2 = this.evaluateNeighbourhoodQuality();
                writer2.println("random " + j + ": " + qs2);
                writer2.flush();
                this.initializeMatrix();
                this.initializeSortVectors();
                this.initByRandom();
                this.setQuads();
                this.m_elementSet.update((Object)this.m_elementSet);
                this.evenOddUntilStable();
                this.setQuads();
                this.m_elementSet.update((Object)this.m_elementSet);
                String qs4 = this.evaluateNeighbourhoodQuality();
                writer4.println("random " + j + ": " + qs4);
                writer4.flush();
                this.initializeMatrix();
                this.initializeSortVectors();
                this.initByRandom();
                this.setQuads();
                this.m_elementSet.update((Object)this.m_elementSet);
                this.swapMaxUntilStable();
                this.setQuads();
                this.m_elementSet.update((Object)this.m_elementSet);
                String qsm = this.evaluateNeighbourhoodQuality();
                writer1.println("random " + j + ": " + qsm);
                writer1.flush();
                ++j;
            }
            long tCurrent = (System.currentTimeMillis() - tStart) / 1000L;
            System.out.println("Loop " + i + " - total time " + tCurrent + "s");
            ++i;
        }
        writer1.close();
        writer3.close();
        writer2.close();
    }
}

