/*
 * Decompiled with CFR 0.152.
 */
package dev.geom;

import dev.geom.PwSelect;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.geom.PgElementSet;
import jv.number.PuBoolean;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsUpdateIf;
import jv.vecmath.PbVector;
import jvx.project.PjWorkshop_IP;

public class PwSelect_IP
extends PjWorkshop_IP
implements ItemListener {
    private PwSelect m_pwSelect;
    private PgElementSet m_geom;
    protected Button m_invertVertexMarks;
    protected Button m_invertElementMarks;
    protected Button m_markAllVertices;
    protected Button m_markAllElements;
    protected Button m_unmarkAllVertices;
    protected Button m_unmarkAllElements;
    protected Button m_markBoundaryVertices;
    protected Button m_markBoundaryElements;
    protected Button m_markVerticesAtElements;
    protected Button m_markElementAtVertices;
    protected Button m_markVertexDegree;
    protected Button m_markElementDegree;
    protected Button m_markGauss;
    protected PuDouble m_threshGauss;
    protected String[] m_threshGaussText = new String[]{"Gauss Curvature >", "Gauss Curvature <"};
    protected Button m_markNonFlatVertices;
    protected Button m_markNonFlatElements;
    protected PuDouble m_threshDihedral;
    protected String[] m_threshDihedralText = new String[]{"Dihedral Angle >", "Dihedral Angle <"};
    protected Button m_markSmallVertexAngles;
    protected Button m_markSmallElementAngles;
    protected PuDouble m_threshInterior;
    protected String[] m_threshInteriorText = new String[]{"Max Interior Angle >", "Max Interior Angle <"};
    private PuInteger m_degree;
    protected String[] m_degreeText = new String[]{"Degree is equal to", "Degree differs from"};
    private Checkbox m_markBox;
    private Checkbox m_clearBox;
    private PuBoolean m_invertThreshold;
    private PuBoolean m_absoluteGaussCurv;
    private Button[] m_invertibleButtons;

    public PwSelect_IP() {
        this.setTitle(PsConfig.getMessage((boolean)true, (int)54000, (String)"Select Vertices and ELements"));
        this.m_degree = new PuInteger(this.m_degreeText[0], (PsUpdateIf)this);
        this.m_degree.setDefBounds(0, 20, 1, 5);
        this.m_degree.setDefValue(3);
        this.m_degree.init();
        this.m_invertThreshold = new PuBoolean("Invert Thresholds", (PsUpdateIf)this, false);
        this.m_invertThreshold.init();
        this.setPreferredSize(350, 560);
        if (this.getClass() == PwSelect_IP.class) {
            this.init();
        }
        this.setTitle("Select Vertices and Elements");
    }

    public int getDialogButtons() {
        return 13;
    }

    public void setParent(PsUpdateIf parent) {
        super.setParent(parent);
        this.m_pwSelect = (PwSelect)parent;
        this.m_geom = (PgElementSet)this.m_pwSelect.getGeometry();
        this.m_invertVertexMarks = new Button("Invert Vertex Marks");
        this.m_invertVertexMarks.addActionListener((ActionListener)((Object)this));
        this.m_invertElementMarks = new Button("Invert Element Marks");
        this.m_invertElementMarks.addActionListener((ActionListener)((Object)this));
        this.m_markAllVertices = new Button("Mark all Vertices");
        this.m_markAllVertices.addActionListener((ActionListener)((Object)this));
        this.m_markAllElements = new Button("Mark all Elements");
        this.m_markAllElements.addActionListener((ActionListener)((Object)this));
        this.m_unmarkAllVertices = new Button("Clear all Vertices");
        this.m_unmarkAllVertices.addActionListener((ActionListener)((Object)this));
        this.m_unmarkAllElements = new Button("Clear all Elements");
        this.m_unmarkAllElements.addActionListener((ActionListener)((Object)this));
        this.m_markBoundaryVertices = new Button("Mark Boundary Vertices");
        this.m_markBoundaryVertices.addActionListener((ActionListener)((Object)this));
        this.m_markBoundaryElements = new Button("Mark Boundary Elements");
        this.m_markBoundaryElements.addActionListener((ActionListener)((Object)this));
        this.m_markVerticesAtElements = new Button("Mark Vert's at Marked Elem's");
        this.m_markVerticesAtElements.addActionListener((ActionListener)((Object)this));
        this.m_markElementAtVertices = new Button("Mark Elem's at Marked Vert's");
        this.m_markElementAtVertices.addActionListener((ActionListener)((Object)this));
        CheckboxGroup checkBoxGroup = new CheckboxGroup();
        this.m_clearBox = new Checkbox("Clear", false, checkBoxGroup);
        this.m_clearBox.addItemListener(this);
        this.m_markBox = new Checkbox("Mark", true, checkBoxGroup);
        this.m_markBox.addItemListener(this);
        this.m_markVertexDegree = new Button("Mark Vertices if ...");
        this.m_markVertexDegree.addActionListener((ActionListener)((Object)this));
        this.m_markElementDegree = new Button("Mark Elements if ...");
        this.m_markElementDegree.addActionListener((ActionListener)((Object)this));
        this.m_markGauss = new Button("Mark Vertices if ...");
        this.m_markGauss.addActionListener((ActionListener)((Object)this));
        this.m_absoluteGaussCurv = new PuBoolean("Absolute Curvature Value", (PsUpdateIf)this);
        this.m_absoluteGaussCurv.init();
        this.m_threshGauss = new PuDouble(this.m_threshGaussText[0], (PsUpdateIf)this);
        this.m_threshGauss.setDefValue(5.0);
        this.m_threshGauss.setDefBounds(-180.0, 180.0, 1.0, 10.0);
        this.m_threshGauss.init();
        this.m_markNonFlatVertices = new Button("Mark Vertices if ...");
        this.m_markNonFlatVertices.addActionListener((ActionListener)((Object)this));
        this.m_markNonFlatElements = new Button("Mark Elements if ...");
        this.m_markNonFlatElements.addActionListener((ActionListener)((Object)this));
        this.m_threshDihedral = new PuDouble(this.m_threshDihedralText[0], (PsUpdateIf)this);
        this.m_threshDihedral.setDefValue(5.0);
        this.m_threshDihedral.setDefBounds(0.0, 180.0, 1.0, 10.0);
        this.m_threshDihedral.init();
        this.m_markSmallVertexAngles = new Button("Mark Vertices if ...");
        this.m_markSmallVertexAngles.addActionListener((ActionListener)((Object)this));
        this.m_markSmallElementAngles = new Button("Mark Elements if ...");
        this.m_markSmallElementAngles.addActionListener((ActionListener)((Object)this));
        this.m_threshInterior = new PuDouble(this.m_threshInteriorText[0], (PsUpdateIf)this);
        this.m_threshInterior.setDefBounds(0.0, 180.0, 1.0, 10.0);
        this.m_threshInterior.setDefValue(175.0);
        this.m_threshInterior.init();
        Panel panel = new Panel(new GridLayout(3, 2, 3, 3));
        panel.add(this.m_markAllVertices);
        panel.add(this.m_markAllElements);
        panel.add(this.m_unmarkAllVertices);
        panel.add(this.m_unmarkAllElements);
        panel.add(this.m_invertVertexMarks);
        panel.add(this.m_invertElementMarks);
        this.add(panel);
        this.add(new Label());
        this.addLine(1);
        panel = new Panel(new GridLayout(1, 2, 3, 3));
        Panel p = new Panel(new GridLayout(1, 2));
        p.add(this.m_markBox);
        p.add(this.m_clearBox);
        panel.add(p);
        panel.add((Component)this.m_invertThreshold.getInfoPanel());
        this.add(panel);
        panel = new Panel(new GridLayout(2, 2, 3, 3));
        panel.add(this.m_markBoundaryVertices);
        panel.add(this.m_markBoundaryElements);
        panel.add(this.m_markVerticesAtElements);
        panel.add(this.m_markElementAtVertices);
        this.add(panel);
        this.add(new Label());
        panel = new Panel(new GridLayout(1, 2, 3, 3));
        panel.add(this.m_markNonFlatVertices);
        panel.add(this.m_markNonFlatElements);
        this.add(panel);
        this.add((Component)this.m_threshDihedral.getInfoPanel());
        this.add(new Label());
        panel = new Panel(new GridLayout(1, 2, 3, 3));
        panel.add(this.m_markGauss);
        panel.add((Component)this.m_absoluteGaussCurv.getInfoPanel());
        this.add(panel);
        this.add((Component)this.m_threshGauss.getInfoPanel());
        this.add(new Label());
        panel = new Panel(new GridLayout(1, 2, 3, 3));
        panel.add(this.m_markSmallVertexAngles);
        panel.add(this.m_markSmallElementAngles);
        this.add(panel);
        this.add((Component)this.m_threshInterior.getInfoPanel());
        this.add(new Label());
        panel = new Panel(new GridLayout(1, 2, 3, 3));
        panel.add(this.m_markVertexDegree);
        panel.add(this.m_markElementDegree);
        this.add(panel);
        this.add((Component)this.m_degree.getInfoPanel());
        this.update(this);
        this.m_invertibleButtons = new Button[]{this.m_markBoundaryElements, this.m_markBoundaryVertices, this.m_markElementAtVertices, this.m_markElementDegree, this.m_markGauss, this.m_markNonFlatElements, this.m_markNonFlatVertices, this.m_markSmallElementAngles, this.m_markSmallVertexAngles, this.m_markVertexDegree, this.m_markVerticesAtElements};
    }

    public void actionPerformed(ActionEvent event) {
        PbVector marks;
        PbVector selection;
        if (!(this.m_pwSelect.getGeometry() instanceof PgElementSet)) {
            return;
        }
        PgElementSet geom = (PgElementSet)this.m_pwSelect.getGeometry();
        Object source = event.getSource();
        if (source == this.m_invertVertexMarks) {
            PwSelect.invertVertexMarks(this.m_geom);
        }
        if (source == this.m_invertElementMarks) {
            PwSelect.invertElementMarks(this.m_geom);
        }
        if (source == this.m_markAllVertices) {
            selection = new PbVector(this.m_geom.getNumVertices());
            selection.setConstant(true);
            PwSelect.setVertexSelections(geom, selection);
        }
        if (source == this.m_markAllElements) {
            selection = new PbVector(this.m_geom.getNumElements());
            selection.setConstant(true);
            PwSelect.setElementSelections(geom, selection);
        }
        if (source == this.m_unmarkAllVertices) {
            selection = new PbVector(this.m_geom.getNumVertices());
            PwSelect.setVertexSelections(geom, selection);
        }
        if (source == this.m_unmarkAllElements) {
            selection = new PbVector(this.m_geom.getNumElements());
            PwSelect.setElementSelections(geom, selection);
        }
        if (source == this.m_markBoundaryVertices) {
            this.changeVertices(PwSelect.getBoundaryVertices(geom));
        }
        if (source == this.m_markBoundaryElements) {
            this.changeElements(PwSelect.getBoundaryElements(geom));
        }
        if (source == this.m_markVerticesAtElements) {
            this.changeVertices(PwSelect.getVerticesAtMarkedElements(geom));
        }
        if (source == this.m_markElementAtVertices) {
            this.changeElements(PwSelect.getElementsAtMarkedVertices(geom));
        }
        if (source == this.m_markGauss) {
            marks = PwSelect.getVerticesWithGaussCurvature(geom, this.m_threshGauss.getValue() * Math.PI / 180.0, this.m_absoluteGaussCurv.getState());
            if (this.m_invertThreshold.getState()) {
                marks.invertEntries();
            }
            this.changeVertices(marks);
        }
        if (source == this.m_markNonFlatVertices) {
            marks = PwSelect.getVerticesAtCreases(geom, this.m_threshDihedral.getValue() * Math.PI / 180.0);
            if (this.m_invertThreshold.getState()) {
                marks.invertEntries();
            }
            this.changeVertices(marks);
        }
        if (source == this.m_markNonFlatElements) {
            marks = PwSelect.getElementsAtCreases(geom, this.m_threshDihedral.getValue() * Math.PI / 180.0);
            if (this.m_invertThreshold.getState()) {
                marks.invertEntries();
            }
            this.changeElements(marks);
        }
        if (source == this.m_markSmallVertexAngles) {
            marks = PwSelect.getVerticesAtLargeAngles(geom, this.m_threshInterior.getValue() * Math.PI / 180.0);
            if (this.m_invertThreshold.getState()) {
                marks.invertEntries();
            }
            this.changeVertices(marks);
        }
        if (source == this.m_markSmallElementAngles) {
            marks = PwSelect.getElementsAtLargeAngles(geom, this.m_threshInterior.getValue() * Math.PI / 180.0);
            if (this.m_invertThreshold.getState()) {
                marks.invertEntries();
            }
            this.changeElements(marks);
        }
        if (source == this.m_markVertexDegree) {
            marks = PwSelect.getVerticesWithValence(geom, this.m_degree.getValue());
            if (this.m_invertThreshold.getState()) {
                marks.invertEntries();
            }
            this.changeVertices(marks);
        }
        if (source == this.m_markElementDegree) {
            marks = PwSelect.getElementsWithValence(geom, this.m_degree.getValue());
            if (this.m_invertThreshold.getState()) {
                marks.invertEntries();
            }
            this.changeElements(marks);
        }
        super.actionPerformed(event);
        this.m_geom.update((Object)this.m_geom);
    }

    private void changeVertices(PbVector selection) {
        PgElementSet geom = (PgElementSet)this.m_pwSelect.getGeometry();
        if (this.m_markBox.getState()) {
            PwSelect.addVertexSelections(geom, selection);
        } else {
            PwSelect.clearVertexSelections(geom, selection);
        }
    }

    private void changeElements(PbVector selection) {
        PgElementSet geom = (PgElementSet)this.m_pwSelect.getGeometry();
        if (this.m_markBox.getState()) {
            PwSelect.addElementSelections(geom, selection);
        } else {
            PwSelect.clearElementSelections(geom, selection);
        }
    }

    public boolean update(Object event) {
        if (event == this.m_invertThreshold) {
            this.updateThresholdLabels();
            return true;
        }
        return super.update(event);
    }

    private void updateThresholdLabels() {
        int index = this.m_invertThreshold.getState() ? 1 : 0;
        this.m_threshGauss.setName(this.m_threshGaussText[index]);
        this.m_threshDihedral.setName(this.m_threshDihedralText[index]);
        this.m_threshInterior.setName(this.m_threshInteriorText[index]);
        this.m_degree.setName(this.m_degreeText[index]);
        this.m_threshGauss.update((Object)this.m_threshGauss);
        this.m_threshDihedral.update((Object)this.m_threshDihedral);
        this.m_threshInterior.update((Object)this.m_threshInterior);
        this.m_degree.update((Object)this.m_degree);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        block4: {
            if (e.getSource() != this.m_markBox && e.getSource() != this.m_clearBox) break block4;
            if (this.m_markBox.getState()) {
                int i = 0;
                while (i < this.m_invertibleButtons.length) {
                    Button button = this.m_invertibleButtons[i];
                    button.setLabel("Mark " + button.getLabel().substring(6));
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.m_invertibleButtons.length) {
                    Button button = this.m_invertibleButtons[i];
                    button.setLabel("Clear " + button.getLabel().substring(5));
                    ++i;
                }
            }
        }
    }
}

