/*
 * Decompiled with CFR 0.152.
 */
package dev.geom;

import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.vecmath.PbVector;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgVertexStar;
import jvx.geom.PwCurvature;
import jvx.project.PjWorkshop;

public class PwSelect
extends PjWorkshop {
    private static final long serialVersionUID = -3244479735319831649L;

    public PwSelect() {
        super("PwSelect");
        if (((Object)((Object)this)).getClass() == PwSelect.class) {
            this.init();
        }
    }

    public static void addElementSelections(PgElementSet geom, PbVector marks) {
        PbVector selected = PwSelect.getElementSelections(geom);
        selected.or(marks);
        PwSelect.setElementSelections(geom, selected);
    }

    public static void addVertexSelections(PgElementSet geom, PbVector marks) {
        PbVector selected = PwSelect.getVertexSelections(geom);
        selected.or(marks);
        PwSelect.setVertexSelections(geom, selected);
    }

    public static void clearElementSelections(PgElementSet geom, PbVector marks) {
        PbVector selected = PwSelect.getElementSelections(geom);
        marks = PbVector.copyNew((PbVector)marks);
        marks.invertEntries();
        selected.and(marks);
        PwSelect.setElementSelections(geom, selected);
    }

    public static void clearVertexSelections(PgElementSet geom, PbVector marks) {
        PbVector selected = PwSelect.getVertexSelections(geom);
        marks = PbVector.copyNew((PbVector)marks);
        marks.invertEntries();
        selected.and(marks);
        PwSelect.setVertexSelections(geom, selected);
    }

    public static PbVector getBoundaryElements(PgElementSet geom) {
        PbVector marks = new PbVector(geom.getNumElements());
        if (geom.getNeighbours() == null || geom.getNeighbours().length != geom.getNumElements()) {
            geom.makeNeighbour();
        }
        int e = 0;
        while (e < geom.getNumElements()) {
            if (geom.getNeighbour(e).min() == -1) {
                marks.m_data[e] = true;
            }
            ++e;
        }
        return marks;
    }

    public static PbVector getBoundaryVertices(PgElementSet geom) {
        PbVector marks = new PbVector(geom.getNumVertices());
        PgVertexStar star = new PgVertexStar();
        int[] elemAtVertex = PgVertexStar.getElementPerVertex((PgElementSet)geom).m_data;
        int v = 0;
        while (v < geom.getNumVertices()) {
            star.makeVertexStar(geom, v, elemAtVertex[v]);
            if (!star.isClosed()) {
                marks.m_data[v] = true;
            }
            ++v;
        }
        return marks;
    }

    public static PbVector getElementsAtCreases(PgElementSet geom, double angle) {
        PbVector marks = new PbVector(geom.getNumElements());
        double cos = Math.cos(angle);
        int i = 0;
        while (i < geom.getNumElements()) {
            PiVector elem = geom.getElement(i);
            PiVector neigh = geom.getNeighbour(i);
            PdVector iNormal = geom.getElementNormal(i);
            int j = 0;
            while (j < elem.getSize()) {
                int ne = neigh.getEntry(j);
                if (ne >= i && iNormal.dot(geom.getElementNormal(ne)) < cos) {
                    marks.m_data[i] = true;
                    marks.m_data[ne] = true;
                }
                ++j;
            }
            ++i;
        }
        return marks;
    }

    public static PbVector getElementsAtLargeAngles(PgElementSet geom, double angle) {
        PbVector marks = new PbVector(geom.getNumElements());
        double cos = Math.cos(angle);
        int e = 0;
        while (e < geom.getNumElements()) {
            PiVector elem = geom.getElement(e);
            int j = 0;
            while (j < elem.getSize()) {
                PdVector edge2;
                int v0 = elem.getEntry(j);
                int v1 = elem.getEntry((j + 1) % elem.getSize());
                int v2 = elem.getEntry((j + 2) % elem.getSize());
                PdVector edge1 = PdVector.subNew((PdVector)geom.getVertex(v0), (PdVector)geom.getVertex(v1));
                double dot = PdVector.dot((PdVector)edge1, (PdVector)(edge2 = PdVector.subNew((PdVector)geom.getVertex(v2), (PdVector)geom.getVertex(v1)))) / edge1.length() / edge2.length();
                if (dot < cos) {
                    marks.m_data[e] = true;
                    break;
                }
                ++j;
            }
            ++e;
        }
        return marks;
    }

    public static PbVector getElementsAtMarkedVertices(PgElementSet geom) {
        PbVector marks = new PbVector(geom.getNumElements());
        int e = 0;
        while (e < geom.getNumElements()) {
            PiVector elem = geom.getElement(e);
            int i = 0;
            while (i < elem.getSize()) {
                if (geom.hasTagVertex(elem.getEntry(i), 1)) {
                    marks.m_data[e] = true;
                    break;
                }
                ++i;
            }
            ++e;
        }
        return marks;
    }

    public static PbVector getElementSelections(PgElementSet geom) {
        PbVector marks = new PbVector(geom.getNumElements());
        int e = 0;
        while (e < geom.getNumElements()) {
            marks.m_data[e] = geom.hasTagElement(e, 1);
            ++e;
        }
        return marks;
    }

    public static PbVector getElementsWithValence(PgElementSet geom, int valence) {
        PbVector marks = new PbVector(geom.getNumElements());
        int e = 0;
        while (e < geom.getNumElements()) {
            if (geom.getDimOfElement(e) == valence) {
                marks.m_data[e] = true;
            }
            ++e;
        }
        return marks;
    }

    public static PbVector getVertexSelections(PgElementSet geom) {
        PbVector marks = new PbVector(geom.getNumVertices());
        int v = 0;
        while (v < geom.getNumVertices()) {
            marks.m_data[v] = geom.hasTagVertex(v, 1);
            ++v;
        }
        return marks;
    }

    public static PbVector getVerticesAtCreases(PgElementSet geom, double angle) {
        PbVector marks = new PbVector(geom.getNumVertices());
        double cos = Math.cos(angle);
        int i = 0;
        while (i < geom.getNumElements()) {
            PiVector elem = geom.getElement(i);
            PiVector neigh = geom.getNeighbour(i);
            PdVector iNormal = geom.getElementNormal(i);
            int j = 0;
            while (j < elem.getSize()) {
                int ne = neigh.getEntry(j);
                if (ne >= i && iNormal.dot(geom.getElementNormal(ne)) < cos) {
                    marks.m_data[elem.getEntry((int)((j + 1) % elem.getSize()))] = true;
                    marks.m_data[elem.getEntry((int)((j + 2) % elem.getSize()))] = true;
                }
                ++j;
            }
            ++i;
        }
        return marks;
    }

    public static PbVector getVerticesAtLargeAngles(PgElementSet geom, double angle) {
        PbVector marks = new PbVector(geom.getNumVertices());
        double cos = Math.cos(angle);
        int i = 0;
        while (i < geom.getNumElements()) {
            PiVector elem = geom.getElement(i);
            int j = 0;
            while (j < elem.getSize()) {
                PdVector edge2;
                int v0 = elem.getEntry(j);
                int v1 = elem.getEntry((j + 1) % elem.getSize());
                int v2 = elem.getEntry((j + 2) % elem.getSize());
                PdVector edge1 = PdVector.subNew((PdVector)geom.getVertex(v0), (PdVector)geom.getVertex(v1));
                double dot = PdVector.dot((PdVector)edge1, (PdVector)(edge2 = PdVector.subNew((PdVector)geom.getVertex(v2), (PdVector)geom.getVertex(v1)))) / edge1.length() / edge2.length();
                if (dot < cos) {
                    marks.m_data[v1] = true;
                }
                ++j;
            }
            ++i;
        }
        return marks;
    }

    public static PbVector getVerticesAtMarkedElements(PgElementSet geom) {
        PbVector marks = new PbVector(geom.getNumVertices());
        PgVertexStar star = new PgVertexStar();
        int[] elemAtVertex = PgVertexStar.getElementPerVertex((PgElementSet)geom).m_data;
        int v = 0;
        while (v < geom.getNumVertices()) {
            star.makeVertexStar(geom, v, elemAtVertex[v]);
            PiVector element = star.getElement();
            int i = 0;
            while (i < element.getSize()) {
                if (geom.hasTagElement(element.getEntry(i), 1)) {
                    marks.m_data[v] = true;
                    break;
                }
                ++i;
            }
            ++v;
        }
        return marks;
    }

    public static PbVector getVerticesWithGaussCurvature(PgElementSet geom, double angle, boolean absVal) {
        PbVector marks = new PbVector(geom.getNumVertices());
        PdVector gauss = new PdVector(geom.getNumVertices());
        PwCurvature.getGaussCurvature((PgElementSet)geom, (PdVector)gauss);
        int v = 0;
        while (v < geom.getNumVertices()) {
            if (gauss.getEntry(v) > angle || absVal && Math.abs(gauss.getEntry(v)) > Math.abs(angle)) {
                marks.m_data[v] = true;
            }
            ++v;
        }
        return marks;
    }

    public static PbVector getVerticesWithValence(PgElementSet geom, int valence) {
        PbVector marks = new PbVector(geom.getNumVertices());
        PiVector val = PgElementSet.getVertexValence((PgElementSet)geom);
        int v = 0;
        while (v < geom.getNumVertices()) {
            if (val.getEntry(v) == valence) {
                marks.m_data[v] = true;
            }
            ++v;
        }
        return marks;
    }

    public static void invertElementMarks(PgElementSet geom) {
        PbVector marks = PwSelect.getElementSelections(geom);
        marks.invertEntries();
        PwSelect.setElementSelections(geom, marks);
    }

    public static void invertVertexMarks(PgElementSet geom) {
        PbVector marks = PwSelect.getVertexSelections(geom);
        marks.invertEntries();
        PwSelect.setVertexSelections(geom, marks);
    }

    public static void setElementSelections(PgElementSet geom, PbVector selection) {
        if (selection == null || selection.getSize() != geom.getNumElements()) {
            PsDebug.warning((String)"Missing argument or wrong size.");
            return;
        }
        int e = 0;
        while (e < geom.getNumElements()) {
            if (selection.m_data[e]) {
                geom.setTagElement(e, 1);
            } else {
                geom.clearTagElement(e, 1);
            }
            ++e;
        }
    }

    public static void setVertexSelections(PgElementSet geom, PbVector selection) {
        if (selection == null || selection.getSize() != geom.getNumVertices()) {
            PsDebug.warning((String)"Missing argument or wrong size.");
            return;
        }
        int v = 0;
        while (v < geom.getNumVertices()) {
            if (selection.m_data[v]) {
                geom.setTagVertex(v, 1);
            } else {
                geom.clearTagVertex(v, 1);
            }
            ++v;
        }
    }

    public void reset() {
        super.reset();
        this.m_geom.copy((PsObject)this.m_geomSave);
    }
}

