/*
 * Decompiled with CFR 0.152.
 */
package dev.geom;

import jv.geom.PgElementSet;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.project.PgGeometry;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgVertexStar;
import jvx.project.PjWorkshop;

public class PwNormal
extends PjWorkshop {
    protected PgElementSet m_elementSet;

    public PwNormal() {
        super(PsConfig.getMessage((boolean)true, (int)51000, (String)"Calculate Normals"));
        if (((Object)((Object)this)).getClass() == PwNormal.class) {
            this.init();
        }
    }

    public void setGeometry(PgGeometry geom) {
        super.setGeometry(geom);
        this.m_elementSet = (PgElementSet)geom;
    }

    public boolean makeVertexNormals() {
        int dim = this.m_elementSet.getDimOfVertices();
        if (dim != 3) {
            return false;
        }
        this.m_elementSet.assureVertexNormals();
        int dimOfVectors = this.m_elementSet.getDimOfVectors();
        PdVector edgeB = new PdVector(dim);
        PdVector edgeC = new PdVector(dim);
        PdVector normal = new PdVector(dimOfVectors);
        PdVector facNor = new PdVector(dimOfVectors);
        int maxDimOfElements = this.m_elementSet.getMaxDimOfElements();
        boolean[] bRegular = new boolean[maxDimOfElements];
        PdVector[] vertexNormal = this.m_elementSet.getVertexNormals();
        PdVector.setConstant((PdVector[])vertexNormal, (double)0.0);
        int numElements = this.m_elementSet.getNumElements();
        int numVertices = this.m_elementSet.getNumVertices();
        PiVector[] element = this.m_elementSet.getElements();
        int i = 0;
        while (i < numElements) {
            int numEdges = element[i].getSize();
            if (numEdges >= 3) {
                double area;
                if (numEdges > maxDimOfElements && numEdges > bRegular.length) {
                    bRegular = new boolean[maxDimOfElements + numEdges];
                    PsDebug.warning((String)("dimension of an element = " + numEdges + " too large."));
                }
                if (!((area = this.m_elementSet.getAreaOfElement(i)) < 1.0E-10)) {
                    int vertexInd;
                    int[] elem = this.m_elementSet.getElement((int)i).m_data;
                    PdVector vertexB = this.m_elementSet.getVertex(elem[(-2 + numEdges) % numEdges]);
                    PdVector vertexC = this.m_elementSet.getVertex(elem[(-1 + numEdges) % numEdges]);
                    edgeB.sub(vertexC, vertexB);
                    boolean bVoidFace = false;
                    facNor.setConstant(0.0);
                    int j = 0;
                    while (j < numEdges) {
                        vertexInd = elem[(j - 1 + numEdges) % numEdges];
                        vertexB = vertexC;
                        vertexC = this.m_elementSet.getVertex(elem[j]);
                        edgeC.sub(vertexC, vertexB);
                        boolean bOk = normal.cross(edgeB, edgeC);
                        edgeB.copyArray(edgeC);
                        boolean bl = bRegular[j] = bOk && normal.setLength(area);
                        if (bRegular[j]) {
                            if (PdVector.angle((PdVector)vertexNormal[vertexInd], (PdVector)normal) > 135.0) {
                                vertexNormal[vertexInd].sub(normal);
                                facNor.sub(normal);
                            } else {
                                vertexNormal[vertexInd].add(normal);
                                facNor.add(normal);
                            }
                        } else {
                            bVoidFace = true;
                        }
                        ++j;
                    }
                    if (bVoidFace) {
                        j = 0;
                        while (j < numEdges) {
                            vertexInd = elem[(j - 1 + numEdges) % numEdges];
                            if (!bRegular[j]) {
                                vertexNormal[vertexInd].add(facNor);
                            }
                            ++j;
                        }
                    }
                }
            }
            ++i;
        }
        i = 0;
        while (i < numVertices) {
            vertexNormal[i].normalize();
            ++i;
        }
        return true;
    }

    public boolean makeVertexNormals2() {
        int dim = this.m_elementSet.getDimOfVertices();
        if (dim != 3) {
            return false;
        }
        this.m_elementSet.assureVertexNormals();
        int dimOfVectors = this.m_elementSet.getDimOfVectors();
        PdVector edgeB = new PdVector(dim);
        PdVector edgeC = new PdVector(dim);
        PdVector normal = new PdVector(dimOfVectors);
        PdVector facNor = new PdVector(dimOfVectors);
        int maxDimOfElements = this.m_elementSet.getMaxDimOfElements();
        boolean[] bRegular = new boolean[maxDimOfElements];
        PdVector[] vertexNormal = this.m_elementSet.getVertexNormals();
        PdVector.setConstant((PdVector[])vertexNormal, (double)0.0);
        int numElements = this.m_elementSet.getNumElements();
        int numVertices = this.m_elementSet.getNumVertices();
        PiVector[] element = this.m_elementSet.getElements();
        int i = 0;
        while (i < numElements) {
            int numEdges = element[i].getSize();
            if (numEdges >= 3) {
                double area;
                if (numEdges > maxDimOfElements && numEdges > bRegular.length) {
                    bRegular = new boolean[maxDimOfElements + numEdges];
                    PsDebug.warning((String)("dimension of an element = " + numEdges + " too large."));
                }
                if (!((area = this.m_elementSet.getAreaOfElement(i)) < 1.0E-10)) {
                    int vertexInd;
                    int[] elem = this.m_elementSet.getElement((int)i).m_data;
                    PdVector vertexB = this.m_elementSet.getVertex(elem[(-2 + numEdges) % numEdges]);
                    PdVector vertexC = this.m_elementSet.getVertex(elem[(-1 + numEdges) % numEdges]);
                    edgeB.sub(vertexC, vertexB);
                    boolean bVoidFace = false;
                    facNor.setConstant(0.0);
                    int j = 0;
                    while (j < numEdges) {
                        vertexInd = elem[(j - 1 + numEdges) % numEdges];
                        vertexB = vertexC;
                        vertexC = this.m_elementSet.getVertex(elem[j]);
                        edgeC.sub(vertexC, vertexB);
                        boolean bOk = normal.cross(edgeB, edgeC);
                        edgeB.copyArray(edgeC);
                        boolean bl = bRegular[j] = bOk && normal.length() > 1.0E-10;
                        if (bRegular[j]) {
                            if (PdVector.angle((PdVector)vertexNormal[vertexInd], (PdVector)normal) > 135.0) {
                                vertexNormal[vertexInd].sub(normal);
                            } else {
                                vertexNormal[vertexInd].add(normal);
                            }
                            facNor.add(normal);
                        } else {
                            bVoidFace = true;
                        }
                        ++j;
                    }
                    if (bVoidFace) {
                        facNor.setLength(2.0 * area);
                        j = 0;
                        while (j < numEdges) {
                            vertexInd = elem[(j - 1 + numEdges) % numEdges];
                            if (!bRegular[j]) {
                                if (PdVector.angle((PdVector)vertexNormal[vertexInd], (PdVector)normal) > 135.0) {
                                    vertexNormal[vertexInd].sub(facNor);
                                } else {
                                    vertexNormal[vertexInd].add(facNor);
                                }
                            }
                            ++j;
                        }
                    }
                }
            }
            ++i;
        }
        i = 0;
        while (i < numVertices) {
            vertexNormal[i].normalize();
            ++i;
        }
        return true;
    }

    public boolean makeVertexNormals3() {
        int dim = this.m_elementSet.getDimOfVertices();
        if (dim != 3) {
            return false;
        }
        this.m_elementSet.assureVertexNormals();
        int dimOfVectors = this.m_elementSet.getDimOfVectors();
        PdVector edgeB = new PdVector(dim);
        PdVector edgeC = new PdVector(dim);
        PdVector normal = new PdVector(dimOfVectors);
        PdVector facNor = new PdVector(dimOfVectors);
        int maxDimOfElements = this.m_elementSet.getMaxDimOfElements();
        boolean[] bRegular = new boolean[maxDimOfElements];
        PdVector[] vertexNormal = this.m_elementSet.getVertexNormals();
        PdVector.setConstant((PdVector[])vertexNormal, (double)0.0);
        int numElements = this.m_elementSet.getNumElements();
        int numVertices = this.m_elementSet.getNumVertices();
        PiVector[] element = this.m_elementSet.getElements();
        int i = 0;
        while (i < numElements) {
            int numEdges = element[i].getSize();
            if (numEdges >= 3) {
                double area;
                if (numEdges > maxDimOfElements && numEdges > bRegular.length) {
                    bRegular = new boolean[maxDimOfElements + numEdges];
                    PsDebug.warning((String)("dimension of an element = " + numEdges + " too large."));
                }
                if (!((area = this.m_elementSet.getAreaOfElement(i)) < 1.0E-10)) {
                    int vertexInd;
                    int[] elem = this.m_elementSet.getElement((int)i).m_data;
                    PdVector vertexB = this.m_elementSet.getVertex(elem[(-2 + numEdges) % numEdges]);
                    PdVector vertexC = this.m_elementSet.getVertex(elem[(-1 + numEdges) % numEdges]);
                    edgeB.sub(vertexC, vertexB);
                    boolean bVoidFace = false;
                    facNor.setConstant(0.0);
                    int j = 0;
                    while (j < numEdges) {
                        vertexInd = elem[(j - 1 + numEdges) % numEdges];
                        vertexB = vertexC;
                        vertexC = this.m_elementSet.getVertex(elem[j]);
                        edgeC.sub(vertexC, vertexB);
                        boolean bOk = normal.cross(edgeB, edgeC);
                        double angle = 180.0 - PdVector.angle((PdVector)edgeB, (PdVector)edgeC);
                        edgeB.copyArray(edgeC);
                        normal.setLength(angle);
                        boolean bl = bRegular[j] = bOk && normal.length() > 1.0E-10;
                        if (bRegular[j]) {
                            if (PdVector.angle((PdVector)vertexNormal[vertexInd], (PdVector)normal) > 135.0) {
                                vertexNormal[vertexInd].sub(normal);
                            } else {
                                vertexNormal[vertexInd].add(normal);
                            }
                            facNor.add(normal);
                        } else {
                            bVoidFace = true;
                        }
                        ++j;
                    }
                    if (bVoidFace) {
                        facNor.normalize();
                        j = 0;
                        while (j < numEdges) {
                            vertexInd = elem[(j - 1 + numEdges) % numEdges];
                            if (!bRegular[j]) {
                                double angle = PdVector.angle((PdVector)PdVector.subNew((PdVector)this.m_elementSet.getVertex(elem[j]), (PdVector)this.m_elementSet.getVertex(elem[(j + numEdges - 1) % numEdges])), (PdVector)PdVector.subNew((PdVector)this.m_elementSet.getVertex(elem[(j + numEdges - 2) % numEdges]), (PdVector)this.m_elementSet.getVertex(elem[(j + numEdges - 1) % numEdges])));
                                if (PdVector.angle((PdVector)vertexNormal[vertexInd], (PdVector)normal) > 135.0) {
                                    vertexNormal[vertexInd].blendBase(vertexNormal[vertexInd], -angle, facNor);
                                } else {
                                    vertexNormal[vertexInd].blendBase(vertexNormal[vertexInd], angle, facNor);
                                }
                            }
                            ++j;
                        }
                    }
                }
            }
            ++i;
        }
        i = 0;
        while (i < numVertices) {
            vertexNormal[i].normalize();
            ++i;
        }
        return true;
    }

    public boolean makeVertexNormals4() {
        int dim = this.m_elementSet.getDimOfVertices();
        if (dim != 3) {
            return false;
        }
        this.m_elementSet.assureVertexNormals();
        int dimOfVectors = this.m_elementSet.getDimOfVectors();
        PdVector edgeB = new PdVector(dim);
        PdVector edgeC = new PdVector(dim);
        PdVector normal = new PdVector(dimOfVectors);
        PdVector facNor = new PdVector(dimOfVectors);
        int maxDimOfElements = this.m_elementSet.getMaxDimOfElements();
        boolean[] bRegular = new boolean[maxDimOfElements];
        PdVector[] vertexNormal = this.m_elementSet.getVertexNormals();
        PdVector.setConstant((PdVector[])vertexNormal, (double)0.0);
        int numElements = this.m_elementSet.getNumElements();
        int numVertices = this.m_elementSet.getNumVertices();
        PiVector[] element = this.m_elementSet.getElements();
        int i = 0;
        while (i < numElements) {
            int numEdges = element[i].getSize();
            if (numEdges >= 3) {
                double area;
                if (numEdges > maxDimOfElements && numEdges > bRegular.length) {
                    bRegular = new boolean[maxDimOfElements + numEdges];
                    PsDebug.warning((String)("dimension of an element = " + numEdges + " too large."));
                }
                if (!((area = this.m_elementSet.getAreaOfElement(i)) < 1.0E-10)) {
                    int vertexInd;
                    int[] elem = this.m_elementSet.getElement((int)i).m_data;
                    PdVector vertexB = this.m_elementSet.getVertex(elem[(-2 + numEdges) % numEdges]);
                    PdVector vertexC = this.m_elementSet.getVertex(elem[(-1 + numEdges) % numEdges]);
                    edgeB.sub(vertexC, vertexB);
                    boolean bVoidFace = false;
                    facNor.setConstant(0.0);
                    int j = 0;
                    while (j < numEdges) {
                        vertexInd = elem[(j - 1 + numEdges) % numEdges];
                        vertexB = vertexC;
                        vertexC = this.m_elementSet.getVertex(elem[j]);
                        edgeC.sub(vertexC, vertexB);
                        boolean bOk = normal.cross(edgeB, edgeC);
                        edgeB.copyArray(edgeC);
                        normal.normalize();
                        boolean bl = bRegular[j] = bOk && normal.length() > 1.0E-10;
                        if (bRegular[j]) {
                            if (PdVector.angle((PdVector)vertexNormal[vertexInd], (PdVector)normal) > 135.0) {
                                vertexNormal[vertexInd].sub(normal);
                            } else {
                                vertexNormal[vertexInd].add(normal);
                            }
                            facNor.add(normal);
                        } else {
                            bVoidFace = true;
                        }
                        ++j;
                    }
                    if (bVoidFace) {
                        facNor.normalize();
                        j = 0;
                        while (j < numEdges) {
                            vertexInd = elem[(j - 1 + numEdges) % numEdges];
                            if (!bRegular[j]) {
                                if (PdVector.angle((PdVector)vertexNormal[vertexInd], (PdVector)normal) > 135.0) {
                                    vertexNormal[vertexInd].sub(facNor);
                                } else {
                                    vertexNormal[vertexInd].add(facNor);
                                }
                            }
                            ++j;
                        }
                    }
                }
            }
            ++i;
        }
        i = 0;
        while (i < numVertices) {
            vertexNormal[i].normalize();
            ++i;
        }
        return true;
    }

    public boolean makeVertexStarNormals() {
        int dim = this.m_elementSet.getDimOfVertices();
        if (dim != 3) {
            return false;
        }
        if (this.m_elementSet.getNeighbours() == null || !this.m_elementSet.checkNeighbour(false)) {
            this.m_elementSet.makeNeighbour();
        }
        this.m_elementSet.assureVertexNormals();
        int dimOfVectors = this.m_elementSet.getDimOfVectors();
        PdVector edgeB = new PdVector(dim);
        PdVector edgeC = new PdVector(dim);
        PdVector normal = new PdVector(dimOfVectors);
        PdVector[] vertexNormal = this.m_elementSet.getVertexNormals();
        PdVector.setConstant((PdVector[])vertexNormal, (double)0.0);
        int numElements = this.m_elementSet.getNumElements();
        int numVertices = this.m_elementSet.getNumVertices();
        PiVector[] element = this.m_elementSet.getElements();
        boolean[] bComputed = new boolean[numVertices];
        int i = 0;
        while (i < numVertices) {
            bComputed[i] = false;
            ++i;
        }
        PgVertexStar vertexStar = new PgVertexStar();
        int starSize = 0;
        int linkSize = 0;
        int elementSize = 0;
        int i2 = 0;
        while (i2 < numElements) {
            int numEdges = element[i2].getSize();
            if (numEdges >= 3) {
                int[] elem = this.m_elementSet.getElement((int)i2).m_data;
                int j = 0;
                while (j < numEdges) {
                    if (!bComputed[elem[j]]) {
                        vertexStar.makeVertexStar(this.m_elementSet, elem[j], i2);
                        linkSize = starSize = vertexStar.getSize();
                        if (!vertexStar.isClosed()) {
                            ++linkSize;
                        }
                        PiVector link = vertexStar.getLink();
                        PiVector vsElement = vertexStar.getElement();
                        PiVector localInd = vertexStar.getVertexLocInd();
                        PiVector currentElement = this.m_elementSet.getElement(vsElement.m_data[0]);
                        elementSize = currentElement.getSize();
                        boolean bChangeSign = false;
                        if (currentElement.m_data[(localInd.m_data[0] + elementSize - 1) % elementSize] == link.m_data[0] && currentElement.m_data[(localInd.m_data[0] + 1) % elementSize] == link.m_data[1]) {
                            bChangeSign = true;
                        } else if (currentElement.m_data[(localInd.m_data[0] + elementSize - 1) % elementSize] == link.m_data[1] && currentElement.m_data[(localInd.m_data[0] + 1) % elementSize] == link.m_data[0]) {
                            bChangeSign = false;
                        } else {
                            PsDebug.warning((String)"Some index is wrong.");
                        }
                        int k = 0;
                        while (k < starSize) {
                            edgeB.sub(this.m_elementSet.getVertex(link.m_data[k]), this.m_elementSet.getVertex(elem[j]));
                            edgeC.sub(this.m_elementSet.getVertex(link.m_data[(k + 1) % linkSize]), this.m_elementSet.getVertex(elem[j]));
                            boolean bOk = normal.cross(edgeB, edgeC);
                            if (!bOk || normal.length() < 1.0E-10) {
                                currentElement = this.m_elementSet.getElement(vsElement.m_data[k]);
                                elementSize = currentElement.getSize();
                                boolean bFlip = false;
                                PdVector faceNormal = new PdVector(dimOfVectors);
                                int m = 0;
                                while (m < elementSize) {
                                    edgeB.sub(this.m_elementSet.getVertex(currentElement.m_data[m]), this.m_elementSet.getVertex(currentElement.m_data[(m + 1) % elementSize]));
                                    edgeC.sub(this.m_elementSet.getVertex(currentElement.m_data[(m + 2) % elementSize]), this.m_elementSet.getVertex(currentElement.m_data[(m + 1) % elementSize]));
                                    faceNormal.cross(edgeB, edgeC);
                                    normal.add(faceNormal);
                                    if (elem[j] == currentElement.m_data[(m + 1) % elementSize]) {
                                        if (currentElement.m_data[m] == link.m_data[k] && currentElement.m_data[(m + 2) % elementSize] == link.m_data[(k + 1) % linkSize]) {
                                            bFlip = false;
                                        } else if (currentElement.m_data[m] == link.m_data[(k + 1) % linkSize] && currentElement.m_data[(m + 2) % elementSize] == link.m_data[k]) {
                                            bFlip = true;
                                        } else {
                                            PsDebug.warning((String)"Some index is wrong.");
                                        }
                                    }
                                    ++m;
                                }
                                if (bFlip) {
                                    normal.multScalar(-1.0);
                                }
                            }
                            if (bChangeSign) {
                                normal.multScalar(-1.0);
                            }
                            vertexNormal[elem[j]].add(normal);
                            ++k;
                        }
                        bComputed[elem[j]] = true;
                    }
                    ++j;
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < numVertices) {
            vertexNormal[i2].normalize();
            ++i2;
        }
        return true;
    }

    public boolean makeVertexNormals2inv() {
        int dim = this.m_elementSet.getDimOfVertices();
        if (dim != 3) {
            return false;
        }
        this.m_elementSet.assureVertexNormals();
        int dimOfVectors = this.m_elementSet.getDimOfVectors();
        PdVector edgeB = new PdVector(dim);
        PdVector edgeC = new PdVector(dim);
        PdVector normal = new PdVector(dimOfVectors);
        PdVector facNor = new PdVector(dimOfVectors);
        int maxDimOfElements = this.m_elementSet.getMaxDimOfElements();
        boolean[] bRegular = new boolean[maxDimOfElements];
        PdVector[] vertexNormal = this.m_elementSet.getVertexNormals();
        PdVector.setConstant((PdVector[])vertexNormal, (double)0.0);
        int numElements = this.m_elementSet.getNumElements();
        int numVertices = this.m_elementSet.getNumVertices();
        PiVector[] element = this.m_elementSet.getElements();
        int i = 0;
        while (i < numElements) {
            int numEdges = element[i].getSize();
            if (numEdges >= 3) {
                double area;
                if (numEdges > maxDimOfElements && numEdges > bRegular.length) {
                    bRegular = new boolean[maxDimOfElements + numEdges];
                    PsDebug.warning((String)("dimension of an element = " + numEdges + " too large."));
                }
                if (!((area = this.m_elementSet.getAreaOfElement(i)) < 1.0E-10)) {
                    int vertexInd;
                    int[] elem = this.m_elementSet.getElement((int)i).m_data;
                    PdVector vertexB = this.m_elementSet.getVertex(elem[(-2 + numEdges) % numEdges]);
                    PdVector vertexC = this.m_elementSet.getVertex(elem[(-1 + numEdges) % numEdges]);
                    edgeB.sub(vertexC, vertexB);
                    boolean bVoidFace = false;
                    facNor.setConstant(0.0);
                    int j = 0;
                    while (j < numEdges) {
                        vertexInd = elem[(j - 1 + numEdges) % numEdges];
                        vertexB = vertexC;
                        vertexC = this.m_elementSet.getVertex(elem[j]);
                        edgeC.sub(vertexC, vertexB);
                        boolean bOk = normal.cross(edgeB, edgeC);
                        edgeB.copyArray(edgeC);
                        if (normal.sqrLength() > 1.0E-10) {
                            normal.multScalar(1.0 / normal.sqrLength());
                        }
                        boolean bl = bRegular[j] = bOk && normal.length() > 1.0E-10;
                        if (bRegular[j]) {
                            if (PdVector.angle((PdVector)vertexNormal[vertexInd], (PdVector)normal) > 135.0) {
                                vertexNormal[vertexInd].sub(normal);
                            } else {
                                vertexNormal[vertexInd].add(normal);
                            }
                            facNor.add(normal);
                        } else {
                            bVoidFace = true;
                        }
                        ++j;
                    }
                    if (bVoidFace) {
                        facNor.setLength(2.0 * area);
                        j = 0;
                        while (j < numEdges) {
                            vertexInd = elem[(j - 1 + numEdges) % numEdges];
                            if (!bRegular[j]) {
                                if (PdVector.angle((PdVector)vertexNormal[vertexInd], (PdVector)normal) > 135.0) {
                                    vertexNormal[vertexInd].sub(facNor);
                                } else {
                                    vertexNormal[vertexInd].add(facNor);
                                }
                            }
                            ++j;
                        }
                    }
                }
            }
            ++i;
        }
        i = 0;
        while (i < numVertices) {
            vertexNormal[i].normalize();
            ++i;
        }
        return true;
    }
}

