/*
 * Decompiled with CFR 0.152.
 */
package dev.geom;

import dev.geom.PwHausdorffDistance;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import jv.geom.PgElementSet;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.objectGui.PsList;
import jv.objectGui.PsMultiLineLabel;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.viewer.PvDisplay;
import jvx.project.PjWorkshop_IP;

public class PwHausdorffDistance_IP
extends PjWorkshop_IP
implements ActionListener,
ItemListener {
    protected PwHausdorffDistance m_pjElementSetDistance;
    protected Vector m_geomList;
    protected List m_listActive;
    protected List m_listPassive;
    protected Button m_bCompDistance;
    protected Button m_bSplitToComponents;
    protected CheckboxGroup m_chgCubeSize;
    protected Checkbox m_chAutoCubeSize;
    protected Checkbox m_chManualCubeSize;
    protected CheckboxGroup m_distVis;
    protected Checkbox m_distOnly;
    protected Checkbox m_autoDist;
    protected Checkbox m_scaFieldDist;
    protected PsMultiLineLabel m_lResult;
    protected Panel m_pCubeSize;
    protected Panel m_pSampleSteps;

    public PwHausdorffDistance_IP() {
        this.setTitle(PsConfig.getMessage((boolean)true, (int)54000, (String)"Compute Hausdorff distance"));
        if (this.getClass() == PwHausdorffDistance_IP.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.addSubTitle("Comparison surfaces");
        this.add((Component)new PsMultiLineLabel("Select the element sets from which (left) to which (right) the non-symmetrical Hausdorff distance is requested:"));
        Panel pGeometries = new Panel();
        pGeometries.setLayout(new GridLayout(1, 2));
        Panel Passive = new Panel(new BorderLayout());
        Label PassiveLabel = new Label("Pivot Surface");
        Passive.add((Component)PassiveLabel, "North");
        this.m_listPassive = new PsList(5, true);
        this.m_listPassive.setMultipleMode(false);
        Passive.add((Component)this.m_listPassive, "Center");
        pGeometries.add(Passive);
        Panel Active = new Panel(new BorderLayout());
        Label ActiveLabel = new Label("Reference Surface");
        Active.add((Component)ActiveLabel, "North");
        this.m_listActive = new PsList(5, true);
        this.m_listActive.setMultipleMode(false);
        Active.add((Component)this.m_listActive, "Center");
        pGeometries.add(Active);
        this.add(pGeometries);
        this.addSubTitle("Sampling density");
        this.add((Component)new PsMultiLineLabel("Select the size of the cubes of the internally used uniform grid (will only affect execution speed, not the result)."));
        Panel pSelect = new Panel(new GridLayout(1, 3));
        pSelect.add(new Label("Select cube size:"));
        this.m_chgCubeSize = new CheckboxGroup();
        this.m_chAutoCubeSize = new Checkbox("Auto select", true, this.m_chgCubeSize);
        this.m_chAutoCubeSize.addItemListener(this);
        pSelect.add(this.m_chAutoCubeSize);
        this.m_chManualCubeSize = new Checkbox("Manually select", false, this.m_chgCubeSize);
        this.m_chManualCubeSize.addItemListener(this);
        pSelect.add(this.m_chManualCubeSize);
        this.add(pSelect);
        this.m_pCubeSize = new Panel(new GridLayout(1, 1));
        this.add(this.m_pCubeSize);
        this.add((Component)new PsMultiLineLabel("Select the number of times the triangles should be subsampled to obtain a higher accuracy."));
        this.m_pSampleSteps = new Panel(new GridLayout(1, 1));
        this.add(this.m_pSampleSteps);
        this.addSubTitle("Visualization");
        Panel vSelect = new Panel(new GridLayout(1, 3));
        this.m_distVis = new CheckboxGroup();
        this.m_distOnly = new Checkbox("Dist Only", true, this.m_distVis);
        this.m_distOnly.addItemListener(this);
        vSelect.add(this.m_distOnly);
        this.m_autoDist = new Checkbox("Color", false, this.m_distVis);
        this.m_autoDist.addItemListener(this);
        vSelect.add(this.m_autoDist);
        this.m_scaFieldDist = new Checkbox("Scalar Field", false, this.m_distVis);
        this.m_scaFieldDist.addItemListener(this);
        vSelect.add(this.m_scaFieldDist);
        this.add(vSelect);
        this.addSubTitle("Result");
        this.m_lResult = new PsMultiLineLabel("maximal dist:\naverage dist:\n");
        this.add((Component)this.m_lResult);
        this.m_bCompDistance = new Button("Compute Hausdorff distance");
        this.m_bCompDistance.addActionListener(this);
        this.add(this.m_bCompDistance);
    }

    public Dimension getDialogSize() {
        return new Dimension(350, 700);
    }

    public String getNotice() {
        return "Computes and visualizes (an approximation of) the non-symmetrical Hausdorff distance between two element sets. For all vertices plus additional points on the elementsof the pivot surface their distance to the reference surface is computed.";
    }

    public void setParent(PsUpdateIf parent) {
        super.setParent(parent);
        this.m_pjElementSetDistance = (PwHausdorffDistance)parent;
        PsPanel ip = this.m_pjElementSetDistance.m_userCubeSize.getInfoPanel();
        ip.setEnabled(false);
        this.m_pCubeSize.add((Component)ip);
        this.m_pSampleSteps.add((Component)this.m_pjElementSetDistance.m_sampleSteps.getInfoPanel());
        Vector displays = this.m_pjElementSetDistance.getGeometry().getDisplayList();
        int numDisplays = displays.size();
        this.m_geomList = new Vector();
        int i = 0;
        while (i < numDisplays) {
            PvDisplay disp = (PvDisplay)displays.elementAt(i);
            PgGeometryIf[] geomList = disp.getGeometries();
            int numGeom = geomList.length;
            int j = 0;
            while (j < numGeom) {
                if (!this.m_geomList.contains(geomList[j]) && geomList[j].getType() == 33) {
                    this.m_geomList.addElement(geomList[j]);
                }
                ++j;
            }
            ++i;
        }
        int nog = this.m_geomList.size();
        this.m_listActive.removeAll();
        this.m_listPassive.removeAll();
        int i2 = 0;
        while (i2 < nog) {
            String name = ((PgGeometryIf)this.m_geomList.elementAt(i2)).getName();
            this.m_listPassive.add(name);
            this.m_listActive.add(name);
            ++i2;
        }
        this.validate();
    }

    public boolean update(Object object) {
        PsDebug.notify((String)"called");
        if (this.m_pjElementSetDistance == null) {
            PsDebug.warning((String)"missing workshop");
            return true;
        }
        if (object == this.m_pjElementSetDistance) {
            return true;
        }
        return super.update(object);
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (event.getSource() == this.m_chAutoCubeSize) {
            this.m_pjElementSetDistance.m_userCubeSize.getInfoPanel().setEnabled(false);
            this.m_pjElementSetDistance.setCubeSize(-1.0);
        } else if (event.getSource() == this.m_chManualCubeSize) {
            this.m_pjElementSetDistance.m_userCubeSize.getInfoPanel().setEnabled(true);
            this.m_pjElementSetDistance.setCubeSize(this.m_pjElementSetDistance.m_userCubeSize.getValue());
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.m_bCompDistance) {
            Color bg = this.m_bCompDistance.getBackground();
            this.m_bCompDistance.setLabel(PsConfig.getMessage((int)54350));
            this.m_bCompDistance.setBackground(Color.red);
            this.m_bCompDistance.setEnabled(false);
            int numGeomA = this.m_listActive.getItemCount();
            int numGeomP = this.m_listPassive.getItemCount();
            int i = 0;
            while (i < numGeomP) {
                if (this.m_listPassive.isIndexSelected(i)) {
                    PgElementSet passGeom = (PgElementSet)this.m_geomList.elementAt(i);
                    int j = 0;
                    while (j < numGeomA) {
                        if (this.m_listActive.isIndexSelected(j)) {
                            this.m_pjElementSetDistance.setGeometry((PgGeometry)passGeom);
                            PgElementSet refGeom = (PgElementSet)this.m_geomList.elementAt(j);
                            if (!refGeom.hasElementNormals()) {
                                refGeom.assureElementNormals();
                                refGeom.makeElementNormals();
                            }
                            double[] dist = new double[]{0.0, 0.0};
                            dist = this.m_distOnly.getState() ? this.m_pjElementSetDistance.computeDistance(passGeom, refGeom, this.m_bCompDistance) : (this.m_autoDist.getState() ? this.m_pjElementSetDistance.autoColorcomputeDist(passGeom, refGeom, this.m_bCompDistance) : this.m_pjElementSetDistance.scaFieldcomputeDist(passGeom, refGeom, this.m_bCompDistance));
                            double bbDiag = passGeom.getDiameter();
                            this.m_lResult.setText("maximal dist: " + dist[0] + "\n\t(" + dist[0] / bbDiag * 100.0 + "% of bbox)\n" + "average dist: " + dist[1] + "\n\t(" + dist[1] / bbDiag * 100.0 + "% of bbox)");
                            this.m_lResult.repaint();
                            break;
                        }
                        ++j;
                    }
                    passGeom.update((Object)passGeom);
                    break;
                }
                ++i;
            }
            this.m_bCompDistance.setLabel("Compute Hausdorff Distance");
            this.m_bCompDistance.setBackground(bg);
            this.m_bCompDistance.setEnabled(true);
        } else {
            super.actionPerformed(event);
        }
    }
}

