/*
 * Decompiled with CFR 0.152.
 */
package dev.geom;

import dev.vecmath.PiDynVector;
import java.awt.Button;
import java.awt.Color;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygon;
import jv.geom.PgVectorField;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.project.PgGeometry;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.project.PjWorkshop;
import jvx.thirdParty.acmeGui.YesNoBox;
import jvx.util.PuPriorityQueue;

public class PwHausdorffDistance
extends PjWorkshop {
    protected PgElementSet m_S1;
    protected PgElementSet m_S2;
    protected PiDynVector[] m_cubesElements;
    protected double m_cubeSize = -1.0;
    protected boolean m_autoCubeSize = true;
    protected PiVector m_numCubes;
    protected PdVector m_gridStart;
    protected int m_numTotalCubes;
    protected PgPolygon m_poly3 = new PgPolygon(3);
    protected PgPolygon m_poly4;
    protected PgPolygon m_poly5;
    protected PgVectorField m_diff;
    protected PgVectorField m_dist;
    protected PuInteger m_sampleSteps;
    protected PuDouble m_userCubeSize;
    protected static final int X = 0;
    protected static final int Y = 1;
    protected static final int Z = 2;
    protected static final int TOP = 1;
    protected static final int BOTTOM = -1;

    public PwHausdorffDistance() {
        super(PsConfig.getMessage((int)48008));
        this.m_poly3.setClosed(true);
        this.m_poly3.setNumVertices(3);
        this.m_poly4 = new PgPolygon(3);
        this.m_poly4.setClosed(true);
        this.m_poly4.setNumVertices(4);
        this.m_poly5 = new PgPolygon(3);
        this.m_poly5.setClosed(true);
        this.m_poly5.setNumVertices(4);
        if (((Object)((Object)this)).getClass() == PwHausdorffDistance.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_sampleSteps = new PuInteger("Sample Steps");
        this.m_sampleSteps.setBounds(0, 5);
        this.m_sampleSteps.setValue(0);
        this.m_userCubeSize = new PuDouble("Cube Size");
        this.m_userCubeSize.setBounds(0.1, 5.0);
        this.m_userCubeSize.setValue(0.2);
    }

    public void setCubeSize(double size) {
        if (size <= 0.0) {
            this.m_autoCubeSize = true;
        } else {
            this.m_userCubeSize.setValue(size);
            this.m_autoCubeSize = false;
        }
    }

    protected PdVector[] getCommonBoundingBox(PgGeometry g1, PgGeometry g2) {
        PdVector[] box1 = g1.getAmbientBounds();
        PdVector[] box2 = g2.getAmbientBounds();
        PdVector bbMin = PdVector.copyNew((PdVector)box1[0]);
        PdVector bbMax = PdVector.copyNew((PdVector)box1[1]);
        bbMin.min(box2[0]);
        bbMax.max(box2[1]);
        PdVector[] box = new PdVector[]{bbMin, bbMax};
        return box;
    }

    protected void createGrid(PdVector start, PdVector end) {
        if (this.m_autoCubeSize) {
            double avgArea = this.m_S2.getArea() / (double)this.m_S2.getNumElements();
            this.m_cubeSize = Math.sqrt(4.0 * avgArea / Math.sqrt(3.0));
            this.m_userCubeSize.setValue(this.m_cubeSize);
        } else {
            this.m_cubeSize = this.m_userCubeSize.getValue();
        }
        this.m_gridStart = PdVector.copyNew((PdVector)start);
        PdVector diag = PdVector.subNew((PdVector)end, (PdVector)start);
        diag.multScalar(1.0 / this.m_cubeSize);
        this.m_numCubes = new PiVector((int)Math.ceil(diag.getEntry(0)), (int)Math.ceil(diag.getEntry(1)), (int)Math.ceil(diag.getEntry(2)));
        this.m_numTotalCubes = this.m_numCubes.getEntry(0) * this.m_numCubes.getEntry(1) * this.m_numCubes.getEntry(2);
        this.m_cubesElements = new PiDynVector[this.m_numTotalCubes];
    }

    protected void computeCubeIntersections(int elemIndex) {
        PdVector normal = this.m_S2.getElementNormal(elemIndex);
        if (normal == null) {
            return;
        }
        PdVector[] triVert = this.m_S2.getElementVertices(elemIndex);
        int ZDIR = normal.indexOfAbsMax();
        int i = 0;
        while (i <= 1) {
            int j = i + 1;
            while (j <= 2) {
                if (triVert[i].getEntry(ZDIR) > triVert[j].getEntry(ZDIR)) {
                    PdVector temp = triVert[i];
                    triVert[i] = triVert[j];
                    triVert[j] = temp;
                }
                ++j;
            }
            ++i;
        }
        PdVector A = triVert[2];
        PdVector B = triVert[1];
        PdVector C = triVert[0];
        int zA = this.getCubeFromPoint(A).getEntry(ZDIR);
        int zB = this.getCubeFromPoint(B).getEntry(ZDIR);
        int zC = this.getCubeFromPoint(C).getEntry(ZDIR);
        PdVector[] acCutVertices = new PdVector[zA - zC];
        PdVector[] otherCutVertices = new PdVector[zA - zC];
        PdVector AC = PdVector.subNew((PdVector)C, (PdVector)A);
        PdVector AB = PdVector.subNew((PdVector)B, (PdVector)A);
        PdVector BC = PdVector.subNew((PdVector)C, (PdVector)B);
        int i2 = 0;
        int k = zA;
        while (k > zC) {
            double z = this.m_gridStart.getEntry(ZDIR) + (double)k * this.m_cubeSize;
            double mu = (z - A.getEntry(ZDIR)) / AC.getEntry(ZDIR);
            PdVector ACScaled = PdVector.copyNew((PdVector)AC);
            ACScaled.multScalar(mu);
            acCutVertices[i2] = PdVector.addNew((PdVector)A, (PdVector)ACScaled);
            if (B.getEntry(ZDIR) < z) {
                mu = (z - A.getEntry(ZDIR)) / AB.getEntry(ZDIR);
                PdVector ABScaled = PdVector.copyNew((PdVector)AB);
                ABScaled.multScalar(mu);
                otherCutVertices[i2] = PdVector.addNew((PdVector)A, (PdVector)ABScaled);
            } else {
                mu = (z - B.getEntry(ZDIR)) / BC.getEntry(ZDIR);
                PdVector BCScaled = PdVector.copyNew((PdVector)BC);
                BCScaled.multScalar(mu);
                otherCutVertices[i2] = PdVector.addNew((PdVector)B, (PdVector)BCScaled);
            }
            ++i2;
            --k;
        }
        i2 = 0;
        int k2 = zA;
        while (k2 >= zC) {
            PgPolygon poly;
            if (k2 == zA) {
                if (k2 == zB) {
                    if (k2 == zC) {
                        poly = this.m_poly3;
                        poly.setVertex(0, A);
                        poly.setVertex(1, B);
                        poly.setVertex(2, C);
                    } else {
                        poly = this.m_poly4;
                        poly.setVertex(0, A);
                        poly.setVertex(1, B);
                        poly.setVertex(2, otherCutVertices[0]);
                        poly.setVertex(3, acCutVertices[0]);
                    }
                } else {
                    poly = this.m_poly3;
                    poly.setVertex(0, A);
                    poly.setVertex(1, acCutVertices[0]);
                    poly.setVertex(2, otherCutVertices[0]);
                }
            } else if (k2 == zB) {
                if (k2 == zC) {
                    poly = this.m_poly4;
                    poly.setVertex(0, C);
                    poly.setVertex(1, B);
                    poly.setVertex(2, otherCutVertices[i2 - 1]);
                    poly.setVertex(3, acCutVertices[i2 - 1]);
                } else {
                    poly = this.m_poly5;
                    poly.setVertex(0, otherCutVertices[i2]);
                    poly.setVertex(1, B);
                    poly.setVertex(2, otherCutVertices[i2 - 1]);
                    poly.setVertex(3, acCutVertices[i2 - 1]);
                    poly.setVertex(4, acCutVertices[i2]);
                }
            } else if (k2 == zC) {
                poly = this.m_poly3;
                poly.setVertex(0, C);
                poly.setVertex(1, acCutVertices[i2 - 1]);
                poly.setVertex(2, otherCutVertices[i2 - 1]);
            } else {
                poly = this.m_poly4;
                poly.setVertex(0, otherCutVertices[i2]);
                poly.setVertex(1, otherCutVertices[i2 - 1]);
                poly.setVertex(2, acCutVertices[i2 - 1]);
                poly.setVertex(3, acCutVertices[i2]);
            }
            ++i2;
            this.scanConvertPolygon2d(elemIndex, poly, k2, ZDIR);
            --k2;
        }
    }

    protected void scanConvertPolygon2d(int elemIndex, PgPolygon poly, int z, int ZDIR) {
        int XDIR = ZDIR == 0 ? 1 : 0;
        int YDIR = 3 - ZDIR - XDIR;
        PdVector highestCoords = new PdVector(3);
        PdVector smallestCoords = new PdVector(3);
        PdVector.max((PdVector)highestCoords, (PdVector[])poly.getVertices(), (int)poly.getNumVertices());
        PdVector.min((PdVector)smallestCoords, (PdVector[])poly.getVertices(), (int)poly.getNumVertices());
        PdVector diff = PdVector.subNew((PdVector)highestCoords, (PdVector)smallestCoords);
        if (diff.getEntry(XDIR) > diff.getEntry(YDIR)) {
            YDIR = ZDIR == 0 ? 1 : 0;
            XDIR = 3 - ZDIR - YDIR;
        }
        int leftIdx = 0;
        int rightIdx = 0;
        int i = 1;
        while (i < poly.getNumVertices()) {
            if (poly.getVertex(i).getEntry(XDIR) < poly.getVertex(leftIdx).getEntry(XDIR)) {
                leftIdx = i;
            }
            if (poly.getVertex(i).getEntry(XDIR) > poly.getVertex(rightIdx).getEntry(XDIR)) {
                rightIdx = i;
            }
            ++i;
        }
        int len = poly.getNumVertices();
        PdVector v = new PdVector(poly.getVertex(leftIdx).getEntry(XDIR), poly.getVertex(leftIdx).getEntry(YDIR));
        PdVector next = new PdVector(poly.getVertex((leftIdx + 1) % len).getEntry(XDIR), poly.getVertex((leftIdx + 1) % len).getEntry(YDIR));
        PdVector prev = new PdVector(poly.getVertex((leftIdx + len - 1) % len).getEntry(XDIR), poly.getVertex((leftIdx + len - 1) % len).getEntry(YDIR));
        PdVector down = PdVector.addNew((PdVector)v, (PdVector)new PdVector(0.0, -1.0));
        double alpha = PdVector.angle((PdVector)v, (PdVector)down, (PdVector)next);
        double beta = PdVector.angle((PdVector)v, (PdVector)down, (PdVector)prev);
        int topDir = 0;
        topDir = alpha > beta ? 1 : -1;
        int leftCubeIdx = (int)Math.floor((poly.getVertex(leftIdx).getEntry(XDIR) - this.m_gridStart.getEntry(XDIR)) / this.m_cubeSize);
        int rightCubeIdx = (int)Math.floor((poly.getVertex(rightIdx).getEntry(XDIR) - this.m_gridStart.getEntry(XDIR)) / this.m_cubeSize);
        int[] topBorder = new int[rightCubeIdx - leftCubeIdx + 1];
        int[] bottomBorder = new int[rightCubeIdx - leftCubeIdx + 1];
        boolean[] topBorderSet = new boolean[rightCubeIdx - leftCubeIdx + 1];
        boolean[] bottomBorderSet = new boolean[rightCubeIdx - leftCubeIdx + 1];
        int i2 = leftCubeIdx;
        while (i2 <= rightCubeIdx) {
            topBorderSet[i2 - leftCubeIdx] = false;
            bottomBorderSet[i2 - leftCubeIdx] = false;
            ++i2;
        }
        int pass = 1;
        while (pass >= -1) {
            int currIdx = leftIdx;
            while (currIdx != rightIdx) {
                double y;
                int nextIdx = (currIdx + len + topDir * pass) % len;
                PdVector a = poly.getVertex(currIdx);
                PdVector b = poly.getVertex(nextIdx);
                double dy = b.getEntry(YDIR) - a.getEntry(YDIR);
                double dx = b.getEntry(XDIR) - a.getEntry(XDIR);
                double n = b.getEntry(YDIR) - dy / dx * b.getEntry(XDIR);
                int direction = PwHausdorffDistance.signum(dy);
                int cubeDiff = (int)Math.floor(Math.abs(dy / dx)) * direction;
                int iStart = (int)Math.floor((a.getEntry(XDIR) - this.m_gridStart.getEntry(XDIR)) / this.m_cubeSize);
                int jStart = (int)Math.floor((a.getEntry(YDIR) - this.m_gridStart.getEntry(YDIR)) / this.m_cubeSize);
                int iEnd = (int)Math.floor((b.getEntry(XDIR) - this.m_gridStart.getEntry(XDIR)) / this.m_cubeSize);
                int jEnd = (int)Math.floor((b.getEntry(YDIR) - this.m_gridStart.getEntry(YDIR)) / this.m_cubeSize);
                int loopDiff = 0;
                int j = 0;
                if (dy >= 0.0 && pass == 1 || dy < 0.0 && pass == -1) {
                    y = ((double)(iStart + 1) * this.m_cubeSize + this.m_gridStart.getEntry(XDIR)) * (dy / dx) + n;
                    j = (int)Math.floor((y - this.m_gridStart.getEntry(YDIR)) / this.m_cubeSize);
                    j = pass == 1 ? Math.min(j, jEnd) : Math.max(j, jEnd);
                    loopDiff = 1;
                    if (pass == 1) {
                        PwHausdorffDistance.setTopBorder(topBorder, topBorderSet, iStart, j, leftCubeIdx);
                        PwHausdorffDistance.setTopBorder(topBorder, topBorderSet, iEnd, jEnd, leftCubeIdx);
                    } else {
                        PwHausdorffDistance.setBottomBorder(bottomBorder, bottomBorderSet, iStart, j, leftCubeIdx);
                        PwHausdorffDistance.setBottomBorder(bottomBorder, bottomBorderSet, iEnd, jEnd, leftCubeIdx);
                    }
                } else {
                    if (pass == 1) {
                        PwHausdorffDistance.setTopBorder(topBorder, topBorderSet, iStart, jStart, leftCubeIdx);
                    } else {
                        PwHausdorffDistance.setBottomBorder(bottomBorder, bottomBorderSet, iStart, jStart, leftCubeIdx);
                    }
                    y = ((double)iStart * this.m_cubeSize + this.m_gridStart.getEntry(XDIR)) * (dy / dx) + n;
                    j = (int)Math.floor((y - this.m_gridStart.getEntry(YDIR)) / this.m_cubeSize);
                }
                double errTerm = dy >= 0.0 && pass == 1 ? (dy * (this.m_gridStart.getEntry(XDIR) + this.m_cubeSize * (double)(iStart + 2)) + dx * n - dx * (this.m_gridStart.getEntry(YDIR) + this.m_cubeSize * ((double)j + Math.floor(dy / dx) + 1.0))) / this.m_cubeSize : (dy < 0.0 && pass == -1 ? (dy * (this.m_gridStart.getEntry(XDIR) + this.m_cubeSize * (double)(iStart + 2)) + dx * n - dx * (this.m_gridStart.getEntry(YDIR) + this.m_cubeSize * ((double)j + Math.ceil(dy / dx)))) / this.m_cubeSize : (dy < 0.0 && pass == 1 ? (dy * (this.m_gridStart.getEntry(XDIR) + this.m_cubeSize * (double)(iStart + 1)) + dx * n - dx * (this.m_gridStart.getEntry(YDIR) + this.m_cubeSize * ((double)j + Math.ceil(dy / dx)))) / this.m_cubeSize : (dy * (this.m_gridStart.getEntry(XDIR) + this.m_cubeSize * (double)(iStart + 1)) + dx * n - dx * (this.m_gridStart.getEntry(YDIR) + this.m_cubeSize * ((double)j + Math.floor(dy / dx) + 1.0))) / this.m_cubeSize));
                double bigStep = dy - dx * (double)(cubeDiff + direction);
                double smallStep = dy - dx * (double)cubeDiff;
                int i3 = iStart + 1;
                while (i3 <= iEnd - loopDiff) {
                    if (errTerm * (double)direction > 0.0) {
                        j += cubeDiff + direction;
                        errTerm += bigStep;
                    } else {
                        j += cubeDiff;
                        errTerm += smallStep;
                    }
                    if (pass == 1) {
                        PwHausdorffDistance.setTopBorder(topBorder, topBorderSet, i3, j, leftCubeIdx);
                    } else {
                        PwHausdorffDistance.setBottomBorder(bottomBorder, bottomBorderSet, i3, j, leftCubeIdx);
                    }
                    ++i3;
                }
                currIdx = (currIdx + len + topDir * pass) % len;
            }
            pass -= 2;
        }
        PiVector cube = new PiVector(3);
        cube.setEntry(ZDIR, z);
        int i4 = leftCubeIdx;
        while (i4 <= rightCubeIdx) {
            cube.setEntry(XDIR, i4);
            int j = bottomBorder[i4 - leftCubeIdx];
            while (j <= topBorder[i4 - leftCubeIdx]) {
                cube.setEntry(YDIR, j);
                int cIdx = this.cubeIdx(cube);
                if (this.m_cubesElements[cIdx] == null) {
                    this.m_cubesElements[cIdx] = new PiDynVector(0, 2);
                }
                this.m_cubesElements[cIdx].appendEntry(elemIndex);
                ++j;
            }
            ++i4;
        }
    }

    protected double computeDistanceForVertex(PdVector v, int vIdx, CubeIterator iter, PiDynVector examinedFaces) {
        PdVector tmp = new PdVector(3);
        PdVector proj = new PdVector(3);
        PdVector dir0 = new PdVector(3);
        PdVector dir1 = new PdVector(3);
        PdVector dir2 = new PdVector(3);
        double minDist = Double.MAX_VALUE;
        PdVector closestVertex = new PdVector(3);
        PdVector reallyClosestVertex = new PdVector(3);
        PdVector[] vertexS2 = this.m_S2.getVertices();
        iter.init(v);
        while (iter.hasNext()) {
            int cubeIdx = iter.next();
            if (this.m_cubesElements[cubeIdx] == null) continue;
            int size = this.m_cubesElements[cubeIdx].getSize();
            int i = 0;
            while (i < size) {
                int elemIdx = this.m_cubesElements[cubeIdx].getEntry(i);
                if (examinedFaces.indexOf(elemIdx) <= 0) {
                    PdVector C;
                    PdVector B;
                    PdVector A;
                    examinedFaces.appendEntry(elemIdx);
                    PiVector element = this.m_S2.getElement(elemIdx);
                    double[] angles = new double[3];
                    PdVector.angle((double[])angles, (PdVector)vertexS2[element.getEntry(0)], (PdVector)vertexS2[element.getEntry(1)], (PdVector)vertexS2[element.getEntry(2)]);
                    int obtuseAngle = -1;
                    int k = 0;
                    while (k < 3) {
                        if (angles[k] > 1.5707963267948966) {
                            obtuseAngle = k;
                            break;
                        }
                        ++k;
                    }
                    if (obtuseAngle >= 0) {
                        A = vertexS2[element.getEntry(obtuseAngle)];
                        B = vertexS2[element.getEntry((obtuseAngle + 1) % 3)];
                        C = vertexS2[element.getEntry((obtuseAngle + 2) % 3)];
                    } else {
                        A = vertexS2[element.getEntry(0)];
                        B = vertexS2[element.getEntry(1)];
                        C = vertexS2[element.getEntry(2)];
                    }
                    dir0.sub(B, A);
                    dir1.sub(C, A);
                    double a = PdVector.dot((PdVector)dir0, (PdVector)dir0);
                    double b = PdVector.dot((PdVector)dir0, (PdVector)dir1);
                    double c = PdVector.dot((PdVector)dir1, (PdVector)dir1);
                    tmp.sub(A, v);
                    double d = PdVector.dot((PdVector)dir0, (PdVector)tmp);
                    double e = PdVector.dot((PdVector)dir1, (PdVector)tmp);
                    double det = a * c - b * b;
                    if (det != 0.0) {
                        double s = b * e - c * d;
                        double t = b * d - a * e;
                        int region = s + t <= det ? (s < 0.0 ? (t < 0.0 ? 4 : 3) : (t < 0.0 ? 5 : 0)) : (s < 0.0 ? 2 : (t < 0.0 ? 6 : 1));
                        double sqrDist = -1.0;
                        switch (region) {
                            case 0: {
                                proj.blendBase(A, s / det, dir0, t / det, dir1);
                                sqrDist = PdVector.sqrDist((PdVector)v, (PdVector)proj);
                                closestVertex = proj;
                                break;
                            }
                            case 2: 
                            case 6: {
                                PdVector P = region == 2 ? C : B;
                                sqrDist = PdVector.sqrDist((PdVector)P, (PdVector)v);
                                closestVertex = P;
                                break;
                            }
                            case 4: {
                                if (obtuseAngle == -1) {
                                    sqrDist = PdVector.sqrDist((PdVector)A, (PdVector)v);
                                    closestVertex = A;
                                    break;
                                }
                                double s_ = -PdVector.dot((PdVector)tmp, (PdVector)dir0);
                                double t_ = -PdVector.dot((PdVector)tmp, (PdVector)dir1);
                                if (s_ < 0.0) {
                                    if (t_ < 0.0) {
                                        sqrDist = PdVector.sqrDist((PdVector)A, (PdVector)v);
                                        closestVertex = A;
                                        break;
                                    }
                                    if (t_ > c) {
                                        sqrDist = PdVector.sqrDist((PdVector)C, (PdVector)v);
                                        closestVertex = C;
                                        break;
                                    }
                                    proj.blendBase(A, t_ / c, dir1);
                                    sqrDist = PdVector.sqrDist((PdVector)v, (PdVector)proj);
                                    closestVertex = proj;
                                    break;
                                }
                                if (s_ > a) {
                                    sqrDist = PdVector.sqrDist((PdVector)B, (PdVector)v);
                                    closestVertex = B;
                                    break;
                                }
                                proj.blendBase(A, s_ / a, dir0);
                                sqrDist = PdVector.sqrDist((PdVector)v, (PdVector)proj);
                                closestVertex = proj;
                                break;
                            }
                            case 1: {
                                dir2.sub(dir1, dir0);
                                double t_ = -(PdVector.dot((PdVector)B, (PdVector)dir2) - PdVector.dot((PdVector)v, (PdVector)dir2));
                                if (t_ < 0.0) {
                                    sqrDist = PdVector.sqrDist((PdVector)B, (PdVector)v);
                                    closestVertex = B;
                                    break;
                                }
                                if (t_ > dir2.sqrLength()) {
                                    sqrDist = PdVector.sqrDist((PdVector)C, (PdVector)v);
                                    closestVertex = C;
                                    break;
                                }
                                proj.blendBase(B, t_ / dir2.sqrLength(), dir2);
                                sqrDist = PdVector.sqrDist((PdVector)v, (PdVector)proj);
                                closestVertex = proj;
                                break;
                            }
                            case 3: {
                                double t_ = -PdVector.dot((PdVector)tmp, (PdVector)dir1);
                                if (t_ < 0.0) {
                                    sqrDist = PdVector.sqrDist((PdVector)A, (PdVector)v);
                                    closestVertex = A;
                                    break;
                                }
                                if (t_ > c) {
                                    sqrDist = PdVector.sqrDist((PdVector)C, (PdVector)v);
                                    closestVertex = C;
                                    break;
                                }
                                proj.blendBase(A, t_ / c, dir1);
                                sqrDist = PdVector.sqrDist((PdVector)v, (PdVector)proj);
                                closestVertex = proj;
                                break;
                            }
                            case 5: {
                                double t_ = -PdVector.dot((PdVector)tmp, (PdVector)dir0);
                                if (t_ < 0.0) {
                                    sqrDist = PdVector.sqrDist((PdVector)A, (PdVector)v);
                                    closestVertex = A;
                                    break;
                                }
                                if (t_ > a) {
                                    sqrDist = PdVector.sqrDist((PdVector)B, (PdVector)v);
                                    closestVertex = B;
                                    break;
                                }
                                proj.blendBase(A, t_ / a, dir0);
                                sqrDist = PdVector.sqrDist((PdVector)v, (PdVector)proj);
                                closestVertex = proj;
                            }
                        }
                        double dist = Math.sqrt(sqrDist);
                        if (dist < minDist) {
                            minDist = dist;
                            iter.setMinDist(minDist);
                            reallyClosestVertex.copy(closestVertex);
                        }
                    }
                }
                ++i;
            }
        }
        reallyClosestVertex.sub(v);
        this.m_diff.setVector(vIdx, reallyClosestVertex);
        this.m_dist.setVector(vIdx, minDist);
        return minDist;
    }

    public double[] computeDistance(PgElementSet elSet0, PgElementSet elSet1, Button butt) {
        this.m_S1 = elSet0;
        this.m_S2 = elSet1;
        if (elSet0 == elSet1) {
            PsDebug.error((String)"Please pass two different element sets!");
            double[] returnValue = new double[]{-1.0, -1.0};
            return returnValue;
        }
        if (this.m_S1.getDimOfVertices() != this.m_S2.getDimOfVertices() || this.m_S1.getDimOfVertices() != 3) {
            PsDebug.error((String)"Surfaces do not both lie in R^3");
            double[] returnValue = new double[]{-1.0, -1.0};
            return returnValue;
        }
        if (!this.m_S2.hasElementNormals()) {
            PsDebug.error((String)"Missing or wrong dimension of element normals of reference geometry.");
            double[] returnValue = new double[]{-1.0, -1.0};
            return returnValue;
        }
        if (this.m_S2.getDimOfElements() != 3) {
            YesNoBox triangBox = new YesNoBox(PsConfig.getFrame(), "Second geometry must be triangulated for this workshop; shall this be done now?");
            triangBox.setVisible(true);
            if (triangBox.getAnswer() == 1) {
                PgElementSet.triangulate((PgElementSet)this.m_S2);
            } else {
                double[] returnValue = new double[]{-1.0, -1.0};
                return returnValue;
            }
        }
        int i = 0;
        while (i < this.m_sampleSteps.getValue()) {
            this.m_S1.refineGlobalIntoFour(true);
            ++i;
        }
        this.m_diff = new PgVectorField(3);
        this.m_diff.setGeometry((PgPointSet)this.m_S1);
        this.m_S1.addVectorField(this.m_diff);
        this.m_dist = new PgVectorField(1);
        this.m_dist.setGeometry((PgPointSet)this.m_S1);
        this.m_S1.addVectorField(this.m_dist);
        this.m_S1.showVectorFields(false);
        PdVector[] box = this.getCommonBoundingBox((PgGeometry)this.m_S1, (PgGeometry)this.m_S2);
        this.createGrid(box[0], box[1]);
        int numElementsS2 = this.m_S2.getNumElements();
        int i2 = 0;
        while (i2 < numElementsS2) {
            if (i2 % 500 == 0) {
                butt.setLabel("Processing element index = " + i2);
            }
            this.computeCubeIntersections(i2);
            ++i2;
        }
        int usedCubes = 0;
        int maxTriangles = 0;
        int i3 = 0;
        while (i3 < this.m_numTotalCubes) {
            if (this.m_cubesElements[i3] != null) {
                ++usedCubes;
                if (this.m_cubesElements[i3].getSize() > maxTriangles) {
                    maxTriangles = this.m_cubesElements[i3].getSize();
                }
            }
            ++i3;
        }
        int[] usedCubes2 = new int[numElementsS2];
        int i4 = 0;
        while (i4 < this.m_numTotalCubes) {
            if (this.m_cubesElements[i4] != null) {
                int k = 0;
                while (k < this.m_cubesElements[i4].getSize()) {
                    int n = this.m_cubesElements[i4].getEntry(k);
                    usedCubes2[n] = usedCubes2[n] + 1;
                    ++k;
                }
            }
            ++i4;
        }
        int totalUsedCubes = 0;
        int i5 = 0;
        while (i5 < this.m_S2.getNumElements()) {
            totalUsedCubes += usedCubes2[i5];
            ++i5;
        }
        if (PsDebug.isNotify()) {
            System.out.println("used cubes: " + usedCubes + "/" + this.m_numTotalCubes + "\nmaximum number of triangles per cube: " + maxTriangles + "\naverage triangles per cube: " + (double)this.m_S2.getNumElements() / (double)usedCubes + "/" + (double)this.m_S2.getNumElements() / (double)this.m_numTotalCubes + "\naverage cubes per triangle: " + (double)totalUsedCubes / (double)this.m_S2.getNumElements());
        }
        PdVector[] vertexS1 = this.m_S1.getVertices();
        int numVerticesS1 = this.m_S1.getNumVertices();
        double[] dist = new double[numVerticesS1];
        CubeIterator iter = new CubeIterator(this);
        double maxDist = -1.7976931348623157E308;
        double totalDist = 0.0;
        PiDynVector examinedFaces = new PiDynVector(0, 15);
        int i6 = 0;
        while (i6 < numVerticesS1) {
            dist[i6] = this.computeDistanceForVertex(vertexS1[i6], i6, iter, examinedFaces);
            examinedFaces.setSize(0);
            totalDist += dist[i6];
            if (dist[i6] > maxDist) {
                maxDist = dist[i6];
            }
            ++i6;
        }
        double[] returnValue = new double[]{maxDist, totalDist / (double)numVerticesS1};
        return returnValue;
    }

    public double[] scaFieldcomputeDist(PgElementSet elSet0, PgElementSet elSet1, Button butt) {
        this.m_S1 = elSet0;
        this.m_S2 = elSet1;
        if (elSet0 == elSet1) {
            PsDebug.error((String)"Please pass two different element sets!");
            double[] returnValue = new double[]{-1.0, -1.0};
            return returnValue;
        }
        if (this.m_S1.getDimOfVertices() != this.m_S2.getDimOfVertices() || this.m_S1.getDimOfVertices() != 3) {
            PsDebug.error((String)"Surfaces do not both lie in R^3");
            double[] returnValue = new double[]{-1.0, -1.0};
            return returnValue;
        }
        if (!this.m_S2.hasElementNormals()) {
            PsDebug.error((String)"Missing or wrong dimension of element normals of reference geometry.");
            double[] returnValue = new double[]{-1.0, -1.0};
            return returnValue;
        }
        if (this.m_S2.getDimOfElements() != 3) {
            YesNoBox triangBox = new YesNoBox(PsConfig.getFrame(), "Second geometry must be triangulated for this workshop; shall this be done now?");
            triangBox.setVisible(true);
            if (triangBox.getAnswer() == 1) {
                PgElementSet.triangulate((PgElementSet)this.m_S2);
            } else {
                double[] returnValue = new double[]{-1.0, -1.0};
                return returnValue;
            }
        }
        int i = 0;
        while (i < this.m_sampleSteps.getValue()) {
            this.m_S1.refineGlobalIntoFour(true);
            ++i;
        }
        int novS2 = this.m_S2.getNumVertices();
        this.m_diff = new PgVectorField(3);
        this.m_diff.setGeometry((PgPointSet)this.m_S1);
        this.m_S1.addVectorField(this.m_diff);
        this.m_dist = new PgVectorField(1);
        this.m_dist.setGeometry((PgPointSet)this.m_S1);
        this.m_S1.addVectorField(this.m_dist);
        this.m_S1.showVectorFields(false);
        PgVectorField hausVecField_r = new PgVectorField(1);
        hausVecField_r.setGeometry((PgPointSet)this.m_S2);
        hausVecField_r.setName("Hausdoff Visualization at reference model");
        hausVecField_r.setNumVectors(novS2);
        this.m_S2.addVectorField(hausVecField_r);
        int novS1 = this.m_S1.getNumVertices();
        PgVectorField hausVecField = new PgVectorField(1);
        hausVecField.setGeometry((PgPointSet)this.m_S1);
        hausVecField.setName("Hausdoff Visualization at pivot model");
        hausVecField.setNumVectors(novS1);
        this.m_S1.addVectorField(hausVecField);
        PdVector[] box = this.getCommonBoundingBox((PgGeometry)this.m_S1, (PgGeometry)this.m_S2);
        this.createGrid(box[0], box[1]);
        int numElementsS2 = this.m_S2.getNumElements();
        int i2 = 0;
        while (i2 < numElementsS2) {
            if (i2 % 500 == 0) {
                butt.setLabel("Processing element index = " + i2);
            }
            this.computeCubeIntersections(i2);
            ++i2;
        }
        int usedCubes = 0;
        int maxTriangles = 0;
        int i3 = 0;
        while (i3 < this.m_numTotalCubes) {
            if (this.m_cubesElements[i3] != null) {
                ++usedCubes;
                if (this.m_cubesElements[i3].getSize() > maxTriangles) {
                    maxTriangles = this.m_cubesElements[i3].getSize();
                }
            }
            ++i3;
        }
        int[] usedCubes2 = new int[numElementsS2];
        int i4 = 0;
        while (i4 < this.m_numTotalCubes) {
            if (this.m_cubesElements[i4] != null) {
                int k = 0;
                while (k < this.m_cubesElements[i4].getSize()) {
                    int n = this.m_cubesElements[i4].getEntry(k);
                    usedCubes2[n] = usedCubes2[n] + 1;
                    ++k;
                }
            }
            ++i4;
        }
        int totalUsedCubes = 0;
        int i5 = 0;
        while (i5 < this.m_S2.getNumElements()) {
            totalUsedCubes += usedCubes2[i5];
            ++i5;
        }
        if (PsDebug.isNotify()) {
            System.out.println("used cubes: " + usedCubes + "/" + this.m_numTotalCubes + "\nmaximum number of triangles per cube: " + maxTriangles + "\naverage triangles per cube: " + (double)this.m_S2.getNumElements() / (double)usedCubes + "/" + (double)this.m_S2.getNumElements() / (double)this.m_numTotalCubes + "\naverage cubes per triangle: " + (double)totalUsedCubes / (double)this.m_S2.getNumElements());
        }
        PdVector[] vertexS1 = this.m_S1.getVertices();
        int numVerticesS1 = this.m_S1.getNumVertices();
        double[] dist = new double[numVerticesS1];
        CubeIterator iter = new CubeIterator(this);
        double maxDist = -1.7976931348623157E308;
        double totalDist = 0.0;
        PiDynVector examinedFaces = new PiDynVector(0, 15);
        int i6 = 0;
        while (i6 < numVerticesS1) {
            dist[i6] = this.computeDistanceForVertex(vertexS1[i6], i6, iter, examinedFaces);
            examinedFaces.setSize(0);
            hausVecField.setVector(i6, dist[i6]);
            hausVecField_r.setVector(i6, dist[i6]);
            totalDist += dist[i6];
            if (dist[i6] > maxDist) {
                maxDist = dist[i6];
            }
            ++i6;
        }
        this.m_S1.update((Object)this.m_S1);
        this.m_S2.update((Object)this.m_S2);
        double[] returnValue = new double[]{maxDist, totalDist / (double)numVerticesS1};
        return returnValue;
    }

    public double[] autoColorcomputeDist(PgElementSet elSet0, PgElementSet elSet1, Button butt) {
        this.m_S1 = elSet0;
        this.m_S2 = elSet1;
        if (elSet0 == elSet1) {
            PsDebug.error((String)"Please pass two different element sets!");
            double[] returnValue = new double[]{-1.0, -1.0};
            return returnValue;
        }
        if (this.m_S1.getDimOfVertices() != this.m_S2.getDimOfVertices() || this.m_S1.getDimOfVertices() != 3) {
            PsDebug.error((String)"Surfaces do not both lie in R^3");
            double[] returnValue = new double[]{-1.0, -1.0};
            return returnValue;
        }
        if (!this.m_S2.hasElementNormals()) {
            PsDebug.error((String)"Missing or wrong dimension of element normals of reference geometry.");
            double[] returnValue = new double[]{-1.0, -1.0};
            return returnValue;
        }
        if (this.m_S2.getDimOfElements() != 3) {
            YesNoBox triangBox = new YesNoBox(PsConfig.getFrame(), "Second geometry must be triangulated for this workshop; shall this be done now?");
            triangBox.setVisible(true);
            if (triangBox.getAnswer() == 1) {
                PgElementSet.triangulate((PgElementSet)this.m_S2);
            } else {
                double[] returnValue = new double[]{-1.0, -1.0};
                return returnValue;
            }
        }
        int i = 0;
        while (i < this.m_sampleSteps.getValue()) {
            this.m_S1.refineGlobalIntoFour(true);
            ++i;
        }
        this.m_diff = new PgVectorField(3);
        this.m_diff.setGeometry((PgPointSet)this.m_S1);
        this.m_S1.addVectorField(this.m_diff);
        this.m_dist = new PgVectorField(1);
        this.m_dist.setGeometry((PgPointSet)this.m_S1);
        this.m_S1.addVectorField(this.m_dist);
        this.m_S1.showVectorFields(false);
        PdVector[] box = this.getCommonBoundingBox((PgGeometry)this.m_S1, (PgGeometry)this.m_S2);
        this.createGrid(box[0], box[1]);
        int numElementsS2 = this.m_S2.getNumElements();
        int i2 = 0;
        while (i2 < numElementsS2) {
            if (i2 % 500 == 0) {
                butt.setLabel("Processing element index = " + i2);
            }
            this.computeCubeIntersections(i2);
            ++i2;
        }
        int usedCubes = 0;
        int maxTriangles = 0;
        int i3 = 0;
        while (i3 < this.m_numTotalCubes) {
            if (this.m_cubesElements[i3] != null) {
                ++usedCubes;
                if (this.m_cubesElements[i3].getSize() > maxTriangles) {
                    maxTriangles = this.m_cubesElements[i3].getSize();
                }
            }
            ++i3;
        }
        int[] usedCubes2 = new int[numElementsS2];
        int i4 = 0;
        while (i4 < this.m_numTotalCubes) {
            if (this.m_cubesElements[i4] != null) {
                int k = 0;
                while (k < this.m_cubesElements[i4].getSize()) {
                    int n = this.m_cubesElements[i4].getEntry(k);
                    usedCubes2[n] = usedCubes2[n] + 1;
                    ++k;
                }
            }
            ++i4;
        }
        int totalUsedCubes = 0;
        int i5 = 0;
        while (i5 < this.m_S2.getNumElements()) {
            totalUsedCubes += usedCubes2[i5];
            ++i5;
        }
        if (PsDebug.isNotify()) {
            System.out.println("used cubes: " + usedCubes + "/" + this.m_numTotalCubes + "\nmaximum number of triangles per cube: " + maxTriangles + "\naverage triangles per cube: " + (double)this.m_S2.getNumElements() / (double)usedCubes + "/" + (double)this.m_S2.getNumElements() / (double)this.m_numTotalCubes + "\naverage cubes per triangle: " + (double)totalUsedCubes / (double)this.m_S2.getNumElements());
        }
        PdVector[] vertexS1 = this.m_S1.getVertices();
        int numVerticesS1 = this.m_S1.getNumVertices();
        double[] dist = new double[numVerticesS1];
        CubeIterator iter = new CubeIterator(this);
        double maxDist = -1.7976931348623157E308;
        double totalDist = 0.0;
        PiDynVector examinedFaces = new PiDynVector(0, 15);
        int i6 = 0;
        while (i6 < numVerticesS1) {
            dist[i6] = this.computeDistanceForVertex(vertexS1[i6], i6, iter, examinedFaces);
            examinedFaces.setSize(0);
            totalDist += dist[i6];
            if (dist[i6] > maxDist) {
                maxDist = dist[i6];
            }
            ++i6;
        }
        i6 = 0;
        while (i6 < numVerticesS1) {
            float val = 1.0f - (float)(dist[i6] / maxDist);
            this.m_S1.setVertexColor(i6, new Color(1.0f, val, val));
            ++i6;
        }
        this.m_S1.showElementColors(true);
        this.m_S1.showElementColorFromVertices(true);
        this.m_S1.showSmoothElementColors(true);
        this.m_S1.showVectorFields(false);
        this.m_S1.update((Object)this.m_S1);
        this.m_S2.update((Object)this.m_S2);
        double[] returnValue = new double[]{maxDist, totalDist / (double)numVerticesS1};
        return returnValue;
    }

    protected PdVector getCubeBase(PiVector v) {
        int[] data = v.getEntries();
        PdVector v2 = new PdVector((double)data[0], (double)data[1], (double)data[2]);
        v2.multScalar(this.m_cubeSize);
        v2.add(this.m_gridStart);
        return v2;
    }

    protected PdVector getCubeBase(int i, int j, int k) {
        PdVector v2 = new PdVector((double)i, (double)j, (double)k);
        v2.multScalar(this.m_cubeSize);
        v2.add(this.m_gridStart);
        return v2;
    }

    protected final int getNumCubes(int dir) {
        return this.m_numCubes.getEntry(dir);
    }

    public static final int signum(double x) {
        if (x < 0.0) {
            return -1;
        }
        if (x > 0.0) {
            return 1;
        }
        return 0;
    }

    protected PiVector parentCube(PiVector v) {
        PiVector v2 = PiVector.copyNew((PiVector)v);
        int i = 0;
        while (i < v2.getSize()) {
            v2.setEntry(i, (int)Math.floor((double)v2.getEntry(i) * 0.5));
            ++i;
        }
        return v2;
    }

    protected PiVector getCubeFromPoint(PdVector v) {
        PdVector v2 = PdVector.copyNew((PdVector)v);
        v2.sub(this.m_gridStart);
        v2.multScalar(1.0 / this.m_cubeSize);
        return new PiVector((int)Math.floor(v2.getEntry(0)), (int)Math.floor(v2.getEntry(1)), (int)Math.floor(v2.getEntry(2)));
    }

    protected int cubeIdx(PiVector v) {
        int i = v.getEntry(0);
        int j = v.getEntry(1);
        int k = v.getEntry(2);
        return i + j * this.getNumCubes(0) + k * this.getNumCubes(0) * this.getNumCubes(1);
    }

    protected int cubeIdx(int i, int j, int k) {
        return i + j * this.getNumCubes(0) + k * this.getNumCubes(0) * this.getNumCubes(1);
    }

    protected PiVector cubeFromIdx(int idx) {
        int i = idx % this.getNumCubes(0);
        int cIdx = idx / this.getNumCubes(0);
        int j = cIdx % this.getNumCubes(1);
        int k = cIdx / this.getNumCubes(1);
        return new PiVector(i, j, k);
    }

    protected void cubeFromIdx(PiVector vec, int idx) {
        int i = idx % this.getNumCubes(0);
        int cIdx = idx / this.getNumCubes(0);
        int j = cIdx % this.getNumCubes(1);
        int k = cIdx / this.getNumCubes(1);
        vec.set(i, j, k);
    }

    protected PdVector[] getBoundingBox(PdVector[] vertices) {
        if (vertices.length == 0) {
            PdVector[] retval = new PdVector[]{};
            return retval;
        }
        PdVector bbMin = PdVector.copyNew((PdVector)vertices[0]);
        PdVector bbMax = PdVector.copyNew((PdVector)vertices[0]);
        PdVector.min((PdVector)bbMin, (PdVector[])vertices, (int)vertices.length);
        PdVector.max((PdVector)bbMax, (PdVector[])vertices, (int)vertices.length);
        PdVector[] retval = new PdVector[]{bbMin, bbMax};
        return retval;
    }

    private static final void setTopBorder(int[] topBorder, boolean[] topBorderSet, int i, int j, int leftCubeIdx) {
        if (!topBorderSet[i - leftCubeIdx] || topBorder[i - leftCubeIdx] <= j) {
            topBorder[i - leftCubeIdx] = j;
            topBorderSet[i - leftCubeIdx] = true;
        }
    }

    private static final void setBottomBorder(int[] bottomBorder, boolean[] bottomBorderSet, int i, int j, int leftCubeIdx) {
        if (!bottomBorderSet[i - leftCubeIdx] || bottomBorder[i - leftCubeIdx] >= j) {
            bottomBorder[i - leftCubeIdx] = j;
            bottomBorderSet[i - leftCubeIdx] = true;
        }
    }

    protected class CubeIterator {
        protected PwHausdorffDistance m_parentPw;
        protected double m_minDist;
        protected PuPriorityQueue m_queue;
        protected PdVector m_v;
        protected PiVector m_startCube;
        protected PiVector m_tmpIntVec;

        public CubeIterator(PwHausdorffDistance parent) {
            this.m_parentPw = parent;
            this.m_queue = new PuPriorityQueue(parent.m_numTotalCubes);
            this.m_tmpIntVec = new PiVector(3);
        }

        public void init(PdVector v) {
            PiVector startCube;
            this.m_queue.emptyHeap();
            this.m_minDist = Double.MAX_VALUE;
            this.m_v = v;
            this.m_startCube = startCube = this.m_parentPw.getCubeFromPoint(v);
            this.m_queue.enqueue(this.m_parentPw.cubeIdx(startCube), 0.0);
        }

        public void setMinDist(double dist) {
            this.m_minDist = dist;
        }

        public boolean hasNext() {
            return !this.m_queue.isEmpty() && this.m_queue.getKeyOfMin() < this.m_minDist;
        }

        public int next() {
            double minDist = this.m_queue.getKeyOfMin();
            int next = this.m_queue.extractMin();
            this.m_parentPw.cubeFromIdx(this.m_tmpIntVec, next);
            this.enqueue(this.m_tmpIntVec.m_data[0] - 1, this.m_tmpIntVec.m_data[1], this.m_tmpIntVec.m_data[2], minDist);
            this.enqueue(this.m_tmpIntVec.m_data[0] + 1, this.m_tmpIntVec.m_data[1], this.m_tmpIntVec.m_data[2], minDist);
            this.enqueue(this.m_tmpIntVec.m_data[0], this.m_tmpIntVec.m_data[1] - 1, this.m_tmpIntVec.m_data[2], minDist);
            this.enqueue(this.m_tmpIntVec.m_data[0], this.m_tmpIntVec.m_data[1] + 1, this.m_tmpIntVec.m_data[2], minDist);
            this.enqueue(this.m_tmpIntVec.m_data[0], this.m_tmpIntVec.m_data[1], this.m_tmpIntVec.m_data[2] - 1, minDist);
            this.enqueue(this.m_tmpIntVec.m_data[0], this.m_tmpIntVec.m_data[1], this.m_tmpIntVec.m_data[2] + 1, minDist);
            return next;
        }

        protected void enqueue(int i, int j, int k, double minDist) {
            if (i < 0 || i >= this.m_parentPw.m_numCubes.m_data[0] || j < 0 || j >= this.m_parentPw.m_numCubes.m_data[1] || k < 0 || k >= this.m_parentPw.m_numCubes.m_data[2]) {
                return;
            }
            if (!this.m_queue.isElement(this.m_parentPw.cubeIdx(i, j, k))) {
                double dist = -1.0;
                PdVector dir = new PdVector((double)PwHausdorffDistance.signum(this.m_startCube.m_data[0] - i), (double)PwHausdorffDistance.signum(this.m_startCube.m_data[1] - j), (double)PwHausdorffDistance.signum(this.m_startCube.m_data[2] - k));
                PdVector diff = PwHausdorffDistance.this.getCubeBase(i, j, k);
                diff.add(0.5 * this.m_parentPw.m_cubeSize);
                diff.add(0.5 * this.m_parentPw.m_cubeSize, dir);
                int q = 0;
                while (q < 3) {
                    if (dir.m_data[q] == 0.0) {
                        diff.setEntry(q, this.m_v.getEntry(q));
                    }
                    ++q;
                }
                diff.sub(this.m_v);
                dist = diff.length();
                if (dist > minDist) {
                    this.m_queue.enqueue(PwHausdorffDistance.this.cubeIdx(i, j, k), dist);
                }
            }
        }
    }
}

