/*
 * Decompiled with CFR 0.152.
 */
package dev.geom;

import jv.geom.PgElementSet;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.vecmath.P_Vector;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgVertexStar;
import jvx.geom.PwIntersectElementSet;
import jvx.geom.PwIntersectWithFunction;
import jvx.project.PjWorkshop;
import jvx.util.PuPriorityQueue;

public class PwFrieze
extends PjWorkshop {
    protected PdVector[] m_axis = new PdVector[3];
    PdVector m_center = new PdVector(3);
    PdMatrix m_transform;
    PdMatrix m_invTransform;
    protected PuDouble m_radiusOffset = new PuDouble("Radial Offset", (PsUpdateIf)this);
    protected PuDouble m_maxAngle = new PuDouble("Maximum Angle", (PsUpdateIf)this);
    protected PuDouble m_cuttingAngle = new PuDouble("Cutting Angle", (PsUpdateIf)this);
    protected PuDouble m_angleScaling = new PuDouble("Length Scaling", (PsUpdateIf)this);
    protected PuDouble m_radialScaling = new PuDouble("Relief Scaling", (PsUpdateIf)this);
    protected PuDouble m_morphing = new PuDouble("Wrap", (PsUpdateIf)this);
    private PdVector[] m_friezeVertex;
    private boolean m_bShowShape = false;
    protected PgElementSet m_shape = new PgElementSet(3);
    private double[][] m_box;
    public static final int FRIEZE_TO_STATUE = 0;
    public static final int STATUE_TO_FRIEZE = 1;
    protected int m_mode = 0;

    public PwFrieze() {
        super(PsConfig.getMessage((boolean)true, (int)51000, (String)"Wrap Relief"));
        this.m_shape.setName("Shape");
        this.m_shape.showElements(false);
        this.m_shape.showEdges(true);
        this.m_shape.showVertices(false);
        this.m_box = new double[3][2];
        if (((Object)((Object)this)).getClass() == PwFrieze.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_radiusOffset.setDefBounds(0.0, 100.0, 1.0, 10.0);
        this.m_radiusOffset.setDefValue(0.0);
        this.m_radiusOffset.init();
        this.m_maxAngle.setDefBounds(0.0, Math.PI * 2, 0.09817477042468103, 1.5707963267948966);
        this.m_maxAngle.setDefValue(Math.PI * 2);
        this.m_maxAngle.init();
        this.m_axis[0] = new PdVector(1.0, 0.0, 0.0);
        this.m_axis[1] = new PdVector(0.0, 1.0, 0.0);
        this.m_axis[2] = new PdVector(0.0, 0.0, 1.0);
        this.m_cuttingAngle.setDefBounds(0.0, Math.PI * 2, 0.09817477042468103, 1.5707963267948966);
        this.m_cuttingAngle.setDefValue(0.0);
        this.m_cuttingAngle.init();
        this.m_angleScaling.setDefBounds(0.0, 10.0, 0.1, 1.0);
        this.m_angleScaling.setDefValue(1.0);
        this.m_angleScaling.init();
        this.m_radialScaling.setDefBounds(0.0, 10.0, 0.1, 1.0);
        this.m_radialScaling.setDefValue(1.0);
        this.m_radialScaling.init();
        this.m_morphing.setDefBounds(0.0, 1.0, 0.01, 0.1);
        this.m_morphing.setDefValue(0.0);
        this.m_morphing.init();
        if (this.m_geom != null) {
            this.wrap();
            this.m_geom.update((Object)this.m_geom);
        }
    }

    public boolean update(Object event) {
        if (event == this.m_morphing || event == this.m_angleScaling || event == this.m_radialScaling || event == this.m_maxAngle) {
            this.wrap();
            this.m_geom.update((Object)this.m_geom);
            return true;
        }
        if (event == this.m_radiusOffset || event == this.m_cuttingAngle) {
            if (this.m_mode == 1) {
                this.initStatueToFrieze();
            }
            this.wrap();
            this.m_geom.update((Object)this.m_geom);
            return true;
        }
        return super.update(event);
    }

    public void setGeometry(PgGeometry geom) {
        super.setGeometry(geom);
        if (this.m_mode == 0) {
            this.initFriezeToStatue();
            this.m_morphing.setValue(1.0);
        } else {
            this.initStatueToFrieze();
            this.m_morphing.setValue(0.0);
        }
        this.wrap();
        this.m_geom.update((Object)this.m_geom);
        if (this.m_bShowShape && this.getDisplay() != null) {
            this.getDisplay().addGeometry((PgGeometryIf)this.m_shape);
        }
    }

    public void setMode(int mode) {
        if (this.m_mode == mode) {
            return;
        }
        this.m_mode = mode;
        if (this.m_mode == 0) {
            this.initFriezeToStatue();
            this.m_morphing.setValue(1.0);
        } else {
            PgElementSet geom = (PgElementSet)this.m_geomSave;
            int nov = geom.getNumVertices();
            double maxRadius = 0.0;
            double radius = 0.0;
            PdVector vertex = new PdVector(3);
            int i = 0;
            while (i < nov) {
                vertex.copy(geom.getVertex(i));
                vertex.sub(this.m_center);
                vertex.leftMultMatrix(this.m_transform);
                radius = Math.sqrt(vertex.m_data[1] * vertex.m_data[1] + vertex.m_data[2] * vertex.m_data[2]);
                if (radius > maxRadius) {
                    maxRadius = radius;
                }
                ++i;
            }
            this.m_radiusOffset.setValue(maxRadius * 0.01);
            this.initStatueToFrieze();
            this.m_morphing.setValue(0.0);
            this.m_angleScaling.setValue(Math.PI * (this.m_box[2][1] + this.m_radiusOffset.getValue()));
        }
        this.wrap();
        this.m_geom.update((Object)this.m_geom);
    }

    public void setRadialOffset(double offset) {
        this.m_radiusOffset.setValue(offset);
    }

    public void setMaxAngle(double angle) {
        this.m_maxAngle.setValue(angle);
    }

    public void setCuttingAngle(double angle) {
        this.m_cuttingAngle.setValue(angle);
    }

    public void setAngleScaling(double scale) {
        this.m_angleScaling.setValue(scale);
    }

    public void setRadialScaling(double scale) {
        this.m_radialScaling.setValue(scale);
    }

    public void initFriezeToStatue() {
        PdVector vertex;
        PdMatrix rotation = new PdMatrix(3, 3);
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                rotation.m_data[i][j] = this.m_axis[j].m_data[i];
                ++j;
            }
            ++i;
        }
        this.m_transform = rotation;
        this.m_invTransform = (PdMatrix)this.m_transform.clone();
        this.m_transform.invert();
        PgElementSet geom = (PgElementSet)this.m_geom;
        PgElementSet geomSave = (PgElementSet)this.m_geomSave;
        geom.copy((PsObject)geomSave);
        this.m_friezeVertex = (PdVector[])P_Vector.clone((P_Vector[])geomSave.getVertices());
        int nov = geom.getNumVertices();
        double minY = Double.MAX_VALUE;
        double maxY = Double.MIN_VALUE;
        double minZ = Double.MAX_VALUE;
        double maxZ = Double.MIN_VALUE;
        this.m_box[0][0] = Double.MAX_VALUE;
        this.m_box[0][1] = Double.MIN_VALUE;
        int i2 = 0;
        while (i2 < nov) {
            vertex = this.m_friezeVertex[i2];
            vertex.leftMultMatrix(this.m_transform);
            if (vertex.m_data[0] < this.m_box[0][0]) {
                this.m_box[0][0] = vertex.m_data[0];
            }
            if (vertex.m_data[0] > this.m_box[0][1]) {
                this.m_box[0][1] = vertex.m_data[0];
            }
            if (vertex.m_data[1] < minY) {
                minY = vertex.m_data[1];
            }
            if (vertex.m_data[1] > maxY) {
                maxY = vertex.m_data[1];
            }
            if (vertex.m_data[2] < minZ) {
                minZ = vertex.m_data[2];
            }
            if (vertex.m_data[2] > maxZ) {
                maxZ = vertex.m_data[2];
            }
            ++i2;
        }
        this.m_radiusOffset.setValue(0.0);
        this.m_angleScaling.setValue(maxY -= minY);
        i2 = 0;
        while (i2 < nov) {
            vertex = this.m_friezeVertex[i2];
            if (maxY != 0.0) {
                vertex.m_data[1] = vertex.m_data[1] - minY;
                vertex.m_data[1] = vertex.m_data[1] / maxY;
            } else {
                vertex.m_data[1] = 0.0;
            }
            this.m_center = new PdVector(0.0, minY, minZ);
            vertex.m_data[2] = vertex.m_data[2] - minZ;
            ++i2;
        }
        this.m_cuttingAngle.setEnabled(false);
        this.m_box[1][0] = 0.0;
        this.m_box[1][1] = 1.0;
        this.m_box[2][0] = 0.0;
        this.m_box[2][1] = maxZ - minZ;
    }

    public void initStatueToFrieze() {
        PdVector vertex;
        this.m_center = new PdVector(0.0, 0.0, 0.0);
        PdMatrix rotation = new PdMatrix(3, 3);
        double angle = this.m_cuttingAngle.getValue();
        int i = 0;
        while (i < 3) {
            rotation.m_data[i][0] = this.m_axis[0].m_data[i];
            rotation.m_data[i][1] = this.m_axis[1].m_data[i] * Math.cos(angle) + this.m_axis[2].m_data[i] * Math.sin(angle);
            rotation.m_data[i][2] = this.m_axis[2].m_data[i] * Math.cos(angle) - this.m_axis[1].m_data[i] * Math.sin(angle);
            ++i;
        }
        this.m_transform = rotation;
        this.m_invTransform = (PdMatrix)this.m_transform.clone();
        this.m_transform.invert();
        PgElementSet geom = (PgElementSet)this.m_geom;
        PgElementSet geomSave = (PgElementSet)this.m_geomSave;
        geom.copy((PsObject)geomSave);
        int nov = geom.getNumVertices();
        double maxRadius = 0.0;
        double radius = 0.0;
        double xMin = Double.MAX_VALUE;
        double xMax = Double.MIN_VALUE;
        int i2 = 0;
        while (i2 < nov) {
            vertex = geom.getVertex(i2);
            vertex.sub(this.m_center);
            vertex.leftMultMatrix(this.m_transform);
            radius = Math.sqrt(vertex.m_data[1] * vertex.m_data[1] + vertex.m_data[2] * vertex.m_data[2]);
            if (vertex.m_data[0] < xMin) {
                xMin = vertex.m_data[0];
            }
            if (vertex.m_data[0] > xMax) {
                xMax = vertex.m_data[0];
            }
            if (radius > maxRadius) {
                maxRadius = radius;
            }
            ++i2;
        }
        PgElementSet plane = new PgElementSet(3);
        plane.setNumVertices(4);
        plane.setVertex(0, new PdVector(xMin, 0.0, 0.0));
        plane.setVertex(1, new PdVector(xMax, 0.0, 0.0));
        plane.setVertex(2, new PdVector(xMax, 0.0, maxRadius));
        plane.setVertex(3, new PdVector(xMin, 0.0, maxRadius));
        plane.setNumElements(1);
        plane.setElement(0, new PiVector(0, 1, 2, 3));
        plane.makeNeighbour();
        plane.makeElementNormals();
        plane.makeVertexNormals();
        PwIntersectElementSet pwIntersect = new PwIntersectElementSet();
        pwIntersect.setGeometries(geom, plane);
        pwIntersect.breakElements(0, true);
        pwIntersect.breakElements(1, false);
        pwIntersect.cutAlongIntersection(0, true);
        pwIntersect.cutAlongIntersection(1, false);
        pwIntersect.intersect();
        geom.update((Object)geom);
        PwIntersectWithFunction pwClip = new PwIntersectWithFunction();
        pwClip.setGeometry((PgGeometry)geom);
        pwClip.setFunction("v*v+w*w");
        double clip = this.m_radiusOffset.getValue();
        pwClip.setLevel(clip * clip);
        String geomName = geom.getName();
        geom.copy((PsObject)pwClip.splitAtFunction());
        geom.setName(geomName);
        geom.update((Object)geom);
        nov = geom.getNumVertices();
        PiVector vertexSign = new PiVector(nov);
        PuPriorityQueue queue = new PuPriorityQueue(nov);
        int i3 = 0;
        while (i3 < nov) {
            if (geom.getVertex((int)i3).m_data[2] > 0.0) {
                vertexSign.m_data[i3] = 0;
                queue.enqueue(i3, -Math.abs(geom.getVertex((int)i3).m_data[1]));
            } else {
                vertexSign.m_data[i3] = geom.getVertex((int)i3).m_data[1] > 0.0 ? 2 : -2;
            }
            ++i3;
        }
        int noe = geom.getNumElements();
        PiVector elementAtVertex = new PiVector(nov);
        elementAtVertex.setConstant(-1);
        int i4 = 0;
        while (i4 < noe) {
            PiVector element = geom.getElement(i4);
            int elSize = element.getSize();
            int j = 0;
            while (j < elSize) {
                elementAtVertex.m_data[element.m_data[j]] = i4;
                ++j;
            }
            ++i4;
        }
        PgVertexStar vs = new PgVertexStar();
        int currentIndex = queue.extractMin();
        double cc = 0.0;
        while (currentIndex > -1) {
            if (elementAtVertex.m_data[currentIndex] == -1) {
                vertexSign.m_data[currentIndex] = geom.getVertex((int)currentIndex).m_data[1] > 0.0 ? 1 : -1;
            } else {
                vs.makeVertexStar(geom, currentIndex, elementAtVertex.m_data[currentIndex]);
                PiVector link = vs.getLink();
                int linkSize = vs.getSize();
                if (!vs.isClosed()) {
                    ++linkSize;
                }
                int sign = 0;
                int i5 = 0;
                while (i5 < linkSize) {
                    if (Math.abs(vertexSign.m_data[link.m_data[i5]]) == 1) {
                        sign = vertexSign.m_data[link.m_data[i5]];
                        break;
                    }
                    ++i5;
                }
                if (sign == 0) {
                    i5 = 0;
                    while (i5 < linkSize) {
                        if (Math.abs(vertexSign.m_data[link.m_data[i5]]) == 2 && Math.abs(geom.getVertex((int)link.m_data[i5]).m_data[1]) > Math.abs(geom.getVertex((int)currentIndex).m_data[1])) {
                            sign = vertexSign.m_data[link.m_data[i5]] / 2;
                            break;
                        }
                        ++i5;
                    }
                }
                if (sign == 0) {
                    sign = geom.getVertex((int)currentIndex).m_data[1] > 0.0 ? 1 : -1;
                }
                vertexSign.m_data[currentIndex] = sign;
                i5 = 0;
                while (i5 < linkSize) {
                    if (vertexSign.m_data[link.m_data[i5]] == 0) {
                        queue.decreaseKey(link.m_data[i5], -maxRadius - 1.0 + cc / (double)nov);
                        cc += 1.0;
                    }
                    ++i5;
                }
            }
            currentIndex = queue.extractMin();
        }
        this.m_friezeVertex = (PdVector[])P_Vector.clone((P_Vector[])geom.getVertices());
        double angleScaling = 0.15915494309189535;
        int i6 = 0;
        while (i6 < nov) {
            vertex = this.m_friezeVertex[i6];
            radius = Math.sqrt(vertex.m_data[1] * vertex.m_data[1] + vertex.m_data[2] * vertex.m_data[2]);
            if (Math.abs(vertex.m_data[1]) == 0.0 && Math.abs(vertex.m_data[2]) == 0.0) {
                angle = 0.0;
            } else if (Math.abs(vertex.m_data[2]) > Math.abs(vertex.m_data[1])) {
                angle = Math.atan(vertex.m_data[1] / vertex.m_data[2]);
                if (Math.abs(vertexSign.m_data[i6]) == 2) {
                    angle += Math.PI;
                }
                if (vertexSign.m_data[i6] == -1) {
                    angle += Math.PI * 2;
                }
            } else {
                angle = 1.5707963267948966 - Math.atan(vertex.m_data[2] / vertex.m_data[1]);
                if (vertexSign.m_data[i6] < 0) {
                    angle += Math.PI;
                }
            }
            vertex.m_data[1] = angle * angleScaling;
            vertex.m_data[2] = radius - clip;
            ++i6;
        }
        this.m_cuttingAngle.setEnabled(true);
        this.m_box[0][0] = xMin;
        this.m_box[0][1] = xMax;
        this.m_box[1][0] = 0.0;
        this.m_box[1][1] = 1.0;
        this.m_box[2][0] = 0.0;
        this.m_box[2][1] = maxRadius - clip;
    }

    public void wrap() {
        PgElementSet geom = (PgElementSet)this.m_geom;
        int nov = geom.getNumVertices();
        double threshold = this.m_morphing.getValue();
        double radius = this.m_radiusOffset.getValue();
        double totalAngle = this.m_maxAngle.getValue();
        double yScaling = this.m_angleScaling.getValue();
        double radialScaling = this.m_radialScaling.getValue();
        int i = 0;
        while (i < nov) {
            PdVector relVertex = this.m_friezeVertex[i];
            PdVector geomVertex = geom.getVertex(i);
            geomVertex.m_data[0] = relVertex.m_data[0];
            if (relVertex.m_data[1] < threshold) {
                double angle = (threshold - relVertex.m_data[1]) * totalAngle;
                geomVertex.m_data[2] = Math.cos(angle) * (relVertex.m_data[2] * radialScaling + radius);
                geomVertex.m_data[1] = -Math.sin(angle) * (relVertex.m_data[2] * radialScaling + radius);
            } else {
                geomVertex.m_data[1] = (relVertex.m_data[1] - threshold) * yScaling;
                geomVertex.m_data[2] = relVertex.m_data[2] * radialScaling + radius;
            }
            geomVertex.leftMultMatrix(this.m_invTransform);
            ++i;
        }
        geom.makeElementNormals();
        geom.makeVertexNormals();
        if (this.m_bShowShape) {
            this.computeShape();
        }
    }

    private void computeShape() {
        int angleResolution = 72;
        int nov = 4 * (angleResolution + 1) + 4;
        this.m_shape.setNumVertices(nov);
        double maxAngle = this.m_maxAngle.getValue();
        double radius = this.m_radiusOffset.getValue();
        double radialScaling = this.m_radialScaling.getValue();
        double angleScaling = this.m_angleScaling.getValue();
        int i = 0;
        while (i < angleResolution + 1) {
            double angle = maxAngle * (double)i / (double)angleResolution;
            int j = 0;
            while (j < 2) {
                this.m_shape.setVertex(4 * i + j, new PdVector(this.m_box[0][j], -radius * Math.sin(angle), radius * Math.cos(angle)));
                this.m_shape.setVertex(4 * i + j + 2, new PdVector(this.m_box[0][j], -(radius + this.m_box[2][1] * radialScaling) * Math.sin(angle), (radius + this.m_box[2][1] * radialScaling) * Math.cos(angle)));
                ++j;
            }
            ++i;
        }
        this.m_shape.setVertex(4 * angleResolution + 4, new PdVector(this.m_box[0][0], angleScaling, radius));
        this.m_shape.setVertex(4 * angleResolution + 5, new PdVector(this.m_box[0][1], angleScaling, radius));
        this.m_shape.setVertex(4 * angleResolution + 6, new PdVector(this.m_box[0][0], angleScaling, radius + this.m_box[2][1] * radialScaling));
        this.m_shape.setVertex(4 * angleResolution + 7, new PdVector(this.m_box[0][1], angleScaling, radius + this.m_box[2][1] * radialScaling));
        i = 0;
        while (i < nov) {
            this.m_shape.getVertex(i).leftMultMatrix(this.m_invTransform);
            ++i;
        }
        this.m_shape.setNumElements(2 * angleResolution + 3);
        i = 0;
        while (i < angleResolution) {
            this.m_shape.setElement(2 * i, new PiVector(4 * i, 4 * i + 4, 4 * i + 6, 4 * i + 2));
            this.m_shape.setElement(2 * i + 1, new PiVector(4 * i + 1, 4 * i + 3, 4 * i + 7, 4 * i + 5));
            ++i;
        }
        this.m_shape.setElement(2 * angleResolution, new PiVector(0, 2, 4 * angleResolution + 6, 4 * angleResolution + 4));
        this.m_shape.setElement(2 * angleResolution + 1, new PiVector(1, 4 * angleResolution + 5, 4 * angleResolution + 7, 3));
        this.m_shape.setElement(2 * angleResolution + 2, new PiVector(4 * angleResolution + 4, 4 * angleResolution + 6, 4 * angleResolution + 7, 4 * angleResolution + 5));
        this.m_shape.makeElementNormals();
        this.m_shape.update((Object)this.m_shape);
    }
}

