/*
 * Decompiled with CFR 0.152.
 */
package dev.geom;

import java.awt.Color;
import jv.geom.PgPointSet;
import jv.geom.PgPolygon;
import jv.geom.PgVectorField;
import jv.number.PuComplex;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.vecmath.PcMatrix;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PuMath;
import jvx.project.PjWorkshop;

public class PwCageDeformComplex
extends PjWorkshop {
    protected PgPolygon m_cage;
    protected PgPolygon[] m_vcages;
    public static final int NUM_CAGES = 1;
    public static final int DEFORM_NORMAL = 0;
    public static final int DEFORM_SZEGOE = 1;
    public static final int DEFORM_SZEGOE_QUADMOD = 2;
    protected int[] m_deformModes;
    protected Color[] m_deformedCageColors;
    protected PgPointSet[] m_pointSets;
    protected PgPolygon[] m_sampledCages;
    protected PgPolygon m_sampledMasterCage;
    protected PcMatrix m_cageVertices;
    protected PcMatrix m_geomVertices;
    protected PcMatrix m_vertexWeights;
    protected PcMatrix m_sampledPoints;
    protected PcMatrix m_sampledPointWeights;
    protected boolean m_hasCoordinates;
    public static final boolean DEBUG_WEIGHTS = false;

    public PwCageDeformComplex() {
        super("Deformation using a cage");
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        this.m_deformModes = nArray;
        this.m_deformedCageColors = new Color[]{Color.blue, Color.green, Color.red};
        this.m_hasCoordinates = false;
        this.m_vertexWeights = new PcMatrix(0);
        this.m_cageVertices = new PcMatrix(0);
        this.m_geomVertices = new PcMatrix(0);
        this.m_pointSets = new PgPointSet[1];
        this.m_vcages = new PgPolygon[1];
        if (((Object)((Object)this)).getClass() == PwCageDeformComplex.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
    }

    public void setGeometry(PgGeometry geom) {
        super.setGeometry(geom);
        this.m_geom = geom;
        this.m_pointSets[0] = (PgPointSet)geom;
        int i = 1;
        while (i < 1) {
            this.m_pointSets[i] = (PgPointSet)geom.clone();
            this.m_pointSets[i].setTransparency(0.8);
            this.m_pointSets[i].showTransparency(true);
            this.m_display.addGeometry((PgGeometryIf)this.m_pointSets[i]);
            ++i;
        }
        this.m_sampledCages = new PgPolygon[1];
        this.m_cage = new PgPolygon(this.m_pointSets[0].getDimOfVertices());
        this.m_cage.setName("Deformation Cage");
        this.computeCage(this.m_cage, this.m_pointSets[0]);
        this.m_cage.addUpdateListener((PsUpdateIf)this);
        this.m_display.addGeometry((PgGeometryIf)this.m_cage);
        this.m_display.selectGeometry((PgGeometryIf)this.m_cage);
        i = 0;
        while (i < 1) {
            this.m_vcages[i] = (PgPolygon)this.m_cage.clone();
            this.m_vcages[i].setName("Virtual Cage #" + i);
            this.m_vcages[i].setGlobalEdgeColor(this.m_deformedCageColors[i]);
            if (i >= 1) {
                this.m_vcages[i].setTransparency(0.7);
                this.m_vcages[i].showTransparency(true);
            }
            this.m_display.addGeometry((PgGeometryIf)this.m_vcages[i]);
            ++i;
        }
    }

    protected void computeComplexCoordinates() {
        this.m_geomVertices.setSize(this.m_pointSets[0].getNumVertices(), 1);
        this.m_vertexWeights.setSize(this.m_pointSets[0].getNumVertices(), this.m_cage.getNumVertices());
        this.m_cageVertices.setSize(this.m_cage.getNumVertices(), 1);
        this.geom2vector(this.m_pointSets[0], this.m_geomVertices);
        this.geom2vector((PgPointSet)this.m_cage, this.m_cageVertices);
        int i = 0;
        while (i < this.m_pointSets[0].getNumVertices()) {
            int j = 0;
            while (j < this.m_cage.getNumVertices()) {
                this.m_vertexWeights.m_data[i][j] = new PuComplex(0.0);
                ++j;
            }
            ++i;
        }
        PuComplex B_j = new PuComplex();
        PuComplex B_jm1 = new PuComplex();
        PuComplex B_jp1 = new PuComplex();
        PuComplex A_j = new PuComplex();
        PuComplex A_jp1 = new PuComplex();
        PuComplex x = new PuComplex();
        PuComplex y = new PuComplex();
        PuComplex TWO_PI_I = new PuComplex(0.0, Math.PI * 2);
        int i2 = 0;
        while (i2 < this.m_pointSets[0].getNumVertices()) {
            PuComplex z = this.m_geomVertices.m_data[i2][0];
            int j = 0;
            while (j < this.m_cage.getNumVertices()) {
                int jm1 = (this.m_cage.getNumVertices() + j - 1) % this.m_cage.getNumVertices();
                int jp1 = (j + 1) % this.m_cage.getNumVertices();
                B_j.copy(this.m_cageVertices.m_data[j][0]);
                B_j.sub(z);
                B_jm1.copy(this.m_cageVertices.m_data[jm1][0]);
                B_jm1.sub(z);
                B_jp1.copy(this.m_cageVertices.m_data[jp1][0]);
                B_jp1.sub(z);
                A_j.copy(this.m_cageVertices.m_data[j][0]);
                A_j.sub(this.m_cageVertices.m_data[jm1][0]);
                A_jp1.copy(this.m_cageVertices.m_data[jp1][0]);
                A_jp1.sub(this.m_cageVertices.m_data[j][0]);
                this.weight_zInInterior(B_j, B_jm1, B_jp1, A_j, A_jp1, x, y);
                x.div(TWO_PI_I);
                this.m_vertexWeights.m_data[i2][j].copy(x);
                ++j;
            }
            ++i2;
        }
        this.m_hasCoordinates = true;
        this.computeBoundaryValues();
        this.update(this.m_cage);
    }

    protected void computeBoundaryValues() {
        this.geom2vector((PgPointSet)this.m_cage, this.m_cageVertices);
        int m = 10;
        int n = this.m_cage.getNumVertices();
        int k = n * m;
        this.m_sampledPoints = new PcMatrix(k, 1);
        double[][] weights = this.sampleCage(this.m_cageVertices, m, this.m_sampledPoints);
        this.m_sampledPointWeights = new PcMatrix(k, n);
        PuComplex B_j = new PuComplex();
        PuComplex B_jm1 = new PuComplex();
        PuComplex B_jp1 = new PuComplex();
        PuComplex A_j = new PuComplex();
        PuComplex A_jp1 = new PuComplex();
        PuComplex x = new PuComplex();
        PuComplex y = new PuComplex();
        PuComplex TWO_PI_I = new PuComplex(0.0, Math.PI * 2);
        int i = 0;
        while (i < k) {
            PuComplex z = this.m_sampledPoints.m_data[i][0];
            double t = weights[i % m][1];
            int j = 0;
            while (j < n) {
                int jm1 = (n + j - 1) % n;
                int jp1 = (j + 1) % n;
                A_j.copy(this.m_cageVertices.m_data[j][0]);
                A_j.sub(this.m_cageVertices.m_data[jm1][0]);
                A_jp1.copy(this.m_cageVertices.m_data[jp1][0]);
                A_jp1.sub(this.m_cageVertices.m_data[j][0]);
                int thisVert = j * m;
                int nextVert = (j + 1) * m;
                int prevVert = (j - 1) * m;
                if (i > prevVert && i < thisVert || i - k > prevVert && i - k < thisVert) {
                    this.weightLim_zOnEdgeJm1_J(A_j, A_jp1, x, y, t);
                } else if (i > thisVert && i < nextVert) {
                    this.weightLim_zOnEdgeJ_Jp1(A_j, A_jp1, x, y, t);
                } else if (i == PuMath.modulo((int)prevVert, (int)k)) {
                    this.weightLim_zOnVertexJm1(A_j, A_jp1, x, y);
                } else if (i == thisVert) {
                    this.weightLim_zOnVertexJ(A_j, A_jp1, x);
                } else if (i == PuMath.modulo((int)nextVert, (int)k)) {
                    this.weightLim_zOnVertexJp1(A_j, A_jp1, x, y);
                } else {
                    B_j.copy(this.m_cageVertices.m_data[j][0]);
                    B_j.sub(z);
                    B_jm1.copy(this.m_cageVertices.m_data[jm1][0]);
                    B_jm1.sub(z);
                    B_jp1.copy(this.m_cageVertices.m_data[jp1][0]);
                    B_jp1.sub(z);
                    this.weight_zInInterior(B_j, B_jm1, B_jp1, A_j, A_jp1, x, y);
                }
                x.div(TWO_PI_I);
                this.m_sampledPointWeights.m_data[i][j].copy(x);
                ++j;
            }
            ++i;
        }
        this.m_sampledPoints.mult(this.m_sampledPointWeights, this.m_cageVertices);
        int j = 0;
        while (j < 1) {
            if (this.m_sampledCages[j] == null) {
                this.m_sampledCages[j] = new PgPolygon(2);
            } else {
                this.m_display.removeGeometry((PgGeometryIf)this.m_sampledCages[j]);
                this.m_sampledCages[j] = new PgPolygon(2);
            }
            this.m_sampledCages[j].setName("Sampled Cage (deformed by vcage #" + j + ")");
            int i2 = 0;
            while (i2 < k) {
                this.m_sampledCages[j].addVertex(new PdVector(this.m_sampledPoints.m_data[i2][0].re, this.m_sampledPoints.m_data[i2][0].im));
                ++i2;
            }
            PgVectorField vf = new PgVectorField(2, 0);
            vf.setGeometry((PgPointSet)this.m_sampledCages[j]);
            this.m_sampledCages[j].addVectorField(vf);
            this.m_sampledCages[j].setClosed(true);
            this.m_sampledCages[j].setGlobalEdgeColor(this.m_deformedCageColors[j]);
            if (j == 0) {
                this.m_sampledCages[j].showVectorFields(true);
            }
            this.m_sampledCages[j].setGlobalVectorColor(this.m_deformedCageColors[j]);
            this.m_sampledCages[j].showVertices(false);
            this.m_sampledCages[j].setTransparency(0.7);
            this.m_sampledCages[j].showTransparency(true);
            this.m_display.addGeometry((PgGeometryIf)this.m_sampledCages[j]);
            ++j;
        }
        if (this.m_sampledMasterCage == null) {
            this.m_sampledMasterCage = new PgPolygon(2);
        } else {
            this.m_display.removeGeometry((PgGeometryIf)this.m_sampledMasterCage);
            this.m_sampledMasterCage = new PgPolygon(2);
        }
        this.m_sampledMasterCage.setName("Deformation Cage, sampled");
        this.sampleCage(this.m_cageVertices, m, this.m_sampledPoints);
        i = 0;
        while (i < k) {
            this.m_sampledMasterCage.addVertex(new PdVector(this.m_sampledPoints.m_data[i][0].re, this.m_sampledPoints.m_data[i][0].im));
            ++i;
        }
        this.m_sampledMasterCage.setClosed(true);
        this.m_sampledMasterCage.showVertices(false);
        this.m_display.addGeometry((PgGeometryIf)this.m_sampledMasterCage);
    }

    public boolean update(Object event) {
        if (event != this.m_cage) {
            return super.update(event);
        }
        if (!this.m_hasCoordinates) {
            int i = 0;
            while (i < 1) {
                int j = 0;
                while (j < this.m_cage.getNumVertices()) {
                    this.m_vcages[i].setVertex(j, this.m_cage.getVertex(j));
                    ++j;
                }
                this.m_vcages[i].update(null);
                ++i;
            }
        } else {
            if (this.m_sampledPoints != null) {
                this.geom2vector((PgPointSet)this.m_cage, this.m_cageVertices);
                this.sampleCage(this.m_cageVertices, 10, this.m_sampledPoints);
                this.vector2geom(this.m_sampledPoints, (PgPointSet)this.m_sampledMasterCage);
                this.m_sampledMasterCage.update(null);
            }
            int i = 0;
            while (i < 1) {
                int j;
                int deformMode = this.m_deformModes[i];
                if (deformMode == 0) {
                    int j2 = 0;
                    while (j2 < this.m_cage.getNumVertices()) {
                        this.m_vcages[i].setVertex(j2, this.m_cage.getVertex(j2));
                        ++j2;
                    }
                } else if (deformMode == 1) {
                    PdVector offset = new PdVector(20.0, 4.0);
                    j = 0;
                    while (j < this.m_cage.getNumVertices()) {
                        this.m_vcages[i].setVertex(j, this.m_cage.getVertex(j));
                        this.m_vcages[i].getVertex(j).add(offset);
                        ++j;
                    }
                } else if (deformMode == 2) {
                    PdVector offset = new PdVector(-10.0, -14.0);
                    j = 0;
                    while (j < this.m_cage.getNumVertices()) {
                        this.m_vcages[i].setVertex(j, this.m_cage.getVertex(j));
                        this.m_vcages[i].getVertex(j).add(offset);
                        ++j;
                    }
                }
                this.m_vcages[i].update(null);
                ++i;
            }
            i = 0;
            while (i < 1) {
                this.geom2vector((PgPointSet)this.m_vcages[i], this.m_cageVertices);
                this.m_geomVertices.mult(this.m_vertexWeights, this.m_cageVertices);
                this.vector2geom(this.m_geomVertices, this.m_pointSets[i]);
                this.m_pointSets[i].update(null);
                if (this.m_sampledPoints != null) {
                    this.m_sampledPoints.mult(this.m_sampledPointWeights, this.m_cageVertices);
                    this.vector2geom(this.m_sampledPoints, (PgPointSet)this.m_sampledCages[i]);
                    this.m_sampledCages[i].update(null);
                    if (i == 0) {
                        int j = 0;
                        while (j < this.m_sampledCages[i].getNumVertices()) {
                            this.m_sampledCages[i].getVectorField(0).getVector(j).sub(this.m_sampledMasterCage.getVertex(j), this.m_sampledCages[i].getVertex(j));
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        return this.m_geom.update((Object)this.m_geom);
    }

    void geom2vector(PgPointSet geom, PcMatrix M) {
        int n = geom.getNumVertices();
        int i = 0;
        while (i < n) {
            if (M.m_data[i][0] == null) {
                M.m_data[i][0] = new PuComplex();
            }
            M.m_data[i][0].re = geom.getVertex((int)i).m_data[0];
            M.m_data[i][0].im = geom.getVertex((int)i).m_data[1];
            ++i;
        }
    }

    void vector2geom(PcMatrix M, PgPointSet geom) {
        int n = geom.getNumVertices();
        int i = 0;
        while (i < n) {
            geom.getVertex((int)i).m_data[0] = M.m_data[i][0].re;
            geom.getVertex((int)i).m_data[1] = M.m_data[i][0].im;
            ++i;
        }
    }

    protected void computeCage(PgPolygon targetCage, PgPointSet geom) {
        PdVector[] bb = geom.getAmbientBounds();
        bb[0].sub(bb[1]);
        double xdiam = Math.abs(bb[0].getEntry(0));
        double ydiam = Math.abs(bb[0].getEntry(1));
        double xoffset = 0.1 * xdiam;
        double yoffset = 0.1 * ydiam;
        targetCage.computeCircle(4, Math.max(xdiam + xoffset, ydiam + yoffset));
        targetCage.showVertices(true);
        PdVector center = geom.getCenterOfBndBox();
        PdMatrix rot = new PdMatrix(2);
        double angle = 0.7853981633974483;
        rot.setEntry(0, 0, Math.cos(angle));
        rot.setEntry(1, 0, Math.sin(angle));
        rot.setEntry(0, 1, -Math.sin(angle));
        rot.setEntry(1, 1, Math.cos(angle));
        int i = 0;
        while (i < targetCage.getNumVertices()) {
            targetCage.getVertex(i).leftMultMatrix(rot);
            targetCage.getVertex(i).add(center);
            ++i;
        }
    }

    private double[][] sampleCage(PcMatrix cage, int samplePoints, PcMatrix sampledCage) {
        double[][] weights = new double[samplePoints][2];
        int i = 0;
        while (i < samplePoints) {
            double t;
            weights[i][1] = t = (double)i / 10.0;
            weights[i][0] = 1.0 - t;
            ++i;
        }
        int n = cage.getISize();
        int i2 = 0;
        while (i2 < n) {
            int j = 0;
            while (j < samplePoints) {
                int idx = i2 * samplePoints + j;
                sampledCage.m_data[idx][0] = PuComplex.blend((double)weights[j][0], (PuComplex)cage.m_data[i2][0], (double)weights[j][1], (PuComplex)cage.m_data[(i2 + 1) % n][0]);
                ++j;
            }
            ++i2;
        }
        return weights;
    }

    private void weight_zInInterior(PuComplex B_j, PuComplex B_jm1, PuComplex B_jp1, PuComplex A_j, PuComplex A_jp1, PuComplex x, PuComplex y) {
        x.copy(B_jp1);
        x.div(B_j);
        x.logPB();
        x.mult(B_jp1);
        x.div(A_jp1);
        y.copy(B_j);
        y.div(B_jm1);
        y.logPB();
        y.mult(B_jm1);
        y.div(A_j);
        x.sub(y);
    }

    private void weightLim_zOnVertexJp1(PuComplex A_j, PuComplex A_jp1, PuComplex x, PuComplex y) {
        x.copy(A_j);
        x.div(A_jp1);
        x.add(1.0);
        x.logPB();
        y.copy(A_jp1);
        y.div(A_j);
        y.add(1.0);
        y.mult(x);
        x.copy(y);
        x.neg();
    }

    private void weightLim_zOnVertexJ(PuComplex A_j, PuComplex A_jp1, PuComplex x) {
        x.copy(A_jp1);
        x.div(A_j);
        x.neg();
        x.log();
    }

    private void weightLim_zOnVertexJm1(PuComplex A_j, PuComplex A_jp1, PuComplex x, PuComplex y) {
        x.copy(A_j);
        x.div(A_jp1);
        x.add(1.0);
        y.copy(A_jp1);
        y.div(A_j);
        y.add(1.0);
        y.logPB();
        x.mult(y);
    }

    private void weightLim_zOnEdgeJm1_J(PuComplex A_j, PuComplex A_jp1, PuComplex x, PuComplex y, double t) {
        x.copy(A_j);
        x.mult(1.0 - t);
        x.div(A_jp1);
        x.add(1.0);
        y.copy(A_jp1);
        y.div(A_j);
        y.div(1.0 - t);
        y.add(1.0);
        y.logPB();
        x.mult(y);
        y.set(Math.log((1.0 - t) / t), Math.PI);
        y.mult(t);
        x.add(y);
    }

    private void weightLim_zOnEdgeJ_Jp1(PuComplex A_j, PuComplex A_jp1, PuComplex x, PuComplex y, double t) {
        x.copy(A_jp1);
        x.mult(t);
        x.div(A_j);
        x.add(1.0);
        y.copy(A_j);
        y.div(A_jp1);
        y.div(t);
        y.add(1.0);
        y.logPB();
        x.mult(y);
        y.set(Math.log((1.0 - t) / t), Math.PI);
        y.mult(1.0 - t);
        y.sub(x);
        x.copy(y);
    }

    protected void resetVisibility() {
        this.m_display.removeGeometry((PgGeometryIf)this.m_cage);
        this.m_display.removeGeometry((PgGeometryIf)this.m_sampledMasterCage);
        int i = 0;
        while (i < 1) {
            this.m_display.removeGeometry((PgGeometryIf)this.m_vcages[i]);
            ++i;
        }
        i = 0;
        while (i < 1) {
            this.m_display.removeGeometry((PgGeometryIf)this.m_sampledCages[i]);
            ++i;
        }
        i = 1;
        while (i < 1) {
            this.m_display.removeGeometry((PgGeometryIf)this.m_pointSets[i]);
            ++i;
        }
    }

    public void ok() {
        this.resetVisibility();
        this.m_geom.update((Object)this.m_geom);
        super.ok();
    }

    public void cancel() {
        this.resetVisibility();
        this.m_geom.update((Object)this.m_geom);
        super.cancel();
    }
}

