/*
 * Decompiled with CFR 0.152.
 */
package dev.geom;

import dev.geom.PwApprox;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jvx.project.PjWorkshop_IP;

public class PwApprox_IP
extends PjWorkshop_IP
implements ActionListener,
TextListener,
ItemListener {
    protected PwApprox m_ws;
    protected TextField m_tCurrLoop;
    protected TextField m_tNumLoops;
    protected Button m_bPartition;
    private boolean m_bStartOrStop;
    private Color m_cButtonColor;
    protected Button m_bComputeModel;
    protected Button m_bSplitPatch;
    protected Button m_bJoinPatches;
    protected Button m_bInitialPatches;
    protected Checkbox m_cOptimizeNumProxies;
    protected Checkbox m_cAddProxiesBySelection;
    protected Checkbox m_cPatchesByNormals;
    protected Checkbox m_cPatchesByCurvature;
    protected Checkbox m_cPatchesByLogCurvature;
    protected Checkbox m_cPrincipalComponentAnalysis;
    protected Checkbox m_cColorByCurvature;
    protected Checkbox m_cKeepSign;
    protected Button m_bSmoothPatches;
    protected Checkbox m_cShowPlanes;
    protected Checkbox m_cComputeDunnIndex;
    private static boolean m_bExperimentalVersion = false;
    private static boolean m_bJoinSplitInitialButton = false;

    public PwApprox_IP() {
        this.setTitle(PsConfig.getMessage((boolean)true, (int)54000, (String)"Variational Shape Approximation"));
        if (this.getClass() == PwApprox_IP.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
    }

    public void setParent(PsUpdateIf parent) {
        super.setParent(parent);
        this.m_ws = (PwApprox)parent;
        Panel panel = new Panel(new GridLayout(1, 2));
        this.m_tCurrLoop = new TextField(8);
        this.m_tCurrLoop.setEditable(false);
        panel.add(this.m_tCurrLoop);
        this.m_tNumLoops = new TextField(8);
        this.m_tNumLoops.addTextListener(this);
        panel.add(this.m_tNumLoops);
        this.addLabelComponent(PsConfig.getMessage((int)54264), panel);
        this.add((Component)this.m_ws.m_numProxies.newInspector("_IP"));
        if (m_bJoinSplitInitialButton) {
            Panel panel2 = new Panel();
            this.m_bSplitPatch = new Button(PsConfig.getMessage((boolean)true, (int)54000, (String)"Split Patch"));
            this.m_bSplitPatch.addActionListener(this);
            panel2.add(this.m_bSplitPatch);
            this.m_bJoinPatches = new Button(PsConfig.getMessage((boolean)true, (int)54000, (String)"Join Patches"));
            this.m_bJoinPatches.addActionListener(this);
            panel2.add(this.m_bJoinPatches);
            this.m_bInitialPatches = new Button(PsConfig.getMessage((boolean)true, (int)54000, (String)"Initial Patches"));
            this.m_bInitialPatches.addActionListener(this);
            panel2.add(this.m_bInitialPatches);
            this.add(panel2);
        }
        Panel panel3 = new Panel();
        this.m_cOptimizeNumProxies = new Checkbox(PsConfig.getMessage((boolean)true, (int)54000, (String)"Optimize  Number of Proxies"), false);
        this.m_cOptimizeNumProxies.addItemListener(this);
        panel3.add(this.m_cOptimizeNumProxies);
        this.m_cAddProxiesBySelection = new Checkbox(PsConfig.getMessage((boolean)true, (int)54000, (String)"Add Proxies by Hand"), false);
        this.m_cAddProxiesBySelection.addItemListener(this);
        panel3.add(this.m_cAddProxiesBySelection);
        this.m_cShowPlanes = new Checkbox(PsConfig.getMessage((boolean)true, (int)54000, (String)"Show Planes"), false);
        this.m_cShowPlanes.addItemListener(this);
        panel3.add(this.m_cShowPlanes);
        this.add(panel3);
        Panel panel4 = new Panel();
        CheckboxGroup group = new CheckboxGroup();
        this.m_cPatchesByNormals = new Checkbox("Element Normals", group, true);
        this.m_cPatchesByNormals.addItemListener(this);
        panel4.add(this.m_cPatchesByNormals);
        this.m_cPrincipalComponentAnalysis = new Checkbox("PCA", group, false);
        this.m_cPrincipalComponentAnalysis.addItemListener(this);
        panel4.add(this.m_cPrincipalComponentAnalysis);
        if (m_bExperimentalVersion) {
            this.m_cPatchesByCurvature = new Checkbox("Max Curvature", group, false);
            this.m_cPatchesByCurvature.addItemListener(this);
            panel4.add(this.m_cPatchesByCurvature);
            this.m_cPatchesByLogCurvature = new Checkbox("Log Max Curvature", group, false);
            this.m_cPatchesByLogCurvature.addItemListener(this);
            panel4.add(this.m_cPatchesByLogCurvature);
        }
        this.m_cComputeDunnIndex = new Checkbox("Compute Dunn Index", false);
        this.m_cComputeDunnIndex.addItemListener(this);
        panel4.add(this.m_cComputeDunnIndex);
        this.add(panel4);
        if (m_bExperimentalVersion) {
            Panel panel5 = new Panel();
            this.m_cColorByCurvature = new Checkbox("Color by Curvature", false);
            this.m_cColorByCurvature.addItemListener(this);
            panel5.add(this.m_cColorByCurvature);
            this.m_cKeepSign = new Checkbox("Keep Signs", false);
            this.m_cKeepSign.addItemListener(this);
            panel5.add(this.m_cKeepSign);
            this.add(panel5);
        }
        this.add((Component)this.m_ws.m_splitValue.newInspector("_IP"));
        this.add((Component)this.m_ws.m_joinValue.newInspector("_IP"));
        Panel panel0 = new Panel();
        this.m_bPartition = new Button(PsConfig.getMessage((boolean)true, (int)54000, (String)"Compute Partition"));
        this.m_bPartition.addActionListener(this);
        panel0.add(this.m_bPartition);
        this.m_bStartOrStop = true;
        this.m_cButtonColor = this.m_bPartition.getBackground();
        this.add(panel0);
        this.addLine(1);
        Panel panel6 = new Panel(new GridLayout(1, 1));
        this.m_bSmoothPatches = new Button("Smooth Patch Boundaries");
        this.m_bSmoothPatches.addActionListener(this);
        panel6.add((Component)this.m_ws.m_dijkstraDistanceValue.newInspector("_IP"));
        this.add(panel6);
        Panel panel7 = new Panel();
        panel7.add(this.m_bSmoothPatches);
        this.add(panel7);
        this.addLine(1);
        this.add((Component)this.m_ws.m_curvedPolygonsThreshold.newInspector("_IP"));
        Panel panel1 = new Panel();
        this.m_bComputeModel = new Button("Compute Model");
        this.m_bComputeModel.addActionListener(this);
        panel1.add(this.m_bComputeModel);
        this.add(panel1);
        this.update(this.m_ws);
        this.validate();
    }

    public boolean update(Object event) {
        if (this.m_ws == null) {
            PsDebug.notify((String)"missing parent");
            return true;
        }
        if (event == this.m_ws) {
            PwApprox_IP.setText((TextComponent)this.m_tCurrLoop, (String)String.valueOf(this.m_ws.m_currLoop));
            PwApprox_IP.setText((TextComponent)this.m_tNumLoops, (String)String.valueOf(this.m_ws.m_maxNumLoops));
            if (this.m_ws.m_bStopped && !this.m_bStartOrStop) {
                this.m_bPartition.setLabel(PsConfig.getMessage((boolean)true, (int)54000, (String)"Compute Partition"));
                this.m_bPartition.setBackground(this.m_cButtonColor);
                this.m_bStartOrStop = !this.m_bStartOrStop;
            }
            return true;
        }
        return super.update(event);
    }

    public Dimension getDialogSize() {
        if (m_bExperimentalVersion) {
            return new Dimension(450, 600);
        }
        return new Dimension(450, 480);
    }

    public String getNotice() {
        return PsConfig.getMessage((boolean)true, (int)54000, (String)"Variational Shape Approximation, Reduce the number of mesh elements of a surface using the concept of geometric proxies and also maintain the geometric fidelity for subsequent geometry processing. Number of proxies are target number of elements in the resulting surface.");
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this.m_bPartition) {
            if (this.m_bStartOrStop) {
                this.m_bPartition.setLabel(PsConfig.getMessage((int)54018));
                this.m_bPartition.setBackground(Color.red);
                this.m_ws.start();
            } else {
                this.m_bPartition.setLabel(PsConfig.getMessage((boolean)true, (int)54000, (String)"Compute Partition"));
                this.m_bPartition.setBackground(this.m_cButtonColor);
                this.m_ws.stop();
            }
            this.m_bStartOrStop = !this.m_bStartOrStop;
        } else if (object == this.m_bSplitPatch) {
            this.m_ws.splitBadPatches();
            this.m_ws.m_geom.update((Object)this.m_ws.m_geom);
        } else if (object == this.m_bJoinPatches) {
            this.m_ws.joinProxies();
            this.m_ws.m_geom.update((Object)this.m_ws.m_geom);
        } else if (object == this.m_bInitialPatches) {
            this.m_ws.initialPartition();
            this.m_ws.m_geom.update((Object)this.m_ws.m_geom);
        } else if (object == this.m_bComputeModel) {
            this.m_ws.computeModel();
        } else if (object == this.m_bSmoothPatches) {
            this.m_ws.smoothPatches();
            this.m_ws.m_geom.update((Object)this.m_ws.m_geom);
        } else {
            super.actionPerformed(event);
        }
    }

    @Override
    public void textValueChanged(TextEvent event) {
        Object source = event.getSource();
        if (source == this.m_tNumLoops) {
            this.m_ws.m_maxNumLoops = Integer.parseInt(this.m_tNumLoops.getText());
        }
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        Object source = event.getSource();
        if (source == this.m_cOptimizeNumProxies) {
            this.m_ws.m_bOptimizeNumProxies = this.m_cOptimizeNumProxies.getState();
            this.m_ws.m_joinValue.setEnabled(this.m_cOptimizeNumProxies.getState());
            this.m_ws.m_splitValue.setEnabled(this.m_cOptimizeNumProxies.getState());
        } else if (source == this.m_cAddProxiesBySelection) {
            this.m_ws.m_bAddProxiesBySelection = this.m_cAddProxiesBySelection.getState();
        } else if (source == this.m_cPatchesByNormals) {
            this.m_ws.setMeasure(0);
        } else if (source == this.m_cPrincipalComponentAnalysis) {
            this.m_ws.setMeasure(3);
        } else if (source == this.m_cPatchesByCurvature) {
            this.m_ws.setMeasure(1);
        } else if (source == this.m_cPatchesByLogCurvature) {
            this.m_ws.setMeasure(2);
        } else if (source == this.m_cColorByCurvature) {
            this.m_ws.m_bColorByPatchCurvature = this.m_cColorByCurvature.getState();
        } else if (source == this.m_cKeepSign) {
            this.m_ws.m_bKeepSign = this.m_cKeepSign.getState();
        } else if (source == this.m_cShowPlanes) {
            this.m_ws.showPlaneGeometry(this.m_cShowPlanes.getState());
        } else if (source == this.m_cComputeDunnIndex) {
            this.m_ws.m_bComputeDunnIndex = this.m_cComputeDunnIndex.getState();
        }
    }
}

