/*
 * Decompiled with CFR 0.152.
 */
package dev.geom;

import dev.numeric.PnDunnValidityIndex;
import java.awt.Color;
import java.util.Random;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygonSet;
import jv.geom.PgTetraSet;
import jv.geom.PgVectorField;
import jv.geom.PuCleanMesh;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgVertexStar;
import jvx.geom.PwCleanMesh;
import jvx.numeric.PnJacobi;
import jvx.numeric.PnPCA;
import jvx.project.PjWorkshop;
import jvx.util.PuPriorityQueue;

public class PwApprox
extends PjWorkshop
implements Runnable {
    protected PgPointSet m_geom;
    protected PgElementSet m_approxGeom;
    protected int m_currLoop;
    protected int m_maxNumLoops;
    protected PiVector m_root;
    protected PiVector m_elem2proxy;
    protected PdVector[] m_avNormal;
    protected PdVector m_proxyDist;
    protected PuPriorityQueue m_queue;
    protected PuInteger m_numProxies = new PuInteger("Number of Proxies", (PsUpdateIf)this);
    private int m_nop;
    protected boolean m_bOptimizeNumProxies = false;
    protected PuDouble m_splitValue = new PuDouble("Split Value", (PsUpdateIf)this);
    protected PuDouble m_joinValue = new PuDouble("Join Value", (PsUpdateIf)this);
    protected boolean m_bAddProxiesBySelection = false;
    protected static final int ELEMENT_NORMAL = 0;
    protected static final int MAX_PRINCIPAL_CURVATURE = 1;
    protected static final int MAX_PRINCIPAL_CURVATURE_LOG = 2;
    protected static final int PRINCIPAL_COMPONENT_ANALYSIS = 3;
    protected PdVector m_elementMaxCurvature;
    protected PdVector m_avCurvature;
    protected PuDouble m_shiftValue = new PuDouble("Log Shift", (PsUpdateIf)this);
    protected boolean m_bKeepSign = false;
    private int m_measure = 0;
    protected boolean m_bColorByPatchCurvature = false;
    protected PuDouble m_curvedPolygonsThreshold;
    protected PuInteger m_dijkstraDistanceValue = new PuInteger("Smoothing Distance", (PsUpdateIf)this);
    private Color[] m_proxyColor;
    private PgElementSet m_elementSet;
    private PgTetraSet m_tetraSet;
    private static boolean m_bShowPolygonSet = false;
    private PgVertexStar m_vertStar;
    private PiVector m_vert2elem;
    private PiVector m_anchorVert;
    private PgElementSet m_planeGeom;
    public boolean m_bShowPlanes = false;
    private boolean[] m_vertexOnPatchBnd;
    private static final boolean m_bProjectAnchors = true;
    protected Thread m_thread;
    protected boolean m_bRunning = false;
    protected boolean m_bStopped = true;
    public boolean m_bComputeDunnIndex;

    public PwApprox() {
        super("Variational Shape Approximation");
        this.m_curvedPolygonsThreshold = new PuDouble("Curved Poly Threshold", (PsUpdateIf)this);
        if (this.getClass() == PwApprox.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_numProxies.setDefBounds(1, 1000, 1, 10);
        this.m_numProxies.setDefValue(10);
        this.m_numProxies.init();
        this.m_nop = 10;
        this.m_splitValue.setDefBounds(0.0, 180.0, 1.0, 5.0);
        this.m_splitValue.setDefValue(45.0);
        this.m_splitValue.init();
        this.m_joinValue.setDefBounds(0.0, 180.0, 1.0, 5.0);
        this.m_joinValue.setDefValue(5.0);
        this.m_joinValue.init();
        this.m_shiftValue.setDefBounds(0.0, 10.0, 0.001, 0.1);
        this.m_shiftValue.setDefValue(1.0E-10);
        this.m_shiftValue.init();
        this.m_dijkstraDistanceValue.setDefBounds(0, 20, 1, 5);
        this.m_dijkstraDistanceValue.setDefValue(5);
        this.m_dijkstraDistanceValue.init();
        this.m_curvedPolygonsThreshold.setDefBounds(0.0, 2.0, 0.05, 0.2);
        this.m_curvedPolygonsThreshold.setDefValue(0.5);
        this.m_curvedPolygonsThreshold.init();
        this.assureNumProxies(this.m_numProxies.getValue());
        this.m_maxNumLoops = 50;
        this.m_currLoop = 0;
    }

    public boolean update(Object event) {
        if (event == this.m_numProxies) {
            return true;
        }
        if (event == this.m_splitValue) {
            return true;
        }
        if (event == this.m_joinValue) {
            return true;
        }
        if (event == this.m_shiftValue) {
            return true;
        }
        if (event == this.m_dijkstraDistanceValue) {
            return true;
        }
        if (event == this.m_curvedPolygonsThreshold) {
            return true;
        }
        return super.update(event);
    }

    public void setGeometry(PgElementSet geom) {
        super.setGeometry((PgGeometry)geom);
        this.m_geom = geom;
        if (this.m_geom instanceof PgElementSet) {
            int noe;
            this.m_elementSet = (PgElementSet)this.m_geom;
            if (!PwCleanMesh.checkManifold((PgElementSet)this.m_elementSet, (boolean)false)) {
                PsDebug.message((String)"Geometry is not manifold - trying to heal.");
                PuCleanMesh.removeDegenerateElements((PgElementSet)this.m_elementSet);
                PwCleanMesh.removeNonManifoldEdges((PgElementSet)this.m_elementSet);
                this.m_elementSet.makeNeighbour();
                PwCleanMesh.splitNonManifoldVertices((PgElementSet)this.m_elementSet);
                PwCleanMesh.removeNeighbourhoodDegenerations((PgElementSet)this.m_elementSet);
            }
            if (this.m_elementSet.getNumUnusedVertices() > 0) {
                PsDebug.message((String)"Geometry contains unused vertices - removing those.");
                this.m_elementSet.removeUnusedVertices();
            }
            if (!geom.hasElementNormals()) {
                this.m_elementSet.makeElementNormals();
            }
            if ((noe = geom.getNumElements()) < this.m_numProxies.getValue()) {
                this.m_numProxies.setValue(1);
            }
            int nov = geom.getNumVertices();
            this.m_queue = new PuPriorityQueue(noe);
            if (this.m_elem2proxy == null) {
                this.m_elem2proxy = new PiVector(noe);
            } else {
                this.m_elem2proxy.setSize(noe);
            }
            int nop = this.m_nop;
            this.randomRoots(0, nop);
            this.assureNumProxies(nop);
            PdVector[] curvatureValue = new PdVector[2];
            curvatureValue = PdVector.realloc((PdVector[])curvatureValue, (int)nov, (int)2);
            int i = 0;
            while (i < nov) {
                if (Math.abs(curvatureValue[i].m_data[0]) < Math.abs(curvatureValue[i].m_data[1])) {
                    curvatureValue[i].m_data[0] = curvatureValue[i].m_data[1];
                }
                ++i;
            }
            this.m_elementMaxCurvature = new PdVector(noe);
            double min = Double.MAX_VALUE;
            double max = Double.MIN_VALUE;
            double mean = 0.0;
            int i2 = 0;
            while (i2 < noe) {
                PiVector element = geom.getElement(i2);
                this.m_elementMaxCurvature.m_data[i2] = curvatureValue[element.m_data[0]].m_data[0];
                int n = i2;
                this.m_elementMaxCurvature.m_data[n] = this.m_elementMaxCurvature.m_data[n] + curvatureValue[element.m_data[1]].m_data[0];
                int n2 = i2;
                this.m_elementMaxCurvature.m_data[n2] = this.m_elementMaxCurvature.m_data[n2] + curvatureValue[element.m_data[2]].m_data[0];
                int n3 = i2;
                this.m_elementMaxCurvature.m_data[n3] = this.m_elementMaxCurvature.m_data[n3] / 3.0;
                if (this.m_elementMaxCurvature.m_data[i2] < min) {
                    min = this.m_elementMaxCurvature.m_data[i2];
                }
                if (this.m_elementMaxCurvature.m_data[i2] > max) {
                    max = this.m_elementMaxCurvature.m_data[i2];
                }
                mean += Math.abs(this.m_elementMaxCurvature.m_data[i2]);
                ++i2;
            }
            this.m_shiftValue.setValue((mean /= (double)noe) / 10000.0);
            if (this.m_measure == 0) {
                i2 = 0;
                while (i2 < nop) {
                    this.m_avNormal[i2] = PdVector.copyNew((PdVector)this.m_elementSet.getElementNormal(this.m_root.m_data[i2]));
                    ++i2;
                }
            } else if (this.m_measure == 1 || this.m_measure == 2) {
                this.m_avCurvature = new PdVector(nop);
                i2 = 0;
                while (i2 < nop) {
                    this.m_avCurvature.m_data[i2] = this.getElementCurvature(this.m_root.m_data[i2]);
                    ++i2;
                }
            }
        } else if (this.m_geom instanceof PgTetraSet) {
            this.m_tetraSet = (PgTetraSet)this.m_geom;
        }
    }

    public void setMeasure(int measure) {
        block4: {
            int nop;
            block3: {
                if (measure == this.m_measure) {
                    return;
                }
                this.m_measure = measure;
                nop = this.m_nop;
                this.assureNumProxies(nop);
                if (this.m_measure != 0) break block3;
                int i = 0;
                while (i < nop) {
                    this.m_avNormal[i] = PdVector.copyNew((PdVector)this.m_elementSet.getElementNormal(this.m_root.m_data[i]));
                    ++i;
                }
                break block4;
            }
            if (this.m_measure != 1 && this.m_measure != 2) break block4;
            int i = 0;
            while (i < nop) {
                this.m_avCurvature.m_data[i] = this.getElementCurvature(this.m_root.m_data[i]);
                ++i;
            }
        }
    }

    private double getElementCurvature(int index) {
        if (this.m_measure == 1) {
            return this.m_elementMaxCurvature.m_data[index];
        }
        if (this.m_measure == 2) {
            if (this.m_bKeepSign) {
                if (this.m_elementMaxCurvature.m_data[index] < 0.0) {
                    return -Math.log(Math.abs(this.m_elementMaxCurvature.m_data[index] + this.m_shiftValue.getValue()) / this.m_shiftValue.getValue());
                }
                return Math.log(Math.abs(this.m_elementMaxCurvature.m_data[index] + this.m_shiftValue.getValue()) / this.m_shiftValue.getValue());
            }
            return Math.log(Math.abs(this.m_elementMaxCurvature.m_data[index] + this.m_shiftValue.getValue()) / this.m_shiftValue.getValue());
        }
        return 0.0;
    }

    private void assureNumProxies(int num) {
        int oldSize;
        if (this.m_root == null) {
            this.m_root = new PiVector(num);
            if (this.m_geom != null) {
                this.randomRoots(0, num);
            }
        } else if (this.m_root.getSize() < num) {
            oldSize = this.m_root.getSize();
            this.m_root.setSize(num);
            if (this.m_geom != null) {
                this.randomRoots(oldSize, num);
            }
        }
        this.assureProxyColors(num);
        if (this.m_measure == 0 || this.m_measure == 3) {
            if (this.m_proxyDist == null) {
                this.m_proxyDist = new PdVector(num);
            }
            if (this.m_proxyDist.getSize() != num) {
                this.m_proxyDist.setSize(num);
            }
            if (this.m_geom != null) {
                oldSize = this.m_avNormal == null ? 0 : this.m_avNormal.length;
                this.m_avNormal = PdVector.realloc((PdVector[])this.m_avNormal, (int)num, (int)this.m_geom.getDimOfVertices());
                int i = oldSize;
                while (i < num) {
                    this.setNormal(i);
                    ++i;
                }
            }
        } else if (this.m_measure == 1 || this.m_measure == 2) {
            if (this.m_avCurvature == null) {
                this.m_avCurvature = new PdVector(num);
            } else if (this.m_avCurvature.getSize() < num) {
                this.m_avCurvature.setSize(num);
            }
        }
    }

    protected void assureProxyColors(int num) {
        this.m_proxyColor = new Color[num];
        this.m_proxyColor = PwApprox.makeUniformDistributedColors(num, this.m_proxyColor);
        int i = 0;
        while (i < num) {
            if (this.m_proxyColor[i] != Color.white && this.m_proxyColor[i] != Color.black) {
                this.m_proxyColor[i] = new Color(255 - this.m_proxyColor[i].getBlue(), 255 - this.m_proxyColor[i].getGreen(), this.m_proxyColor[i].getRed());
            }
            ++i;
        }
    }

    public void setNumProxies(int numProxies) {
        this.m_numProxies.setValue(numProxies);
        this.m_nop = numProxies;
        this.m_numProxies.update((Object)this.m_numProxies);
    }

    public int getNumProxies() {
        return this.m_numProxies.getValue();
    }

    private void randomRoots(int start, int end) {
        if (end == start) {
            return;
        }
        if (this.m_geom == null) {
            return;
        }
        int noe = this.getNumSimplices();
        if (end > noe) {
            end = noe;
        }
        boolean[] bUsed = new boolean[noe];
        int i = 0;
        while (i < start) {
            bUsed[this.m_root.m_data[i]] = true;
            ++i;
        }
        Random random = new Random(System.currentTimeMillis());
        int i2 = start;
        while (i2 < end) {
            int k = Math.abs(random.nextInt()) % noe;
            while (bUsed[k]) {
                k = Math.abs(random.nextInt()) % noe;
            }
            this.m_root.m_data[i2] = k;
            bUsed[k] = true;
            ++i2;
        }
    }

    protected void adjustNumProxies() {
        int numProx = this.m_numProxies.getValue();
        int noe = this.getNumSimplices();
        if (numProx != this.m_nop) {
            int i;
            if (this.m_nop > numProx) {
                i = 0;
                while (i < noe) {
                    if (this.m_elem2proxy.m_data[i] >= numProx) {
                        this.m_elem2proxy.m_data[i] = 0;
                    }
                    ++i;
                }
            }
            i = numProx;
            while (i < this.m_nop) {
                this.m_geom.clearTagElement(this.m_root.m_data[i], 1);
                ++i;
            }
            this.assureNumProxies(numProx);
            this.m_nop = numProx;
            this.randomRoots(0, this.m_nop);
        }
    }

    protected void partitionStep() {
        int min;
        int i;
        int numProx = this.m_nop;
        int noe = this.getNumSimplices();
        if (numProx > noe) {
            PsDebug.warning((String)"Cannot compute partition of the surface. The number of Proxies is bigger than the number of triangles.");
            return;
        }
        if (this.m_bAddProxiesBySelection) {
            i = 0;
            while (i < numProx) {
                this.m_geom.clearTagElement(this.m_root.m_data[i], 1);
                ++i;
            }
            int numNew = 0;
            boolean[] addProxyAtEl = new boolean[noe];
            i = 0;
            while (i < noe) {
                if (this.m_geom.hasTagElement(i, 1)) {
                    ++numNew;
                    addProxyAtEl[i] = true;
                } else {
                    addProxyAtEl[i] = false;
                }
                ++i;
            }
            if (numNew != 0) {
                this.assureNumProxies(this.m_nop + numNew);
                i = 0;
                while (i < noe) {
                    if (addProxyAtEl[i]) {
                        this.addProxy(i);
                    }
                    ++i;
                }
                numProx = this.m_nop;
                this.setNumProxies(numProx);
            }
            i = 0;
            while (i < numProx) {
                this.m_geom.setTagElement(this.m_root.m_data[i], 1);
                ++i;
            }
        }
        this.m_queue.emptyHeap();
        this.m_elem2proxy.setConstant(-1);
        double[] keys = this.m_queue.getKeys();
        i = 0;
        while (i < keys.length) {
            keys[i] = Double.MAX_VALUE;
            ++i;
        }
        i = 0;
        while (i < numProx) {
            this.m_queue.enqueue(this.m_root.m_data[i], 0.0);
            this.m_elem2proxy.m_data[this.m_root.m_data[i]] = i;
            ++i;
        }
        PiVector[] neigh = this.getNeighbours();
        i = 0;
        while (i < noe) {
            neigh[i].clearTag(0);
            ++i;
        }
        while ((min = this.m_queue.extractMin()) >= 0) {
            neigh[min].setTag(0);
            int nSize = neigh[min].getSize();
            i = 0;
            while (i < nSize) {
                double energy;
                int nei = neigh[min].m_data[i];
                if (nei != -1 && (energy = this.evalEnergy(this.m_elem2proxy.m_data[min], nei)) < keys[nei] && !neigh[nei].hasTag(0)) {
                    this.m_elem2proxy.m_data[nei] = this.m_elem2proxy.m_data[min];
                    this.m_queue.enqueueOrDecrease(nei, energy);
                }
                ++i;
            }
        }
        this.computeRoots(numProx);
        this.updateColors();
    }

    protected void initialPartition() {
        if (this.m_measure != 0) {
            return;
        }
        int noe = this.getNumSimplices();
        int i = 0;
        while (i < noe) {
            this.m_elem2proxy.m_data[i] = -1;
            ++i;
        }
        int nop = 0;
        int[] queue = new int[noe];
        int maxEl = 0;
        i = 0;
        while (i < noe) {
            if (this.m_elem2proxy.m_data[i] == -1) {
                queue[maxEl] = i;
                int currIndex = maxEl++;
                PdVector normal1 = this.m_elementSet.getElementNormal(i);
                while (currIndex < maxEl) {
                    this.m_elem2proxy.m_data[queue[currIndex]] = nop;
                    PiVector neighbour = this.m_elementSet.getNeighbour(queue[currIndex]);
                    int elSize = neighbour.getSize();
                    int j = 0;
                    while (j < elSize) {
                        int neighIndex = neighbour.m_data[j];
                        if (neighIndex != -1 && this.m_elem2proxy.m_data[neighIndex] == -1) {
                            PdVector normal2 = this.m_elementSet.getElementNormal(neighIndex);
                            if (!(normal1.m_data[0] * normal2.m_data[0] < 0.0 || normal1.m_data[1] * normal2.m_data[1] < 0.0 || normal1.m_data[2] * normal2.m_data[2] < 0.0)) {
                                queue[maxEl] = neighIndex;
                                ++maxEl;
                                this.m_elem2proxy.m_data[neighIndex] = -2;
                            }
                        }
                        ++j;
                    }
                    ++currIndex;
                }
                ++nop;
            }
            ++i;
        }
        this.assureNumProxies(nop);
        this.setNumProxies(nop);
        this.computeRoots(nop);
        this.updateColors();
    }

    private void computeRoots(int numRoots) {
        int i;
        int noe = this.getNumSimplices();
        if (this.m_measure == 0) {
            PdVector[] eNormals = this.m_elementSet.getElementNormals();
            PdVector hVec = new PdVector(this.m_geom.getDimOfVertices());
            i = 0;
            while (i < numRoots) {
                this.m_avNormal[i].setConstant(0.0);
                ++i;
            }
            i = 0;
            while (i < noe) {
                hVec.copyArray(eNormals[i]);
                hVec.multScalar(this.m_elementSet.getAreaOfElement(i));
                if (this.m_elem2proxy.m_data[i] != -1) {
                    this.m_avNormal[this.m_elem2proxy.m_data[i]].add(hVec);
                }
                ++i;
            }
            i = 0;
            while (i < numRoots) {
                this.m_avNormal[i].normalize();
                ++i;
            }
            double[] diff = new double[numRoots];
            i = 0;
            while (i < numRoots) {
                diff[i] = Double.POSITIVE_INFINITY;
                ++i;
            }
            i = 0;
            while (i < noe) {
                if (this.m_elem2proxy.m_data[i] != -1) {
                    hVec.sub(eNormals[i], this.m_avNormal[this.m_elem2proxy.m_data[i]]);
                    double hd = hVec.sqrLength();
                    if (hd < diff[this.m_elem2proxy.m_data[i]]) {
                        diff[this.m_elem2proxy.m_data[i]] = hd;
                        this.m_root.m_data[this.m_elem2proxy.m_data[i]] = i;
                    }
                }
                ++i;
            }
        } else if (this.m_measure == 1 || this.m_measure == 2) {
            this.m_avCurvature.setSize(numRoots);
            this.m_avCurvature.setConstant(0.0);
            PiVector numPatchElements = new PiVector(numRoots);
            numPatchElements.setConstant(0);
            i = 0;
            while (i < noe) {
                if (this.m_elem2proxy.m_data[i] != -1) {
                    int n = this.m_elem2proxy.m_data[i];
                    this.m_avCurvature.m_data[n] = this.m_avCurvature.m_data[n] + this.getElementCurvature(i);
                    int n2 = this.m_elem2proxy.m_data[i];
                    numPatchElements.m_data[n2] = numPatchElements.m_data[n2] + 1;
                }
                ++i;
            }
            i = 0;
            while (i < numRoots) {
                int n = i;
                this.m_avCurvature.m_data[n] = this.m_avCurvature.m_data[n] * (1.0 / (double)numPatchElements.m_data[i]);
                ++i;
            }
            i = 0;
            while (i < noe) {
                if (this.m_elem2proxy.m_data[i] != -1 && Math.abs(this.getElementCurvature(i) - this.m_avCurvature.m_data[this.m_elem2proxy.m_data[i]]) < Math.abs(this.getElementCurvature(this.m_root.m_data[this.m_elem2proxy.m_data[i]]) - this.m_avCurvature.m_data[this.m_elem2proxy.m_data[i]])) {
                    this.m_root.m_data[this.m_elem2proxy.m_data[i]] = i;
                }
                ++i;
            }
        } else if (this.m_measure == 3) {
            int[] numProxyElements = new int[this.m_nop];
            i = 0;
            while (i < this.m_nop) {
                numProxyElements[i] = 0;
                ++i;
            }
            int[][] proxyToElement = new int[this.m_nop][];
            i = 0;
            while (i < noe) {
                if (this.m_elem2proxy.m_data[i] > -1 && this.m_elem2proxy.m_data[i] < noe) {
                    int n = this.m_elem2proxy.m_data[i];
                    numProxyElements[n] = numProxyElements[n] + 1;
                }
                ++i;
            }
            i = 0;
            while (i < this.m_nop) {
                proxyToElement[i] = new int[numProxyElements[i]];
                numProxyElements[i] = 0;
                ++i;
            }
            i = 0;
            while (i < noe) {
                if (this.m_elem2proxy.m_data[i] > -1 && this.m_elem2proxy.m_data[i] < noe) {
                    proxyToElement[this.m_elem2proxy.m_data[i]][numProxyElements[this.m_elem2proxy.m_data[i]]] = i;
                    int n = this.m_elem2proxy.m_data[i];
                    numProxyElements[n] = numProxyElements[n] + 1;
                }
                ++i;
            }
            PdVector[] center = new PdVector[this.m_nop];
            i = 0;
            while (i < this.m_nop) {
                center[i] = this.getBarycenter(proxyToElement[i]);
                this.m_avNormal[i] = this.getNormal(center[i], proxyToElement[i]);
                this.m_proxyDist.m_data[i] = PdVector.dot((PdVector)center[i], (PdVector)this.m_avNormal[i]);
                ++i;
            }
            double[] diff = new double[numRoots];
            i = 0;
            while (i < numRoots) {
                diff[i] = Double.POSITIVE_INFINITY;
                ++i;
            }
            i = 0;
            while (i < noe) {
                int proxy = this.m_elem2proxy.m_data[i];
                if (proxy != -1) {
                    PdVector centerElement = new PdVector(3);
                    PgGeometry.getCenterOfElement((PdVector)centerElement, (PdVector[])this.m_geom.getVertices(), (int[])this.m_geom.getElement(i).getEntries());
                    double hd = PdVector.dist((PdVector)center[proxy], (PdVector)centerElement);
                    if (hd < diff[proxy]) {
                        diff[proxy] = hd;
                        this.m_root.m_data[proxy] = i;
                    }
                }
                ++i;
            }
        }
        PiVector[] elem = this.getSimplices();
        i = 0;
        while (i < noe) {
            elem[i].clearTag(1);
            ++i;
        }
        i = 0;
        while (i < numRoots) {
            elem[this.m_root.m_data[i]].setTag(1);
            ++i;
        }
    }

    protected void splitBadPatches() {
        int nop = this.m_nop;
        int noe = this.getNumSimplices();
        PdVector minSP = new PdVector(nop);
        if (this.m_measure == 0) {
            minSP.setConstant(Math.cos(this.m_splitValue.getValue() * Math.PI / 180.0));
        } else {
            minSP.setConstant(this.m_splitValue.getValue());
        }
        PiVector newProxyInd = new PiVector(nop);
        newProxyInd.setConstant(-1);
        int i = 0;
        while (i < noe) {
            if (this.m_elem2proxy.m_data[i] >= 0 && this.m_elem2proxy.m_data[i] <= nop - 1) {
                double sp;
                if (this.m_measure == 0) {
                    sp = PdVector.dot((PdVector)this.m_elementSet.getElementNormal(i), (PdVector)this.m_avNormal[this.m_elem2proxy.m_data[i]]);
                    if (sp < minSP.m_data[this.m_elem2proxy.m_data[i]] && !this.m_geom.hasTagElement(i, 1)) {
                        newProxyInd.m_data[this.m_elem2proxy.m_data[i]] = i;
                        minSP.m_data[this.m_elem2proxy.m_data[i]] = sp;
                    }
                } else if (this.m_measure == 1 || this.m_measure == 2) {
                    sp = Math.abs(this.getElementCurvature(i) - this.m_avCurvature.m_data[this.m_elem2proxy.m_data[i]]);
                    if (sp > minSP.m_data[this.m_elem2proxy.m_data[i]] && !this.m_geom.hasTagElement(i, 1)) {
                        newProxyInd.m_data[this.m_elem2proxy.m_data[i]] = i;
                        minSP.m_data[this.m_elem2proxy.m_data[i]] = sp;
                    }
                } else if (this.m_measure == 3 && (sp = Math.sqrt(this.evalEnergy(this.m_elem2proxy.m_data[i], i) / (1.0E-10 + this.getVolumeOfSimplex(i)))) > minSP.m_data[this.m_elem2proxy.m_data[i]] && !this.m_geom.hasTagElement(i, 1)) {
                    newProxyInd.m_data[this.m_elem2proxy.m_data[i]] = i;
                    minSP.m_data[this.m_elem2proxy.m_data[i]] = sp;
                }
            }
            ++i;
        }
        int numNew = 0;
        int i2 = 0;
        while (i2 < nop) {
            if (newProxyInd.m_data[i2] != -1) {
                ++numNew;
            }
            ++i2;
        }
        if (numNew != 0) {
            this.assureNumProxies(this.m_nop + numNew);
            i2 = 0;
            while (i2 < nop) {
                if (newProxyInd.m_data[i2] != -1) {
                    this.addProxy(newProxyInd.m_data[i2]);
                }
                ++i2;
            }
            this.setNumProxies(this.m_nop);
        }
    }

    private void addProxy(int elIndex) {
        this.m_elem2proxy.m_data[elIndex] = this.m_nop;
        this.m_root.m_data[this.m_nop] = elIndex;
        if (this.m_measure == 0 || this.m_measure == 3) {
            this.setNormal(this.m_nop);
        } else if (this.m_measure == 1 || this.m_measure == 2) {
            this.m_avCurvature.m_data[this.m_nop] = this.getElementCurvature(elIndex);
        }
        this.m_geom.setTagElement(elIndex, 1);
        ++this.m_nop;
    }

    private void setNormal(int i) {
        int elIndex = this.m_root.m_data[i];
        if (this.m_geom instanceof PgElementSet) {
            this.m_avNormal[i] = PdVector.copyNew((PdVector)this.m_elementSet.getElementNormal(elIndex));
            this.m_proxyDist.m_data[i] = PdVector.dot((PdVector)this.m_elementSet.getVertex(this.m_geom.getElement((int)elIndex).m_data[0]), (PdVector)this.m_avNormal[i]);
        } else if (this.m_geom instanceof PgTetraSet) {
            this.m_avNormal[i] = new PdVector(1.0, 0.0, 0.0);
            PdVector center = new PdVector(3);
            PgGeometry.getCenterOfElement((PdVector)center, (PdVector[])this.m_tetraSet.getVertices(), (int[])this.m_tetraSet.getTetra(elIndex).getEntries());
            this.m_proxyDist.m_data[i] = PdVector.dot((PdVector)center, (PdVector)this.m_avNormal[i]);
        }
    }

    protected void joinProxies() {
        int noe = this.getNumSimplices();
        boolean[] bJoined = new boolean[this.m_nop];
        int i = 0;
        while (i < this.m_nop) {
            bJoined[i] = false;
            ++i;
        }
        double maxSP = this.m_measure == 0 ? Math.cos(this.m_joinValue.getValue() * Math.PI / 180.0) : this.m_joinValue.getValue();
        PiVector proxy1 = new PiVector(this.m_nop / 2);
        PiVector proxy2 = new PiVector(this.m_nop / 2);
        int numJoins = 0;
        i = 0;
        while (i < noe) {
            PiVector neighbour = this.getNeighbour(i);
            int elSize = neighbour.getSize();
            int j = 0;
            while (j < elSize) {
                if (neighbour.m_data[j] != -1 && this.m_elem2proxy.m_data[i] != this.m_elem2proxy.m_data[neighbour.m_data[j]] && !bJoined[this.m_elem2proxy.m_data[i]] && !bJoined[this.m_elem2proxy.m_data[neighbour.m_data[j]]]) {
                    double sp;
                    if (this.m_measure == 0) {
                        sp = PdVector.dot((PdVector)this.m_avNormal[this.m_elem2proxy.m_data[i]], (PdVector)this.m_avNormal[this.m_elem2proxy.m_data[neighbour.m_data[j]]]);
                        if (sp > maxSP) {
                            if (this.m_elem2proxy.m_data[i] < this.m_elem2proxy.m_data[neighbour.m_data[j]]) {
                                proxy1.m_data[numJoins] = this.m_elem2proxy.m_data[i];
                                proxy2.m_data[numJoins] = this.m_elem2proxy.m_data[neighbour.m_data[j]];
                            } else {
                                proxy2.m_data[numJoins] = this.m_elem2proxy.m_data[i];
                                proxy1.m_data[numJoins] = this.m_elem2proxy.m_data[neighbour.m_data[j]];
                            }
                            ++numJoins;
                            bJoined[this.m_elem2proxy.m_data[i]] = true;
                            bJoined[this.m_elem2proxy.m_data[neighbour.m_data[j]]] = true;
                        }
                    } else if (this.m_measure == 1 || this.m_measure == 2) {
                        sp = Math.abs(this.m_avCurvature.m_data[this.m_elem2proxy.m_data[i]] - this.m_avCurvature.m_data[this.m_elem2proxy.m_data[neighbour.m_data[j]]]);
                        if (sp < maxSP) {
                            if (this.m_elem2proxy.m_data[i] < this.m_elem2proxy.m_data[neighbour.m_data[j]]) {
                                proxy1.m_data[numJoins] = this.m_elem2proxy.m_data[i];
                                proxy2.m_data[numJoins] = this.m_elem2proxy.m_data[neighbour.m_data[j]];
                            } else {
                                proxy2.m_data[numJoins] = this.m_elem2proxy.m_data[i];
                                proxy1.m_data[numJoins] = this.m_elem2proxy.m_data[neighbour.m_data[j]];
                            }
                            ++numJoins;
                            bJoined[this.m_elem2proxy.m_data[i]] = true;
                            bJoined[this.m_elem2proxy.m_data[neighbour.m_data[j]]] = true;
                        }
                    } else if (this.m_measure == 3 && (sp = Math.sqrt(this.evalEnergy(this.m_elem2proxy.m_data[i], this.m_root.m_data[j]) / (1.0E-10 + this.getVolumeOfSimplex(this.m_root.m_data[j])))) < maxSP) {
                        if (this.m_elem2proxy.m_data[i] < this.m_elem2proxy.m_data[neighbour.m_data[j]]) {
                            proxy1.m_data[numJoins] = this.m_elem2proxy.m_data[i];
                            proxy2.m_data[numJoins] = this.m_elem2proxy.m_data[neighbour.m_data[j]];
                        } else {
                            proxy2.m_data[numJoins] = this.m_elem2proxy.m_data[i];
                            proxy1.m_data[numJoins] = this.m_elem2proxy.m_data[neighbour.m_data[j]];
                        }
                        ++numJoins;
                        bJoined[this.m_elem2proxy.m_data[i]] = true;
                        bJoined[this.m_elem2proxy.m_data[neighbour.m_data[j]]] = true;
                    }
                }
                ++j;
            }
            ++i;
        }
        if (numJoins > 0) {
            proxy1.setSize(numJoins);
            proxy2.setSize(numJoins);
            this.joinProxies(proxy1, proxy2);
            this.computeRoots(this.m_nop);
            this.assureProxyColors(this.m_nop);
            this.updateColors();
            this.setNumProxies(this.m_nop);
        }
    }

    private void joinProxies(int proxy1, int proxy2) {
        --this.m_nop;
        int noe = this.getNumSimplices();
        if (this.m_measure == 0) {
            this.m_avNormal[proxy2] = this.m_avNormal[this.m_nop];
        } else if (this.m_measure == 1 || this.m_measure == 2) {
            this.m_avCurvature.m_data[proxy2] = this.m_avCurvature.m_data[this.m_nop];
        }
        int i = 0;
        while (i < noe) {
            if (this.m_elem2proxy.m_data[i] == proxy2) {
                this.m_elem2proxy.m_data[i] = proxy1;
            }
            if (this.m_elem2proxy.m_data[i] == this.m_nop) {
                this.m_elem2proxy.m_data[i] = proxy2;
            }
            ++i;
        }
        this.m_root.m_data[proxy2] = this.m_root.m_data[this.m_nop];
    }

    private void joinProxies(PiVector proxy1, PiVector proxy2) {
        int numJoins = proxy1.getSize();
        PiVector mapProxy = new PiVector(this.m_nop);
        boolean[] bRemoveProxy = new boolean[this.m_nop];
        int i = 0;
        while (i < this.m_nop) {
            bRemoveProxy[i] = false;
            ++i;
        }
        i = 0;
        while (i < numJoins) {
            bRemoveProxy[proxy2.m_data[i]] = true;
            ++i;
        }
        int numRemoved = 0;
        int i2 = 0;
        while (i2 < this.m_nop) {
            if (bRemoveProxy[i2]) {
                ++numRemoved;
            } else {
                mapProxy.m_data[i2] = i2 - numRemoved;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < numJoins) {
            mapProxy.m_data[proxy2.m_data[i2]] = mapProxy.m_data[proxy1.m_data[i2]];
            ++i2;
        }
        this.m_nop -= numJoins;
        int noe = this.getNumSimplices();
        int i3 = 0;
        while (i3 < noe) {
            if (this.m_elem2proxy.m_data[i3] != -1) {
                this.m_elem2proxy.m_data[i3] = mapProxy.m_data[this.m_elem2proxy.m_data[i3]];
            }
            ++i3;
        }
    }

    public void smoothPatches() {
        int k;
        int nNeighSize;
        int nei;
        int minValue;
        int nSize;
        int min;
        int elSize;
        int dist = this.m_dijkstraDistanceValue.getValue();
        if (dist < 1) {
            return;
        }
        int noe = this.getNumSimplices();
        int nov = this.m_geom.getNumVertices();
        int nop = this.m_nop;
        int[][] grownRegion = new int[nop][nov];
        int i = 0;
        while (i < nop) {
            int j = 0;
            while (j < nov) {
                grownRegion[i][j] = -1;
                ++j;
            }
            ++i;
        }
        PiVector[] element = this.m_elementSet.getElements();
        PiVector[] neigh = this.m_elementSet.getNeighbours();
        int i2 = 0;
        while (i2 < noe) {
            if (this.m_elem2proxy.m_data[i2] != -1) {
                elSize = element[i2].getSize();
                int j = 0;
                while (j < elSize) {
                    grownRegion[this.m_elem2proxy.m_data[i2]][element[i2].m_data[j]] = 0;
                    ++j;
                }
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < nop) {
            this.m_queue.emptyHeap();
            double[] keys = this.m_queue.getKeys();
            int j = 0;
            while (j < keys.length) {
                keys[j] = Double.MAX_VALUE;
                ++j;
            }
            this.m_queue.enqueue(this.m_root.m_data[i3], 0.0);
            j = 0;
            while (j < noe) {
                neigh[j].clearTag(0);
                ++j;
            }
            while ((min = this.m_queue.extractMin()) >= 0) {
                neigh[min].setTag(0);
                nSize = neigh[min].getSize();
                minValue = Integer.MAX_VALUE;
                j = 0;
                while (j < nSize) {
                    if (grownRegion[i3][element[min].m_data[j]] < minValue && grownRegion[i3][element[min].m_data[j]] != -1) {
                        minValue = grownRegion[i3][element[min].m_data[j]];
                    }
                    ++j;
                }
                j = 0;
                while (j < nSize) {
                    if (grownRegion[i3][element[min].m_data[j]] == -1) {
                        grownRegion[i3][element[min].m_data[j]] = minValue + 1;
                    }
                    ++j;
                }
                j = 0;
                while (j < nSize) {
                    nei = neigh[min].m_data[j];
                    if (nei != -1) {
                        minValue = Integer.MAX_VALUE;
                        nNeighSize = neigh[nei].getSize();
                        int k2 = 0;
                        while (k2 < nNeighSize) {
                            if (grownRegion[i3][element[nei].m_data[k2]] < minValue && grownRegion[i3][element[nei].m_data[k2]] != -1) {
                                minValue = grownRegion[i3][element[nei].m_data[k2]];
                            }
                            ++k2;
                        }
                        if ((double)minValue < keys[nei] && !neigh[nei].hasTag(0)) {
                            this.m_queue.enqueueOrDecrease(nei, (double)minValue);
                        }
                    }
                    ++j;
                }
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < nop) {
            int j = 0;
            while (j < nov) {
                grownRegion[i3][j] = grownRegion[i3][j] >= dist ? 0 : -1;
                ++j;
            }
            int startEl = -1;
            int j2 = 0;
            while (j2 < noe) {
                elSize = element[j2].getSize();
                boolean okElement = true;
                k = 0;
                while (k < elSize) {
                    if (grownRegion[i3][element[j2].m_data[k]] == -1) {
                        okElement = false;
                    }
                    ++k;
                }
                if (okElement) {
                    startEl = j2;
                    break;
                }
                ++j2;
            }
            if (startEl == -1) {
                PsDebug.warning((String)("At least one patch (" + i3 + ") does not have a forbidden region; break patch smoothing process."));
                return;
            }
            this.m_queue.emptyHeap();
            double[] keys = this.m_queue.getKeys();
            int j3 = 0;
            while (j3 < keys.length) {
                keys[j3] = Double.MAX_VALUE;
                ++j3;
            }
            this.m_queue.enqueue(startEl, 0.0);
            j3 = 0;
            while (j3 < noe) {
                neigh[j3].clearTag(0);
                ++j3;
            }
            while ((min = this.m_queue.extractMin()) >= 0) {
                neigh[min].setTag(0);
                nSize = neigh[min].getSize();
                minValue = Integer.MAX_VALUE;
                j3 = 0;
                while (j3 < nSize) {
                    if (grownRegion[i3][element[min].m_data[j3]] < minValue && grownRegion[i3][element[min].m_data[j3]] != -1) {
                        minValue = grownRegion[i3][element[min].m_data[j3]];
                    }
                    ++j3;
                }
                j3 = 0;
                while (j3 < nSize) {
                    if (grownRegion[i3][element[min].m_data[j3]] == -1) {
                        grownRegion[i3][element[min].m_data[j3]] = minValue + 1;
                    }
                    ++j3;
                }
                j3 = 0;
                while (j3 < nSize) {
                    nei = neigh[min].m_data[j3];
                    if (nei != -1) {
                        minValue = Integer.MAX_VALUE;
                        nNeighSize = neigh[nei].getSize();
                        k = 0;
                        while (k < nNeighSize) {
                            if (grownRegion[i3][element[nei].m_data[k]] < minValue && grownRegion[i3][element[nei].m_data[k]] != -1) {
                                minValue = grownRegion[i3][element[nei].m_data[k]];
                            }
                            ++k;
                        }
                        if ((double)minValue < keys[nei] && !neigh[nei].hasTag(0)) {
                            this.m_queue.enqueueOrDecrease(nei, (double)minValue);
                        }
                    }
                    ++j3;
                }
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < noe) {
            elSize = element[i3].getSize();
            int maxDist = Integer.MIN_VALUE;
            int j = 0;
            while (j < nop) {
                int currDist = 0;
                k = 0;
                while (k < elSize) {
                    currDist += grownRegion[j][element[i3].m_data[k]];
                    ++k;
                }
                if ((currDist /= elSize) > maxDist) {
                    this.m_elem2proxy.m_data[i3] = j;
                    maxDist = currDist;
                }
                ++j;
            }
            ++i3;
        }
        int[] patchElement = new int[nop];
        int i4 = 0;
        while (i4 < nop) {
            patchElement[i4] = -1;
            ++i4;
        }
        i4 = 0;
        while (i4 < noe) {
            patchElement[this.m_elem2proxy.m_data[i4]] = i4;
            ++i4;
        }
        i4 = 0;
        while (i4 < nop) {
            if (patchElement[i4] != -1 && this.m_elem2proxy.m_data[this.m_root.m_data[i4]] != i4) {
                this.m_root.m_data[i4] = patchElement[i4];
            }
            ++i4;
        }
        i4 = 0;
        while (i4 < nop) {
            if (patchElement[i4] == -1) {
                this.joinProxies(-1, i4);
                patchElement[i4] = patchElement[nop - 1];
                --i4;
                this.setNumProxies(--nop);
            }
            ++i4;
        }
        this.computeRoots(nop);
        this.updateColors();
    }

    private double evalEnergy(int proxy, int elem) {
        if (this.m_measure == 0) {
            PdVector hvec = new PdVector(this.m_geom.getDimOfVertices());
            PdVector[] eNormals = this.m_elementSet.getElementNormals();
            hvec.sub(this.m_avNormal[proxy], eNormals[elem]);
            double hd = hvec.sqrLength();
            return hd;
        }
        if (this.m_measure == 1 || this.m_measure == 2) {
            return Math.abs(this.getElementCurvature(elem) - this.m_avCurvature.m_data[proxy]);
        }
        if (this.m_measure == 3) {
            double[] d = new double[3];
            int i = 0;
            while (i < 3) {
                d[i] = PdVector.dot((PdVector)this.m_geom.getVertex(this.m_geom.getElement((int)elem).m_data[i]), (PdVector)this.m_avNormal[proxy]) - this.m_proxyDist.m_data[proxy];
                ++i;
            }
            double dd = (d[0] * d[0] + d[1] * d[1] + d[2] * d[2] + d[0] * d[1] + d[1] * d[2] + d[2] * d[0]) * this.getVolumeOfSimplex(elem) / 6.0;
            return dd;
        }
        return 0.0;
    }

    private void updateColors() {
        this.showElementColors(true);
        this.assureElementColors();
        Color[] elemCol = this.getElementColors();
        int noe = this.getNumSimplices();
        PiVector[] elem = this.getElements();
        int nop = this.m_nop;
        if (this.m_measure == 1 && this.m_bColorByPatchCurvature) {
            double min = Double.MAX_VALUE;
            double max = Double.MIN_VALUE;
            int i = 0;
            while (i < nop) {
                if (Math.abs(this.m_avCurvature.m_data[i]) > max) {
                    max = Math.abs(this.m_avCurvature.m_data[i]);
                }
                if (Math.abs(this.m_avCurvature.m_data[i]) < min) {
                    min = Math.abs(this.m_avCurvature.m_data[i]);
                }
                ++i;
            }
            i = 0;
            while (i < noe) {
                elemCol[i] = this.m_elem2proxy.m_data[i] > -1 && this.m_elem2proxy.m_data[i] < nop && max != min ? new Color(255, 255 - (int)(255.0 * (Math.abs(this.m_avCurvature.m_data[this.m_elem2proxy.m_data[i]]) - min) / (max - min)), 0) : Color.black;
                elem[i].setName("" + this.m_elem2proxy.m_data[i]);
                ++i;
            }
        } else if (this.m_measure == 2 && this.m_bColorByPatchCurvature) {
            double min = Double.MAX_VALUE;
            double max = Double.MIN_VALUE;
            int i = 0;
            while (i < nop) {
                if (this.m_avCurvature.m_data[i] > max) {
                    max = this.m_avCurvature.m_data[i];
                }
                if (this.m_avCurvature.m_data[i] < min) {
                    min = this.m_avCurvature.m_data[i];
                }
                ++i;
            }
            i = 0;
            while (i < noe) {
                elemCol[i] = this.m_elem2proxy.m_data[i] > -1 && this.m_elem2proxy.m_data[i] < nop && max != min ? new Color(255, 255 - (int)(255.0 * (this.m_avCurvature.m_data[this.m_elem2proxy.m_data[i]] - min) / (max - min)), 0) : Color.black;
                elem[i].setName("" + this.m_elem2proxy.m_data[i]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < noe) {
                elemCol[i] = this.m_elem2proxy.m_data[i] > -1 && this.m_elem2proxy.m_data[i] < nop && this.m_proxyColor != null && this.m_proxyColor[this.m_elem2proxy.m_data[i]] != null ? this.m_proxyColor[this.m_elem2proxy.m_data[i]] : Color.black;
                elem[i].setName("" + this.m_elem2proxy.m_data[i]);
                ++i;
            }
        }
    }

    protected void computeModel() {
        if (this.m_vertStar == null) {
            this.m_vertStar = new PgVertexStar();
        }
        int nov = this.m_elementSet.getNumVertices();
        int noe = this.m_elementSet.getNumElements();
        if (this.m_vert2elem == null) {
            this.m_vert2elem = new PiVector(nov);
        } else if (this.m_vert2elem.m_data.length < nov) {
            this.m_vert2elem.setSize(nov);
        }
        this.m_vert2elem.setConstant(-1);
        PiVector[] elements = this.m_elementSet.getElements();
        int i = 0;
        while (i < noe) {
            int[] elem = elements[i].m_data;
            int j = 0;
            while (j < elem.length) {
                if (this.m_vert2elem.m_data[elem[j]] == -1) {
                    this.m_vert2elem.m_data[elem[j]] = i;
                }
                ++j;
            }
            ++i;
        }
        this.computeVertices();
        this.m_approxGeom = new PgElementSet(this.m_elementSet.getDimOfVertices());
        if (this.m_display != null) {
            this.m_display.addGeometry((PgGeometryIf)this.m_approxGeom);
        }
        this.setVertices();
        this.computeElements();
        this.m_approxGeom.makeNeighbour();
        this.m_approxGeom.makeVertexNormals();
        this.m_approxGeom.makeElementNormals();
        this.m_approxGeom.showEdges(false);
        this.m_approxGeom.update((Object)this.m_approxGeom);
    }

    protected void showPlaneGeometry(boolean bShow) {
        if (bShow == this.m_bShowPlanes) {
            return;
        }
        this.m_bShowPlanes = bShow;
        if (bShow) {
            if (this.m_planeGeom == null) {
                this.m_planeGeom = new PgElementSet(this.m_geom.getDimOfVertices());
                this.m_planeGeom.showElementColors(true);
                this.m_planeGeom.showTransparency(true);
                this.m_planeGeom.setTransparency(0.75);
                this.m_planeGeom.showEdges(false);
            }
            this.computePlaneGeometry();
            if (this.m_display != null) {
                this.m_display.addGeometry((PgGeometryIf)this.m_planeGeom);
                this.m_display.setEnabledZBuffer(true);
                this.m_display.update(null);
            }
        } else if (this.m_display != null) {
            this.m_display.removeGeometry((PgGeometryIf)this.m_planeGeom);
            this.m_display.update(null);
        }
    }

    protected void computePlaneGeometry() {
        if (this.m_planeGeom == null) {
            this.m_planeGeom = new PgElementSet(this.m_geom.getDimOfVertices());
            this.m_planeGeom.showElementColors(true);
            this.m_planeGeom.showTransparency(true);
            this.m_planeGeom.setTransparency(0.75);
            this.m_planeGeom.showEdges(false);
        }
        this.m_planeGeom.setNumElements(this.m_nop);
        this.m_planeGeom.setNumVertices(4 * this.m_nop);
        this.m_planeGeom.assureElementColors();
        int noe = this.getNumSimplices();
        int[] numProxyElements = new int[this.m_nop];
        int i = 0;
        while (i < this.m_nop) {
            numProxyElements[i] = 0;
            ++i;
        }
        int[][] proxyToElement = new int[this.m_nop][];
        int i2 = 0;
        while (i2 < noe) {
            if (this.m_elem2proxy.m_data[i2] > -1 && this.m_elem2proxy.m_data[i2] < noe) {
                int n = this.m_elem2proxy.m_data[i2];
                numProxyElements[n] = numProxyElements[n] + 1;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.m_nop) {
            proxyToElement[i2] = new int[numProxyElements[i2]];
            numProxyElements[i2] = 0;
            ++i2;
        }
        i2 = 0;
        while (i2 < noe) {
            if (this.m_elem2proxy.m_data[i2] > -1 && this.m_elem2proxy.m_data[i2] < noe) {
                proxyToElement[this.m_elem2proxy.m_data[i2]][numProxyElements[this.m_elem2proxy.m_data[i2]]] = i2;
                int n = this.m_elem2proxy.m_data[i2];
                numProxyElements[n] = numProxyElements[n] + 1;
            }
            ++i2;
        }
        PdVector[] center = new PdVector[this.m_nop];
        int i3 = 0;
        while (i3 < this.m_nop) {
            if (numProxyElements[i3] != 0) {
                int smallestIndex;
                center[i3] = this.getBarycenter(proxyToElement[i3]);
                PdVector eValue = new PdVector(3);
                PdVector[] eVector = new PdVector[3];
                int j = 0;
                while (j < 3) {
                    eVector[j] = new PdVector(3);
                    ++j;
                }
                PnJacobi.computeEigenvectors((PdMatrix)this.getCovarianceMatrix(center[i3], proxyToElement[i3]), (int)3, (PdVector)eValue, (PdVector[])eVector);
                int n = eValue.getEntry(0) < eValue.getEntry(1) && eValue.getEntry(0) < eValue.getEntry(2) ? 0 : (smallestIndex = eValue.getEntry(1) < eValue.getEntry(2) ? 1 : 2);
                int largestIndex = eValue.getEntry(0) >= eValue.getEntry(1) && eValue.getEntry(0) >= eValue.getEntry(2) ? 0 : (eValue.getEntry(1) >= eValue.getEntry(2) ? 1 : 2);
                int middleIndex = 3 - smallestIndex - largestIndex;
                PdVector v1 = PdVector.copyNew((PdVector)eVector[largestIndex]);
                PdVector v2 = PdVector.copyNew((PdVector)eVector[middleIndex]);
                double v1min = v1.dot(center[i3]);
                double v2min = v2.dot(center[i3]);
                double v1max = v1.dot(center[i3]);
                double v2max = v2.dot(center[i3]);
                int j2 = 0;
                while (j2 < numProxyElements[i3]) {
                    PiVector elem = this.m_geom.getElement(proxyToElement[i3][j2]);
                    int k = 0;
                    while (k < 3) {
                        PdVector p = this.m_geom.getVertex(elem.getEntry(k));
                        double v1val = v1.dot(p);
                        double v2val = v2.dot(p);
                        v1min = Math.min(v1min, v1val);
                        v1max = Math.max(v1max, v1val);
                        v2min = Math.min(v2min, v2val);
                        v2max = Math.max(v2max, v2val);
                        ++k;
                    }
                    ++j2;
                }
                v1max -= v1.dot(center[i3]);
                v2min -= v2.dot(center[i3]);
                v2max -= v2.dot(center[i3]);
                PdVector d1min = PdVector.copyNew((PdVector)v1);
                d1min.multScalar(v1min -= v1.dot(center[i3]));
                PdVector d1max = PdVector.copyNew((PdVector)v1);
                d1max.multScalar(v1max);
                PdVector d2min = PdVector.copyNew((PdVector)v2);
                d2min.multScalar(v2min);
                PdVector d2max = PdVector.copyNew((PdVector)v2);
                d2max.multScalar(v2max);
                this.m_planeGeom.setVertex(4 * i3, PdVector.addNew((PdVector)PdVector.addNew((PdVector)d1min, (PdVector)d2min), (PdVector)center[i3]));
                this.m_planeGeom.setVertex(4 * i3 + 1, PdVector.addNew((PdVector)PdVector.addNew((PdVector)d1min, (PdVector)d2max), (PdVector)center[i3]));
                this.m_planeGeom.setVertex(4 * i3 + 2, PdVector.addNew((PdVector)PdVector.addNew((PdVector)d1max, (PdVector)d2max), (PdVector)center[i3]));
                this.m_planeGeom.setVertex(4 * i3 + 3, PdVector.addNew((PdVector)PdVector.addNew((PdVector)d1max, (PdVector)d2min), (PdVector)center[i3]));
                this.m_planeGeom.setElement(i3, 4 * i3, 4 * i3 + 1, 4 * i3 + 2, 4 * i3 + 3);
            }
            ++i3;
        }
        this.m_planeGeom.setElementColors(this.m_proxyColor);
        this.m_planeGeom.makeVertexNormals();
        this.m_planeGeom.makeElementNormals();
        this.m_planeGeom.update((Object)this.m_planeGeom);
    }

    private void computeVertices() {
        int j;
        PiVector neighbour;
        int elSize;
        PiVector element;
        int nov = this.m_elementSet.getNumVertices();
        int numAnchor = 0;
        if (this.m_anchorVert == null) {
            this.m_anchorVert = new PiVector();
        }
        this.m_vertexOnPatchBnd = new boolean[nov];
        int i = 0;
        while (i < nov) {
            this.m_vertexOnPatchBnd[i] = false;
            ++i;
        }
        PgPolygonSet polySet = new PgPolygonSet(this.m_elementSet.getDimOfVertices());
        polySet.setNumVertices(nov);
        i = 0;
        while (i < nov) {
            polySet.setVertex(i, (PdVector)this.m_elementSet.getVertex(i).clone());
            ++i;
        }
        int noe = this.m_elementSet.getNumElements();
        int numEdges = 0;
        i = 0;
        while (i < noe) {
            element = this.m_elementSet.getElement(i);
            elSize = element.getSize();
            neighbour = this.m_elementSet.getNeighbour(i);
            j = 0;
            while (j < elSize) {
                if (neighbour.m_data[j] == -1 || this.m_elem2proxy.m_data[i] != this.m_elem2proxy.m_data[neighbour.m_data[j]] && neighbour.m_data[j] < i) {
                    ++numEdges;
                }
                ++j;
            }
            ++i;
        }
        polySet.setNumPolygons(numEdges);
        numEdges = 0;
        i = 0;
        while (i < noe) {
            element = this.m_elementSet.getElement(i);
            elSize = element.getSize();
            neighbour = this.m_elementSet.getNeighbour(i);
            j = 0;
            while (j < elSize) {
                if (neighbour.m_data[j] == -1 || this.m_elem2proxy.m_data[i] != this.m_elem2proxy.m_data[neighbour.m_data[j]] && neighbour.m_data[j] < i) {
                    polySet.setPolygon(numEdges, new PiVector(element.m_data[(j + 1) % elSize], element.m_data[(j + 2) % elSize]));
                    ++numEdges;
                    this.m_vertexOnPatchBnd[element.m_data[(j + 1) % elSize]] = true;
                    this.m_vertexOnPatchBnd[element.m_data[(j + 2) % elSize]] = true;
                }
                ++j;
            }
            ++i;
        }
        PwCleanMesh.joinPolygons((PgPolygonSet)polySet);
        PwCleanMesh.splitCurvedPolygons((PgPolygonSet)polySet, (double)this.m_curvedPolygonsThreshold.getValue());
        int numPolygons = polySet.getNumPolygons();
        Color[] polyColor = PwApprox.makeUniformDistributedColors(numPolygons, null);
        polySet.setPolygonColors(polyColor);
        polySet.showPolygonColors(true);
        polySet.showVertices(false);
        i = 0;
        while (i < numPolygons) {
            PiVector polygon = polySet.getPolygon(i);
            polySet.setTagVertex(polygon.m_data[0], 1);
            polySet.setTagVertex(polygon.m_data[polygon.getSize() - 1], 1);
            ++i;
        }
        i = 0;
        while (i < nov) {
            if (polySet.hasTagVertex(i, 1)) {
                ++numAnchor;
            }
            ++i;
        }
        this.m_anchorVert.setSize(numAnchor);
        numAnchor = 0;
        i = 0;
        while (i < nov) {
            if (polySet.hasTagVertex(i, 1)) {
                this.m_anchorVert.m_data[numAnchor] = i;
                ++numAnchor;
            }
            ++i;
        }
        i = 0;
        while (i < nov) {
            polySet.clearTagVertex(i, 1);
            ++i;
        }
        if (m_bShowPolygonSet && this.m_display != null) {
            this.m_display.addGeometry((PgGeometryIf)polySet);
        }
        polySet.update((Object)polySet);
    }

    private void setVertices() {
        int elSize;
        PiVector element;
        int proxyIndex;
        int noav = this.m_anchorVert.getSize();
        this.m_approxGeom.setNumVertices(noav);
        PdVector[] vert = this.m_elementSet.getVertices();
        PdVector[] avert = this.m_approxGeom.getVertices();
        PdVector proxyDist = new PdVector(this.m_nop);
        proxyDist.setConstant(0.0);
        PdVector proxyArea = new PdVector(this.m_nop);
        proxyArea.setConstant(0.0);
        int noe = this.m_elementSet.getNumElements();
        int i = 0;
        while (i < noe) {
            proxyIndex = this.m_elem2proxy.m_data[i];
            if (proxyIndex != -1) {
                element = this.m_elementSet.getElement(i);
                elSize = element.getSize();
                double area = this.m_elementSet.getAreaOfElement(i);
                int n = proxyIndex;
                proxyArea.m_data[n] = proxyArea.m_data[n] + area;
                int j = 0;
                while (j < elSize) {
                    int n2 = proxyIndex;
                    proxyDist.m_data[n2] = proxyDist.m_data[n2] + PdVector.dot((PdVector)this.m_avNormal[proxyIndex], (PdVector)this.m_geom.getVertex(element.m_data[j])) * area / (double)elSize;
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.m_nop) {
            if (proxyArea.m_data[i] != 0.0) {
                int n = i;
                proxyDist.m_data[n] = proxyDist.m_data[n] / proxyArea.m_data[i];
            }
            ++i;
        }
        if (this.m_measure == 3) {
            proxyDist = this.m_proxyDist;
        }
        boolean[] bProxyTouched = new boolean[this.m_nop];
        int i2 = 0;
        while (i2 < this.m_nop) {
            bProxyTouched[i2] = false;
            ++i2;
        }
        int i3 = 0;
        while (i3 < noav) {
            this.m_vertStar.makeVertexStar(this.m_elementSet, this.m_anchorVert.m_data[i3], this.m_vert2elem.m_data[this.m_anchorVert.m_data[i3]]);
            element = this.m_vertStar.getElement();
            elSize = element.getSize();
            int numTouchingProxies = 0;
            avert[i3].setConstant(0.0);
            int j = 0;
            while (j < elSize) {
                proxyIndex = this.m_elem2proxy.m_data[element.m_data[j]];
                if (proxyIndex != -1 && !bProxyTouched[proxyIndex]) {
                    bProxyTouched[proxyIndex] = true;
                    ++numTouchingProxies;
                    double p = proxyDist.m_data[proxyIndex] - PdVector.dot((PdVector)this.m_elementSet.getVertex(this.m_anchorVert.m_data[i3]), (PdVector)this.m_avNormal[proxyIndex]);
                    avert[i3].add(PdVector.blendNew((double)1.0, (PdVector)vert[this.m_anchorVert.m_data[i3]], (double)p, (PdVector)this.m_avNormal[proxyIndex]));
                }
                ++j;
            }
            avert[i3].multScalar(1.0 / (double)numTouchingProxies);
            j = 0;
            while (j < elSize) {
                if (this.m_elem2proxy.m_data[element.m_data[j]] != -1) {
                    bProxyTouched[this.m_elem2proxy.m_data[element.m_data[j]]] = false;
                }
                ++j;
            }
            ++i3;
        }
    }

    private void computeElements() {
        int nov = this.m_elementSet.getNumVertices();
        int noe = this.m_elementSet.getNumElements();
        int[] nearestAnchor = new int[nov];
        boolean[] bEnqueued = new boolean[nov];
        int numAnchors = this.m_anchorVert.getSize();
        if (numAnchors == 0) {
            PsDebug.warning((String)"Anchor vertices are missing.");
            return;
        }
        int[] queue = new int[nov];
        int i = 0;
        while (i < nov) {
            bEnqueued[i] = false;
            nearestAnchor[i] = -1;
            queue[i] = -1;
            ++i;
        }
        i = 0;
        while (i < numAnchors) {
            bEnqueued[this.m_anchorVert.m_data[i]] = true;
            nearestAnchor[this.m_anchorVert.m_data[i]] = this.m_anchorVert.m_data[i];
            queue[i] = this.m_anchorVert.m_data[i];
            ++i;
        }
        int nextFreeIndex = numAnchors;
        if (this.m_vertStar == null) {
            this.m_vertStar = new PgVertexStar();
        }
        int i2 = 0;
        while (i2 < nov) {
            if (queue[i2] == -1) break;
            this.m_vertStar.makeVertexStar(this.m_elementSet, queue[i2], this.m_vert2elem.m_data[queue[i2]]);
            PiVector starElement = this.m_vertStar.getElement();
            PiVector locInd = this.m_vertStar.getVertexLocInd();
            int starSize = starElement.getSize();
            int j = 0;
            while (j < starSize) {
                PiVector element = this.m_elementSet.getElement(starElement.m_data[j]);
                int elSize = element.getSize();
                PiVector neighbour = this.m_elementSet.getNeighbour(starElement.m_data[j]);
                int k = 0;
                while (k < 1) {
                    int neighIndex = neighbour.m_data[(locInd.m_data[j] + elSize - 1 - k) % elSize];
                    int vertexIndex = element.m_data[(locInd.m_data[j] + elSize + 1 - 2 * k) % elSize];
                    if (!bEnqueued[vertexIndex] && this.m_vertexOnPatchBnd[vertexIndex] && (neighIndex == -1 || this.m_elem2proxy.m_data[starElement.m_data[j]] != this.m_elem2proxy.m_data[neighIndex])) {
                        bEnqueued[vertexIndex] = true;
                        nearestAnchor[vertexIndex] = nearestAnchor[queue[i2]];
                        queue[nextFreeIndex] = vertexIndex;
                        ++nextFreeIndex;
                    }
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < nov) {
            bEnqueued[i2] = false;
            queue[i2] = -1;
            ++i2;
        }
        i2 = 0;
        while (i2 < numAnchors) {
            queue[i2] = this.m_anchorVert.m_data[i2];
            bEnqueued[this.m_anchorVert.m_data[i2]] = true;
            ++i2;
        }
        nextFreeIndex = numAnchors;
        i2 = 0;
        while (i2 < nov) {
            if (queue[i2] == -1) {
                PsDebug.warning((String)"Disc growing from Anchor Vertices failed");
                return;
            }
            this.m_vertStar.makeVertexStar(this.m_elementSet, queue[i2], this.m_vert2elem.m_data[queue[i2]]);
            PiVector link = this.m_vertStar.getLink();
            int linkSize = link.getSize();
            int j = 0;
            while (j < linkSize) {
                if (!bEnqueued[link.m_data[j]]) {
                    bEnqueued[link.m_data[j]] = true;
                    if (nearestAnchor[link.m_data[j]] == -1) {
                        nearestAnchor[link.m_data[j]] = nearestAnchor[queue[i2]];
                    }
                    queue[nextFreeIndex] = link.m_data[j];
                    ++nextFreeIndex;
                }
                ++j;
            }
            ++i2;
        }
        int newNoe = 0;
        int i3 = 0;
        while (i3 < noe) {
            PiVector element = this.m_elementSet.getElement(i3);
            int elSize = element.getSize();
            int j = 0;
            while (j < elSize - 2) {
                if (nearestAnchor[element.m_data[0]] != nearestAnchor[element.m_data[j + 1]] && nearestAnchor[element.m_data[0]] != nearestAnchor[element.m_data[j + 2]] && nearestAnchor[element.m_data[j + 1]] != nearestAnchor[element.m_data[j + 2]]) {
                    ++newNoe;
                }
                ++j;
            }
            ++i3;
        }
        PiVector[] newElements = PiVector.realloc(null, (int)newNoe, (int)3);
        Color[] approxGeomElColor = new Color[newNoe];
        newNoe = 0;
        int[] newIndex = new int[nov];
        int i4 = 0;
        while (i4 < numAnchors) {
            newIndex[this.m_anchorVert.m_data[i4]] = i4;
            ++i4;
        }
        i4 = 0;
        while (i4 < noe) {
            PiVector element = this.m_elementSet.getElement(i4);
            int elSize = element.getSize();
            int j = 0;
            while (j < elSize - 2) {
                if (nearestAnchor[element.m_data[0]] != nearestAnchor[element.m_data[j + 1]] && nearestAnchor[element.m_data[0]] != nearestAnchor[element.m_data[j + 2]] && nearestAnchor[element.m_data[j + 1]] != nearestAnchor[element.m_data[j + 2]]) {
                    newElements[newNoe].m_data[0] = newIndex[nearestAnchor[element.m_data[0]]];
                    newElements[newNoe].m_data[1] = newIndex[nearestAnchor[element.m_data[j + 1]]];
                    newElements[newNoe].m_data[2] = newIndex[nearestAnchor[element.m_data[j + 2]]];
                    approxGeomElColor[newNoe] = this.m_elementSet.getElementColor(i4);
                    ++newNoe;
                }
                ++j;
            }
            ++i4;
        }
        this.m_approxGeom.setNumElements(newNoe);
        this.m_approxGeom.setElements(newElements);
        this.m_approxGeom.setElementColors(approxGeomElColor);
        this.m_approxGeom.showElementColors(true);
        this.m_approxGeom.setDimOfElements(3);
    }

    public boolean isRunning() {
        return this.m_bRunning;
    }

    public boolean isStopped() {
        return this.m_bStopped;
    }

    public void start() {
        if (!this.m_bStopped || this.m_bRunning) {
            return;
        }
        this.m_currLoop = 1;
        this.m_bRunning = true;
        this.m_thread = new Thread((Runnable)this, "JavaView: Shape Approximation");
        this.m_thread.setPriority(5);
        this.m_thread.start();
        PsDebug.notify((String)"Thread started");
    }

    public void stop() {
        if (this.m_bRunning) {
            this.m_bRunning = false;
            this.m_thread = null;
            PsDebug.notify((String)"Thread stopped");
        }
    }

    @Override
    public void run() {
        this.m_nop = this.m_numProxies.getValue();
        this.assureNumProxies(this.m_nop);
        this.m_bStopped = false;
        while (this.m_thread != null && this.m_bRunning) {
            if (this.m_bOptimizeNumProxies && this.m_currLoop != 1) {
                this.joinProxies();
                this.splitBadPatches();
            }
            this.adjustNumProxies();
            this.partitionStep();
            if (this.m_bShowPlanes) {
                this.computePlaneGeometry();
            }
            this.m_geom.update((Object)this.m_geom);
            this.update(this);
            if (this.m_currLoop >= this.m_maxNumLoops) {
                this.stop();
                continue;
            }
            ++this.m_currLoop;
        }
        if (this.m_bComputeDunnIndex) {
            int numProx = this.m_numProxies.getValue();
            PiVector[] segmentation = new PiVector[numProx];
            int i = 0;
            while (i < numProx) {
                segmentation[i] = new PiVector();
                ++i;
            }
            i = 0;
            while (i < this.m_elementSet.getNumElements()) {
                segmentation[this.m_elem2proxy.m_data[i]].addEntry(i);
                ++i;
            }
            PsDebug.message((String)("Dunn Validity Index after partition step: " + PnDunnValidityIndex.computeIndex(this.m_elementSet, segmentation)));
        }
        this.m_bStopped = true;
        this.update(this);
    }

    public static Color[] makeUniformDistributedColors(int numCols, Color[] colors) {
        if (colors == null) {
            colors = new Color[numCols];
        } else if (colors.length != numCols) {
            PsDebug.warning((String)"invalid length of colors array");
            return null;
        }
        if (numCols < 2) {
            int c = 0;
            while (c < numCols) {
                colors[c] = Color.white;
                ++c;
            }
            return colors;
        }
        int ind = 0;
        int numDim = (int)Math.ceil(Math.pow(numCols, 0.3333333333333333));
        float f = 1.0f / (float)(numDim - 1);
        int r = 0;
        while (r < numDim) {
            int g = 0;
            while (g < numDim) {
                int b = 0;
                while (b < numDim) {
                    if (ind >= numCols) {
                        return colors;
                    }
                    colors[ind] = new Color(1.0f - (float)r * f, 1.0f - (float)g * f, 1.0f - (float)b * f);
                    ++ind;
                    ++b;
                }
                ++g;
            }
            ++r;
        }
        return colors;
    }

    public void cancel() {
        super.cancel();
        this.stop();
        if (this.m_display != null && this.m_planeGeom != null) {
            this.m_display.removeGeometry((PgGeometryIf)this.m_planeGeom);
        }
    }

    private int getNumSimplices() {
        if (this.m_geom instanceof PgElementSet) {
            return ((PgElementSet)this.m_geom).getNumElements();
        }
        if (this.m_geom instanceof PgTetraSet) {
            return ((PgTetraSet)this.m_geom).getNumTetras();
        }
        return 0;
    }

    private PiVector[] getNeighbours() {
        if (this.m_geom instanceof PgElementSet) {
            return ((PgElementSet)this.m_geom).getNeighbours();
        }
        if (this.m_geom instanceof PgTetraSet) {
            return ((PgTetraSet)this.m_geom).getNeighbours();
        }
        return null;
    }

    private PiVector getNeighbour(int i) {
        if (this.m_geom instanceof PgElementSet) {
            return this.m_elementSet.getNeighbour(i);
        }
        if (this.m_geom instanceof PgTetraSet) {
            return this.m_tetraSet.getNeighbour(i);
        }
        return null;
    }

    private PiVector[] getSimplices() {
        if (this.m_geom instanceof PgElementSet) {
            return this.m_elementSet.getElements();
        }
        if (this.m_geom instanceof PgTetraSet) {
            return this.m_tetraSet.getTetras();
        }
        return null;
    }

    private double getVolumeOfSimplex(int i) {
        if (this.m_geom instanceof PgElementSet) {
            return this.m_elementSet.getAreaOfElement(i);
        }
        if (this.m_geom instanceof PgTetraSet) {
            return this.m_tetraSet.getVolumeOfTetra(i);
        }
        return 0.0;
    }

    private PdVector getBarycenter(int[] indices) {
        if (this.m_geom instanceof PgElementSet) {
            return PnPCA.getBarycenter((PgElementSet)this.m_elementSet, (int[])indices);
        }
        if (this.m_geom instanceof PgTetraSet) {
            return PnPCA.getWeightedBarycenter((PgTetraSet)this.m_tetraSet, (PgVectorField)this.m_tetraSet.getVectorField(0), (int[])indices);
        }
        return null;
    }

    private PdMatrix getCovarianceMatrix(PdVector center, int[] indices) {
        if (this.m_geom instanceof PgElementSet) {
            return PnPCA.getCovarianceMatrix((PgElementSet)this.m_elementSet, (PdVector)center, (int[])indices);
        }
        if (this.m_geom instanceof PgTetraSet) {
            return PnPCA.getWeightedCovarianceMatrix((PgTetraSet)this.m_tetraSet, (PgVectorField)this.m_tetraSet.getVectorField(0), (PdVector)center, (int[])indices);
        }
        return null;
    }

    private PdVector getNormal(PdVector center, int[] indices) {
        if (this.m_geom instanceof PgElementSet) {
            return PnPCA.getNormal((PgElementSet)this.m_elementSet, (PdVector)center, (int[])indices);
        }
        if (this.m_geom instanceof PgTetraSet) {
            return PnPCA.getWeightedNormal((PgTetraSet)this.m_tetraSet, (PgVectorField)this.m_tetraSet.getVectorField(0), (PdVector)center, (int[])indices);
        }
        return null;
    }

    private PiVector[] getElements() {
        if (this.m_geom instanceof PgElementSet) {
            return this.m_elementSet.getElements();
        }
        if (this.m_geom instanceof PgTetraSet) {
            return this.m_tetraSet.getTetras();
        }
        return null;
    }

    private Color[] getElementColors() {
        if (this.m_geom instanceof PgElementSet) {
            return this.m_elementSet.getElementColors();
        }
        if (this.m_geom instanceof PgTetraSet) {
            return this.m_tetraSet.getTetraColors();
        }
        return null;
    }

    private void assureElementColors() {
        if (this.m_geom instanceof PgElementSet) {
            this.m_elementSet.assureElementColors();
        } else if (this.m_geom instanceof PgTetraSet) {
            this.m_tetraSet.assureTetraColors();
        }
    }

    private void showElementColors(boolean b) {
        if (this.m_geom instanceof PgElementSet) {
            this.m_elementSet.showElementColors(b);
        } else if (this.m_geom instanceof PgTetraSet) {
            this.m_tetraSet.showTetraColors(b);
        }
    }
}

