/*
 * Decompiled with CFR 0.152.
 */
package dev.geom;

import java.awt.Color;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.vecmath.PdVector;
import jvx.gui.PuColorBar;

public class PuGeometryDyer
extends PsObject {
    public static final int BASED_ELEMENTS = 1;
    public static final int BASED_VERTICES = 2;
    protected PgPointSet m_geom;
    protected PuColorBar m_colorTable = new PuColorBar(true);
    protected double m_min;
    protected double m_max;
    protected PdVector m_values;
    protected int m_basedOn;
    private boolean m_automaticMark = true;

    public PuGeometryDyer() {
    }

    public PuGeometryDyer(boolean automaticColoring) {
        this();
        this.enableAutomaticColoring(automaticColoring);
    }

    public PuGeometryDyer(boolean automaticColoring, boolean automaticMark) {
        this();
        this.enableAutomaticColoring(automaticColoring);
        this.enableAutomaticMatk(automaticMark);
    }

    public void setGeometry(PgPointSet geom, int basedOn) {
        this.m_geom = geom;
        this.m_basedOn = basedOn;
        this.setValues(null);
    }

    public void setBasedOn(int basedOn) {
        boolean change = false;
        if (basedOn != this.m_basedOn) {
            change = true;
        }
        this.m_basedOn = basedOn;
        if (change) {
            this.setValues(null);
        }
    }

    public int getBasedOn() {
        return this.m_basedOn;
    }

    public void setMin(double min) {
        this.m_min = min;
        this.m_colorTable.setMinValue(min);
    }

    public void setMax(double max) {
        this.m_max = max;
        this.m_colorTable.setMaxValue(max);
    }

    public void setBounds(double min, double max) {
        this.m_min = min;
        this.m_max = max;
        this.m_colorTable.setBounds(min, max);
    }

    public PdVector getValues() {
        return this.m_values;
    }

    public int getNumValues() {
        return this.m_values == null ? 0 : this.m_values.getSize();
    }

    public void setValues(PdVector values) {
        this.m_values = values;
    }

    public void setValue(int idx, double value) {
        this.m_values.m_data[idx] = value;
    }

    public double getValue(int idx) {
        return this.m_values.m_data[idx];
    }

    public void setValuesAndBounds(PdVector values) {
        this.setValuesAndBounds(values, PuGeometryDyer.computeBounds(values));
    }

    public void setValuesAndBounds(PdVector values, boolean symmetric, double p) {
        this.setValuesAndBounds(values, PuGeometryDyer.computeBounds(values, symmetric, p));
    }

    public void setValuesAndBounds(PdVector values, PdVector bounds) {
        this.setBounds(bounds.m_data[0], bounds.m_data[1]);
        this.setValues(values);
    }

    public static PdVector computeBounds(PdVector values) {
        return PuGeometryDyer.computeBounds(values, false, 0.0);
    }

    public static PdVector computeBounds(PdVector values, boolean symmetric, double p) {
        int len = values.getSize();
        PdVector newValues = PdVector.copyNew((PdVector)values);
        int i = 0;
        while (i < len) {
            if (Double.isNaN(newValues.m_data[i])) {
                newValues.m_data[i] = Double.MIN_VALUE;
            }
            ++i;
        }
        newValues.sort();
        int numMinValue = 0;
        while (newValues.m_data[numMinValue] == Double.MIN_VALUE) {
            ++numMinValue;
        }
        int cutOff = (int)((double)len * p / 2.0);
        double min = newValues.m_data[cutOff + numMinValue];
        double max = newValues.m_data[len - cutOff - 1];
        if (symmetric) {
            double boundary = Math.max(-min, max);
            min = -boundary;
            max = boundary;
        }
        return new PdVector(min, max);
    }

    public PuColorBar getColorBar() {
        return this.m_colorTable;
    }

    public void enableAutomaticColoring(boolean enabled) {
        if (enabled) {
            this.m_colorTable.setParent((PsUpdateIf)this);
            this.makeColors();
        } else {
            this.m_colorTable.setParent(null);
        }
    }

    public void enableAutomaticMatk(boolean enabled) {
        this.m_automaticMark = enabled;
    }

    public double getColorIndex(int ind) {
        return this.m_colorTable.transformAbsoluteValueToColorIndex(this.m_values.m_data[ind]);
    }

    public Color getColor(int idx) {
        return this.m_colorTable.getColor(this.m_values.m_data[idx]);
    }

    public void makeColors() {
        PgElementSet es = (PgElementSet)this.m_geom;
        if (es != null) {
            es.showElementColors(true);
        }
        if (this.m_basedOn == 1) {
            int num = es.getNumElements();
            if (num != this.m_values.getSize()) {
                PsDebug.warning((String)"length of values array is not equals numElements");
                return;
            }
            int e = 0;
            while (e < num) {
                es.setElementColor(e, this.getColor(e));
                if (this.m_automaticMark) {
                    if (this.m_colorTable.isMarked(this.m_values.m_data[e])) {
                        es.setTagElement(e, 1);
                    } else {
                        es.clearTagElement(e, 1);
                    }
                }
                ++e;
            }
            es.showSmoothElementColors(false);
        } else if (this.m_basedOn == 2) {
            int num;
            if (es != null) {
                es.showVertexColors(true);
            }
            if ((num = es.getNumVertices()) != this.m_values.getSize()) {
                PsDebug.warning((String)"length of values array is not equals numVertices");
                return;
            }
            int v = 0;
            while (v < num) {
                es.setVertexColor(v, this.getColor(v));
                if (this.m_automaticMark) {
                    if (this.m_colorTable.isMarked(this.m_values.m_data[v])) {
                        es.setTagVertex(v, 1);
                    } else {
                        es.clearTagVertex(v, 1);
                    }
                }
                ++v;
            }
        }
    }

    public boolean update(Object event) {
        if (event == this.m_colorTable) {
            this.makeColors();
            this.m_geom.update((Object)this.m_geom);
            return true;
        }
        return super.update(event);
    }
}

