/*
 * Decompiled with CFR 0.152.
 */
package dev.geom;

import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgVertexStar;
import jvx.util.PuPriorityQueue;
import jvx.util.PuQueue;

public class PuElementSetIterator {
    public static final int ELEMENT_BASED = 1;
    public static final int VERTEX_BASED = 0;
    public static final int EMPTY = -2;
    public static final int ROOT = -3;
    public static final int MODE_BREADTH_FIRST = 1;
    public static final int MODE_DEPTH_FIRST = 2;
    public static final int MODE_WEIGHTED = 3;
    protected int m_mode;
    protected int m_basedOn;
    protected PgElementSet m_geom;
    protected int m_numNodes;
    protected PiVector m_elementPerVertex;
    protected PiVector m_neighbours;
    protected int m_focus;
    protected double m_key;
    protected PdVector m_weights;
    protected PiVector m_parent;
    protected PuPriorityQueue m_pQueue;
    protected PuQueue m_queue;
    protected PgVertexStar m_vertexStar;

    public PuElementSetIterator(PgElementSet geom, int basedOn) {
        this.setSurface(geom, basedOn);
    }

    public void setSurface(PgElementSet geom, int basedOn) {
        this.m_basedOn = basedOn;
        this.m_geom = geom;
        this.m_queue = null;
        this.m_pQueue = null;
        if (this.m_parent == null) {
            this.m_parent = new PiVector();
        }
        if (basedOn == 0) {
            this.m_vertexStar = new PgVertexStar();
            this.m_elementPerVertex = PgVertexStar.getElementPerVertex((PgElementSet)this.m_geom);
        } else {
            this.m_vertexStar = null;
            this.m_elementPerVertex = null;
        }
    }

    public void init(int root, int mode) {
        int n = this.m_numNodes = this.m_basedOn == 0 ? this.m_geom.getNumVertices() : this.m_geom.getNumElements();
        if (root < 0 || root >= this.m_numNodes) {
            root = 0;
        }
        this.m_mode = mode;
        this.m_focus = -1;
        this.m_key = 0.0;
        this.m_neighbours = new PiVector();
        this.m_weights = new PdVector();
        if (this.m_parent == null) {
            this.m_parent = new PiVector();
        }
        this.m_parent.setSize(this.m_numNodes);
        this.m_parent.setConstant(-2);
        this.m_parent.setEntry(root, -3);
        if (mode == 1 || mode == 2) {
            if (this.m_queue == null) {
                this.m_queue = new PuQueue((int)Math.sqrt(this.m_numNodes));
            } else {
                this.m_queue.removeAll();
            }
            this.m_pQueue = null;
            this.m_queue.enqueue(root);
        } else if (mode == 3) {
            this.m_queue = null;
            this.m_pQueue = new PuPriorityQueue(this.m_numNodes);
            this.m_pQueue.enqueue(root, 0.0);
        }
    }

    public void addRoot(int root) {
        if (this.m_mode == 1 || this.m_mode == 2) {
            this.m_queue.enqueue(root);
        } else if (this.m_mode == 3) {
            this.m_pQueue.enqueue(root, 0.0);
        }
    }

    private void refreshNeighbours() {
        if (this.m_focus < 0) {
            this.m_neighbours = new PiVector();
            return;
        }
        if (this.m_basedOn == 1) {
            this.m_neighbours = this.m_geom.getNeighbour(this.m_focus);
        }
        if (this.m_basedOn == 0) {
            this.m_vertexStar.makeVertexStar(this.m_geom, this.m_focus, this.m_elementPerVertex.m_data[this.m_focus]);
            this.m_neighbours = this.m_vertexStar.getLink();
        }
        int count = 0;
        int i = 0;
        while (i < this.m_neighbours.getSize()) {
            if (this.m_neighbours.getEntry(i) < 0 || this.isVisited(this.m_neighbours.getEntry(i))) {
                ++count;
            }
            ++i;
        }
        if (count > 0) {
            int count2 = 0;
            PiVector newNeigh = new PiVector(this.m_neighbours.getSize() - count);
            int i2 = 0;
            while (i2 < this.m_neighbours.getSize()) {
                if (this.m_neighbours.getEntry(i2) >= 0 && !this.isVisited(this.m_neighbours.getEntry(i2))) {
                    newNeigh.m_data[count2] = this.m_neighbours.m_data[i2];
                    ++count2;
                }
                ++i2;
            }
            this.m_neighbours = newNeigh;
        }
        this.m_weights.setSize(this.m_neighbours.getSize());
        this.m_weights.setConstant(Double.NaN);
    }

    public PiVector getSuccEdgeInd() {
        PiVector edgeInd = new PiVector(this.m_neighbours.getSize());
        if (this.m_basedOn == 1) {
            PiVector neigh = this.m_geom.getNeighbour(this.m_focus);
            int ind = 0;
            int i = 0;
            while (i < neigh.getSize()) {
                if (ind < this.m_neighbours.getSize() && neigh.getEntry(i) == this.m_neighbours.getEntry(ind)) {
                    edgeInd.m_data[ind] = this.m_geom.getElementEdge(this.m_focus, i);
                    ++ind;
                }
                ++i;
            }
        } else {
            PiVector link = this.m_vertexStar.getLink();
            PiVector edges = this.m_vertexStar.findEdges(this.m_geom, null);
            int ind = 0;
            int i = 0;
            while (i < link.getSize()) {
                if (ind < this.m_neighbours.getSize() && link.getEntry(i) == this.m_neighbours.getEntry(ind)) {
                    edgeInd.m_data[ind] = edges.getEntry(i);
                    ++ind;
                }
                ++i;
            }
        }
        return edgeInd;
    }

    public PiVector getSuccessors() {
        return this.m_neighbours;
    }

    public void blockEdge(int locNeighInd) {
        this.setEdgeWeight(locNeighInd, Double.POSITIVE_INFINITY);
    }

    public void setEdgeWeight(int locNeighInd, double weight) {
        if (weight < 0.0) {
            PsDebug.warning((String)"Only non-negative weights allowed, edge weight is set to 0.");
            weight = 0.0;
        }
        int neigh = this.m_neighbours.getEntry(locNeighInd);
        if (this.m_mode == 3 && this.m_pQueue.isElement(neigh) && this.m_pQueue.getKey(neigh) <= weight + this.m_key) {
            this.m_weights.setEntry(locNeighInd, Double.NaN);
        } else {
            this.setNodeWeight(locNeighInd, weight + this.m_key);
        }
    }

    public void setEdgeWeights(PdVector weights) {
        if (weights == null || weights.getSize() != this.m_neighbours.getSize()) {
            PsDebug.warning((String)"Weights are null or have wrong size.");
            return;
        }
        if (weights.min() < 0.0) {
            PsDebug.warning((String)"Only non-negative edge weights are allowed.");
            int size = weights.getSize();
            int i = 0;
            while (i < size) {
                if (weights.getEntry(i) < 0.0) {
                    weights.setEntry(i, 0.0);
                }
                int neigh = this.m_neighbours.getEntry(i);
                if (this.m_mode == 3 && this.m_pQueue.isElement(neigh) && this.m_pQueue.getKey(neigh) <= weights.getEntry(i) + this.m_key) {
                    weights.setEntry(i, Double.NaN);
                }
                ++i;
            }
        }
        this.m_weights.copy(weights);
        this.m_weights.add(this.m_key);
    }

    public void setNodeWeight(int locNeighInd, double weight) {
        if (locNeighInd < 0 || locNeighInd >= this.m_weights.getSize()) {
            PsDebug.warning((String)"Index out of range.");
        }
        this.m_weights.setEntry(locNeighInd, weight);
    }

    public void setNodeWeights(PdVector weights) {
        if (weights == null || weights.getSize() != this.m_neighbours.getSize()) {
            PsDebug.warning((String)"Weights are null or have wrong size.");
            return;
        }
        this.m_weights.setSize(weights.getSize());
        this.m_weights.copy(weights);
    }

    public double getCurrentWeight() {
        return this.m_key;
    }

    public void init(PiVector roots, PdVector weights, int mode) {
        PsDebug.warning((String)"This method is not implemented yet.");
    }

    public boolean isVisited(int index) {
        if (index < 0 || index >= this.m_numNodes) {
            PsDebug.warning((String)"Index out of range.");
        }
        if (this.m_mode == 3) {
            return this.m_parent.getEntry(index) != -2 && !this.m_pQueue.isElement(index);
        }
        return this.m_parent.getEntry(index) != -2;
    }

    public int getParent(int index) {
        return this.m_parent.getEntry(index);
    }

    public PiVector getParents() {
        return this.m_parent;
    }

    private void enqueueNeighbors() {
        int neigh;
        int i;
        if (this.m_mode == 2 || this.m_mode == 1) {
            i = 0;
            while (i < this.m_neighbours.getSize()) {
                neigh = this.m_neighbours.getEntry(i);
                if (this.m_weights.m_data[i] != Double.POSITIVE_INFINITY) {
                    if (this.m_parent.getEntry(neigh) == -2) {
                        this.m_parent.setEntry(neigh, this.m_focus);
                    }
                    this.m_queue.enqueue(this.m_neighbours.getEntry(i));
                }
                ++i;
            }
        }
        if (this.m_mode == 3) {
            i = 0;
            while (i < this.m_neighbours.getSize()) {
                neigh = this.m_neighbours.getEntry(i);
                if (this.m_weights.m_data[i] < Double.POSITIVE_INFINITY) {
                    this.m_parent.setEntry(neigh, this.m_focus);
                    if (this.m_pQueue.isElement(neigh)) {
                        this.m_pQueue.changeKey(neigh, this.m_weights.getEntry(i));
                    } else {
                        this.m_pQueue.enqueue(neigh, this.m_weights.getEntry(i));
                    }
                }
                if (this.m_weights.m_data[i] == Double.POSITIVE_INFINITY && this.m_pQueue.isElement(neigh)) {
                    this.m_pQueue.extractElement(neigh);
                }
                ++i;
            }
        }
    }

    private int extractNext() {
        int next = -1;
        if (this.m_mode == 2) {
            next = this.m_queue.isEmpty() ? -1 : this.m_queue.extractLast();
        }
        if (this.m_mode == 1) {
            next = this.m_queue.isEmpty() ? -1 : this.m_queue.extractFirst();
        }
        if (this.m_mode == 3) {
            if (this.m_pQueue.getHeapSize() == 0) {
                next = -1;
                this.m_key = Double.POSITIVE_INFINITY;
            } else {
                this.m_key = this.m_pQueue.getKeyOfMin();
                next = this.m_pQueue.extractMin();
            }
        }
        return next;
    }

    public int getNext() {
        this.enqueueNeighbors();
        this.m_focus = this.extractNext();
        this.refreshNeighbours();
        return this.m_focus;
    }

    public boolean hasNext() {
        if (this.m_mode == 3) {
            return this.m_pQueue.getHeapSize() > 0 || this.m_weights.getSize() > 0 && this.m_weights.min() < Double.MAX_VALUE;
        }
        if (this.m_mode == 1 || this.m_mode == 2) {
            if (!this.m_queue.isEmpty()) {
                return true;
            }
            int i = 0;
            while (i < this.m_weights.getSize()) {
                if (this.m_weights.m_data[i] != Double.POSITIVE_INFINITY) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

