/*
 * Decompiled with CFR 0.152.
 */
package dev.geom;

import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygon;
import jv.geom.PgPolygonSet;
import jv.project.PgGeometryIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgPolygonOnElementSet;
import jvx.geom.PgPolygonSetOnElementSet;

public class PnStructurePolygonSet {
    public static void appendPolygon(PgPolygonSet ps, PgPolygon poly) {
        if (poly == null || poly.getNumVertices() == 0) {
            int oldNumPolies = ps.getNumPolygons();
            ps.setNumPolygons(oldNumPolies + 1);
            return;
        }
        int oldNumVertices = ps.getNumVertices();
        int numPolyVertices = poly.getNumVertices();
        ps.setNumVertices(oldNumVertices + numPolyVertices);
        int i = 0;
        while (i < numPolyVertices) {
            ps.setVertex(oldNumVertices + i, poly.getVertex(i));
            ++i;
        }
        int oldNumPolies = ps.getNumPolygons();
        ps.setNumPolygons(oldNumPolies + 1);
        boolean isClosed = poly.isClosed();
        PiVector newPolygon = new PiVector(numPolyVertices + (isClosed ? 1 : 0));
        int i2 = 0;
        while (i2 < numPolyVertices) {
            newPolygon.m_data[i2] = oldNumVertices + i2;
            ++i2;
        }
        if (isClosed) {
            newPolygon.m_data[numPolyVertices] = oldNumVertices;
        }
        ps.setPolygon(oldNumPolies, newPolygon);
    }

    public static int appendPolygon(PgPolygonSetOnElementSet ps, PgPolygonOnElementSet poly) {
        if (poly == null || poly.getNumVertices() == 0) {
            int oldNumPolies = ps.getNumPolygons();
            ps.setNumPolygons(oldNumPolies + 1);
            return oldNumPolies;
        }
        int oldNumVertices = ps.getNumVertices();
        int numPolyVertices = poly.getNumVertices();
        ps.setNumVertices(oldNumVertices + numPolyVertices);
        int i = 0;
        while (i < numPolyVertices) {
            ps.setVertexBary(oldNumVertices + i, poly.getVertexBary(i));
            ++i;
        }
        int oldNumPolies = ps.getNumPolygons();
        ps.setNumPolygons(oldNumPolies + 1);
        boolean isClosed = poly.isClosed();
        PiVector newPolygon = new PiVector(numPolyVertices + (isClosed ? 1 : 0));
        int i2 = 0;
        while (i2 < numPolyVertices) {
            newPolygon.m_data[i2] = oldNumVertices + i2;
            ++i2;
        }
        if (isClosed) {
            newPolygon.m_data[numPolyVertices] = oldNumVertices;
        }
        ps.setPolygon(oldNumPolies, newPolygon);
        return oldNumPolies;
    }

    public static int appendPolygon(PgPolygonSetOnElementSet ps, PgPolygonSetOnElementSet newPs) {
        if (newPs == null || newPs.getNumVertices() == 0) {
            return -1;
        }
        int oldNumVertices = ps.getNumVertices();
        int numPolyVertices = newPs.getNumVertices();
        ps.setNumVertices(oldNumVertices + numPolyVertices);
        int i = 0;
        while (i < numPolyVertices) {
            ps.setVertexBary(oldNumVertices + i, newPs.getVertexBary(i));
            ++i;
        }
        int numOldPolies = ps.getNumPolygons();
        int numNewPolies = newPs.getNumPolygons();
        ps.setNumPolygons(numOldPolies + numNewPolies);
        int p = 0;
        while (p < numNewPolies) {
            PiVector oldPolygon = newPs.getPolygon(p);
            int len = oldPolygon.getSize();
            PiVector newPolygon = new PiVector(len);
            int i2 = 0;
            while (i2 < len) {
                newPolygon.m_data[i2] = oldNumVertices + oldPolygon.m_data[i2];
                ++i2;
            }
            ps.setPolygon(numOldPolies + p, newPolygon);
            ++p;
        }
        return numOldPolies;
    }

    public static int appendPolygon(PgPolygonSetOnElementSet ps, PgPolygonSetOnElementSet[] polies) {
        if (polies == null || polies.length == 0) {
            return -1;
        }
        int numNewVertices = 0;
        int numNewPolygons = 0;
        int numNewPs = polies.length;
        int p = 0;
        while (p < numNewPs) {
            numNewVertices += polies[p].getNumVertices();
            numNewPolygons += polies[p].getNumPolygons();
            ++p;
        }
        int oldNumVertices = ps.getNumVertices();
        ps.setNumVertices(oldNumVertices + numNewVertices);
        int vInd = 0;
        int p2 = 0;
        while (p2 < numNewPs) {
            int numV = polies[p2].getNumVertices();
            int i = 0;
            while (i < numV) {
                ps.setVertexBary(vInd++, polies[p2].getVertexBary(i));
                ++i;
            }
            ++p2;
        }
        int numOldPolies = ps.getNumPolygons();
        ps.setNumPolygons(numOldPolies + numNewPolygons);
        int qInd = numOldPolies;
        vInd = oldNumVertices;
        int p3 = 0;
        while (p3 < numNewPs) {
            int numP = polies[p3].getNumPolygons();
            int q = 0;
            while (q < numP) {
                PiVector oldPolygon = polies[p3].getPolygon(q);
                int len = oldPolygon.getSize();
                PiVector newPolygon = new PiVector(len);
                int i = 0;
                while (i < len) {
                    newPolygon.m_data[i] = vInd + oldPolygon.m_data[i];
                    ++i;
                }
                ps.setPolygon(qInd++, newPolygon);
                ++q;
            }
            vInd += polies[p3].getNumVertices();
            ++p3;
        }
        return numOldPolies;
    }

    public static PgPolygon extractPolygon(PgPolygonSet ps, int ind) {
        PiVector vertices = ps.getPolygon(ind);
        int size = vertices.getSize();
        PgPolygon poly = new PgPolygon(ps.getDimOfVertices());
        poly.setName("Poly " + ind + " of " + ps.getName());
        poly.setNumVertices(size);
        int v = 0;
        while (v < size) {
            poly.setVertex(v, ps.getVertex(vertices.m_data[v]));
            ++v;
        }
        return poly;
    }

    public static PgPolygonSet makePolygonSetFromVertices(PgPointSet geom, PiVector[] cycles) {
        PgPolygonSet polySet = new PgPolygonSet(geom.getDimOfVertices());
        polySet.setNumVertices(geom.getNumVertices());
        polySet.setVertices(geom.getVertices());
        polySet.setNumPolygons(cycles.length);
        if (cycles.length != 0) {
            int i = 0;
            while (i < cycles.length) {
                if (cycles[i] == null) {
                    cycles[i] = new PiVector();
                }
                ++i;
            }
            polySet.setPolygons(cycles);
        }
        return polySet;
    }

    public static PgPolygonSet makePolygonSetFromElements(PgElementSet geom, PiVector[] cycles) {
        PgPolygonSet polySet = new PgPolygonSet(geom.getDimOfVertices());
        int numE = geom.getNumElements();
        polySet.setNumVertices(numE);
        PdVector[] vertices = PdVector.realloc(null, (int)numE, (int)3);
        int e = 0;
        while (e < numE) {
            PiVector element = geom.getElement(e);
            int i = 0;
            while (i < 3) {
                vertices[e].add(geom.getVertex(element.m_data[i]));
                ++i;
            }
            vertices[e].multScalar(0.3333333333333333);
            ++e;
        }
        polySet.setVertices(vertices);
        polySet.setNumPolygons(cycles.length);
        if (cycles.length != 0) {
            polySet.setPolygons(cycles);
        }
        return polySet;
    }

    public static PgPolygonSet convertPolygon(PgPolygon poly) {
        PgPolygonSet ps = new PgPolygonSet();
        ps.setName(poly.getName());
        ps.setNumVertices(poly.getNumVertices());
        ps.setVertices(poly.getVertices());
        ps.setNumPolygons(1);
        int numV = poly.getNumVertices();
        PiVector p = new PiVector(numV);
        int i = 0;
        while (i < numV) {
            p.m_data[i] = i;
            ++i;
        }
        ps.setPolygon(0, p);
        ps.setClosed(0, poly.isClosed());
        return ps;
    }

    public static PgPolygonSet convertPolygons(PgPolygon[] poly) {
        PgPolygonSet ps = new PgPolygonSet();
        int numPolygons = poly.length;
        int p = 0;
        while (p < numPolygons) {
            PgPolygonSet newPs = PnStructurePolygonSet.convertPolygon(poly[p]);
            ps.merge((PgGeometryIf)newPs);
            ++p;
        }
        return ps;
    }
}

