/*
 * Decompiled with CFR 0.152.
 */
package dev.geom;

import dev.vecmath.PiDynVector;
import devGraph.PgAbstractGraph;
import devGraph.PnAbstractGraph;
import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.vecmath.PbVector;
import jv.vecmath.PiVector;
import jvx.geom.PgVertexStar;
import jvx.util.PuQueue;

public class PnStructureElementSet {
    public static PiVector dualEdgeFromVertices(PgElementSet geom, int v0, int v1, int e, PiVector buffer) {
        if (buffer == null) {
            buffer = new PiVector(2);
        } else {
            buffer.setSize(2);
        }
        PgVertexStar star = new PgVertexStar();
        star.makeVertexStar(geom, v0, e);
        PiVector link = star.getLink();
        PiVector elements = star.getElement();
        int index = link.getIndexOf(v1);
        if (index < 0) {
            PsDebug.warning((String)("Vertices " + v0 + " and " + v1 + " are not adjacent"));
            return null;
        }
        buffer.m_data[0] = !star.isClosed() && index == 0 ? -1 : (index == 0 ? elements.getLastEntry() : elements.m_data[index - 1]);
        buffer.m_data[1] = !star.isClosed() && index == link.getSize() - 1 ? -1 : elements.m_data[index];
        return buffer;
    }

    public static PiVector dualEdgeFromElements(PgElementSet geom, int e0, int e1, PiVector buffer) {
        if (buffer == null) {
            buffer = new PiVector(2);
        } else {
            buffer.setSize(2);
        }
        PiVector neighbour = geom.getNeighbour(e0);
        int locInd = neighbour.getIndexOf(e1);
        if (locInd < 0) {
            PsDebug.warning((String)"Elements are not adjacent.");
            return null;
        }
        PiVector element0 = geom.getElement(e0);
        int size = element0.getSize();
        buffer.m_data[0] = element0.m_data[(locInd + 1) % size];
        buffer.m_data[1] = element0.m_data[(locInd + 2) % size];
        return buffer;
    }

    public static PiVector makePatchGeometry(PgElementSet geom, PiVector elem2proxy, PgElementSet approxGeom, PiVector outElem2Proxy) {
        PbVector vertexOnPatchBnd = new PbVector();
        PiVector[] polygons = PnStructureElementSet.makePatchBoundary(geom, elem2proxy, vertexOnPatchBnd);
        PiVector triplePointVertices = PnStructureElementSet.getEndPointList(polygons);
        PnStructureElementSet.makePatchGeometry(geom, approxGeom, triplePointVertices, elem2proxy, vertexOnPatchBnd, outElem2Proxy);
        return triplePointVertices;
    }

    public static PiVector makePatchGeometry(PgElementSet geom, PiVector elem2proxy, PgElementSet approxGeom, PiVector[] patchBoundary, PiVector outElem2Proxy) {
        if (patchBoundary == null) {
            return PnStructureElementSet.makePatchGeometry(geom, elem2proxy, approxGeom, outElem2Proxy);
        }
        PbVector vertexOnPatchBnd = new PbVector();
        vertexOnPatchBnd.setSize(geom.getNumVertices());
        vertexOnPatchBnd.setConstant(false);
        int numPolygons = patchBoundary.length;
        int i = 0;
        while (i < numPolygons) {
            int length = patchBoundary[i].getSize();
            int j = 0;
            while (j < length) {
                vertexOnPatchBnd.m_data[patchBoundary[i].m_data[j]] = true;
                ++j;
            }
            ++i;
        }
        PiVector triplePointVertices = PnStructureElementSet.getEndPointList(patchBoundary);
        PnStructureElementSet.makePatchGeometry(geom, approxGeom, triplePointVertices, elem2proxy, vertexOnPatchBnd, outElem2Proxy);
        return triplePointVertices;
    }

    private static PiVector[] makePatchBoundary(PgElementSet geom, PiVector elem2proxy, PbVector vertexOnPatchBoundary) {
        int noe = geom.getNumElements();
        PgAbstractGraph graph = new PgAbstractGraph();
        graph.setNumNodes(geom.getNumVertices());
        if (vertexOnPatchBoundary != null) {
            vertexOnPatchBoundary.setSize(geom.getNumVertices());
            vertexOnPatchBoundary.setConstant(false);
        }
        int i = 0;
        while (i < noe) {
            PiVector element = geom.getElement(i);
            int elSize = element.getSize();
            PiVector neighbour = geom.getNeighbour(i);
            int j = 0;
            while (j < elSize) {
                if (neighbour.m_data[j] == -1 || elem2proxy.m_data[i] != elem2proxy.m_data[neighbour.m_data[j]] && neighbour.m_data[j] < i) {
                    graph.addEdge(element.m_data[(j + 1) % elSize], element.m_data[(j + 2) % elSize]);
                    if (vertexOnPatchBoundary != null) {
                        vertexOnPatchBoundary.m_data[element.m_data[(j + 1) % elSize]] = true;
                        vertexOnPatchBoundary.m_data[element.m_data[(j + 2) % elSize]] = true;
                    }
                }
                ++j;
            }
            ++i;
        }
        return PnAbstractGraph.splitToPolygons(graph, null);
    }

    public static PiVector[] getPatchBoundary(PgElementSet geom, PiVector elem2Proxy) {
        return PnStructureElementSet.makePatchBoundary(geom, elem2Proxy, null);
    }

    private static PiVector getEndPointList(PiVector[] vectors) {
        PiDynVector outVec = new PiDynVector();
        int num = vectors.length;
        int i = 0;
        while (i < num) {
            if (vectors[i].getSize() >= 1) {
                outVec.appendEntry(vectors[i].getFirstEntry());
                outVec.appendEntry(vectors[i].getLastEntry());
            }
            ++i;
        }
        PiVector piv = outVec.toPiVector();
        piv.sort();
        piv.removeSuccessiveDuplicates();
        return piv;
    }

    private static void makePatchGeometry(PgElementSet geom, PgElementSet approxGeom, PiVector triplePoint, PiVector elem2proxy, PbVector vertexOnPatchBnd, PiVector outElem2Proxy) {
        int nov = geom.getNumVertices();
        int noe = geom.getNumElements();
        int[] nearestTriplePoint = new int[nov];
        boolean[] bEnqueued = new boolean[nov];
        int numTriplePoints = triplePoint.getSize();
        if (numTriplePoints == 0) {
            PsDebug.warning((String)"Triple points are missing.");
            return;
        }
        int[] queue = new int[nov];
        int i = 0;
        while (i < nov) {
            bEnqueued[i] = false;
            nearestTriplePoint[i] = -1;
            queue[i] = -1;
            ++i;
        }
        i = 0;
        while (i < numTriplePoints) {
            bEnqueued[triplePoint.m_data[i]] = true;
            nearestTriplePoint[triplePoint.m_data[i]] = triplePoint.m_data[i];
            queue[i] = triplePoint.m_data[i];
            ++i;
        }
        int nextFreeIndex = numTriplePoints;
        PgVertexStar vertStar = new PgVertexStar();
        PiVector vert2elem = PgVertexStar.getElementPerVertex((PgElementSet)geom);
        int i2 = 0;
        while (i2 < nov) {
            if (queue[i2] == -1) break;
            vertStar.makeVertexStar(geom, queue[i2], vert2elem.m_data[queue[i2]]);
            PiVector starElement = vertStar.getElement();
            PiVector locInd = vertStar.getVertexLocInd();
            int starSize = starElement.getSize();
            int j = 0;
            while (j < starSize) {
                PiVector element = geom.getElement(starElement.m_data[j]);
                int elSize = element.getSize();
                PiVector neighbour = geom.getNeighbour(starElement.m_data[j]);
                int k = 0;
                while (k < 1) {
                    int neighIndex = neighbour.m_data[(locInd.m_data[j] + elSize - 1 - k) % elSize];
                    int vertexIndex = element.m_data[(locInd.m_data[j] + elSize + 1 - 2 * k) % elSize];
                    if (!bEnqueued[vertexIndex] && vertexOnPatchBnd.m_data[vertexIndex] && (neighIndex == -1 || elem2proxy.m_data[starElement.m_data[j]] != elem2proxy.m_data[neighIndex])) {
                        bEnqueued[vertexIndex] = true;
                        nearestTriplePoint[vertexIndex] = nearestTriplePoint[queue[i2]];
                        queue[nextFreeIndex] = vertexIndex;
                        ++nextFreeIndex;
                    }
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < nov) {
            bEnqueued[i2] = false;
            queue[i2] = -1;
            ++i2;
        }
        i2 = 0;
        while (i2 < numTriplePoints) {
            queue[i2] = triplePoint.m_data[i2];
            bEnqueued[triplePoint.m_data[i2]] = true;
            ++i2;
        }
        nextFreeIndex = numTriplePoints;
        i2 = 0;
        while (i2 < nov) {
            if (queue[i2] == -1) {
                PsDebug.warning((String)"Disc growing from Triple Points failed");
                return;
            }
            vertStar.makeVertexStar(geom, queue[i2], vert2elem.m_data[queue[i2]]);
            PiVector link = vertStar.getLink();
            int linkSize = link.getSize();
            int j = 0;
            while (j < linkSize) {
                if (!bEnqueued[link.m_data[j]]) {
                    bEnqueued[link.m_data[j]] = true;
                    if (nearestTriplePoint[link.m_data[j]] == -1) {
                        nearestTriplePoint[link.m_data[j]] = nearestTriplePoint[queue[i2]];
                    }
                    queue[nextFreeIndex] = link.m_data[j];
                    ++nextFreeIndex;
                }
                ++j;
            }
            ++i2;
        }
        int newNoe = 0;
        int i3 = 0;
        while (i3 < noe) {
            PiVector element = geom.getElement(i3);
            int elSize = element.getSize();
            int j = 0;
            while (j < elSize - 2) {
                if (nearestTriplePoint[element.m_data[0]] != nearestTriplePoint[element.m_data[j + 1]] && nearestTriplePoint[element.m_data[0]] != nearestTriplePoint[element.m_data[j + 2]] && nearestTriplePoint[element.m_data[j + 1]] != nearestTriplePoint[element.m_data[j + 2]]) {
                    ++newNoe;
                }
                ++j;
            }
            ++i3;
        }
        PiVector[] newElements = PiVector.realloc(null, (int)newNoe, (int)3);
        if (outElem2Proxy != null) {
            outElem2Proxy.setSize(newNoe);
        }
        newNoe = 0;
        int[] newIndex = new int[nov];
        int i4 = 0;
        while (i4 < numTriplePoints) {
            newIndex[triplePoint.m_data[i4]] = i4;
            ++i4;
        }
        i4 = 0;
        while (i4 < noe) {
            PiVector element = geom.getElement(i4);
            int elSize = element.getSize();
            int j = 0;
            while (j < elSize - 2) {
                if (nearestTriplePoint[element.m_data[0]] != nearestTriplePoint[element.m_data[j + 1]] && nearestTriplePoint[element.m_data[0]] != nearestTriplePoint[element.m_data[j + 2]] && nearestTriplePoint[element.m_data[j + 1]] != nearestTriplePoint[element.m_data[j + 2]]) {
                    newElements[newNoe].m_data[0] = newIndex[nearestTriplePoint[element.m_data[0]]];
                    newElements[newNoe].m_data[1] = newIndex[nearestTriplePoint[element.m_data[j + 1]]];
                    newElements[newNoe].m_data[2] = newIndex[nearestTriplePoint[element.m_data[j + 2]]];
                    if (outElem2Proxy != null) {
                        outElem2Proxy.m_data[newNoe] = elem2proxy.m_data[i4];
                    }
                    ++newNoe;
                }
                ++j;
            }
            ++i4;
        }
        approxGeom.setNumElements(newNoe);
        approxGeom.setElements(newElements);
        approxGeom.setDimOfElements(3);
        approxGeom.showElementColors(true);
        approxGeom.setNumVertices(numTriplePoints);
        i4 = 0;
        while (i4 < numTriplePoints) {
            approxGeom.setVertex(i4, geom.getVertex(triplePoint.m_data[i4]));
            ++i4;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    public static int enumerateRegionsFromTags(PiVector tags, PiVector[] neighbours, PiVector nodeInRegion, PiVector tagInRegion) {
        numNodes = tags.getSize();
        if (numNodes != neighbours.length) {
            PsDebug.warning((String)"Size of tags must be equal to length of neighbours array");
            return -1;
        }
        nodeInRegion.setSize(numNodes);
        nodeInRegion.setConstant(-1);
        queue = new PuQueue(numNodes);
        dynTagInRegion = null;
        if (tagInRegion != null) {
            dynTagInRegion = new PiDynVector();
        }
        numRegions = 0;
        while (true) {
            block10: {
                block11: {
                    block9: {
                        eInd = -1;
                        e = 0;
                        while (e < numNodes) {
                            if (nodeInRegion.m_data[e] < 0 && tags.m_data[e] >= 0) {
                                eInd = e;
                                break;
                            }
                            ++e;
                        }
                        if (eInd >= 0) break block9;
                        if (dynTagInRegion == null) break block10;
                        break block11;
                    }
                    queue.removeAll();
                    queue.enqueue(eInd);
                    faceIndex = numRegions;
                    if (dynTagInRegion != null) {
                        dynTagInRegion.appendEntry(tags.m_data[eInd]);
                    }
                    ++numRegions;
                    if (true) ** GOTO lbl52
                }
                tagInRegion.setSize(numRegions);
                dynTagInRegion.toPiVector(tagInRegion);
            }
            return numRegions;
            do {
                if (nodeInRegion.m_data[e = queue.extractFirst()] >= 0) continue;
                nodeInRegion.m_data[e] = faceIndex;
                neighb = neighbours[e];
                numNeighb = neighb.getSize();
                n = 0;
                while (n < numNeighb) {
                    ne = neighb.m_data[n];
                    if (ne >= 0 && nodeInRegion.m_data[ne] < 0 && tags.m_data[ne] == tags.m_data[e]) {
                        queue.enqueue(ne);
                    }
                    ++n;
                }
lbl52:
                // 3 sources

            } while (!queue.isEmpty());
        }
    }
}

