/*
 * Decompiled with CFR 0.152.
 */
package dev.geom;

import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.vecmath.PdVector;
import jv.vecmath.PuMath;

public class PgVertexSphere
extends PgElementSet {
    protected PgPointSet m_geom;
    protected PgElementSet m_spheres;
    protected PuDouble m_radius;
    protected PuInteger m_numULines;
    protected PuInteger m_numVLines;

    public PgVertexSphere() {
        super(3);
        this.setTag(10);
        this.m_radius = new PuDouble("Radius", (PsUpdateIf)this);
        this.m_numULines = new PuInteger("Num u lines", (PsUpdateIf)this);
        this.m_numVLines = new PuInteger("Num v lines", (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == PgVertexSphere.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_radius.setDefBounds(0.0, 1.0, 0.1, 0.1);
        this.m_radius.setDefValue(1.0);
        this.m_radius.init();
        this.m_numULines.setDefBounds(2, 16, 1, 1);
        this.m_numULines.setDefValue(8);
        this.m_numULines.init();
        this.m_numVLines.setDefBounds(2, 16, 1, 1);
        this.m_numVLines.setDefValue(8);
        this.m_numVLines.init();
    }

    public boolean guessThicknessFromDiameter() {
        double diam = this.m_geom.getDiameter();
        if (diam < 1.0E-10) {
            return false;
        }
        double exp = Math.round(Math.log(diam) / Math.log(10.0) + 0.5);
        double diamRnd = PuMath.exp((double)10.0, (double)exp);
        diamRnd = PuMath.precision((double)diamRnd, (double)0.001);
        this.m_radius.setValue(diamRnd / 100.0);
        return true;
    }

    public void setPointSet(PgPointSet geom) {
        if (this.m_geom == geom) {
            return;
        }
        if (this.m_geom != null) {
            this.m_geom.removeUpdateListener((PsUpdateIf)this);
        }
        this.m_geom = geom;
        this.m_geom.addUpdateListener((PsUpdateIf)this);
        this.guessThicknessFromDiameter();
    }

    public boolean update(Object event) {
        PsDebug.notify((String)"called");
        if (event == null) {
            return super.update(event);
        }
        if (event == this.m_geom || event == this.m_radius || event == this.m_numULines || event == this.m_numVLines) {
            this.computeSpheres();
            return super.update((Object)this);
        }
        return super.update(event);
    }

    public void computeSpheres() {
        PgVertexSphere.computeSpheres(this, this.m_geom, this.m_numULines.getValue(), this.m_numVLines.getValue(), this.m_radius.getValue());
    }

    public static void computeSpheres(PgElementSet es, PgPointSet ps, int numULines, int numVLines, double radius) {
        if (ps == null) {
            es.setNumElements(0);
            es.setNumVertices(0);
            return;
        }
        PgElementSet sphereGeom = new PgElementSet(3);
        sphereGeom.computeSphere(numULines, numVLines, radius);
        int numSphereVertices = sphereGeom.getNumVertices();
        int numSphereElements = sphereGeom.getNumElements();
        int numV = ps.getNumVertices();
        es.setNumVertices(numV * numSphereVertices);
        es.setNumElements(numV * numSphereElements);
        int v = 0;
        while (v < numV) {
            int i = 0;
            while (i < numSphereVertices) {
                PdVector vertex = ps.getVertex(v);
                es.setVertex(numSphereVertices * v + i, sphereGeom.getVertex(i));
                es.getVertex(numSphereVertices * v + i).add(vertex);
                ++i;
            }
            int e = 0;
            while (e < numSphereElements) {
                es.setElement(numSphereElements * v + e, sphereGeom.getElement(e));
                int dim = es.getDimOfElement(numSphereElements * v + e);
                int i2 = 0;
                while (i2 < dim) {
                    int n = i2++;
                    es.getElement((int)(numSphereElements * v + e)).m_data[n] = es.getElement((int)(numSphereElements * v + e)).m_data[n] + numSphereVertices * v;
                }
                ++e;
            }
            ++v;
        }
        es.makeNeighbour();
    }
}

