/*
 * Decompiled with CFR 0.152.
 */
package dev.geom;

import dev.geom.PgPointSet_Menu;
import jv.geom.PgElementSet;
import jv.geom.PgTetraSet;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.project.PvViewerIf;
import jv.vecmath.PiVector;
import jvx.project.PjWorkshop_Dialog;
import jvx.volume.PwTetraSet;

public class PgTetraSet_Menu
extends PgPointSet_Menu {
    public static final int MTHD_LEVEL_SURFACE = 0;
    public static final int MTHD_MAKE_BOUNDARY = 1;
    public static final int MTHD_CONVERT_TO_ELEMENT_SET = 2;
    public static final int MTHD_ADD_TEST_VECTOR_FIELD = 3;
    public static final int MTHD_TEST_EDGE_STARS = 4;
    public static final int MTHD_TEST_VERTEX_STARS = 5;
    public static final int MTHD_ADD_TEST_FRAME_FIELD = 6;
    public static final int MTHD_ADD_TEST_TEXTURE = 7;
    public static final int MTHD_MARK_BOUNDARY_VERTICES = 8;
    public String[] m_tetraSetMethod = new String[]{"Level Surface ...", "Make Boundary", "Convert to ElementSet", "Add Test Vector Field", "Test Edge Stars", "Test Vertex Stars", "Add Test Frame Field", "Add Test Texture", "Mark Boundary Vertices"};
    protected PgTetraSet m_tetraSet;

    @Override
    public void init(PsObject anObject) {
        super.init(anObject);
        this.m_tetraSet = (PgTetraSet)anObject;
        String menuMark = PsConfig.getMessage((int)21050);
        this.addMenuItem(menuMark, this.m_tetraSetMethod[8]);
        String menuDev = "Develop";
        this.addMenu(menuDev);
        this.addMenuItem(menuDev, this.m_tetraSetMethod[0]);
        this.addMenuItem(menuDev, this.m_tetraSetMethod[1]);
        this.addMenuItem(menuDev, this.m_tetraSetMethod[2]);
        this.addMenuItem(menuDev, this.m_tetraSetMethod[3]);
        this.addMenuItem(menuDev, this.m_tetraSetMethod[4]);
        this.addMenuItem(menuDev, this.m_tetraSetMethod[5]);
        this.addMenuItem(menuDev, this.m_tetraSetMethod[6]);
        this.addMenuItem(menuDev, this.m_tetraSetMethod[7]);
    }

    @Override
    public boolean applyMethod(String aMethod) {
        if (super.applyMethod(aMethod)) {
            return true;
        }
        PsDebug.notify((String)("trying method = " + aMethod));
        PvDisplayIf currDisp = null;
        PvViewerIf viewer = this.getViewer();
        if (viewer == null) {
            PsDebug.warning((String)"missing viewer");
        } else {
            currDisp = viewer.getDisplay();
        }
        int found = PgTetraSet_Menu.getIndexOfMethod((String[])this.m_tetraSetMethod, (String)aMethod);
        switch (found) {
            case 0: {
                PwTetraSet ls = new PwTetraSet();
                ls.setGeometry((PgGeometry)this.m_tetraSet);
                if (currDisp != null) {
                    ls.setDisplay(currDisp);
                }
                PjWorkshop_Dialog dialog = new PjWorkshop_Dialog(false);
                dialog.setParent((PsUpdateIf)ls);
                dialog.update((Object)ls);
                ls.computeLevelSurface();
                if (currDisp != null) {
                    currDisp.addGeometry((PgGeometryIf)ls.getSurface());
                }
                dialog.setVisible(true);
                break;
            }
            case 1: {
                PwTetraSet.makeBoundary((PgTetraSet)this.m_tetraSet);
                if (currDisp == null || this.m_tetraSet.getBoundaries() == null || this.m_tetraSet.getBoundaries().length <= 0 || this.m_tetraSet.getBoundaries()[0] == null || currDisp.containsGeometry((PgGeometryIf)this.m_tetraSet.getBoundaries()[0])) break;
                currDisp.addGeometry((PgGeometryIf)this.m_tetraSet.getBoundaries()[0]);
                break;
            }
            case 2: {
                PgElementSet es = PwTetraSet.convertToElementSet((PgTetraSet)this.m_tetraSet);
                if (currDisp == null) break;
                currDisp.addGeometry((PgGeometryIf)es);
                break;
            }
            case 3: {
                PwTetraSet.addTestVectorField((PgTetraSet)this.m_tetraSet);
                this.m_tetraSet.showVectorFields(true);
                this.m_tetraSet.update((Object)this.m_tetraSet);
                break;
            }
            case 4: {
                PwTetraSet.testEdgeStars((PgTetraSet)this.m_tetraSet);
                break;
            }
            case 5: {
                PwTetraSet.testVertexStars((PgTetraSet)this.m_tetraSet);
                break;
            }
            case 6: {
                PwTetraSet.addTestFrameField((PgTetraSet)this.m_tetraSet, (boolean)true);
                this.m_tetraSet.showVectorFields(true);
                this.m_tetraSet.update((Object)this.m_tetraSet);
                break;
            }
            case 7: {
                PwTetraSet.addTestTexture((PgTetraSet)this.m_tetraSet);
                this.m_tetraSet.update((Object)this.m_tetraSet);
                break;
            }
            case 8: {
                int numTets = this.m_tetraSet.getNumTetras();
                int i = 0;
                while (i < numTets) {
                    PiVector tn = this.m_tetraSet.getNeighbour(i);
                    int j = 0;
                    while (j < 4) {
                        if (tn.m_data[j] == -1) {
                            int k = 0;
                            while (k < 3) {
                                this.m_tetraSet.setTagVertex(this.m_tetraSet.getTetra((int)i).m_data[(j + 1 + k) % 4], 1);
                                ++k;
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
                this.m_tetraSet.update((Object)this.m_tetraSet);
                break;
            }
            case -1: {
                return false;
            }
            default: {
                PsDebug.warning((String)("method string = " + aMethod + " does not match a constant"));
                return false;
            }
        }
        return true;
    }
}

