/*
 * Decompiled with CFR 0.152.
 */
package dev.geom;

import dev.geom.PgVertexSphere;
import dev.geom.PwCageDeformComplex;
import dev.vector.PwInterpolateVectorFields;
import devProjection.PwProjection;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PgGeometry_Menu;
import jv.project.PvDisplayIf;
import jv.vecmath.PdVector;
import jv.vecmath.PuVectorGeom;
import jvx.material.PwAdjustColors;
import jvx.material.PwMaterial;
import jvx.project.PjWorkshop_Dialog;

public class PgPointSet_Menu
extends PgGeometry_Menu {
    public static final int MTHD_INDIVIDUAL_MATERIAL = 0;
    public static final int MTHD_CAGE_DEFORM_COMPLEX = 1;
    public static final int MTHD_NORMALIZE_VECTOR_FIELD = 2;
    public static final int MTHD_PROJECT_VECTOR_FIELD = 3;
    public static final int MTHD_HSB = 4;
    public static final int MTHD_RGB = 5;
    public static final int MTHD_MAKE_SPHERE = 6;
    public static final int MTHD_PROJECT = 7;
    public static final int MTHD_INTERPOLATE_VECTOR_FIELDS = 8;
    public String[] m_pointSetMethod = new String[]{"Individual Material ...", "Deform using Cage (Complex Coord.)", "Normalize Vector Field", "Project Vector Field to Tangent Planes", "Adjust Individual Colors HSB", "Adjust Individual Colors RGB", "Make spheres from vertices", "Project...", "Interpolate Vector Fields..."};
    protected PgPointSet m_pointSet;

    public void init(PsObject anObject) {
        super.init(anObject);
        this.m_pointSet = (PgPointSet)anObject;
        String menuDev = "Develop";
        this.addMenu(menuDev);
        this.addMenuItem(menuDev, this.m_pointSetMethod[0]);
        if (this.m_pointSet.getDimOfVertices() == 2) {
            this.addMenuItem(menuDev, this.m_pointSetMethod[1]);
        }
        this.addMenuItem(menuDev, this.m_pointSetMethod[2]);
        this.addMenuItem(menuDev, this.m_pointSetMethod[3]);
        this.addMenuItem(menuDev, this.m_pointSetMethod[4]);
        this.addMenuItem(menuDev, this.m_pointSetMethod[5]);
        this.addMenuItem(menuDev, this.m_pointSetMethod[6]);
        this.addMenuItem(menuDev, this.m_pointSetMethod[7]);
        this.addMenuItem(menuDev, this.m_pointSetMethod[8]);
    }

    public boolean applyMethod(String aMethod) {
        if (super.applyMethod(aMethod)) {
            return true;
        }
        PsDebug.notify((String)("trying method = " + aMethod));
        PvDisplayIf currDisp = null;
        if (this.getViewer() == null) {
            PsDebug.warning((String)"missing viewer");
        } else {
            currDisp = this.getViewer().getDisplay();
        }
        switch (PgPointSet_Menu.getIndexOfMethod((String[])this.m_pointSetMethod, (String)aMethod)) {
            case 0: {
                PwMaterial pwMaterial = new PwMaterial();
                pwMaterial.setGeometry((PgGeometry)this.m_pointSet);
                pwMaterial.setDisplay(currDisp);
                PjWorkshop_Dialog dialog = new PjWorkshop_Dialog(false);
                dialog.setParent((PsUpdateIf)pwMaterial);
                dialog.update((Object)pwMaterial);
                dialog.setVisible(true);
                break;
            }
            case 1: {
                PwCageDeformComplex pwCageDC = new PwCageDeformComplex();
                pwCageDC.setGeometry((PgGeometry)this.m_pointSet);
                pwCageDC.setDisplay(currDisp);
                PjWorkshop_Dialog dialog = new PjWorkshop_Dialog(false);
                dialog.setParent((PsUpdateIf)pwCageDC);
                dialog.update((Object)pwCageDC);
                dialog.setVisible(true);
                break;
            }
            case 2: {
                PgVectorField field = this.m_pointSet.getSelectedVectorField();
                if (field == null) {
                    PsDebug.warning((String)"No vector field selected.");
                    return true;
                }
                int numV = field.getNumVectors();
                int i = 0;
                while (i < numV) {
                    field.getVector(i).normalize();
                    ++i;
                }
                this.m_pointSet.update((Object)this.m_pointSet);
                break;
            }
            case 3: {
                PgVectorField field = this.m_pointSet.getSelectedVectorField();
                if (field == null) {
                    PsDebug.warning((String)"No vector field selected.");
                    return true;
                }
                if (field.getBasedOn() == 0) {
                    int numV = this.m_pointSet.getNumVertices();
                    int v = 0;
                    while (v < numV) {
                        PuVectorGeom.projectOntoPlane((PdVector)field.getVector(v), (PdVector)this.m_pointSet.getVertexNormal(v));
                        ++v;
                    }
                } else if (this.m_pointSet instanceof PgElementSet) {
                    PgElementSet geom = (PgElementSet)this.m_pointSet;
                    int numE = geom.getNumElements();
                    int e = 0;
                    while (e < numE) {
                        PuVectorGeom.projectOntoPlane((PdVector)field.getVector(e), (PdVector)geom.getElementNormal(e));
                        ++e;
                    }
                }
                this.m_pointSet.update((Object)this.m_pointSet);
                break;
            }
            case 4: {
                PwAdjustColors pwAdjustHSB = new PwAdjustColors();
                pwAdjustHSB.setMode(1);
                pwAdjustHSB.setGeometry((PgGeometry)this.m_pointSet);
                pwAdjustHSB.setDisplay(currDisp);
                PjWorkshop_Dialog dialog = new PjWorkshop_Dialog(false);
                dialog.setParent((PsUpdateIf)pwAdjustHSB);
                dialog.update((Object)pwAdjustHSB);
                dialog.setVisible(true);
                break;
            }
            case 5: {
                PwAdjustColors pwAdjustRGB = new PwAdjustColors();
                pwAdjustRGB.setMode(0);
                pwAdjustRGB.setGeometry((PgGeometry)this.m_pointSet);
                pwAdjustRGB.setDisplay(currDisp);
                PjWorkshop_Dialog dialog = new PjWorkshop_Dialog(false);
                dialog.setParent((PsUpdateIf)pwAdjustRGB);
                dialog.update((Object)pwAdjustRGB);
                dialog.setVisible(true);
                break;
            }
            case 6: {
                PgVertexSphere sphere = new PgVertexSphere();
                sphere.setName("Spheres of " + this.m_pointSet.getName());
                sphere.setPointSet(this.m_pointSet);
                if (currDisp != null) {
                    currDisp.addGeometry((PgGeometryIf)sphere);
                    currDisp.update((Object)currDisp);
                    currDisp.selectGeometry((PgGeometryIf)sphere);
                }
                if (this.getViewer() == null) break;
                this.getViewer().showPanel(17);
                break;
            }
            case 7: {
                PwProjection pwProject = new PwProjection();
                pwProject.setGeometry((PgGeometry)this.m_pointSet);
                pwProject.setDisplay(currDisp);
                PjWorkshop_Dialog dialog = new PjWorkshop_Dialog(false);
                dialog.setParent((PsUpdateIf)pwProject);
                dialog.update((Object)pwProject);
                dialog.setVisible(true);
                break;
            }
            case 8: {
                PwInterpolateVectorFields ivf = new PwInterpolateVectorFields();
                ivf.setGeometry((PgGeometry)this.m_pointSet);
                PjWorkshop_Dialog dialog = new PjWorkshop_Dialog(false);
                dialog.setParent((PsUpdateIf)ivf);
                dialog.update((Object)ivf);
                dialog.setVisible(true);
                break;
            }
            case -1: {
                return false;
            }
            default: {
                PsDebug.warning((String)("method string = " + aMethod + " does not match a constant"));
                return false;
            }
        }
        return true;
    }
}

