/*
 * Decompiled with CFR 0.152.
 */
package dev.geom;

import java.awt.Color;
import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgVertexStar;

public class PgNonConforming
extends PgElementSet {
    protected PgElementSet m_elementSet;
    public static final int ELEMENT_COLOR_GLOBAL = 0;
    public static final int ELEMENT_COLOR_FROM_VERTEX = 1;
    public static final int ELEMENT_COLOR_FROM_ELEMENT = 2;
    protected int m_elementColorMode = 0;

    public PgNonConforming(int aDim) {
        super(aDim);
        this.setTag(10);
        if (((Object)((Object)this)).getClass() == PgNonConforming.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.showElements(true);
        this.showTransparency(true);
        this.showVertices(false);
        this.showBoundaries(true);
        this.setGlobalBndSize(1.0);
        this.setGlobalBndColor(Color.black);
        this.showEdges(false);
    }

    public Object clone() {
        PgNonConforming clone = (PgNonConforming)((Object)super.clone());
        if (clone == null) {
            return null;
        }
        if (this.m_elementSet != null) {
            clone.setElementSet(this.m_elementSet);
        }
        clone.setElementColorMode(this.m_elementColorMode);
        return clone;
    }

    public void copy(PsObject object) {
        super.copy(object);
        if (object == null) {
            return;
        }
        if (!(object instanceof PgNonConforming)) {
            return;
        }
        PgNonConforming geom = (PgNonConforming)object;
        this.setElementColorMode(geom.getElementColorMode());
        this.setElementSet(geom.m_elementSet);
    }

    public void setElementSet(PgElementSet elementSet) {
        if (elementSet == null) {
            PsDebug.warning((String)"missing elementSet");
            return;
        }
        if (this.m_elementSet == elementSet) {
            return;
        }
        this.removeElementSet();
        this.m_elementSet = elementSet;
        this.m_elementSet.addUpdateListener((PsUpdateIf)this);
    }

    public void removeElementSet() {
        if (this.m_elementSet == null) {
            return;
        }
        this.m_elementSet.removeUpdateListener((PsUpdateIf)this);
        this.m_elementSet = null;
    }

    public void setElementColorMode(int mode) {
        this.m_elementColorMode = mode;
    }

    public int getElementColorMode() {
        return this.m_elementColorMode;
    }

    public boolean update(Object event) {
        if (event != null && event == this.m_elementSet) {
            this.computeSurface();
            return super.update((Object)this);
        }
        return super.update(event);
    }

    public void computeSurface() {
        if (this.m_elementSet == null) {
            PsDebug.warning((String)"missing elementSet");
            return;
        }
        if (!this.m_elementSet.checkNeighbour(false)) {
            this.m_elementSet.makeNeighbour();
        }
        int noe = this.m_elementSet.getNumElements();
        int nov = this.m_elementSet.getNumVertices();
        int dim = this.m_elementSet.getDimOfVertices();
        int[] startEl = new int[noe];
        int newNoe = 0;
        int numEdges = this.m_elementSet.getNumEdges();
        PiVector[] element = this.m_elementSet.getElements();
        PiVector[] neighbour = this.m_elementSet.getNeighbours();
        int i = 0;
        while (i < noe) {
            int elSize = element[i].getSize();
            startEl[i] = newNoe;
            newNoe += elSize;
            ++i;
        }
        int newNov = nov + newNoe + numEdges;
        this.setNumVertices(newNov);
        this.setDimOfElements(4);
        this.setNumElements(newNoe);
        this.assureNeighbours();
        if (this.m_elementColorMode != 0) {
            this.assureElementColors();
            this.showElementColors(true);
        } else {
            this.showElementColors(false);
        }
        PdVector[] avgVertex = PdVector.realloc(null, (int)nov, (int)dim);
        int[] vertexValence = new int[nov];
        int nextVertexInd = nov + newNoe;
        int i2 = 0;
        while (i2 < noe) {
            int elSize = element[i2].getSize();
            int j = 0;
            while (j < elSize) {
                int index = startEl[i2] + j;
                this.m_element[index].m_data[0] = element[i2].m_data[j];
                this.m_element[index].m_data[2] = index + nov;
                avgVertex[element[i2].m_data[j]].add(this.m_elementSet.getVertex(element[i2].m_data[(j + 1) % elSize]));
                int n = element[i2].m_data[j];
                vertexValence[n] = vertexValence[n] + 1;
                avgVertex[element[i2].m_data[(j + 1) % elSize]].add(this.m_elementSet.getVertex(element[i2].m_data[j]));
                int n2 = element[i2].m_data[(j + 1) % elSize];
                vertexValence[n2] = vertexValence[n2] + 1;
                if (this.m_elementColorMode == 1) {
                    this.m_elementColor[index] = this.m_elementSet.hasVertexColors() ? this.m_elementSet.getVertexColor(element[i2].m_data[j]) : this.m_elementSet.getGlobalVertexColor();
                } else if (this.m_elementColorMode == 2) {
                    this.m_elementColor[index] = this.m_elementSet.hasElementColors() ? this.m_elementSet.getElementColor(i2) : this.m_elementSet.getGlobalElementColor();
                }
                ++j;
            }
            j = 0;
            while (j < elSize) {
                if (neighbour[i2].m_data[j] < i2) {
                    this.setVertex(nextVertexInd, PdVector.blendNew((double)0.5, (PdVector)this.m_elementSet.getVertex(element[i2].m_data[(j + 1) % elSize]), (double)0.5, (PdVector)this.m_elementSet.getVertex(element[i2].m_data[(j + 2) % elSize])));
                    this.m_element[startEl[i2] + (j + 1) % elSize].m_data[1] = nextVertexInd;
                    this.m_element[startEl[i2] + (j + 2) % elSize].m_data[3] = nextVertexInd;
                    if (neighbour[i2].m_data[j] == -1) {
                        this.m_neighbour[startEl[i2] + (j + 1) % elSize].m_data[3] = -1;
                        this.m_neighbour[startEl[i2] + (j + 2) % elSize].m_data[2] = -1;
                    } else {
                        int nn = neighbour[i2].m_data[j];
                        int neighSize = element[nn].getSize();
                        int oppLocInd = this.m_elementSet.getOppVertexLocInd(i2, j);
                        int ind0 = (oppLocInd + 1) % neighSize;
                        int ind1 = (oppLocInd + 2) % neighSize;
                        this.m_element[startEl[nn] + ind0].m_data[1] = nextVertexInd;
                        this.m_element[startEl[nn] + ind1].m_data[3] = nextVertexInd;
                        if (element[i2].m_data[(j + 1) % elSize] == element[nn].m_data[ind1]) {
                            this.m_neighbour[startEl[i2] + (j + 1) % elSize].m_data[3] = startEl[nn] + ind1;
                            this.m_neighbour[startEl[nn] + ind1].m_data[2] = startEl[i2] + (j + 1) % elSize;
                            this.m_neighbour[startEl[i2] + (j + 2) % elSize].m_data[2] = startEl[nn] + ind0;
                            this.m_neighbour[startEl[nn] + ind0].m_data[3] = startEl[i2] + (j + 2) % elSize;
                        } else {
                            this.m_neighbour[startEl[i2] + (j + 1) % elSize].m_data[3] = startEl[nn] + ind0;
                            this.m_neighbour[startEl[nn] + ind0].m_data[3] = startEl[i2] + (j + 1) % elSize;
                            this.m_neighbour[startEl[i2] + (j + 2) % elSize].m_data[2] = startEl[nn] + ind1;
                            this.m_neighbour[startEl[nn] + ind1].m_data[2] = startEl[i2] + (j + 2) % elSize;
                        }
                    }
                    ++nextVertexInd;
                }
                ++j;
            }
            ++i2;
        }
        PdVector vertexNormal = new PdVector(dim);
        PdVector diff = new PdVector(dim);
        PdVector e1 = new PdVector(this.m_dim);
        PdVector e2 = new PdVector(this.m_dim);
        PgVertexStar vs = new PgVertexStar();
        boolean[] vertexProcessed = new boolean[nov];
        int i3 = 0;
        while (i3 < nov) {
            vertexProcessed[i3] = false;
            ++i3;
        }
        i3 = 0;
        while (i3 < noe) {
            int elSize = element[i3].getSize();
            int j = 0;
            while (j < elSize) {
                int index = element[i3].m_data[j];
                if (!vertexProcessed[index]) {
                    vs.makeVertexStar(this.m_elementSet, index, i3);
                    PiVector link = vs.getLink();
                    int linkSize = link.getSize();
                    if (linkSize == 2) {
                        e1.sub(this.m_elementSet.getVertex(link.m_data[0]), this.m_elementSet.getVertex(index));
                        e2.sub(this.m_elementSet.getVertex(link.m_data[1]), this.m_elementSet.getVertex(index));
                        vertexNormal.cross(e1, e2);
                    } else {
                        vertexNormal.setConstant(0.0);
                        int k = 0;
                        while (k < linkSize) {
                            e1.sub(this.m_elementSet.getVertex(link.m_data[(k + 2) % linkSize]), this.m_elementSet.getVertex(link.m_data[(k + 1) % linkSize]));
                            e2.sub(this.m_elementSet.getVertex(link.m_data[k]), this.m_elementSet.getVertex(link.m_data[(k + 1) % linkSize]));
                            vertexNormal.add(PdVector.crossNew((PdVector)e1, (PdVector)e2));
                            ++k;
                        }
                    }
                    this.m_vertex[index].copy(this.m_elementSet.getVertex(index));
                    if (dim == 3) {
                        vertexNormal.normalize();
                        avgVertex[index].multScalar(1.0 / (double)vertexValence[index]);
                        diff.sub(this.m_vertex[index], avgVertex[index]);
                        this.m_vertex[index].blendBase(this.m_vertex[index], -PdVector.dot((PdVector)vertexNormal, (PdVector)diff) / 2.0, vertexNormal);
                    }
                    vertexProcessed[index] = true;
                }
                ++j;
            }
            ++i3;
        }
        double area = 0.0;
        PdVector a = new PdVector(this.m_dim);
        PdVector b = new PdVector(this.m_dim);
        PdVector c = new PdVector(this.m_dim);
        PdVector ja = new PdVector(this.m_dim);
        int i4 = 0;
        while (i4 < noe) {
            int elSize = element[i4].getSize();
            int j = 0;
            while (j < elSize) {
                int index = startEl[i4] + j;
                area = PdVector.area((PdVector)this.m_vertex[this.m_element[index].m_data[0]], (PdVector)this.m_vertex[this.m_element[index].m_data[1]], (PdVector)this.m_vertex[this.m_element[index].m_data[3]]);
                if (area < 1.0E-10) {
                    this.m_vertex[index + nov].blend(0.5, this.m_vertex[this.m_element[index].m_data[1]], 0.5, this.m_vertex[this.m_element[index].m_data[3]]);
                } else {
                    a.sub(this.m_vertex[this.m_element[index].m_data[1]], this.m_vertex[this.m_element[index].m_data[0]]);
                    b.sub(this.m_vertex[this.m_element[index].m_data[0]], this.m_vertex[this.m_element[index].m_data[3]]);
                    c.sub(this.m_vertex[this.m_element[index].m_data[3]], this.m_vertex[this.m_element[index].m_data[1]]);
                    ja.blend(-PdVector.dot((PdVector)a, (PdVector)c) / 2.0 / area, b, PdVector.dot((PdVector)a, (PdVector)b) / 2.0 / area, c);
                    this.m_vertex[index + nov].blendBase(this.m_vertex[this.m_element[index].m_data[1]], PdVector.dot((PdVector)c, (PdVector)b) / 2.0 / area, ja);
                }
                ++j;
            }
            ++i4;
        }
    }
}

