/*
 * Decompiled with CFR 0.152.
 */
package dev.geom;

import dev.geom.PgPointSet_Menu;
import java.awt.CheckboxMenuItem;
import java.util.Enumeration;
import jv.geom.PgElementSet;
import jv.geom.PgPolygonSet;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.project.PvViewerIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.project.PjWorkshop_Dialog;
import jvx.volume.PgCubeSet;
import jvx.volume.PgSmallCubes;
import jvx.volume.PwCubeSet;
import jvx.volume.PwStc;

public class PgCubeSet_Menu
extends PgPointSet_Menu {
    public static final int MTHD_CHECK_NEIGHBOUR = 0;
    public static final int MTHD_MAKE_NEIGHBOUR = 1;
    public static final int MTHD_REMOVE_UNUSED_VERTICES = 2;
    public static final int MTHD_MARK_CUBES = 3;
    public static final int MTHD_UNMARK_CUBES = 4;
    public static final int MTHD_REMOVE_MARKED_CUBES = 5;
    public static final int MTHD_SHOW_MARKED_CUBES = 6;
    public static final int MTHD_TRIANGULATE = 7;
    public static final int MTHD_REFINE_INTO_EIGHT = 8;
    public static final int MTHD_SHOW_GLOBAL_CUBE_COLOR = 9;
    public static final int MTHD_MAKE_CUBE_COLOR_FROM_XYZ = 10;
    public static final int MTHD_MAKE_CUBE_COLOR_FROM_Z = 11;
    public static final int MTHD_MAKE_CUBE_COLOR_FROM_Z_HUE = 12;
    public static final int MTHD_SHOW_CUBE_LABELS = 13;
    public static final int MTHD_MARK_ALL_CUBES = 14;
    public static final int MTHD_UNMARK_ALL_CUBES = 15;
    public static final int MTHD_REMOVE_CUBE_COLORS = 16;
    public static final int MTHD_INVERT_CUBE_MARKS = 17;
    public static final int MTHD_REMOVE_MARKED_CUBES_KEEP_V = 18;
    public static final int MTHD_MAKE_VERTEX_COLOR_FROM_CUBE = 19;
    public static final int MTHD_MAKE_CUBE_COLOR_FROM_VERTEX = 20;
    public static final int MTHD_MAKE_ORIENTATION = 21;
    public static final int MTHD_ADD_ALIGNED_FRAME_FIELD = 22;
    public static final int MTHD_CUBES_TO_OCTAGONS = 23;
    public static final int MTHD_TEST_EDGE_STARS = 24;
    public static final int MTHD_TRIANGULATE_12 = 25;
    public static final int MTHD_TEXTURE_PER_CUBE = 26;
    public static final int MTHD_ADD_ROTATION_FIELD = 27;
    public static final int MTHD_CUBES_TO_ELEMENTSET = 28;
    public static final int MTHD_MARK_BOUNDARY_VERTICES = 29;
    public static final int MTHD_COPY_VERTEX = 30;
    public static final int MTHD_REFINE_INTO_EIGHT_STAR = 31;
    public static final int MTHD_RELAX_CUBES_INDIVIDUAL = 32;
    public static final int MTHD_RELAX_CUBES_EQUAL = 33;
    public static final int MTHD_RELAX_CUBES_INDIVIDUAL_128 = 34;
    public static final int MTHD_RELAX_CUBES_EQUAL_128 = 35;
    public static final int MTHD_REMOVE_DUPLICATE_CUBES = 36;
    public static final int MTHD_COMPUTE_DIHEDRAL_ANGLES = 37;
    public static final int MTHD_COMPUTE_EDGE_VALENCES = 38;
    public static final int MTHD_SPLIT_TO_LAYERS = 39;
    public static final int MTHD_EXTRACT_SINGULARITIES = 40;
    public static final int MTHD_DIHEDRAL_ANGLE_VARIANCE = 41;
    public static final int MTHD_EDGE_LENGTH_VARIANCE = 42;
    public static final int MTHD_CUBE_VOLUME_VARIANCE = 43;
    public static final int MTHD_CUBES_TO_ELEMENTSET2 = 44;
    public static final int MTHD_SPATIAL_TWIST_CONTINUUM = 45;
    public static final int MTHD_SMALL_CUBES = 46;
    public static final int MTHD_ADD_BOUNDARY_LAYER = 47;
    public static final int MTHD_MIN_AND_MAX_ANGLE = 48;
    public static final int MTHD_MARK_SINGULARITIES = 49;
    public static final int MTHD_MARK_VAL2_SINGULARITIES = 50;
    public String[] m_cubeSetMethod = new String[]{"Check Neighbour", "Make Neighbour", "Remove unused Vertices", "Mark Cubes", "Unmark Cubes", "Remove marked Cubes", "--Show marked Cubes", "Split to Tetrahedra ...", "Refine into eight - parallel", "Show Global Cube Color", "Make Cube Color from XYZ", "Make Cube Color from Z", "Make Cube Color from Z Hue", "Show Cube Labels", "Mark all Cubes", "Unmark all Cubes", "Remove Cube Colors", "Invert Cube Marks", "Remove Marked Cubes (Keep Vertices)", "Make Vertex Colors from Cubes", "Make Cube Colors from Vertices", "Make Orientation", "Add aligned Frame Field", "Cubes to Octagons", "Test Edge Stars", "Split to Tetrahedra (12)", "Texture Per Cube", "Add Rotation Field", "Cubes to ElementSet", "Mark Boundary Vertices", "Copy Vertex", "Refine into eight - star", "Relax Cubes - Individual Sizes", "Relax Cubes - Equalize", "Relax Cubes - Individual Sizes 128", "Relax Cubes - Equalize 128", "Remove duplicate cubes", "Compute Dihedral Angles", "Compute Edge Valences", "Split to Layers", "Extract Singularities", "Variance of Dihedral Angles", "Variance of Edge Length", "Variance of Cube Volumes", "Cubes to inner and boundary faces", "Spatial Twist Continuum", "Show small cubes", "Add Boundary Layer", "Min and Max Dihedral Angle", "Mark Singularity vertices", "Mark 2-Singularity vertices"};
    protected PgCubeSet m_cubeSet;

    @Override
    public void init(PsObject anObject) {
        super.init(anObject);
        this.m_cubeSet = (PgCubeSet)anObject;
        String menuInfo = PsConfig.getMessage((int)21048);
        this.addMenuItem(menuInfo, this.m_cubeSetMethod[0]);
        this.addMenuItem(menuInfo, this.m_cubeSetMethod[37]);
        this.addMenuItem(menuInfo, this.m_cubeSetMethod[38]);
        this.addMenuItem(menuInfo, this.m_cubeSetMethod[41]);
        this.addMenuItem(menuInfo, this.m_cubeSetMethod[42]);
        this.addMenuItem(menuInfo, this.m_cubeSetMethod[43]);
        this.addMenuItem(menuInfo, this.m_cubeSetMethod[48]);
        String menuShow = PsConfig.getMessage((int)21049);
        this.getMenu(menuShow).addSeparator();
        this.addMenuItem(menuShow, this.m_cubeSetMethod[13], this.m_cubeSet.isShowingCubeLabels());
        this.addMenuItem(menuShow, this.m_cubeSetMethod[6], this.m_cubeSet.isShowingTaggedCubes());
        String menuMark = PsConfig.getMessage((int)21050);
        this.addMenuItem(menuMark, this.m_cubeSetMethod[29]);
        this.addMenuItem(menuMark, this.m_cubeSetMethod[49]);
        this.addMenuItem(menuMark, this.m_cubeSetMethod[50]);
        this.getMenu(menuMark).addSeparator();
        this.addMenuItem(menuMark, this.m_cubeSetMethod[3]);
        this.addMenuItem(menuMark, this.m_cubeSetMethod[14]);
        this.addMenuItem(menuMark, this.m_cubeSetMethod[4]);
        this.addMenuItem(menuMark, this.m_cubeSetMethod[15]);
        this.addMenuItem(menuMark, this.m_cubeSetMethod[17]);
        String menuDelete = PsConfig.getMessage((int)21051);
        this.addMenu(menuDelete);
        this.insertMenuItem(1, menuDelete, this.m_cubeSetMethod[2], null);
        this.getMenu(menuDelete).addSeparator();
        this.addMenuItem(menuDelete, this.m_cubeSetMethod[5]);
        this.addMenuItem(menuDelete, this.m_cubeSetMethod[36]);
        this.addMenuItem(menuDelete, this.m_cubeSetMethod[18]);
        this.addMenuItem(menuDelete, this.m_cubeSetMethod[16]);
        CheckboxMenuItem item = null;
        String menuColor = PsConfig.getMessage((int)21052);
        this.addMenuItem(menuColor, this.m_cubeSetMethod[19]);
        this.getMenu(menuColor).addSeparator();
        item = this.addMenuItem(menuColor, this.m_cubeSetMethod[9], !this.m_cubeSet.isShowingCubeColors());
        item.setEnabled(this.m_cubeSet.hasCubeColors() || this.m_cubeSet.hasVertexColors());
        this.getMenu(menuColor).addSeparator();
        this.addMenuItem(menuColor, this.m_cubeSetMethod[10]);
        this.addMenuItem(menuColor, this.m_cubeSetMethod[11]);
        this.addMenuItem(menuColor, this.m_cubeSetMethod[12]);
        this.addMenuItem(menuColor, this.m_cubeSetMethod[20]);
        String menuTexture = PsConfig.getMessage((int)21054);
        this.addMenu(menuTexture);
        this.getMenu(menuTexture).addSeparator();
        this.addMenuItem(menuTexture, this.m_cubeSetMethod[26]);
        String menuModeling = PsConfig.getMessage((int)21053);
        this.insertMenuItem(5, menuModeling, this.m_cubeSetMethod[1], null);
        this.insertMenuItem(5, menuModeling, this.m_cubeSetMethod[21], null);
        this.addMenuItem(menuModeling, this.m_cubeSetMethod[7]);
        this.addMenuItem(menuModeling, this.m_cubeSetMethod[47]);
        this.getMenu(menuModeling).addSeparator();
        String menuName = PsConfig.getMessage((int)21110);
        this.addMenu(menuName);
        this.addMenuItem(menuName, this.m_cubeSetMethod[46]);
        this.addMenuItem(menuName, this.m_cubeSetMethod[8]);
        this.addMenuItem(menuName, this.m_cubeSetMethod[31]);
        this.addMenuItem(menuName, this.m_cubeSetMethod[39]);
        this.addMenuItem(menuName, this.m_cubeSetMethod[40]);
        this.addMenuItem(menuName, this.m_cubeSetMethod[45]);
        String menuVector = PsConfig.getMessage((int)21228);
        this.addMenu(menuVector);
        this.addMenuItem(menuVector, this.m_cubeSetMethod[22]);
        this.addMenuItem(menuVector, this.m_cubeSetMethod[27]);
        String menuDevUR = "Dev-Uli";
        this.addMenu(menuDevUR);
        this.addMenuItem(menuDevUR, this.m_cubeSetMethod[23]);
        this.addMenuItem(menuDevUR, this.m_cubeSetMethod[28]);
        this.addMenuItem(menuDevUR, this.m_cubeSetMethod[44]);
        this.addMenuItem(menuDevUR, this.m_cubeSetMethod[32]);
        this.addMenuItem(menuDevUR, this.m_cubeSetMethod[34]);
        this.addMenuItem(menuDevUR, this.m_cubeSetMethod[33]);
        this.addMenuItem(menuDevUR, this.m_cubeSetMethod[35]);
    }

    public boolean update(Object event) {
        String menuShow;
        CheckboxMenuItem item;
        if (event == null || event != this.m_cubeSet) {
            return false;
        }
        String menuColor = PsConfig.getMessage((int)21052);
        if (this.hasMenu(menuColor) && (item = (CheckboxMenuItem)this.getMenuItem(menuColor, this.m_cubeSetMethod[9])) != null) {
            if (item.isEnabled() != (this.m_cubeSet.hasCubeColors() || this.m_cubeSet.hasVertexColors())) {
                item.setEnabled(!item.isEnabled());
            }
            if (item.getState() != !this.m_cubeSet.isShowingCubeColors()) {
                item.setState(!item.getState());
            }
        }
        if (this.hasMenu(menuShow = PsConfig.getMessage((int)21049))) {
            item = (CheckboxMenuItem)this.getMenuItem(menuShow, this.m_cubeSetMethod[13]);
            if (item != null && item.getState() != this.m_cubeSet.isShowingCubeLabels()) {
                item.setState(this.m_cubeSet.isShowingCubeLabels());
            }
            if ((item = (CheckboxMenuItem)this.getMenuItem(menuShow, this.m_cubeSetMethod[6])) != null && item.getState() != this.m_cubeSet.isShowingTaggedCubes()) {
                item.setState(this.m_cubeSet.isShowingTaggedCubes());
            }
        }
        return super.update(event);
    }

    @Override
    public boolean applyMethod(String aMethod) {
        if (super.applyMethod(aMethod)) {
            return true;
        }
        PsDebug.notify((String)("trying method = " + aMethod));
        int found = PgCubeSet_Menu.getIndexOfMethod((String[])this.m_cubeSetMethod, (String)aMethod);
        PvDisplayIf currDisp = null;
        PvViewerIf viewer = this.getViewer();
        if (viewer == null) {
            PsDebug.warning((String)"missing viewer");
        } else {
            currDisp = viewer.getDisplay();
        }
        if (viewer == null) {
            PsDebug.warning((String)"missing viewer");
        } else {
            currDisp = viewer.getDisplay();
        }
        int noc = this.m_cubeSet.getNumCubes();
        switch (found) {
            case 0: {
                this.m_cubeSet.checkNeighbour(true);
                return true;
            }
            case 3: {
                Enumeration dispSet = this.m_cubeSet.getDisplays();
                while (dispSet != null && dispSet.hasMoreElements()) {
                    PvDisplayIf disp = (PvDisplayIf)dispSet.nextElement();
                    disp.setMajorMode(10);
                }
                break;
            }
            case 14: {
                int i = 0;
                while (i < noc) {
                    this.m_cubeSet.getCube(i).setTag(1);
                    ++i;
                }
                break;
            }
            case 4: {
                Enumeration dispSet = this.m_cubeSet.getDisplays();
                while (dispSet != null && dispSet.hasMoreElements()) {
                    PvDisplayIf disp = (PvDisplayIf)dispSet.nextElement();
                    disp.setMajorMode(11);
                }
                break;
            }
            case 15: {
                int i = 0;
                while (i < noc) {
                    this.m_cubeSet.getCube(i).clearTag(1);
                    ++i;
                }
                break;
            }
            case 17: {
                int i = 0;
                while (i < noc) {
                    if (this.m_cubeSet.getCube(i).hasTag(1)) {
                        this.m_cubeSet.getCube(i).clearTag(1);
                    } else {
                        this.m_cubeSet.getCube(i).setTag(1);
                    }
                    ++i;
                }
            }
            case 13: {
                this.m_cubeSet.showCubeLabels(!this.m_cubeSet.isShowingCubeLabels());
                if (!this.m_cubeSet.isShowingCubeLabels()) break;
                this.m_cubeSet.showCubes(true);
                break;
            }
            case 6: {
                this.m_cubeSet.showTaggedCubes(!this.m_cubeSet.isShowingTaggedCubes());
                break;
            }
            case 2: {
                this.m_cubeSet.removeUnusedVertices();
                break;
            }
            case 5: 
            case 18: {
                PiVector[] element = this.m_cubeSet.getCubes();
                int i = this.m_cubeSet.getNumCubes() - 1;
                while (i >= 0) {
                    if (element[i].hasTag(1)) {
                        element[i].setTag(2);
                    }
                    --i;
                }
                this.m_cubeSet.removeMarkedCubes();
                if (found != 5) break;
                this.m_cubeSet.removeUnusedVertices();
                break;
            }
            case 36: {
                PwCubeSet.removeDuplicateCubes((PgCubeSet)this.m_cubeSet);
                this.m_cubeSet.update((Object)this.m_cubeSet);
                break;
            }
            case 16: {
                this.m_cubeSet.showCubeColors(false);
                this.m_cubeSet.setCubeColors(null);
                break;
            }
            case 20: {
                this.m_cubeSet.makeCubeFromVertexColors();
                this.m_cubeSet.showCubeColors(true);
                break;
            }
            case 19: {
                this.m_cubeSet.makeVertexFromCubeColors();
                this.m_cubeSet.showVertexColors(true);
                break;
            }
            case 9: {
                this.m_cubeSet.showCubeColors(!this.m_cubeSet.isShowingCubeColors());
                break;
            }
            case 10: {
                this.m_cubeSet.makeCubeColorsFromXYZ();
                this.m_cubeSet.showCubeColors(true);
                this.m_cubeSet.showCubes(true);
                CheckboxMenuItem item = (CheckboxMenuItem)this.getMenuItem(PsConfig.getMessage((int)21052), this.m_cubeSetMethod[9]);
                if (item == null) break;
                item.setState(false);
                break;
            }
            case 11: {
                this.m_cubeSet.makeCubeColorsFromZ();
                this.m_cubeSet.showCubeColors(true);
                this.m_cubeSet.showCubes(true);
                CheckboxMenuItem item = (CheckboxMenuItem)this.getMenuItem(PsConfig.getMessage((int)21052), this.m_cubeSetMethod[9]);
                if (item == null) break;
                item.setState(false);
                break;
            }
            case 12: {
                this.m_cubeSet.makeCubeColorsFromZHue();
                this.m_cubeSet.showCubeColors(true);
                this.m_cubeSet.showCubes(true);
                CheckboxMenuItem item = (CheckboxMenuItem)this.getMenuItem(PsConfig.getMessage((int)21052), this.m_cubeSetMethod[9]);
                if (item == null) break;
                item.setState(false);
                break;
            }
            case 1: {
                this.m_cubeSet.makeNeighbour();
                break;
            }
            case 22: {
                PwCubeSet.addAlignedFrameField((PgCubeSet)this.m_cubeSet, (boolean)true);
                this.m_cubeSet.showVectorFields(true);
                this.m_cubeSet.update((Object)this.m_cubeSet);
                break;
            }
            case 21: {
                PwCubeSet.makeOrientation((PgCubeSet)this.m_cubeSet);
                this.m_cubeSet.update((Object)this.m_cubeSet);
                break;
            }
            case 7: {
                PwCubeSet wcs = new PwCubeSet();
                if (currDisp == null) {
                    PsDebug.warning((String)"missing display.");
                } else {
                    wcs.setDisplay(currDisp);
                }
                wcs.setGeometry((PgGeometry)this.m_cubeSet);
                PjWorkshop_Dialog dialog = new PjWorkshop_Dialog(false);
                dialog.setParent((PsUpdateIf)wcs);
                dialog.update((Object)wcs);
                dialog.setVisible(true);
                break;
            }
            case 23: {
                PgElementSet octagons = PwCubeSet.convertToElementSet((PgCubeSet)this.m_cubeSet);
                if (currDisp == null) break;
                currDisp.addGeometry((PgGeometryIf)octagons);
                currDisp.update((Object)octagons);
                break;
            }
            case 28: {
                PgElementSet cubes = new PgElementSet(this.m_cubeSet.getDimOfVertices());
                cubes.copy((PsObject)this.m_cubeSet);
                cubes.setDimOfElements(4);
                int numCubes = this.m_cubeSet.getNumCubes();
                cubes.setNumElements(6 * numCubes);
                PiVector[] faces = PiVector.realloc(null, (int)(6 * numCubes), (int)4);
                PiVector[] neigh = PiVector.realloc(null, (int)(6 * numCubes), (int)4);
                int i = 0;
                while (i < numCubes) {
                    PiVector cube = this.m_cubeSet.getCube(i);
                    faces[6 * i + 0].set(cube.m_data[0], cube.m_data[1], cube.m_data[3], cube.m_data[2]);
                    neigh[6 * i + 0].set(6 * i + 3, 6 * i + 2, 6 * i + 1, 6 * i + 4);
                    faces[6 * i + 1].set(cube.m_data[0], cube.m_data[2], cube.m_data[6], cube.m_data[4]);
                    neigh[6 * i + 1].set(6 * i + 2, 6 * i + 5, 6 * i + 4, 6 * i + 0);
                    faces[6 * i + 2].set(cube.m_data[2], cube.m_data[3], cube.m_data[7], cube.m_data[6]);
                    neigh[6 * i + 2].set(6 * i + 3, 6 * i + 5, 6 * i + 1, 6 * i + 0);
                    faces[6 * i + 3].set(cube.m_data[3], cube.m_data[1], cube.m_data[5], cube.m_data[7]);
                    neigh[6 * i + 3].set(6 * i + 4, 6 * i + 5, 6 * i + 2, 6 * i + 0);
                    faces[6 * i + 4].set(cube.m_data[1], cube.m_data[0], cube.m_data[4], cube.m_data[5]);
                    neigh[6 * i + 4].set(6 * i + 1, 6 * i + 5, 6 * i + 3, 6 * i + 0);
                    faces[6 * i + 5].set(cube.m_data[4], cube.m_data[6], cube.m_data[7], cube.m_data[5]);
                    neigh[6 * i + 5].set(6 * i + 2, 6 * i + 3, 6 * i + 4, 6 * i + 1);
                    ++i;
                }
                cubes.setElements(faces);
                cubes.setNeighbours(neigh);
                if (currDisp == null) break;
                currDisp.addGeometry((PgGeometryIf)cubes);
                currDisp.update((Object)cubes);
                break;
            }
            case 44: {
                PgElementSet innerFaces = new PgElementSet(this.m_cubeSet.getDimOfVertices());
                PgElementSet outerFaces = new PgElementSet(this.m_cubeSet.getDimOfVertices());
                innerFaces.copy((PsObject)this.m_cubeSet);
                outerFaces.copy((PsObject)this.m_cubeSet);
                innerFaces.setDimOfElements(4);
                outerFaces.setDimOfElements(4);
                int cte2numCubes = this.m_cubeSet.getNumCubes();
                innerFaces.setNumElements(6 * cte2numCubes);
                outerFaces.setNumElements(6 * cte2numCubes);
                PiVector[] cte2InFaces = PiVector.realloc(null, (int)(6 * cte2numCubes), (int)4);
                PiVector[] cte2OutFaces = PiVector.realloc(null, (int)(6 * cte2numCubes), (int)4);
                int i = 0;
                while (i < cte2numCubes) {
                    PiVector cube = this.m_cubeSet.getCube(i);
                    PiVector cn = this.m_cubeSet.getNeighbour(i);
                    int j = 0;
                    while (j < 6) {
                        cte2InFaces[6 * i + j].set(cube.m_data[PgCubeSet.LOCAL_FACE_TO_VERTEX[j][0]], cube.m_data[PgCubeSet.LOCAL_FACE_TO_VERTEX[j][1]], cube.m_data[PgCubeSet.LOCAL_FACE_TO_VERTEX[j][2]], cube.m_data[PgCubeSet.LOCAL_FACE_TO_VERTEX[j][3]]);
                        cte2OutFaces[6 * i + j].set(cube.m_data[PgCubeSet.LOCAL_FACE_TO_VERTEX[j][0]], cube.m_data[PgCubeSet.LOCAL_FACE_TO_VERTEX[j][1]], cube.m_data[PgCubeSet.LOCAL_FACE_TO_VERTEX[j][2]], cube.m_data[PgCubeSet.LOCAL_FACE_TO_VERTEX[j][3]]);
                        if (cn.m_data[j] == -1) {
                            cte2InFaces[6 * i + j].setTag(2);
                        } else {
                            cte2OutFaces[6 * i + j].setTag(2);
                        }
                        ++j;
                    }
                    ++i;
                }
                innerFaces.setElements(cte2InFaces);
                outerFaces.setElements(cte2OutFaces);
                innerFaces.removeMarkedElements();
                outerFaces.removeMarkedElements();
                innerFaces.removeUnusedVertices();
                outerFaces.removeUnusedVertices();
                innerFaces.setName("Inner Faces of " + this.m_cubeSet.getName());
                outerFaces.setName("Boundary Faces of " + this.m_cubeSet.getName());
                if (currDisp == null) break;
                currDisp.addGeometry((PgGeometryIf)innerFaces);
                currDisp.addGeometry((PgGeometryIf)outerFaces);
                currDisp.update((Object)innerFaces);
                currDisp.update((Object)outerFaces);
                break;
            }
            case 29: {
                noc = this.m_cubeSet.getNumCubes();
                int i = 0;
                while (i < noc) {
                    PiVector cn = this.m_cubeSet.getNeighbour(i);
                    int j = 0;
                    while (j < 6) {
                        if (cn.m_data[j] == -1) {
                            int k = 0;
                            while (k < 4) {
                                this.m_cubeSet.setTagVertex(this.m_cubeSet.getCube((int)i).m_data[PgCubeSet.LOCAL_FACE_TO_VERTEX[j][k]], 1);
                                ++k;
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
                this.m_cubeSet.update((Object)this.m_cubeSet);
                break;
            }
            case 24: {
                PwCubeSet.testEdgeStars((PgCubeSet)this.m_cubeSet);
                break;
            }
            case 8: {
                PwCubeSet.m_refineToEightType = 0;
                PwCubeSet.refineIntoEight((PgCubeSet)this.m_cubeSet);
                this.m_cubeSet.update((Object)this.m_cubeSet);
                break;
            }
            case 31: {
                PwCubeSet.m_refineToEightType = 1;
                PwCubeSet.refineIntoEight((PgCubeSet)this.m_cubeSet);
                this.m_cubeSet.update((Object)this.m_cubeSet);
                break;
            }
            case 26: {
                PwCubeSet.addTexturePerCube((PgCubeSet)this.m_cubeSet);
                this.m_cubeSet.update((Object)this.m_cubeSet);
                break;
            }
            case 27: {
                PwCubeSet.computeRotationField((PgCubeSet)this.m_cubeSet, (boolean)true);
                this.m_cubeSet.update((Object)this.m_cubeSet);
                break;
            }
            case 30: {
                if (currDisp == null) break;
                PgGeometryIf[] cvGeom = currDisp.getGeometries();
                int cvNumGeom = cvGeom.length;
                boolean bFound = false;
                int i = 0;
                while (i < cvNumGeom) {
                    if (((PgGeometry)cvGeom[i]).getName().equals("Singularities")) {
                        bFound = true;
                        PgPolygonSet ps = (PgPolygonSet)cvGeom[i];
                        int nocv = this.m_cubeSet.getNumVertices();
                        int nopv = ps.getNumVertices();
                        int j = 0;
                        while (j < nocv) {
                            if (this.m_cubeSet.hasTagVertex(j, 1)) {
                                int k = 0;
                                while (k < nopv) {
                                    if (ps.hasTagVertex(k, 1)) {
                                        this.m_cubeSet.getVertex(j).copy(ps.getVertex(k));
                                        this.m_cubeSet.clearTagVertex(j, 1);
                                        ps.clearTagVertex(k, 1);
                                    }
                                    ++k;
                                }
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                if (bFound) break;
                PsDebug.message((String)"Geometry 'Cubes' was not found. Rename cube Set to steal frame field from.");
                break;
            }
            case 32: {
                PwCubeSet.relaxVertices((PgCubeSet)this.m_cubeSet, (boolean)false);
                this.m_cubeSet.update((Object)this.m_cubeSet);
                break;
            }
            case 33: {
                PwCubeSet.relaxVertices((PgCubeSet)this.m_cubeSet, (boolean)true);
                this.m_cubeSet.update((Object)this.m_cubeSet);
                break;
            }
            case 34: {
                int i = 0;
                while (i < 128) {
                    PwCubeSet.relaxVertices((PgCubeSet)this.m_cubeSet, (boolean)false);
                    ++i;
                }
                this.m_cubeSet.update((Object)this.m_cubeSet);
                break;
            }
            case 35: {
                int i = 0;
                while (i < 128) {
                    PwCubeSet.relaxVertices((PgCubeSet)this.m_cubeSet, (boolean)true);
                    ++i;
                }
                this.m_cubeSet.update((Object)this.m_cubeSet);
                break;
            }
            case 37: {
                PdVector threshold = new PdVector(new double[]{4.0, 8.0, 12.0, 16.0, 20.0, 24.0, 28.0, 32.0, 36.0, 40.0, 44.0, 48.0, 52.0, 56.0, 60.0, 64.0, 68.0, 72.0, 76.0, 80.0, 84.0, 88.0, 92.0, 96.0, 100.0, 104.0, 108.0, 112.0, 116.0, 120.0, 124.0, 128.0, 132.0, 136.0, 140.0, 144.0, 148.0, 152.0, 156.0, 160.0, 164.0, 168.0, 172.0, 176.0, 180.0});
                double numAllAngles = (double)this.m_cubeSet.getNumCubes() * 12.0;
                PiVector numAngles = PwCubeSet.countDihedralAnglesByBins((PgCubeSet)this.m_cubeSet, (PdVector)threshold);
                PsDebug.message((String)"Dihedral angles ... ");
                int percent = (int)((0.5 * numAllAngles + 100.0 * (double)numAngles.m_data[0]) / numAllAngles);
                PsDebug.message((String)("... " + percent + "% below " + threshold.m_data[0] + " (" + numAngles.m_data[0] + ")"));
                int i = 1;
                while (i < threshold.getSize()) {
                    percent = (int)((0.5 * numAllAngles + 100.0 * (double)numAngles.m_data[i]) / numAllAngles);
                    PsDebug.message((String)("... " + percent + "% between " + threshold.m_data[i - 1] + " and " + threshold.m_data[i] + " (" + numAngles.m_data[i] + ")"));
                    ++i;
                }
                percent = (int)((0.5 * numAllAngles + 100.0 * (double)numAngles.m_data[threshold.getSize()]) / numAllAngles);
                PsDebug.message((String)("... " + percent + "% above " + threshold.m_data[threshold.getSize() - 1] + " (" + numAngles.m_data[threshold.getSize()] + ")"));
                break;
            }
            case 38: {
                PiVector iv = new PiVector(4);
                PiVector bv = new PiVector(3);
                PwCubeSet.countEdgeValences((PgCubeSet)this.m_cubeSet, (PiVector)iv, (PiVector)bv);
                int numInnerEdges = 0;
                int numBndEdges = 0;
                int i = 0;
                while (i < iv.getSize()) {
                    numInnerEdges += iv.m_data[i];
                    ++i;
                }
                i = 0;
                while (i < bv.getSize()) {
                    numBndEdges += bv.m_data[i];
                    ++i;
                }
                PsDebug.message((String)("Inner Edges: " + numInnerEdges + " + Boundary Edges: " + numBndEdges + " = " + (numInnerEdges + numBndEdges) + " Edges total"));
                i = 0;
                while (i < iv.getSize()) {
                    if (iv.m_data[i] != 0) {
                        PsDebug.message((String)("Valence " + i + " inner edges: " + (iv.m_data[i] * 100 + numInnerEdges / 2) / numInnerEdges + "% (" + iv.m_data[i] + ")"));
                    }
                    ++i;
                }
                i = 0;
                while (i < bv.getSize()) {
                    if (bv.m_data[i] != 0) {
                        PsDebug.message((String)("Valence " + i + " boundaty edges: " + (bv.m_data[i] * 100 + numBndEdges / 2) / numBndEdges + "% (" + bv.m_data[i] + ")"));
                    }
                    ++i;
                }
                break;
            }
            case 39: {
                PgCubeSet[] layers = PwCubeSet.splitToLayers((PgCubeSet)this.m_cubeSet);
                if (layers == null || layers.length == 0 || currDisp == null) break;
                int i = 0;
                while (i < layers.length) {
                    currDisp.addGeometry((PgGeometryIf)layers[i]);
                    currDisp.update((Object)layers[i]);
                    ++i;
                }
                break;
            }
            case 40: {
                PgPolygonSet[] singularities = PwCubeSet.ExtractSingularities((PgCubeSet)this.m_cubeSet);
                if (singularities == null || singularities.length == 0 || currDisp == null) break;
                int i = 0;
                while (i < singularities.length) {
                    currDisp.addGeometry((PgGeometryIf)singularities[i]);
                    currDisp.update((Object)singularities[i]);
                    ++i;
                }
                break;
            }
            case 49: {
                PwCubeSet.selectSingularVertices((PgCubeSet)this.m_cubeSet);
                this.m_cubeSet.update((Object)this.m_cubeSet);
                break;
            }
            case 50: {
                PwCubeSet.selectSingularInner2Vertices((PgCubeSet)this.m_cubeSet);
                this.m_cubeSet.update((Object)this.m_cubeSet);
                break;
            }
            case 41: {
                double[] angle = PwCubeSet.computeAllDihedralAngles((PgCubeSet)this.m_cubeSet);
                int davNumAngles = angle.length;
                double avg = 0.0;
                int i = 0;
                while (i < davNumAngles) {
                    avg += angle[i] / (double)davNumAngles;
                    ++i;
                }
                PsDebug.message((String)("Average dihedral Angle: " + avg));
                double variance = 0.0;
                int i2 = 0;
                while (i2 < davNumAngles) {
                    variance += (angle[i2] - avg) * (angle[i2] - avg) / (double)davNumAngles;
                    ++i2;
                }
                PsDebug.message((String)("Variance of dihedral angles: " + variance));
                PsDebug.message((String)("Standard deviation of dihedral angles: " + Math.sqrt(variance)));
                break;
            }
            case 48: {
                double[] mmAngle = PwCubeSet.computeAllDihedralAngles((PgCubeSet)this.m_cubeSet);
                int mmNumAngles = mmAngle.length;
                double min = Double.MAX_VALUE;
                double max = 0.0;
                int i = 0;
                while (i < mmNumAngles) {
                    if (mmAngle[i] > max) {
                        max = mmAngle[i];
                    }
                    if (mmAngle[i] < min) {
                        min = mmAngle[i];
                    }
                    ++i;
                }
                PsDebug.message((String)("Angle range: " + min + " < angle < " + max));
                break;
            }
            case 42: {
                double[] el = PwCubeSet.computeAllEdgeLengths((PgCubeSet)this.m_cubeSet);
                int elvNumEdges = el.length;
                double elvAvg = 0.0;
                int i = 0;
                while (i < elvNumEdges) {
                    elvAvg += el[i] / (double)elvNumEdges;
                    ++i;
                }
                PsDebug.message((String)("Average Edge Length: " + elvAvg));
                double elvVariance = 0.0;
                int i3 = 0;
                while (i3 < elvNumEdges) {
                    elvVariance += (el[i3] - elvAvg) * (el[i3] - elvAvg) / (double)elvNumEdges;
                    ++i3;
                }
                PsDebug.message((String)("Variance of edge length: " + elvVariance));
                PsDebug.message((String)("Standard deviation of Edge Length: " + Math.sqrt(elvVariance)));
                break;
            }
            case 43: {
                double[] cv = PwCubeSet.computeAllCubeVolumes((PgCubeSet)this.m_cubeSet);
                int cvvNumCubes = cv.length;
                double cvvAvg = 0.0;
                int i = 0;
                while (i < cvvNumCubes) {
                    cvvAvg += cv[i] / (double)cvvNumCubes;
                    ++i;
                }
                PsDebug.message((String)("Average Cube Volume: " + cvvAvg));
                double cvvVariance = 0.0;
                int i4 = 0;
                while (i4 < cvvNumCubes) {
                    cvvVariance += (cv[i4] - cvvAvg) * (cv[i4] - cvvAvg) / (double)cvvNumCubes;
                    ++i4;
                }
                PsDebug.message((String)("Variance of Cube Volume: " + cvvVariance));
                PsDebug.message((String)("Standard deviation of Cube Volume: " + Math.sqrt(cvvVariance)));
                break;
            }
            case 45: {
                PwStc stc = new PwStc();
                stc.setGeometry((PgGeometry)this.m_cubeSet);
                if (currDisp != null) {
                    stc.setDisplay(currDisp);
                }
                PjWorkshop_Dialog dialog = new PjWorkshop_Dialog(false);
                dialog.setParent((PsUpdateIf)stc);
                dialog.update((Object)stc);
                dialog.setVisible(true);
                break;
            }
            case 46: {
                PgSmallCubes sc = new PgSmallCubes(this.m_cubeSet.getDimOfVertices());
                sc.setCubeSet(this.m_cubeSet);
                sc.setName("Small Cubes of " + this.m_cubeSet.getName());
                if (currDisp != null) {
                    currDisp.addGeometry((PgGeometryIf)sc);
                    currDisp.update((Object)sc);
                    currDisp.selectGeometry((PgGeometryIf)sc);
                }
                if (viewer == null) break;
                viewer.showPanel(17);
                break;
            }
            case 47: {
                PwCubeSet.addBoundaryLayer((PgCubeSet)this.m_cubeSet);
                this.m_cubeSet.update((Object)this.m_cubeSet);
                break;
            }
            case -1: {
                return false;
            }
            default: {
                PsDebug.error((String)("method string = " + aMethod + " does not match a constant"), (Object)((Object)this));
                return false;
            }
        }
        return true;
    }
}

