/*
 * Decompiled with CFR 0.152.
 */
package dev.denoising.robustDenoising;

import dev6.numeric.PnCSparseCholesky;
import java.util.Date;
import jv.geom.PgElementSet;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgVertexStar;
import jvx.numeric.PnSparseMatrix;
import jvx.project.PjWorkshop;
import jvx.util.PuQueue;

public class PwRobustDenoising
extends PjWorkshop {
    private static final long serialVersionUID = 1L;
    protected PgElementSet m_geom2;
    protected PuDouble m_isoFactor = new PuDouble(" Iso Factor ");
    protected PuDouble m_speedFactor;
    protected PuDouble m_normVar;
    protected PuInteger m_noItera;
    protected int m_nov;
    protected int m_noe;
    protected int m_noedge;
    protected PdVector[] m_vertices;
    protected PdVector[] m_origVertices;
    protected PiVector[] m_elements;
    protected PdVector[] m_elemNormals;
    protected PiVector[] m_elemNeigh;
    protected PiVector m_elemperVert;
    PiVector[] m_valence;
    PiVector[] m_elemValence;
    PdVector m_centroid;
    PdVector m_avgDistFacet;
    PdVector[] m_vertUpdated;
    PiVector m_vertFace;
    PdVector[] m_elemNormUp;
    PdVector m_elemArea;
    PdVector m_vertArea;
    int[] m_elemStatus;
    PuQueue m_queue;
    protected PdVector[] m_diffCoord;
    protected PdVector[] m_weigtedCenroid;
    protected PdVector[] m_diffCoordTan;
    double m_sw;
    double m_normalVar;
    PnSparseMatrix m_edgeAreaOpSparse;
    PnSparseMatrix m_edgeRegSparse;

    public PwRobustDenoising() {
        super("RoFi");
        this.m_isoFactor.addUpdateListener((PsUpdateIf)this);
        this.m_noItera = new PuInteger("Number of Iteration");
        this.m_noItera.addUpdateListener((PsUpdateIf)this);
        this.m_normVar = new PuDouble("Range Variation");
        this.m_normVar.addUpdateListener((PsUpdateIf)this);
        this.m_speedFactor = new PuDouble("Speed Factor");
        this.m_speedFactor.addUpdateListener((PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == PwRobustDenoising.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_isoFactor.setDefBounds(0.0, 10.0, 0.1, 0.1);
        this.m_isoFactor.setDefValue(0.17);
        this.m_isoFactor.init();
        this.m_noItera.setDefBounds(0, 1000, 1, 5);
        this.m_noItera.setDefValue(100);
        this.m_noItera.init();
        this.m_normVar.setDefBounds(0.0, 100.0, 0.1, 0.1);
        this.m_normVar.setDefValue(0.34);
        this.m_normVar.init();
        this.m_speedFactor.setDefBounds(1.0, 100.0, 0.1, 0.1);
        this.m_speedFactor.setDefValue(1.4);
        this.m_speedFactor.init();
    }

    public void setGeometry(PgElementSet geom) {
        super.setGeometry((PgGeometry)geom);
        this.m_geom2 = geom;
        this.m_nov = this.m_geom2.getNumVertices();
        this.m_noe = this.m_geom2.getNumElements();
        this.m_noedge = this.m_geom2.getNumEdges();
        this.m_vertices = this.m_geom2.getVertices();
        this.m_origVertices = PdVector.copyNew((PdVector[])this.m_vertices);
        this.m_elements = this.m_geom2.getElements();
        this.m_elemNeigh = this.m_geom2.getNeighbours();
        this.m_elemperVert = PgVertexStar.getElementPerVertex((PgElementSet)this.m_geom2);
        this.m_geom2.makeElementNormals();
        this.m_elemNormals = this.m_geom2.getElementNormals();
        this.m_geom2.makeElementNormals();
        System.out.println("Number of vertices in the geometry : " + this.m_nov);
    }

    public void starValence() {
        PgVertexStar S = new PgVertexStar();
        this.m_valence = PiVector.realloc(null, (int)this.m_nov, (int)3);
        this.m_elemValence = PiVector.realloc(null, (int)this.m_nov, (int)3);
        int k = 0;
        while (k < this.m_nov) {
            if (!this.m_geom2.getVertex(k).hasTag(14)) {
                S.makeVertexStar(this.m_geom2, k, this.m_elemperVert.m_data[k]);
                PiVector starVertInd = S.getLink();
                PiVector starElemInd = S.getElement();
                int val = starVertInd.getSize();
                int valElem = starElemInd.getSize();
                this.m_valence[k] = new PiVector(val);
                this.m_elemValence[k] = starElemInd;
                int i = 0;
                while (i < val) {
                    this.m_valence[k].m_data[i] = starVertInd.m_data[i];
                    ++i;
                }
                i = 0;
                while (i < valElem) {
                    this.m_elemValence[k].m_data[i] = starElemInd.m_data[i];
                    ++i;
                }
            }
            ++k;
        }
    }

    public void centroidElem(PiVector vertIndices) {
        this.m_centroid = new PdVector(3);
        int nov = vertIndices.getSize();
        int i = 0;
        while (i < nov) {
            this.m_centroid.add(this.m_geom.getVertex(vertIndices.m_data[i]));
            ++i;
        }
        this.m_centroid.multScalar(1.0 / (double)nov);
    }

    public void avgDistFace() {
        this.m_avgDistFacet = new PdVector(this.m_noe);
        int i = 0;
        while (i < this.m_noe) {
            this.centroidElem(this.m_elements[i]);
            PdVector centroid = this.m_centroid;
            int non = this.m_elemNeigh[i].getSize();
            if (non != 0) {
                double elemDist = 0.0;
                int j = 0;
                while (j < non) {
                    PdVector loc = new PdVector(3);
                    PdVector locDiff = new PdVector(3);
                    if (this.m_elemNeigh[i].m_data[j] >= 0) {
                        PiVector elemNei = this.m_elements[this.m_elemNeigh[i].m_data[j]];
                        this.centroidElem(elemNei);
                        loc = this.m_centroid;
                        locDiff.sub(centroid, loc);
                        elemDist += locDiff.length();
                    }
                    ++j;
                }
                this.m_avgDistFacet.m_data[i] = elemDist / (double)non;
            }
            ++i;
        }
    }

    public void vertUpdatefromElem() {
        PgVertexStar S = new PgVertexStar();
        this.m_vertUpdated = PdVector.realloc(null, (int)this.m_nov, (int)3);
        this.m_vertFace = new PiVector(this.m_nov);
        this.m_vertArea = new PdVector(this.m_nov);
        this.m_vertArea.setConstant(0.0);
        int i = 0;
        while (i < this.m_nov) {
            int numElem;
            S.makeVertexStar(this.m_geom2, i, this.m_elemperVert.m_data[i]);
            PiVector locInd = S.getVertexLocInd();
            PiVector neighEle = S.getElement();
            this.m_vertFace.m_data[i] = numElem = neighEle.getSize();
            double locArea = 0.0;
            int j = 0;
            while (j < numElem) {
                locArea += this.m_elemArea.m_data[neighEle.m_data[j]];
                double loc = 0.0;
                PiVector elemInd = this.m_elements[neighEle.m_data[j]];
                PdVector vert0 = this.m_vertices[elemInd.m_data[locInd.m_data[j]]];
                PdVector vert1 = this.m_vertices[elemInd.m_data[(locInd.m_data[j] + 1) % 3]];
                PdVector vert2 = this.m_vertices[elemInd.m_data[(locInd.m_data[j] + 2) % 3]];
                PdVector diff10 = new PdVector(3);
                PdVector diff21 = new PdVector(3);
                diff10.sub(vert1, vert0);
                diff21.sub(vert2, vert0);
                loc = diff10.dot(this.m_elemNormUp[neighEle.m_data[j]]) + diff21.dot(this.m_elemNormUp[neighEle.m_data[j]]);
                this.m_vertUpdated[i].blendBase(this.m_vertUpdated[i], loc, this.m_elemNormUp[neighEle.m_data[j]]);
                ++j;
            }
            this.m_vertArea.m_data[i] = locArea;
            ++i;
        }
        this.m_geom2.makeElementNormals();
        this.m_geom2.makeVertexNormals();
        this.m_geom2.update((Object)this.m_geom2);
    }

    public void bilateralNormal() {
        PgElementSet geom = (PgElementSet)this.m_geom;
        PgVertexStar S = new PgVertexStar();
        this.m_elemNormUp = PdVector.realloc(null, (int)this.m_noe, (int)3);
        this.m_elemArea = new PdVector(this.m_noe);
        int i = 0;
        while (i < this.m_noe) {
            double distVar = this.m_avgDistFacet.m_data[i];
            PdVector updateNorm = new PdVector(3);
            PdVector centNormal = this.m_elemNormals[i];
            this.centroidElem(this.m_elements[i]);
            this.m_elemArea.m_data[i] = geom.getAreaOfElement(i);
            PdVector centroid = PdVector.copyNew((PdVector)this.m_centroid);
            int j = 0;
            while (j < 3) {
                int vertIndex = this.m_elements[i].m_data[j];
                S.makeVertexStar(geom, vertIndex, this.m_elemperVert.m_data[vertIndex]);
                PiVector neighEle = S.getElement();
                int len = neighEle.getSize();
                int k = 0;
                while (k < len) {
                    if (neighEle.m_data[k] != i) {
                        double area;
                        PdVector loc = new PdVector(3);
                        this.centroidElem(this.m_elements[neighEle.m_data[k]]);
                        loc = this.m_centroid;
                        PdVector normDiff = new PdVector(3);
                        PdVector locDiff = new PdVector(3);
                        locDiff.sub(centroid, loc);
                        normDiff.sub(centNormal, this.m_elemNormals[neighEle.m_data[k]]);
                        double distWeight = Math.exp(-locDiff.sqrLength() / (2.0 * distVar * distVar));
                        double normWeight = Math.exp(-normDiff.sqrLength() / (2.0 * this.m_normalVar * this.m_normalVar));
                        this.m_elemArea.m_data[neighEle.m_data[k]] = area = geom.getAreaOfElement(neighEle.m_data[k]);
                        double totalweight = distWeight * normWeight * area;
                        PdVector scaleNormal = new PdVector(3);
                        scaleNormal.multScalar(this.m_elemNormals[neighEle.m_data[k]], totalweight);
                        updateNorm.add(scaleNormal);
                    }
                    ++k;
                }
                ++j;
            }
            updateNorm.normalize();
            this.m_elemNormUp[i] = updateNorm;
            ++i;
        }
    }

    public void tukeyGneighElem(PgElementSet geom, int startElem, double radius) {
        if (this.m_elemStatus == null || this.m_elemStatus.length != this.m_noe) {
            this.m_elemStatus = new int[this.m_noe];
            int i = 0;
            while (i < this.m_noe) {
                this.m_elemStatus[i] = -1;
                ++i;
            }
        }
        this.m_queue = new PuQueue(100);
        this.m_queue.enqueue(startElem);
        this.m_elemStatus[startElem] = startElem;
        boolean[] elemInBall = new boolean[3];
        this.centroidElem(this.m_elements[startElem]);
        this.m_elemArea.m_data[startElem] = geom.getAreaOfElement(startElem);
        double distVar = this.m_avgDistFacet.m_data[startElem];
        PdVector updateNorm = new PdVector(3);
        PdVector centroid = PdVector.copyNew((PdVector)this.m_centroid);
        PdVector centNormal = this.m_elemNormals[startElem];
        while (!this.m_queue.isEmpty()) {
            int elemInd = this.m_queue.extractFirst();
            PiVector neighElem = geom.getNeighbour(elemInd);
            int nSize = neighElem.getSize();
            int i = 0;
            while (i < nSize) {
                int nInd = neighElem.m_data[i];
                if (nInd >= 0) {
                    this.centroidElem(this.m_elements[nInd]);
                    double sqrDistCentroid = centroid.sqrDist(this.m_centroid);
                    boolean bl = elemInBall[i] = sqrDistCentroid < radius * radius;
                    if (elemInBall[i] && this.m_elemStatus[nInd] != startElem) {
                        double area;
                        PdVector neighNormal = this.m_elemNormals[nInd];
                        PdVector normDiff = PdVector.subNew((PdVector)centNormal, (PdVector)neighNormal);
                        double distWeight = Math.exp(-sqrDistCentroid / (2.0 * distVar * distVar));
                        double normWeight = 0.0;
                        if (normDiff.sqrLength() <= this.m_normalVar * this.m_normalVar) {
                            normWeight = 1.0 * (1.0 - normDiff.sqrLength() / this.m_normalVar * this.m_normalVar) * (1.0 - normDiff.sqrLength() / this.m_normalVar * this.m_normalVar);
                        }
                        this.m_elemArea.m_data[nInd] = area = geom.getAreaOfElement(nInd);
                        double totalweight = distWeight * normWeight * area;
                        PdVector scaleNormal = new PdVector(3);
                        scaleNormal.multScalar(this.m_elemNormals[nInd], totalweight);
                        updateNorm.add(scaleNormal);
                        this.m_queue.enqueue(nInd);
                        this.m_elemStatus[nInd] = startElem;
                    }
                }
                ++i;
            }
        }
        updateNorm.normalize();
        this.m_elemNormUp[startElem] = updateNorm;
    }

    public void tukeybilateralNormalGneigh() {
        PgElementSet geom = (PgElementSet)this.m_geom;
        this.m_elemNormUp = PdVector.realloc(null, (int)this.m_noe, (int)3);
        this.m_elemArea = new PdVector(this.m_noe);
        double radius = this.m_avgDistFacet.average();
        int i = 0;
        while (i < this.m_noe) {
            this.tukeyGneighElem(geom, i, 2.5 * radius);
            ++i;
        }
    }

    public void smoothCentroidOnUpdatedNormals() {
        this.m_weigtedCenroid = PdVector.realloc(null, (int)this.m_nov, (int)3);
        this.m_diffCoord = PdVector.realloc(null, (int)this.m_nov, (int)3);
        this.m_diffCoordTan = PdVector.realloc(null, (int)this.m_nov, (int)3);
        int i = 0;
        while (i < this.m_nov) {
            PdVector center = new PdVector(3);
            double weight = 0.0;
            int linkSize = this.m_valence[i].getSize();
            int j = 0;
            while (j < linkSize) {
                int w = this.m_valence[i].getEntry(j);
                double locDist = this.m_geom2.getVertex(w).dist(this.m_geom2.getVertex(i));
                weight += locDist;
                center.add(locDist, this.m_geom2.getVertex(w));
                ++j;
            }
            center.multScalar(1.0 / weight);
            this.m_weigtedCenroid[i] = center;
            this.m_diffCoord[i] = PdVector.subNew((PdVector)center, (PdVector)this.m_vertices[i]);
            PdVector vertNormal = new PdVector(3);
            int elemSize = this.m_elemValence[i].getSize();
            double sumWeight = 0.0;
            int j2 = 0;
            while (j2 < elemSize) {
                int indexElem = this.m_elemValence[i].m_data[j2];
                vertNormal.add(this.m_elemArea.m_data[indexElem], this.m_elemNormUp[indexElem]);
                sumWeight += this.m_elemArea.m_data[indexElem];
                ++j2;
            }
            vertNormal.multScalar(1.0 / sumWeight);
            this.m_diffCoordTan[i] = PdVector.copyNew((PdVector)this.m_diffCoord[i]);
            this.m_diffCoordTan[i].orthogonalPart(this.m_diffCoord[i], vertNormal);
            ++i;
        }
    }

    public void regBilNormal() {
        long stTime = new Date().getTime();
        this.starValence();
        this.m_sw = this.m_isoFactor.getValue();
        this.avgDistFace();
        System.out.println(" Average dist Faces " + this.m_avgDistFacet.average());
        int numIt = this.m_noItera.getValue();
        this.m_normalVar = this.m_normVar.getValue();
        int n = 0;
        while (n < numIt) {
            this.avgDistFace();
            this.tukeybilateralNormalGneigh();
            this.vertUpdatefromElem();
            this.smoothCentroidOnUpdatedNormals();
            int i = 0;
            while (i < this.m_nov) {
                this.m_vertices[i].blendBase(this.m_vertices[i], 1.0 / (3.0 * (double)this.m_vertFace.m_data[i]), this.m_vertUpdated[i]);
                this.m_vertices[i].blendBase(this.m_vertices[i], this.m_sw, this.m_diffCoord[i]);
                this.m_vertices[i].blendBase(this.m_vertices[i], this.m_sw, this.m_diffCoordTan[i]);
                ++i;
            }
            this.m_sw *= 0.7;
            PsDebug.showStatus((String)(" RoFi Denoising " + ((double)n + 1.0) / (double)numIt * 100.0 + "% ..."));
            ++n;
        }
        this.m_geom2.makeElementNormals();
        this.m_geom2.makeVertexNormals();
        this.m_geom2.update((Object)this.m_geom2);
        long enTime = new Date().getTime();
        System.out.println(" Time taken during smoothing in seconds " + (double)(enTime - stTime) / 1000.0);
    }

    public void BilNormalZheng() {
        long stTime = new Date().getTime();
        this.starValence();
        this.avgDistFace();
        System.out.println(" Average dist Faces " + this.m_avgDistFacet.average());
        int numIt = this.m_noItera.getValue();
        this.m_normalVar = this.m_normVar.getValue();
        int n = 0;
        while (n < numIt) {
            this.avgDistFace();
            this.bilateralNormal();
            this.vertUpdatefromElem();
            int i = 0;
            while (i < this.m_nov) {
                this.m_vertices[i].blendBase(this.m_vertices[i], 1.0 / (3.0 * (double)this.m_vertFace.m_data[i]), this.m_vertUpdated[i]);
                ++i;
            }
            PsDebug.showStatus((String)(" BN Denoising " + ((double)n + 1.0) / (double)numIt * 100.0 + "% ..."));
            ++n;
        }
        this.m_geom2.makeElementNormals();
        this.m_geom2.makeVertexNormals();
        this.m_geom2.update((Object)this.m_geom2);
        long enTime = new Date().getTime();
        System.out.println(" Time taken by bilateral normal filtering (in seconds): " + (double)(enTime - stTime) / 1000.0);
    }

    public void circumCentre() {
        PdVector[] circumCentre = PdVector.realloc(null, (int)this.m_noe, (int)3);
        PdVector qualityFactor = new PdVector(this.m_noe);
        int i = 0;
        while (i < this.m_noe) {
            int a = this.m_elements[i].m_data[0];
            int b = this.m_elements[i].m_data[1];
            int c = this.m_elements[i].m_data[2];
            PdVector ab = PdVector.subNew((PdVector)this.m_vertices[b], (PdVector)this.m_vertices[a]);
            PdVector ac = PdVector.subNew((PdVector)this.m_vertices[c], (PdVector)this.m_vertices[a]);
            PdVector abXac = PdVector.crossNew((PdVector)ab, (PdVector)ac);
            PdVector abXacXab = PdVector.crossNew((PdVector)abXac, (PdVector)ab);
            PdVector acXabXac = PdVector.crossNew((PdVector)ac, (PdVector)abXac);
            abXacXab.multScalar(ac.sqrLength());
            acXabXac.multScalar(ab.sqrLength());
            PdVector loc = PdVector.addNew((PdVector)abXacXab, (PdVector)acXabXac);
            if (!(abXac.sqrLength() < 1.0E-16)) {
                loc.multScalar(1.0 / (2.0 * abXac.sqrLength()));
                circumCentre[i] = loc;
                PdVector bc = PdVector.subNew((PdVector)this.m_vertices[c], (PdVector)this.m_vertices[b]);
                PdVector length = new PdVector(3);
                length.m_data[0] = ab.length();
                length.m_data[1] = ac.length();
                length.m_data[2] = bc.length();
                length.sort();
                if (!(length.m_data[0] < 1.0E-16)) {
                    qualityFactor.m_data[i] = circumCentre[i].length() / length.m_data[0];
                }
            }
            ++i;
        }
        System.out.println(" Mesh Quality Factor Q: " + qualityFactor.average());
    }

    public void reset() {
        this.m_geom2.setVertices(this.m_origVertices);
        this.m_geom2.makeElementNormals();
        this.m_geom2.makeVertexNormals();
        this.m_geom2.update((Object)this.m_geom2);
    }

    public void L0_areaSparse() {
        long stTime = new Date().getTime();
        double beta = 0.001;
        double speedFac = this.m_speedFactor.getValue();
        PgElementSet geom = (PgElementSet)this.m_geom;
        PdVector dihAngArr = this.avgDihedral();
        double dihAngle = dihAngArr.average();
        this.avgDistFace();
        double edgeLength = this.m_avgDistFacet.average();
        System.out.println(" Average dist Faces " + edgeLength);
        double lambda = 0.02 * Math.pow(edgeLength, 2.0) * dihAngle;
        double alpha_0 = 0.1 * dihAngle;
        int noiter = 0;
        while (beta < 1000.0) {
            this.areacoeffAMCFSparse();
            this.m_edgeAreaOpSparse.validate();
            double sqrtLambda = Math.sqrt(lambda / beta);
            PdVector[] deltaSparse = PdVector.realloc(null, (int)this.m_noedge, (int)3);
            int i = 0;
            while (i < this.m_noedge) {
                int numEntries = this.m_edgeAreaOpSparse.getNumEntries(i);
                PiVector index = this.m_edgeAreaOpSparse.getColIndices(i);
                PdVector entries = this.m_edgeAreaOpSparse.getEntries(i);
                int j = 0;
                while (j < numEntries) {
                    deltaSparse[i].m_data[0] = deltaSparse[i].m_data[0] + entries.m_data[j] * this.m_vertices[index.m_data[j]].m_data[0];
                    deltaSparse[i].m_data[1] = deltaSparse[i].m_data[1] + entries.m_data[j] * this.m_vertices[index.m_data[j]].m_data[1];
                    deltaSparse[i].m_data[2] = deltaSparse[i].m_data[2] + entries.m_data[j] * this.m_vertices[index.m_data[j]].m_data[2];
                    ++j;
                }
                if (!(deltaSparse[i].length() > sqrtLambda)) {
                    deltaSparse[i].setConstant(0.0);
                }
                ++i;
            }
            PnSparseMatrix edgeCoTranSparse = new PnSparseMatrix(this.m_nov, this.m_noedge);
            edgeCoTranSparse.transpose(this.m_edgeAreaOpSparse);
            edgeCoTranSparse.validate();
            PdVector[] DtDelSparse = PdVector.realloc(null, (int)this.m_nov, (int)3);
            int i2 = 0;
            while (i2 < this.m_nov) {
                int numEntries = edgeCoTranSparse.getNumEntries(i2);
                PiVector index = edgeCoTranSparse.getColIndices(i2);
                PdVector entries = edgeCoTranSparse.getEntries(i2);
                int j = 0;
                while (j < numEntries) {
                    DtDelSparse[i2].m_data[0] = DtDelSparse[i2].m_data[0] + entries.m_data[j] * deltaSparse[index.m_data[j]].m_data[0];
                    DtDelSparse[i2].m_data[1] = DtDelSparse[i2].m_data[1] + entries.m_data[j] * deltaSparse[index.m_data[j]].m_data[1];
                    DtDelSparse[i2].m_data[2] = DtDelSparse[i2].m_data[2] + entries.m_data[j] * deltaSparse[index.m_data[j]].m_data[2];
                    ++j;
                }
                DtDelSparse[i2].multScalar(beta);
                ++i2;
            }
            PdVector[] b = PdVector.realloc(null, (int)this.m_nov, (int)3);
            int i3 = 0;
            while (i3 < this.m_nov) {
                b[i3].add(this.m_vertices[i3], DtDelSparse[i3]);
                ++i3;
            }
            PnSparseMatrix dTdSparse = new PnSparseMatrix(this.m_nov, this.m_nov);
            PnSparseMatrix.multMatrices((PnSparseMatrix)edgeCoTranSparse, (PnSparseMatrix)this.m_edgeAreaOpSparse, (PnSparseMatrix)dTdSparse);
            dTdSparse.multScalar(beta);
            PnSparseMatrix regMatTranSparse = new PnSparseMatrix(this.m_nov, this.m_noedge);
            regMatTranSparse.transpose(this.m_edgeRegSparse);
            PnSparseMatrix rTrSparse = new PnSparseMatrix(this.m_nov, this.m_nov);
            PnSparseMatrix.multMatrices((PnSparseMatrix)regMatTranSparse, (PnSparseMatrix)this.m_edgeRegSparse, (PnSparseMatrix)rTrSparse);
            rTrSparse.multScalar(alpha_0);
            PnSparseMatrix idenSparse = new PnSparseMatrix(this.m_nov, this.m_nov);
            int i4 = 0;
            while (i4 < this.m_nov) {
                idenSparse.setEntry(i4, i4, 1.0);
                ++i4;
            }
            idenSparse.validate();
            dTdSparse.validate();
            rTrSparse.validate();
            PnSparseMatrix ASparse = new PnSparseMatrix(this.m_nov, this.m_nov);
            ASparse.add(idenSparse, dTdSparse);
            ASparse.validate();
            ASparse.add(rTrSparse);
            PdVector bx = new PdVector(this.m_nov);
            PdVector by = new PdVector(this.m_nov);
            PdVector bz = new PdVector(this.m_nov);
            int i5 = 0;
            while (i5 < this.m_nov) {
                bx.m_data[i5] = b[i5].m_data[0];
                by.m_data[i5] = b[i5].m_data[1];
                bz.m_data[i5] = b[i5].m_data[2];
                ++i5;
            }
            PdVector prx = new PdVector(this.m_nov);
            PdVector pry = new PdVector(this.m_nov);
            PdVector prz = new PdVector(this.m_nov);
            PnCSparseCholesky.solve((PnSparseMatrix)ASparse, (PdVector)prx, (PdVector)bx);
            PnCSparseCholesky.solve((PnSparseMatrix)ASparse, (PdVector)pry, (PdVector)by);
            PnCSparseCholesky.solve((PnSparseMatrix)ASparse, (PdVector)prz, (PdVector)bz);
            int i6 = 0;
            while (i6 < this.m_nov) {
                geom.setVertex(i6, prx.m_data[i6], pry.m_data[i6], prz.m_data[i6]);
                ++i6;
            }
            geom.makeElementNormals();
            geom.makeVertexNormals();
            alpha_0 /= 2.0;
            ++noiter;
            PsDebug.showStatus((String)(" L0 Denoising " + (beta *= speedFac) / 999.0 * 100.0 + "% ..."));
        }
        geom.update((Object)geom);
        ((PgElementSet)this.m_geom).makeElementNormals();
        long enTime = new Date().getTime();
        System.out.println(" Total time in L0 Smoothing : " + (enTime - stTime) / 1000L);
        System.out.println(" Total iteration during calculation : " + noiter);
    }

    public void areacoeffAMCFSparse() {
        this.m_edgeAreaOpSparse = new PnSparseMatrix(this.m_noedge, this.m_nov);
        this.m_edgeRegSparse = new PnSparseMatrix(this.m_noedge, this.m_nov);
        int dim = this.m_geom.getDimOfVertices();
        new PdVector(dim);
        int counter = 0;
        int i = 0;
        while (i < this.m_noe) {
            PiVector elem = this.m_elements[i];
            double elemArea1 = ((PgElementSet)this.m_geom).getAreaOfElement(i);
            int j = 0;
            while (j < 3) {
                if (this.m_elemNeigh[i].m_data[j] >= i) {
                    PiVector elemNei = this.m_elements[this.m_elemNeigh[i].m_data[j]];
                    double elemArea2 = ((PgElementSet)this.m_geom).getAreaOfElement(this.m_elemNeigh[i].m_data[j]);
                    int oppVert = ((PgElementSet)this.m_geom).getOppVertexLocInd(i, j);
                    int a = elem.m_data[j];
                    int b = elem.m_data[(j + 1) % 3];
                    int c = elem.m_data[(j + 2) % 3];
                    int an = elemNei.m_data[oppVert];
                    PdVector edgep1p3 = PdVector.subNew((PdVector)((PgElementSet)this.m_geom).getVertex(b), (PdVector)((PgElementSet)this.m_geom).getVertex(c));
                    PdVector edgep4p3 = PdVector.subNew((PdVector)((PgElementSet)this.m_geom).getVertex(a), (PdVector)((PgElementSet)this.m_geom).getVertex(c));
                    PdVector edgep3p2 = PdVector.subNew((PdVector)((PgElementSet)this.m_geom).getVertex(c), (PdVector)((PgElementSet)this.m_geom).getVertex(an));
                    PdVector edgep1p4 = PdVector.subNew((PdVector)((PgElementSet)this.m_geom).getVertex(b), (PdVector)((PgElementSet)this.m_geom).getVertex(a));
                    PdVector edgep2p1 = PdVector.subNew((PdVector)((PgElementSet)this.m_geom).getVertex(an), (PdVector)((PgElementSet)this.m_geom).getVertex(b));
                    PdVector edgep3p1 = PdVector.subNew((PdVector)((PgElementSet)this.m_geom).getVertex(c), (PdVector)((PgElementSet)this.m_geom).getVertex(b));
                    double cSqrLength = edgep1p3.sqrLength();
                    double locp1 = (edgep4p3.dot(edgep3p1) * elemArea2 + edgep1p3.dot(edgep3p2) * elemArea1) / ((elemArea1 + elemArea2) * cSqrLength);
                    double locp2 = elemArea1 / (elemArea1 + elemArea2);
                    double locp3 = (edgep3p1.dot(edgep1p4) * elemArea2 + edgep1p3.dot(edgep2p1) * elemArea1) / ((elemArea1 + elemArea2) * cSqrLength);
                    double locp4 = elemArea2 / (elemArea1 + elemArea2);
                    this.m_edgeAreaOpSparse.setEntry(counter, b, locp1);
                    this.m_edgeAreaOpSparse.setEntry(counter, an, locp2);
                    this.m_edgeAreaOpSparse.setEntry(counter, c, locp3);
                    this.m_edgeAreaOpSparse.setEntry(counter, a, locp4);
                    this.m_edgeRegSparse.addEntry(counter, b, -1.0);
                    this.m_edgeRegSparse.addEntry(counter, c, -1.0);
                    this.m_edgeRegSparse.addEntry(counter, an, 1.0);
                    this.m_edgeRegSparse.addEntry(counter, a, 1.0);
                    ++counter;
                }
                ++j;
            }
            ++i;
        }
    }

    public PdVector avgDihedral() {
        int noEdge = ((PgElementSet)this.m_geom).getNumEdges();
        PdVector dihArr = new PdVector(noEdge);
        int counter = 0;
        int i = 0;
        while (i < this.m_noe) {
            int size = this.m_elements[i].getSize();
            PiVector neigh = this.m_elemNeigh[i];
            PdVector elemNorm = this.m_elemNormals[i];
            int j = 0;
            while (j < size) {
                int elemInd;
                if (neigh.m_data[j] < i && (elemInd = neigh.m_data[j]) != -1) {
                    double dihAngle;
                    PdVector elemNorm2 = this.m_elemNormals[elemInd];
                    dihArr.m_data[counter] = dihAngle = Math.toRadians(180.0 - PdVector.angle((PdVector)elemNorm, (PdVector)elemNorm2));
                    ++counter;
                }
                ++j;
            }
            ++i;
        }
        System.out.println(" Number of edge : " + noEdge + " counter value  " + counter + " average dihedral " + dihArr.average());
        return dihArr;
    }

    public boolean update(Object event) {
        if (event == this.m_isoFactor) {
            System.out.println("Isotropic Factor: " + this.m_isoFactor.getValue());
            return true;
        }
        if (event == this.m_noItera) {
            System.out.println("Number of Iteration: " + this.m_noItera.getValue());
            return true;
        }
        if (event == this.m_normVar) {
            System.out.println("Normal variation: " + this.m_normVar.getValue());
            return true;
        }
        return super.update(event);
    }
}

