/*
 * Decompiled with CFR 0.152.
 */
package dev.denoising.SmoothOp;

import dev.denoising.Box.PjBox;
import dev.denoising.Box.boxComparator;
import dev6.numeric.PnCSparseCholesky;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.loader.PjImportModel;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvViewerIf;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;
import jvx.geom.PgVertexStar;
import jvx.geom.PwCleanMesh;
import jvx.geom.PwCurvature;
import jvx.numeric.PnSparseMatrix;
import jvx.util.PuAVLTree;
import jvx.util.PuCompare_If;

public class PjSmoothOp
extends PjProject
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static String m_defFileName = "models/numeric/Octahedron_noisy_512.jvx";
    protected String m_fileName;
    protected PjImportModel m_import;
    protected PgElementSet m_refGrid = new PgElementSet(3);
    protected PuDouble m_threshold;
    protected PuDouble m_gaussVar;
    protected PuInteger m_iteration;
    protected PdVector m_errBil;
    protected PdVector m_dihArr;
    protected PdVector m_highFreqComp;
    protected PdVector m_vertexStarArea;
    protected PgElementSet m_geomCopy;
    protected PgElementSet m_geom2;
    protected PuDouble m_colorThreshold;
    protected PuDouble m_featureDetect;
    protected PuDouble m_stepWidth;
    protected PuDouble m_normVar;
    protected PuDouble m_stepWidth2;
    protected PuDouble m_color;
    protected PuInteger m_noItera;
    protected PdVector m_areaWeight;
    protected PdVector[] m_vertCoeff;
    protected PdVector[] m_vertReg;
    protected PdVector[] m_vertMean;
    protected PdVector[] m_areavertCoeff;
    protected PdVector[] m_vertCoeffField;
    protected PnSparseMatrix m_edgeCotan;
    protected PdVector m_magLap;
    protected PdVector[] m_laplacian;
    protected PdMatrix m_edgeReg;
    protected PdMatrix m_locMat;
    protected PdMatrix m_edgeAreaOp;
    protected int m_nov;
    protected int m_noe;
    protected int m_noedge;
    protected PdVector[] m_vertices;
    protected PiVector[] m_elements;
    protected PdVector[] m_elemNormals;
    protected PiVector[] m_elemNeigh;
    protected PiVector m_elemperVert;
    PiVector[] m_valence;
    PdVector[] m_vertStaravgDist;
    protected PdVector[] anisoAreaGrad;
    protected PdVector[] volGrad;
    protected boolean[] onEdge;
    protected PdVector m_mean;
    protected PdVector[] aVolGrad;
    protected PdVector m_curvMag;
    double charCurv;
    PdVector m_centroid;
    PdVector m_avgDistFacet;
    PdVector[] m_vertUpdated;
    PiVector m_vertFace;
    double m_normalVar;
    PdVector m_dirCurvature;
    PdVector[] m_elemNormUp;
    PdVector m_angleError;
    PdVector m_angleError2;
    PdVector m_elemArea;
    PdVector m_vertArea;
    PdVector[] m_vertUpdatedTukey;
    PiVector m_vertFaceTukey;
    double m_normalVarTukey;
    PdVector m_dirCurvatureTukey;
    PdVector m_maxareaCurv;
    PnSparseMatrix m_edgeAreaOpSparse;
    PnSparseMatrix m_edgeRegSparse;
    PnSparseMatrix m_vertWeightSparse;
    PdVector[] errAnisoGrad;
    PdVector[] m_curvAboveThre;
    protected boolean[] m_featureVert;
    PdVector m_vorArea;
    PiVector m_connEdge;
    PdVector[] m_edgeCurv;
    PdMatrix m_vertWeight;
    PdVector m_dihArrVert;
    PdVector[] m_diff;
    protected PdVector[] m_regDir2;
    protected PdVector[] m_regVector;
    protected PdVector[] m_regDir;
    PdVector m_diffLength;
    PdVector[] m_gausslaplacian;
    PnSparseMatrix m_lapOp;
    double m_sw;
    PiVector[] m_edgeConn;
    PdVector m_gaussDiff;
    PiVector[] m_valence2;

    public PjSmoothOp() {
        this(String.valueOf(PsConfig.getCodeBase()) + m_defFileName);
    }

    public PjSmoothOp(String fileName) {
        super(fileName);
        if (fileName == null) {
            fileName = "Unknown file name";
        }
        this.m_fileName = fileName;
        this.m_import = new PjImportModel();
        this.m_import.setTypeOfInfoPanel(1);
        this.m_import.setFileName(fileName);
        this.m_import.addActionListener((ActionListener)this);
        if (this.getClass() == PjSmoothOp.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_gaussVar = new PuDouble("Gaussian Variance");
        this.m_gaussVar.addUpdateListener((PsUpdateIf)this);
        this.m_gaussVar.setDefBounds(0.0, 10.0, 0.1, 0.1);
        this.m_gaussVar.setDefValue(0.5);
        this.m_gaussVar.init();
        this.m_featureDetect = new PuDouble(" Feature Threshold ");
        this.m_featureDetect.addUpdateListener((PsUpdateIf)this);
        this.m_featureDetect.setDefBounds(0.0, 10.0, 0.1, 0.1);
        this.m_featureDetect.setDefValue(0.01);
        this.m_featureDetect.init();
        this.m_stepWidth = new PuDouble("Alpha");
        this.m_stepWidth.addUpdateListener((PsUpdateIf)this);
        this.m_stepWidth.setDefBounds(0.0, 10.0, 0.1, 0.1);
        this.m_stepWidth.setDefValue(0.5);
        this.m_stepWidth.init();
        this.m_stepWidth2 = new PuDouble(" Beta ");
        this.m_stepWidth2.addUpdateListener((PsUpdateIf)this);
        this.m_stepWidth2.setDefBounds(0.0, 10.0, 0.1, 0.1);
        this.m_stepWidth2.setDefValue(0.05);
        this.m_stepWidth2.init();
        this.m_color = new PuDouble("Speed Factor");
        this.m_color.addUpdateListener((PsUpdateIf)this);
        this.m_color.setDefBounds(1.0, 100.0, 0.1, 0.1);
        this.m_color.setDefValue(1.4);
        this.m_color.init();
        this.m_noItera = new PuInteger("Number of Iteration");
        this.m_noItera.addUpdateListener((PsUpdateIf)this);
        this.m_noItera.setDefBounds(0, 1000, 1, 5);
        this.m_noItera.setDefValue(50);
        this.m_noItera.init();
        this.m_normVar = new PuDouble("Range Variation");
        this.m_normVar.addUpdateListener((PsUpdateIf)this);
        this.m_normVar.setDefBounds(0.0, 100.0, 0.1, 0.1);
        this.m_normVar.setDefValue(1.5);
        this.m_normVar.init();
    }

    public void start() {
        String model;
        super.start();
        PvViewerIf viewer = this.getViewer();
        if (viewer != null && (model = viewer.getParameter("model")) != null) {
            this.m_fileName = String.valueOf(PsConfig.getCodeBase()) + model;
        }
        this.m_import.load(this.m_fileName);
        PgGeometryIf geom = this.m_import.getGeometry();
        this.setGeometry(geom);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.m_import) {
            PgElementSet m_anElemSet;
            PsDebug.notify((String)"(m_import): called");
            if (this.m_import.getConfirm() == 2) {
                if (this.m_import.getGeometry() instanceof PgElementSet) {
                    this.addGeometry(this.m_import.getGeometry());
                    this.fitDisplays();
                }
            } else if (this.m_import.getConfirm() == 1) {
                this.fitDisplays();
            } else if (this.m_import.getConfirm() == 0 && !this.addGeometry((PgGeometryIf)(m_anElemSet = (PgElementSet)this.m_import.getGeometry()))) {
                return;
            }
            this.fitDisplays();
        }
        this.m_geom2 = (PgElementSet)this.m_geom;
        PgElementSet.triangulate((PgElementSet)this.m_geom2);
        this.m_nov = this.m_geom2.getNumVertices();
        this.m_noe = this.m_geom2.getNumElements();
        this.m_noedge = this.m_geom2.getNumEdges();
        this.m_vertices = this.m_geom2.getVertices();
        this.m_elements = this.m_geom2.getElements();
        this.m_elemNeigh = this.m_geom2.getNeighbours();
        this.m_elemperVert = PgVertexStar.getElementPerVertex((PgElementSet)this.m_geom2);
        this.m_geom2.makeElementNormals();
        this.m_elemNormals = this.m_geom2.getElementNormals();
        this.m_geom2.makeElementNormals();
        System.out.println("Number of vertices in the geometry : " + this.m_nov);
    }

    public void bilFilt() {
        this.bilateral();
    }

    public void grid() {
        this.gridSize();
    }

    public void colFreq() {
        this.highFreqCol();
    }

    public void colArea() {
        this.areaWeight();
        double colorThreshold = this.m_colorThreshold.getValue();
        System.out.println(" Max value in areaWeight: " + this.m_areaWeight.max());
        this.m_areaWeight.multScalar(1.0 / colorThreshold);
        int j = 0;
        while (j < this.m_nov) {
            int red = 0;
            int green = 0;
            double locVar = Math.abs(this.m_areaWeight.m_data[j]);
            if (locVar <= 0.5) {
                red = (int)(255.0 * (2.0 * locVar));
                green = 255;
            } else if (locVar > 1.0) {
                red = 255;
                green = 0;
            } else {
                red = 255;
                green = (int)(255.0 * (2.0 - 2.0 * locVar));
            }
            Color col = new Color(red, green, 0);
            this.m_geom2.setVertexColor(j, col);
            ++j;
        }
        this.m_geom2.showVertexColors(true);
        this.m_geom2.showElementColorFromVertices(true);
        this.m_geom2.showElementColors(true);
        this.m_geom2.update((Object)this.m_geom2);
        System.out.println(" Color field on the basis area weight i.e. outlier detection ");
    }

    public void starValence() {
        PgVertexStar S = new PgVertexStar();
        this.m_valence = PiVector.realloc(null, (int)this.m_nov, (int)3);
        this.m_vertStaravgDist = PdVector.realloc(null, (int)this.m_nov, (int)3);
        int k = 0;
        while (k < this.m_nov) {
            if (!this.m_geom2.getVertex(k).hasTag(14)) {
                S.makeVertexStar(this.m_geom2, k, this.m_elemperVert.m_data[k]);
                PiVector starVertInd = S.getLink();
                int val = starVertInd.getSize();
                this.m_valence[k] = new PiVector(val);
                this.m_vertStaravgDist[k] = new PdVector(val);
                int i = 0;
                while (i < val) {
                    this.m_valence[k].m_data[i] = starVertInd.m_data[i];
                    ++i;
                }
            }
            ++k;
        }
    }

    public void bilStarSmooth() {
        long stTime = new Date().getTime();
        this.starValence();
        int numIt = this.m_noItera.getValue();
        double sigma = this.m_normVar.getValue();
        PdVector[] vert = ((PgElementSet)this.m_geom).getVertices();
        int n = 0;
        while (n < numIt) {
            PdVector update = new PdVector(this.m_nov);
            PdVector[] NormVector = ((PgElementSet)this.m_geom).getVertexNormals();
            int i = 0;
            while (i < this.m_nov) {
                int starSize = this.m_valence[i].getSize();
                PdVector refVert = vert[i];
                PdVector refVertNorm = NormVector[i];
                double sum = 0.0;
                double normalizer = 0.0;
                int p = 0;
                while (p < starSize) {
                    int locVert = this.m_valence[i].m_data[p];
                    if (i != locVert) {
                        PdVector vertLoc = vert[locVert];
                        PdVector d = PdVector.subNew((PdVector)refVert, (PdVector)vertLoc);
                        double h = PdVector.dot((PdVector)refVertNorm, (PdVector)d);
                        double a = d.sqrLength();
                        double WeightDist = Math.exp(-a / (2.0 * sigma * sigma));
                        double range = sigma * 1.5;
                        double WeightRange = Math.exp(-(h * h) / (2.0 * range * range));
                        double Weight = WeightDist * WeightRange;
                        double Weighted_Dist = Weight * h;
                        sum += Weighted_Dist;
                        normalizer += Weight;
                    }
                    ++p;
                }
                update.m_data[i] = sum / normalizer;
                ++i;
            }
            i = 0;
            while (i < this.m_nov) {
                PdVector loc = new PdVector(3);
                loc.multScalar(NormVector[i], update.m_data[i]);
                vert[i].blendBase(vert[i], -1.0, loc);
                ++i;
            }
            ((PgElementSet)this.m_geom).update((Object)this.m_geom);
            ((PgElementSet)this.m_geom).makeVertexNormals();
            ((PgElementSet)this.m_geom).makeElementNormals();
            ++n;
        }
        long enTime = new Date().getTime();
        System.out.println(" Time taken during Bilateral in seconds " + (enTime - stTime));
    }

    public void regBil() {
        this.highFreqInfo();
        this.bilateral();
        double boundVar = 0.0;
        int refGeomVert = ((PgPointSet)this.m_geom).getNumVertices();
        int i = 0;
        while (i < refGeomVert) {
            boundVar += Math.abs(this.m_highFreqComp.m_data[i]);
            ++i;
        }
        boundVar /= (double)refGeomVert;
        double noiseVar = 0.0;
        int i2 = 0;
        while (i2 < refGeomVert) {
            noiseVar += Math.abs(this.m_errBil.m_data[i2]);
            ++i2;
        }
        System.out.println("noise var " + (noiseVar /= (double)refGeomVert) + " HCF  " + boundVar);
        double alpha = Math.abs(noiseVar / boundVar);
        double beta = 1.0;
        System.out.println(" Regularization parameter alpha = " + alpha + "   Relaxation parameter beta =  " + beta);
        PdVector grdError = new PdVector(refGeomVert);
        int i3 = 0;
        while (i3 < refGeomVert) {
            double loc = this.m_errBil.m_data[i3] - alpha * this.m_highFreqComp.m_data[i3];
            this.m_geom.getVertex(i3).add(beta * loc, this.m_geomCopy.getVertexNormal(i3));
            grdError.m_data[i3] = Math.abs(loc);
            ++i3;
        }
        this.m_geom.update((Object)this.m_geom);
        System.out.println(" Total error due to smoothing = " + grdError.average());
    }

    private void bilateral() {
        int iter = 0;
        while (iter < 1) {
            this.m_geomCopy = (PgElementSet)this.m_geom.clone();
            PdVector[] orig_Vert = this.m_geomCopy.getVertices();
            PdVector[] box = ((PgPointSet)this.m_geom).getBounds();
            double xMin = box[0].m_data[0];
            double xMax = box[1].m_data[0];
            double yMin = box[0].m_data[1];
            double yMax = box[1].m_data[1];
            double zMin = box[0].m_data[2];
            double zMax = box[1].m_data[2];
            double gridStep = this.gridSize();
            int xLine = (int)((xMax - xMin) / gridStep + 1.0);
            int yLine = (int)((yMax - yMin) / gridStep + 1.0);
            int zLine = (int)((zMax - zMin) / gridStep + 1.0);
            int noVert = ((PgPointSet)this.m_geom).getNumVertices();
            PuAVLTree treeVert = new PuAVLTree((PuCompare_If)new boxComparator());
            int i = 0;
            while (i < noVert) {
                double x = this.m_geom.getVertex((int)i).m_data[0];
                int xIndex = (int)((x - xMin) / gridStep);
                double y = this.m_geom.getVertex((int)i).m_data[1];
                int yIndex = (int)((y - yMin) / gridStep);
                double z = this.m_geom.getVertex((int)i).m_data[2];
                int zIndex = (int)((z - zMin) / gridStep);
                PjBox boxVert = new PjBox(xIndex, yIndex, zIndex);
                Object box_Lr2 = treeVert.findNode((Object)boxVert);
                if (box_Lr2 == null) {
                    treeVert.insert((Object)boxVert);
                } else {
                    boxVert = (PjBox)box_Lr2;
                }
                boxVert.addVertex(0, i);
                ++i;
            }
            int HR_Vert = ((PgPointSet)this.m_geom).getNumVertices();
            int j = 0;
            while (j < HR_Vert) {
                PdVector vert_Ref = this.m_geom.getVertex(j);
                PdVector Vert_Norm = ((PgPointSet)this.m_geom).getVertexNormal(j);
                double x1 = this.m_geom.getVertex((int)j).m_data[0];
                int xIndex_Hr = (int)((x1 - xMin) / gridStep);
                double y1 = this.m_geom.getVertex((int)j).m_data[1];
                int yIndex_Hr = (int)((y1 - yMin) / gridStep);
                double z1 = this.m_geom.getVertex((int)j).m_data[2];
                int zIndex_Hr = (int)((z1 - zMin) / gridStep);
                double Sum_Weight = 0.0;
                double Sum_Weighted_Dist = 0.0;
                int neighbor = 2;
                PdVector weightedDiff = new PdVector(3);
                int i2 = xIndex_Hr - neighbor;
                while (i2 <= xIndex_Hr + neighbor) {
                    if (i2 >= 0 || i2 < xLine) {
                        int m = yIndex_Hr - neighbor;
                        while (m <= yIndex_Hr + neighbor) {
                            if (m >= 0 || m < yLine) {
                                int n = zIndex_Hr - neighbor;
                                while (n <= zIndex_Hr + neighbor) {
                                    PjBox box1;
                                    Object box2;
                                    if ((n >= 0 || n < zLine) && (box2 = treeVert.findNode((Object)(box1 = new PjBox(i2, m, n)))) != null) {
                                        box1 = (PjBox)box2;
                                        PiVector vertPoint = box1.m_vertIndex;
                                        int noPoint = vertPoint.getSize();
                                        int p = 0;
                                        while (p < noPoint) {
                                            int lVert = vertPoint.m_data[p];
                                            if (j != lVert) {
                                                PdVector vertLoc = this.m_geom.getVertex(lVert);
                                                PdVector d = PdVector.subNew((PdVector)vertLoc, (PdVector)vert_Ref);
                                                double h = PdVector.dot((PdVector)Vert_Norm, (PdVector)d);
                                                PdVector normal = PdVector.copyNew((PdVector)Vert_Norm);
                                                normal.multScalar(h);
                                                PdVector loc_vec = PdVector.subNew((PdVector)vertLoc, (PdVector)normal);
                                                PdVector Dist = PdVector.subNew((PdVector)vert_Ref, (PdVector)loc_vec);
                                                double a = d.sqrLength();
                                                double sigma = gridStep * 0.5;
                                                double WeightDist = Math.exp(-a / (2.0 * sigma));
                                                double range = sigma * 3.0;
                                                double WeightRange = Math.exp(-(Math.pow(h, 2.0) / (2.0 * range)));
                                                double Weight = WeightDist * WeightRange;
                                                double Weighted_Dist = Weight * h;
                                                weightedDiff.add(Weight, Dist);
                                                Sum_Weight += Weight;
                                                Sum_Weighted_Dist += Weighted_Dist;
                                            }
                                            ++p;
                                        }
                                    }
                                    ++n;
                                }
                            }
                            ++m;
                        }
                    }
                    ++i2;
                }
                if (Sum_Weight > 1.0E-10) {
                    this.m_geom.getVertex(j).add(Sum_Weighted_Dist / (Sum_Weight *= 1.0), Vert_Norm);
                } else {
                    this.m_geom.setTagVertex(j, 1);
                }
                ++j;
            }
            ((PgElementSet)this.m_geom).makeElementNormals();
            ((PgElementSet)this.m_geom).makeVertexNormals();
            this.m_errBil = new PdVector(noVert);
            int k = 0;
            while (k < noVert) {
                PdVector vertFilt = this.m_geom.getVertex(k);
                PdVector vertOrig = orig_Vert[k];
                PdVector d = PdVector.subNew((PdVector)vertOrig, (PdVector)vertFilt);
                PdVector vertNorm = this.m_geomCopy.getVertexNormal(k);
                double h = PdVector.dot((PdVector)vertNorm, (PdVector)d);
                if (Math.abs(h) > 2.0) {
                    h = 0.0;
                }
                this.m_errBil.m_data[k] = h;
                ++k;
            }
            ++iter;
        }
        this.m_geom.update((Object)this.m_geom);
    }

    private double gridSize() {
        int no_element2 = ((PgElementSet)this.m_geom).getNumElements();
        double Dist_Grid = 0.0;
        double Sum_Grid = 0.0;
        int Index_Grid = 0;
        int i = 0;
        while (i < no_element2) {
            int size = this.m_geom.getElement(i).getSize();
            PiVector elem = this.m_geom.getElement(i);
            PiVector neigh = ((PgElementSet)this.m_geom).getNeighbour(i);
            int j = 0;
            while (j < size) {
                if (neigh.m_data[j] < i) {
                    int vert1 = elem.m_data[(j + 1) % size];
                    int vert2 = elem.m_data[(j + 2) % size];
                    double loc_var = Math.pow(this.m_geom.getVertex((int)vert1).m_data[0] - this.m_geom.getVertex((int)vert2).m_data[0], 2.0) + Math.pow(this.m_geom.getVertex((int)vert1).m_data[1] - this.m_geom.getVertex((int)vert2).m_data[1], 2.0);
                    Dist_Grid = Math.sqrt(loc_var);
                    ++Index_Grid;
                    Sum_Grid += Dist_Grid;
                }
                ++j;
            }
            ++i;
        }
        double Grid_Size = Sum_Grid / (double)Index_Grid;
        return Grid_Size;
    }

    public void freqDomain() {
        PdVector[] box = ((PgPointSet)this.m_geom).getBounds();
        double xMin = box[0].m_data[0];
        double xMax = box[1].m_data[0];
        double yMin = box[0].m_data[1];
        double yMax = box[1].m_data[1];
        double gridStep = this.gridSize();
        int xLine = (int)((xMax - xMin) / gridStep + 1.0);
        int yLine = (int)((yMax - yMin) / gridStep + 1.0);
        int noVert = ((PgPointSet)this.m_geom).getNumVertices();
        this.m_refGrid.computePlane(++xLine, ++yLine, xMin, yMin, xMin + (double)(xLine - 1) * gridStep, yMin + (double)(yLine - 1) * gridStep);
        this.m_refGrid.setName("Regular Grid Geometry");
        this.addGeometry((PgGeometryIf)this.m_refGrid);
        this.fitDisplays();
        int i = 0;
        while (i < noVert) {
            double x2 = this.m_geom.getVertex((int)i).m_data[0];
            int xIndex = (int)((x2 - xMin + gridStep / 2.0) / gridStep);
            double y2 = this.m_geom.getVertex((int)i).m_data[1];
            int yIndex = (int)((y2 - yMin + gridStep / 2.0) / gridStep);
            int index = yIndex + xIndex * yLine;
            this.m_refGrid.getVertex((int)index).m_data[2] = this.m_geom.getVertex((int)i).m_data[2];
            ++i;
        }
    }

    protected void anisoAreaGrad() {
        int i;
        int nov = ((PgPointSet)this.m_geom).getNumVertices();
        if (this.anisoAreaGrad == null || this.anisoAreaGrad.length < nov) {
            this.anisoAreaGrad = PdVector.realloc(null, (int)nov, (int)3);
        } else {
            i = 0;
            while (i < nov) {
                this.anisoAreaGrad[i].setConstant(0.0);
                ++i;
            }
        }
        int noe = ((PgElementSet)this.m_geom).getNumElements();
        PiVector[] element = ((PgElementSet)this.m_geom).getElements();
        PiVector[] neigh = ((PgElementSet)this.m_geom).getNeighbours();
        PdVector[] vert = ((PgPointSet)this.m_geom).getVertices();
        int dim = this.m_geom.getDimOfVertices();
        PdVector he = new PdVector(dim);
        double[] cot = new double[3];
        double[] cotNei = new double[3];
        i = 0;
        while (i < noe) {
            PiVector elem = element[i];
            PuVectorGeom.ctg((double[])cot, (PdVector)vert[elem.m_data[0]], (PdVector)vert[elem.m_data[1]], (PdVector)vert[elem.m_data[2]]);
            int j = 0;
            while (j < 3) {
                if (neigh[i].m_data[j] >= i) {
                    PiVector elemNei = element[neigh[i].m_data[j]];
                    PuVectorGeom.ctg((double[])cotNei, (PdVector)vert[elemNei.m_data[0]], (PdVector)vert[elemNei.m_data[1]], (PdVector)vert[elemNei.m_data[2]]);
                    int oppVert = ((PgElementSet)this.m_geom).getOppVertexLocInd(i, j);
                    int a = elem.m_data[j];
                    int b = elem.m_data[(j + 1) % 3];
                    int c = elem.m_data[(j + 2) % 3];
                    int an = elemNei.m_data[oppVert];
                    int bn = elemNei.m_data[(oppVert + 1) % 3];
                    int cn = elemNei.m_data[(oppVert + 2) % 3];
                    int k = 0;
                    while (k < dim) {
                        he.m_data[k] = 0.5 * (cot[(j + 1) % 3] * (vert[c].m_data[k] - vert[a].m_data[k]) + cot[(j + 2) % 3] * (vert[b].m_data[k] - vert[a].m_data[k]) + cotNei[(oppVert + 1) % 3] * (vert[cn].m_data[k] - vert[an].m_data[k]) + cotNei[(oppVert + 2) % 3] * (vert[bn].m_data[k] - vert[an].m_data[k]));
                        ++k;
                    }
                    double ke = he.length();
                    double len = PdVector.subNew((PdVector)vert[b], (PdVector)vert[c]).length();
                    if (len > 1.0E-10) {
                        ke /= len;
                    }
                    if (!(ke > this.charCurv)) {
                        this.anisoAreaGrad[b].sub(he);
                        this.anisoAreaGrad[c].sub(he);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    protected void volGradient() {
        if (this.m_geom == null) {
            PsDebug.warning((String)"gemetry is null.");
            return;
        }
        int nov = ((PgPointSet)this.m_geom).getNumVertices();
        if (this.volGrad == null || this.volGrad.length < nov) {
            this.volGrad = PdVector.realloc(null, (int)nov, (int)3);
        }
        PdVector[] vert = ((PgPointSet)this.m_geom).getVertices();
        int noe = ((PgElementSet)this.m_geom).getNumElements();
        PiVector[] elem = ((PgElementSet)this.m_geom).getElements();
        ((PgElementSet)this.m_geom).makeElementNormals();
        PdVector[] elementNormal = ((PgElementSet)this.m_geom).getElementNormals();
        PdVector vhelp = new PdVector(3);
        int i = 0;
        while (i < nov) {
            this.volGrad[i].setConstant(0.0);
            ++i;
        }
        i = 0;
        while (i < noe) {
            double area = PdVector.area((PdVector)vert[elem[i].m_data[0]], (PdVector)vert[elem[i].m_data[1]], (PdVector)vert[elem[i].m_data[2]]);
            vhelp.copyArray(elementNormal[i]);
            vhelp.multScalar(area);
            int j = 0;
            while (j < 3) {
                this.volGrad[elem[i].m_data[j]].add(vhelp);
                ++j;
            }
            ++i;
        }
    }

    protected void detectEdges() {
        int nov = ((PgPointSet)this.m_geom).getNumVertices();
        if (this.onEdge == null || this.onEdge.length < nov) {
            this.onEdge = new boolean[nov];
        }
        int i = 0;
        while (i < nov) {
            this.onEdge[i] = false;
            ++i;
        }
        int noe = ((PgElementSet)this.m_geom).getNumElements();
        PiVector[] elem = ((PgElementSet)this.m_geom).getElements();
        PdVector[] vert = ((PgPointSet)this.m_geom).getVertices();
        PiVector[] neigh = ((PgElementSet)this.m_geom).getNeighbours();
        PdVector j1e = new PdVector(3);
        PdVector j2e = new PdVector(3);
        PdVector e = new PdVector(3);
        PdVector vhelp = new PdVector(3);
        ((PgElementSet)this.m_geom).makeElementNormals();
        PdVector[] elementNormal = ((PgElementSet)this.m_geom).getElementNormals();
        i = 0;
        while (i < noe) {
            int j = 0;
            while (j < 3) {
                if (neigh[i].m_data[j] >= i) {
                    e.sub(vert[elem[i].m_data[(j + 2) % 3]], vert[elem[i].m_data[(j + 1) % 3]]);
                    j1e.cross(elementNormal[i], e);
                    e.multScalar(-1.0);
                    j2e.cross(elementNormal[neigh[i].m_data[j]], e);
                    vhelp.add(j1e, j2e);
                    double ke = vhelp.length();
                    if (ke > this.charCurv) {
                        this.onEdge[elem[i].m_data[(j + 1) % 3]] = true;
                        this.onEdge[elem[i].m_data[(j + 2) % 3]] = true;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private void aVolGrad() {
        int j;
        if (this.m_geom == null) {
            PsDebug.warning((String)"gemetry is null.");
            return;
        }
        int nov = ((PgPointSet)this.m_geom).getNumVertices();
        if (this.aVolGrad == null || this.aVolGrad.length < nov) {
            this.aVolGrad = PdVector.realloc(null, (int)nov, (int)3);
        }
        PdVector[] vert = ((PgPointSet)this.m_geom).getVertices();
        int noe = ((PgElementSet)this.m_geom).getNumElements();
        PiVector[] elem = ((PgElementSet)this.m_geom).getElements();
        PdVector vhelp = new PdVector(3);
        this.anisoAreaGrad();
        this.volGradient();
        this.detectEdges();
        int i = 0;
        while (i < nov) {
            this.aVolGrad[i].setConstant(0.0);
            ++i;
        }
        double[] angle = new double[3];
        i = 0;
        while (i < noe) {
            PdVector.angle((double[])angle, (PdVector)vert[elem[i].m_data[0]], (PdVector)vert[elem[i].m_data[1]], (PdVector)vert[elem[i].m_data[2]]);
            j = 0;
            while (j < 3) {
                if (this.onEdge[elem[i].m_data[j]]) {
                    vhelp.copyArray(this.anisoAreaGrad[elem[i].m_data[(j + 1) % 3]]);
                    vhelp.multScalar(angle[j]);
                    this.aVolGrad[elem[i].m_data[j]].add(vhelp);
                    vhelp.copyArray(this.anisoAreaGrad[elem[i].m_data[(j + 2) % 3]]);
                    vhelp.multScalar(angle[j]);
                    this.aVolGrad[elem[i].m_data[j]].add(vhelp);
                }
                ++j;
            }
            ++i;
        }
        double weight = 1.0;
        i = 0;
        while (i < nov) {
            if (this.onEdge[i]) {
                this.aVolGrad[i].normalize();
                vhelp.copyArray(this.anisoAreaGrad[i]);
                vhelp.setLength(weight);
                this.aVolGrad[i].add(vhelp);
                this.aVolGrad[i].normalize();
                if (PdVector.dot((PdVector)this.volGrad[i], (PdVector)this.aVolGrad[i]) < 0.0) {
                    this.aVolGrad[i].multScalar(-1.0);
                }
            } else {
                this.aVolGrad[i].copyArray(this.volGrad[i]);
            }
            ++i;
        }
        ((PgElementSet)this.m_geom).makeElementNormals();
        PdVector[] elementNormal = ((PgElementSet)this.m_geom).getElementNormals();
        double[] len = new double[nov];
        i = 0;
        while (i < noe) {
            double area = PdVector.area((PdVector)vert[elem[i].m_data[0]], (PdVector)vert[elem[i].m_data[1]], (PdVector)vert[elem[i].m_data[2]]);
            vhelp.copyArray(elementNormal[i]);
            vhelp.multScalar(area);
            j = 0;
            while (j < 3) {
                if (this.onEdge[elem[i].m_data[j]]) {
                    int n = elem[i].m_data[j];
                    len[n] = len[n] + area * Math.abs(PdVector.dot((PdVector)this.aVolGrad[elem[i].m_data[j]], (PdVector)elementNormal[i]));
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < nov) {
            if (this.onEdge[i]) {
                this.aVolGrad[i].multScalar(len[i]);
            }
            ++i;
        }
    }

    private void computeHE() {
        if (this.m_geom == null) {
            PsDebug.warning((String)"gemetry is null.");
            return;
        }
        int nov = ((PgPointSet)this.m_geom).getNumVertices();
        if (this.m_mean == null || this.m_mean.getSize() < nov) {
            this.m_mean = new PdVector(nov);
        }
        int i = 0;
        while (i < nov) {
            double d;
            this.m_mean.m_data[i] = PdVector.dot((PdVector)this.volGrad[i], (PdVector)this.anisoAreaGrad[i]) < 0.0 ? this.anisoAreaGrad[i].length() : -this.anisoAreaGrad[i].length();
            double dhelp = this.aVolGrad[i].length();
            if (d > 1.0E-10) {
                int n = i;
                this.m_mean.m_data[n] = this.m_mean.m_data[n] / dhelp;
            }
            ++i;
        }
    }

    protected void smoothHE() {
        int v2;
        int v1;
        int j;
        int nov = ((PgPointSet)this.m_geom).getNumVertices();
        int noe = ((PgElementSet)this.m_geom).getNumElements();
        PiVector[] elem = ((PgElementSet)this.m_geom).getElements();
        PdVector[] vert = ((PgPointSet)this.m_geom).getVertices();
        PiVector[] neigh = ((PgElementSet)this.m_geom).getNeighbours();
        if (this.m_mean == null || this.m_mean.getSize() < nov) {
            this.computeHE();
        }
        PdVector dir = new PdVector(nov);
        double stepwidth = 0.4;
        int numLoops = 5;
        int[][] vertNeigh = new int[nov][];
        int voe = 0;
        int vs = 0;
        int[] valenz = new int[nov];
        int i = 0;
        while (i < nov) {
            valenz[i] = 0;
            ++i;
        }
        i = 0;
        while (i < noe) {
            j = 0;
            while (j < 3) {
                if (neigh[i].m_data[j] >= i) {
                    v1 = elem[i].m_data[(j + 1) % 3];
                    v2 = elem[i].m_data[(j + 2) % 3];
                    if (!vert[v1].hasTag(14)) {
                        if (this.onEdge[v1]) {
                            if (!vert[v2].hasTag(14) && this.onEdge[v2]) {
                                int n = v1;
                                valenz[n] = valenz[n] + 1;
                                int n2 = v2;
                                valenz[n2] = valenz[n2] + 1;
                            }
                        } else if (!vert[v2].hasTag(14) && !this.onEdge[v2]) {
                            int n = v1;
                            valenz[n] = valenz[n] + 1;
                            int n3 = v2;
                            valenz[n3] = valenz[n3] + 1;
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < nov) {
            if (!vert[i].hasTag(14)) {
                if (this.onEdge[i]) {
                    ++voe;
                } else {
                    ++vs;
                }
            }
            ++i;
        }
        int[] vertOnEdges = new int[voe];
        int[] vertSmooth = new int[vs];
        voe = 0;
        vs = 0;
        i = 0;
        while (i < nov) {
            if (!vert[i].hasTag(14)) {
                if (this.onEdge[i]) {
                    vertOnEdges[voe] = i;
                    ++voe;
                } else {
                    vertSmooth[vs] = i;
                    ++vs;
                }
            }
            ++i;
        }
        i = 0;
        while (i < nov) {
            vertNeigh[i] = new int[valenz[i]];
            valenz[i] = 0;
            ++i;
        }
        i = 0;
        while (i < noe) {
            j = 0;
            while (j < 3) {
                if (neigh[i].m_data[j] >= i) {
                    v1 = elem[i].m_data[(j + 1) % 3];
                    v2 = elem[i].m_data[(j + 2) % 3];
                    if (!vert[v1].hasTag(14)) {
                        if (this.onEdge[v1]) {
                            if (!vert[v2].hasTag(14) && this.onEdge[v2]) {
                                vertNeigh[v1][valenz[v1]] = v2;
                                int n = v1;
                                valenz[n] = valenz[n] + 1;
                                vertNeigh[v2][valenz[v2]] = v1;
                                int n4 = v2;
                                valenz[n4] = valenz[n4] + 1;
                            }
                        } else if (!vert[v2].hasTag(14) && !this.onEdge[v2]) {
                            vertNeigh[v1][valenz[v1]] = v2;
                            int n = v1;
                            valenz[n] = valenz[n] + 1;
                            vertNeigh[v2][valenz[v2]] = v1;
                            int n5 = v2;
                            valenz[n5] = valenz[n5] + 1;
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        int k = 0;
        while (k < numLoops) {
            dir.setConstant(0.0);
            i = 0;
            while (i < vs) {
                block45: {
                    block44: {
                        block43: {
                            v1 = vertSmooth[i];
                            j = 0;
                            while (j < valenz[v1]) {
                                int n = v1;
                                dir.m_data[n] = dir.m_data[n] + this.m_mean.m_data[vertNeigh[v1][j]];
                                ++j;
                            }
                            if (valenz[v1] <= 1) break block43;
                            int n = v1;
                            dir.m_data[n] = dir.m_data[n] / (double)valenz[v1];
                            break block44;
                        }
                        if (valenz[v1] < 1) break block45;
                    }
                    int n = v1;
                    dir.m_data[n] = dir.m_data[n] - this.m_mean.m_data[v1];
                }
                ++i;
            }
            i = 0;
            while (i < vs) {
                int n = vertSmooth[i];
                this.m_mean.m_data[n] = this.m_mean.m_data[n] + stepwidth * dir.m_data[vertSmooth[i]];
                ++i;
            }
            ++k;
        }
        k = 0;
        while (k < numLoops) {
            dir.setConstant(0.0);
            i = 0;
            while (i < voe) {
                block48: {
                    block47: {
                        block46: {
                            v1 = vertOnEdges[i];
                            j = 0;
                            while (j < valenz[v1]) {
                                int n = v1;
                                dir.m_data[n] = dir.m_data[n] + this.m_mean.m_data[vertNeigh[v1][j]];
                                ++j;
                            }
                            if (valenz[v1] <= 1) break block46;
                            int n = v1;
                            dir.m_data[n] = dir.m_data[n] / (double)valenz[v1];
                            break block47;
                        }
                        if (valenz[v1] < 1) break block48;
                    }
                    int n = v1;
                    dir.m_data[n] = dir.m_data[n] - this.m_mean.m_data[v1];
                }
                ++i;
            }
            i = 0;
            while (i < voe) {
                int n = vertOnEdges[i];
                this.m_mean.m_data[n] = this.m_mean.m_data[n] + stepwidth * dir.m_data[vertOnEdges[i]];
                ++i;
            }
            ++k;
        }
    }

    public PdVector[] computeGradient() {
        this.aVolGrad();
        this.computeHE();
        this.smoothHE();
        int nov = ((PgPointSet)this.m_geom).getNumVertices();
        int dim = this.m_geom.getDimOfVertices();
        int i = 0;
        while (i < nov) {
            int j = 0;
            while (j < dim) {
                int n = j;
                this.anisoAreaGrad[i].m_data[n] = this.anisoAreaGrad[i].m_data[n] + this.m_mean.m_data[i] * this.aVolGrad[i].m_data[j];
                ++j;
            }
            ++i;
        }
        return this.anisoAreaGrad;
    }

    public void moveVertices() {
        int iter = this.m_noItera.getValue();
        int j = 0;
        while (j < iter) {
            PdVector[] gradient = this.computeGradient();
            double sw = this.m_stepWidth.getValue();
            PdVector[] vert = ((PgPointSet)this.m_geom).getVertices();
            int nov = ((PgPointSet)this.m_geom).getNumVertices();
            int i = 0;
            while (i < nov) {
                vert[i].blendBase(vert[i], sw, gradient[i]);
                ++i;
            }
            this.m_geom.update((Object)this.m_geom);
            ((PgElementSet)this.m_geom).makeElementNormals();
            ((PgElementSet)this.m_geom).makeVertexNormals();
            ++j;
        }
        System.out.println(" PMCF Test going on : ");
    }

    public void coeffAMCF() {
        int i;
        PgElementSet geom = (PgElementSet)this.m_geom;
        this.m_curvMag = new PdVector(this.m_nov);
        this.m_vertCoeff = PdVector.realloc(null, (int)this.m_nov, (int)3);
        if (this.m_vertCoeff == null || this.m_vertCoeff.length < this.m_nov) {
            this.m_vertCoeff = PdVector.realloc(null, (int)this.m_nov, (int)3);
        } else {
            i = 0;
            while (i < this.m_nov) {
                this.m_vertCoeff[i].setConstant(0.0);
                ++i;
            }
        }
        PdVector he = new PdVector(3);
        double[] cot = new double[3];
        double[] cotNei = new double[3];
        i = 0;
        while (i < this.m_noe) {
            PiVector elem = this.m_elements[i];
            double area1 = geom.getAreaOfElement(i);
            PuVectorGeom.ctg((double[])cot, (PdVector)this.m_vertices[elem.m_data[0]], (PdVector)this.m_vertices[elem.m_data[1]], (PdVector)this.m_vertices[elem.m_data[2]]);
            int j = 0;
            while (j < 3) {
                if (this.m_elemNeigh[i].m_data[j] >= i) {
                    PiVector elemNei = this.m_elements[this.m_elemNeigh[i].m_data[j]];
                    double area2 = geom.getAreaOfElement(this.m_elemNeigh[i].m_data[j]);
                    PuVectorGeom.ctg((double[])cotNei, (PdVector)this.m_vertices[elemNei.m_data[0]], (PdVector)this.m_vertices[elemNei.m_data[1]], (PdVector)this.m_vertices[elemNei.m_data[2]]);
                    int oppVert = ((PgElementSet)this.m_geom).getOppVertexLocInd(i, j);
                    int a = elem.m_data[j];
                    int b = elem.m_data[(j + 1) % 3];
                    int c = elem.m_data[(j + 2) % 3];
                    int an = elemNei.m_data[oppVert];
                    int bn = elemNei.m_data[(oppVert + 1) % 3];
                    int cn = elemNei.m_data[(oppVert + 2) % 3];
                    int k = 0;
                    while (k < 3) {
                        he.m_data[k] = 0.5 * (area1 * (cot[(j + 1) % 3] * (this.m_vertices[c].m_data[k] - this.m_vertices[a].m_data[k]) + cot[(j + 2) % 3] * (this.m_vertices[b].m_data[k] - this.m_vertices[a].m_data[k])) + area2 * (cotNei[(oppVert + 1) % 3] * (this.m_vertices[cn].m_data[k] - this.m_vertices[an].m_data[k]) + cotNei[(oppVert + 2) % 3] * (this.m_vertices[bn].m_data[k] - this.m_vertices[an].m_data[k]))) / (area1 + area2);
                        ++k;
                    }
                    double ke = he.length();
                    if (ke > this.charCurv) {
                        he.multScalar(this.charCurv * this.charCurv / (this.charCurv * this.charCurv + 10.0 * (ke - this.charCurv) * (ke - this.charCurv)));
                    }
                    if (this.m_curvMag.m_data[b] < ke) {
                        this.m_curvMag.m_data[b] = ke;
                    }
                    if (this.m_curvMag.m_data[c] < ke) {
                        this.m_curvMag.m_data[c] = ke;
                    }
                    this.m_vertCoeff[b].sub(he);
                    this.m_vertCoeff[c].sub(he);
                }
                ++j;
            }
            ++i;
        }
        this.m_geom.update((Object)this.m_geom);
    }

    public void centroidElem(PiVector vertIndices) {
        this.m_centroid = new PdVector(3);
        int nov = vertIndices.getSize();
        int i = 0;
        while (i < nov) {
            this.m_centroid.add(this.m_geom.getVertex(vertIndices.m_data[i]));
            ++i;
        }
        this.m_centroid.multScalar(1.0 / (double)nov);
    }

    public void avgDistFace() {
        PgElementSet geom = (PgElementSet)this.m_geom;
        this.m_avgDistFacet = new PdVector(this.m_noe);
        this.vertexValence(geom);
        int i = 0;
        while (i < this.m_noe) {
            this.centroidElem(this.m_elements[i]);
            PdVector centroid = this.m_centroid;
            int non = this.m_elemNeigh[i].getSize();
            if (non != 0) {
                double elemDist = 0.0;
                int j = 0;
                while (j < non) {
                    PdVector loc = new PdVector(3);
                    PdVector locDiff = new PdVector(3);
                    if (this.m_elemNeigh[i].m_data[j] >= 0) {
                        PiVector elemNei = this.m_elements[this.m_elemNeigh[i].m_data[j]];
                        this.centroidElem(elemNei);
                        loc = this.m_centroid;
                        locDiff.sub(centroid, loc);
                        elemDist += locDiff.length();
                    }
                    ++j;
                }
                this.m_avgDistFacet.m_data[i] = elemDist / (double)non;
            }
            ++i;
        }
    }

    public void normalMean() {
        PgElementSet geom = (PgElementSet)this.m_geom;
        PgElementSet.triangulate((PgElementSet)geom);
        geom.makeElementNormals();
        PgVertexStar S = new PgVertexStar();
        PiVector elemIndices = PgVertexStar.getElementPerVertex((PgElementSet)geom);
        int noVert = geom.getNumVertices();
        int noEle = geom.getNumElements();
        PiVector[] element = geom.getElements();
        PdVector[] elemNorm = geom.getElementNormals();
        PdVector[] vert = geom.getVertices();
        PdVector[] elemNormUp = PdVector.realloc(null, (int)noEle, (int)3);
        double noi = this.m_noItera.getValue();
        int n = 0;
        while ((double)n < noi) {
            int i = 0;
            while (i < noEle) {
                PdVector updateNorm = new PdVector(3);
                int j = 0;
                while (j < 3) {
                    int vertIndex = element[i].m_data[j];
                    S.makeVertexStar(geom, vertIndex, elemIndices.m_data[vertIndex]);
                    PiVector neighEle = S.getElement();
                    int len = neighEle.getSize();
                    int k = 0;
                    while (k < len) {
                        if (neighEle.m_data[k] != i) {
                            double area = geom.getAreaOfElement(neighEle.m_data[k]);
                            PdVector scaleNormal = new PdVector(3);
                            scaleNormal.multScalar(elemNorm[neighEle.m_data[k]], area);
                            updateNorm.add(scaleNormal);
                        }
                        ++k;
                    }
                    ++j;
                }
                updateNorm.normalize();
                elemNormUp[i] = updateNorm;
                ++i;
            }
            i = 0;
            while (i < noVert) {
                S.makeVertexStar(geom, i, elemIndices.m_data[i]);
                PiVector locInd = S.getVertexLocInd();
                PiVector neighEle = S.getElement();
                int numElem = neighEle.getSize();
                PdVector vertUpdated = new PdVector(3);
                int j = 0;
                while (j < numElem) {
                    double loc = 0.0;
                    PiVector elemInd = element[neighEle.m_data[j]];
                    PdVector vert0 = vert[elemInd.m_data[locInd.m_data[j]]];
                    PdVector vert1 = vert[elemInd.m_data[(locInd.m_data[j] + 1) % 3]];
                    PdVector vert2 = vert[elemInd.m_data[(locInd.m_data[j] + 2) % 3]];
                    PdVector diff10 = new PdVector(3);
                    PdVector diff21 = new PdVector(3);
                    diff10.sub(vert1, vert0);
                    diff21.sub(vert2, vert0);
                    loc = diff10.dot(elemNormUp[neighEle.m_data[j]]) + diff21.dot(elemNormUp[neighEle.m_data[j]]);
                    vertUpdated.blendBase(vertUpdated, loc, elemNormUp[neighEle.m_data[j]]);
                    ++j;
                }
                vert[i].blendBase(vert[i], 1.0 / (3.0 * (double)numElem), vertUpdated);
                ++i;
            }
            geom.makeElementNormals();
            geom.makeVertexNormals();
            ++n;
        }
        geom.update((Object)geom);
        System.out.println(" DoneMeanNormal ");
    }

    public void bilateralNormal() {
        PgElementSet geom = (PgElementSet)this.m_geom;
        PgVertexStar S = new PgVertexStar();
        this.m_elemNormUp = PdVector.realloc(null, (int)this.m_noe, (int)3);
        this.m_angleError = new PdVector(this.m_noe);
        this.m_elemArea = new PdVector(this.m_noe);
        int i = 0;
        while (i < this.m_noe) {
            double distVar = this.m_avgDistFacet.m_data[i];
            PdVector updateNorm = new PdVector(3);
            PdVector centNormal = this.m_elemNormals[i];
            this.centroidElem(this.m_elements[i]);
            this.m_elemArea.m_data[i] = geom.getAreaOfElement(i);
            PdVector centroid = PdVector.copyNew((PdVector)this.m_centroid);
            int j = 0;
            while (j < 3) {
                int vertIndex = this.m_elements[i].m_data[j];
                S.makeVertexStar(geom, vertIndex, this.m_elemperVert.m_data[vertIndex]);
                PiVector neighEle = S.getElement();
                int len = neighEle.getSize();
                int k = 0;
                while (k < len) {
                    if (neighEle.m_data[k] != i) {
                        double area;
                        PdVector loc = new PdVector(3);
                        this.centroidElem(this.m_elements[neighEle.m_data[k]]);
                        loc = this.m_centroid;
                        PdVector normDiff = new PdVector(3);
                        PdVector locDiff = new PdVector(3);
                        locDiff.sub(centroid, loc);
                        normDiff.sub(centNormal, this.m_elemNormals[neighEle.m_data[k]]);
                        double distWeight = Math.exp(-locDiff.sqrLength() / (2.0 * distVar * distVar));
                        double normWeight = Math.exp(-normDiff.sqrLength() / (2.0 * this.m_normalVar * this.m_normalVar));
                        this.m_elemArea.m_data[neighEle.m_data[k]] = area = geom.getAreaOfElement(neighEle.m_data[k]);
                        double totalweight = distWeight * normWeight * area;
                        PdVector scaleNormal = new PdVector(3);
                        scaleNormal.multScalar(this.m_elemNormals[neighEle.m_data[k]], totalweight);
                        updateNorm.add(scaleNormal);
                    }
                    ++k;
                }
                ++j;
            }
            updateNorm.normalize();
            double sw = 1.0;
            updateNorm.blend(1.0 - sw, centNormal, sw, updateNorm);
            updateNorm.normalize();
            this.m_elemNormUp[i] = updateNorm;
            double loc = centNormal.dot(updateNorm);
            this.m_angleError.m_data[i] = Math.acos(loc) * 180.0 / Math.PI;
            ++i;
        }
    }

    public void tukeybilateralNormal() {
        PgElementSet geom = (PgElementSet)this.m_geom;
        PgVertexStar S = new PgVertexStar();
        this.m_elemNormUp = PdVector.realloc(null, (int)this.m_noe, (int)3);
        this.m_angleError = new PdVector(this.m_noe);
        this.m_elemArea = new PdVector(this.m_noe);
        int i = 0;
        while (i < this.m_noe) {
            double distVar = this.m_avgDistFacet.m_data[i];
            PdVector updateNorm = new PdVector(3);
            PdVector centNormal = this.m_elemNormals[i];
            this.centroidElem(this.m_elements[i]);
            this.m_elemArea.m_data[i] = geom.getAreaOfElement(i);
            PdVector centroid = PdVector.copyNew((PdVector)this.m_centroid);
            int j = 0;
            while (j < 3) {
                int vertIndex = this.m_elements[i].m_data[j];
                S.makeVertexStar(geom, vertIndex, this.m_elemperVert.m_data[vertIndex]);
                PiVector neighEle = S.getElement();
                int len = neighEle.getSize();
                int k = 0;
                while (k < len) {
                    if (neighEle.m_data[k] != i) {
                        double area;
                        PdVector loc = new PdVector(3);
                        this.centroidElem(this.m_elements[neighEle.m_data[k]]);
                        loc = this.m_centroid;
                        PdVector normDiff = new PdVector(3);
                        PdVector locDiff = new PdVector(3);
                        locDiff.sub(centroid, loc);
                        normDiff.sub(centNormal, this.m_elemNormals[neighEle.m_data[k]]);
                        double distWeight = Math.exp(-locDiff.sqrLength() / (2.0 * distVar * distVar));
                        double normWeight = 0.0;
                        if (normDiff.sqrLength() <= this.m_normalVar * this.m_normalVar) {
                            normWeight = 1.0 * (1.0 - normDiff.sqrLength() / this.m_normalVar * this.m_normalVar) * (1.0 - normDiff.sqrLength() / this.m_normalVar * this.m_normalVar);
                        }
                        this.m_elemArea.m_data[neighEle.m_data[k]] = area = geom.getAreaOfElement(neighEle.m_data[k]);
                        double totalweight = distWeight * normWeight * area;
                        PdVector scaleNormal = new PdVector(3);
                        scaleNormal.multScalar(this.m_elemNormals[neighEle.m_data[k]], totalweight);
                        updateNorm.add(scaleNormal);
                    }
                    ++k;
                }
                ++j;
            }
            updateNorm.normalize();
            double sw = 1.0;
            updateNorm.blend(1.0 - sw, centNormal, sw, updateNorm);
            updateNorm.normalize();
            this.m_elemNormUp[i] = updateNorm;
            double loc = centNormal.dot(updateNorm);
            this.m_angleError.m_data[i] = Math.acos(loc) * 180.0 / Math.PI;
            ++i;
        }
    }

    public void vertUpdatefromElem() {
        PgElementSet geom = (PgElementSet)this.m_geom;
        PgVertexStar S = new PgVertexStar();
        this.m_vertUpdated = PdVector.realloc(null, (int)this.m_nov, (int)3);
        this.m_vertFace = new PiVector(this.m_nov);
        this.m_vertArea = new PdVector(this.m_nov);
        this.m_vertArea.setConstant(0.0);
        this.m_dirCurvature = new PdVector(this.m_nov);
        int i = 0;
        while (i < this.m_nov) {
            int numElem;
            S.makeVertexStar(geom, i, this.m_elemperVert.m_data[i]);
            PiVector locInd = S.getVertexLocInd();
            PiVector neighEle = S.getElement();
            this.m_vertFace.m_data[i] = numElem = neighEle.getSize();
            double locArea = 0.0;
            int j = 0;
            while (j < numElem) {
                locArea += this.m_elemArea.m_data[neighEle.m_data[j]];
                double loc = 0.0;
                PiVector elemInd = this.m_elements[neighEle.m_data[j]];
                PdVector vert0 = this.m_vertices[elemInd.m_data[locInd.m_data[j]]];
                PdVector vert1 = this.m_vertices[elemInd.m_data[(locInd.m_data[j] + 1) % 3]];
                PdVector vert2 = this.m_vertices[elemInd.m_data[(locInd.m_data[j] + 2) % 3]];
                PdVector diff10 = new PdVector(3);
                PdVector diff21 = new PdVector(3);
                diff10.sub(vert1, vert0);
                diff21.sub(vert2, vert0);
                loc = diff10.dot(this.m_elemNormUp[neighEle.m_data[j]]) + diff21.dot(this.m_elemNormUp[neighEle.m_data[j]]);
                this.m_vertUpdated[i].blendBase(this.m_vertUpdated[i], loc, this.m_elemNormUp[neighEle.m_data[j]]);
                ++j;
            }
            this.m_vertArea.m_data[i] = locArea;
            ++i;
        }
        geom.makeElementNormals();
        geom.makeVertexNormals();
        geom.update((Object)geom);
    }

    public void weightedVertUpdatefromElem() {
        PgElementSet geom = (PgElementSet)this.m_geom;
        PgVertexStar S = new PgVertexStar();
        this.m_vertUpdated = PdVector.realloc(null, (int)this.m_nov, (int)3);
        this.m_vertFace = new PiVector(this.m_nov);
        this.m_vertArea = new PdVector(this.m_nov);
        this.m_vertArea.setConstant(0.0);
        this.m_dirCurvature = new PdVector(this.m_nov);
        int i = 0;
        while (i < this.m_nov) {
            int numElem;
            S.makeVertexStar(geom, i, this.m_elemperVert.m_data[i]);
            PiVector locInd = S.getVertexLocInd();
            PiVector neighEle = S.getElement();
            this.m_vertFace.m_data[i] = numElem = neighEle.getSize();
            double locArea = 0.0;
            int j = 0;
            while (j < numElem) {
                locArea += this.m_elemArea.m_data[neighEle.m_data[j]];
                double loc = 0.0;
                PiVector elemInd = this.m_elements[neighEle.m_data[j]];
                PdVector vert0 = this.m_vertices[elemInd.m_data[locInd.m_data[j]]];
                PdVector vert1 = this.m_vertices[elemInd.m_data[(locInd.m_data[j] + 1) % 3]];
                PdVector vert2 = this.m_vertices[elemInd.m_data[(locInd.m_data[j] + 2) % 3]];
                PdVector diff10 = new PdVector(3);
                PdVector diff21 = new PdVector(3);
                diff10.sub(vert1, vert0);
                diff21.sub(vert2, vert0);
                loc = diff10.dot(this.m_elemNormUp[neighEle.m_data[j]]) + diff21.dot(this.m_elemNormUp[neighEle.m_data[j]]);
                this.m_vertUpdated[i].blendBase(this.m_vertUpdated[i], loc, this.m_elemNormUp[neighEle.m_data[j]]);
                ++j;
            }
            this.m_vertArea.m_data[i] = locArea;
            ++i;
        }
        geom.makeElementNormals();
        geom.makeVertexNormals();
        geom.update((Object)geom);
    }

    public void bilateralNormalTukey() {
        int j;
        PgElementSet geom = (PgElementSet)this.m_geom;
        PgElementSet.triangulate((PgElementSet)geom);
        geom.makeElementNormals();
        PgVertexStar S = new PgVertexStar();
        PiVector elemIndices = PgVertexStar.getElementPerVertex((PgElementSet)geom);
        int noVert = geom.getNumVertices();
        int noEle = geom.getNumElements();
        PiVector[] element = geom.getElements();
        PdVector[] vert = geom.getVertices();
        PdVector[] elemNorm = geom.getElementNormals();
        this.m_elemNormUp = PdVector.realloc(null, (int)noEle, (int)3);
        this.avgDistFace();
        PdVector dirCurv = new PdVector(noEle);
        int i = 0;
        while (i < noEle) {
            double distVar = this.m_avgDistFacet.m_data[i];
            PdVector updateNorm = new PdVector(3);
            this.centroidElem(element[i]);
            PdVector centroid = this.m_centroid;
            PdVector centNormal = elemNorm[i];
            j = 0;
            while (j < 3) {
                int vertIndex = element[i].m_data[j];
                S.makeVertexStar(geom, vertIndex, elemIndices.m_data[vertIndex]);
                PiVector neighEle = S.getElement();
                int len = neighEle.getSize();
                int k = 0;
                while (k < len) {
                    if (neighEle.m_data[k] != i) {
                        PdVector loc = new PdVector(3);
                        this.centroidElem(element[neighEle.m_data[k]]);
                        loc = this.m_centroid;
                        PdVector normDiff = new PdVector(3);
                        PdVector locDiff = new PdVector(3);
                        locDiff.sub(centroid, loc);
                        normDiff.sub(centNormal, elemNorm[neighEle.m_data[k]]);
                        double diffDist = locDiff.sqrLength();
                        double diffnorm = normDiff.sqrLength();
                        double distWeight = diffDist < distVar * distVar ? 0.5 * ((1.0 - diffDist / (distVar * distVar)) * (1.0 - diffDist / (distVar * distVar))) : 0.0;
                        double normWeight = diffnorm < this.m_normalVar * this.m_normalVar ? 0.5 * ((1.0 - diffnorm / (this.m_normalVar * this.m_normalVar)) * (1.0 - diffnorm / (this.m_normalVar * this.m_normalVar))) : 0.0;
                        double area = geom.getAreaOfElement(neighEle.m_data[k]);
                        double totalweight = distWeight * normWeight * area;
                        PdVector scaleNormal = new PdVector(3);
                        scaleNormal.multScalar(elemNorm[neighEle.m_data[k]], totalweight);
                        updateNorm.add(scaleNormal);
                    }
                    ++k;
                }
                ++j;
            }
            updateNorm.normalize();
            this.m_elemNormUp[i] = updateNorm;
            ++i;
        }
        this.m_vertUpdatedTukey = PdVector.realloc(null, (int)noVert, (int)3);
        this.m_vertFaceTukey = new PiVector(noVert);
        this.m_dirCurvatureTukey = new PdVector(noVert);
        i = 0;
        while (i < noVert) {
            int numElem;
            S.makeVertexStar(geom, i, elemIndices.m_data[i]);
            PiVector locInd = S.getVertexLocInd();
            PiVector neighEle = S.getElement();
            this.m_vertFaceTukey.m_data[i] = numElem = neighEle.getSize();
            double areaSum = 0.0;
            j = 0;
            while (j < numElem) {
                double loc = 0.0;
                PiVector elemInd = element[neighEle.m_data[j]];
                PdVector vert0 = vert[elemInd.m_data[locInd.m_data[j]]];
                PdVector vert1 = vert[elemInd.m_data[(locInd.m_data[j] + 1) % 3]];
                PdVector vert2 = vert[elemInd.m_data[(locInd.m_data[j] + 2) % 3]];
                PdVector diff10 = new PdVector(3);
                PdVector diff21 = new PdVector(3);
                diff10.sub(vert1, vert0);
                diff21.sub(vert2, vert0);
                loc = diff10.dot(this.m_elemNormUp[neighEle.m_data[j]]) + diff21.dot(this.m_elemNormUp[neighEle.m_data[j]]);
                double areaElem = geom.getAreaOfElement(neighEle.m_data[j]);
                int n = i;
                this.m_dirCurvatureTukey.m_data[n] = this.m_dirCurvatureTukey.m_data[n] + areaElem * dirCurv.m_data[neighEle.m_data[j]];
                areaSum += areaElem;
                this.m_vertUpdatedTukey[i].blendBase(this.m_vertUpdatedTukey[i], loc, this.m_elemNormUp[neighEle.m_data[j]]);
                ++j;
            }
            int n = i++;
            this.m_dirCurvatureTukey.m_data[n] = this.m_dirCurvatureTukey.m_data[n] / areaSum;
        }
        geom.makeElementNormals();
        geom.makeVertexNormals();
        geom.update((Object)geom);
    }

    public void faceNormalVec() {
        PgElementSet geom = (PgElementSet)this.m_geom;
        geom.makeElementNormals();
        int nof = geom.getNumElements();
        PgVectorField vf = new PgVectorField(3);
        vf.setBasedOn(1);
        geom.addVectorField(vf);
        vf.setName("Element Normal");
        vf.setGeometry((PgPointSet)geom);
        vf.setNumVectors(nof);
        int i = 0;
        while (i < nof) {
            vf.setVector(i, this.m_elemNormUp[i]);
            ++i;
        }
        System.out.println(" element normal ");
    }

    public void bilateralNormalVertexUpdate() {
        long stTime = new Date().getTime();
        PgElementSet geom = (PgElementSet)this.m_geom;
        int noVert = geom.getNumVertices();
        PdVector[] vert = geom.getVertices();
        this.avgDistFace();
        this.m_normalVar = this.m_normVar.getValue();
        double noi = this.m_noItera.getValue();
        int n = 0;
        while ((double)n < noi) {
            this.bilateralNormal();
            this.vertUpdatefromElem();
            int i = 0;
            while (i < noVert) {
                vert[i].blendBase(vert[i], 1.0 / (3.0 * (double)this.m_vertFace.m_data[i]), this.m_vertUpdated[i]);
                ++i;
            }
            ++n;
        }
        geom.update((Object)geom);
        long enTime = new Date().getTime();
        System.out.println(" Done Bilateral Normal running time in ms" + (enTime - stTime));
    }

    public void bilateralNormalTukeyVertexUpdate() {
        PgElementSet geom = (PgElementSet)this.m_geom;
        int noVert = geom.getNumVertices();
        PdVector[] vert = geom.getVertices();
        this.m_normalVar = this.m_normVar.getValue();
        double noi = this.m_noItera.getValue();
        int n = 0;
        while ((double)n < noi) {
            this.bilateralNormalTukey();
            int i = 0;
            while (i < noVert) {
                vert[i].blendBase(vert[i], 1.0 / (3.0 * (double)this.m_vertFaceTukey.m_data[i]), this.m_vertUpdatedTukey[i]);
                ++i;
            }
            ++n;
        }
        geom.update((Object)geom);
        System.out.println(" Done Tukey Bilateral Normal ");
    }

    public static Color colorMap(double d) {
        float f;
        float g;
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        if (d > 0.2) {
            g = 1.0f;
            f = (float)(0.75 - (d -= 0.2));
            if (f < 0.0f) {
                f += 1.0f;
            }
        } else {
            f = 0.75f;
            d *= 5.0;
            d = d * d * d;
            g = (float)d;
        }
        return Color.getHSBColor(f, g, 1.0f);
    }

    public void colorCurv() {
        int noVert = ((PgPointSet)this.m_geom).getNumVertices();
        PdVector curMag = new PdVector(noVert);
        this.vertexValence((PgElementSet)this.m_geom);
        this.coeffAMCF();
        int j = 0;
        while (j < noVert) {
            curMag.m_data[j] = this.m_vertCoeff[j].length();
            ++j;
        }
        System.out.println(" avg of max curv at each vertex : " + curMag.average());
        int i = 0;
        while (i < noVert) {
            ((PgElementSet)this.m_geom).setVertexColor(i, PjSmoothOp.colorMap(curMag.m_data[i] / this.charCurv));
            ++i;
        }
        ((PgElementSet)this.m_geom).showVertexColors(true);
        ((PgElementSet)this.m_geom).showElementColorFromVertices(true);
        ((PgElementSet)this.m_geom).showElementColors(true);
        this.m_geom.update((Object)this.m_geom);
        System.out.println(" Coloring Done :");
    }

    public void colorVecBased(PdVector input) {
        double colorThreshold = this.m_featureDetect.getValue();
        int noVertproc = input.getSize();
        input.multScalar(1.0 / colorThreshold);
        int j = 0;
        while (j < noVertproc) {
            int red = 0;
            int green = 0;
            double locVar = input.m_data[j];
            if (locVar <= 0.5) {
                red = (int)(255.0 * (2.0 * locVar));
                green = 255;
            } else if (locVar > 1.0) {
                red = 255;
                green = 0;
            } else {
                red = 255;
                green = (int)(255.0 * (2.0 - 2.0 * locVar));
            }
            Color col = new Color(red, green, 0);
            ((PgElementSet)this.m_geom).setVertexColor(j, col);
            ++j;
        }
        ((PgElementSet)this.m_geom).showVertexColors(true);
        ((PgElementSet)this.m_geom).showElementColorFromVertices(true);
        ((PgElementSet)this.m_geom).showElementColors(true);
        this.m_geom.update((Object)this.m_geom);
        System.out.println(" Color field on the basis of Euclidean distance with same topology ");
    }

    public void color() {
        this.featuredEdge();
        this.edgeCurv();
        this.detectEdges();
        int noVert = ((PgPointSet)this.m_geom).getNumVertices();
        int i = 0;
        while (i < noVert) {
            if (this.m_featureVert[i]) {
                Color col = new Color(255, 0, 0);
                ((PgElementSet)this.m_geom).setVertexColor(i, col);
            } else {
                Color col2 = new Color(0, 255, 0);
                ((PgElementSet)this.m_geom).setVertexColor(i, col2);
            }
            ++i;
        }
        ((PgElementSet)this.m_geom).showVertexColors(true);
        ((PgElementSet)this.m_geom).showElementColorFromVertices(true);
        ((PgElementSet)this.m_geom).showElementColors(true);
        this.m_geom.update((Object)this.m_geom);
    }

    public void AMCF() {
        long stTime = new Date().getTime();
        double sw = this.m_stepWidth.getValue();
        int numIt = this.m_noItera.getValue();
        int noit = 0;
        while (noit < numIt) {
            PdVector[] vert = ((PgPointSet)this.m_geom).getVertices();
            int noVert = ((PgPointSet)this.m_geom).getNumVertices();
            this.coeffAMCF();
            int n = 0;
            while (n < noVert) {
                vert[n].blendBase(vert[n], sw, this.m_vertCoeff[n]);
                ++n;
            }
            ((PgElementSet)this.m_geom).update((Object)((PgElementSet)this.m_geom));
            ((PgElementSet)this.m_geom).makeElementNormals();
            ++noit;
        }
        long endTime = new Date().getTime();
        System.out.println(" Total time taken during calculation in milliseconds : " + (endTime - stTime));
    }

    public void areacoeffAMCF() {
        this.m_areavertCoeff = PdVector.realloc(null, (int)this.m_nov, (int)3);
        if (this.m_areavertCoeff == null || this.m_areavertCoeff.length < this.m_nov) {
            this.m_areavertCoeff = PdVector.realloc(null, (int)this.m_nov, (int)3);
        } else {
            int i = 0;
            while (i < this.m_nov) {
                this.m_areavertCoeff[i].setConstant(0.0);
                ++i;
            }
        }
        this.m_edgeAreaOp = new PdMatrix(this.m_noedge, this.m_nov);
        this.m_edgeReg = new PdMatrix(this.m_noedge, this.m_nov);
        this.m_maxareaCurv = new PdVector(this.m_nov);
        int dim = this.m_geom.getDimOfVertices();
        new PdVector(dim);
        this.m_vertWeight = new PdMatrix(this.m_nov, this.m_noedge);
        this.m_vertWeight.transpose(this.m_edgeAreaOp);
        int counter = 0;
        int i = 0;
        while (i < this.m_noe) {
            PiVector elem = this.m_elements[i];
            double elemArea1 = ((PgElementSet)this.m_geom).getAreaOfElement(i);
            int j = 0;
            while (j < 3) {
                if (this.m_elemNeigh[i].m_data[j] >= i) {
                    PiVector elemNei = this.m_elements[this.m_elemNeigh[i].m_data[j]];
                    double elemArea2 = ((PgElementSet)this.m_geom).getAreaOfElement(this.m_elemNeigh[i].m_data[j]);
                    int oppVert = ((PgElementSet)this.m_geom).getOppVertexLocInd(i, j);
                    int a = elem.m_data[j];
                    int b = elem.m_data[(j + 1) % 3];
                    int c = elem.m_data[(j + 2) % 3];
                    int an = elemNei.m_data[oppVert];
                    PdVector edgep1p3 = PdVector.subNew((PdVector)((PgElementSet)this.m_geom).getVertex(b), (PdVector)((PgElementSet)this.m_geom).getVertex(c));
                    PdVector edgep4p3 = PdVector.subNew((PdVector)((PgElementSet)this.m_geom).getVertex(a), (PdVector)((PgElementSet)this.m_geom).getVertex(c));
                    PdVector edgep3p2 = PdVector.subNew((PdVector)((PgElementSet)this.m_geom).getVertex(c), (PdVector)((PgElementSet)this.m_geom).getVertex(an));
                    PdVector edgep1p4 = PdVector.subNew((PdVector)((PgElementSet)this.m_geom).getVertex(b), (PdVector)((PgElementSet)this.m_geom).getVertex(a));
                    PdVector edgep2p1 = PdVector.subNew((PdVector)((PgElementSet)this.m_geom).getVertex(an), (PdVector)((PgElementSet)this.m_geom).getVertex(b));
                    PdVector edgep3p1 = PdVector.subNew((PdVector)((PgElementSet)this.m_geom).getVertex(c), (PdVector)((PgElementSet)this.m_geom).getVertex(b));
                    double cSqrLength = edgep1p3.sqrLength();
                    double locp1 = (edgep4p3.dot(edgep3p1) * elemArea2 + edgep1p3.dot(edgep3p2) * elemArea1) / ((elemArea1 + elemArea2) * cSqrLength);
                    double locp2 = elemArea1 / (elemArea1 + elemArea2);
                    double locp3 = (edgep3p1.dot(edgep1p4) * elemArea2 + edgep1p3.dot(edgep2p1) * elemArea1) / ((elemArea1 + elemArea2) * cSqrLength);
                    double locp4 = elemArea2 / (elemArea1 + elemArea2);
                    this.m_edgeAreaOp.setEntry(counter, b, locp1);
                    this.m_edgeAreaOp.setEntry(counter, an, locp2);
                    this.m_edgeAreaOp.setEntry(counter, c, locp3);
                    this.m_edgeAreaOp.setEntry(counter, a, locp4);
                    this.m_edgeReg.addEntry(counter, b, -1.0);
                    this.m_edgeReg.addEntry(counter, c, -1.0);
                    this.m_edgeReg.addEntry(counter, an, 1.0);
                    this.m_edgeReg.addEntry(counter, a, 1.0);
                    ++counter;
                }
                ++j;
            }
            ++i;
        }
    }

    public void areacoeffAMCFSparse() {
        this.m_areavertCoeff = PdVector.realloc(null, (int)this.m_nov, (int)3);
        if (this.m_areavertCoeff == null || this.m_areavertCoeff.length < this.m_nov) {
            this.m_areavertCoeff = PdVector.realloc(null, (int)this.m_nov, (int)3);
        } else {
            int i = 0;
            while (i < this.m_nov) {
                this.m_areavertCoeff[i].setConstant(0.0);
                ++i;
            }
        }
        this.m_edgeAreaOpSparse = new PnSparseMatrix(this.m_noedge, this.m_nov);
        this.m_edgeRegSparse = new PnSparseMatrix(this.m_noedge, this.m_nov);
        this.m_maxareaCurv = new PdVector(this.m_nov);
        int dim = this.m_geom.getDimOfVertices();
        new PdVector(dim);
        this.m_vertWeightSparse = new PnSparseMatrix(this.m_nov, this.m_noedge);
        this.m_vertWeightSparse.transpose(this.m_edgeAreaOpSparse);
        int counter = 0;
        int i = 0;
        while (i < this.m_noe) {
            PiVector elem = this.m_elements[i];
            double elemArea1 = ((PgElementSet)this.m_geom).getAreaOfElement(i);
            int j = 0;
            while (j < 3) {
                if (this.m_elemNeigh[i].m_data[j] >= i) {
                    PiVector elemNei = this.m_elements[this.m_elemNeigh[i].m_data[j]];
                    double elemArea2 = ((PgElementSet)this.m_geom).getAreaOfElement(this.m_elemNeigh[i].m_data[j]);
                    int oppVert = ((PgElementSet)this.m_geom).getOppVertexLocInd(i, j);
                    int a = elem.m_data[j];
                    int b = elem.m_data[(j + 1) % 3];
                    int c = elem.m_data[(j + 2) % 3];
                    int an = elemNei.m_data[oppVert];
                    PdVector edgep1p3 = PdVector.subNew((PdVector)((PgElementSet)this.m_geom).getVertex(b), (PdVector)((PgElementSet)this.m_geom).getVertex(c));
                    PdVector edgep4p3 = PdVector.subNew((PdVector)((PgElementSet)this.m_geom).getVertex(a), (PdVector)((PgElementSet)this.m_geom).getVertex(c));
                    PdVector edgep3p2 = PdVector.subNew((PdVector)((PgElementSet)this.m_geom).getVertex(c), (PdVector)((PgElementSet)this.m_geom).getVertex(an));
                    PdVector edgep1p4 = PdVector.subNew((PdVector)((PgElementSet)this.m_geom).getVertex(b), (PdVector)((PgElementSet)this.m_geom).getVertex(a));
                    PdVector edgep2p1 = PdVector.subNew((PdVector)((PgElementSet)this.m_geom).getVertex(an), (PdVector)((PgElementSet)this.m_geom).getVertex(b));
                    PdVector edgep3p1 = PdVector.subNew((PdVector)((PgElementSet)this.m_geom).getVertex(c), (PdVector)((PgElementSet)this.m_geom).getVertex(b));
                    double cSqrLength = edgep1p3.sqrLength();
                    double locp1 = (edgep4p3.dot(edgep3p1) * elemArea2 + edgep1p3.dot(edgep3p2) * elemArea1) / ((elemArea1 + elemArea2) * cSqrLength);
                    double locp2 = elemArea1 / (elemArea1 + elemArea2);
                    double locp3 = (edgep3p1.dot(edgep1p4) * elemArea2 + edgep1p3.dot(edgep2p1) * elemArea1) / ((elemArea1 + elemArea2) * cSqrLength);
                    double locp4 = elemArea2 / (elemArea1 + elemArea2);
                    this.m_edgeAreaOpSparse.setEntry(counter, b, locp1);
                    this.m_edgeAreaOpSparse.setEntry(counter, an, locp2);
                    this.m_edgeAreaOpSparse.setEntry(counter, c, locp3);
                    this.m_edgeAreaOpSparse.setEntry(counter, a, locp4);
                    this.m_edgeRegSparse.addEntry(counter, b, -1.0);
                    this.m_edgeRegSparse.addEntry(counter, c, -1.0);
                    this.m_edgeRegSparse.addEntry(counter, an, 1.0);
                    this.m_edgeRegSparse.addEntry(counter, a, 1.0);
                    ++counter;
                }
                ++j;
            }
            ++i;
        }
    }

    public void edgeReg() {
        PgElementSet.triangulate((PgElementSet)((PgElementSet)this.m_geom));
        ((PgElementSet)this.m_geom).makeElementNormals();
        this.gridSize();
        int noVert = ((PgPointSet)this.m_geom).getNumVertices();
        this.m_vertReg = PdVector.realloc(null, (int)noVert, (int)3);
        int v = 0;
        while (v < noVert) {
            this.m_vertReg[v].setConstant(0.0);
            ++v;
        }
        PdVector[] vert = PdVector.copyNew((PdVector[])((PgElementSet)this.m_geom).getVertices());
        int noEle = ((PgElementSet)this.m_geom).getNumElements();
        PiVector[] element = ((PgElementSet)this.m_geom).getElements();
        PiVector[] neigh = ((PgElementSet)this.m_geom).getNeighbours();
        double diam = ((PgElementSet)this.m_geom).getDiameter();
        PdVector reg = new PdVector(3);
        int i = 0;
        while (i < noEle) {
            PiVector elem = element[i];
            int j = 0;
            while (j < 3) {
                if (neigh[i].m_data[j] >= i) {
                    PiVector elemNei = element[neigh[i].m_data[j]];
                    int oppVert = ((PgElementSet)this.m_geom).getOppVertexLocInd(i, j);
                    int a = elem.m_data[j];
                    int b = elem.m_data[(j + 1) % 3];
                    int c = elem.m_data[(j + 2) % 3];
                    int an = elemNei.m_data[oppVert];
                    int k = 0;
                    while (k < 3) {
                        reg.m_data[k] = -vert[b].m_data[k] - vert[c].m_data[k] + vert[an].m_data[k] + vert[a].m_data[k];
                        ++k;
                    }
                    this.m_vertReg[b].add(reg);
                    this.m_vertReg[c].add(reg);
                }
                ++j;
            }
            ++i;
        }
        double newDiam = ((PgElementSet)this.m_geom).getDiameter();
        ((PgElementSet)this.m_geom).scale(diam / newDiam);
        ((PgElementSet)this.m_geom).makeElementNormals();
        ((PgElementSet)this.m_geom).update((Object)((PgElementSet)this.m_geom));
    }

    public void areaAMCF() {
        long stTime = new Date().getTime();
        this.areacoeffAMCF();
        int noVert = ((PgPointSet)this.m_geom).getNumVertices();
        PdVector[] vert = ((PgPointSet)this.m_geom).getVertices();
        double sw = this.m_stepWidth.getValue();
        this.vertexStarArea();
        int n = 0;
        while (n < noVert) {
            vert[n].blendBase(vert[n], sw, this.m_areavertCoeff[n]);
            ++n;
        }
        ((PgElementSet)this.m_geom).update((Object)((PgElementSet)this.m_geom));
        ((PgElementSet)this.m_geom).makeElementNormals();
        long endTime = new Date().getTime();
        System.out.println(" Total time taken during calculation : " + (endTime - stTime) / 1000L);
    }

    public void showDiffOp() {
        int nov = ((PgElementSet)this.m_geom).getNumVertices();
        double colorThreshold = this.m_colorThreshold.getValue();
        PdVector grad = new PdVector(nov);
        this.coeffAMCF();
        int i = 0;
        while (i < nov) {
            grad.m_data[i] = this.m_vertCoeff[i].length();
            ++i;
        }
        grad.multScalar(1.0 / colorThreshold);
        int j = 0;
        while (j < nov) {
            int red = 0;
            int green = 0;
            double locVar = grad.m_data[j];
            if (locVar <= 0.5) {
                red = (int)(255.0 * (2.0 * locVar));
                green = 255;
            } else if (locVar > 1.0) {
                red = 255;
                green = 0;
            } else {
                red = 255;
                green = (int)(255.0 * (2.0 - 2.0 * locVar));
            }
            Color col = new Color(red, green, 0);
            ((PgPointSet)this.m_geom).setVertexColor(j, col);
            ++j;
        }
        ((PgPointSet)this.m_geom).showVertexColors(true);
        this.m_geom.update((Object)this.m_geom);
        System.out.println(" Color field  ");
    }

    public void showareaDiffOp() {
        int nov = ((PgElementSet)this.m_geom).getNumVertices();
        double colorThreshold = this.m_color.getValue();
        PdVector grad = new PdVector(nov);
        this.areacoeffAMCF();
        int i = 0;
        while (i < nov) {
            grad.m_data[i] = this.m_areavertCoeff[i].length();
            ++i;
        }
        grad.multScalar(1.0 / colorThreshold);
        int j = 0;
        while (j < nov) {
            int red = 0;
            int green = 0;
            double locVar = grad.m_data[j];
            if (locVar <= 0.5) {
                red = (int)(255.0 * (2.0 * locVar));
                green = 255;
            } else if (locVar > 1.0) {
                red = 255;
                green = 0;
            } else {
                red = 255;
                green = (int)(255.0 * (2.0 - 2.0 * locVar));
            }
            Color col = new Color(red, green, 0);
            ((PgPointSet)this.m_geom).setVertexColor(j, col);
            ++j;
        }
        ((PgPointSet)this.m_geom).showVertexColors(true);
        this.m_geom.update((Object)this.m_geom);
        System.out.println(" Color field  ");
    }

    public void errNormSmooth() {
        int i;
        PgElementSet geom = (PgElementSet)this.m_geom;
        int nov = geom.getNumVertices();
        if (this.errAnisoGrad == null || this.errAnisoGrad.length < nov) {
            this.errAnisoGrad = PdVector.realloc(null, (int)nov, (int)3);
        } else {
            i = 0;
            while (i < nov) {
                this.errAnisoGrad[i].setConstant(0.0);
                ++i;
            }
        }
        int noe = geom.getNumElements();
        PiVector[] element = geom.getElements();
        PiVector[] neigh = geom.getNeighbours();
        PdVector[] vert = geom.getVertices();
        int dim = geom.getDimOfVertices();
        PdVector he = new PdVector(dim);
        double[] cot = new double[3];
        double sw = this.m_stepWidth.getValue();
        double[] cotNei = new double[3];
        int it = this.m_noItera.getValue();
        int m = 0;
        while (m < it) {
            i = 0;
            while (i < noe) {
                PiVector elem = element[i];
                PuVectorGeom.ctg((double[])cot, (PdVector)vert[elem.m_data[0]], (PdVector)vert[elem.m_data[1]], (PdVector)vert[elem.m_data[2]]);
                int j = 0;
                while (j < 3) {
                    if (neigh[i].m_data[j] >= i) {
                        PiVector elemNei = element[neigh[i].m_data[j]];
                        PuVectorGeom.ctg((double[])cotNei, (PdVector)vert[elemNei.m_data[0]], (PdVector)vert[elemNei.m_data[1]], (PdVector)vert[elemNei.m_data[2]]);
                        int oppVert = geom.getOppVertexLocInd(i, j);
                        int a = elem.m_data[j];
                        int b = elem.m_data[(j + 1) % 3];
                        int c = elem.m_data[(j + 2) % 3];
                        int an = elemNei.m_data[oppVert];
                        int bn = elemNei.m_data[(oppVert + 1) % 3];
                        int cn = elemNei.m_data[(oppVert + 2) % 3];
                        int k = 0;
                        while (k < dim) {
                            he.m_data[k] = 0.5 * (cot[(j + 1) % 3] * (vert[c].m_data[k] - vert[a].m_data[k]) + cot[(j + 2) % 3] * (vert[b].m_data[k] - vert[a].m_data[k]) + cotNei[(oppVert + 1) % 3] * (vert[cn].m_data[k] - vert[an].m_data[k]) + cotNei[(oppVert + 2) % 3] * (vert[bn].m_data[k] - vert[an].m_data[k]));
                            ++k;
                        }
                        double ke = he.length();
                        if (ke > this.charCurv) {
                            he.multScalar(0.5 * Math.pow(1.0 - Math.pow(ke * ke / (this.charCurv * this.charCurv), 2.0), 2.0));
                        }
                        this.errAnisoGrad[b].sub(he);
                        this.errAnisoGrad[c].sub(he);
                    }
                    ++j;
                }
                ++i;
            }
            int n = 0;
            while (n < nov) {
                vert[n].blendBase(vert[n], sw, this.errAnisoGrad[n]);
                ++n;
            }
            geom.update((Object)geom);
            geom.makeElementNormals();
            geom.makeVertexNormals();
            ++m;
        }
    }

    public void showedgecotan() {
        int nov = ((PgElementSet)this.m_geom).getNumVertices();
        double colorThreshold = this.m_color.getValue();
        PdVector grad = new PdVector(nov);
        this.edgeCotanOperator();
        int i = 0;
        while (i < nov) {
            grad.m_data[i] = this.m_vertMean[i].length();
            ++i;
        }
        grad.multScalar(1.0 / colorThreshold);
        int j = 0;
        while (j < nov) {
            int red = 0;
            int green = 0;
            double locVar = grad.m_data[j];
            if (locVar <= 0.5) {
                red = (int)(255.0 * (2.0 * locVar));
                green = 255;
            } else if (locVar > 1.0) {
                red = 255;
                green = 0;
            } else {
                red = 255;
                green = (int)(255.0 * (2.0 - 2.0 * locVar));
            }
            Color col = new Color(red, green, 0);
            ((PgPointSet)this.m_geom).setVertexColor(j, col);
            ++j;
        }
        ((PgPointSet)this.m_geom).showVertexColors(true);
        this.m_geom.update((Object)this.m_geom);
        System.out.println(" Color field  ");
    }

    private void vertexStarArea() {
        int noVert = ((PgPointSet)this.m_geom).getNumVertices();
        int noEl = ((PgElementSet)this.m_geom).getNumElements();
        this.m_vertexStarArea = new PdVector(noVert);
        int i = 0;
        while (i < noEl) {
            PiVector element = ((PgElementSet)this.m_geom).getElement(i);
            int size = element.getSize();
            double area = ((PgElementSet)this.m_geom).getAreaOfElement(i);
            int k = 0;
            while (k < size) {
                int n = element.m_data[k];
                this.m_vertexStarArea.m_data[n] = this.m_vertexStarArea.m_data[n] + area;
                ++k;
            }
            ++i;
        }
    }

    public void edgeCurv() {
        PgElementSet geom = (PgElementSet)this.m_geom;
        int nov = geom.getNumVertices();
        PdVector[] curvVert = PdVector.realloc(null, (int)nov, (int)3);
        this.m_curvAboveThre = PdVector.realloc(null, (int)nov, (int)3);
        this.m_featureVert = new boolean[nov];
        int i = 0;
        while (i < nov) {
            this.m_featureVert[i] = false;
            ++i;
        }
        int noe = geom.getNumElements();
        PiVector[] element = geom.getElements();
        PiVector[] neigh = geom.getNeighbours();
        PdVector[] vert = geom.getVertices();
        int dim = geom.getDimOfVertices();
        PdVector he = new PdVector(dim);
        double[] cot = new double[3];
        double[] cotNei = new double[3];
        i = 0;
        while (i < noe) {
            PiVector elem = element[i];
            PuVectorGeom.ctg((double[])cot, (PdVector)vert[elem.m_data[0]], (PdVector)vert[elem.m_data[1]], (PdVector)vert[elem.m_data[2]]);
            int j = 0;
            while (j < 3) {
                if (neigh[i].m_data[j] >= i) {
                    PiVector elemNei = element[neigh[i].m_data[j]];
                    PuVectorGeom.ctg((double[])cotNei, (PdVector)vert[elemNei.m_data[0]], (PdVector)vert[elemNei.m_data[1]], (PdVector)vert[elemNei.m_data[2]]);
                    int oppVert = geom.getOppVertexLocInd(i, j);
                    int a = elem.m_data[j];
                    int b = elem.m_data[(j + 1) % 3];
                    int c = elem.m_data[(j + 2) % 3];
                    int an = elemNei.m_data[oppVert];
                    int bn = elemNei.m_data[(oppVert + 1) % 3];
                    int cn = elemNei.m_data[(oppVert + 2) % 3];
                    int k = 0;
                    while (k < dim) {
                        he.m_data[k] = 0.5 * (cot[(j + 1) % 3] * (vert[c].m_data[k] - vert[a].m_data[k]) + cot[(j + 2) % 3] * (vert[b].m_data[k] - vert[a].m_data[k]) + cotNei[(oppVert + 1) % 3] * (vert[cn].m_data[k] - vert[an].m_data[k]) + cotNei[(oppVert + 2) % 3] * (vert[bn].m_data[k] - vert[an].m_data[k]));
                        ++k;
                    }
                    double ke = he.length();
                    if (ke > this.charCurv) {
                        this.m_curvAboveThre[b].sub(he);
                        this.m_curvAboveThre[c].sub(he);
                        this.m_featureVert[b] = true;
                        this.m_featureVert[c] = true;
                    }
                    curvVert[b].sub(he);
                    curvVert[c].sub(he);
                }
                ++j;
            }
            ++i;
        }
    }

    public void featuredEdge() {
        PgElementSet geom = (PgElementSet)this.m_geom;
        int nov = geom.getNumVertices();
        int noEdge = geom.getNumEdges();
        PgVertexStar S = new PgVertexStar();
        PiVector elemIndices = PgVertexStar.getElementPerVertex((PgElementSet)geom);
        ArrayList matrix = new ArrayList();
        this.edgeCurv();
        int counter = 0;
        int i = 0;
        while (i < nov) {
            if (this.m_featureVert[i]) {
                S.makeVertexStar(geom, i, elemIndices.m_data[i]);
                PiVector vertStar = S.getLink();
                int starSize = vertStar.getSize();
                int j = 0;
                while (j < starSize) {
                    if (this.m_featureVert[vertStar.m_data[j]]) {
                        ArrayList<Integer> edge = new ArrayList<Integer>(2);
                        edge.add(i);
                        edge.add(vertStar.m_data[j]);
                        matrix.add(counter, edge);
                        ++counter;
                    }
                    ++j;
                }
            }
            ++i;
        }
        System.out.println(" Number of featured edges : " + counter);
        System.out.println(" Number of total edges : " + noEdge);
    }

    public void vertStarElenIndices() {
        PgElementSet geom = (PgElementSet)this.m_geom;
        this.m_vorArea = new PdVector(this.m_nov);
        PgVertexStar S = new PgVertexStar();
        PiVector elemIndices = PgVertexStar.getElementPerVertex((PgElementSet)geom);
        int k = 0;
        while (k < this.m_nov) {
            S.makeVertexStar(geom, k, elemIndices.m_data[k]);
            PiVector elemInd = S.getElement();
            int size = elemInd.getSize();
            double areaVert = 0.0;
            int j = 0;
            while (j < size) {
                int locInd = elemInd.m_data[j];
                if (locInd >= 0) {
                    double area = geom.getAreaOfElement(locInd);
                    areaVert += area;
                }
                ++j;
            }
            this.m_vorArea.m_data[k] = areaVert / (double)size;
            ++k;
        }
    }

    public void vertexValence(PgElementSet geom) {
        this.m_connEdge = new PiVector(this.m_nov);
        PgVertexStar S = new PgVertexStar();
        PiVector elemIndices = PgVertexStar.getElementPerVertex((PgElementSet)geom);
        int k = 0;
        while (k < this.m_nov) {
            S.makeVertexStar(geom, k, elemIndices.m_data[k]);
            PiVector Neigh_Ind = S.getLink();
            this.m_connEdge.m_data[k] = Neigh_Ind.getSize();
            ++k;
        }
    }

    public void edgeCurvature() {
        int i;
        PgElementSet geom = (PgElementSet)this.m_geom;
        int nov = geom.getNumVertices();
        int noEdge = geom.getNumElements();
        if (this.anisoAreaGrad == null || this.anisoAreaGrad.length < nov) {
            this.anisoAreaGrad = PdVector.realloc(null, (int)nov, (int)3);
        } else {
            i = 0;
            while (i < nov) {
                this.anisoAreaGrad[i].setConstant(0.0);
                ++i;
            }
        }
        if (this.m_edgeCurv == null || this.m_edgeCurv.length < noEdge) {
            this.m_edgeCurv = PdVector.realloc(null, (int)noEdge, (int)3);
        } else {
            i = 0;
            while (i < noEdge) {
                this.m_edgeCurv[i].setConstant(0.0);
                ++i;
            }
        }
        int noe = geom.getNumElements();
        PiVector[] element = geom.getElements();
        PiVector[] neigh = geom.getNeighbours();
        PdVector[] vert = geom.getVertices();
        int dim = geom.getDimOfVertices();
        PdVector he = new PdVector(dim);
        double[] cot = new double[3];
        double[] cotNei = new double[3];
        int counter = 0;
        i = 0;
        while (i < noe) {
            PiVector elem = element[i];
            PuVectorGeom.ctg((double[])cot, (PdVector)vert[elem.m_data[0]], (PdVector)vert[elem.m_data[1]], (PdVector)vert[elem.m_data[2]]);
            int j = 0;
            while (j < 3) {
                if (neigh[i].m_data[j] >= i) {
                    PiVector elemNei = element[neigh[i].m_data[j]];
                    PuVectorGeom.ctg((double[])cotNei, (PdVector)vert[elemNei.m_data[0]], (PdVector)vert[elemNei.m_data[1]], (PdVector)vert[elemNei.m_data[2]]);
                    int oppVert = geom.getOppVertexLocInd(i, j);
                    int a = elem.m_data[j];
                    int b = elem.m_data[(j + 1) % 3];
                    int c = elem.m_data[(j + 2) % 3];
                    int an = elemNei.m_data[oppVert];
                    int bn = elemNei.m_data[(oppVert + 1) % 3];
                    int cn = elemNei.m_data[(oppVert + 2) % 3];
                    int k = 0;
                    while (k < dim) {
                        he.m_data[k] = 0.5 * (cot[(j + 1) % 3] * (vert[c].m_data[k] - vert[a].m_data[k]) + cot[(j + 2) % 3] * (vert[b].m_data[k] - vert[a].m_data[k]) + cotNei[(oppVert + 1) % 3] * (vert[cn].m_data[k] - vert[an].m_data[k]) + cotNei[(oppVert + 2) % 3] * (vert[bn].m_data[k] - vert[an].m_data[k]));
                        ++k;
                    }
                    this.anisoAreaGrad[b].sub(he);
                    this.anisoAreaGrad[c].sub(he);
                    this.m_edgeCurv[counter] = he;
                }
                ++j;
            }
            ++i;
        }
    }

    public void edgeCotanOperator() {
        this.m_edgeCotan = new PnSparseMatrix(this.m_noedge, this.m_nov);
        this.m_locMat = this.m_edgeCotan.toPdMatrix();
        this.m_edgeReg = new PdMatrix(this.m_noedge, this.m_nov);
        PdVector he = new PdVector(3);
        double[] cot = new double[3];
        PdVector[] edgeMeanCurv = PdVector.realloc(null, (int)this.m_noedge, (int)3);
        this.m_vertWeight = new PdMatrix(this.m_nov, this.m_noedge);
        this.m_vertWeight.transpose(this.m_locMat);
        double[] cotNei = new double[3];
        int counter = 0;
        int i = 0;
        while (i < this.m_noe) {
            PiVector elem = this.m_elements[i];
            PuVectorGeom.ctg((double[])cot, (PdVector)this.m_vertices[elem.m_data[0]], (PdVector)this.m_vertices[elem.m_data[1]], (PdVector)this.m_vertices[elem.m_data[2]]);
            int j = 0;
            while (j < 3) {
                if (this.m_elemNeigh[i].m_data[j] >= i) {
                    PiVector elemNei = this.m_elements[this.m_elemNeigh[i].m_data[j]];
                    PuVectorGeom.ctg((double[])cotNei, (PdVector)this.m_vertices[elemNei.m_data[0]], (PdVector)this.m_vertices[elemNei.m_data[1]], (PdVector)this.m_vertices[elemNei.m_data[2]]);
                    int oppVert = ((PgElementSet)this.m_geom).getOppVertexLocInd(i, j);
                    int a = elem.m_data[j];
                    int b = elem.m_data[(j + 1) % 3];
                    int c = elem.m_data[(j + 2) % 3];
                    int an = elemNei.m_data[oppVert];
                    int bn = elemNei.m_data[(oppVert + 1) % 3];
                    int cn = elemNei.m_data[(oppVert + 2) % 3];
                    int k = 0;
                    while (k < 3) {
                        he.m_data[k] = 0.5 * (cot[(j + 1) % 3] * (this.m_vertices[c].m_data[k] - this.m_vertices[a].m_data[k]) + cot[(j + 2) % 3] * (this.m_vertices[b].m_data[k] - this.m_vertices[a].m_data[k]) + cotNei[(oppVert + 1) % 3] * (this.m_vertices[cn].m_data[k] - this.m_vertices[an].m_data[k]) + cotNei[(oppVert + 2) % 3] * (this.m_vertices[bn].m_data[k] - this.m_vertices[an].m_data[k]));
                        ++k;
                    }
                    he.length();
                    edgeMeanCurv[counter].add(he);
                    this.m_locMat.addEntry(counter, b, cot[(j + 2) % 3] + cotNei[(oppVert + 1) % 3]);
                    this.m_edgeReg.addEntry(counter, b, -1.0);
                    this.m_locMat.addEntry(counter, c, cot[(j + 1) % 3] + cotNei[(oppVert + 2) % 3]);
                    this.m_edgeReg.addEntry(counter, c, -1.0);
                    this.m_locMat.addEntry(counter, an, -(cotNei[(oppVert + 1) % 3] + cotNei[(oppVert + 2) % 3]));
                    this.m_edgeReg.addEntry(counter, an, 1.0);
                    this.m_locMat.addEntry(counter, a, -(cot[(j + 1) % 3] + cot[(j + 2) % 3]));
                    this.m_edgeReg.addEntry(counter, a, 1.0);
                    this.m_vertWeight.setEntry(b, counter, 1.0 / (double)this.m_connEdge.m_data[b]);
                    this.m_vertWeight.setEntry(c, counter, 1.0 / (double)this.m_connEdge.m_data[c]);
                    ++counter;
                }
                ++j;
            }
            ++i;
        }
    }

    public void vertFromEdge(PdMatrix edgeOp) {
        int noVert = edgeOp.getJSize();
        int noEdge = edgeOp.getISize();
        PdVector[] vert = ((PgPointSet)this.m_geom).getVertices();
        PdVector heTest = new PdVector(3);
        PdMatrix locX = new PdMatrix(noVert, 1);
        PdMatrix locY = new PdMatrix(noVert, 1);
        PdMatrix locZ = new PdMatrix(noVert, 1);
        int n = 0;
        while (n < noVert) {
            locX.setEntry(n, 0, vert[n].m_data[0]);
            locY.setEntry(n, 0, vert[n].m_data[1]);
            locZ.setEntry(n, 0, vert[n].m_data[2]);
            ++n;
        }
        PdMatrix locMatX = new PdMatrix(1, noVert);
        PdVector[] edgeMeanCurvt = PdVector.realloc(null, (int)noEdge, (int)3);
        int p = 0;
        while (p < noEdge) {
            int m = 0;
            while (m < noVert) {
                locMatX.setEntry(0, m, edgeOp.getEntry(p, m));
                ++m;
            }
            PdMatrix locMulX = new PdMatrix(1, 1);
            locMulX.mult(locMatX, locX);
            PdMatrix locMulY = new PdMatrix(1, 1);
            locMulY.mult(locMatX, locY);
            PdMatrix locMulZ = new PdMatrix(1, 1);
            locMulZ.mult(locMatX, locZ);
            heTest.m_data[0] = locMulX.getEntry(0, 0);
            heTest.m_data[1] = locMulY.getEntry(0, 0);
            heTest.m_data[2] = locMulZ.getEntry(0, 0);
            edgeMeanCurvt[p].add(heTest);
            ++p;
        }
        this.m_vertMean = PdVector.realloc(null, (int)noVert, (int)3);
        int m = 0;
        while (m < noVert) {
            int n2 = 0;
            while (n2 < noEdge) {
                this.m_vertMean[m].m_data[0] = this.m_vertMean[m].m_data[0] + this.m_vertWeight.getEntry(m, n2) * edgeMeanCurvt[n2].m_data[0];
                this.m_vertMean[m].m_data[1] = this.m_vertMean[m].m_data[1] + this.m_vertWeight.getEntry(m, n2) * edgeMeanCurvt[n2].m_data[1];
                this.m_vertMean[m].m_data[2] = this.m_vertMean[m].m_data[2] + this.m_vertWeight.getEntry(m, n2) * edgeMeanCurvt[n2].m_data[2];
                ++n2;
            }
            ++m;
        }
    }

    public void avgDihedral() {
        int noEdge = ((PgElementSet)this.m_geom).getNumEdges();
        this.m_dihArr = new PdVector(noEdge);
        int counter = 0;
        int i = 0;
        while (i < this.m_noe) {
            int size = this.m_elements[i].getSize();
            PiVector neigh = this.m_elemNeigh[i];
            PdVector elemNorm = this.m_elemNormals[i];
            int j = 0;
            while (j < size) {
                int elemInd;
                if (neigh.m_data[j] < i && (elemInd = neigh.m_data[j]) != -1) {
                    double dihAngle;
                    PdVector elemNorm2 = this.m_elemNormals[elemInd];
                    this.m_dihArr.m_data[counter] = dihAngle = Math.toRadians(180.0 - PdVector.angle((PdVector)elemNorm, (PdVector)elemNorm2));
                    ++counter;
                }
                ++j;
            }
            ++i;
        }
        System.out.println(" Number of edge : " + noEdge + " counter value  " + counter + " average dihedral " + this.m_dihArr.average());
    }

    public void avgDihedralVert() {
        PgElementSet geom = (PgElementSet)this.m_geom;
        int noEdge = geom.getNumEdges();
        this.m_dihArr = new PdVector(noEdge);
        this.m_dihArrVert = new PdVector(this.m_nov);
        int counter = 0;
        int i = 0;
        while (i < this.m_noe) {
            int size = this.m_elements[i].getSize();
            PiVector neigh = this.m_elemNeigh[i];
            PdVector elemNorm = this.m_elemNormals[i];
            int j = 0;
            while (j < size) {
                if (neigh.m_data[j] < i) {
                    double dihAngle;
                    int elemInd = neigh.m_data[j];
                    int b = this.m_elements[i].m_data[(j + 1) % 3];
                    int c = this.m_elements[i].m_data[(j + 2) % 3];
                    PdVector elemNorm2 = this.m_elemNormals[elemInd];
                    this.m_dihArr.m_data[counter] = dihAngle = Math.toRadians(180.0 - PdVector.angle((PdVector)elemNorm, (PdVector)elemNorm2));
                    int n = b;
                    this.m_dihArrVert.m_data[n] = this.m_dihArrVert.m_data[n] + dihAngle;
                    int n2 = c;
                    this.m_dihArrVert.m_data[n2] = this.m_dihArrVert.m_data[n2] + dihAngle;
                    ++counter;
                }
                ++j;
            }
            ++i;
        }
        PgVertexStar S = new PgVertexStar();
        PiVector elemIndices = PgVertexStar.getElementPerVertex((PgElementSet)geom);
        int k = 0;
        while (k < this.m_nov) {
            if (!geom.getVertex(k).hasTag(14)) {
                S.makeVertexStar(geom, k, elemIndices.m_data[k]);
                PiVector starVertInd = S.getLink();
                int val = starVertInd.getSize();
                int n = k;
                this.m_dihArrVert.m_data[n] = this.m_dihArrVert.m_data[n] / (double)val;
            }
            ++k;
        }
        System.out.println(" Number of edge : " + noEdge + " counter value  " + counter + " average dihedral " + this.m_dihArr.average() + " average dihedral by vertices " + this.m_dihArrVert.average());
    }

    public void avgDihVis() {
        PgElementSet geom = (PgElementSet)this.m_geom;
        PgVectorField dihAngle = new PgVectorField(1);
        dihAngle.setBasedOn(0);
        geom.addVectorField(dihAngle);
        dihAngle.setName("Dihedral Angle per Vertices");
        dihAngle.setGeometry((PgPointSet)geom);
        dihAngle.setNumVectors(this.m_nov);
        this.avgDihedralVert();
        int k = 0;
        while (k < this.m_nov) {
            dihAngle.setVector(k, this.m_dihArrVert.m_data[k]);
            ++k;
        }
        System.out.println(" Done with vectorField");
    }

    public void cotanVecField() {
        int noEdge = ((PgElementSet)this.m_geom).getNumEdges();
        ((PgElementSet)this.m_geom).makeVertexNormals();
        this.edgeCotanOperator();
        PgVectorField m_vf = new PgVectorField(1);
        ((PgPointSet)this.m_geom).addVectorField(m_vf);
        m_vf.setName(" Cotan Scalar Field ");
        m_vf.setGeometry((PgPointSet)this.m_geom);
        m_vf.setNumVectors(this.m_nov);
        int i = 0;
        while (i < this.m_nov) {
            double loc = 0.0;
            int j = 0;
            while (j < noEdge) {
                loc += this.m_edgeCotan.getEntry(j, i);
                ++j;
            }
            m_vf.setVector(i, loc);
            ++i;
        }
        this.m_geom.update((Object)this.m_geom);
    }

    public void diffTest() {
        PgElementSet geom = (PgElementSet)this.m_geom;
        PdVector[] vert = PdVector.copyNew((PdVector[])this.m_vertices);
        this.AMCF();
        PdVector diff = new PdVector(3);
        int i = 0;
        while (i < this.m_nov) {
            diff.sub(vert[i], this.m_vertices[i]);
            geom.setVertex(i, diff);
            ++i;
        }
        geom.makeElementNormals();
        geom.makeVertexNormals();
        geom.update((Object)geom);
    }

    public void circumCentre() {
        PdVector[] circumCentre = PdVector.realloc(null, (int)this.m_noe, (int)3);
        PdVector qualityFactor = new PdVector(this.m_noe);
        int i = 0;
        while (i < this.m_noe) {
            int a = this.m_elements[i].m_data[0];
            int b = this.m_elements[i].m_data[1];
            int c = this.m_elements[i].m_data[2];
            PdVector ab = PdVector.subNew((PdVector)this.m_vertices[b], (PdVector)this.m_vertices[a]);
            PdVector ac = PdVector.subNew((PdVector)this.m_vertices[c], (PdVector)this.m_vertices[a]);
            PdVector abXac = PdVector.crossNew((PdVector)ab, (PdVector)ac);
            PdVector abXacXab = PdVector.crossNew((PdVector)abXac, (PdVector)ab);
            PdVector acXabXac = PdVector.crossNew((PdVector)ac, (PdVector)abXac);
            abXacXab.multScalar(ac.sqrLength());
            acXabXac.multScalar(ab.sqrLength());
            PdVector loc = PdVector.addNew((PdVector)abXacXab, (PdVector)acXabXac);
            if (!(abXac.sqrLength() < 1.0E-16)) {
                loc.multScalar(1.0 / (2.0 * abXac.sqrLength()));
                circumCentre[i] = loc;
                PdVector bc = PdVector.subNew((PdVector)this.m_vertices[c], (PdVector)this.m_vertices[b]);
                PdVector length = new PdVector(3);
                length.m_data[0] = ab.length();
                length.m_data[1] = ac.length();
                length.m_data[2] = bc.length();
                length.sort();
                if (!(length.m_data[0] < 1.0E-16)) {
                    qualityFactor.m_data[i] = circumCentre[i].length() / length.m_data[0];
                }
            }
            ++i;
        }
        int a = qualityFactor.indexOfAbsMax();
        System.out.println(" Average and max Quality index for geometry" + a);
        PgElementSet geom = (PgElementSet)this.m_geom;
        geom.setTagElement(a, 1);
        System.out.println(" Average and max Quality index for geometry " + qualityFactor.average() + " ," + qualityFactor.max());
    }

    public void L0_optimization(PdVector[] vertices) {
        long stTime = new Date().getTime();
        double lambda = 5.0E-5;
        double beta = 0.001;
        double sqrtLambda = Math.sqrt(lambda / beta);
        int numIter = 0;
        this.m_diff = PdVector.realloc(null, (int)this.m_nov, (int)3);
        while (beta < 1000.0) {
            this.laplacian(vertices);
            PdVector[] delta = PdVector.copyNew((PdVector[])this.m_laplacian);
            int zeroCounter = 0;
            int i = 0;
            while (i < this.m_nov) {
                if (!(this.m_magLap.m_data[i] > sqrtLambda)) {
                    delta[i].setConstant(0.0);
                    ++zeroCounter;
                }
                ++i;
            }
            System.out.println(" Number of zero component is " + zeroCounter + " in iteration number " + numIter);
            PdVector[] b = PdVector.realloc(null, (int)this.m_nov, (int)3);
            int i2 = 0;
            while (i2 < this.m_nov) {
                b[i2].blendBase(vertices[i2], beta, delta[i2]);
                ++i2;
            }
            i2 = 0;
            while (i2 < this.m_nov) {
                this.m_diff[i2].blendBase(b[i2], beta, this.m_laplacian[i2]);
                ++i2;
            }
            beta *= 2.0;
            ++numIter;
        }
        ((PgElementSet)this.m_geom).makeElementNormals();
        long enTime = new Date().getTime();
        System.out.println(" Time taken during Error optimization : " + (enTime - stTime) / 1000L);
    }

    public void L0_Smoothing() {
        long stTime = new Date().getTime();
        PgElementSet geom = (PgElementSet)this.m_geom;
        double edgeLength = this.gridSize();
        this.avgDihedral();
        double dihAngle = this.m_dihArr.average();
        double alpha_0 = 0.1 * dihAngle;
        double lambda = 0.02 * Math.pow(edgeLength, 2.0) * dihAngle;
        double beta = 0.005;
        double speedFac = this.m_color.getValue();
        System.out.println(" Lambda: " + lambda + "beta" + beta + "alpha  " + alpha_0);
        int numIter = 0;
        this.vertexValence(geom);
        while (beta < 1000.0) {
            this.edgeCotanOperator();
            double sqrtLambda = Math.sqrt(lambda / beta);
            PdVector[] delta = PdVector.realloc(null, (int)this.m_noedge, (int)3);
            int i = 0;
            while (i < this.m_noedge) {
                int j = 0;
                while (j < this.m_nov) {
                    delta[i].m_data[0] = delta[i].m_data[0] + this.m_locMat.getEntry(i, j) * this.m_vertices[j].m_data[0];
                    delta[i].m_data[1] = delta[i].m_data[1] + this.m_locMat.getEntry(i, j) * this.m_vertices[j].m_data[1];
                    delta[i].m_data[2] = delta[i].m_data[2] + this.m_locMat.getEntry(i, j) * this.m_vertices[j].m_data[2];
                    ++j;
                }
                if (!(delta[i].length() > sqrtLambda)) {
                    delta[i].setConstant(0.0);
                }
                ++i;
            }
            PdMatrix edgeCoTran = new PdMatrix(this.m_nov, this.m_noedge);
            edgeCoTran.transpose(this.m_locMat);
            PdVector[] DtDel = PdVector.realloc(null, (int)this.m_nov, (int)3);
            int i2 = 0;
            while (i2 < this.m_nov) {
                int j = 0;
                while (j < this.m_noedge) {
                    DtDel[i2].m_data[0] = DtDel[i2].m_data[0] + edgeCoTran.getEntry(i2, j) * delta[j].m_data[0];
                    DtDel[i2].m_data[1] = DtDel[i2].m_data[1] + edgeCoTran.getEntry(i2, j) * delta[j].m_data[1];
                    DtDel[i2].m_data[2] = DtDel[i2].m_data[2] + edgeCoTran.getEntry(i2, j) * delta[j].m_data[2];
                    ++j;
                }
                DtDel[i2].multScalar(beta);
                ++i2;
            }
            PdVector[] b = PdVector.realloc(null, (int)this.m_nov, (int)3);
            int i3 = 0;
            while (i3 < this.m_nov) {
                b[i3].add(this.m_vertices[i3], DtDel[i3]);
                ++i3;
            }
            PdMatrix dTd = new PdMatrix(this.m_nov, this.m_nov);
            dTd.mult(edgeCoTran, this.m_locMat);
            dTd.multScalar(beta);
            PdMatrix regMatTran = new PdMatrix(this.m_nov, this.m_noedge);
            regMatTran.transpose(this.m_edgeReg);
            PdMatrix rTr = new PdMatrix(this.m_nov, this.m_nov);
            rTr.mult(regMatTran, this.m_edgeReg);
            rTr.multScalar(alpha_0);
            PdMatrix iden = new PdMatrix(this.m_nov, this.m_nov);
            int i4 = 0;
            while (i4 < this.m_nov) {
                int j = 0;
                while (j < this.m_nov) {
                    if (i4 == j) {
                        iden.setEntry(i4, j, 1.0);
                    }
                    ++j;
                }
                ++i4;
            }
            PdMatrix A = new PdMatrix(this.m_nov, this.m_nov);
            A.add(iden, dTd);
            A.add(rTr);
            PnSparseMatrix As = new PnSparseMatrix(this.m_nov, this.m_nov);
            int i5 = 0;
            while (i5 < this.m_nov) {
                int j = 0;
                while (j < this.m_nov) {
                    double loc = A.getEntry(i5, j);
                    if (loc != 0.0) {
                        As.setEntry(i5, j, loc);
                    }
                    ++j;
                }
                ++i5;
            }
            PdVector bx = new PdVector(this.m_nov);
            PdVector by = new PdVector(this.m_nov);
            PdVector bz = new PdVector(this.m_nov);
            int i6 = 0;
            while (i6 < this.m_nov) {
                bx.m_data[i6] = b[i6].m_data[0];
                by.m_data[i6] = b[i6].m_data[1];
                bz.m_data[i6] = b[i6].m_data[2];
                ++i6;
            }
            PdVector prx = new PdVector(this.m_nov);
            PdVector pry = new PdVector(this.m_nov);
            PdVector prz = new PdVector(this.m_nov);
            PnCSparseCholesky.solve((PnSparseMatrix)As, (PdVector)prx, (PdVector)bx);
            PnCSparseCholesky.solve((PnSparseMatrix)As, (PdVector)pry, (PdVector)by);
            PnCSparseCholesky.solve((PnSparseMatrix)As, (PdVector)prz, (PdVector)bz);
            int i7 = 0;
            while (i7 < this.m_nov) {
                geom.setVertex(i7, prx.m_data[i7], pry.m_data[i7], prz.m_data[i7]);
                ++i7;
            }
            geom.update((Object)geom);
            alpha_0 /= 2.0;
            beta *= speedFac;
            ++numIter;
        }
        geom.makeElementNormals();
        long enTime = new Date().getTime();
        System.out.println(" Total time taken during calculation : " + (enTime - stTime) / 1000L + " and number of iteration " + numIter);
    }

    public void L0_area() {
        long stTime = new Date().getTime();
        double beta = 0.001;
        double speedFac = this.m_color.getValue();
        PgElementSet geom = (PgElementSet)this.m_geom;
        this.avgDihedral();
        double edgeLength = this.gridSize();
        System.out.println("Average edge length: " + edgeLength);
        double dihAngle = this.m_dihArr.average();
        double lambda = 0.02 * Math.pow(edgeLength, 2.0) * dihAngle;
        double alpha_0 = 0.1 * dihAngle;
        int noiter = 0;
        while (beta < 1000.0) {
            this.areacoeffAMCF();
            double loc3 = 0.0;
            int i = 0;
            while (i < this.m_noedge) {
                int j = 0;
                while (j < this.m_nov) {
                    loc3 += Math.pow(this.m_edgeAreaOp.getEntry(i, j), 2.0);
                    ++j;
                }
                ++i;
            }
            System.out.println(" Edge Area op " + loc3 + " iter " + noiter);
            double sqrtLambda = Math.sqrt(lambda / beta);
            PdVector[] delta = PdVector.realloc(null, (int)this.m_noedge, (int)3);
            int i2 = 0;
            while (i2 < this.m_noedge) {
                int j = 0;
                while (j < this.m_nov) {
                    delta[i2].m_data[0] = delta[i2].m_data[0] + this.m_edgeAreaOp.getEntry(i2, j) * this.m_vertices[j].m_data[0];
                    delta[i2].m_data[1] = delta[i2].m_data[1] + this.m_edgeAreaOp.getEntry(i2, j) * this.m_vertices[j].m_data[1];
                    delta[i2].m_data[2] = delta[i2].m_data[2] + this.m_edgeAreaOp.getEntry(i2, j) * this.m_vertices[j].m_data[2];
                    ++j;
                }
                if (!(delta[i2].length() > sqrtLambda)) {
                    delta[i2].setConstant(0.0);
                }
                ++i2;
            }
            double locDel = 0.0;
            int i3 = 0;
            while (i3 < this.m_noedge) {
                locDel += delta[i3].sqrLength();
                ++i3;
            }
            System.out.println(" Delta " + locDel + " iter " + noiter);
            PdMatrix edgeCoTran = new PdMatrix(this.m_nov, this.m_noedge);
            edgeCoTran.transpose(this.m_edgeAreaOp);
            PdVector[] DtDel = PdVector.realloc(null, (int)this.m_nov, (int)3);
            int i4 = 0;
            while (i4 < this.m_nov) {
                int j = 0;
                while (j < this.m_noedge) {
                    DtDel[i4].m_data[0] = DtDel[i4].m_data[0] + edgeCoTran.getEntry(i4, j) * delta[j].m_data[0];
                    DtDel[i4].m_data[1] = DtDel[i4].m_data[1] + edgeCoTran.getEntry(i4, j) * delta[j].m_data[1];
                    DtDel[i4].m_data[2] = DtDel[i4].m_data[2] + edgeCoTran.getEntry(i4, j) * delta[j].m_data[2];
                    ++j;
                }
                DtDel[i4].multScalar(beta);
                ++i4;
            }
            double dtDel = 0.0;
            int i5 = 0;
            while (i5 < this.m_nov) {
                dtDel += DtDel[i5].sqrLength();
                ++i5;
            }
            System.out.println(" DtDel " + dtDel + " iter " + noiter);
            PdVector[] b = PdVector.realloc(null, (int)this.m_nov, (int)3);
            int i6 = 0;
            while (i6 < this.m_nov) {
                b[i6].add(this.m_vertices[i6], DtDel[i6]);
                ++i6;
            }
            double bmag = 0.0;
            int i7 = 0;
            while (i7 < this.m_nov) {
                bmag += b[i7].sqrLength();
                ++i7;
            }
            System.out.println(" b " + bmag + " iter " + noiter);
            PdMatrix dTd = new PdMatrix(this.m_nov, this.m_nov);
            dTd.mult(edgeCoTran, this.m_edgeAreaOp);
            dTd.multScalar(beta);
            double loc4 = 0.0;
            int i8 = 0;
            while (i8 < this.m_nov) {
                int j = 0;
                while (j < this.m_nov) {
                    loc4 += Math.pow(dTd.getEntry(i8, j), 2.0);
                    ++j;
                }
                ++i8;
            }
            System.out.println(" dTd " + loc4 + " iter " + noiter);
            PdMatrix regMatTran = new PdMatrix(this.m_nov, this.m_noedge);
            regMatTran.transpose(this.m_edgeReg);
            PdMatrix rTr = new PdMatrix(this.m_nov, this.m_nov);
            rTr.mult(regMatTran, this.m_edgeReg);
            rTr.multScalar(alpha_0);
            double loc5 = 0.0;
            int i9 = 0;
            while (i9 < this.m_nov) {
                int j = 0;
                while (j < this.m_nov) {
                    loc5 += Math.pow(rTr.getEntry(i9, j), 2.0);
                    ++j;
                }
                ++i9;
            }
            System.out.println(" rTr " + loc5 + " iter " + noiter);
            PdMatrix iden = new PdMatrix(this.m_nov, this.m_nov);
            int i10 = 0;
            while (i10 < this.m_nov) {
                int j = 0;
                while (j < this.m_nov) {
                    if (i10 == j) {
                        iden.setEntry(i10, j, 1.0);
                    }
                    ++j;
                }
                ++i10;
            }
            PdMatrix A = new PdMatrix(this.m_nov, this.m_nov);
            A.add(iden, dTd);
            A.add(rTr);
            double loc6 = 0.0;
            int i11 = 0;
            while (i11 < this.m_nov) {
                int j = 0;
                while (j < this.m_nov) {
                    loc6 += Math.pow(A.getEntry(i11, j), 2.0);
                    ++j;
                }
                ++i11;
            }
            System.out.println(" A " + loc6 + " iter " + noiter);
            PnSparseMatrix As = new PnSparseMatrix(this.m_nov, this.m_nov);
            int i12 = 0;
            while (i12 < this.m_nov) {
                int j = 0;
                while (j < this.m_nov) {
                    double loc = A.getEntry(i12, j);
                    if (loc != 0.0) {
                        As.setEntry(i12, j, loc);
                    }
                    ++j;
                }
                ++i12;
            }
            PdVector bx = new PdVector(this.m_nov);
            PdVector by = new PdVector(this.m_nov);
            PdVector bz = new PdVector(this.m_nov);
            int i13 = 0;
            while (i13 < this.m_nov) {
                bx.m_data[i13] = b[i13].m_data[0];
                by.m_data[i13] = b[i13].m_data[1];
                bz.m_data[i13] = b[i13].m_data[2];
                ++i13;
            }
            PdVector prx = new PdVector(this.m_nov);
            PdVector pry = new PdVector(this.m_nov);
            PdVector prz = new PdVector(this.m_nov);
            PnCSparseCholesky.solve((PnSparseMatrix)As, (PdVector)prx, (PdVector)bx);
            PnCSparseCholesky.solve((PnSparseMatrix)As, (PdVector)pry, (PdVector)by);
            PnCSparseCholesky.solve((PnSparseMatrix)As, (PdVector)prz, (PdVector)bz);
            int i14 = 0;
            while (i14 < this.m_nov) {
                geom.setVertex(i14, prx.m_data[i14], pry.m_data[i14], prz.m_data[i14]);
                ++i14;
            }
            geom.makeElementNormals();
            geom.makeVertexNormals();
            geom.update((Object)geom);
            alpha_0 /= 2.0;
            beta *= speedFac;
            ++noiter;
        }
        ((PgElementSet)this.m_geom).makeElementNormals();
        long enTime = new Date().getTime();
        System.out.println(" Total time taken during calculation : " + (enTime - stTime) / 1000L);
        System.out.println(" Total iteration during calculation : " + noiter);
    }

    public void L0_areaSparse() {
        long stTime = new Date().getTime();
        double beta = 0.001;
        double speedFac = this.m_color.getValue();
        PgElementSet geom = (PgElementSet)this.m_geom;
        this.avgDihedral();
        double edgeLength = this.gridSize();
        System.out.println("Average edge length: " + edgeLength);
        double dihAngle = this.m_dihArr.average();
        double lambda = 0.02 * Math.pow(edgeLength, 2.0) * dihAngle;
        double alpha_0 = 0.1 * dihAngle;
        int noiter = 0;
        while (beta < 1000.0) {
            this.areacoeffAMCFSparse();
            this.m_edgeAreaOpSparse.validate();
            double sqrtLambda = Math.sqrt(lambda / beta);
            PdVector[] deltaSparse = PdVector.realloc(null, (int)this.m_noedge, (int)3);
            int i = 0;
            while (i < this.m_noedge) {
                int numEntries = this.m_edgeAreaOpSparse.getNumEntries(i);
                PiVector index = this.m_edgeAreaOpSparse.getColIndices(i);
                PdVector entries = this.m_edgeAreaOpSparse.getEntries(i);
                int j = 0;
                while (j < numEntries) {
                    deltaSparse[i].m_data[0] = deltaSparse[i].m_data[0] + entries.m_data[j] * this.m_vertices[index.m_data[j]].m_data[0];
                    deltaSparse[i].m_data[1] = deltaSparse[i].m_data[1] + entries.m_data[j] * this.m_vertices[index.m_data[j]].m_data[1];
                    deltaSparse[i].m_data[2] = deltaSparse[i].m_data[2] + entries.m_data[j] * this.m_vertices[index.m_data[j]].m_data[2];
                    ++j;
                }
                if (!(deltaSparse[i].length() > sqrtLambda)) {
                    deltaSparse[i].setConstant(0.0);
                }
                ++i;
            }
            PnSparseMatrix edgeCoTranSparse = new PnSparseMatrix(this.m_nov, this.m_noedge);
            edgeCoTranSparse.transpose(this.m_edgeAreaOpSparse);
            edgeCoTranSparse.validate();
            PdVector[] DtDelSparse = PdVector.realloc(null, (int)this.m_nov, (int)3);
            int i2 = 0;
            while (i2 < this.m_nov) {
                int numEntries = edgeCoTranSparse.getNumEntries(i2);
                PiVector index = edgeCoTranSparse.getColIndices(i2);
                PdVector entries = edgeCoTranSparse.getEntries(i2);
                int j = 0;
                while (j < numEntries) {
                    DtDelSparse[i2].m_data[0] = DtDelSparse[i2].m_data[0] + entries.m_data[j] * deltaSparse[index.m_data[j]].m_data[0];
                    DtDelSparse[i2].m_data[1] = DtDelSparse[i2].m_data[1] + entries.m_data[j] * deltaSparse[index.m_data[j]].m_data[1];
                    DtDelSparse[i2].m_data[2] = DtDelSparse[i2].m_data[2] + entries.m_data[j] * deltaSparse[index.m_data[j]].m_data[2];
                    ++j;
                }
                DtDelSparse[i2].multScalar(beta);
                ++i2;
            }
            PdVector[] b = PdVector.realloc(null, (int)this.m_nov, (int)3);
            int i3 = 0;
            while (i3 < this.m_nov) {
                b[i3].add(this.m_vertices[i3], DtDelSparse[i3]);
                ++i3;
            }
            PnSparseMatrix dTdSparse = new PnSparseMatrix(this.m_nov, this.m_nov);
            PnSparseMatrix.multMatrices((PnSparseMatrix)edgeCoTranSparse, (PnSparseMatrix)this.m_edgeAreaOpSparse, (PnSparseMatrix)dTdSparse);
            dTdSparse.multScalar(beta);
            PnSparseMatrix regMatTranSparse = new PnSparseMatrix(this.m_nov, this.m_noedge);
            regMatTranSparse.transpose(this.m_edgeRegSparse);
            PnSparseMatrix rTrSparse = new PnSparseMatrix(this.m_nov, this.m_nov);
            PnSparseMatrix.multMatrices((PnSparseMatrix)regMatTranSparse, (PnSparseMatrix)this.m_edgeRegSparse, (PnSparseMatrix)rTrSparse);
            rTrSparse.multScalar(alpha_0);
            PnSparseMatrix idenSparse = new PnSparseMatrix(this.m_nov, this.m_nov);
            int i4 = 0;
            while (i4 < this.m_nov) {
                idenSparse.setEntry(i4, i4, 1.0);
                ++i4;
            }
            idenSparse.validate();
            dTdSparse.validate();
            rTrSparse.validate();
            PnSparseMatrix ASparse = new PnSparseMatrix(this.m_nov, this.m_nov);
            ASparse.add(idenSparse, dTdSparse);
            ASparse.validate();
            ASparse.add(rTrSparse);
            PdVector bx = new PdVector(this.m_nov);
            PdVector by = new PdVector(this.m_nov);
            PdVector bz = new PdVector(this.m_nov);
            int i5 = 0;
            while (i5 < this.m_nov) {
                bx.m_data[i5] = b[i5].m_data[0];
                by.m_data[i5] = b[i5].m_data[1];
                bz.m_data[i5] = b[i5].m_data[2];
                ++i5;
            }
            PdVector prx = new PdVector(this.m_nov);
            PdVector pry = new PdVector(this.m_nov);
            PdVector prz = new PdVector(this.m_nov);
            PnCSparseCholesky.solve((PnSparseMatrix)ASparse, (PdVector)prx, (PdVector)bx);
            PnCSparseCholesky.solve((PnSparseMatrix)ASparse, (PdVector)pry, (PdVector)by);
            PnCSparseCholesky.solve((PnSparseMatrix)ASparse, (PdVector)prz, (PdVector)bz);
            int i6 = 0;
            while (i6 < this.m_nov) {
                geom.setVertex(i6, prx.m_data[i6], pry.m_data[i6], prz.m_data[i6]);
                ++i6;
            }
            geom.makeElementNormals();
            geom.makeVertexNormals();
            alpha_0 /= 2.0;
            beta *= speedFac;
            ++noiter;
        }
        geom.update((Object)geom);
        ((PgElementSet)this.m_geom).makeElementNormals();
        long enTime = new Date().getTime();
        System.out.println(" Total time taken during calculation : " + (enTime - stTime));
        System.out.println(" Total iteration during calculation : " + noiter);
    }

    public int nozeroMin(PdVector vec) {
        double min = vec.min();
        int indexofMin = vec.indexOfMin();
        vec.getSize();
        if (min < 0.001) {
            vec.m_data[indexofMin] = 100000.0;
            indexofMin = vec.indexOfMin();
        }
        return indexofMin;
    }

    public void smoothCentroidStep() {
        double dihAngle = this.m_dihArr.average();
        double sw = 1.0 / (2.0 * dihAngle);
        this.m_regVector = PdVector.realloc(null, (int)this.m_nov, (int)3);
        this.m_regDir = PdVector.realloc(null, (int)this.m_nov, (int)3);
        this.m_regDir2 = PdVector.realloc(null, (int)this.m_nov, (int)3);
        PdVector[] vertices = PdVector.copyNew((PdVector[])this.m_vertices);
        PdVector[] normals = PdVector.copyNew((PdVector[])this.m_geom2.getVertexNormals());
        int v = 0;
        while (v < this.m_nov) {
            PdVector center = new PdVector(3);
            PdVector avgNormal = PdVector.copyNew((PdVector)this.m_geom2.getVertexNormal(v));
            double weight = 0.0;
            int linkSize = this.m_valence[v].getSize();
            int j = 0;
            while (j < linkSize) {
                int w = this.m_valence[v].getEntry(j);
                double locDist = this.m_geom2.getVertex(w).dist(this.m_geom2.getVertex(v));
                weight += locDist;
                center.add(locDist, this.m_geom2.getVertex(w));
                avgNormal.add(this.m_geom2.getVertexNormal(w));
                ++j;
            }
            center.multScalar(1.0 / weight);
            avgNormal.normalize();
            normals[v] = avgNormal;
            this.m_regVector[v].add(center);
            vertices[v].blend(1.0 - sw, vertices[v], sw, center);
            ++v;
        }
        int i = 0;
        while (i < this.m_nov) {
            PdVector dir = PdVector.subNew((PdVector)vertices[i], (PdVector)this.m_vertices[i]);
            this.m_regDir2[i].add(dir);
            dir.orthogonalPart(dir, normals[i]);
            this.m_regDir[i].add(dir);
            ++i;
        }
    }

    public void smoothCentroidStepForL0() {
        double dihAngle = this.m_dihArr.average();
        double sw = 1.0 / (2.0 * dihAngle);
        this.m_regVector = PdVector.realloc(null, (int)this.m_nov, (int)3);
        this.m_regDir = PdVector.realloc(null, (int)this.m_nov, (int)3);
        this.m_regDir2 = PdVector.realloc(null, (int)this.m_nov, (int)3);
        this.m_diffLength = new PdVector(this.m_nov);
        PdVector[] vertices = PdVector.copyNew((PdVector[])this.m_vertices);
        PdVector[] normals = PdVector.copyNew((PdVector[])this.m_geom2.getVertexNormals());
        int v = 0;
        while (v < this.m_nov) {
            PdVector center = new PdVector(3);
            PdVector avgNormal = PdVector.copyNew((PdVector)this.m_geom2.getVertexNormal(v));
            double weight = 0.0;
            int linkSize = this.m_valence[v].getSize();
            int j = 0;
            while (j < linkSize) {
                int w = this.m_valence[v].getEntry(j);
                double locDist = this.m_geom2.getVertex(w).dist(this.m_geom2.getVertex(v));
                weight += locDist;
                center.add(locDist, this.m_geom2.getVertex(w));
                avgNormal.add(this.m_geom2.getVertexNormal(w));
                ++j;
            }
            center.multScalar(1.0 / weight);
            avgNormal.normalize();
            normals[v] = avgNormal;
            this.m_regVector[v].add(center);
            vertices[v].blend(1.0 - sw, vertices[v], sw, center);
            ++v;
        }
        int i = 0;
        while (i < this.m_nov) {
            PdVector dir = PdVector.subNew((PdVector)vertices[i], (PdVector)this.m_vertices[i]);
            this.m_regDir2[i].add(dir);
            dir.orthogonalPart(dir, normals[i]);
            this.m_regDir[i].add(dir);
            this.m_regVector[i].add(this.m_regDir[i], this.m_regDir2[i]);
            this.m_diffLength.m_data[i] = this.m_regVector[i].length();
            ++i;
        }
    }

    public void metriclap() {
        long stTime = new Date().getTime();
        PgElementSet geom = (PgElementSet)this.m_geom;
        int noi = this.m_noItera.getValue();
        this.avgDihedral();
        this.starValence();
        double dihAngle = this.m_dihArr.average();
        this.m_sw = 4.0 / (dihAngle * dihAngle);
        int n = 0;
        while (n < noi) {
            this.smoothCentroidStepForL0();
            PdVector[] lap = PdVector.copyNew((PdVector[])this.m_regVector);
            double avgLap = this.m_diffLength.average();
            int i = 0;
            while (i < this.m_nov) {
                PdVector loc = new PdVector(3);
                if (this.m_diffLength.m_data[i] < avgLap) {
                    lap[i].setConstant(0.0);
                    loc.sub(this.m_regVector[i], lap[i]);
                    this.m_vertices[i].blendBase(this.m_vertices[i], this.m_sw, loc);
                }
                this.m_vertices[i].blendBase(this.m_vertices[i], this.m_sw, this.m_regDir2[i]);
                this.m_vertices[i].blendBase(this.m_vertices[i], this.m_sw, this.m_regDir[i]);
                ++i;
            }
            ++n;
        }
        geom.makeElementNormals();
        geom.makeVertexNormals();
        geom.update((Object)((PgElementSet)this.m_geom));
        long enTime = new Date().getTime();
        System.out.println(" Time taken during maetric laplacian smoothing in miliseconds " + (enTime - stTime));
    }

    private void highFreqInfo() {
        long stTime = new Date().getTime();
        PdVector[] box = ((PgPointSet)this.m_geom).getBounds();
        double xMin = box[0].m_data[0];
        double xMax = box[1].m_data[0];
        double yMin = box[0].m_data[1];
        double yMax = box[1].m_data[1];
        double zMin = box[0].m_data[2];
        double zMax = box[1].m_data[2];
        double gridStep = this.gridSize();
        int xLine = (int)((xMax - xMin) / gridStep + 1.0);
        int yLine = (int)((yMax - yMin) / gridStep + 1.0);
        int zLine = (int)((zMax - zMin) / gridStep + 1.0);
        int noVert = ((PgPointSet)this.m_geom).getNumVertices();
        PuAVLTree treeVert = new PuAVLTree((PuCompare_If)new boxComparator());
        int i = 0;
        while (i < noVert) {
            double x = this.m_geom.getVertex((int)i).m_data[0];
            int xIndex = (int)((x - xMin) / gridStep);
            double y = this.m_geom.getVertex((int)i).m_data[1];
            int yIndex = (int)((y - yMin) / gridStep);
            double z = this.m_geom.getVertex((int)i).m_data[2];
            int zIndex = (int)((z - zMin) / gridStep);
            PjBox boxVert = new PjBox(xIndex, yIndex, zIndex);
            Object box_Lr2 = treeVert.findNode((Object)boxVert);
            if (box_Lr2 == null) {
                treeVert.insert((Object)boxVert);
            } else {
                boxVert = (PjBox)box_Lr2;
            }
            boxVert.addVertex(0, i);
            ++i;
        }
        int HR_Vert = ((PgPointSet)this.m_geom).getNumVertices();
        this.m_highFreqComp = new PdVector(HR_Vert);
        int j = 0;
        while (j < HR_Vert) {
            PdVector vert_Ref = this.m_geom.getVertex(j);
            PdVector Vert_Norm = ((PgPointSet)this.m_geom).getVertexNormal(j);
            double x1 = this.m_geom.getVertex((int)j).m_data[0];
            int xIndex_Hr = (int)((x1 - xMin) / gridStep);
            double y1 = this.m_geom.getVertex((int)j).m_data[1];
            int yIndex_Hr = (int)((y1 - yMin) / gridStep);
            double z1 = this.m_geom.getVertex((int)j).m_data[2];
            int zIndex_Hr = (int)((z1 - zMin) / gridStep);
            int counter = 0;
            double locAdder = 0.0;
            int neighbor = 2;
            int i2 = xIndex_Hr - neighbor;
            while (i2 <= xIndex_Hr + neighbor) {
                if (i2 >= 0 || i2 < xLine) {
                    int m = yIndex_Hr - neighbor;
                    while (m <= yIndex_Hr + neighbor) {
                        if (m >= 0 || m < yLine) {
                            int n = zIndex_Hr - neighbor;
                            while (n <= zIndex_Hr + neighbor) {
                                PjBox box1;
                                Object box2;
                                if ((n >= 0 || n < zLine) && (box2 = treeVert.findNode((Object)(box1 = new PjBox(i2, m, n)))) != null) {
                                    box1 = (PjBox)box2;
                                    PiVector vertPoint = box1.m_vertIndex;
                                    int noPoint = vertPoint.getSize();
                                    int p = 0;
                                    while (p < noPoint) {
                                        int lVert = vertPoint.m_data[p];
                                        if (j != lVert) {
                                            PdVector vertLoc = this.m_geom.getVertex(lVert);
                                            PdVector d = PdVector.subNew((PdVector)vertLoc, (PdVector)vert_Ref);
                                            double h = PdVector.dot((PdVector)Vert_Norm, (PdVector)d);
                                            locAdder += h;
                                            ++counter;
                                        }
                                        ++p;
                                    }
                                }
                                ++n;
                            }
                        }
                        ++m;
                    }
                }
                ++i2;
            }
            this.m_highFreqComp.m_data[j] = counter == 0 ? 0.0 : locAdder / (double)counter;
            ++j;
        }
        long enTime = new Date().getTime();
        System.out.println(" TIME TAKEN IN HFC : " + (double)(enTime - stTime) / 1000.0);
    }

    private void highFreqCol() {
        this.highFreqInfo();
        double colorThreshold = this.m_colorThreshold.getValue();
        System.out.println(" Max value in HFC: " + colorThreshold);
        this.m_highFreqComp.multScalar(1.0 / colorThreshold);
        int noVertproc = ((PgPointSet)this.m_geom).getNumVertices();
        int j = 0;
        while (j < noVertproc) {
            int red = 0;
            int green = 0;
            double locVar = Math.abs(this.m_highFreqComp.m_data[j]);
            if (locVar <= 0.5) {
                red = (int)(255.0 * (2.0 * locVar));
                green = 255;
            } else if (locVar > 1.0) {
                red = 255;
                green = 0;
            } else {
                red = 255;
                green = (int)(255.0 * (2.0 - 2.0 * locVar));
            }
            Color col = new Color(red, green, 0);
            ((PgPointSet)this.m_geom).setVertexColor(j, col);
            ++j;
        }
        ((PgPointSet)this.m_geom).showVertexColors(true);
        ((PgElementSet)this.m_geom).showElementColors(true);
        this.m_geom.update((Object)this.m_geom);
        System.out.println(" Color field on the basis of Euclidean distance with same topology ");
    }

    public void laplacian(PdVector[] diff) {
        PgPointSet lapl = new PgPointSet(3);
        this.m_laplacian = PdVector.realloc(null, (int)this.m_nov, (int)3);
        this.m_magLap = new PdVector(this.m_nov);
        int k = 0;
        while (k < this.m_nov) {
            int valence = this.m_valence[k].getSize();
            if (valence != 0) {
                double weight = 1.0 / (double)valence;
                PdVector loc = new PdVector(3);
                int i = 0;
                while (i < valence) {
                    if (this.m_valence[k].m_data[i] != k) {
                        loc.add(diff[this.m_valence[k].m_data[i]]);
                    }
                    ++i;
                }
                loc.multScalar(weight);
                loc.sub(diff[k]);
                this.m_laplacian[k] = loc;
                this.m_magLap.m_data[k] = this.m_laplacian[k].length();
                lapl.addVertex(loc);
            }
            ++k;
        }
    }

    public void Gausslaplacian(PdVector[] diff) {
        int noVertproc = ((PgPointSet)this.m_geom).getNumVertices();
        PgPointSet lapl = new PgPointSet(3);
        this.m_gausslaplacian = PdVector.realloc(null, (int)noVertproc, (int)3);
        this.m_magLap = new PdVector(noVertproc);
        int k = 0;
        while (k < noVertproc) {
            int valence = this.m_valence[k].getSize();
            if (valence != 0) {
                PdVector loc = diff[k];
                double sigmaDist = this.m_vertStaravgDist[k].average();
                PdVector resLoc = new PdVector(3);
                double totalWeight = 0.0;
                int i = 0;
                while (i < valence) {
                    if (this.m_valence[k].m_data[i] != k) {
                        PdVector newDiff = PdVector.subNew((PdVector)loc, (PdVector)diff[this.m_valence[k].m_data[i]]);
                        double weightG = Math.exp(-newDiff.sqrLength() / (sigmaDist * sigmaDist));
                        totalWeight += weightG;
                        newDiff.multScalar(weightG);
                        resLoc.add(newDiff);
                    }
                    ++i;
                }
                resLoc.multScalar(1.0 / totalWeight);
                this.m_gausslaplacian[k] = resLoc;
                this.m_magLap.m_data[k] = this.m_laplacian[k].length();
                lapl.addVertex(loc);
            }
            ++k;
        }
    }

    public void lapMatOp(PgElementSet geom) {
        int numVert = geom.getNumVertices();
        this.m_lapOp = new PnSparseMatrix(numVert, numVert);
        PgVertexStar S = new PgVertexStar();
        PiVector elemIndices = PgVertexStar.getElementPerVertex((PgElementSet)geom);
        int k = 0;
        while (k < numVert) {
            S.makeVertexStar(geom, k, elemIndices.m_data[k]);
            PiVector starVertInd = S.getLink();
            int valence = starVertInd.getSize();
            int i = 0;
            while (i < valence) {
                int loc = starVertInd.m_data[i];
                if (loc == k) {
                    this.m_lapOp.setEntry(k, loc, 1.0);
                } else {
                    this.m_lapOp.setEntry(k, loc, -(1.0 / (double)valence));
                }
                ++i;
            }
            ++k;
        }
    }

    public void smoothLapMat() {
        double dia = ((PgElementSet)this.m_geom).getDiameter();
        int numVert = ((PgElementSet)this.m_geom).getNumVertices();
        double sw = this.m_stepWidth.getValue();
        int numIter = this.m_noItera.getValue();
        PdMatrix vertX = new PdMatrix(numVert, 1);
        PdMatrix vertY = new PdMatrix(numVert, 1);
        PdMatrix vertZ = new PdMatrix(numVert, 1);
        PdMatrix vertXR = new PdMatrix(numVert, 1);
        PdMatrix vertYR = new PdMatrix(numVert, 1);
        PdMatrix vertZR = new PdMatrix(numVert, 1);
        PnSparseMatrix I = new PnSparseMatrix(numVert, numVert);
        PdVector diag = new PdVector(numVert);
        diag.setConstant(1.0);
        I.addDiagonal(diag);
        int n = 0;
        while (n < numIter) {
            PdVector[] vert = ((PgElementSet)this.m_geom).getVertices();
            int i = 0;
            while (i < numVert) {
                vertX.setEntry(i, 0, vert[i].m_data[0]);
                vertY.setEntry(i, 0, vert[i].m_data[1]);
                vertZ.setEntry(i, 0, vert[i].m_data[2]);
                ++i;
            }
            this.lapMatOp((PgElementSet)this.m_geom);
            this.m_lapOp.multScalar(-sw);
            this.m_lapOp.validate();
            I.validate();
            I.add(this.m_lapOp);
            PdMatrix locMat = I.toPdMatrix();
            vertXR.mult(locMat, vertX);
            vertYR.mult(locMat, vertY);
            vertZR.mult(locMat, vertZ);
            int i2 = 0;
            while (i2 < numVert) {
                ((PgElementSet)this.m_geom).setVertex(i2, vertXR.getEntry(i2, 0), vertYR.getEntry(i2, 0), vertZR.getEntry(i2, 0));
                ++i2;
            }
            sw *= 0.5;
            ++n;
        }
        double newDiam = ((PgElementSet)this.m_geom).getDiameter();
        ((PgElementSet)this.m_geom).scale(dia / newDiam);
        System.out.println(" Done ");
    }

    public void regBilNormal() {
        long stTime = new Date().getTime();
        PgElementSet geom = (PgElementSet)this.m_geom;
        this.starValence();
        this.avgDihedral();
        this.m_sw = this.m_stepWidth.getValue();
        this.avgDistFace();
        int count = 0;
        int numIt = this.m_noItera.getValue();
        this.m_normalVar = this.m_normVar.getValue();
        this.bilateralNormal();
        this.vertUpdatefromElem();
        int n = 0;
        while (n < numIt) {
            PdVector[] origVert = PdVector.copyNew((PdVector[])this.m_vertices);
            this.tukeybilateralNormal();
            this.vertUpdatefromElem();
            this.smoothCentroidStep();
            int i = 0;
            while (i < this.m_nov) {
                this.m_vertices[i].blendBase(this.m_vertices[i], 1.0 / (3.0 * (double)this.m_vertFace.m_data[i]), this.m_vertUpdated[i]);
                this.m_vertices[i].blendBase(this.m_vertices[i], this.m_sw, this.m_regDir2[i]);
                this.m_vertices[i].blendBase(this.m_vertices[i], this.m_sw, this.m_regDir[i]);
                PdVector locDiffVec = new PdVector(3);
                locDiffVec.sub(origVert[i], this.m_vertices[i]);
                ++i;
            }
            this.m_sw *= 0.7;
            ++count;
            ++n;
        }
        geom.makeElementNormals();
        geom.makeVertexNormals();
        geom.update((Object)((PgElementSet)this.m_geom));
        long enTime = new Date().getTime();
        System.out.println(" Time taken during smoothing in miliseconds " + (enTime - stTime) + " And number of iterations " + count + " and average error " + this.m_angleError.average());
    }

    public void regBilNormalTukey() {
        long stTime = new Date().getTime();
        PgElementSet geom = (PgElementSet)this.m_geom;
        this.starValence();
        int numIt = this.m_noItera.getValue();
        double sw = this.m_stepWidth.getValue();
        int noVertproc = geom.getNumVertices();
        this.m_normalVar = this.m_normVar.getValue();
        PdVector[] vert = geom.getVertices();
        int n = 0;
        while (n < numIt) {
            this.smoothCentroidStep();
            this.bilateralNormalTukey();
            int i = 0;
            while (i < noVertproc) {
                vert[i].blendBase(vert[i], sw, this.m_regDir[i]);
                vert[i].blendBase(vert[i], 0.6 * sw, this.m_regDir2[i]);
                vert[i].blendBase(vert[i], 1.0 / (3.0 * (double)this.m_vertFaceTukey.m_data[i]), this.m_vertUpdatedTukey[i]);
                ++i;
            }
            sw *= 0.6;
            ++n;
        }
        geom.makeElementNormals();
        geom.makeVertexNormals();
        geom.update((Object)((PgElementSet)this.m_geom));
        long enTime = new Date().getTime();
        System.out.println(" Time taken during smoothing in miliseconds " + (enTime - stTime));
    }

    public void edgeConn(PgElementSet geom) {
        int noe = geom.getNumElements();
        this.m_edgeConn = PiVector.realloc(null, (int)noe, (int)4);
        PiVector[] element = geom.getElements();
        PiVector[] neigh = geom.getNeighbours();
        int counter = 0;
        int i = 0;
        while (i < noe) {
            PiVector elem = element[i];
            int j = 0;
            while (j < 3) {
                if (neigh[i].m_data[j] >= i) {
                    PiVector elemNei = element[neigh[i].m_data[j]];
                    int oppVert = geom.getOppVertexLocInd(i, j);
                    int a = elem.m_data[j];
                    int b = elem.m_data[(j + 1) % 3];
                    int c = elem.m_data[(j + 2) % 3];
                    int an = elemNei.m_data[oppVert];
                    this.m_edgeConn[counter].m_data[0] = a;
                    this.m_edgeConn[counter].m_data[1] = b;
                    this.m_edgeConn[counter].m_data[2] = c;
                    this.m_edgeConn[counter].m_data[3] = an;
                }
                ++j;
            }
            ++i;
        }
    }

    public void flipModification() {
        PgElementSet geom = (PgElementSet)this.m_geom;
        int nov = geom.getNumVertices();
        int noe = geom.getNumElements();
        double gaussThre = this.m_featureDetect.getValue();
        this.m_gaussDiff = new PdVector(nov);
        System.out.println(" Number of Element before Flip " + noe);
        PdVector gaussVec = new PdVector(nov);
        PdVector gaussVec2 = new PdVector(nov);
        PwCurvature.getGaussCurvature((PgElementSet)geom, (PdVector)gaussVec);
        PgElementSet geom2 = (PgElementSet)this.m_geom.clone();
        this.m_display.addGeometry((PgGeometryIf)geom2);
        this.fitDisplays();
        geom2.flipEdges();
        PwCurvature.getGaussCurvature((PgElementSet)geom2, (PdVector)gaussVec2);
        int n = 0;
        while (n < nov) {
            this.m_gaussDiff.m_data[n] = Math.abs(gaussVec.m_data[n] - gaussVec2.m_data[n]);
            ++n;
        }
        PiVector[] element = geom2.getElements();
        PiVector[] neigh = geom2.getNeighbours();
        int i = 0;
        while (i < noe) {
            PiVector elem = element[i];
            int j = 0;
            while (j < 3) {
                if (neigh[i].m_data[j] >= i) {
                    double loc;
                    PiVector elemNei = element[neigh[i].m_data[j]];
                    int oppVert = geom2.getOppVertexLocInd(i, j);
                    int a = elem.m_data[j];
                    int b = elem.m_data[(j + 1) % 3];
                    int c = elem.m_data[(j + 2) % 3];
                    int an = elemNei.m_data[oppVert];
                    double gaussDiffa = this.m_gaussDiff.m_data[a];
                    double gaussDiffb = this.m_gaussDiff.m_data[b];
                    double gaussDiffc = this.m_gaussDiff.m_data[c];
                    double gaussDiffan = this.m_gaussDiff.m_data[an];
                    if (gaussDiffa > gaussThre) {
                        geom2.setTagVertex(a, 1);
                    }
                    if (gaussDiffb > 1.2 * gaussThre) {
                        geom2.setTagVertex(b, 1);
                    }
                    if (gaussDiffc > 1.2 * gaussThre) {
                        geom2.setTagVertex(c, 1);
                    }
                    if (gaussDiffan > 1.2 * gaussThre) {
                        geom2.setTagVertex(an, 1);
                    }
                    if ((loc = (gaussDiffa + gaussDiffb + gaussDiffc + gaussDiffan) / 4.0) > 1.2 * gaussThre) {
                        geom2.setTagElement(neigh[i].m_data[j], 1);
                        geom2.setTagElement(i, 1);
                    }
                }
                ++j;
            }
            ++i;
        }
        geom2.update((Object)geom2);
        System.out.println(" Flipped elements are " + geom2.getNeighbour(5046));
        boolean[] flipTag = new boolean[noe];
        int i2 = 0;
        while (i2 < noe) {
            if (geom2.getElement(i2).hasTag(1) && !flipTag[i2]) {
                PiVector elemSelected = geom2.getElement(i2);
                if (geom2.hasTagVertex(elemSelected.m_data[0], 1) && geom2.hasTagVertex(elemSelected.m_data[1], 1) && geom2.hasTagVertex(elemSelected.m_data[2], 1)) {
                    PiVector neighElem = geom2.getNeighbour(i2);
                    int size = neighElem.getSize();
                    int j = 0;
                    while (j < size) {
                        if (geom2.getElement(neighElem.m_data[j]).hasTag(1) && !flipTag[neighElem.m_data[j]]) {
                            PiVector neighElement = geom2.getElement(neighElem.m_data[j]);
                            if (geom2.hasTagVertex(neighElement.m_data[0], 1) && geom2.hasTagVertex(neighElement.m_data[1], 1) && geom2.hasTagVertex(neighElement.m_data[2], 1)) {
                                flipTag[neighElem.m_data[j]] = true;
                                flipTag[i2] = true;
                                geom2.clearTagElement(i2, 1);
                                geom2.clearTagElement(j, 1);
                                PwCleanMesh.flipEdge((PgElementSet)geom2, (int)i2, (int)j);
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i2;
        }
        geom2.update((Object)geom2);
        PwCurvature.getGaussCurvature((PgElementSet)geom2, (PdVector)gaussVec);
        System.out.println(" Average of the absolute difference " + this.m_gaussDiff.average());
    }

    public void diffCoSmooth() {
        this.starValence();
        PgElementSet geom = (PgElementSet)this.m_geom;
        PdVector[] vert = geom.getVertices();
        this.laplacian(vert);
        double sw = this.m_stepWidth.getValue();
        int nov = geom.getNumVertices();
        int noe = geom.getNumElements();
        PdVector[] bD = PdVector.realloc(null, (int)(nov + noe), (int)3);
        PnSparseMatrix bDx = new PnSparseMatrix(nov + noe, 1);
        PnSparseMatrix bDy = new PnSparseMatrix(nov + noe, 1);
        PnSparseMatrix bDz = new PnSparseMatrix(nov + noe, 1);
        PnSparseMatrix A = new PnSparseMatrix(nov + noe, nov);
        int i = 0;
        while (i < nov) {
            int valence = this.m_valence[i].getSize();
            PdVector loc = new PdVector(3);
            int j = 0;
            while (j < valence) {
                if (this.m_valence[i].m_data[j] == i) {
                    A.setEntry(i, this.m_valence[i].m_data[j], 1.0);
                } else {
                    loc.add(this.m_laplacian[this.m_valence[i].m_data[j]]);
                    A.setEntry(i, this.m_valence[i].m_data[j], -(1.0 / (double)valence));
                }
                ++j;
            }
            loc.add(this.m_laplacian[i]);
            loc.multScalar(1.0 / (double)(valence + 1));
            bD[i] = loc;
            bDx.setEntry(i, 0, loc.m_data[0]);
            bDy.setEntry(i, 0, loc.m_data[1]);
            bDz.setEntry(i, 0, loc.m_data[2]);
            ++i;
        }
        i = 0;
        while (i < noe) {
            PiVector elemIndices = geom.getElement(i);
            int j = 0;
            while (j < 3) {
                A.setEntry(nov + i, elemIndices.m_data[j], 0.3333333333333333);
                bD[nov + i].add(vert[elemIndices.m_data[j]]);
                ++j;
            }
            bD[nov + i].multScalar(0.3333333333333333);
            bDx.setEntry(nov + i, 0, bD[nov + i].m_data[0]);
            bDy.setEntry(nov + i, 0, bD[nov + i].m_data[1]);
            bDz.setEntry(nov + i, 0, bD[nov + i].m_data[2]);
            ++i;
        }
        i = 0;
        while (i < nov) {
            vert[i].blendBase(vert[i], sw, bD[i]);
            ++i;
        }
        geom.update((Object)geom);
        geom.makeElementNormals();
        geom.makeVertexNormals();
    }

    public void meanDiffSmooth() {
        this.starValence();
        PgElementSet geom = (PgElementSet)this.m_geom;
        PdVector[] vert = geom.getVertices();
        this.laplacian(vert);
        double sw = this.m_stepWidth.getValue();
        int nov = geom.getNumVertices();
        PdVector[] bD = PdVector.realloc(null, (int)nov, (int)3);
        int i = 0;
        while (i < nov) {
            int valence = this.m_valence[i].getSize();
            PdVector loc = new PdVector(3);
            int j = 0;
            while (j < valence) {
                if (this.m_valence[i].m_data[j] != i) {
                    loc.add(this.m_laplacian[this.m_valence[i].m_data[j]]);
                }
                ++j;
            }
            loc.multScalar(1.0 / (double)valence);
            bD[i] = loc;
            ++i;
        }
        i = 0;
        while (i < nov) {
            vert[i].blendBase(vert[i], sw, bD[i]);
            ++i;
        }
        geom.update((Object)geom);
        geom.makeElementNormals();
        geom.makeVertexNormals();
    }

    public void flipMod2() {
        long currentTime = new Date().getTime();
        PgElementSet geom = (PgElementSet)this.m_geom;
        int nov = geom.getNumVertices();
        int noe = geom.getNumElements();
        double gaussThre = this.m_featureDetect.getValue();
        PdVector gaussVec = new PdVector(nov);
        PwCurvature.getGaussCurvature((PgElementSet)geom, (PdVector)gaussVec);
        PgElementSet geom2 = (PgElementSet)this.m_geom.clone();
        this.m_display.addGeometry((PgGeometryIf)geom2);
        this.fitDisplays();
        PiVector[] element = geom2.getElements();
        PiVector[] neigh = geom2.getNeighbours();
        geom2.makeElementNormals();
        geom2.makeNeighbour();
        int i = 0;
        while (i < noe) {
            PiVector elem = element[i];
            int j = 0;
            while (j < 3) {
                if (neigh[i].m_data[j] >= i) {
                    double angle;
                    PiVector elemNei = element[neigh[i].m_data[j]];
                    int neighIndex = neigh[i].m_data[j];
                    int oppVert = geom2.getOppVertexLocInd(i, j);
                    int a = elem.m_data[j];
                    int b = elem.m_data[(j + 1) % 3];
                    int c = elem.m_data[(j + 2) % 3];
                    int an = elemNei.m_data[oppVert];
                    double gaussEdge = 0.25 * (Math.pow(gaussVec.m_data[a], 2.0) + Math.pow(gaussVec.m_data[b], 2.0) + Math.pow(gaussVec.m_data[c], 2.0) + Math.pow(gaussVec.m_data[an], 2.0));
                    PwCleanMesh.flipEdge((PgElementSet)geom2, (int)i, (int)j);
                    double gVerta = PwCurvature.getGaussCurvature((PgElementSet)geom2, (int)a, (int)-1);
                    double gVertb = PwCurvature.getGaussCurvature((PgElementSet)geom2, (int)b, (int)-1);
                    double gVertc = PwCurvature.getGaussCurvature((PgElementSet)geom2, (int)c, (int)-1);
                    double gVertan = PwCurvature.getGaussCurvature((PgElementSet)geom2, (int)an, (int)-1);
                    double gEdgeFlip = 0.25 * (Math.pow(gVerta, 2.0) + Math.pow(gVertb, 2.0) + Math.pow(gVertc, 2.0) + Math.pow(gVertan, 2.0));
                    int k = 0;
                    while (k < 11) {
                        int locInd = neigh[i].getIndexOf(neighIndex);
                        PwCleanMesh.flipEdge((PgElementSet)geom2, (int)i, (int)locInd);
                        ++k;
                    }
                    if (Math.abs(gEdgeFlip - gaussEdge) > gaussThre && gEdgeFlip < gaussEdge && Math.abs(angle = PdVector.dot((PdVector)geom2.getElementNormal(i), (PdVector)geom2.getElementNormal(neighIndex))) > 0.25) {
                        geom2.setTagElement(i, 1);
                        geom2.setTagElement(neighIndex, 1);
                    }
                }
                ++j;
            }
            ++i;
        }
        geom2.makeElementNormals();
        geom2.makeVertexNormals();
        geom2.update((Object)geom2);
        i = 0;
        while (i < noe) {
            if (geom2.hasTagElement(i, 1)) {
                PiVector selNeigh = geom2.getNeighbour(i);
                int selNeighSize = selNeigh.getSize();
                int j = 0;
                while (j < selNeighSize) {
                    int elemInd = selNeigh.m_data[j];
                    if (geom2.hasTagElement(elemInd, 1)) {
                        System.out.println(" Selected elements  " + i + " and " + elemInd);
                        PwCleanMesh.flipEdge((PgElementSet)geom2, (int)i, (int)j);
                        geom2.clearTagElement(i, 1);
                        geom2.clearTagElement(elemInd, 1);
                    }
                    ++j;
                }
            }
            ++i;
        }
        geom2.update((Object)geom2);
        long endTime = new Date().getTime();
        System.out.println(" Time taken  " + (endTime - currentTime));
    }

    public void smoothLap() {
        long stTime = new Date().getTime();
        this.starValence();
        int numIt = this.m_noItera.getValue();
        double sw = this.m_stepWidth.getValue();
        double sw2 = this.m_stepWidth2.getValue();
        this.charCurv = this.m_featureDetect.getValue();
        int n = 0;
        while (n < numIt) {
            PdVector[] origVert = PdVector.copyNew((PdVector[])((PgElementSet)this.m_geom).getVertices());
            this.laplacian(this.m_vertices);
            this.coeffAMCF();
            this.areaWeight();
            int i = 0;
            while (i < this.m_nov) {
                this.m_vertices[i].blendBase(this.m_vertices[i], sw, this.m_laplacian[i]);
                this.m_vertices[i].blendBase(this.m_vertices[i], sw2, this.m_vertCoeff[i]);
                ++i;
            }
            PdVector[] diff = PdVector.realloc(null, (int)this.m_nov, (int)3);
            int i2 = 0;
            while (i2 < this.m_nov) {
                diff[i2].sub(origVert[i2], this.m_vertices[i2]);
                ++i2;
            }
            PdVector[] avgDiff = PdVector.realloc(null, (int)this.m_nov, (int)3);
            int i3 = 0;
            while (i3 < this.m_nov) {
                avgDiff[i3].setConstant(0.0);
                int starVal = this.m_valence[i3].getSize();
                int j = 0;
                while (j < starVal) {
                    avgDiff[i3].add(diff[this.m_valence[i3].m_data[j]]);
                    ++j;
                }
                avgDiff[i3].multScalar(1.0 / (double)starVal);
                diff[i3].blendBase(diff[i3], -1.0, avgDiff[i3]);
                ++i3;
            }
            i3 = 0;
            while (i3 < this.m_nov) {
                if (sw2 < 0.82) {
                    this.m_vertices[i3].blendBase(this.m_vertices[i3], sw2, diff[i3]);
                } else {
                    this.m_vertices[i3].blendBase(this.m_vertices[i3], 0.98, diff[i3]);
                }
                ++i3;
            }
            sw *= 0.5;
            sw2 *= 1.01;
            ++n;
        }
        ((PgElementSet)this.m_geom).makeElementNormals();
        ((PgElementSet)this.m_geom).makeVertexNormals();
        ((PgElementSet)this.m_geom).update((Object)((PgElementSet)this.m_geom));
        long enTime = new Date().getTime();
        System.out.println(" Time taken during smoothing in miliseconds " + (enTime - stTime));
    }

    public void smoothLapDiff() {
        int noVertproc = ((PgPointSet)this.m_geom).getNumVertices();
        PdVector[] vertGeom = ((PgElementSet)this.m_geom).getVertices();
        double lambda = this.m_featureDetect.getValue();
        int noiter = this.m_noItera.getValue();
        this.m_stepWidth2.getValue();
        int n = 0;
        while (n < noiter) {
            PdVector[] origVert = PdVector.copyNew((PdVector[])((PgElementSet)this.m_geom).getVertices());
            PdVector[] diffLap = PdVector.realloc(null, (int)noVertproc, (int)3);
            this.smoothLap();
            int i = 0;
            while (i < noVertproc) {
                diffLap[i].sub(origVert[i], this.m_geom.getVertex(i));
                ++i;
            }
            this.laplacian(diffLap);
            double beta = 0.001;
            PdVector[] diffLapCopy = PdVector.copyNew((PdVector[])diffLap);
            int counter = 0;
            int i2 = 0;
            while (i2 < noVertproc) {
                if (this.m_magLap.m_data[i2] < lambda / beta) {
                    diffLapCopy[i2].setConstant(0.0);
                    ++counter;
                }
                ++i2;
            }
            PdVector[] diffLoc = PdVector.realloc(null, (int)noVertproc, (int)3);
            int i3 = 0;
            while (i3 < noVertproc) {
                diffLoc[i3].sub(diffLap[i3], diffLapCopy[i3]);
                ++i3;
            }
            System.out.println(" Number of zero component " + counter);
            i3 = 0;
            while (i3 < noVertproc) {
                vertGeom[i3].blendBase(vertGeom[i3], beta, diffLoc[i3]);
                ++i3;
            }
            beta *= 1.4;
            ++n;
        }
        System.out.println(" Laplacian with modification done ");
    }

    public void colorLap() {
        PdVector[] vert = ((PgPointSet)this.m_geom).getVertices();
        this.laplacian(vert);
        double colorThreshold = this.m_color.getValue();
        this.m_magLap.multScalar(1.0 / colorThreshold);
        int noVertproc = ((PgPointSet)this.m_geom).getNumVertices();
        int j = 0;
        while (j < noVertproc) {
            int red = 0;
            int green = 0;
            double locVar = Math.abs(this.m_magLap.m_data[j]);
            if (locVar <= 0.5) {
                red = (int)(255.0 * (2.0 * locVar));
                green = 255;
            } else if (locVar > 1.0) {
                red = 255;
                green = 0;
            } else {
                red = 255;
                green = (int)(255.0 * (2.0 - 2.0 * locVar));
            }
            Color col = new Color(red, green, 0);
            ((PgPointSet)this.m_geom).setVertexColor(j, col);
            ++j;
        }
        ((PgPointSet)this.m_geom).showVertexColors(true);
        ((PgElementSet)this.m_geom).showElementColors(true);
        this.m_geom.update((Object)this.m_geom);
        System.out.println(" Color field on the basis of Lapalacian ");
    }

    private void areaWeight() {
        PgVertexStar S = new PgVertexStar();
        this.m_areaWeight = new PdVector(this.m_nov);
        int k = 0;
        while (k < this.m_nov) {
            S.makeVertexStar((PgElementSet)this.m_geom, k, this.m_elemperVert.m_data[k]);
            PiVector Neigh_Ind = S.getElement();
            PdVector Neigh_Area = new PdVector(Neigh_Ind.getSize());
            int size = Neigh_Ind.getSize();
            int kn = 0;
            while (kn < size) {
                Neigh_Area.m_data[kn] = ((PgElementSet)this.m_geom).getAreaOfElement(Neigh_Ind.m_data[kn]);
                ++kn;
            }
            this.m_areaWeight.m_data[k] = Neigh_Area.average() < 3.0E-10 ? 0.001 : Neigh_Area.average();
            ++k;
        }
    }

    public void feature() {
        PgElementSet.triangulate((PgElementSet)((PgElementSet)this.m_geom));
        int vertNumb = ((PgPointSet)this.m_geom).getNumVertices();
        PdVector gValue = new PdVector(vertNumb);
        PwCurvature.getGaussCurvature((PgElementSet)((PgElementSet)this.m_geom), (PdVector)gValue);
        double colorThreshold = this.m_colorThreshold.getValue();
        double loc = 0.0;
        int i = 0;
        while (i < vertNumb) {
            loc += Math.abs(gValue.m_data[i]);
            ++i;
        }
        System.out.println(" Avg value in gauss: " + (loc /= (double)vertNumb));
        System.out.println(" Max value in gauss: " + gValue.maxAbs());
        gValue.multScalar(1.0 / colorThreshold);
        int noVertproc = ((PgPointSet)this.m_geom).getNumVertices();
        int j = 0;
        while (j < noVertproc) {
            int red = 0;
            int green = 0;
            double locVar = Math.abs(gValue.m_data[j]);
            if (locVar <= 0.5) {
                red = (int)(255.0 * (2.0 * locVar));
                green = 255;
            } else if (locVar > 1.0) {
                red = 255;
                green = 0;
            } else {
                red = 255;
                green = (int)(255.0 * (2.0 - 2.0 * locVar));
            }
            Color col = new Color(red, green, 0);
            ((PgPointSet)this.m_geom).setVertexColor(j, col);
            ++j;
        }
        ((PgPointSet)this.m_geom).showVertexColors(true);
        ((PgElementSet)this.m_geom).showElementColors(true);
        this.m_geom.update((Object)this.m_geom);
        System.out.println(" Color field on the basis of Gaussian curvature ");
    }

    public void featurePrinc() {
        PgElementSet.triangulate((PgElementSet)((PgElementSet)this.m_geom));
        int vertNumb = ((PgPointSet)this.m_geom).getNumVertices();
        PdVector[] pcValue = PdVector.realloc(null, (int)2, (int)vertNumb);
        PwCurvature.getPrincipalCurvatures((PgElementSet)((PgElementSet)this.m_geom), null, (PdVector[])pcValue, null);
        System.out.println(" Max value in principle curvature: " + pcValue[0].max());
        double colorThreshold = this.m_colorThreshold.getValue();
        pcValue[0].multScalar(1.0 / colorThreshold);
        int noVertproc = ((PgPointSet)this.m_geom).getNumVertices();
        int j = 0;
        while (j < noVertproc) {
            int red = 0;
            int green = 0;
            double locVar = Math.abs(pcValue[0].m_data[j]);
            if (locVar <= 0.5) {
                red = (int)(255.0 * (2.0 * locVar));
                green = 255;
            } else if (locVar > 1.0) {
                red = 255;
                green = 0;
            } else {
                red = 255;
                green = (int)(255.0 * (2.0 - 2.0 * locVar));
            }
            Color col = new Color(red, green, 0);
            ((PgPointSet)this.m_geom).setVertexColor(j, col);
            ++j;
        }
        ((PgPointSet)this.m_geom).showVertexColors(true);
        ((PgElementSet)this.m_geom).showElementColors(true);
        this.m_geom.update((Object)this.m_geom);
        System.out.println(" Color field on the basis of Max Principle Curvature");
    }

    public boolean update(Object event) {
        if (event == this.m_gaussVar) {
            System.out.println("Current Value of Gaussian Variance: " + this.m_gaussVar.getValue());
            return true;
        }
        if (event == this.m_colorThreshold) {
            System.out.println("Current Value of color threshold: " + this.m_colorThreshold.getValue());
            return true;
        }
        if (event == this.m_featureDetect) {
            System.out.println("Current Value of feature threshold: " + this.m_featureDetect.getValue());
            return true;
        }
        if (event == this.m_stepWidth) {
            System.out.println("Current Step size: " + this.m_stepWidth.getValue());
            return true;
        }
        if (event == this.m_color) {
            System.out.println("Speed Factor: " + this.m_color.getValue());
            return true;
        }
        if (event == this.m_noItera) {
            System.out.println("Number of Iteration: " + this.m_noItera.getValue());
            return true;
        }
        if (event == this.m_stepWidth2) {
            System.out.println("Step width 2: " + this.m_stepWidth2.getValue());
            return true;
        }
        if (event == this.m_normVar) {
            System.out.println("Normal variation: " + this.m_normVar.getValue());
            return true;
        }
        return super.update(event);
    }
}

