/*
 * Decompiled with CFR 0.152.
 */
package dev.denoising.PointSetProc;

import dev.util.kdtree.PuKdTree;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygon;
import jv.geom.PgVectorField;
import jv.loader.PjImportModel;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvViewerIf;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgVertexStar;
import jvx.numeric.PnJacobi;
import jvx.util.PuQueue;

public class PjPointSetProc
extends PjProject
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static String m_defFileName = "20.obj";
    protected String m_fileName;
    protected PjImportModel m_import;
    protected PgElementSet m_refGrid = new PgElementSet(3);
    protected PuDouble m_dampingFactor;
    protected PuInteger m_numIteration;
    protected PuDouble m_multiPurpose;
    protected PiVector[] m_elemNeigh;
    protected PdVector[] m_vertices;
    protected PiVector m_elemperVert;
    protected int m_nov;
    protected PgElementSet m_geomExp;
    protected PgVertexStar m_S;
    protected PuDouble m_threshold;
    PdVector[] m_edgeNormNoisy;
    PgPointSet m_pointSet2;
    PdMatrix[] m_avg2Dcovar;
    PdVector[] m_upDatedNorm;
    PdMatrix m_covMatVec;
    double m_edge = 0.0;
    int[] m_vertStatus2;
    int[] m_vertStatuscorner;
    int[] m_vertStatus3;
    PdVector m_edgeDist;
    double m_avgEdgeLen;
    PdVector[] m_origVertPosition;
    PdVector[] m_updatedVertNormal = PdVector.realloc(null, (int)this.m_nov, (int)3);
    PdVector[] m_laplacian;
    PdVector m_avgLap;
    PdVector[] m_diAniLap;
    PiVector[] m_valence;
    PiVector[] m_valElem;
    PdVector[] m_vertStaravgDist;
    PiVector m_valNum;
    int[] m_vertStatus;

    public PjPointSetProc() {
        this(String.valueOf(PsConfig.getCodeBase()) + m_defFileName);
    }

    public PjPointSetProc(String fileName) {
        super(fileName);
        if (fileName == null) {
            fileName = "Unknown file name";
        }
        this.m_fileName = fileName;
        this.m_import = new PjImportModel();
        this.m_import.setTypeOfInfoPanel(1);
        this.m_import.setFileName(fileName);
        this.m_import.addActionListener((ActionListener)this);
        if (this.getClass() == PjPointSetProc.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_dampingFactor = new PuDouble("Damping Factor");
        this.m_dampingFactor.addUpdateListener((PsUpdateIf)this);
        this.m_dampingFactor.setDefBounds(0.0, 20.0, 1.0, 1.0);
        this.m_dampingFactor.setDefValue(3.0);
        this.m_dampingFactor.init();
        this.m_numIteration = new PuInteger("Iterations");
        this.m_numIteration.addUpdateListener((PsUpdateIf)this);
        this.m_numIteration.setDefBounds(1, 500, 1, 1);
        this.m_numIteration.setDefValue(50);
        this.m_numIteration.init();
        this.m_multiPurpose = new PuDouble("Multi Purpose");
        this.m_multiPurpose.addUpdateListener((PsUpdateIf)this);
        this.m_multiPurpose.setDefBounds(0.0, 1.0, 0.05, 0.05);
        this.m_multiPurpose.setDefValue(0.95);
        this.m_multiPurpose.init();
        this.m_threshold = new PuDouble("Optimization Threshold");
        this.m_threshold.addUpdateListener((PsUpdateIf)this);
        this.m_threshold.setDefBounds(0.0, 4000.0, 0.01, 0.1);
        this.m_threshold.setDefValue(0.3);
        this.m_threshold.init();
    }

    public void start() {
        String model;
        super.start();
        PvViewerIf viewer = this.getViewer();
        if (viewer != null && (model = viewer.getParameter("model")) != null) {
            this.m_fileName = String.valueOf(PsConfig.getCodeBase()) + model;
        }
        this.m_import.load(m_defFileName);
        PgGeometryIf geom = this.m_import.getGeometry();
        this.setGeometry(geom);
        this.m_display.addGeometry(geom);
        this.m_display.update((Object)this.m_display);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.m_import) {
            PgElementSet m_anElemSet;
            PsDebug.notify((String)"(m_import): called");
            if (this.m_import.getConfirm() == 2) {
                if (this.m_import.getGeometry() instanceof PgElementSet) {
                    this.addGeometry(this.m_import.getGeometry());
                    this.fitDisplays();
                }
            } else if (this.m_import.getConfirm() == 1) {
                this.fitDisplays();
            } else if (this.m_import.getConfirm() == 0 && !this.addGeometry((PgGeometryIf)(m_anElemSet = (PgElementSet)this.m_import.getGeometry()))) {
                return;
            }
            this.fitDisplays();
        }
        this.m_geomExp = (PgElementSet)this.m_geom;
        this.m_nov = this.m_geomExp.getNumVertices();
        this.m_vertices = this.m_geomExp.getVertices();
        this.m_elemNeigh = this.m_geomExp.getNeighbours();
        PgElementSet.triangulate((PgElementSet)this.m_geomExp);
        this.m_S = new PgVertexStar();
        this.m_elemperVert = PgVertexStar.getElementPerVertex((PgElementSet)this.m_geomExp);
        System.out.println("Number of vertices in the geometry : " + this.m_nov);
    }

    public void polyGonAnalyis() {
        PgPolygon planar = new PgPolygon(2);
        planar.setNumVertices(50);
        int i = 0;
        while (i < 50) {
            planar.setVertex(i, (double)i * 0.5, 1.0);
            ++i;
        }
        planar.update((Object)planar);
        planar.setName("Smooth Polygon");
        this.addGeometry((PgGeometryIf)planar);
        this.fitDisplays();
        PdVector[] edgeNorm = PdVector.realloc(null, (int)planar.getNumEdges(), (int)2);
        PgPointSet pointSet = new PgPointSet(2);
        pointSet.setNumVertices(planar.getNumEdges());
        PdMatrix rotation = new PdMatrix(2, 2);
        rotation.m_data[0][0] = 0.0;
        rotation.m_data[0][1] = -1.0;
        rotation.m_data[1][0] = 1.0;
        rotation.m_data[1][1] = 0.0;
        int i2 = 0;
        while (i2 < 50) {
            PdVector locVec1 = planar.getVertex(i2);
            if (i2 + 1 <= 49) {
                PdVector locVec2 = planar.getVertex(i2 + 1);
                PdVector edgeVec = PdVector.subNew((PdVector)locVec2, (PdVector)locVec1);
                edgeVec.leftMultMatrix(rotation);
                edgeVec.normalize();
                PdVector virtualPoint = PdVector.addNew((PdVector)locVec2, (PdVector)locVec1);
                virtualPoint.multScalar(0.5);
                pointSet.setVertex(i2, virtualPoint);
                edgeNorm[i2] = edgeVec;
            }
            ++i2;
        }
        pointSet.setName("point set for VF");
        this.addGeometry((PgGeometryIf)pointSet);
        this.fitDisplays();
        PgVectorField edgeNormVf = new PgVectorField(2);
        edgeNormVf.setBasedOn(0);
        pointSet.addVectorField(edgeNormVf);
        edgeNormVf.setGeometry(pointSet);
        edgeNormVf.setName("Edge Normal");
        edgeNormVf.setNumVectors(planar.getNumEdges());
        edgeNormVf.setVectors(edgeNorm);
        edgeNormVf.showVectorArrows(true);
        pointSet.update((Object)pointSet);
        PgPolygon planarNoisy = (PgPolygon)planar.clone();
        int j = 0;
        while (j < 50) {
            Random r = new Random();
            planarNoisy.getVertex((int)j).m_data[1] = planarNoisy.getVertex((int)j).m_data[1] + 0.2 * r.nextGaussian();
            ++j;
        }
        planarNoisy.update((Object)planarNoisy);
        planarNoisy.setName("Noisy Polygon");
        this.addGeometry((PgGeometryIf)planarNoisy);
        this.fitDisplays();
        this.m_edgeNormNoisy = PdVector.realloc(null, (int)planar.getNumEdges(), (int)2);
        this.m_pointSet2 = new PgPointSet(2);
        this.m_pointSet2.setNumVertices(planarNoisy.getNumEdges());
        int i3 = 0;
        while (i3 < 50) {
            PdVector locVec1 = planarNoisy.getVertex(i3);
            if (i3 + 1 <= 49) {
                PdVector locVec2 = planarNoisy.getVertex(i3 + 1);
                PdVector edgeVec = PdVector.subNew((PdVector)locVec2, (PdVector)locVec1);
                edgeVec.leftMultMatrix(rotation);
                edgeVec.normalize();
                PdVector virtualPoint = PdVector.addNew((PdVector)locVec2, (PdVector)locVec1);
                virtualPoint.multScalar(0.5);
                this.m_pointSet2.setVertex(i3, virtualPoint);
                this.m_edgeNormNoisy[i3] = edgeVec;
            }
            ++i3;
        }
        this.m_pointSet2.setName("point set for VF Noisy");
        this.addGeometry((PgGeometryIf)this.m_pointSet2);
        this.fitDisplays();
        PgVectorField edgeNormVf2 = new PgVectorField(2);
        edgeNormVf2.setBasedOn(0);
        this.m_pointSet2.addVectorField(edgeNormVf2);
        edgeNormVf2.setGeometry(this.m_pointSet2);
        edgeNormVf2.setName("Edge Normal");
        edgeNormVf2.setNumVectors(planarNoisy.getNumEdges());
        edgeNormVf2.setVectors(this.m_edgeNormNoisy);
        edgeNormVf2.showVectorArrows(true);
        this.m_pointSet2.update((Object)this.m_pointSet2);
    }

    public void coVar2DAnalysis(PdVector[] noisyNorm) {
        int noEdge = noisyNorm.length;
        this.m_avg2Dcovar = PdMatrix.realloc(null, (int)noEdge, (int)2, (int)2);
        this.m_upDatedNorm = PdVector.realloc(null, (int)noEdge, (int)2);
        this.m_upDatedNorm = PdVector.copyNew((PdVector[])noisyNorm);
        int n = 0;
        while (n < 40) {
            PdMatrix[] avg2Dcovarloc = PdMatrix.realloc(null, (int)noEdge, (int)2, (int)2);
            int i = 0;
            while (i < noEdge) {
                int count = 0;
                int j = i - 2;
                while (j <= i + 2) {
                    if (j >= 0 && j < noEdge) {
                        this.coVar(this.m_upDatedNorm[j]);
                        avg2Dcovarloc[i].add(this.m_covMatVec);
                        ++count;
                    }
                    ++j;
                }
                avg2Dcovarloc[i].multScalar(1.0 / (double)count);
                ++i;
            }
            this.m_avg2Dcovar = avg2Dcovarloc;
            i = 0;
            while (i < noEdge) {
                this.m_upDatedNorm[i].leftMultMatrix(this.m_avg2Dcovar[i]);
                this.m_upDatedNorm[i].normalize();
                ++i;
            }
            ++n;
        }
    }

    public void smoothPoly() {
        this.polyGonAnalyis();
        this.coVar2DAnalysis(this.m_edgeNormNoisy);
        int noedge = this.m_upDatedNorm.length;
        PgVectorField edgeNormVfSmooth = new PgVectorField(2);
        edgeNormVfSmooth.setBasedOn(0);
        this.m_pointSet2.addVectorField(edgeNormVfSmooth);
        edgeNormVfSmooth.setGeometry(this.m_pointSet2);
        edgeNormVfSmooth.setName("Edge Normal smooth ");
        edgeNormVfSmooth.setNumVectors(noedge);
        edgeNormVfSmooth.setVectors(this.m_upDatedNorm);
        edgeNormVfSmooth.showVectorArrows(true);
        this.m_pointSet2.update((Object)this.m_pointSet2);
    }

    public void coVar(PdVector vec) {
        int size = vec.getSize();
        if (this.m_covMatVec == null) {
            this.m_covMatVec = new PdMatrix(size, size);
        }
        if (this.m_covMatVec.getNumCols() != size || this.m_covMatVec.getNumRows() != size) {
            this.m_covMatVec.setSize(size);
        }
        int k = 0;
        while (k < size) {
            int m = 0;
            while (m < size) {
                this.m_covMatVec.m_data[k][m] = vec.m_data[k] * vec.m_data[m];
                ++m;
            }
            ++k;
        }
    }

    public PdMatrix binaryOptimization(PdMatrix mat, double threshold) {
        PdVector eValue = new PdVector(3);
        PdVector[] eVector = PdVector.realloc(null, (int)3, (int)3);
        PdMatrix optMat = new PdMatrix(3, 3);
        PnJacobi.computeEigenvectors((PdMatrix)mat, (int)3, (PdVector)eValue, (PdVector[])eVector);
        int indexofmin = eValue.indexOfMin();
        int indexofmax = eValue.indexOfMax();
        eValue.m_data[indexofmin] = eValue.m_data[indexofmin] < threshold ? 0.0 : 1.0;
        eValue.m_data[indexofmax] = 1.0;
        int midIndex = 3 - indexofmax - indexofmin;
        eValue.m_data[midIndex] = eValue.m_data[midIndex] < threshold ? 0.0 : 1.0;
        int j = 0;
        while (j < 3) {
            PdMatrix local = new PdMatrix(3, 3);
            int k = 0;
            while (k < 3) {
                int m = 0;
                while (m < 3) {
                    double[] dArray = local.m_data[k];
                    int n = m;
                    dArray[n] = dArray[n] + eVector[j].m_data[k] * eVector[j].m_data[m];
                    ++m;
                }
                ++k;
            }
            local.multScalar(eValue.m_data[j]);
            optMat.add(local);
            ++j;
        }
        return optMat;
    }

    public void NVTvert() {
        this.m_geomExp.makeVertexNormals();
        PdVector[] verticesNormals = this.m_geomExp.getVertexNormals();
        PdVector featureVal = new PdVector(this.m_nov);
        int i = 0;
        while (i < this.m_nov) {
            this.m_S.makeVertexStar(this.m_geomExp, i, this.m_elemperVert.m_data[i]);
            PiVector Neigh_Ind = this.m_S.getLink();
            int ringSize = Neigh_Ind.getSize();
            PdVector centVertNorm = verticesNormals[i];
            PdMatrix covarStar = new PdMatrix(3, 3);
            this.coVar(centVertNorm);
            covarStar.add(this.m_covMatVec);
            int j = 0;
            while (j < ringSize) {
                PdVector ringNormal = verticesNormals[Neigh_Ind.m_data[j]];
                this.coVar(ringNormal);
                covarStar.add(this.m_covMatVec);
                ++j;
            }
            covarStar.multScalar(1.0 / (double)(ringSize + 1));
            PdVector eValue = new PdVector(3);
            PdVector[] eVector = PdVector.realloc(null, (int)3, (int)3);
            PnJacobi.computeEigenvectors((PdMatrix)covarStar, (int)3, (PdVector)eValue, (PdVector[])eVector);
            eValue.normalize();
            eValue.sort();
            featureVal.m_data[i] = eValue.m_data[0] + eValue.m_data[1];
            ++i;
        }
        this.vecFieldVisCons(this.m_geomExp, featureVal, "Feature");
    }

    public PdMatrix avgVertCoVar(PgElementSet geom, int index) {
        this.m_S.makeVertexStar(geom, index, this.m_elemperVert.m_data[index]);
        PiVector Neigh_Ind = this.m_S.getLink();
        int ringSize = Neigh_Ind.getSize();
        PdVector centVertNorm = geom.getVertexNormal(index);
        PdMatrix covarStar = new PdMatrix(3, 3);
        this.coVar(centVertNorm);
        covarStar.add(this.m_covMatVec);
        int j = 0;
        while (j < ringSize) {
            PdVector ringNormal = geom.getVertexNormal(Neigh_Ind.m_data[j]);
            this.coVar(ringNormal);
            covarStar.add(this.m_covMatVec);
            ++j;
        }
        covarStar.multScalar(1.0 / (double)(ringSize + 1));
        return covarStar;
    }

    public PdVector vertNormWeightedPCA(PgElementSet geom, int index) {
        this.m_edge = PdVector.dist((PdVector)this.m_geomExp.getVertex(0), (PdVector)this.m_geomExp.getVertex(1));
        this.m_S.makeVertexStar(geom, index, this.m_elemperVert.m_data[index]);
        PiVector Neigh_Ind = this.m_S.getLink();
        int ringSize = Neigh_Ind.getSize();
        PdVector centVertPos = geom.getVertex(index);
        PdMatrix covarStar = new PdMatrix(3, 3);
        double weightSum = 0.0;
        int j = 0;
        while (j < ringSize) {
            PdVector ringVert = geom.getVertex(Neigh_Ind.m_data[j]);
            PdVector diffVec = PdVector.subNew((PdVector)ringVert, (PdVector)centVertPos);
            this.coVar(diffVec);
            double weight = Math.exp(-diffVec.sqrLength() / this.m_edge);
            this.m_covMatVec.multScalar(weight);
            covarStar.add(this.m_covMatVec);
            weightSum += weight;
            ++j;
        }
        covarStar.multScalar(1.0 / weightSum);
        PdVector eValue = new PdVector(3);
        PdVector[] eVector = PdVector.realloc(null, (int)3, (int)3);
        PnJacobi.computeEigenvectors((PdMatrix)covarStar, (int)3, (PdVector)eValue, (PdVector[])eVector);
        int indMin = eValue.indexOfMin();
        return eVector[indMin];
    }

    public PdVector vertNormWeightedPCARad(PgElementSet geom, double radius, int vertInd) {
        this.m_edge = PdVector.dist((PdVector)this.m_geomExp.getVertex(0), (PdVector)this.m_geomExp.getVertex(1));
        PdMatrix covarStar = new PdMatrix(3, 3);
        double weightSum = 0.0;
        if (this.m_vertStatus == null || this.m_vertStatus.length != this.m_nov) {
            this.m_vertStatus = new int[this.m_nov];
            int i = 0;
            while (i < this.m_nov) {
                this.m_vertStatus[i] = -1;
                ++i;
            }
        }
        PuQueue queue = new PuQueue(100);
        queue.enqueue(vertInd);
        this.m_vertStatus[vertInd] = vertInd;
        boolean[] vertInBall = new boolean[10];
        PdVector vertex = geom.getVertex(vertInd);
        geom.setTagVertex(vertInd, 1);
        int noVertInCircle = 0;
        while (!queue.isEmpty()) {
            int locVertInd = queue.extractFirst();
            this.m_S.makeVertexStar(geom, locVertInd, this.m_elemperVert.m_data[locVertInd]);
            PiVector neighvert = this.m_S.getLink();
            int nSize = neighvert.getSize();
            int i = 0;
            while (i < nSize) {
                int nInd = neighvert.m_data[i];
                if (nInd >= 0) {
                    PdVector locVert = geom.getVertex(nInd);
                    boolean bl = vertInBall[i] = vertex.sqrDist(locVert) < radius * radius;
                    if (vertInBall[i] && this.m_vertStatus[nInd] != vertInd) {
                        PdVector diffVec = PdVector.subNew((PdVector)locVert, (PdVector)vertex);
                        this.coVar(diffVec);
                        double weight = 1.0;
                        this.m_covMatVec.multScalar(weight);
                        covarStar.add(this.m_covMatVec);
                        weightSum += weight;
                        queue.enqueue(nInd);
                        ++noVertInCircle;
                        this.m_vertStatus[nInd] = vertInd;
                    }
                }
                ++i;
            }
        }
        System.out.println(" Number of vertices within the circle for vertex " + vertInd + " are: " + noVertInCircle);
        covarStar.multScalar(1.0 / weightSum);
        PdVector eValue = new PdVector(3);
        PdVector[] eVector = PdVector.realloc(null, (int)3, (int)3);
        PnJacobi.computeEigenvectors((PdMatrix)covarStar, (int)3, (PdVector)eValue, (PdVector[])eVector);
        int indMin = eValue.indexOfMin();
        return eVector[indMin];
    }

    public PdMatrix anisoCoVarRadius(PgElementSet geom, double radius, int vertInd, double angleThreshold) {
        this.m_edge = PdVector.dist((PdVector)this.m_geomExp.getVertex(0), (PdVector)this.m_geomExp.getVertex(1));
        PdMatrix covarStar = new PdMatrix(3, 3);
        double weightSum = 0.0;
        if (this.m_vertStatus == null || this.m_vertStatus.length != this.m_nov) {
            this.m_vertStatus = new int[this.m_nov];
            int i = 0;
            while (i < this.m_nov) {
                this.m_vertStatus[i] = -1;
                ++i;
            }
        }
        PuQueue queue = new PuQueue(100);
        queue.enqueue(vertInd);
        this.m_vertStatus[vertInd] = vertInd;
        boolean[] vertInBall = new boolean[100];
        PdVector vertex = geom.getVertex(vertInd);
        PdVector centerVertNormal = geom.getVertexNormal(vertInd);
        while (!queue.isEmpty()) {
            int locVertInd = queue.extractFirst();
            this.m_S.makeVertexStar(geom, locVertInd, this.m_elemperVert.m_data[locVertInd]);
            PiVector neighvert = this.m_S.getLink();
            int nSize = neighvert.getSize();
            int i = 0;
            while (i < nSize) {
                int nInd = neighvert.m_data[i];
                if (nInd >= 0) {
                    PdVector locVert = geom.getVertex(nInd);
                    PdVector neighVertNormal = geom.getVertexNormal(nInd);
                    boolean bl = vertInBall[i] = vertex.sqrDist(locVert) < radius * radius;
                    if (vertInBall[i] && this.m_vertStatus[nInd] != vertInd) {
                        double angle = PdVector.dot((PdVector)centerVertNormal, (PdVector)neighVertNormal);
                        this.coVar(neighVertNormal);
                        if (angle > angleThreshold) {
                            weightSum += 1.0;
                        } else {
                            this.m_covMatVec.multScalar(1.0E-5);
                            weightSum += 1.0E-5;
                        }
                        covarStar.add(this.m_covMatVec);
                        queue.enqueue(nInd);
                        this.m_vertStatus[nInd] = vertInd;
                    }
                }
                ++i;
            }
        }
        if (weightSum != 0.0) {
            covarStar.multScalar(1.0 / weightSum);
        }
        return covarStar;
    }

    public double averageKNNDistance() {
        PgElementSet points = this.m_geomExp;
        PuKdTree kdtree = new PuKdTree((PgPointSet)points);
        double dist = 0.0;
        int k = 6;
        int i = 0;
        while (i < points.getNumVertices()) {
            int[] nArray = kdtree.getNearestNeighbors((int)i, (int)k, (double)-1.0, (boolean)false).m_data;
            int n = kdtree.getNearestNeighbors((int)i, (int)k, (double)-1.0, (boolean)false).m_data.length;
            int n2 = 0;
            while (n2 < n) {
                int j = nArray[n2];
                dist += PdVector.dist((PdVector)points.getVertex(i), (PdVector)points.getVertex(j));
                ++n2;
            }
            ++i;
        }
        return dist /= (double)(k * points.getNumVertices());
    }

    public PdMatrix isoCoVarRadius(PgElementSet geom, double radius, int vertInd) {
        this.m_edge = PdVector.dist((PdVector)this.m_geomExp.getVertex(0), (PdVector)this.m_geomExp.getVertex(1));
        PdMatrix covarStar = new PdMatrix(3, 3);
        double weightSum = 0.0;
        if (this.m_vertStatus == null || this.m_vertStatus.length != this.m_nov) {
            this.m_vertStatus = new int[this.m_nov];
            int i = 0;
            while (i < this.m_nov) {
                this.m_vertStatus[i] = -1;
                ++i;
            }
        }
        PuQueue queue = new PuQueue(100);
        queue.enqueue(vertInd);
        this.m_vertStatus[vertInd] = vertInd;
        boolean[] vertInBall = new boolean[10];
        PdVector vertex = geom.getVertex(vertInd);
        while (!queue.isEmpty()) {
            int locVertInd = queue.extractFirst();
            this.m_S.makeVertexStar(geom, locVertInd, this.m_elemperVert.m_data[locVertInd]);
            PiVector neighvert = this.m_S.getLink();
            int nSize = neighvert.getSize();
            int i = 0;
            while (i < nSize) {
                int nInd = neighvert.m_data[i];
                if (nInd >= 0) {
                    PdVector locVert = geom.getVertex(nInd);
                    PdVector neighVertNormal = geom.getVertexNormal(nInd);
                    boolean bl = vertInBall[i] = vertex.sqrDist(locVert) < radius * radius;
                    if (vertInBall[i] && this.m_vertStatus[nInd] != vertInd) {
                        this.coVar(neighVertNormal);
                        weightSum += 1.0;
                        covarStar.add(this.m_covMatVec);
                        queue.enqueue(nInd);
                        this.m_vertStatus[nInd] = vertInd;
                    }
                }
                ++i;
            }
        }
        covarStar.multScalar(1.0 / weightSum);
        return covarStar;
    }

    public PdMatrix featureCoVar(PgElementSet geom, double radius, int vertInd, double angleThreshold) {
        this.m_edge = PdVector.dist((PdVector)this.m_geomExp.getVertex(0), (PdVector)this.m_geomExp.getVertex(1));
        PdMatrix covarStar = new PdMatrix(3, 3);
        double weightSum = 0.0;
        if (this.m_vertStatus == null || this.m_vertStatus.length != this.m_nov) {
            this.m_vertStatus = new int[this.m_nov];
            int i = 0;
            while (i < this.m_nov) {
                this.m_vertStatus[i] = -1;
                ++i;
            }
        }
        PuQueue queue = new PuQueue(100);
        queue.enqueue(vertInd);
        this.m_vertStatus[vertInd] = vertInd;
        boolean[] vertInBall = new boolean[100];
        PdVector vertex = geom.getVertex(vertInd);
        PdVector centerVertNormal = geom.getVertexNormal(vertInd);
        while (!queue.isEmpty()) {
            int locVertInd = queue.extractFirst();
            this.m_S.makeVertexStar(geom, locVertInd, this.m_elemperVert.m_data[locVertInd]);
            PiVector neighvert = this.m_S.getLink();
            int nSize = neighvert.getSize();
            int i = 0;
            while (i < nSize) {
                int nInd = neighvert.m_data[i];
                if (nInd >= 0) {
                    PdVector locVert = geom.getVertex(nInd);
                    PdVector neighVertNormal = geom.getVertexNormal(nInd);
                    PdVector diffVert = PdVector.subNew((PdVector)locVert, (PdVector)vertex);
                    boolean bl = vertInBall[i] = diffVert.sqrLength() < radius * radius;
                    if (vertInBall[i] && this.m_vertStatus[nInd] != vertInd) {
                        double angle = PdVector.dot((PdVector)centerVertNormal, (PdVector)neighVertNormal);
                        this.coVar(diffVert);
                        if (angle > angleThreshold) {
                            weightSum += 1.0;
                        } else {
                            this.m_covMatVec.multScalar(1.0E-4);
                            weightSum += 1.0E-4;
                        }
                        covarStar.add(this.m_covMatVec);
                        queue.enqueue(nInd);
                        this.m_vertStatus[nInd] = vertInd;
                    }
                }
                ++i;
            }
        }
        if (weightSum != 0.0) {
            covarStar.multScalar(1.0 / weightSum);
        }
        return covarStar;
    }

    public PdMatrix featureCoVarShifted(PgElementSet geom, double radius, int vertInd, double angleThreshold) {
        this.m_edge = PdVector.dist((PdVector)this.m_geomExp.getVertex(0), (PdVector)this.m_geomExp.getVertex(1));
        PdMatrix covarStar = new PdMatrix(3, 3);
        if (this.m_vertStatus == null || this.m_vertStatus.length != this.m_nov) {
            this.m_vertStatus = new int[this.m_nov];
            int i = 0;
            while (i < this.m_nov) {
                this.m_vertStatus[i] = -1;
                ++i;
            }
        }
        PuQueue queue = new PuQueue(100);
        queue.enqueue(vertInd);
        PuQueue featurePoints = new PuQueue(0);
        featurePoints.enqueue(vertInd);
        this.m_vertStatus[vertInd] = vertInd;
        boolean[] vertInBall = new boolean[100];
        PdVector vertex = geom.getVertex(vertInd);
        PdVector centerVertNormal = geom.getVertexNormal(vertInd);
        while (!queue.isEmpty()) {
            int locVertInd = queue.extractFirst();
            this.m_S.makeVertexStar(geom, locVertInd, this.m_elemperVert.m_data[locVertInd]);
            PiVector neighvert = this.m_S.getLink();
            int nSize = neighvert.getSize();
            int i = 0;
            while (i < nSize) {
                int nInd = neighvert.m_data[i];
                if (nInd >= 0) {
                    double angle;
                    PdVector locVert = geom.getVertex(nInd);
                    PdVector neighVertNormal = geom.getVertexNormal(nInd);
                    PdVector diffVert = PdVector.subNew((PdVector)locVert, (PdVector)vertex);
                    boolean bl = vertInBall[i] = diffVert.sqrLength() < radius * radius;
                    if (vertInBall[i] && this.m_vertStatus[nInd] != vertInd && (angle = PdVector.dot((PdVector)centerVertNormal, (PdVector)neighVertNormal)) > angleThreshold) {
                        queue.enqueue(nInd);
                        featurePoints.enqueue(nInd);
                        this.m_vertStatus[nInd] = vertInd;
                    }
                }
                ++i;
            }
        }
        int nofp = featurePoints.getNumEntries();
        PdVector[] featurePointVec = PdVector.realloc(null, (int)nofp, (int)3);
        PdVector[] featurePointNorm = PdVector.realloc(null, (int)nofp, (int)3);
        PdVector centroidFeature = new PdVector(3);
        PdVector locfeature = new PdVector(3);
        int i = 0;
        while (i < nofp) {
            int featureIndex = featurePoints.extractLast();
            locfeature = this.m_geomExp.getVertex(featureIndex);
            featurePointNorm[i] = this.m_geomExp.getVertexNormal(featureIndex);
            centroidFeature.add(locfeature);
            featurePointVec[i] = locfeature;
            ++i;
        }
        centroidFeature.multScalar(1.0 / (double)nofp);
        i = 0;
        while (i < nofp) {
            PdVector diff = PdVector.subNew((PdVector)centroidFeature, (PdVector)featurePointVec[i]);
            this.coVar(diff);
            covarStar.add(this.m_covMatVec);
            ++i;
        }
        if ((double)nofp != 0.0) {
            covarStar.multScalar(1.0 / (double)nofp);
        }
        return covarStar;
    }

    public PdVector ls2d(PgElementSet geom, double radius, int vertInd, PdVector planeNormal) {
        this.m_edge = PdVector.dist((PdVector)this.m_geomExp.getVertex(0), (PdVector)this.m_geomExp.getVertex(1));
        PdMatrix coVarSum = new PdMatrix(3, 3);
        this.coVar(planeNormal);
        coVarSum.add(this.m_covMatVec);
        PdVector coVarVecMult = new PdVector(3);
        if (this.m_vertStatus2 == null || this.m_vertStatus2.length != this.m_nov) {
            this.m_vertStatus2 = new int[this.m_nov];
            int i = 0;
            while (i < this.m_nov) {
                this.m_vertStatus2[i] = -1;
                ++i;
            }
        }
        PuQueue queue = new PuQueue(100);
        queue.enqueue(vertInd);
        this.m_vertStatus[vertInd] = vertInd;
        boolean[] vertInBall = new boolean[100];
        PdVector vertex = geom.getVertex(vertInd);
        PdVector locOutp = new PdVector(3);
        this.m_covMatVec.leftMultMatrix(locOutp, vertex);
        coVarVecMult.add(locOutp);
        while (!queue.isEmpty()) {
            int locVertInd = queue.extractFirst();
            this.m_S.makeVertexStar(geom, locVertInd, this.m_elemperVert.m_data[locVertInd]);
            PiVector neighvert = this.m_S.getLink();
            int nSize = neighvert.getSize();
            int i = 0;
            while (i < nSize) {
                int nInd = neighvert.m_data[i];
                if (nInd >= 0) {
                    PdVector locVert = geom.getVertex(nInd);
                    PdVector locOut = new PdVector(3);
                    PdVector diffVert = PdVector.subNew((PdVector)locVert, (PdVector)vertex);
                    boolean bl = vertInBall[i] = diffVert.sqrLength() < radius * radius;
                    if (vertInBall[i] && this.m_vertStatus2[nInd] != vertInd) {
                        double locProjVert = PdVector.dot((PdVector)planeNormal, (PdVector)diffVert);
                        PdVector newLocProjVec = PdVector.copyNew((PdVector)planeNormal);
                        newLocProjVec.multScalar(locProjVert);
                        PdVector projectedVert = PdVector.subNew((PdVector)locVert, (PdVector)newLocProjVec);
                        PdVector neighVertNormal = geom.getVertexNormal(nInd);
                        PdVector locVertNormVec = new PdVector(3);
                        locVertNormVec.multScalar(planeNormal, PdVector.dot((PdVector)planeNormal, (PdVector)neighVertNormal));
                        PdVector projectedNormal = PdVector.subNew((PdVector)neighVertNormal, (PdVector)locVertNormVec);
                        this.coVar(projectedNormal);
                        coVarSum.add(this.m_covMatVec);
                        this.m_covMatVec.leftMultMatrix(locOut, projectedVert);
                        coVarVecMult.add(locOut);
                        queue.enqueue(nInd);
                        this.m_vertStatus2[nInd] = vertInd;
                    }
                }
                ++i;
            }
        }
        coVarSum.invert();
        PdVector updatedVert = new PdVector(3);
        coVarSum.leftMultMatrix(updatedVert, coVarVecMult);
        return updatedVert;
    }

    public PdVector ls3d(PgElementSet geom, double radius, int vertInd) {
        this.m_edge = PdVector.dist((PdVector)this.m_geomExp.getVertex(0), (PdVector)this.m_geomExp.getVertex(1));
        PdMatrix coVarSum = new PdMatrix(3, 3);
        PdVector coVarVecMult = new PdVector(3);
        if (this.m_vertStatuscorner == null || this.m_vertStatuscorner.length != this.m_nov) {
            this.m_vertStatuscorner = new int[this.m_nov];
            int i = 0;
            while (i < this.m_nov) {
                this.m_vertStatuscorner[i] = -1;
                ++i;
            }
        }
        PuQueue queue = new PuQueue(100);
        queue.enqueue(vertInd);
        this.m_vertStatus[vertInd] = vertInd;
        boolean[] vertInBall = new boolean[100];
        PdVector vertex = geom.getVertex(vertInd);
        while (!queue.isEmpty()) {
            int locVertInd = queue.extractFirst();
            this.m_S.makeVertexStar(geom, locVertInd, this.m_elemperVert.m_data[locVertInd]);
            PiVector neighvert = this.m_S.getLink();
            int nSize = neighvert.getSize();
            int i = 0;
            while (i < nSize) {
                int nInd = neighvert.m_data[i];
                if (nInd >= 0) {
                    PdVector locVert = geom.getVertex(nInd);
                    PdVector locOut = new PdVector(3);
                    PdVector diffVert = PdVector.subNew((PdVector)vertex, (PdVector)locVert);
                    boolean bl = vertInBall[i] = diffVert.sqrLength() < radius * radius;
                    if (vertInBall[i] && this.m_vertStatuscorner[nInd] != vertInd) {
                        PdVector neighVertNormal = geom.getVertexNormal(nInd);
                        this.coVar(neighVertNormal);
                        coVarSum.add(this.m_covMatVec);
                        this.m_covMatVec.leftMultMatrix(locOut, locVert);
                        coVarVecMult.add(locOut);
                        queue.enqueue(nInd);
                        this.m_vertStatuscorner[nInd] = vertInd;
                    }
                }
                ++i;
            }
        }
        coVarSum.invert();
        PdVector updatedVert = new PdVector(3);
        coVarSum.leftMultMatrix(updatedVert, coVarVecMult);
        return updatedVert;
    }

    public PdVector updatedVertex(PgElementSet geom, double radius, int vertInd) {
        double weightSum = 0.0;
        double weightAngle = 0.0;
        if (this.m_vertStatus == null || this.m_vertStatus.length != this.m_nov) {
            this.m_vertStatus = new int[this.m_nov];
            int i = 0;
            while (i < this.m_nov) {
                this.m_vertStatus[i] = -1;
                ++i;
            }
        }
        PuQueue queue = new PuQueue(100);
        queue.enqueue(vertInd);
        this.m_vertStatus[vertInd] = vertInd;
        boolean[] vertInBall = new boolean[10];
        PdVector vertex = geom.getVertex(vertInd);
        PdVector centerVertNormal = geom.getVertexNormal(vertInd);
        while (!queue.isEmpty()) {
            int locVertInd = queue.extractFirst();
            this.m_S.makeVertexStar(geom, locVertInd, this.m_elemperVert.m_data[locVertInd]);
            PiVector neighvert = this.m_S.getLink();
            int nSize = neighvert.getSize();
            int i = 0;
            while (i < nSize) {
                int nInd = neighvert.m_data[i];
                if (nInd >= 0) {
                    PdVector locVert = geom.getVertex(nInd);
                    PdVector neighVertNormal = geom.getVertexNormal(nInd);
                    PdVector diffVert = PdVector.subNew((PdVector)locVert, (PdVector)vertex);
                    boolean bl = vertInBall[i] = diffVert.sqrLength() < radius * radius;
                    if (vertInBall[i] && this.m_vertStatus[nInd] != vertInd) {
                        double angle = PdVector.dot((PdVector)centerVertNormal, (PdVector)neighVertNormal);
                        double angleNormPlane = PdVector.dot((PdVector)centerVertNormal, (PdVector)diffVert);
                        if (angle > 0.95) {
                            weightAngle += angleNormPlane;
                            weightSum += 1.0;
                        } else {
                            weightAngle += angleNormPlane * 0.001;
                            weightSum += 0.001;
                        }
                        queue.enqueue(nInd);
                        this.m_vertStatus[nInd] = vertInd;
                    }
                }
                ++i;
            }
        }
        double weighFac = weightAngle / weightSum;
        centerVertNormal.multScalar(weighFac);
        return centerVertNormal;
    }

    public PdVector weightedUpdateVertex(PgElementSet geom, double radius, int vertInd) {
        double weightSum = 0.0;
        double weightTotal = 0.0;
        if (this.m_vertStatus3 == null || this.m_vertStatus3.length != this.m_nov) {
            this.m_vertStatus3 = new int[this.m_nov];
            int i = 0;
            while (i < this.m_nov) {
                this.m_vertStatus3[i] = -1;
                ++i;
            }
        }
        PuQueue queue = new PuQueue(100);
        queue.enqueue(vertInd);
        this.m_vertStatus3[vertInd] = vertInd;
        boolean[] vertInBall = new boolean[100];
        PdVector vertex = geom.getVertex(vertInd);
        PdVector centerVertNormal = (PdVector)geom.getVertexNormal(vertInd).clone();
        while (!queue.isEmpty()) {
            int locVertInd = queue.extractFirst();
            this.m_S.makeVertexStar(geom, locVertInd, this.m_elemperVert.m_data[locVertInd]);
            PiVector neighvert = this.m_S.getLink();
            int nSize = neighvert.getSize();
            int i = 0;
            while (i < nSize) {
                int nInd = neighvert.m_data[i];
                if (nInd >= 0) {
                    PdVector locVert = geom.getVertex(nInd);
                    PdVector diffVert = PdVector.subNew((PdVector)locVert, (PdVector)vertex);
                    boolean bl = vertInBall[i] = diffVert.sqrLength() < radius * radius;
                    if (vertInBall[i] && this.m_vertStatus3[nInd] != vertInd) {
                        PdVector neighVertNormal = geom.getVertexNormal(nInd);
                        PdVector angleDiff = PdVector.subNew((PdVector)centerVertNormal, (PdVector)neighVertNormal);
                        double angleNormPlane = PdVector.dot((PdVector)centerVertNormal, (PdVector)diffVert);
                        double weightAngle = Math.exp(-angleDiff.sqrLength() * 8.0 / (radius * radius));
                        double weightDist = Math.exp(-diffVert.sqrLength() * 4.0 / (radius * radius));
                        weightSum += angleNormPlane * weightDist * weightAngle;
                        weightTotal += weightDist * weightAngle;
                        queue.enqueue(nInd);
                        this.m_vertStatus3[nInd] = vertInd;
                    }
                }
                ++i;
            }
        }
        double weighFac = weightSum / weightTotal;
        centerVertNormal.multScalar(weighFac);
        return centerVertNormal;
    }

    public void binaryNeighTest(PgElementSet geom, int index) {
        this.m_S.makeVertexStar(geom, index, this.m_elemperVert.m_data[index]);
        PiVector Neigh_Ind = this.m_S.getLink();
        int ringSize = Neigh_Ind.getSize();
        PdVector centVertNorm = geom.getVertexNormal(index);
        this.m_geomExp.getVertex(index).setTag(1);
        int j = 0;
        while (j < ringSize) {
            PdVector ringNormal = geom.getVertexNormal(Neigh_Ind.m_data[j]);
            double angle = PdVector.dot((PdVector)centVertNorm, (PdVector)ringNormal);
            if (angle > 0.8) {
                this.m_geomExp.getVertex(Neigh_Ind.m_data[j]).setTag(1);
            }
            ++j;
        }
    }

    public PdMatrix avgVertCoVarBinaryNeigh(PgElementSet geom, int index) {
        this.m_S.makeVertexStar(geom, index, this.m_elemperVert.m_data[index]);
        PiVector Neigh_Ind = this.m_S.getLink();
        int ringSize = Neigh_Ind.getSize();
        PdVector centVertNorm = geom.getVertexNormal(index);
        PdMatrix covarStar = new PdMatrix(3, 3);
        this.coVar(centVertNorm);
        covarStar.add(this.m_covMatVec);
        int j = 0;
        while (j < ringSize) {
            PdVector ringNormal = geom.getVertexNormal(Neigh_Ind.m_data[j]);
            double angle = PdVector.dot((PdVector)centVertNorm, (PdVector)ringNormal);
            if (angle > 0.8) {
                this.coVar(ringNormal);
                covarStar.add(this.m_covMatVec);
            }
            ++j;
        }
        covarStar.multScalar(1.0 / (double)(ringSize + 1));
        return covarStar;
    }

    public void testMT() {
        ExecutorService executorService = Executors.newFixedThreadPool(20);
        int i = 0;
        while (i < 100) {
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                }
            });
            ++i;
        }
        executorService.shutdown();
        while (!executorService.isTerminated()) {
            System.out.print("");
            System.out.print("Somehow working");
        }
    }

    public void testMTGen() {
        long stTime = System.currentTimeMillis();
        int i = 0;
        while (i < 1000) {
            ++i;
        }
        long enTime = System.currentTimeMillis();
        System.out.println(" total time taken to compute the directional curvature:" + (enTime - stTime));
    }

    public void test2NVT() {
        PdVector featureVal = new PdVector(this.m_nov);
        PdVector[] upVertNormals = PdVector.realloc(null, (int)this.m_nov, (int)3);
        int i = 0;
        while (i < this.m_nov) {
            PdMatrix avgCoVar = this.avgVertCoVar(this.m_geomExp, i);
            PdVector upNormal = this.matMul(avgCoVar, this.m_geomExp.getVertexNormal(i));
            this.m_geomExp.setVertexNormal(i, upNormal);
            upVertNormals[i] = this.vertNormWeightedPCA(this.m_geomExp, i);
            PdVector eValue = new PdVector(3);
            PdVector[] eVector = PdVector.realloc(null, (int)3, (int)3);
            PnJacobi.computeEigenvectors((PdMatrix)avgCoVar, (int)3, (PdVector)eValue, (PdVector[])eVector);
            eValue.normalize();
            eValue.sort();
            featureVal.m_data[i] = eValue.m_data[0] + eValue.m_data[1];
            ++i;
        }
    }

    public void avgEdgeLength(PgElementSet geom) {
        PgElementSet.triangulate((PgElementSet)geom);
        int noedge = geom.getNumEdges();
        int noe = geom.getNumElements();
        PiVector[] elemNeigh = geom.getNeighbours();
        PiVector[] elements = geom.getElements();
        PdVector[] vertices = geom.getVertices();
        this.m_edgeDist = new PdVector(noedge);
        this.m_avgEdgeLen = 0.0;
        double Dist_Grid = 0.0;
        int Index_Grid = 0;
        int i = 0;
        while (i < noe) {
            int size = elements[i].getSize();
            int j = 0;
            while (j < size) {
                if (elemNeigh[i].m_data[j] < i) {
                    int vert1 = elements[i].m_data[(j + 1) % size];
                    int vert2 = elements[i].m_data[(j + 2) % size];
                    this.m_edgeDist.m_data[Index_Grid] = Dist_Grid = vertices[vert1].dist(vertices[vert2]);
                    ++Index_Grid;
                }
                ++j;
            }
            ++i;
        }
        this.m_avgEdgeLen = this.m_edgeDist.average();
        System.out.println(" average edge length : " + this.m_avgEdgeLen);
    }

    public void L2NormVert() {
        double refVertavg = 0.0;
        int noveref = this.m_geomExp.getNumVertices();
        int i = 0;
        while (i < noveref) {
            refVertavg += this.m_geomExp.getVertex(i).sqrLength();
            ++i;
        }
        System.out.println(" L2-Norm vertices : " + (refVertavg /= (double)noveref));
    }

    public void vertexNormalSmoothing() {
        long stTime = System.currentTimeMillis();
        this.m_geomExp.makeVertexNormals();
        this.m_updatedVertNormal = PdVector.copyNew((PdVector[])this.m_geomExp.getVertexNormals());
        PdVector[] locVertNorm = PdVector.realloc(null, (int)this.m_nov, (int)3);
        this.avgEdgeLength(this.m_geomExp);
        double threshold = this.m_threshold.getValue();
        double radius = this.m_avgEdgeLen;
        int numIt = this.m_numIteration.getValue();
        double angleT = this.m_multiPurpose.getValue();
        int it = 0;
        while (it < numIt) {
            int i = 0;
            while (i < this.m_nov) {
                PdVector locNormPos = new PdVector(3);
                PdMatrix coVar = this.anisoCoVarRadius(this.m_geomExp, 2.0 * radius, i, angleT);
                PdMatrix optMat = this.binaryOptimization(coVar, threshold);
                locNormPos = this.matMul(optMat, this.m_updatedVertNormal[i]);
                locVertNorm[i].blendBase(locNormPos, 3.0, locVertNorm[i]);
                locVertNorm[i].normalize();
                ++i;
            }
            this.m_updatedVertNormal = locVertNorm;
            this.m_geomExp.setVertexNormals(locVertNorm);
            ++it;
        }
        long entTime = System.currentTimeMillis();
        System.out.println("Total time taken in vertex normal smoothing: " + (entTime - stTime));
    }

    public void vertexUpdate() {
        long stTime = System.currentTimeMillis();
        this.avgEdgeLength(this.m_geomExp);
        double threshold = this.m_threshold.getValue();
        double radius = this.m_avgEdgeLen;
        int numIt = this.m_numIteration.getValue();
        double angleT = this.m_multiPurpose.getValue();
        Color corner = new Color(0, 200, 0);
        Color edge = new Color(255, 255, 0);
        Color planar = new Color(0, 127, 0);
        int j = 0;
        while (j < numIt) {
            int i = 0;
            while (i < this.m_nov) {
                PdMatrix coVar = this.featureCoVar(this.m_geomExp, 2.5 * radius, i, angleT);
                PdVector eValue = new PdVector(3);
                PdVector[] eVector = PdVector.realloc(null, (int)3, (int)3);
                PnJacobi.computeEigenvectors((PdMatrix)coVar, (int)3, (PdVector)eValue, (PdVector[])eVector);
                eValue.normalize();
                int indexofmax = eValue.indexOfMax();
                int indexofmin = eValue.indexOfMin();
                int midIndex = 3 - indexofmax - indexofmin;
                if (eValue.m_data[indexofmin] < threshold && eValue.m_data[midIndex] < threshold) {
                    PdVector pNormal = eVector[indexofmax];
                    PdVector shiftVert = this.ls2d(this.m_geomExp, 1.6 * radius, i, pNormal);
                    shiftVert.multScalar(-0.5);
                    this.m_geomExp.getVertex(i).add(shiftVert);
                    this.m_geomExp.setVertexColor(i, edge);
                } else if (eValue.m_data[indexofmin] < threshold && eValue.m_data[midIndex] > threshold && eValue.m_data[indexofmax] > threshold) {
                    PdVector vertPlanar = this.weightedUpdateVertex(this.m_geomExp, 1.6 * radius, i);
                    vertPlanar.multScalar(0.5);
                    this.m_geomExp.getVertex(i).add(vertPlanar);
                    this.m_geomExp.setVertexColor(i, planar);
                } else if (!(eValue.m_data[indexofmin] < threshold && eValue.m_data[midIndex] < threshold && eValue.m_data[indexofmax] < threshold)) {
                    this.m_geomExp.setVertexColor(i, corner);
                    System.out.println("corner Vertices index: " + i);
                    PdVector vertCorner = this.ls3d(this.m_geomExp, 1.6 * radius, i);
                    PdVector origDiff = PdVector.subNew((PdVector)vertCorner, (PdVector)this.m_geomExp.getVertex(i));
                    if (origDiff.sqrLength() < radius * radius / 4.0) {
                        this.m_geomExp.setVertex(i, vertCorner);
                    }
                }
                ++i;
            }
            ++j;
        }
        this.m_geomExp.update((Object)this.m_geomExp);
        long entTime = System.currentTimeMillis();
        System.out.println("Total time taken: " + (entTime - stTime));
    }

    public void featureDetection() {
        this.avgEdgeLength(this.m_geomExp);
        double threshold = this.m_threshold.getValue();
        double radius = this.m_avgEdgeLen;
        Color corner = new Color(0, 0, 0);
        Color corner2 = new Color(200, 0, 0);
        Color edge = new Color(255, 255, 0);
        Color planar = new Color(0, 127, 0);
        double angleT = this.m_multiPurpose.getValue();
        this.m_geomExp.assureVertexColors();
        this.m_geomExp.showVertexColors(true);
        int i = 0;
        while (i < this.m_nov) {
            PdMatrix coVar = this.featureCoVar(this.m_geomExp, 2.5 * radius, i, angleT);
            PdVector eValue = new PdVector(3);
            PdVector[] eVector = PdVector.realloc(null, (int)3, (int)3);
            PnJacobi.computeEigenvectors((PdMatrix)coVar, (int)3, (PdVector)eValue, (PdVector[])eVector);
            eValue.normalize();
            int indexofmax = eValue.indexOfMax();
            int indexofmin = eValue.indexOfMin();
            int midIndex = 3 - indexofmax - indexofmin;
            if (eValue.m_data[indexofmin] < threshold && eValue.m_data[midIndex] < threshold) {
                this.m_geomExp.setVertexColor(i, edge);
            } else if (eValue.m_data[indexofmin] < threshold && eValue.m_data[midIndex] > threshold && eValue.m_data[indexofmax] > threshold) {
                this.m_geomExp.setVertexColor(i, planar);
            } else if (eValue.m_data[indexofmin] < threshold && eValue.m_data[midIndex] < threshold && eValue.m_data[indexofmax] < threshold) {
                System.out.println("corner Vertices index: " + i);
                this.m_geomExp.setVertexColor(i, corner);
            } else {
                System.out.println("corner Vertices index: " + i);
                this.m_geomExp.setVertexColor(i, corner2);
            }
            ++i;
        }
        this.m_geomExp.update((Object)this.m_geomExp);
    }

    public void pointSetSmoothing() {
        int i;
        long stTime = System.currentTimeMillis();
        this.m_origVertPosition = PdVector.copyNew((PdVector[])this.m_vertices);
        this.m_geomExp.makeVertexNormals();
        this.m_updatedVertNormal = PdVector.copyNew((PdVector[])this.m_geomExp.getVertexNormals());
        PdVector[] locVertNorm = PdVector.realloc(null, (int)this.m_nov, (int)3);
        double threshold = this.m_threshold.getValue();
        double radius = this.averageKNNDistance();
        System.out.println("avg distance using KNN: " + radius);
        int numIt = this.m_numIteration.getValue();
        double angleT = this.m_multiPurpose.getValue();
        int it = 0;
        while ((double)it < 1.0 * (double)numIt) {
            i = 0;
            while (i < this.m_nov) {
                PdVector locNormPos = new PdVector(3);
                PdMatrix coVar = this.anisoCoVarRadius(this.m_geomExp, 2.5 * radius, i, angleT);
                if (coVar.m_data[0][0] + coVar.m_data[1][1] + coVar.m_data[2][2] != 0.0) {
                    PdMatrix optMat = this.binaryOptimization(coVar, threshold);
                    locNormPos = this.matMul(optMat, this.m_updatedVertNormal[i]);
                    locVertNorm[i].blendBase(locNormPos, 3.0, locVertNorm[i]);
                    locVertNorm[i].normalize();
                }
                ++i;
            }
            this.m_updatedVertNormal = locVertNorm;
            this.m_geomExp.setVertexNormals(locVertNorm);
            ++it;
        }
        int j = 0;
        while (j < numIt) {
            i = 0;
            while (i < this.m_nov) {
                PdMatrix coVar = this.featureCoVarShifted(this.m_geomExp, 2.5 * radius, i, angleT);
                if (coVar.m_data[0][0] + coVar.m_data[1][1] + coVar.m_data[2][2] != 0.0) {
                    PdVector eValue = new PdVector(3);
                    PdVector[] eVector = PdVector.realloc(null, (int)3, (int)3);
                    PnJacobi.computeEigenvectors((PdMatrix)coVar, (int)3, (PdVector)eValue, (PdVector[])eVector);
                    eValue.normalize();
                    int indexofmax = eValue.indexOfMax();
                    int indexofmin = eValue.indexOfMin();
                    int midIndex = 3 - indexofmax - indexofmin;
                    if (midIndex >= 0 && midIndex <= 2) {
                        PdVector diffVert;
                        if (eValue.m_data[indexofmin] < threshold && eValue.m_data[midIndex] < threshold && eValue.m_data[indexofmax] > threshold) {
                            PdVector pNormal = eVector[indexofmax];
                            PdVector shiftVert = this.ls2d(this.m_geomExp, 2.0 * radius, i, pNormal);
                            diffVert = PdVector.subNew((PdVector)shiftVert, (PdVector)this.m_origVertPosition[i]);
                            if (diffVert.sqrLength() < 4.0 * radius * radius) {
                                this.m_geomExp.setVertex(i, shiftVert);
                            } else {
                                PdVector vertPlanar = this.m_geomExp.getVertexNormal(i);
                                vertPlanar.multScalar(0.2 * radius);
                                this.m_geomExp.getVertex(i).add(vertPlanar);
                            }
                        } else if (eValue.m_data[indexofmin] < threshold && eValue.m_data[midIndex] > threshold && eValue.m_data[indexofmax] > threshold) {
                            PdVector vertPlanar = this.weightedUpdateVertex(this.m_geomExp, 2.5 * radius, i);
                            PdVector LocationVert = PdVector.copyNew((PdVector)this.m_geomExp.getVertex(i));
                            vertPlanar.multScalar(0.3);
                            LocationVert.add(vertPlanar);
                            diffVert = PdVector.subNew((PdVector)LocationVert, (PdVector)this.m_origVertPosition[i]);
                            if (diffVert.sqrLength() < 4.0 * radius * radius) {
                                this.m_geomExp.getVertex(i).add(vertPlanar);
                            }
                        } else {
                            System.out.println("corner Vertices index: " + i);
                            PdVector vertCorner = this.ls3d(this.m_geomExp, 2.0 * radius, i);
                            PdVector diffVert2 = PdVector.subNew((PdVector)vertCorner, (PdVector)this.m_origVertPosition[i]);
                            if (diffVert2.sqrLength() < 4.0 * radius * radius) {
                                this.m_geomExp.setVertex(i, vertCorner);
                            } else {
                                PdVector LocationVert = PdVector.copyNew((PdVector)this.m_geomExp.getVertex(i));
                                PdVector diffVertC = PdVector.subNew((PdVector)vertCorner, (PdVector)LocationVert);
                                double previousDist = diffVertC.length();
                                diffVertC.normalize();
                                diffVertC.multScalar(2.0 * radius - previousDist);
                                this.m_geomExp.getVertex(i).add(diffVertC);
                            }
                        }
                    }
                }
                ++i;
            }
            ++j;
        }
        this.m_geomExp.update((Object)this.m_geomExp);
        long entTime = System.currentTimeMillis();
        System.out.println("Total time taken: " + (entTime - stTime));
    }

    public List<String> readFile(String filename) {
        ArrayList<String> records = new ArrayList<String>();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(filename));
            while ((line = reader.readLine()) != null) {
                records.add(line);
            }
            reader.close();
            return records;
        }
        catch (Exception e) {
            System.err.format("Exception occurred trying to read '%s'.", filename);
            e.printStackTrace();
            return null;
        }
    }

    public void readxyz() {
        List<Object> records = new ArrayList();
        records = this.readFile("C:\\Users\\sunil\\Desktop\\MRPCA\\octa_dense_0-003_normal.xyz");
        int nov = records.size();
        int i = 0;
        while (i < nov) {
            String data = (String)records.get(i);
            System.out.println("data in the list: " + data);
            ++i;
        }
        System.out.println("size of the list: " + records.size());
    }

    public void colorVertexBasedOn() {
        PdVector baseNormal = this.m_geomExp.getVertexNormal(0);
        PdVector angleDiff = new PdVector(this.m_nov);
        double l2Norm = 0.0;
        int i = 0;
        while (i < this.m_nov) {
            angleDiff.m_data[i] = PdVector.dot((PdVector)baseNormal, (PdVector)this.m_geomExp.getVertexNormal(i));
            l2Norm += this.m_geomExp.getVertex(i).length();
            ++i;
        }
        this.vecFieldVisCons(this.m_geomExp, angleDiff, "angleDiff");
        System.out.println("L2-Norm: " + l2Norm / (double)this.m_nov);
    }

    public PdVector matMul(PdMatrix covMat, PdVector vertexNormal) {
        PdVector upVec = PdVector.copyNew((PdVector)vertexNormal);
        upVec.leftMultMatrix(covMat);
        upVec.normalize();
        upVec.add(3.0, vertexNormal);
        upVec.normalize();
        return upVec;
    }

    public void faceNormalCovarAnisoOpt() {
        PdVector featureVal = new PdVector(this.m_nov);
        int i = 0;
        while (i < this.m_nov) {
            PdMatrix avgCoVar = this.avgVertCoVar(this.m_geomExp, i);
            PdVector eValue = new PdVector(3);
            PdVector[] eVector = PdVector.realloc(null, (int)3, (int)3);
            PnJacobi.computeEigenvectors((PdMatrix)avgCoVar, (int)3, (PdVector)eValue, (PdVector[])eVector);
            int indexofmin = eValue.indexOfMin();
            int indexofmax = eValue.indexOfMax();
            eValue.m_data[indexofmin] = eValue.m_data[indexofmin] < 0.3 ? 0.0 : 1.0;
            eValue.m_data[indexofmax] = 1.0;
            int midIndex = 3 - indexofmax - indexofmin;
            eValue.m_data[midIndex] = eValue.m_data[midIndex] < 0.3 ? 0.0 : 1.0;
            avgCoVar.setConstant(0.0);
            int j = 0;
            while (j < 3) {
                PdMatrix local = new PdMatrix(3, 3);
                int k = 0;
                while (k < 3) {
                    int m = 0;
                    while (m < 3) {
                        double[] dArray = local.m_data[k];
                        int n = m;
                        dArray[n] = dArray[n] + eVector[j].m_data[k] * eVector[j].m_data[m];
                        ++m;
                    }
                    ++k;
                }
                local.multScalar(eValue.m_data[j]);
                avgCoVar.add(local);
                ++j;
            }
            PdVector eValue2 = new PdVector(3);
            PdVector[] eVector2 = PdVector.realloc(null, (int)3, (int)3);
            PnJacobi.computeEigenvectors((PdMatrix)avgCoVar, (int)3, (PdVector)eValue2, (PdVector[])eVector2);
            eValue2.normalize();
            eValue2.sort();
            featureVal.m_data[i] = eValue.m_data[0] + eValue.m_data[1];
            ++i;
        }
        this.vecFieldVisCons(this.m_geomExp, featureVal, "Feature Optimized");
    }

    public void vecFieldVisCons(PgElementSet geom, PdVector vec, String name) {
        PgVectorField vf = new PgVectorField(1);
        int nov = geom.getNumVertices();
        vf.setBasedOn(0);
        geom.addVectorField(vf);
        vf.setName(name);
        vf.setGeometry((PgPointSet)geom);
        vf.setNumVectors(nov);
        int k = 0;
        while (k < nov) {
            vf.setVector(k, vec.m_data[k]);
            ++k;
        }
        geom.update((Object)geom);
    }

    public void anisoCoVar() {
        this.m_geomExp.makeVertexNormals();
        this.m_updatedVertNormal = PdVector.copyNew((PdVector[])this.m_geomExp.getVertexNormals());
        double angleThreshold = this.m_multiPurpose.getValue();
        PdMatrix covarianceVert = new PdMatrix(3, 3);
        int it = 0;
        while (it < 100) {
            int k = 0;
            while (k < this.m_nov) {
                this.m_S.makeVertexStar(this.m_geomExp, k, this.m_elemperVert.m_data[k]);
                PiVector Neigh_Ind = this.m_S.getLink();
                int ringSize = Neigh_Ind.getSize();
                PdVector centerVertNormal = this.m_updatedVertNormal[k];
                double totalDistWeight = 0.0;
                int j = 0;
                while (j < ringSize) {
                    PdVector neighNormal = this.m_updatedVertNormal[Neigh_Ind.m_data[j]];
                    this.coVar(neighNormal);
                    PdMatrix locMat = this.m_covMatVec;
                    double distWeight = 1.0;
                    double angle = PdVector.dot((PdVector)centerVertNormal, (PdVector)neighNormal);
                    if (angle < angleThreshold) {
                        locMat.multScalar(distWeight * 0.1);
                        totalDistWeight += 0.1 * distWeight;
                    } else {
                        locMat.multScalar(distWeight);
                        totalDistWeight += distWeight;
                    }
                    covarianceVert.add(locMat);
                    ++j;
                }
                covarianceVert.multScalar(1.0 / totalDistWeight);
                covarianceVert = this.binaryOptimization(covarianceVert, 0.3);
                PdVector oldNormal = PdVector.copyNew((PdVector)this.m_updatedVertNormal[k]);
                this.m_updatedVertNormal[k].leftMultMatrix(covarianceVert);
                this.m_updatedVertNormal[k].normalize();
                this.m_updatedVertNormal[k].add(2.0, oldNormal);
                this.m_updatedVertNormal[k].normalize();
                ++k;
            }
            ++it;
        }
        PgVectorField vf = new PgVectorField(3);
        vf.setBasedOn(0);
        this.m_geomExp.addVectorField(vf);
        vf.setName("Smooth Vertex Normal");
        vf.setGeometry((PgPointSet)this.m_geomExp);
        vf.setNumVectors(this.m_nov);
        vf.setVectors(this.m_updatedVertNormal);
        System.out.println("Done ");
    }

    public void laplacian(PdVector[] diff) {
        PgPointSet lapl = new PgPointSet(3);
        this.m_laplacian = PdVector.realloc(null, (int)this.m_nov, (int)3);
        this.m_avgLap = new PdVector(3);
        int k = 0;
        while (k < this.m_nov) {
            int valence = this.m_valence[k].getSize();
            if (valence != 0) {
                double weight = 1.0 / (double)valence;
                PdVector loc = new PdVector(3);
                int i = 0;
                while (i < valence) {
                    if (!this.m_vertices[k].hasTag(14) && this.m_valence[k].m_data[i] != k) {
                        loc.add(diff[this.m_valence[k].m_data[i]]);
                    }
                    ++i;
                }
                loc.multScalar(weight);
                loc.sub(diff[k]);
                this.m_laplacian[k] = loc;
                this.m_avgLap.add(this.m_laplacian[k]);
                lapl.addVertex(loc);
            }
            ++k;
        }
        this.m_avgLap.multScalar(1.0 / (double)this.m_nov);
        System.out.println("Average laplacian " + this.m_avgLap);
    }

    public void disAniLap() {
        this.m_diAniLap = PdVector.realloc(null, (int)this.m_nov, (int)3);
        this.m_geomExp.makeVertexNormals();
        PdVector[] vertNormal = this.m_geomExp.getVertexNormals();
        PgVectorField vf = new PgVectorField(1);
        this.m_geomExp.addVectorField(vf);
        vf.setName(" Discrete Anisotropic Laplacian");
        vf.setGeometry((PgPointSet)this.m_geomExp);
        vf.setNumVectors(this.m_nov);
        int k = 0;
        while (k < this.m_nov) {
            this.m_S.makeVertexStar(this.m_geomExp, k, this.m_elemperVert.m_data[k]);
            PiVector Neigh_Ind = this.m_S.getLink();
            int star = Neigh_Ind.getSize();
            double h = 0.0;
            PdVector hvector = new PdVector(star);
            int i = 0;
            while (i < star) {
                PdVector edge = PdVector.subNew((PdVector)this.m_vertices[k], (PdVector)this.m_vertices[Neigh_Ind.m_data[i]]);
                hvector.m_data[i] = h = edge.dot(vertNormal[k]);
                ++i;
            }
            double avgEdgeLen = hvector.average();
            PdVector absMeanDev = new PdVector(star);
            int i2 = 0;
            while (i2 < star) {
                absMeanDev.m_data[i2] = Math.abs(hvector.m_data[i2] - avgEdgeLen);
                ++i2;
            }
            double sigma = 2.0 * absMeanDev.average();
            double weightSum = 0.0;
            double weightEdgeSum = 0.0;
            double weightFact = 0.0;
            int i3 = 0;
            while (i3 < star) {
                weightFact = hvector.m_data[i3] == 0.0 && sigma == 0.0 ? 0.0 : Math.exp(-(hvector.m_data[i3] * hvector.m_data[i3]) / (2.0 * sigma * sigma));
                weightSum += weightFact;
                double weightEdge = weightFact * hvector.m_data[i3];
                weightEdgeSum += weightEdge;
                ++i3;
            }
            double scaFac = 0.0;
            scaFac = weightSum < 1.0E-10 ? 0.0 : weightEdgeSum / weightSum;
            this.m_diAniLap[k] = vertNormal[k];
            this.m_diAniLap[k].multScalar(scaFac);
            vf.setVector(k, this.m_diAniLap[k].length());
            ++k;
        }
        this.m_geomExp.update((Object)this.m_geomExp);
    }

    public void starValence() {
        this.m_valence = PiVector.realloc(null, (int)this.m_nov, (int)3);
        this.m_valElem = PiVector.realloc(null, (int)this.m_nov, (int)3);
        this.m_valNum = new PiVector(this.m_nov);
        this.m_vertStaravgDist = PdVector.realloc(null, (int)this.m_nov, (int)3);
        double valAvg = 0.0;
        int k = 0;
        while (k < this.m_nov) {
            if (!this.m_geomExp.getVertex(k).hasTag(14)) {
                int val;
                this.m_S.makeVertexStar(this.m_geomExp, k, this.m_elemperVert.m_data[k]);
                PiVector starVertInd = this.m_S.getLink();
                this.m_valNum.m_data[k] = val = starVertInd.getSize();
                this.m_valence[k] = new PiVector(val);
                this.m_valElem[k] = new PiVector(val);
                this.m_vertStaravgDist[k] = new PdVector(val);
                valAvg += (double)val;
                int i = 0;
                while (i < val) {
                    this.m_valence[k].m_data[i] = starVertInd.m_data[i];
                    ++i;
                }
            }
            ++k;
        }
        System.out.println("Average valence " + valAvg / (double)this.m_nov);
    }

    public void radiusPointsVert(PgElementSet geom, double radius, int vertInd) {
        long stTime = System.currentTimeMillis();
        if (this.m_vertStatus == null || this.m_vertStatus.length != this.m_nov) {
            this.m_vertStatus = new int[this.m_nov];
            int i = 0;
            while (i < this.m_nov) {
                this.m_vertStatus[i] = -1;
                ++i;
            }
        }
        PuQueue queue = new PuQueue(100);
        queue.enqueue(vertInd);
        this.m_vertStatus[vertInd] = vertInd;
        boolean[] vertInBall = new boolean[10];
        PdVector vertex = geom.getVertex(vertInd);
        geom.setTagVertex(vertInd, 1);
        while (!queue.isEmpty()) {
            int locVertInd = queue.extractFirst();
            this.m_S.makeVertexStar(geom, locVertInd, this.m_elemperVert.m_data[locVertInd]);
            PiVector neighvert = this.m_S.getLink();
            int nSize = neighvert.getSize();
            int i = 0;
            while (i < nSize) {
                int nInd = neighvert.m_data[i];
                if (nInd >= 0) {
                    PdVector locVert = geom.getVertex(nInd);
                    boolean bl = vertInBall[i] = vertex.sqrDist(locVert) < radius * radius;
                    if (vertInBall[i] && this.m_vertStatus[nInd] != vertInd && !geom.hasTagVertex(nInd, 1)) {
                        geom.setTagVertex(nInd, 1);
                        queue.enqueue(nInd);
                        this.m_vertStatus[nInd] = nInd;
                    }
                }
                ++i;
            }
        }
        geom.update((Object)geom);
        long enTime = System.currentTimeMillis();
        System.out.println(" total time taken to select the elements within the fix radius :" + (enTime - stTime));
    }

    public static PdVector getEdgeLengths(PgElementSet geom, PdVector edgeLength, boolean bUseBoundaryEdges) {
        int numEdges = geom.getNumEdges();
        if (edgeLength == null) {
            edgeLength = new PdVector();
        }
        edgeLength.setSize(numEdges);
        int numElements = geom.getNumElements();
        PiVector[] element = geom.getElements();
        PiVector[] neighbour = geom.getNeighbours();
        int ind = 0;
        int i = 0;
        while (i < numElements) {
            int elemLen = element[i].getSize();
            int j = 0;
            while (j < elemLen) {
                if (neighbour == null && bUseBoundaryEdges || neighbour != null && neighbour[i].m_data[j] < i) {
                    double len = geom.getEdgeLength(i, j);
                    edgeLength.setEntry(ind, len);
                    ++ind;
                }
                ++j;
            }
            ++i;
        }
        edgeLength.setSize(ind);
        return edgeLength;
    }

    public void vecFieldVis(PgElementSet geom, PdVector[] vec) {
        PgVectorField vf = new PgVectorField(3);
        vf.setBasedOn(0);
        geom.addVectorField(vf);
        vf.setName("New Normals");
        vf.setGeometry((PgPointSet)geom);
        vf.setNumVectors(this.m_nov);
        vf.setVectors(vec);
        geom.update((Object)geom);
    }

    public boolean update(Object event) {
        if (event == this.m_threshold) {
            System.out.println("Current Value of Threshold: " + this.m_threshold.getValue());
            return true;
        }
        if (event == this.m_dampingFactor) {
            System.out.println(" Damping Factor: " + this.m_dampingFactor.getValue());
            return true;
        }
        if (event == this.m_numIteration) {
            System.out.println(" Number of iterations : " + this.m_numIteration.getValue());
            return true;
        }
        if (event == this.m_multiPurpose) {
            System.out.println(" For diffrent methods value of this variable s : " + this.m_multiPurpose.getValue());
            return true;
        }
        return super.update(event);
    }
}

