/*
 * Decompiled with CFR 0.152.
 */
package dev.denoising.DiffVis;

import dev.denoising.DiffVis.PwDiffVis;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import jv.object.PsConfig;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jvx.project.PjWorkshop_IP;

public class PwDiffVis_IP
extends PjWorkshop_IP
implements ActionListener {
    private static final long serialVersionUID = 1L;
    PwDiffVis m_pwDiffVis;
    Button m_measureEuclidean;
    Button m_measureNorm;
    Button m_scalarFieldEc;
    Button m_scalarFieldNorm;
    Checkbox m_topology;
    Checkbox m_scalarField;

    public PwDiffVis_IP() {
        if (this.getClass() == PwDiffVis_IP.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.setTitle(PsConfig.getMessage((boolean)true, (int)54000, (String)"Disparity Visualization"));
        PsPanel bp1 = new PsPanel();
        bp1.setLayout((LayoutManager)new FlowLayout());
        this.m_topology = new Checkbox("Topology Changed");
        this.add(this.m_topology);
        this.m_topology.setState(false);
        bp1.add((Component)this.m_topology);
        this.m_scalarField = new Checkbox("Visualize Scalar Field");
        this.add(this.m_scalarField);
        this.m_scalarField.setState(true);
        bp1.add((Component)this.m_scalarField);
        this.add((Component)bp1);
        PsPanel bp = new PsPanel();
        bp.setLayout((LayoutManager)new FlowLayout());
        this.m_measureEuclidean = new Button("Disparity Measurement (Euclidean Distance)");
        this.m_measureEuclidean.addActionListener(this);
        bp.add((Component)this.m_measureEuclidean);
        this.add((Component)bp);
        PsPanel bp2 = new PsPanel();
        bp2.setLayout((LayoutManager)new FlowLayout());
        this.m_measureNorm = new Button("Disparity Measurement (Normal Direction)");
        this.m_measureNorm.addActionListener(this);
        bp2.add((Component)this.m_measureNorm);
        this.add((Component)bp2);
    }

    public String getNotice() {
        return "Compute shift of the vertices of a geometry after an operation performed.There are two metheods to compute deviation, one along the normal direction and other is Euclidean distance. If both geometries have same topology then no need to compute the correspondence points and disable the 'topology changed' check box. Other check box is to enable the scalar field or vertices painting. Slider can be use for give a threshold tolerence value above this value all vertices will be paint in red color";
    }

    protected int getDialogButtons() {
        return super.getDialogButtons() | 8;
    }

    public Dimension getDialogSize() {
        return new Dimension(350, 400);
    }

    public void setParent(PsUpdateIf parent) {
        super.setParent(parent);
        this.m_pwDiffVis = (PwDiffVis)parent;
        this.add((Component)this.m_pwDiffVis.m_color.newInspector("_IP"));
        this.validate();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.m_measureEuclidean) {
            if (this.m_scalarField.getState()) {
                if (this.m_topology.getState()) {
                    this.m_pwDiffVis.corrVisEucField();
                } else {
                    this.m_pwDiffVis.scalarEucField();
                }
            } else if (this.m_topology.getState()) {
                this.m_pwDiffVis.corrVisEucColor();
            } else {
                this.m_pwDiffVis.computeDiffColor();
            }
        } else if (source == this.m_measureNorm) {
            if (this.m_scalarField.getState()) {
                if (this.m_topology.getState()) {
                    this.m_pwDiffVis.corrVisNormField();
                } else {
                    this.m_pwDiffVis.scalarFieldNorm();
                }
            } else if (this.m_topology.getState()) {
                this.m_pwDiffVis.corrVisNormColor();
            } else {
                this.m_pwDiffVis.computeDiffNormColor();
            }
        } else {
            super.actionPerformed(event);
        }
    }
}

