/*
 * Decompiled with CFR 0.152.
 */
package dev.denoising.DiffVis;

import dev.denoising.Box.PjBox;
import dev.denoising.Box.boxComparator;
import java.awt.Color;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.number.PuDouble;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.vecmath.P_Vector;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.project.PjWorkshop;
import jvx.util.PuAVLTree;
import jvx.util.PuCompare_If;

public class PwDiffVis
extends PjWorkshop {
    private static final long serialVersionUID = 1L;
    protected PdVector[] m_vertexBackup;
    protected PuDouble m_color = new PuDouble(" Tolerence Value ", (PsUpdateIf)this);
    protected PgVectorField m_vf;

    public PwDiffVis() {
        super("Variation Visualization");
        if (((Object)((Object)this)).getClass() == PwDiffVis.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_color.setDefBounds(0.0, 2.0, 0.005, 0.005);
        this.m_color.setDefValue(1.0);
        this.m_color.init();
        this.m_color.setValue(0.033);
    }

    public void setGeometry(PgGeometry geom) {
        super.setGeometry(geom);
        this.m_vertexBackup = this.m_geomSave != null ? ((PgPointSet)this.m_geomSave).getVertices() : (PdVector[])P_Vector.clone((P_Vector[])((PgPointSet)geom).getVertices());
    }

    public void computeDiffColor() {
        PdVector[] processedGeom = ((PgPointSet)this.m_geom).getVertices();
        int noVertproc = processedGeom.length;
        PdVector deviation = new PdVector(noVertproc);
        double colorThreshold = this.m_color.getValue();
        int i = 0;
        while (i < noVertproc) {
            deviation.m_data[i] = this.m_geom.getVertex(i).dist(this.m_vertexBackup[i]);
            ++i;
        }
        System.out.println(" Maximum deviation: " + deviation.max() + " Average Deviation: " + deviation.average());
        deviation.multScalar(1.0 / colorThreshold);
        int j = 0;
        while (j < noVertproc) {
            int red = 0;
            int green = 0;
            double locVar = deviation.m_data[j];
            if (locVar <= 0.5) {
                red = (int)(255.0 * (2.0 * locVar));
                green = 255;
            } else if (locVar > 1.0) {
                red = 255;
                green = 0;
            } else {
                red = 255;
                green = (int)(255.0 * (2.0 - 2.0 * locVar));
            }
            Color col = new Color(red, green, 0);
            ((PgPointSet)this.m_geom).setVertexColor(j, col);
            ++j;
        }
        ((PgPointSet)this.m_geom).showVertexColors(true);
        ((PgElementSet)this.m_geom).showElementColorFromVertices(true);
        ((PgElementSet)this.m_geom).showElementColors(true);
        this.m_geom.update((Object)this.m_geom);
        System.out.println(" Color field on the basis of Euclidean distance with same topology ");
    }

    public void computeDiffNormColor() {
        PdVector[] processedGeom = ((PgPointSet)this.m_geom).getVertices();
        int noVertproc = processedGeom.length;
        PdVector deviation = new PdVector(noVertproc);
        double colorThreshold = this.m_color.getValue();
        int i = 0;
        while (i < noVertproc) {
            deviation.m_data[i] = Math.abs(PdVector.dot((PdVector)((PgPointSet)this.m_geom).getVertexNormal(i), (PdVector)PdVector.subNew((PdVector)this.m_geom.getVertex(i), (PdVector)this.m_vertexBackup[i])));
            ++i;
        }
        System.out.println(" Maximum deviation: " + deviation.max() + " Average Deviation: " + deviation.average());
        deviation.multScalar(1.0 / colorThreshold);
        int j = 0;
        while (j < noVertproc) {
            int red = 0;
            int green = 0;
            double locVar = deviation.m_data[j];
            if (locVar <= 0.5) {
                red = (int)(255.0 * (2.0 * locVar));
                green = 255;
            } else if (locVar > 1.0) {
                red = 255;
                green = 0;
            } else {
                red = 255;
                green = (int)(255.0 * (2.0 - 2.0 * locVar));
            }
            Color col = new Color(red, green, 0);
            ((PgPointSet)this.m_geom).setVertexColor(j, col);
            ++j;
        }
        ((PgPointSet)this.m_geom).showVertexColors(true);
        ((PgElementSet)this.m_geom).showElementColorFromVertices(true);
        ((PgElementSet)this.m_geom).showElementColors(true);
        this.m_geom.update((Object)this.m_geom);
        System.out.println(" Color field on the basis of normal direction deviation with same topology ");
    }

    public void scalarEucField() {
        PdVector[] processedGeom = ((PgPointSet)this.m_geom).getVertices();
        int noVertproc = processedGeom.length;
        this.m_vf = new PgVectorField(1);
        ((PgPointSet)this.m_geom).addVectorField(this.m_vf);
        this.m_vf.setName("Disparity Scalar Field Euclidean");
        this.m_vf.setGeometry((PgPointSet)this.m_geom);
        this.m_vf.setNumVectors(noVertproc);
        PdVector deviation = new PdVector(noVertproc);
        int i = 0;
        while (i < noVertproc) {
            double locVar = this.m_geom.getVertex(i).dist(this.m_vertexBackup[i]);
            this.m_vf.setVector(i, locVar);
            deviation.m_data[i] = locVar;
            ++i;
        }
        System.out.println(" Maximum deviation: " + deviation.max() + " Average Deviation: " + deviation.average());
        this.m_geom.update((Object)this.m_geom);
        System.out.println(" Scalar field on the basis of Euclidean distance with same topology ");
    }

    public void corrVisNormColor() {
        PdVector[] box = this.m_geom.getBounds();
        double xmin = box[0].m_data[0];
        double xmax = box[1].m_data[0];
        double ymin = box[0].m_data[1];
        double ymax = box[1].m_data[1];
        double zmin = box[0].m_data[2];
        double zmax = box[1].m_data[2];
        double Grid_3d = 0.033;
        int xline = (int)((xmax - xmin) / Grid_3d + 1.0);
        int yline = (int)((ymax - ymin) / Grid_3d + 1.0);
        int zline = (int)((zmax - zmin) / Grid_3d + 1.0);
        PuAVLTree tree_Hr = new PuAVLTree((PuCompare_If)new boxComparator());
        int origVert = this.m_vertexBackup.length;
        int i = 0;
        while (i < origVert) {
            double x = this.m_vertexBackup[i].m_data[0];
            int xIndex = (int)((x - xmin) / Grid_3d);
            double y = this.m_vertexBackup[i].m_data[1];
            int yIndex = (int)((y - ymin) / Grid_3d);
            double z = this.m_vertexBackup[i].m_data[2];
            int zIndex = (int)((z - zmin) / Grid_3d);
            PjBox box_Or = new PjBox(xIndex, yIndex, zIndex);
            Object box_Or2 = tree_Hr.findNode((Object)box_Or);
            if (box_Or2 == null) {
                tree_Hr.insert((Object)box_Or);
            } else {
                box_Or = (PjBox)box_Or2;
            }
            box_Or.addVertex(0, i);
            ++i;
        }
        int procVert = ((PgPointSet)this.m_geom).getNumVertices();
        PiVector[] correspondence = PiVector.realloc(null, (int)2, (int)procVert);
        PjBox boxProc = new PjBox(0, 0, 0);
        PjBox boxProc2 = new PjBox(0, 0, 0);
        int neigh = 2;
        int j = 0;
        while (j < procVert) {
            double x2 = this.m_geom.getVertex((int)j).m_data[0];
            int xIndex2 = (int)((x2 - xmin) / Grid_3d);
            double y2 = this.m_geom.getVertex((int)j).m_data[1];
            int yIndex2 = (int)((y2 - ymin) / Grid_3d);
            double z2 = this.m_geom.getVertex((int)j).m_data[2];
            int zIndex2 = (int)((z2 - zmin) / Grid_3d);
            double locvAR = Double.MAX_VALUE;
            int locVert = 0;
            int i2 = xIndex2 - neigh;
            while (i2 <= xIndex2 + neigh) {
                if (i2 >= 0 || i2 < xline) {
                    int m = yIndex2 - neigh;
                    while (m <= yIndex2 + neigh) {
                        if (m >= 0 || m < yline) {
                            int n = zIndex2 - neigh;
                            while (n <= zIndex2 + neigh) {
                                if (n >= 0 || n < zline) {
                                    boxProc2.setPosition(i2, m, n);
                                    Object box2 = tree_Hr.findNode((Object)boxProc2);
                                    if (box2 != null) {
                                        boxProc = (PjBox)box2;
                                        PiVector vertPoint = boxProc.m_vertIndex;
                                        int noPoint = vertPoint.getSize();
                                        int p = 0;
                                        while (p < noPoint) {
                                            double distance = this.m_geom.getVertex(j).dist(this.m_vertexBackup[vertPoint.m_data[p]]);
                                            if (distance < locvAR) {
                                                locvAR = distance;
                                                locVert = vertPoint.m_data[p];
                                            }
                                            ++p;
                                        }
                                    }
                                }
                                ++n;
                            }
                        }
                        ++m;
                    }
                }
                ++i2;
            }
            correspondence[0].setEntry(j, j);
            correspondence[1].setEntry(j, locVert);
            ++j;
        }
        PdVector deviation = new PdVector(procVert);
        int i3 = 0;
        while (i3 < procVert) {
            double locVar = Math.abs(PdVector.dot((PdVector)((PgPointSet)this.m_geom).getVertexNormal(correspondence[0].getEntry(i3)), (PdVector)PdVector.subNew((PdVector)this.m_geom.getVertex(correspondence[0].getEntry(i3)), (PdVector)this.m_vertexBackup[correspondence[1].getEntry(i3)])));
            this.m_vf.setVector(correspondence[0].getEntry(i3), locVar);
            deviation.m_data[i3] = locVar;
            ++i3;
        }
        System.out.println(" Maximum deviation: " + deviation.max() + " Average Deviation: " + deviation.average());
        double colorThreshold = this.m_color.getValue();
        deviation.multScalar(1.0 / colorThreshold);
        int j2 = 0;
        while (j2 < procVert) {
            int red = 0;
            int green = 0;
            double locVar = deviation.m_data[j2];
            if (locVar <= 0.5) {
                red = (int)(255.0 * (2.0 * locVar));
                green = 255;
            } else if (locVar > 1.0) {
                red = 255;
                green = 0;
            } else {
                red = 255;
                green = (int)(255.0 * (2.0 - 2.0 * locVar));
            }
            Color col = new Color(red, green, 0);
            ((PgPointSet)this.m_geom).setVertexColor(j2, col);
            ++j2;
        }
        ((PgPointSet)this.m_geom).showVertexColors(true);
        ((PgElementSet)this.m_geom).showElementColorFromVertices(true);
        ((PgElementSet)this.m_geom).showElementColors(true);
        this.m_geom.update((Object)this.m_geom);
        System.out.println(" Color field on the basis of normal direction deviation with different topology ");
    }

    public void corrVisEucColor() {
        PdVector[] box = this.m_geom.getBounds();
        double xmin = box[0].m_data[0];
        double xmax = box[1].m_data[0];
        double ymin = box[0].m_data[1];
        double ymax = box[1].m_data[1];
        double zmin = box[0].m_data[2];
        double zmax = box[1].m_data[2];
        double Grid_3d = 0.033;
        int xline = (int)((xmax - xmin) / Grid_3d + 1.0);
        int yline = (int)((ymax - ymin) / Grid_3d + 1.0);
        int zline = (int)((zmax - zmin) / Grid_3d + 1.0);
        PuAVLTree tree_Hr = new PuAVLTree((PuCompare_If)new boxComparator());
        int origVert = this.m_vertexBackup.length;
        int i = 0;
        while (i < origVert) {
            double x = this.m_vertexBackup[i].m_data[0];
            int xIndex = (int)((x - xmin) / Grid_3d);
            double y = this.m_vertexBackup[i].m_data[1];
            int yIndex = (int)((y - ymin) / Grid_3d);
            double z = this.m_vertexBackup[i].m_data[2];
            int zIndex = (int)((z - zmin) / Grid_3d);
            PjBox box_Or = new PjBox(xIndex, yIndex, zIndex);
            Object box_Or2 = tree_Hr.findNode((Object)box_Or);
            if (box_Or2 == null) {
                tree_Hr.insert((Object)box_Or);
            } else {
                box_Or = (PjBox)box_Or2;
            }
            box_Or.addVertex(0, i);
            ++i;
        }
        int procVert = ((PgPointSet)this.m_geom).getNumVertices();
        PiVector[] correspondence = PiVector.realloc(null, (int)2, (int)procVert);
        PdVector deviation = new PdVector(procVert);
        PjBox boxProc = new PjBox(0, 0, 0);
        PjBox boxProc2 = new PjBox(0, 0, 0);
        int neigh = 2;
        int j = 0;
        while (j < procVert) {
            double x2 = this.m_geom.getVertex((int)j).m_data[0];
            int xIndex2 = (int)((x2 - xmin) / Grid_3d);
            double y2 = this.m_geom.getVertex((int)j).m_data[1];
            int yIndex2 = (int)((y2 - ymin) / Grid_3d);
            double z2 = this.m_geom.getVertex((int)j).m_data[2];
            int zIndex2 = (int)((z2 - zmin) / Grid_3d);
            double locvAR = Double.MAX_VALUE;
            int locVert = 0;
            int i2 = xIndex2 - neigh;
            while (i2 <= xIndex2 + neigh) {
                if (i2 >= 0 || i2 < xline) {
                    int m = yIndex2 - neigh;
                    while (m <= yIndex2 + neigh) {
                        if (m >= 0 || m < yline) {
                            int n = zIndex2 - neigh;
                            while (n <= zIndex2 + neigh) {
                                if (n >= 0 || n < zline) {
                                    boxProc2.setPosition(i2, m, n);
                                    Object box2 = tree_Hr.findNode((Object)boxProc2);
                                    if (box2 != null) {
                                        boxProc = (PjBox)box2;
                                        PiVector vertPoint = boxProc.m_vertIndex;
                                        int noPoint = vertPoint.getSize();
                                        int p = 0;
                                        while (p < noPoint) {
                                            double distance = this.m_geom.getVertex(j).dist(this.m_vertexBackup[vertPoint.m_data[p]]);
                                            if (distance < locvAR) {
                                                locvAR = distance;
                                                locVert = vertPoint.m_data[p];
                                            }
                                            ++p;
                                        }
                                    }
                                }
                                ++n;
                            }
                        }
                        ++m;
                    }
                }
                ++i2;
            }
            correspondence[0].setEntry(j, j);
            correspondence[1].setEntry(j, locVert);
            deviation.m_data[j] = locvAR;
            ++j;
        }
        System.out.println(" Maximum deviation: " + deviation.max() + " Average Deviation: " + deviation.average());
        double colorThreshold = this.m_color.getValue();
        deviation.multScalar(1.0 / colorThreshold);
        int j2 = 0;
        while (j2 < procVert) {
            int red = 0;
            int green = 0;
            double locVar = deviation.m_data[j2];
            if (locVar <= 0.5) {
                red = (int)(255.0 * (2.0 * locVar));
                green = 255;
            } else if (locVar > 1.0) {
                red = 255;
                green = 0;
            } else {
                red = 255;
                green = (int)(255.0 * (2.0 - 2.0 * locVar));
            }
            Color col = new Color(red, green, 0);
            ((PgPointSet)this.m_geom).setVertexColor(j2, col);
            ++j2;
        }
        ((PgPointSet)this.m_geom).showVertexColors(true);
        ((PgElementSet)this.m_geom).showElementColorFromVertices(true);
        ((PgElementSet)this.m_geom).showElementColors(true);
        this.m_geom.update((Object)this.m_geom);
        System.out.println(" Color field on the basis of Euclidean Distance with different topology ");
    }

    public void corrVisEucField() {
        PdVector[] box = this.m_geom.getBounds();
        double xmin = box[0].m_data[0];
        double xmax = box[1].m_data[0];
        double ymin = box[0].m_data[1];
        double ymax = box[1].m_data[1];
        double zmin = box[0].m_data[2];
        double zmax = box[1].m_data[2];
        double Grid_3d = 0.033;
        int xline = (int)((xmax - xmin) / Grid_3d + 1.0);
        int yline = (int)((ymax - ymin) / Grid_3d + 1.0);
        int zline = (int)((zmax - zmin) / Grid_3d + 1.0);
        PuAVLTree tree_Hr = new PuAVLTree((PuCompare_If)new boxComparator());
        int origVert = this.m_vertexBackup.length;
        int i = 0;
        while (i < origVert) {
            double x = this.m_vertexBackup[i].m_data[0];
            int xIndex = (int)((x - xmin) / Grid_3d);
            double y = this.m_vertexBackup[i].m_data[1];
            int yIndex = (int)((y - ymin) / Grid_3d);
            double z = this.m_vertexBackup[i].m_data[2];
            int zIndex = (int)((z - zmin) / Grid_3d);
            PjBox box_Or = new PjBox(xIndex, yIndex, zIndex);
            Object box_Or2 = tree_Hr.findNode((Object)box_Or);
            if (box_Or2 == null) {
                tree_Hr.insert((Object)box_Or);
            } else {
                box_Or = (PjBox)box_Or2;
            }
            box_Or.addVertex(0, i);
            ++i;
        }
        int procVert = ((PgPointSet)this.m_geom).getNumVertices();
        PiVector[] correspondence = PiVector.realloc(null, (int)2, (int)procVert);
        PdVector deviation = new PdVector(procVert);
        PjBox boxProc = new PjBox(0, 0, 0);
        PjBox boxProc2 = new PjBox(0, 0, 0);
        int neigh = 2;
        int j = 0;
        while (j < procVert) {
            double x2 = this.m_geom.getVertex((int)j).m_data[0];
            int xIndex2 = (int)((x2 - xmin) / Grid_3d);
            double y2 = this.m_geom.getVertex((int)j).m_data[1];
            int yIndex2 = (int)((y2 - ymin) / Grid_3d);
            double z2 = this.m_geom.getVertex((int)j).m_data[2];
            int zIndex2 = (int)((z2 - zmin) / Grid_3d);
            double locvAR = Double.MAX_VALUE;
            int locVert = 0;
            int i2 = xIndex2 - neigh;
            while (i2 <= xIndex2 + neigh) {
                if (i2 >= 0 || i2 < xline) {
                    int m = yIndex2 - neigh;
                    while (m <= yIndex2 + neigh) {
                        if (m >= 0 || m < yline) {
                            int n = zIndex2 - neigh;
                            while (n <= zIndex2 + neigh) {
                                if (n >= 0 || n < zline) {
                                    boxProc2.setPosition(i2, m, n);
                                    Object box2 = tree_Hr.findNode((Object)boxProc2);
                                    if (box2 != null) {
                                        boxProc = (PjBox)box2;
                                        PiVector vertPoint = boxProc.m_vertIndex;
                                        int noPoint = vertPoint.getSize();
                                        int p = 0;
                                        while (p < noPoint) {
                                            double distance = this.m_geom.getVertex(j).dist(this.m_vertexBackup[vertPoint.m_data[p]]);
                                            if (distance < locvAR) {
                                                locvAR = distance;
                                                locVert = vertPoint.m_data[p];
                                            }
                                            ++p;
                                        }
                                    }
                                }
                                ++n;
                            }
                        }
                        ++m;
                    }
                }
                ++i2;
            }
            correspondence[0].setEntry(j, j);
            correspondence[1].setEntry(j, locVert);
            deviation.m_data[j] = locvAR;
            ++j;
        }
        this.m_vf = new PgVectorField(1);
        ((PgPointSet)this.m_geom).addVectorField(this.m_vf);
        this.m_vf.setName("Disparity Scalar Field Scalar");
        this.m_vf.setGeometry((PgPointSet)this.m_geom);
        this.m_vf.setNumVectors(procVert);
        int i3 = 0;
        while (i3 < procVert) {
            this.m_vf.setVector(correspondence[0].getEntry(i3), deviation.m_data[i3]);
            ++i3;
        }
        System.out.println(" Maximum deviation: " + deviation.max() + " Average Deviation: " + deviation.average());
        this.m_geom.update((Object)this.m_geom);
        System.out.println(" Scalar field on the basis of Euclidean Distance with different topology ");
    }

    public void corrVisNormField() {
        PdVector[] box = this.m_geom.getBounds();
        double xmin = box[0].m_data[0];
        double xmax = box[1].m_data[0];
        double ymin = box[0].m_data[1];
        double ymax = box[1].m_data[1];
        double zmin = box[0].m_data[2];
        double zmax = box[1].m_data[2];
        double Grid_3d = 0.033;
        int xline = (int)((xmax - xmin) / Grid_3d + 1.0);
        int yline = (int)((ymax - ymin) / Grid_3d + 1.0);
        int zline = (int)((zmax - zmin) / Grid_3d + 1.0);
        PuAVLTree tree_Hr = new PuAVLTree((PuCompare_If)new boxComparator());
        int origVert = this.m_vertexBackup.length;
        int i = 0;
        while (i < origVert) {
            double x = this.m_vertexBackup[i].m_data[0];
            int xIndex = (int)((x - xmin) / Grid_3d);
            double y = this.m_vertexBackup[i].m_data[1];
            int yIndex = (int)((y - ymin) / Grid_3d);
            double z = this.m_vertexBackup[i].m_data[2];
            int zIndex = (int)((z - zmin) / Grid_3d);
            PjBox box_Or = new PjBox(xIndex, yIndex, zIndex);
            Object box_Or2 = tree_Hr.findNode((Object)box_Or);
            if (box_Or2 == null) {
                tree_Hr.insert((Object)box_Or);
            } else {
                box_Or = (PjBox)box_Or2;
            }
            box_Or.addVertex(0, i);
            ++i;
        }
        int procVert = ((PgPointSet)this.m_geom).getNumVertices();
        PiVector[] correspondence = PiVector.realloc(null, (int)2, (int)procVert);
        PjBox boxProc = new PjBox(0, 0, 0);
        PjBox boxProc2 = new PjBox(0, 0, 0);
        int neigh = 2;
        int j = 0;
        while (j < procVert) {
            double x2 = this.m_geom.getVertex((int)j).m_data[0];
            int xIndex2 = (int)((x2 - xmin) / Grid_3d);
            double y2 = this.m_geom.getVertex((int)j).m_data[1];
            int yIndex2 = (int)((y2 - ymin) / Grid_3d);
            double z2 = this.m_geom.getVertex((int)j).m_data[2];
            int zIndex2 = (int)((z2 - zmin) / Grid_3d);
            double locvAR = Double.MAX_VALUE;
            int locVert = 0;
            int i2 = xIndex2 - neigh;
            while (i2 <= xIndex2 + neigh) {
                if (i2 >= 0 || i2 < xline) {
                    int m = yIndex2 - neigh;
                    while (m <= yIndex2 + neigh) {
                        if (m >= 0 || m < yline) {
                            int n = zIndex2 - neigh;
                            while (n <= zIndex2 + neigh) {
                                if (n >= 0 || n < zline) {
                                    boxProc2.setPosition(i2, m, n);
                                    Object box2 = tree_Hr.findNode((Object)boxProc2);
                                    if (box2 != null) {
                                        boxProc = (PjBox)box2;
                                        PiVector vertPoint = boxProc.m_vertIndex;
                                        int noPoint = vertPoint.getSize();
                                        int p = 0;
                                        while (p < noPoint) {
                                            double distance = this.m_geom.getVertex(j).dist(this.m_vertexBackup[vertPoint.m_data[p]]);
                                            if (distance < locvAR) {
                                                locvAR = distance;
                                                locVert = vertPoint.m_data[p];
                                            }
                                            ++p;
                                        }
                                    }
                                }
                                ++n;
                            }
                        }
                        ++m;
                    }
                }
                ++i2;
            }
            correspondence[0].setEntry(j, j);
            correspondence[1].setEntry(j, locVert);
            ++j;
        }
        int numVert = correspondence[1].getSize();
        this.m_vf = new PgVectorField(1);
        ((PgPointSet)this.m_geom).addVectorField(this.m_vf);
        this.m_vf.setName("Disparity Scalar Field Scalar");
        this.m_vf.setGeometry((PgPointSet)this.m_geom);
        this.m_vf.setNumVectors(numVert);
        PdVector deviation = new PdVector(numVert);
        int i3 = 0;
        while (i3 < numVert) {
            double locVar = Math.abs(PdVector.dot((PdVector)((PgPointSet)this.m_geom).getVertexNormal(correspondence[0].getEntry(i3)), (PdVector)PdVector.subNew((PdVector)this.m_geom.getVertex(correspondence[0].getEntry(i3)), (PdVector)this.m_vertexBackup[correspondence[1].getEntry(i3)])));
            this.m_vf.setVector(correspondence[0].getEntry(i3), locVar);
            deviation.m_data[i3] = locVar;
            ++i3;
        }
        System.out.println(" Maximum deviation: " + deviation.max() + " Average Deviation: " + deviation.average());
        this.m_geom.update((Object)this.m_geom);
        System.out.println(" Scalar field on the basis of Normal direction deviation with different topology ");
    }

    public void scalarFieldNorm() {
        PdVector[] processedGeom = ((PgPointSet)this.m_geom).getVertices();
        int noVertproc = processedGeom.length;
        this.m_vf = new PgVectorField(1);
        ((PgPointSet)this.m_geom).addVectorField(this.m_vf);
        this.m_vf.setName("Disparity Scalar Field Scalar");
        this.m_vf.setGeometry((PgPointSet)this.m_geom);
        this.m_vf.setNumVectors(noVertproc);
        PdVector deviation = new PdVector(noVertproc);
        int i = 0;
        while (i < noVertproc) {
            double locVar = Math.abs(PdVector.dot((PdVector)((PgPointSet)this.m_geom).getVertexNormal(i), (PdVector)PdVector.subNew((PdVector)this.m_geom.getVertex(i), (PdVector)this.m_vertexBackup[i])));
            this.m_vf.setVector(i, locVar);
            deviation.m_data[i] = locVar;
            ++i;
        }
        System.out.println(" Maximum deviation: " + deviation.max() + " Average Deviation: " + deviation.average());
        this.m_geom.update((Object)this.m_geom);
        System.out.println(" Scalar field on the basis of Normal direction deviation with same topology ");
    }

    public boolean update(Object event) {
        if (event == this.m_color) {
            System.out.println("Tolerence value " + this.m_color.getValue());
            return true;
        }
        return super.update(event);
    }
}

