/*
 * Decompiled with CFR 0.152.
 */
package devZomeView;

import devZomeView.PgZomeSet;
import devZomeView.PnZomeSymmetry;
import java.awt.Color;
import jv.geom.PgPolygonSet;
import jv.object.PsDebug;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.project.PjWorkshop;

public class PwZomeSelect
extends PjWorkshop {
    public static final Color[] EDGE_COLOR = new Color[]{new Color(255, 127, 127), new Color(255, 255, 127), new Color(159, 191, 255), new Color(127, 255, 127), new Color(127, 255, 127)};
    public static final int MODE_ALL_RED_EDGES = 0;
    public static final int MODE_ALL_YELLOW_EDGES = 1;
    public static final int MODE_ALL_BLUE_EDGES = 2;
    public static final int MODE_ALL_GREEN_EDGES = 3;
    public static final int MODE_ALL_HALF_GREEN_EDGES = 4;
    public static final int MODE_RED_SYMMETRIES = 5;
    public static final int MODE_YELLOW_SYMMETRIES = 6;
    public static final int MODE_BLUE_SYMMETRIES = 7;
    public static final int MODE_GREEN_SYMMETRIES = 8;
    protected int m_mode = 0;
    protected int m_restrictColor = -1;
    protected int m_restrictDirectionIndex = 0;
    protected static final int m_scaling_bdry_low = -10;
    protected static final int m_scaling_bdry_hig = 10;
    PgPolygonSet m_polySet;
    protected PdVector m_center;
    protected int m_edgeLength;
    protected int m_color;
    protected PiVector m_directionIndex;

    public PwZomeSelect(String name) {
        super(name);
        this.m_geom = null;
        this.setGeometry((PgGeometry)new PgPolygonSet(3));
        this.m_polySet.setName("Selector Geometry");
        this.m_polySet.setGlobalVertexColor(new Color(127, 127, 127));
        this.m_directionIndex = new PiVector();
        if (((Object)((Object)this)).getClass() == PwZomeSelect.class) {
            this.init();
        }
    }

    public PwZomeSelect(String name, PgPolygonSet geom) {
        this(name);
        this.setGeometry((PgGeometry)geom);
    }

    public void init() {
        super.init();
    }

    public void setGeometry(PgGeometry geom) {
        if (geom == null || !(geom instanceof PgPolygonSet)) {
            PsDebug.warning((String)"Geom is not a PgPolygonSet.");
            return;
        }
        super.setGeometry(geom);
        this.m_polySet = (PgPolygonSet)geom;
    }

    public boolean update(Object event) {
        return super.update(event);
    }

    public String getName() {
        return "Zome Selector Workshop";
    }

    public void setVisibleGeom(boolean flag) {
        if (this.m_display == null) {
            PsDebug.message((String)"Missing display");
            return;
        }
        if (!flag && this.m_display.containsGeometry((PgGeometryIf)this.m_polySet)) {
            this.m_display.removeGeometry((PgGeometryIf)this.m_polySet);
        }
        if (flag && !this.m_display.containsGeometry((PgGeometryIf)this.m_polySet)) {
            this.m_display.addGeometry((PgGeometryIf)this.m_polySet);
            this.m_display.selectGeometry((PgGeometryIf)this.m_polySet);
            this.m_polySet.update((Object)this.m_polySet);
        }
    }

    public void setMode(int mode) {
        this.m_mode = mode;
    }

    public void setCenter(PdVector center) {
        this.m_center = center;
    }

    public void setLength(int length) {
        this.m_edgeLength = length;
    }

    public void computeEdges() {
        int numEdges = 0;
        if (this.m_mode == 0 || this.m_mode == 5) {
            this.m_color = 0;
        } else if (this.m_mode == 1 || this.m_mode == 6) {
            this.m_color = 1;
        } else if (this.m_mode == 2 || this.m_mode == 7) {
            this.m_color = 2;
        } else if (this.m_mode == 3 || this.m_mode == 8) {
            this.m_color = 3;
        } else if (this.m_mode == 4) {
            this.m_color = 4;
        }
        this.m_polySet.setGlobalPolygonColor(EDGE_COLOR[this.m_color]);
        if (this.m_mode == 0 || this.m_mode == 1 || this.m_mode == 2 || this.m_mode == 3 || this.m_mode == 4) {
            if (this.m_restrictColor == -1) {
                numEdges = PnZomeSymmetry.m_numColDirs[this.m_color];
            } else if (this.m_restrictColor == 0) {
                if (this.m_mode == 0) {
                    numEdges = PnZomeSymmetry.redOrthogonalToRed[this.m_restrictDirectionIndex].length;
                }
                if (this.m_mode == 1) {
                    numEdges = PnZomeSymmetry.yellowOrthogonalToRed[this.m_restrictDirectionIndex].length;
                }
                if (this.m_mode == 2) {
                    numEdges = PnZomeSymmetry.blueOrthogonalToRed[this.m_restrictDirectionIndex].length;
                }
                if (this.m_mode == 3 || this.m_mode == 4) {
                    numEdges = PnZomeSymmetry.greenOrthogonalToRed[this.m_restrictDirectionIndex].length;
                }
            } else if (this.m_restrictColor == 1) {
                if (this.m_mode == 0) {
                    numEdges = PnZomeSymmetry.redOrthogonalToYellow[this.m_restrictDirectionIndex].length;
                }
                if (this.m_mode == 1) {
                    numEdges = PnZomeSymmetry.yellowOrthogonalToYellow[this.m_restrictDirectionIndex].length;
                }
                if (this.m_mode == 2) {
                    numEdges = PnZomeSymmetry.blueOrthogonalToYellow[this.m_restrictDirectionIndex].length;
                }
                if (this.m_mode == 3 || this.m_mode == 4) {
                    numEdges = PnZomeSymmetry.greenOrthogonalToYellow[this.m_restrictDirectionIndex].length;
                }
            } else if (this.m_restrictColor == 2) {
                if (this.m_mode == 0) {
                    numEdges = PnZomeSymmetry.redOrthogonalToBlue[this.m_restrictDirectionIndex].length;
                }
                if (this.m_mode == 1) {
                    numEdges = PnZomeSymmetry.yellowOrthogonalToBlue[this.m_restrictDirectionIndex].length;
                }
                if (this.m_mode == 2) {
                    numEdges = PnZomeSymmetry.blueOrthogonalToBlue[this.m_restrictDirectionIndex].length;
                }
                if (this.m_mode == 3 || this.m_mode == 4) {
                    numEdges = PnZomeSymmetry.greenOrthogonalToBlue[this.m_restrictDirectionIndex].length;
                }
            } else if (this.m_restrictColor == 3 || this.m_restrictColor == 4) {
                if (this.m_mode == 0) {
                    numEdges = PnZomeSymmetry.redOrthogonalToGreen[this.m_restrictDirectionIndex].length;
                }
                if (this.m_mode == 1) {
                    numEdges = PnZomeSymmetry.yellowOrthogonalToGreen[this.m_restrictDirectionIndex].length;
                }
                if (this.m_mode == 2) {
                    numEdges = PnZomeSymmetry.blueOrthogonalToGreen[this.m_restrictDirectionIndex].length;
                }
                if (this.m_mode == 3 || this.m_mode == 4) {
                    numEdges = PnZomeSymmetry.greenOrthogonalToGreen[this.m_restrictDirectionIndex].length;
                }
            }
            this.m_directionIndex.setSize(numEdges);
            this.m_polySet.setNumVertices(numEdges + 1);
            this.m_polySet.getVertex(0).copy(this.m_center);
            this.m_polySet.setNumPolygons(numEdges);
            this.m_polySet.clearTagVertex(0, 1);
            int i = 0;
            while (i < numEdges) {
                if (this.m_restrictColor == -1) {
                    this.m_directionIndex.m_data[i] = i;
                } else if (this.m_restrictColor == 0) {
                    if (this.m_mode == 0) {
                        this.m_directionIndex.m_data[i] = PnZomeSymmetry.redOrthogonalToRed[this.m_restrictDirectionIndex][i];
                    }
                    if (this.m_mode == 1) {
                        this.m_directionIndex.m_data[i] = PnZomeSymmetry.yellowOrthogonalToRed[this.m_restrictDirectionIndex][i];
                    }
                    if (this.m_mode == 2) {
                        this.m_directionIndex.m_data[i] = PnZomeSymmetry.blueOrthogonalToRed[this.m_restrictDirectionIndex][i];
                    }
                    if (this.m_mode == 3 || this.m_mode == 4) {
                        this.m_directionIndex.m_data[i] = PnZomeSymmetry.greenOrthogonalToRed[this.m_restrictDirectionIndex][i];
                    }
                } else if (this.m_restrictColor == 1) {
                    if (this.m_mode == 0) {
                        this.m_directionIndex.m_data[i] = PnZomeSymmetry.redOrthogonalToYellow[this.m_restrictDirectionIndex][i];
                    }
                    if (this.m_mode == 1) {
                        this.m_directionIndex.m_data[i] = PnZomeSymmetry.yellowOrthogonalToYellow[this.m_restrictDirectionIndex][i];
                    }
                    if (this.m_mode == 2) {
                        this.m_directionIndex.m_data[i] = PnZomeSymmetry.blueOrthogonalToYellow[this.m_restrictDirectionIndex][i];
                    }
                    if (this.m_mode == 3 || this.m_mode == 4) {
                        this.m_directionIndex.m_data[i] = PnZomeSymmetry.greenOrthogonalToYellow[this.m_restrictDirectionIndex][i];
                    }
                } else if (this.m_restrictColor == 2) {
                    if (this.m_mode == 0) {
                        this.m_directionIndex.m_data[i] = PnZomeSymmetry.redOrthogonalToBlue[this.m_restrictDirectionIndex][i];
                    }
                    if (this.m_mode == 1) {
                        this.m_directionIndex.m_data[i] = PnZomeSymmetry.yellowOrthogonalToBlue[this.m_restrictDirectionIndex][i];
                    }
                    if (this.m_mode == 2) {
                        this.m_directionIndex.m_data[i] = PnZomeSymmetry.blueOrthogonalToBlue[this.m_restrictDirectionIndex][i];
                    }
                    if (this.m_mode == 3 || this.m_mode == 4) {
                        this.m_directionIndex.m_data[i] = PnZomeSymmetry.greenOrthogonalToBlue[this.m_restrictDirectionIndex][i];
                    }
                } else if (this.m_restrictColor == 3 || this.m_restrictColor == 4) {
                    if (this.m_mode == 0) {
                        this.m_directionIndex.m_data[i] = PnZomeSymmetry.redOrthogonalToGreen[this.m_restrictDirectionIndex][i];
                    }
                    if (this.m_mode == 1) {
                        this.m_directionIndex.m_data[i] = PnZomeSymmetry.yellowOrthogonalToGreen[this.m_restrictDirectionIndex][i];
                    }
                    if (this.m_mode == 2) {
                        this.m_directionIndex.m_data[i] = PnZomeSymmetry.blueOrthogonalToGreen[this.m_restrictDirectionIndex][i];
                    }
                    if (this.m_mode == 3 || this.m_mode == 4) {
                        this.m_directionIndex.m_data[i] = PnZomeSymmetry.greenOrthogonalToGreen[this.m_restrictDirectionIndex][i];
                    }
                }
                this.m_polySet.clearTagVertex(i + 1, 1);
                this.m_polySet.setPolygon(i, new PiVector(0, i + 1));
                ++i;
            }
            this.computeScaledVertices();
        } else if (this.m_mode == 5 || this.m_mode == 6 || this.m_mode == 7 || this.m_mode == 8) {
            numEdges = PnZomeSymmetry.m_numColDirs[this.m_color] / 2;
            this.m_directionIndex.setSize(numEdges);
            this.m_polySet.setNumVertices(numEdges * 2);
            this.m_polySet.setNumPolygons(numEdges);
            int i = 0;
            while (i < numEdges) {
                this.m_directionIndex.m_data[i] = i;
                this.m_polySet.clearTagVertex(2 * i, 1);
                this.m_polySet.clearTagVertex(2 * i + 1, 1);
                this.m_polySet.setPolygon(i, new PiVector(2 * i, 2 * i + 1));
                PiVector direction = PiVector.copyNew((PiVector)PnZomeSymmetry.m_intDir[this.m_color][i]);
                PgZomeSet.setIntPosition(this.m_polySet.getVertex(2 * i), direction);
                PgZomeSet.setIntPosition(this.m_polySet.getVertex(2 * i + 1), direction);
                this.m_polySet.getVertex(2 * i + 1).multScalar(-1.0);
                this.m_polySet.getVertex(2 * i).add(this.m_center);
                this.m_polySet.getVertex(2 * i + 1).add(this.m_center);
                ++i;
            }
        }
        this.m_polySet.update((Object)this.m_polySet);
    }

    public void computeScaledVertices() {
        if (this.m_mode == 0 || this.m_mode == 1 || this.m_mode == 2 || this.m_mode == 3 || this.m_mode == 4) {
            int numEdges = 0;
            if (this.m_restrictColor == -1) {
                numEdges = PnZomeSymmetry.m_numColDirs[this.m_color];
            } else if (this.m_restrictColor == 0) {
                if (this.m_mode == 0) {
                    numEdges = PnZomeSymmetry.redOrthogonalToRed[this.m_restrictDirectionIndex].length;
                }
                if (this.m_mode == 1) {
                    numEdges = PnZomeSymmetry.yellowOrthogonalToRed[this.m_restrictDirectionIndex].length;
                }
                if (this.m_mode == 2) {
                    numEdges = PnZomeSymmetry.blueOrthogonalToRed[this.m_restrictDirectionIndex].length;
                }
                if (this.m_mode == 3 || this.m_mode == 4) {
                    numEdges = PnZomeSymmetry.greenOrthogonalToRed[this.m_restrictDirectionIndex].length;
                }
            } else if (this.m_restrictColor == 1) {
                if (this.m_mode == 0) {
                    numEdges = PnZomeSymmetry.redOrthogonalToYellow[this.m_restrictDirectionIndex].length;
                }
                if (this.m_mode == 1) {
                    numEdges = PnZomeSymmetry.yellowOrthogonalToYellow[this.m_restrictDirectionIndex].length;
                }
                if (this.m_mode == 2) {
                    numEdges = PnZomeSymmetry.blueOrthogonalToYellow[this.m_restrictDirectionIndex].length;
                }
                if (this.m_mode == 3 || this.m_mode == 4) {
                    numEdges = PnZomeSymmetry.greenOrthogonalToYellow[this.m_restrictDirectionIndex].length;
                }
            } else if (this.m_restrictColor == 2) {
                if (this.m_mode == 0) {
                    numEdges = PnZomeSymmetry.redOrthogonalToBlue[this.m_restrictDirectionIndex].length;
                }
                if (this.m_mode == 1) {
                    numEdges = PnZomeSymmetry.yellowOrthogonalToBlue[this.m_restrictDirectionIndex].length;
                }
                if (this.m_mode == 2) {
                    numEdges = PnZomeSymmetry.blueOrthogonalToBlue[this.m_restrictDirectionIndex].length;
                }
                if (this.m_mode == 3 || this.m_mode == 4) {
                    numEdges = PnZomeSymmetry.greenOrthogonalToBlue[this.m_restrictDirectionIndex].length;
                }
            } else if (this.m_restrictColor == 3 || this.m_restrictColor == 4) {
                if (this.m_mode == 0) {
                    numEdges = PnZomeSymmetry.redOrthogonalToGreen[this.m_restrictDirectionIndex].length;
                }
                if (this.m_mode == 1) {
                    numEdges = PnZomeSymmetry.yellowOrthogonalToGreen[this.m_restrictDirectionIndex].length;
                }
                if (this.m_mode == 2) {
                    numEdges = PnZomeSymmetry.blueOrthogonalToGreen[this.m_restrictDirectionIndex].length;
                }
                if (this.m_mode == 3 || this.m_mode == 4) {
                    numEdges = PnZomeSymmetry.greenOrthogonalToGreen[this.m_restrictDirectionIndex].length;
                }
            }
            int i = 0;
            while (i < numEdges) {
                PiVector direction = PiVector.copyNew((PiVector)PnZomeSymmetry.m_intDir[this.m_color][this.m_directionIndex.m_data[i]]);
                int j = this.m_edgeLength;
                while (j < 0) {
                    PnZomeSymmetry.divByPhi(direction);
                    ++j;
                }
                j = 0;
                while (j < this.m_edgeLength) {
                    PnZomeSymmetry.multByPhi(direction);
                    ++j;
                }
                PgZomeSet.setIntPosition(this.m_polySet.getVertex(i + 1), direction);
                this.m_polySet.getVertex(i + 1).add(this.m_center);
                ++i;
            }
        }
    }

    public void scaleUp() {
        if (this.m_edgeLength < 10) {
            ++this.m_edgeLength;
        } else {
            PsDebug.message((String)"Maximal scale reached.", (boolean)true);
        }
        this.computeScaledVertices();
        this.m_polySet.update((Object)this.m_polySet);
    }

    public void scaleDown() {
        if (this.m_edgeLength > -10) {
            --this.m_edgeLength;
        } else {
            PsDebug.message((String)"Minimal scale reached.", (boolean)true);
        }
        this.computeScaledVertices();
        this.m_polySet.update((Object)this.m_polySet);
    }

    public PiVector[] getEdgeSelection() {
        PiVector dir = new PiVector(0);
        int numDir = 0;
        int numEdges = this.m_polySet.getNumPolygons();
        int i = 0;
        while (i < numEdges) {
            if (this.m_polySet.hasTagPolygon(i, 1)) {
                dir.setSize(++numDir);
                dir.m_data[numDir - 1] = this.m_directionIndex.m_data[i];
            }
            ++i;
        }
        if (numDir == 0) {
            PsDebug.message((String)"No selected direction!", (boolean)false);
            return null;
        }
        PiVector[] edge = PiVector.realloc(null, (int)numDir, (int)6);
        int i2 = 0;
        while (i2 < numDir) {
            edge[i2].m_data[1] = this.m_color;
            edge[i2].m_data[2] = this.m_edgeLength;
            if (this.m_mode == 0 || this.m_mode == 1 || this.m_mode == 2 || this.m_mode == 3 || this.m_mode == 4) {
                edge[i2].m_data[3] = dir.m_data[i2];
            } else if (this.m_mode == 5 || this.m_mode == 6 || this.m_mode == 7 || this.m_mode == 8) {
                edge[i2].m_data[3] = dir.m_data[i2];
            }
            edge[i2].m_data[5] = 0;
            ++i2;
        }
        return edge;
    }
}

