/*
 * Decompiled with CFR 0.152.
 */
package devZomeView;

import devZomeView.PgZomeSet;
import java.awt.Color;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PuCleanMesh;
import jv.object.PsDebug;
import jv.project.PgGeometry;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PwCleanMesh;
import jvx.geom.PwModel;
import jvx.geom.PwPlatonic;
import jvx.geom.PwTransform;
import jvx.project.PjWorkshop;

public class PwZomeGeom
extends PjWorkshop {
    double scaleSphere = 0.944;
    double scaleInner = 0.6;
    double m_apRed = 0.5;
    double m_apYellow = 0.5;
    double m_apGreen = 1.748;
    private int m_numSphereVertices = 60;
    private int m_numSphereFaces = 62;
    private PgElementSet m_ball;
    private PgElementSet m_elementSet;
    protected double m_explodeParam = 0.0;
    int[][] m_redInd = new int[][]{{120, 122, 124, 126, 128}, {130, 132, 134, 136, 138}, {160, 162, 164, 166, 168}, {150, 152, 154, 156, 158}, {170, 172, 174, 176, 178}, {230, 232, 234, 236, 238}, {200, 202, 204, 206, 208}, {222, 224, 226, 228, 220}, {190, 192, 194, 196, 198}, {182, 184, 186, 188, 180}, {210, 212, 214, 216, 218}, {142, 144, 146, 148, 140}};
    int[][] m_yellowInd;
    int[][] m_blueInd;
    int[][] m_greenInd;

    public PwZomeGeom(String name) {
        super(name);
        int[][] nArrayArray = new int[20][];
        nArrayArray[0] = new int[]{42, 44, 46};
        nArrayArray[1] = new int[]{30, 32, 34};
        nArrayArray[2] = new int[]{12, 14, 16};
        nArrayArray[3] = new int[]{24, 26, 28};
        nArrayArray[4] = new int[]{36, 38, 40};
        nArrayArray[5] = new int[]{96, 98, 100};
        nArrayArray[6] = new int[]{48, 50, 52};
        nArrayArray[7] = new int[]{54, 56, 58};
        nArrayArray[8] = new int[]{6, 8, 10};
        int[] nArray = new int[3];
        nArray[1] = 2;
        nArray[2] = 4;
        nArrayArray[9] = nArray;
        nArrayArray[10] = new int[]{72, 74, 76};
        nArrayArray[11] = new int[]{62, 64, 60};
        nArrayArray[12] = new int[]{92, 94, 90};
        nArrayArray[13] = new int[]{102, 104, 106};
        nArrayArray[14] = new int[]{66, 68, 70};
        nArrayArray[15] = new int[]{18, 20, 22};
        nArrayArray[16] = new int[]{80, 82, 78};
        nArrayArray[17] = new int[]{84, 86, 88};
        nArrayArray[18] = new int[]{118, 114, 116};
        nArrayArray[19] = new int[]{112, 108, 110};
        this.m_yellowInd = nArrayArray;
        this.m_blueInd = new int[][]{{240, 242, 244, 246}, {416, 418, 420, 422}, {320, 322, 324, 326}, {304, 306, 308, 310}, {424, 426, 428, 430}, {336, 338, 340, 342}, {280, 282, 284, 286}, {408, 410, 412, 414}, {312, 314, 316, 318}, {272, 274, 276, 278}, {296, 298, 300, 302}, {328, 330, 332, 334}, {248, 250, 252, 254}, {288, 290, 292, 294}, {432, 434, 436, 438}, {460, 462, 456, 458}, {352, 354, 356, 358}, {388, 390, 384, 386}, {472, 474, 476, 478}, {268, 270, 264, 266}, {392, 394, 396, 398}, {440, 442, 444, 446}, {260, 262, 256, 258}, {380, 382, 376, 378}, {448, 450, 452, 454}, {364, 366, 360, 362}, {400, 402, 404, 406}, {464, 466, 468, 470}, {348, 350, 344, 346}, {368, 370, 372, 374}};
        this.m_greenInd = new int[][]{{128, 120, 122, 124, 126}, {130, 132, 134, 136, 138}, {174, 176, 178, 170, 172}, {144, 146, 148, 140, 142}, {160, 162, 164, 166, 168}, {156, 158, 150, 152, 154}, {126, 128, 120, 122, 124}, {136, 138, 130, 132, 134}, {162, 164, 166, 168, 160}, {150, 152, 154, 156, 158}, {170, 172, 174, 176, 178}, {236, 238, 230, 232, 234}, {120, 122, 124, 126, 128}, {134, 136, 138, 130, 132}, {166, 168, 160, 162, 164}, {154, 156, 158, 150, 152}, {172, 174, 176, 178, 170}, {234, 236, 238, 230, 232}, {124, 126, 128, 120, 122}, {138, 130, 132, 134, 136}, {168, 160, 162, 164, 166}, {152, 154, 156, 158, 150}, {176, 178, 170, 172, 174}, {232, 234, 236, 238, 230}, {122, 124, 126, 128, 120}, {132, 134, 136, 138, 130}, {164, 166, 168, 160, 162}, {158, 150, 152, 154, 156}, {178, 170, 172, 174, 176}, {230, 232, 234, 236, 238}, {202, 204, 206, 208, 200}, {222, 224, 226, 228, 220}, {216, 218, 210, 212, 214}, {238, 230, 232, 234, 236}, {190, 192, 194, 196, 198}, {186, 188, 180, 182, 184}, {204, 206, 208, 200, 202}, {226, 228, 220, 222, 224}, {198, 190, 192, 194, 196}, {182, 184, 186, 188, 180}, {210, 212, 214, 216, 218}, {146, 148, 140, 142, 144}, {200, 202, 204, 206, 208}, {228, 220, 222, 224, 226}, {194, 196, 198, 190, 192}, {188, 180, 182, 184, 186}, {218, 210, 212, 214, 216}, {148, 140, 142, 144, 146}, {206, 208, 200, 202, 204}, {224, 226, 228, 220, 222}, {192, 194, 196, 198, 190}, {180, 182, 184, 186, 188}, {214, 216, 218, 210, 212}, {140, 142, 144, 146, 148}, {208, 200, 202, 204, 206}, {220, 222, 224, 226, 228}, {196, 198, 190, 192, 194}, {184, 186, 188, 180, 182}, {212, 214, 216, 218, 210}, {142, 144, 146, 148, 140}};
        this.computeBall();
        if (((Object)((Object)this)).getClass() == PwZomeGeom.class) {
            this.init();
        }
    }

    public void setGeometry(PgGeometry geom) {
        if (geom == null || !(geom instanceof PgElementSet)) {
            PsDebug.warning((String)"Geom is not a PgElementSet.");
            return;
        }
        super.setGeometry(geom);
        this.m_elementSet = (PgElementSet)geom;
        this.m_elementSet.setName("Zome ElementSet");
    }

    private void computeBall() {
        boolean bDetail = true;
        if (bDetail) {
            this.m_numSphereVertices = 360;
            this.m_numSphereFaces = 480;
            this.computeBall_detail();
        } else {
            this.m_numSphereVertices = 60;
            this.m_numSphereFaces = 62;
            this.computeBall_convHull();
        }
    }

    private void computeBall_convHull() {
        this.m_ball = new PgElementSet(3);
        this.m_ball.setNumVertices(this.m_numSphereVertices);
        this.m_ball.setDimOfElements(4);
        this.m_ball.setNumElements(this.m_numSphereFaces);
        this.m_ball = PwPlatonic.getSolid((int)4);
        PwTransform.rotate((PgPointSet)this.m_ball, (double)1.5707963267948966, (int)0);
        PwModel.rhombiTruncate((PgElementSet)this.m_ball, (double)0.5, (double)0.0);
        PuCleanMesh.identifyVertices((PgPointSet)this.m_ball, (double)1.0E-4);
        this.m_ball.projectToSphere(new PdVector(0.0, 0.0, 0.0), 1.0);
    }

    private void computeBall_detail() {
        this.m_ball = new PgElementSet(3);
        this.m_ball.setNumVertices(this.m_numSphereVertices);
        this.m_ball.setDimOfElements(4);
        this.m_ball.setNumElements(this.m_numSphereFaces);
        PgElementSet rid = PwPlatonic.getSolid((int)4);
        PwTransform.rotate((PgPointSet)rid, (double)1.5707963267948966, (int)0);
        PwModel.rhombiTruncate((PgElementSet)rid, (double)0.5, (double)0.0);
        PuCleanMesh.identifyVertices((PgPointSet)rid, (double)1.0E-4);
        rid.projectToSphere(new PdVector(0.0, 0.0, 0.0), 1.0);
        int ridNov = 60;
        int i = 0;
        while (i < ridNov) {
            PdVector vertex = this.m_ball.getVertex(i);
            vertex.copy(rid.getVertex(i));
            vertex.multScalar(this.scaleSphere);
            vertex = this.m_ball.getVertex(i + ridNov);
            vertex.copy(rid.getVertex(i));
            vertex.multScalar(this.scaleSphere * this.scaleInner);
            ++i;
        }
        int nextElementInd = 0;
        int nextVertexInd = 2 * ridNov;
        int ridNoe = 62;
        int i2 = 0;
        while (i2 < ridNoe) {
            PdVector normal = rid.getElementNormal(i2);
            PiVector element = rid.getElement(i2);
            PdVector vertex = rid.getVertex(element.m_data[0]);
            normal.normalize();
            normal.multScalar(PdVector.dot((PdVector)normal, (PdVector)vertex));
            normal.multScalar(this.scaleSphere * (1.0 - this.scaleInner));
            int elSize = element.getSize();
            int j = 0;
            while (j < elSize) {
                PdVector newVertex = this.m_ball.getVertex(nextVertexInd + j);
                newVertex.copy(this.m_ball.getVertex(element.m_data[j] + ridNov));
                newVertex.add(normal);
                PiVector newEl0 = this.m_ball.getElement(nextElementInd + 2 * j);
                newEl0.m_data[0] = element.m_data[j];
                newEl0.m_data[1] = element.m_data[(j + 1) % elSize];
                newEl0.m_data[2] = nextVertexInd + (j + 1) % elSize;
                newEl0.m_data[3] = nextVertexInd + j;
                PiVector newEl1 = this.m_ball.getElement(nextElementInd + 2 * j + 1);
                newEl1.m_data[0] = nextVertexInd + j;
                newEl1.m_data[1] = nextVertexInd + (j + 1) % elSize;
                newEl1.m_data[2] = ridNov + element.m_data[(j + 1) % elSize];
                newEl1.m_data[3] = ridNov + element.m_data[j];
                ++j;
            }
            nextVertexInd += elSize;
            nextElementInd += 2 * elSize;
            ++i2;
        }
        this.m_ball.makeNeighbour();
    }

    public PgElementSet computeGeometry(PgZomeSet zomeSet) {
        PgElementSet elSet = this.m_elementSet;
        if (elSet == null) {
            elSet = new PgElementSet(3);
            this.setGeometry((PgGeometry)elSet);
        }
        int nozv = zomeSet.getNumVertices();
        int nop = zomeSet.getNumPolygons();
        int nov = nozv * this.m_numSphereVertices;
        int numEl = nozv * this.m_numSphereFaces;
        int numRed = 0;
        int numYellow = 0;
        int numBlue = 0;
        int numGreen = 0;
        int numNve = nop;
        int i = 0;
        while (i < nop) {
            if (zomeSet.edgeIsVirtual(i)) {
                --numNve;
            } else {
                int color = zomeSet.getEdgeColor(i);
                if (color == 0) {
                    ++numRed;
                    numEl += 42;
                    nov += 10;
                } else if (color == 1) {
                    ++numYellow;
                    numEl += 26;
                    nov += 6;
                } else if (color == 2) {
                    ++numBlue;
                    numEl += 22;
                } else {
                    ++numGreen;
                    numEl += 40;
                    nov += 8;
                }
            }
            ++i;
        }
        i = 0;
        while (i < nozv) {
            if (zomeSet.vertexIsVirtual(i) && zomeSet.getNumVertices() > 1) {
                nov -= this.m_numSphereVertices;
                numEl -= this.m_numSphereFaces;
            }
            ++i;
        }
        int nextElInd = 0;
        int nextVertInd = 0;
        PiVector vIndexMap = new PiVector(nozv);
        elSet.setNumVertices(nov);
        elSet.setNumElements(numEl);
        elSet.assureElementColors();
        elSet.showElementColors(true);
        Color white = new Color(255, 255, 255);
        Color blue = PgZomeSet.EDGE_COLOR[2];
        Color red = PgZomeSet.EDGE_COLOR[0];
        Color yellow = PgZomeSet.EDGE_COLOR[1];
        Color green = PgZomeSet.EDGE_COLOR[3];
        elSet.showEdges(false);
        int nextMapIndex = 0;
        int i2 = 0;
        while (i2 < nozv) {
            if (zomeSet.vertexIsVirtual(i2) && zomeSet.getNumVertices() > 1) {
                vIndexMap.m_data[i2] = -1;
            } else {
                vIndexMap.m_data[i2] = nextMapIndex++;
                int j = 0;
                while (j < this.m_numSphereVertices) {
                    elSet.setVertex(vIndexMap.m_data[i2] * this.m_numSphereVertices + j, PdVector.copyNew((PdVector)this.m_ball.getVertex(j)));
                    elSet.getVertex(vIndexMap.m_data[i2] * this.m_numSphereVertices + j).add(zomeSet.getVertex(i2));
                    ++j;
                }
                j = 0;
                while (j < this.m_numSphereFaces) {
                    elSet.setElement(vIndexMap.m_data[i2] * this.m_numSphereFaces + j, PiVector.copyNew((PiVector)this.m_ball.getElement(j)));
                    elSet.getElement(vIndexMap.m_data[i2] * this.m_numSphereFaces + j).add(vIndexMap.m_data[i2] * this.m_numSphereVertices);
                    elSet.setNeighbour(vIndexMap.m_data[i2] * this.m_numSphereFaces + j, PiVector.copyNew((PiVector)this.m_ball.getNeighbour(j)));
                    elSet.getNeighbour(vIndexMap.m_data[i2] * this.m_numSphereFaces + j).add(vIndexMap.m_data[i2] * this.m_numSphereFaces);
                    elSet.setElementColor(vIndexMap.m_data[i2] * this.m_numSphereFaces + j, white);
                    ++j;
                }
                nextVertInd += this.m_numSphereVertices;
                nextElInd += this.m_numSphereFaces;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < nop) {
            if (!zomeSet.edgeIsVirtual(i2)) {
                int j;
                PiVector neigh1;
                PiVector neigh0;
                PiVector el0;
                PdVector diff;
                int color = zomeSet.getEdgeColor(i2);
                int direction = zomeSet.getEdgeDirection(i2);
                int vInd0 = zomeSet.getPolygon((int)i2).m_data[0];
                int vInd1 = zomeSet.getPolygon((int)i2).m_data[1];
                if (color == 0) {
                    diff = PdVector.subNew((PdVector)zomeSet.getVertex(vInd1), (PdVector)zomeSet.getVertex(vInd0));
                    double offset = diff.length();
                    offset -= 2.0 * this.scaleSphere;
                    offset -= 2.0 * this.m_apRed;
                    offset /= 2.0;
                    diff.normalize();
                    el0 = new PiVector(5);
                    PiVector el1 = new PiVector(5);
                    neigh0 = new PiVector(5);
                    neigh1 = new PiVector(5);
                    vInd0 = vIndexMap.m_data[vInd0];
                    vInd1 = vIndexMap.m_data[vInd1];
                    j = 0;
                    while (j < 5) {
                        elSet.setVertex(nextVertInd + j, PdVector.blendNew((double)1.0, (PdVector)elSet.getVertex(elSet.getElement((int)this.m_redInd[direction][j]).m_data[0] + vInd0 * this.m_numSphereVertices), (double)offset, (PdVector)diff));
                        elSet.setVertex(nextVertInd + 5 + j, PdVector.blendNew((double)1.0, (PdVector)elSet.getVertex(elSet.getElement((int)this.m_redInd[(direction + 6) % 12][j]).m_data[0] + vInd1 * this.m_numSphereVertices), (double)(-offset), (PdVector)diff));
                        el0.m_data[4 - j] = vInd0 * this.m_numSphereVertices + elSet.getElement((int)(this.m_redInd[direction][j] + 1)).m_data[2];
                        el1.m_data[4 - j] = vInd1 * this.m_numSphereVertices + elSet.getElement((int)(this.m_redInd[(direction + 6) % 12][j] + 1)).m_data[2];
                        neigh0.m_data[j] = 1 + (8 - j) % 5;
                        neigh1.m_data[j] = 36 + (8 - j) % 5;
                        elSet.setElement(nextElInd + 1 + j, PiVector.copyNew((PiVector)elSet.getElement(vInd0 * this.m_numSphereFaces + this.m_redInd[direction][j] + 1)));
                        elSet.getElement(nextElInd + 1 + j).invert();
                        elSet.setNeighbour(nextElInd + 1 + j, new PiVector(1 + (j + 1) % 5, 6 + j, 1 + (j + 4) % 5, 0));
                        elSet.setElement(nextElInd + 6 + j, PiVector.copyNew((PiVector)elSet.getElement(vInd0 * this.m_numSphereFaces + this.m_redInd[direction][j])));
                        elSet.getElement(nextElInd + 6 + j).invert();
                        elSet.setNeighbour(nextElInd + 6 + j, new PiVector(6 + (j + 1) % 5, 11 + j, 6 + (j + 4) % 5, 1 + j));
                        elSet.setElement(nextElInd + 11 + j, new PiVector(elSet.getElement((int)this.m_redInd[direction][j]).m_data[0] + vInd0 * this.m_numSphereVertices, elSet.getElement((int)this.m_redInd[direction][j]).m_data[1] + vInd0 * this.m_numSphereVertices, nextVertInd + (j + 1) % 5, nextVertInd + j));
                        elSet.setNeighbour(nextElInd + 11 + j, new PiVector(11 + (j + 1) % 5, 16 + j, 11 + (j + 4) % 5, 6 + j));
                        elSet.setElement(nextElInd + 16 + j, new PiVector(nextVertInd + j, nextVertInd + (j + 1) % 5, nextVertInd + 5 + (8 - j) % 5));
                        elSet.setNeighbour(nextElInd + 16 + j, new PiVector(21 + (7 - j) % 5, 21 + (8 - j) % 5, 11 + j));
                        elSet.setElement(nextElInd + 21 + j, new PiVector(nextVertInd + 5 + j, nextVertInd + 5 + (j + 1) % 5, nextVertInd + (8 - j) % 5));
                        elSet.setNeighbour(nextElInd + 21 + j, new PiVector(16 + (7 - j) % 5, 16 + (8 - j) % 5, 26 + j));
                        elSet.setElement(nextElInd + 26 + j, new PiVector(elSet.getElement((int)this.m_redInd[(direction + 6) % 12][j]).m_data[0] + vInd1 * this.m_numSphereVertices, elSet.getElement((int)this.m_redInd[(direction + 6) % 12][j]).m_data[1] + vInd1 * this.m_numSphereVertices, nextVertInd + 5 + (j + 1) % 5, nextVertInd + 5 + j % 5));
                        elSet.setNeighbour(nextElInd + 26 + j, new PiVector(26 + (j + 1) % 5, 21 + j, 26 + (j + 4) % 5, 31 + j));
                        elSet.setElement(nextElInd + 31 + j, PiVector.copyNew((PiVector)elSet.getElement(vInd1 * this.m_numSphereFaces + this.m_redInd[(direction + 6) % 12][j])));
                        elSet.getElement(nextElInd + 31 + j).invert();
                        elSet.setNeighbour(nextElInd + 31 + j, new PiVector(31 + (j + 1) % 5, 26 + j, 31 + (j + 4) % 5, 36 + j));
                        elSet.setElement(nextElInd + 36 + j, PiVector.copyNew((PiVector)elSet.getElement(vInd1 * this.m_numSphereFaces + this.m_redInd[(direction + 6) % 12][j] + 1)));
                        elSet.getElement(nextElInd + 36 + j).invert();
                        elSet.setNeighbour(nextElInd + 36 + j, new PiVector(36 + (j + 1) % 5, 31 + j, 36 + (j + 4) % 5, 41));
                        ++j;
                    }
                    elSet.setElement(nextElInd, el0);
                    elSet.setElement(nextElInd + 41, el1);
                    elSet.setNeighbour(nextElInd, neigh0);
                    elSet.setNeighbour(nextElInd + 41, neigh1);
                    j = 0;
                    while (j < 42) {
                        elSet.getNeighbour(nextElInd + j).add(nextElInd);
                        elSet.setElementColor(nextElInd + j, red);
                        ++j;
                    }
                    nextVertInd += 10;
                    nextElInd += 42;
                } else if (color == 1) {
                    diff = PdVector.subNew((PdVector)zomeSet.getVertex(vInd1), (PdVector)zomeSet.getVertex(vInd0));
                    double offset = diff.length();
                    offset -= 2.0 * this.scaleSphere;
                    offset -= 2.0 * this.m_apYellow;
                    offset /= 2.0;
                    diff.normalize();
                    el0 = new PiVector(3);
                    PiVector el1 = new PiVector(3);
                    neigh0 = new PiVector(3);
                    neigh1 = new PiVector(3);
                    vInd0 = vIndexMap.m_data[vInd0];
                    vInd1 = vIndexMap.m_data[vInd1];
                    j = 0;
                    while (j < 3) {
                        elSet.setVertex(nextVertInd + j, PdVector.blendNew((double)1.0, (PdVector)elSet.getVertex(elSet.getElement((int)this.m_yellowInd[direction][j]).m_data[0] + vInd0 * this.m_numSphereVertices), (double)offset, (PdVector)diff));
                        elSet.setVertex(nextVertInd + 3 + j, PdVector.blendNew((double)1.0, (PdVector)elSet.getVertex(elSet.getElement((int)this.m_yellowInd[(direction + 10) % 20][j]).m_data[0] + vInd1 * this.m_numSphereVertices), (double)(-offset), (PdVector)diff));
                        el0.m_data[2 - j] = vInd0 * this.m_numSphereVertices + elSet.getElement((int)(this.m_yellowInd[direction][j] + 1)).m_data[2];
                        el1.m_data[2 - j] = vInd1 * this.m_numSphereVertices + elSet.getElement((int)(this.m_yellowInd[(direction + 10) % 20][j] + 1)).m_data[2];
                        neigh0.m_data[j] = 1 + (4 - j) % 3;
                        neigh1.m_data[j] = 22 + (4 - j) % 3;
                        elSet.setElement(nextElInd + 1 + j, PiVector.copyNew((PiVector)elSet.getElement(vInd0 * this.m_numSphereFaces + this.m_yellowInd[direction][j] + 1)));
                        elSet.getElement(nextElInd + 1 + j).invert();
                        elSet.setNeighbour(nextElInd + 1 + j, new PiVector(1 + (j + 1) % 3, 4 + j, 1 + (j + 2) % 3, 0));
                        elSet.setElement(nextElInd + 4 + j, PiVector.copyNew((PiVector)elSet.getElement(vInd0 * this.m_numSphereFaces + this.m_yellowInd[direction][j])));
                        elSet.getElement(nextElInd + 4 + j).invert();
                        elSet.setNeighbour(nextElInd + 4 + j, new PiVector(4 + (j + 1) % 3, 7 + j, 4 + (j + 2) % 3, 1 + j));
                        elSet.setElement(nextElInd + 7 + j, new PiVector(elSet.getElement((int)this.m_yellowInd[direction][j]).m_data[0] + vInd0 * this.m_numSphereVertices, elSet.getElement((int)this.m_yellowInd[direction][j]).m_data[1] + vInd0 * this.m_numSphereVertices, nextVertInd + (j + 1) % 3, nextVertInd + j));
                        elSet.setNeighbour(nextElInd + 7 + j, new PiVector(7 + (j + 1) % 3, 10 + j, 7 + (j + 2) % 3, 4 + j));
                        elSet.setElement(nextElInd + 10 + j, new PiVector(nextVertInd + j, nextVertInd + (j + 1) % 3, nextVertInd + 3 + (5 - j) % 3));
                        elSet.setNeighbour(nextElInd + 10 + j, new PiVector(13 + (4 - j) % 3, 13 + (2 - j) % 3, 7 + j));
                        elSet.setElement(nextElInd + 13 + j, new PiVector(nextVertInd + 3 + j, nextVertInd + 3 + (j + 1) % 3, nextVertInd + (5 - j) % 3));
                        elSet.setNeighbour(nextElInd + 13 + j, new PiVector(10 + (4 - j) % 3, 10 + (2 - j) % 3, 16 + j));
                        elSet.setElement(nextElInd + 16 + j, new PiVector(elSet.getElement((int)this.m_yellowInd[(direction + 10) % 20][j]).m_data[0] + vInd1 * this.m_numSphereVertices, elSet.getElement((int)this.m_yellowInd[(direction + 10) % 20][j]).m_data[1] + vInd1 * this.m_numSphereVertices, nextVertInd + 3 + (j + 1) % 3, nextVertInd + 3 + j % 3));
                        elSet.setNeighbour(nextElInd + 16 + j, new PiVector(16 + (j + 1) % 3, 13 + j, 16 + (j + 2) % 3, 19 + j));
                        elSet.setElement(nextElInd + 19 + j, PiVector.copyNew((PiVector)elSet.getElement(vInd1 * this.m_numSphereFaces + this.m_yellowInd[(direction + 10) % 20][j])));
                        elSet.getElement(nextElInd + 19 + j).invert();
                        elSet.setNeighbour(nextElInd + 19 + j, new PiVector(19 + (j + 1) % 3, 16 + j, 19 + (j + 2) % 3, 22 + j));
                        elSet.setElement(nextElInd + 22 + j, PiVector.copyNew((PiVector)elSet.getElement(vInd1 * this.m_numSphereFaces + this.m_yellowInd[(direction + 10) % 20][j] + 1)));
                        elSet.getElement(nextElInd + 22 + j).invert();
                        elSet.setNeighbour(nextElInd + 22 + j, new PiVector(22 + (j + 1) % 3, 19 + j, 22 + (j + 2) % 3, 25));
                        ++j;
                    }
                    elSet.setElement(nextElInd, el0);
                    elSet.setElement(nextElInd + 25, el1);
                    elSet.setNeighbour(nextElInd, neigh0);
                    elSet.setNeighbour(nextElInd + 25, neigh1);
                    j = 0;
                    while (j < 26) {
                        elSet.getNeighbour(nextElInd + j).add(nextElInd);
                        elSet.setElementColor(nextElInd + j, yellow);
                        ++j;
                    }
                    nextVertInd += 6;
                    nextElInd += 26;
                } else if (color == 2) {
                    PiVector el02 = new PiVector(4);
                    PiVector el1 = new PiVector(4);
                    PiVector neigh02 = new PiVector(4);
                    PiVector neigh12 = new PiVector(4);
                    vInd0 = vIndexMap.m_data[vInd0];
                    vInd1 = vIndexMap.m_data[vInd1];
                    int j2 = 0;
                    while (j2 < 4) {
                        el02.m_data[3 - j2] = vInd0 * this.m_numSphereVertices + elSet.getElement((int)(this.m_blueInd[direction][j2] + 1)).m_data[2];
                        el1.m_data[3 - j2] = vInd1 * this.m_numSphereVertices + elSet.getElement((int)(this.m_blueInd[(direction + 15) % 30][j2] + 1)).m_data[2];
                        neigh02.m_data[j2] = 1 + (6 - j2) % 4;
                        neigh12.m_data[j2] = 17 + (6 - j2) % 4;
                        elSet.setElement(nextElInd + 1 + j2, PiVector.copyNew((PiVector)elSet.getElement(vInd0 * this.m_numSphereFaces + this.m_blueInd[direction][j2] + 1)));
                        elSet.getElement(nextElInd + 1 + j2).invert();
                        elSet.setNeighbour(nextElInd + 1 + j2, new PiVector(1 + (j2 + 1) % 4, 5 + j2, 1 + (j2 + 3) % 4, 0));
                        elSet.setElement(nextElInd + 5 + j2, PiVector.copyNew((PiVector)elSet.getElement(vInd0 * this.m_numSphereFaces + this.m_blueInd[direction][j2])));
                        elSet.getElement(nextElInd + 5 + j2).invert();
                        elSet.setNeighbour(nextElInd + 5 + j2, new PiVector(5 + (j2 + 1) % 4, 9 + j2, 5 + (j2 + 3) % 4, 1 + j2));
                        elSet.setElement(nextElInd + 9 + j2, new PiVector(elSet.getElement((int)this.m_blueInd[direction][j2]).m_data[0] + vInd0 * this.m_numSphereVertices, elSet.getElement((int)this.m_blueInd[direction][j2]).m_data[1] + vInd0 * this.m_numSphereVertices, elSet.getElement((int)this.m_blueInd[(direction + 15) % 30][(6 - j2) % 4]).m_data[0] + vInd1 * this.m_numSphereVertices, elSet.getElement((int)this.m_blueInd[(direction + 15) % 30][(6 - j2) % 4]).m_data[1] + vInd1 * this.m_numSphereVertices));
                        elSet.setNeighbour(nextElInd + 9 + j2, new PiVector(9 + (j2 + 1) % 4, 13 + (6 - j2) % 4, 9 + (j2 + 3) % 4, 5 + j2));
                        elSet.setElement(nextElInd + 13 + j2, PiVector.copyNew((PiVector)elSet.getElement(vInd1 * this.m_numSphereFaces + this.m_blueInd[(direction + 15) % 30][j2])));
                        elSet.getElement(nextElInd + 13 + j2).invert();
                        elSet.setNeighbour(nextElInd + 13 + j2, new PiVector(13 + (j2 + 1) % 4, 9 + (6 - j2) % 4, 13 + (j2 + 3) % 4, 17 + j2));
                        elSet.setElement(nextElInd + 17 + j2, PiVector.copyNew((PiVector)elSet.getElement(vInd1 * this.m_numSphereFaces + this.m_blueInd[(direction + 15) % 30][j2] + 1)));
                        elSet.getElement(nextElInd + 17 + j2).invert();
                        elSet.setNeighbour(nextElInd + 17 + j2, new PiVector(17 + (j2 + 1) % 4, 13 + j2, 17 + (j2 + 3) % 4, 21));
                        ++j2;
                    }
                    elSet.setElement(nextElInd, el02);
                    elSet.setElement(nextElInd + 21, el1);
                    elSet.setNeighbour(nextElInd, neigh02);
                    elSet.setNeighbour(nextElInd + 21, neigh12);
                    j2 = 0;
                    while (j2 < 22) {
                        elSet.getNeighbour(nextElInd + j2).add(nextElInd);
                        elSet.setElementColor(nextElInd + j2, blue);
                        ++j2;
                    }
                    nextElInd += 22;
                } else {
                    diff = PdVector.subNew((PdVector)zomeSet.getVertex(vInd1), (PdVector)zomeSet.getVertex(vInd0));
                    diff.normalize();
                    diff.multScalar(this.m_apGreen);
                    PiVector el03 = new PiVector(5);
                    PiVector el1 = new PiVector(5);
                    PiVector neigh03 = new PiVector(5);
                    PiVector neigh13 = new PiVector(5);
                    PdVector center0 = zomeSet.getVertex(vInd0);
                    diff.add(center0);
                    vInd0 = vIndexMap.m_data[vInd0];
                    vInd1 = vIndexMap.m_data[vInd1];
                    PdVector fCenter = PdVector.blendNew((double)0.5, (PdVector)elSet.getVertex(elSet.getElement((int)this.m_greenInd[direction][2]).m_data[0] + vInd0 * this.m_numSphereVertices), (double)0.5, (PdVector)elSet.getVertex(elSet.getElement((int)this.m_greenInd[direction][4]).m_data[0] + vInd0 * this.m_numSphereVertices));
                    diff.sub(fCenter);
                    j = 0;
                    while (j < 3) {
                        elSet.setVertex(nextVertInd + j, PdVector.addNew((PdVector)elSet.getVertex(elSet.getElement((int)this.m_greenInd[direction][2 + j]).m_data[0] + vInd0 * this.m_numSphereVertices), (PdVector)diff));
                        elSet.setVertex(nextVertInd + 4 + j, PdVector.subNew((PdVector)elSet.getVertex(elSet.getElement((int)this.m_greenInd[(direction + 30) % 60][2 + j]).m_data[0] + vInd1 * this.m_numSphereVertices), (PdVector)diff));
                        ++j;
                    }
                    elSet.setVertex(nextVertInd + 3, PdVector.subNew((PdVector)elSet.getVertex(nextVertInd), (PdVector)elSet.getVertex(nextVertInd + 1)));
                    elSet.getVertex(nextVertInd + 3).add(elSet.getVertex(nextVertInd + 2));
                    elSet.setVertex(nextVertInd + 7, PdVector.subNew((PdVector)elSet.getVertex(nextVertInd + 4), (PdVector)elSet.getVertex(nextVertInd + 5)));
                    elSet.getVertex(nextVertInd + 7).add(elSet.getVertex(nextVertInd + 6));
                    j = 0;
                    while (j < 5) {
                        el03.m_data[4 - j] = vInd0 * this.m_numSphereVertices + elSet.getElement((int)(this.m_greenInd[direction][j] + 1)).m_data[2];
                        el1.m_data[4 - j] = vInd1 * this.m_numSphereVertices + elSet.getElement((int)(this.m_greenInd[(direction + 30) % 60][j] + 1)).m_data[2];
                        neigh03.m_data[j] = 1 + (8 - j) % 5;
                        neigh13.m_data[j] = 34 + (8 - j) % 5;
                        elSet.setElement(nextElInd + 1 + j, PiVector.copyNew((PiVector)elSet.getElement(vInd0 * this.m_numSphereFaces + this.m_greenInd[direction][j] + 1)));
                        elSet.getElement(nextElInd + 1 + j).invert();
                        elSet.setNeighbour(nextElInd + 1 + j, new PiVector(1 + (j + 1) % 5, 6 + j, 1 + (j + 4) % 5, 0));
                        elSet.setElement(nextElInd + 6 + j, PiVector.copyNew((PiVector)elSet.getElement(vInd0 * this.m_numSphereFaces + this.m_greenInd[direction][j])));
                        elSet.getElement(nextElInd + 6 + j).invert();
                        if (j == 2 || j == 3) {
                            elSet.setNeighbour(nextElInd + 6 + j, new PiVector(6 + (j + 1) % 5, 9 + j, 6 + (j + 4) % 5, 1 + j));
                        } else {
                            elSet.setNeighbour(nextElInd + 6 + j, new PiVector(6 + (j + 1) % 5, 15 + (j + 1) % 5, 6 + (j + 4) % 5, 1 + j));
                        }
                        elSet.setElement(nextElInd + 29 + j, PiVector.copyNew((PiVector)elSet.getElement(vInd1 * this.m_numSphereFaces + this.m_greenInd[(direction + 30) % 60][j])));
                        elSet.getElement(nextElInd + 29 + j).invert();
                        if (j == 2 || j == 3) {
                            elSet.setNeighbour(nextElInd + 29 + j, new PiVector(29 + (j + 1) % 5, 20 + j, 29 + (j + 4) % 5, 34 + j));
                        } else {
                            elSet.setNeighbour(nextElInd + 29 + j, new PiVector(29 + (j + 1) % 5, 26 + (j + 1) % 5, 29 + (j + 4) % 5, 34 + j));
                        }
                        elSet.setElement(nextElInd + 34 + j, PiVector.copyNew((PiVector)elSet.getElement(vInd1 * this.m_numSphereFaces + this.m_greenInd[(direction + 30) % 60][j] + 1)));
                        elSet.getElement(nextElInd + 34 + j).invert();
                        elSet.setNeighbour(nextElInd + 34 + j, new PiVector(34 + (j + 1) % 5, 29 + j, 34 + (j + 4) % 5, 39));
                        ++j;
                    }
                    elSet.setElement(nextElInd, el03);
                    elSet.setElement(nextElInd + 39, el1);
                    elSet.setNeighbour(nextElInd, neigh03);
                    elSet.setNeighbour(nextElInd + 39, neigh13);
                    j = 0;
                    while (j < 2) {
                        elSet.setElement(nextElInd + 11 + j, new PiVector(vInd0 * this.m_numSphereVertices + elSet.getElement((int)this.m_greenInd[direction][2 + j]).m_data[0], vInd0 * this.m_numSphereVertices + elSet.getElement((int)this.m_greenInd[direction][2 + j]).m_data[1], nextVertInd + 1 + j, nextVertInd + j));
                        elSet.setNeighbour(nextElInd + 11 + j, new PiVector(12 + 3 * j, 18 + j, 17 - 6 * j, 8 + j));
                        elSet.setElement(nextElInd + 13 + j, new PiVector(vInd0 * this.m_numSphereVertices + elSet.getElement((int)this.m_greenInd[direction][j]).m_data[0], nextVertInd + (3 + j) % 4, nextVertInd + 2 + j));
                        elSet.setNeighbour(nextElInd + 13 + j, new PiVector(20 + j, 15 + j, 16 + j));
                        elSet.setElement(nextElInd + 22 + j, new PiVector(vInd1 * this.m_numSphereVertices + elSet.getElement((int)this.m_greenInd[(direction + 30) % 60][2 + j]).m_data[0], vInd1 * this.m_numSphereVertices + elSet.getElement((int)this.m_greenInd[(direction + 30) % 60][2 + j]).m_data[1], nextVertInd + 5 + j, nextVertInd + 4 + j));
                        elSet.setNeighbour(nextElInd + 22 + j, new PiVector(23 + 3 * j, 21 - j, 28 - 6 * j, 31 + j));
                        elSet.setElement(nextElInd + 24 + j, new PiVector(vInd1 * this.m_numSphereVertices + elSet.getElement((int)this.m_greenInd[(direction + 30) % 60][j]).m_data[0], nextVertInd + 4 + (3 + j) % 4, nextVertInd + 6 + j));
                        elSet.setNeighbour(nextElInd + 24 + j, new PiVector(19 - j, 26 + j, 27 + j));
                        ++j;
                    }
                    j = 0;
                    while (j < 3) {
                        elSet.setElement(nextElInd + 15 + j, new PiVector(vInd0 * this.m_numSphereVertices + elSet.getElement((int)this.m_greenInd[direction][(j + 4) % 5]).m_data[0], vInd0 * this.m_numSphereVertices + elSet.getElement((int)this.m_greenInd[direction][(j + 4) % 5]).m_data[1], nextVertInd + (2 + j) % 4));
                        elSet.setElement(nextElInd + 26 + j, new PiVector(vInd1 * this.m_numSphereVertices + elSet.getElement((int)this.m_greenInd[(direction + 30) % 60][(j + 4) % 5]).m_data[0], vInd1 * this.m_numSphereVertices + elSet.getElement((int)this.m_greenInd[(direction + 30) % 60][(j + 4) % 5]).m_data[1], nextVertInd + 4 + (2 + j) % 4));
                        ++j;
                    }
                    elSet.setNeighbour(nextElInd + 15, new PiVector(13, 12, 10));
                    elSet.setNeighbour(nextElInd + 16, new PiVector(14, 13, 6));
                    elSet.setNeighbour(nextElInd + 17, new PiVector(11, 14, 7));
                    elSet.setNeighbour(nextElInd + 26, new PiVector(24, 23, 33));
                    elSet.setNeighbour(nextElInd + 27, new PiVector(25, 24, 29));
                    elSet.setNeighbour(nextElInd + 28, new PiVector(22, 25, 30));
                    j = 0;
                    while (j < 4) {
                        elSet.setElement(nextElInd + 18 + j, new PiVector(nextVertInd + j, nextVertInd + (j + 1) % 4, nextVertInd + 4 + (7 - j) % 4, nextVertInd + 4 + (8 - j) % 4));
                        elSet.setNeighbour(nextElInd + 18 + j, new PiVector(18 + (1 + j) % 4, 25 - j, 18 + (3 + j) % 4, 11 + j));
                        ++j;
                    }
                    j = 0;
                    while (j < 40) {
                        elSet.getNeighbour(nextElInd + j).add(nextElInd);
                        elSet.setElementColor(nextElInd + j, green);
                        ++j;
                    }
                    nextVertInd += 8;
                    nextElInd += 40;
                }
            }
            ++i2;
        }
        PwCleanMesh.splitNonManifoldVertices((PgElementSet)elSet);
        if (this.m_explodeParam != 0.0) {
            PiVector elToComponent = new PiVector(numEl);
            PdVector[] componentCenter = PdVector.realloc(null, (int)(nozv + numNve), (int)3);
            int i3 = 0;
            while (i3 < nozv) {
                if (vIndexMap.m_data[i3] != -1) {
                    int j = 0;
                    while (j < this.m_numSphereFaces) {
                        elToComponent.m_data[vIndexMap.m_data[i3] * this.m_numSphereFaces + j] = vIndexMap.m_data[i3];
                        componentCenter[vIndexMap.m_data[i3]].copy(zomeSet.getVertex(i3));
                        ++j;
                    }
                }
                ++i3;
            }
            nextElInd = nextMapIndex * this.m_numSphereFaces;
            int nextComponentIndex = nextMapIndex;
            int i4 = 0;
            while (i4 < nop) {
                if (!zomeSet.edgeIsVirtual(i4)) {
                    int j;
                    int color = zomeSet.getEdgeColor(i4);
                    int vInd0 = zomeSet.getPolygon((int)i4).m_data[0];
                    int vInd1 = zomeSet.getPolygon((int)i4).m_data[1];
                    componentCenter[nextComponentIndex].blend(0.5, zomeSet.getVertex(vInd0), 0.5, zomeSet.getVertex(vInd1));
                    if (color == 0) {
                        j = 0;
                        while (j < 42) {
                            elToComponent.m_data[nextElInd + j] = nextComponentIndex;
                            ++j;
                        }
                        nextElInd += 42;
                    } else if (color == 1) {
                        j = 0;
                        while (j < 26) {
                            elToComponent.m_data[nextElInd + j] = nextComponentIndex;
                            ++j;
                        }
                        nextElInd += 26;
                    } else if (color == 2) {
                        j = 0;
                        while (j < 22) {
                            elToComponent.m_data[nextElInd + j] = nextComponentIndex;
                            ++j;
                        }
                        nextElInd += 22;
                    } else {
                        j = 0;
                        while (j < 40) {
                            elToComponent.m_data[nextElInd + j] = nextComponentIndex;
                            ++j;
                        }
                        nextElInd += 40;
                    }
                    ++nextComponentIndex;
                }
                ++i4;
            }
            int nv = elSet.getNumVertices();
            PiVector vertexToComponent = new PiVector(nv);
            int i5 = 0;
            while (i5 < nextElInd) {
                PiVector el = elSet.getElement(i5);
                int elSize = el.getSize();
                int j = 0;
                while (j < elSize) {
                    vertexToComponent.m_data[el.m_data[j]] = elToComponent.m_data[i5];
                    ++j;
                }
                ++i5;
            }
            i5 = 0;
            while (i5 < numNve) {
                componentCenter[i5].sub(componentCenter[0]);
                ++i5;
            }
            i5 = 0;
            while (i5 < nv) {
                elSet.getVertex(i5).blendBase(elSet.getVertex(i5), this.m_explodeParam, componentCenter[vertexToComponent.m_data[i5]]);
                ++i5;
            }
        }
        elSet.makeElementNormals();
        return elSet;
    }
}

