/*
 * Decompiled with CFR 0.152.
 */
package devZomeView;

import devZomeView.PwZomeEditor;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.number.PiArray_IP;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.vecmath.PiVector;
import jvx.project.PjWorkshop_IP;

public class PwZomeEditor_IP
extends PjWorkshop_IP
implements ActionListener,
ItemListener {
    private static final boolean m_bHistory = true;
    private static final boolean bShowInfo = false;
    protected Button m_bStepBack;
    protected Button m_bStepForward;
    protected Button m_bSaveScript;
    protected Button m_bLoadScript;
    protected PwZomeEditor m_pwEditor = null;
    protected int m_maxNumVisibleEdges = 4;
    private static String[] m_treeHeader = new String[]{"Start", "Color", "Length", "Direction", "Target", "Virtual"};
    protected PiArray_IP m_treePanel;
    private static final int EDIT = 0;
    private static final int SELECT_EDGE = 1;
    private static final int SELECT_BLUE_REFLECTION = 2;
    private static final int SELECT_SYMMETRY_DIRECTION = 3;
    private static final int SELECT_TRANSFORMATION = 4;
    private static final int SELECT_RESTRICTION = 5;
    private int m_mode = 0;
    private int m_majorMode_save;
    protected Button m_bClearSelections;
    protected Button m_bClearGeometry;
    protected Button m_bSelectRestriction = new Button(this.m_bSelectRestrictionName0);
    protected String m_bSelectRestrictionName0 = "Restrict directions";
    protected String m_bSelectRestrictionName1 = "Confirm Normal";
    protected String m_bSelectRestrictionName2 = "Remove Restriction";
    protected TextField m_tRestriction;
    private static final String NO_RESTRICTION = "none";
    protected Button m_bSelectorAddEdge;
    protected String m_bSelectorAddEdgeName0 = "Add Edge";
    protected String m_bSelectorAddEdgeName1 = "Confirm";
    protected Button m_bSelectorParallelCopyAll;
    protected String m_bParallelCopyAllName0 = "Parallel Copy All";
    protected String m_bParallelCopyAllName1 = "Confirm";
    protected Button m_bSelectorParallelCopySel;
    protected String m_bParallelCopySelName0 = "Parallel Copy Sel.";
    protected String m_bParallelCopySelName1 = "Confirm";
    protected Button m_bRemoveDuplicateEdges;
    protected Button m_bSplitSelectedEdges;
    protected Checkbox m_cEditSelected;
    protected Button m_bSelectEqualEdges;
    protected Button m_bEdgeSymmetry;
    protected String m_bEdgeSymmetryName0 = "Fix Edge Sym.";
    protected String m_bEdgeSymmetryName1 = "Confirm";
    protected Button m_bAllSymmetry;
    protected Button m_bPointReflect;
    protected Button m_bPlaneReflect;
    protected String m_bPlaneReflectName0 = "Plane Reflect";
    protected String m_bPlaneReflectName1 = "Confirm";
    protected Button m_bMakeVirtual;
    protected Button m_bMakeSolid;
    protected Button m_bConnectPoints;
    protected Button m_bCloseCycle;
    protected Button m_bSetSelectedToRoot;
    protected Button m_bAddOffsetCopy;
    protected Checkbox m_cOrientedOnly;
    protected Button m_bAddTransforCopy;
    protected String m_bAddTransforCopyName0 = "Transform Copy";
    protected String m_bAddTransforCopyName1 = "Confirm";
    protected Button m_bScaleUp;
    protected String m_bScaleUpName0 = "Scale Up Sel.";
    protected String m_bScaleUpName1 = "Scale Up";
    protected String m_bScaleUpName2 = "Next";
    protected Button m_bScaleDown;
    protected String m_bScaleDownName0 = "Scale Down Sel.";
    protected String m_bScaleDownName1 = "Scale Down";
    protected String m_bScaleDownName2 = "Previous";
    protected Button m_bStoreTree;
    protected Button m_bLoadTree;
    protected TextField m_tTreeFileName;
    protected TextField m_tScriptFileName;
    protected Button m_bPartsList;
    protected PuInteger m_currentEdgeSlider;
    protected PuInteger m_startIndexSlider;
    protected Checkbox m_cRed;
    protected Checkbox m_cYellow;
    protected Checkbox m_cBlue;
    protected Checkbox m_cGreen;
    protected Checkbox m_cHalfGreen;
    protected PuInteger m_lengthSlider;
    protected PuInteger m_directionSlider;
    protected Color m_bgColorRed;
    protected Color m_bgColorYellow;
    protected Color m_bgColorGray;
    protected Color m_bgColor;
    protected Checkbox m_cShowAsElementSet;
    protected PuDouble m_explodeParam;

    public PwZomeEditor_IP() {
        this.m_bSelectRestriction.addActionListener(this);
        this.m_tRestriction = new TextField(9);
        this.m_tRestriction.setText(NO_RESTRICTION);
        this.m_tRestriction.setEditable(false);
        this.m_bRemoveDuplicateEdges = new Button("Rem. Dupl. Edges");
        this.m_bRemoveDuplicateEdges.addActionListener(this);
        this.m_bSplitSelectedEdges = new Button("Split Sel. Edges");
        this.m_bSplitSelectedEdges.addActionListener(this);
        this.m_bSelectorAddEdge = new Button(this.m_bSelectorAddEdgeName0);
        this.m_bSelectorAddEdge.addActionListener(this);
        this.m_bSelectorParallelCopySel = new Button(this.m_bParallelCopySelName0);
        this.m_bSelectorParallelCopySel.addActionListener(this);
        this.m_bSelectorParallelCopyAll = new Button(this.m_bParallelCopyAllName0);
        this.m_bSelectorParallelCopyAll.addActionListener(this);
        this.m_cEditSelected = new Checkbox("Edit Sel. Edges", false);
        this.m_cEditSelected.addItemListener(this);
        this.m_bSelectEqualEdges = new Button("Sel. Eq. Edges");
        this.m_bSelectEqualEdges.addActionListener(this);
        this.m_cOrientedOnly = new Checkbox("Oriented only");
        this.m_bEdgeSymmetry = new Button(this.m_bEdgeSymmetryName0);
        this.m_bEdgeSymmetry.addActionListener(this);
        this.m_bAllSymmetry = new Button("Fix Point Sym.");
        this.m_bAllSymmetry.addActionListener(this);
        this.m_bPointReflect = new Button("Point Reflection");
        this.m_bPointReflect.addActionListener(this);
        this.m_bPlaneReflect = new Button(this.m_bPlaneReflectName0);
        this.m_bPlaneReflect.addActionListener(this);
        this.m_bMakeVirtual = new Button("Make Virtual Sel.");
        this.m_bMakeVirtual.addActionListener(this);
        this.m_bMakeSolid = new Button("Make Solid Sel.");
        this.m_bMakeSolid.addActionListener(this);
        this.m_bConnectPoints = new Button("Connect Sel. Points");
        this.m_bConnectPoints.addActionListener(this);
        this.m_bCloseCycle = new Button("Close Cycle");
        this.m_bCloseCycle.addActionListener(this);
        this.m_bSetSelectedToRoot = new Button("Set Root to Sel. Point");
        this.m_bSetSelectedToRoot.addActionListener(this);
        this.m_bAddOffsetCopy = new Button("Offset Copy");
        this.m_bAddOffsetCopy.addActionListener(this);
        this.m_bAddTransforCopy = new Button(this.m_bAddTransforCopyName0);
        this.m_bAddTransforCopy.addActionListener(this);
        this.m_currentEdgeSlider = new PuInteger("Current Edge Index", (PsUpdateIf)this);
        this.m_currentEdgeSlider.setDefBounds(0, 0, 1, 10);
        this.m_currentEdgeSlider.setDefValue(0);
        this.m_currentEdgeSlider.init();
        this.m_startIndexSlider = new PuInteger("Start edge index", (PsUpdateIf)this);
        this.m_startIndexSlider.setDefBounds(-1, -1, 1, 1);
        this.m_startIndexSlider.setValue(-1);
        this.m_startIndexSlider.init();
        CheckboxGroup cbgColor = new CheckboxGroup();
        this.m_cRed = new Checkbox("Red", true, cbgColor);
        this.m_cRed.addItemListener(this);
        this.m_cYellow = new Checkbox("Yellow", false, cbgColor);
        this.m_cYellow.addItemListener(this);
        this.m_cBlue = new Checkbox("Blue", false, cbgColor);
        this.m_cBlue.addItemListener(this);
        this.m_cGreen = new Checkbox("Green", false, cbgColor);
        this.m_cGreen.addItemListener(this);
        this.m_cHalfGreen = new Checkbox("Half Green", false, cbgColor);
        this.m_cHalfGreen.addItemListener(this);
        this.m_lengthSlider = new PuInteger("Edge Length", (PsUpdateIf)this);
        this.m_lengthSlider.setDefBounds(0, 3, 1, 1);
        this.m_lengthSlider.setValue(0);
        this.m_lengthSlider.init();
        this.m_directionSlider = new PuInteger("Direction", (PsUpdateIf)this);
        this.m_directionSlider.setDefBounds(0, 11, 1, 6);
        this.m_directionSlider.setValue(0);
        this.m_directionSlider.init();
        this.m_bScaleUp = new Button(this.m_bScaleUpName0);
        this.m_bScaleUp.addActionListener(this);
        this.m_bScaleDown = new Button(this.m_bScaleDownName0);
        this.m_bScaleDown.addActionListener(this);
        this.m_bStoreTree = new Button("Save");
        this.m_bStoreTree.addActionListener(this);
        this.m_bLoadTree = new Button("Load");
        this.m_bLoadTree.addActionListener(this);
        this.m_tTreeFileName = new TextField(16);
        this.m_bPartsList = new Button("Parts Report");
        this.m_bPartsList.addActionListener(this);
        this.m_cShowAsElementSet = new Checkbox("ElSet");
        this.m_cShowAsElementSet.addItemListener(this);
        this.m_explodeParam = new PuDouble("Explode Param", (PsUpdateIf)this);
        this.m_explodeParam.setDefBounds(0.0, 1.0, 0.01, 0.1);
        this.m_explodeParam.setDefValue(0.0);
        this.m_explodeParam.init();
        this.m_bClearSelections = new Button("Deselect all");
        this.m_bClearSelections.addActionListener(this);
        this.m_bClearGeometry = new Button("Remove all Edges");
        this.m_bClearGeometry.addActionListener(this);
        this.m_bStepBack = new Button("Step Back");
        this.m_bStepBack.addActionListener(this);
        this.m_bStepForward = new Button("Step Forward");
        this.m_bStepForward.addActionListener(this);
        this.m_bSaveScript = new Button("Save Script");
        this.m_bSaveScript.addActionListener(this);
        this.m_bLoadScript = new Button("Load Script");
        this.m_bLoadScript.addActionListener(this);
        this.m_tScriptFileName = new TextField(16);
        if (this.getClass() == PwZomeEditor_IP.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        PsPanel restrictionPanel = new PsPanel((LayoutManager)new GridLayout(1, 2));
        restrictionPanel.add((Component)this.m_bSelectRestriction);
        restrictionPanel.add((Component)this.m_tRestriction);
        this.add((Component)restrictionPanel);
        PsPanel pCol = new PsPanel((LayoutManager)new GridLayout(1, 5));
        pCol.add((Component)this.m_cRed);
        pCol.add((Component)this.m_cYellow);
        pCol.add((Component)this.m_cBlue);
        pCol.add((Component)this.m_cGreen);
        pCol.add((Component)this.m_cHalfGreen);
        this.add((Component)pCol);
        PsPanel bpVirtual = new PsPanel((LayoutManager)new FlowLayout());
        bpVirtual.add((Component)this.m_bMakeVirtual);
        bpVirtual.add((Component)this.m_bMakeSolid);
        this.add((Component)bpVirtual);
        PsPanel bp = new PsPanel((LayoutManager)new FlowLayout());
        bp.add((Component)this.m_bSelectorAddEdge);
        bp.add((Component)this.m_bSelectorParallelCopySel);
        bp.add((Component)this.m_bSelectorParallelCopyAll);
        this.add((Component)bp);
        PsPanel bpScale = new PsPanel((LayoutManager)new FlowLayout());
        bpScale.add((Component)this.m_bScaleUp);
        bpScale.add((Component)this.m_bScaleDown);
        this.add((Component)bpScale);
        PsPanel bp2 = new PsPanel((LayoutManager)new FlowLayout());
        bp2.add((Component)this.m_bSplitSelectedEdges);
        bp2.add((Component)this.m_bRemoveDuplicateEdges);
        this.add((Component)bp2);
        this.addLine(1);
        PsPanel bpSymmetry = new PsPanel((LayoutManager)new FlowLayout());
        bpSymmetry.add((Component)this.m_cOrientedOnly);
        bpSymmetry.add((Component)this.m_bEdgeSymmetry);
        bpSymmetry.add((Component)this.m_bAllSymmetry);
        this.add((Component)bpSymmetry);
        this.addLine(1);
        PsPanel bpReflect = new PsPanel((LayoutManager)new FlowLayout());
        bpReflect.add((Component)this.m_bPointReflect);
        bpReflect.add((Component)this.m_bPlaneReflect);
        this.add((Component)bpReflect);
        this.addLine(1);
        PsPanel bpOffset = new PsPanel((LayoutManager)new FlowLayout());
        bpOffset.add((Component)this.m_bAddOffsetCopy);
        bpOffset.add((Component)this.m_bAddTransforCopy);
        this.add((Component)bpOffset);
        PsPanel bpConnect = new PsPanel((LayoutManager)new FlowLayout());
        bpConnect.add((Component)this.m_bConnectPoints);
        bpConnect.add((Component)this.m_bCloseCycle);
        bpConnect.add((Component)this.m_bSetSelectedToRoot);
        this.add((Component)bpConnect);
        this.addLine(1);
        PsPanel bpFile = new PsPanel((LayoutManager)new FlowLayout());
        bpFile.add((Component)this.m_tTreeFileName);
        bpFile.add((Component)this.m_bStoreTree);
        bpFile.add((Component)this.m_bLoadTree);
        bpFile.add((Component)this.m_bPartsList);
        this.add((Component)bpFile);
        PsPanel rp = new PsPanel((LayoutManager)new FlowLayout());
        rp.add((Component)this.m_cShowAsElementSet);
        this.add((Component)rp);
        this.add((Component)this.m_explodeParam.newInspector("_IP"));
        this.m_explodeParam.setEnabled(false);
        this.m_bgColorRed = new Color(255, 0, 0);
        this.m_bgColorYellow = new Color(255, 255, 0);
        this.m_bgColor = this.getBackground();
        this.m_bgColorGray = this.m_bSelectorAddEdge.getBackground();
        PsPanel cp = new PsPanel((LayoutManager)new FlowLayout());
        cp.add((Component)this.m_bClearSelections);
        cp.add((Component)this.m_bClearGeometry);
        this.add((Component)cp);
        PsPanel hp = new PsPanel((LayoutManager)new FlowLayout());
        hp.add((Component)this.m_bStepBack);
        hp.add((Component)this.m_bStepForward);
        this.add((Component)hp);
        PsPanel sp = new PsPanel((LayoutManager)new FlowLayout());
        sp.add((Component)this.m_tScriptFileName);
        sp.add((Component)this.m_bSaveScript);
        sp.add((Component)this.m_bLoadScript);
        this.add((Component)sp);
    }

    public void setParent(PsUpdateIf parent) {
        if (parent == null) {
            return;
        }
        if (parent.getClass() != PwZomeEditor.class) {
            PsDebug.warning((String)"Parent has to be of type PwEditor");
            return;
        }
        super.setParent(parent);
        this.m_pwEditor = (PwZomeEditor)parent;
        this.makeLayout();
        this.m_tTreeFileName.setText(this.m_pwEditor.m_fullTreeFileName);
        this.m_tScriptFileName.setText(this.m_pwEditor.m_log.m_fullScriptFileName);
        if (this.m_pwEditor.m_geom != null) {
            this.m_pwEditor.m_geom.addUpdateListener((PsUpdateIf)this);
        } else {
            PsDebug.warning((String)"Parent workshop does not yet have a geometry. Panel not added as update listener.");
        }
    }

    public void makeLayout() {
    }

    public boolean update(Object event) {
        if (this.m_pwEditor == null) {
            PsDebug.notify((String)"missing parent");
            return true;
        }
        if (event == this.m_pwEditor) {
            return super.update(event);
        }
        if (event == this.m_treePanel) {
            this.m_pwEditor.m_geom.buildFromTree();
            this.m_pwEditor.m_geom.update((Object)this.m_pwEditor.m_geom);
        } else {
            if (event == this.m_pwEditor.m_geom) {
                int nop = this.m_pwEditor.m_geom.getNumPolygons();
                if (nop != this.m_pwEditor.m_geom.getNumPolygons()) {
                    return true;
                }
                int i = 0;
                while (i < nop) {
                    if (this.m_pwEditor.m_geom.hasTagPolygon(i, 1)) {
                        this.m_pwEditor.m_geom.m_buildTree[i].setTag(1);
                    } else {
                        this.m_pwEditor.m_geom.m_buildTree[i].clearTag(1);
                    }
                    ++i;
                }
                return true;
            }
            if (event == this.m_currentEdgeSlider) {
                this.adjustSliders(this.m_currentEdgeSlider.getValue(), this.m_pwEditor.m_geom.getNumPolygons());
                return true;
            }
            if (event == this.m_startIndexSlider || event == this.m_lengthSlider || event == this.m_directionSlider) {
                this.evaluate();
            } else if (event == this.m_explodeParam) {
                this.m_pwEditor.m_pwZomeGeom.m_explodeParam = this.m_explodeParam.getValue();
                this.m_pwEditor.displayAsElementSet(this.m_cShowAsElementSet.getState());
            }
        }
        return super.update(event);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.m_pwEditor == null) {
            return;
        }
        Object source = event.getSource();
        if (source == this.m_bSelectorAddEdge) {
            if (this.m_bSelectorAddEdge.getLabel() == this.m_bSelectorAddEdgeName0) {
                this.setSelectEdgeColor();
                if (!this.m_pwEditor.showSelectorAtVertex()) {
                    return;
                }
                this.m_bSelectorAddEdge.setLabel(this.m_bSelectorAddEdgeName1);
                this.m_bgColorGray = this.m_bSelectorAddEdge.getBackground();
                this.m_bSelectorAddEdge.setBackground(this.m_bgColorRed);
                if (this.m_pwEditor.m_zomeSelect.m_restrictColor == -1 || this.m_pwEditor.m_zomeSelect.m_restrictColor == 2) {
                    this.m_cRed.setBackground(this.m_bgColorYellow);
                }
                if (this.m_pwEditor.m_zomeSelect.m_restrictColor == -1 || this.m_pwEditor.m_zomeSelect.m_restrictColor == 2 || this.m_pwEditor.m_zomeSelect.m_restrictColor == 3) {
                    this.m_cYellow.setBackground(this.m_bgColorYellow);
                }
                this.m_cBlue.setBackground(this.m_bgColorYellow);
                if (this.m_pwEditor.m_zomeSelect.m_restrictColor == -1 || this.m_pwEditor.m_zomeSelect.m_restrictColor == 1 || this.m_pwEditor.m_zomeSelect.m_restrictColor == 2 || this.m_pwEditor.m_zomeSelect.m_restrictColor == 3) {
                    this.m_cGreen.setBackground(this.m_bgColorYellow);
                }
                if (this.m_pwEditor.m_zomeSelect.m_restrictColor == -1 || this.m_pwEditor.m_zomeSelect.m_restrictColor == 1 || this.m_pwEditor.m_zomeSelect.m_restrictColor == 2 || this.m_pwEditor.m_zomeSelect.m_restrictColor == 3) {
                    this.m_cHalfGreen.setBackground(this.m_bgColorYellow);
                }
                this.m_bScaleUp.setBackground(this.m_bgColorYellow);
                this.m_bScaleUp.setLabel(this.m_bScaleUpName1);
                this.m_bScaleDown.setBackground(this.m_bgColorYellow);
                this.m_bScaleDown.setLabel(this.m_bScaleDownName1);
                this.m_mode = 1;
                this.m_majorMode_save = this.m_pwEditor.getDisplay().getMajorMode();
                this.m_pwEditor.getDisplay().setMajorMode(23);
            } else {
                this.m_pwEditor.addEdgeBySelector();
                this.m_bSelectorAddEdge.setLabel(this.m_bSelectorAddEdgeName0);
                this.m_bSelectorAddEdge.setBackground(this.m_bgColorGray);
                this.m_cRed.setBackground(this.m_bgColor);
                this.m_cYellow.setBackground(this.m_bgColor);
                this.m_cBlue.setBackground(this.m_bgColor);
                this.m_cGreen.setBackground(this.m_bgColor);
                this.m_cHalfGreen.setBackground(this.m_bgColor);
                this.m_bScaleUp.setBackground(this.m_bgColorGray);
                this.m_bScaleUp.setLabel(this.m_bScaleUpName0);
                this.m_bScaleDown.setBackground(this.m_bgColorGray);
                this.m_bScaleDown.setLabel(this.m_bScaleDownName0);
                this.m_mode = 0;
                this.m_pwEditor.getDisplay().setMajorMode(this.m_majorMode_save);
            }
        } else if (source == this.m_bSelectorParallelCopySel) {
            if (this.m_bSelectorParallelCopySel.getLabel() == this.m_bParallelCopySelName0) {
                this.setSelectEdgeColor();
                if (!this.m_pwEditor.showSelectorAtVertex() && !this.m_pwEditor.showSelectorAtEdge()) {
                    return;
                }
                this.m_bSelectorParallelCopySel.setLabel(this.m_bParallelCopySelName1);
                this.m_bgColorGray = this.m_bSelectorParallelCopySel.getBackground();
                this.m_bSelectorParallelCopySel.setBackground(this.m_bgColorRed);
                this.m_cRed.setBackground(this.m_bgColorYellow);
                this.m_cYellow.setBackground(this.m_bgColorYellow);
                this.m_cBlue.setBackground(this.m_bgColorYellow);
                this.m_cGreen.setBackground(this.m_bgColorYellow);
                this.m_cHalfGreen.setBackground(this.m_bgColorYellow);
                this.m_bScaleUp.setBackground(this.m_bgColorYellow);
                this.m_bScaleUp.setLabel(this.m_bScaleUpName1);
                this.m_bScaleDown.setBackground(this.m_bgColorYellow);
                this.m_bScaleDown.setLabel(this.m_bScaleDownName1);
                this.m_mode = 1;
            } else {
                this.m_pwEditor.parallelConnectedCopySelectedBySelector();
                this.m_bSelectorParallelCopySel.setLabel(this.m_bParallelCopySelName0);
                this.m_bSelectorParallelCopySel.setBackground(this.m_bgColorGray);
                this.m_cRed.setBackground(this.m_bgColor);
                this.m_cYellow.setBackground(this.m_bgColor);
                this.m_cBlue.setBackground(this.m_bgColor);
                this.m_cGreen.setBackground(this.m_bgColor);
                this.m_cHalfGreen.setBackground(this.m_bgColor);
                this.m_bScaleUp.setBackground(this.m_bgColorGray);
                this.m_bScaleUp.setLabel(this.m_bScaleUpName0);
                this.m_bScaleDown.setBackground(this.m_bgColorGray);
                this.m_bScaleDown.setLabel(this.m_bScaleDownName0);
                this.m_mode = 0;
            }
        } else if (source == this.m_bSelectorParallelCopyAll) {
            if (this.m_bSelectorParallelCopyAll.getLabel() == this.m_bParallelCopyAllName0) {
                this.setSelectEdgeColor();
                if (!this.m_pwEditor.showSelectorAtVertex() && !this.m_pwEditor.showSelectorAtEdge()) {
                    this.m_pwEditor.showSelectorAtRootVertex();
                }
                this.m_bSelectorParallelCopyAll.setLabel(this.m_bParallelCopyAllName1);
                this.m_bgColorGray = this.m_bSelectorParallelCopyAll.getBackground();
                this.m_bSelectorParallelCopyAll.setBackground(this.m_bgColorRed);
                this.m_cRed.setBackground(this.m_bgColorYellow);
                this.m_cYellow.setBackground(this.m_bgColorYellow);
                this.m_cBlue.setBackground(this.m_bgColorYellow);
                this.m_cGreen.setBackground(this.m_bgColorYellow);
                this.m_cHalfGreen.setBackground(this.m_bgColorYellow);
                this.m_bScaleUp.setBackground(this.m_bgColorYellow);
                this.m_bScaleUp.setLabel(this.m_bScaleUpName1);
                this.m_bScaleDown.setBackground(this.m_bgColorYellow);
                this.m_bScaleDown.setLabel(this.m_bScaleDownName1);
                this.m_mode = 1;
            } else {
                this.m_pwEditor.parallelConnectedCopyAllBySelector();
                this.m_bSelectorParallelCopyAll.setLabel(this.m_bParallelCopyAllName0);
                this.m_bSelectorParallelCopyAll.setBackground(this.m_bgColorGray);
                this.m_cRed.setBackground(this.m_bgColor);
                this.m_cYellow.setBackground(this.m_bgColor);
                this.m_cBlue.setBackground(this.m_bgColor);
                this.m_cGreen.setBackground(this.m_bgColor);
                this.m_cHalfGreen.setBackground(this.m_bgColor);
                this.m_bScaleUp.setBackground(this.m_bgColorGray);
                this.m_bScaleUp.setLabel(this.m_bScaleUpName0);
                this.m_bScaleDown.setBackground(this.m_bgColorGray);
                this.m_bScaleDown.setLabel(this.m_bScaleDownName0);
                this.m_mode = 0;
            }
        } else if (source == this.m_bRemoveDuplicateEdges) {
            this.m_pwEditor.removeDuplicateEdges();
            this.m_pwEditor.m_geom.buildFromTree();
            this.m_pwEditor.m_geom.update((Object)this.m_pwEditor.m_geom);
        } else {
            if (source == this.m_bSplitSelectedEdges) {
                this.m_pwEditor.splitSelectedEdges();
                return;
            }
            if (source == this.m_bEdgeSymmetry) {
                if (this.m_pwEditor.findSelectedEdges() == 1) {
                    this.m_pwEditor.addEdgeSymmetry(this.m_cOrientedOnly.getState());
                } else {
                    if (this.m_bEdgeSymmetry.getLabel() == this.m_bEdgeSymmetryName0) {
                        this.setSelectSymmetryColor();
                        if (!this.m_pwEditor.showSelectorAtVertex()) {
                            this.m_pwEditor.showSelectorAtRootVertex();
                        }
                        this.m_bEdgeSymmetry.setLabel(this.m_bEdgeSymmetryName1);
                        this.m_bgColorGray = this.m_bEdgeSymmetry.getBackground();
                        this.m_bEdgeSymmetry.setBackground(this.m_bgColorRed);
                        this.m_cRed.setBackground(this.m_bgColorYellow);
                        this.m_cYellow.setBackground(this.m_bgColorYellow);
                        this.m_cBlue.setBackground(this.m_bgColorYellow);
                        this.m_cGreen.setBackground(this.m_bgColorYellow);
                        this.m_mode = 3;
                        return;
                    }
                    this.m_pwEditor.addEdgeSymmetryBySelector(this.m_cOrientedOnly.getState());
                    this.m_bEdgeSymmetry.setLabel(this.m_bEdgeSymmetryName0);
                    this.m_bEdgeSymmetry.setBackground(this.m_bgColorGray);
                    this.m_cRed.setBackground(this.m_bgColor);
                    this.m_cYellow.setBackground(this.m_bgColor);
                    this.m_cBlue.setBackground(this.m_bgColor);
                    this.m_cGreen.setBackground(this.m_bgColor);
                    this.m_mode = 0;
                }
            } else if (source == this.m_bSelectRestriction) {
                if (this.m_mode == 5) {
                    this.m_bSelectRestriction.setBackground(this.m_bgColorGray);
                    this.m_cRed.setBackground(this.m_bgColor);
                    this.m_cYellow.setBackground(this.m_bgColor);
                    this.m_cBlue.setBackground(this.m_bgColor);
                    this.m_cGreen.setBackground(this.m_bgColor);
                    PiVector[] edge = this.m_pwEditor.m_zomeSelect.getEdgeSelection();
                    if (edge == null || edge.length != 1) {
                        this.m_tRestriction.setText(NO_RESTRICTION);
                        this.m_pwEditor.m_zomeSelect.m_restrictColor = -1;
                        this.m_bSelectRestriction.setLabel(this.m_bSelectRestrictionName0);
                    } else {
                        String text = "";
                        if (this.m_pwEditor.m_zomeSelect.m_mode == 5) {
                            this.m_pwEditor.m_zomeSelect.m_restrictColor = 0;
                            text = String.valueOf(text) + "Red ";
                        } else if (this.m_pwEditor.m_zomeSelect.m_mode == 6) {
                            this.m_pwEditor.m_zomeSelect.m_restrictColor = 1;
                            text = String.valueOf(text) + "Yellow ";
                        } else if (this.m_pwEditor.m_zomeSelect.m_mode == 7) {
                            this.m_pwEditor.m_zomeSelect.m_restrictColor = 2;
                            text = String.valueOf(text) + "Blue ";
                        } else if (this.m_pwEditor.m_zomeSelect.m_mode == 8) {
                            this.m_pwEditor.m_zomeSelect.m_restrictColor = 3;
                            text = String.valueOf(text) + "Green ";
                        }
                        int dir = edge[0].m_data[3];
                        text = String.valueOf(text) + dir;
                        this.m_tRestriction.setText(text);
                        this.m_pwEditor.m_zomeSelect.m_restrictDirectionIndex = dir;
                        this.m_bSelectRestriction.setLabel(this.m_bSelectRestrictionName2);
                    }
                    this.m_pwEditor.m_zomeSelect.setVisibleGeom(false);
                    this.m_mode = 0;
                    return;
                }
                if (this.m_bSelectRestriction.getLabel() == this.m_bSelectRestrictionName0) {
                    this.setSelectSymmetryColor();
                    if (!this.m_pwEditor.showSelectorAtVertex()) {
                        this.m_pwEditor.showSelectorAtRootVertex();
                    }
                    this.m_bSelectRestriction.setLabel(this.m_bSelectRestrictionName1);
                    this.m_bgColorGray = this.m_bSelectRestriction.getBackground();
                    this.m_bSelectRestriction.setBackground(this.m_bgColorRed);
                    this.m_cRed.setBackground(this.m_bgColorYellow);
                    this.m_cYellow.setBackground(this.m_bgColorYellow);
                    this.m_cBlue.setBackground(this.m_bgColorYellow);
                    this.m_cGreen.setBackground(this.m_bgColorYellow);
                    this.m_mode = 5;
                    return;
                }
                if (this.m_bSelectRestriction.getLabel() == this.m_bSelectRestrictionName2) {
                    this.m_tRestriction.setText(NO_RESTRICTION);
                    this.m_pwEditor.m_zomeSelect.m_restrictColor = -1;
                    this.m_bSelectRestriction.setLabel(this.m_bSelectRestrictionName0);
                    this.m_mode = 0;
                    return;
                }
            } else if (source == this.m_bAllSymmetry) {
                if (this.m_cOrientedOnly.getState()) {
                    this.m_pwEditor.addFullOrientedSymmetry();
                } else {
                    this.m_pwEditor.addFull120Symmetry();
                }
            } else if (source == this.m_bPointReflect) {
                this.m_pwEditor.addPointReflection();
            } else if (source == this.m_bPlaneReflect) {
                if (this.m_pwEditor.findSelectedEdges() == 1) {
                    this.m_pwEditor.addPlaneReflection();
                } else {
                    if (this.m_bPlaneReflect.getLabel() == this.m_bPlaneReflectName0) {
                        this.m_pwEditor.m_zomeSelect.setMode(7);
                        if (!this.m_pwEditor.showSelectorAtVertex()) {
                            this.m_pwEditor.showSelectorAtRootVertex();
                        }
                        this.m_bPlaneReflect.setLabel(this.m_bPlaneReflectName1);
                        this.m_bgColorGray = this.m_bPlaneReflect.getBackground();
                        this.m_bPlaneReflect.setBackground(this.m_bgColorRed);
                        this.m_mode = 2;
                        return;
                    }
                    this.m_pwEditor.addPlaneReflectionBySelector();
                    this.m_bPlaneReflect.setLabel(this.m_bPlaneReflectName0);
                    this.m_bPlaneReflect.setBackground(this.m_bgColorGray);
                    this.m_mode = 0;
                }
            } else if (source == this.m_bAddOffsetCopy) {
                this.m_pwEditor.addOffsetCopyTwoPoints();
            } else if (source == this.m_bAddTransforCopy) {
                if (this.m_bAddTransforCopy.getLabel() == this.m_bAddTransforCopyName0) {
                    if (!this.m_pwEditor.findTransformationsTwoEdges()) {
                        return;
                    }
                    this.m_mode = 4;
                    this.m_bAddTransforCopy.setLabel(this.m_bAddTransforCopyName1);
                    this.m_bgColorGray = this.m_bAddTransforCopy.getBackground();
                    this.m_bAddTransforCopy.setBackground(this.m_bgColorRed);
                    this.m_bScaleUp.setBackground(this.m_bgColorYellow);
                    this.m_bScaleUp.setLabel(this.m_bScaleUpName2);
                    this.m_bScaleDown.setBackground(this.m_bgColorYellow);
                    this.m_bScaleDown.setLabel(this.m_bScaleDownName2);
                } else {
                    this.m_mode = 0;
                    this.m_pwEditor.addOffsetTransformBySelector();
                    this.m_bAddTransforCopy.setLabel(this.m_bAddTransforCopyName0);
                    this.m_bAddTransforCopy.setBackground(this.m_bgColorGray);
                    this.m_bScaleUp.setBackground(this.m_bgColorGray);
                    this.m_bScaleUp.setLabel(this.m_bScaleUpName0);
                    this.m_bScaleDown.setBackground(this.m_bgColorGray);
                    this.m_bScaleDown.setLabel(this.m_bScaleDownName0);
                }
            } else if (source == this.m_bScaleUp) {
                if (this.m_mode == 1) {
                    this.m_pwEditor.m_zomeSelect.scaleUp();
                } else if (this.m_mode == 0) {
                    this.m_pwEditor.scaleSelectedEdges(1);
                } else if (this.m_mode == 4) {
                    this.m_pwEditor.m_selectTransform.nextTransformation();
                }
            } else if (source == this.m_bScaleDown) {
                if (this.m_mode == 1) {
                    this.m_pwEditor.m_zomeSelect.scaleDown();
                } else if (this.m_mode == 0) {
                    this.m_pwEditor.scaleSelectedEdges(-1);
                } else if (this.m_mode == 4) {
                    this.m_pwEditor.m_selectTransform.previousTransformation();
                }
            } else if (source == this.m_bMakeVirtual) {
                this.m_pwEditor.setSolidSelectedEdges(false);
            } else if (source == this.m_bMakeSolid) {
                this.m_pwEditor.setSolidSelectedEdges(true);
                this.m_treePanel.update((Object)this);
            } else if (source == this.m_bConnectPoints) {
                this.m_pwEditor.connectSelectedPoints();
            } else if (source == this.m_bCloseCycle) {
                this.m_pwEditor.closeCycle();
            } else if (source == this.m_bSetSelectedToRoot) {
                this.m_pwEditor.setSelectedVertexToRoot();
            } else if (source == this.m_bStoreTree) {
                this.m_pwEditor.m_fullTreeFileName = this.m_tTreeFileName.getText();
                this.m_pwEditor.storeTree();
            } else if (source == this.m_bLoadTree) {
                this.m_pwEditor.m_fullTreeFileName = this.m_tTreeFileName.getText();
                this.m_pwEditor.loadTree();
            } else if (source == this.m_bPartsList) {
                this.m_pwEditor.partList();
            } else if (source == this.m_bSelectEqualEdges) {
                int col = -1;
                col = this.m_cRed.getState() ? 0 : (this.m_cYellow.getState() ? 1 : (this.m_cBlue.getState() ? 2 : (this.m_cGreen.getState() ? 3 : 4)));
                int dir = this.m_directionSlider.getValue();
                int length = this.m_lengthSlider.getValue();
                this.m_pwEditor.selectEdges(col, dir, length);
            } else if (source == this.m_bClearSelections) {
                this.m_pwEditor.removeAllSelections();
            } else if (source == this.m_bClearGeometry) {
                this.m_pwEditor.clearZomeSet();
                this.m_pwEditor.m_log.clearLog();
            } else if (source == this.m_bStepBack) {
                this.m_pwEditor.m_log.stepBack();
            } else if (source == this.m_bStepForward) {
                this.m_pwEditor.m_log.stepForward();
            } else if (source == this.m_bSaveScript) {
                this.m_pwEditor.m_log.m_fullScriptFileName = this.m_tScriptFileName.getText();
                this.m_pwEditor.m_log.storeScript();
            } else if (source == this.m_bLoadScript) {
                this.m_pwEditor.m_log.m_fullScriptFileName = this.m_tScriptFileName.getText();
                this.m_pwEditor.m_log.loadScript();
            }
        }
    }

    protected void adjustSliders(int edgeIndex, int numEdges) {
        if (numEdges < 1) {
            return;
        }
        PiVector edgeInfo = this.m_pwEditor.m_geom.m_buildTree[edgeIndex];
        this.m_currentEdgeSlider.setDefBounds(0, numEdges - 1, 1, 10);
        this.m_currentEdgeSlider.init();
        this.m_currentEdgeSlider.setValue(edgeIndex);
        this.m_startIndexSlider.setDefBounds(-1, edgeIndex - 1, 1, 10);
        this.m_startIndexSlider.init();
        this.m_startIndexSlider.setValue(edgeInfo.m_data[0]);
        if (edgeInfo.m_data[1] == 0) {
            this.m_cRed.setState(true);
        } else if (edgeInfo.m_data[1] == 1) {
            this.m_cYellow.setState(true);
        } else if (edgeInfo.m_data[1] == 2) {
            this.m_cBlue.setState(true);
        } else if (edgeInfo.m_data[1] == 3) {
            this.m_cGreen.setState(true);
        } else {
            this.m_cHalfGreen.setState(true);
        }
        this.m_lengthSlider.setValue(edgeInfo.m_data[2]);
        this.adjustDirectionsToColor(edgeInfo.m_data[1]);
        this.m_directionSlider.setValue(edgeInfo.m_data[3]);
    }

    protected void adjustDirectionsToColor() {
        if (this.m_cRed.getState()) {
            this.m_directionSlider.setDefBounds(0, 11, 1, 6);
        } else if (this.m_cYellow.getState()) {
            this.m_directionSlider.setDefBounds(0, 19, 1, 10);
        } else if (this.m_cBlue.getState()) {
            this.m_directionSlider.setDefBounds(0, 29, 1, 15);
        } else if (this.m_cGreen.getState()) {
            this.m_directionSlider.setDefBounds(0, 59, 1, 30);
        } else {
            this.m_directionSlider.setDefBounds(0, 59, 1, 30);
        }
        this.m_directionSlider.init();
    }

    protected void adjustDirectionsToColor(int colIndex) {
        if (colIndex == 0) {
            this.m_directionSlider.setDefBounds(0, 11, 1, 6);
        } else if (colIndex == 1) {
            this.m_directionSlider.setDefBounds(0, 19, 1, 10);
        } else if (colIndex == 2) {
            this.m_directionSlider.setDefBounds(0, 29, 1, 15);
        } else if (colIndex == 3) {
            this.m_directionSlider.setDefBounds(0, 59, 1, 30);
        } else {
            this.m_directionSlider.setDefBounds(0, 59, 1, 30);
        }
        this.m_directionSlider.init();
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (event.getSource() == this.m_cRed || event.getSource() == this.m_cYellow || event.getSource() == this.m_cBlue || event.getSource() == this.m_cGreen || event.getSource() == this.m_cHalfGreen) {
            if (this.m_mode == 1) {
                this.setSelectEdgeColor();
                this.m_pwEditor.m_zomeSelect.computeEdges();
            } else if (this.m_mode != 0 && (this.m_mode == 3 || this.m_mode == 5)) {
                this.setSelectSymmetryColor();
                this.m_pwEditor.m_zomeSelect.computeEdges();
            }
        } else if (event.getSource() == this.m_cEditSelected) {
            if (this.m_cEditSelected.getState()) {
                int numEdges = this.m_pwEditor.m_geom.getNumPolygons();
                int i = 0;
                while (i < numEdges) {
                    if (this.m_pwEditor.m_geom.m_buildTree[i].hasTag(1)) {
                        this.adjustSliders(i, this.m_pwEditor.m_geom.getNumPolygons());
                        break;
                    }
                    ++i;
                }
            } else {
                this.adjustSliders(this.m_currentEdgeSlider.getValue(), this.m_pwEditor.m_geom.getNumPolygons());
            }
        } else if (event.getSource() == this.m_cShowAsElementSet) {
            this.m_explodeParam.setEnabled(this.m_cShowAsElementSet.getState());
            this.m_pwEditor.m_pwZomeGeom.m_explodeParam = this.m_explodeParam.getValue();
            this.m_pwEditor.displayAsElementSet(this.m_cShowAsElementSet.getState());
        }
    }

    protected void setSelectEdgeColor() {
        if (this.m_cRed.getState()) {
            this.m_pwEditor.m_zomeSelect.setMode(0);
        } else if (this.m_cYellow.getState()) {
            this.m_pwEditor.m_zomeSelect.setMode(1);
        } else if (this.m_cBlue.getState()) {
            this.m_pwEditor.m_zomeSelect.setMode(2);
        } else if (this.m_cGreen.getState()) {
            this.m_pwEditor.m_zomeSelect.setMode(3);
        } else {
            this.m_pwEditor.m_zomeSelect.setMode(4);
        }
    }

    protected void setSelectSymmetryColor() {
        if (this.m_cRed.getState()) {
            this.m_pwEditor.m_zomeSelect.setMode(5);
        } else if (this.m_cYellow.getState()) {
            this.m_pwEditor.m_zomeSelect.setMode(6);
        } else if (this.m_cBlue.getState()) {
            this.m_pwEditor.m_zomeSelect.setMode(7);
        } else if (this.m_cGreen.getState()) {
            this.m_pwEditor.m_zomeSelect.setMode(8);
        } else {
            this.m_pwEditor.m_zomeSelect.setMode(8);
        }
    }

    protected void evaluate() {
        if (this.m_cEditSelected.getState()) {
            int numEdges = this.m_pwEditor.m_geom.getNumPolygons();
            int i = 0;
            while (i < numEdges) {
                if (this.m_pwEditor.m_geom.m_buildTree[i].hasTag(1)) {
                    this.fillEdgeInfo(this.m_pwEditor.m_geom.m_buildTree[i]);
                }
                ++i;
            }
        } else {
            int edgeIndex = this.m_currentEdgeSlider.getValue();
            if (this.m_pwEditor.m_geom.getNumPolygons() < 1) {
                return;
            }
            this.fillEdgeInfo(this.m_pwEditor.m_geom.m_buildTree[edgeIndex]);
            this.m_pwEditor.m_geom.m_buildTree[edgeIndex].m_data[0] = this.m_startIndexSlider.getValue();
        }
        this.m_pwEditor.m_geom.buildFromTree();
        this.m_pwEditor.m_geom.update((Object)this.m_pwEditor.m_geom);
    }

    protected void fillEdgeInfo(PiVector edgeInfo) {
        edgeInfo.m_data[1] = this.m_cRed.getState() ? 0 : (this.m_cYellow.getState() ? 1 : (this.m_cBlue.getState() ? 2 : (this.m_cGreen.getState() ? 3 : 4)));
        edgeInfo.m_data[2] = this.m_lengthSlider.getValue();
        edgeInfo.m_data[3] = this.m_directionSlider.getValue();
    }
}

