/*
 * Decompiled with CFR 0.152.
 */
package devZomeView;

import devZomeView.PgZomeSet;
import devZomeView.PlZomeScript;
import devZomeView.PnZomeSymmetry;
import devZomeView.PwSelectTransform;
import devZomeView.PwZomeGeom;
import devZomeView.PwZomeSelect;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Vector;
import jv.geom.PgElementSet;
import jv.geom.PgPolygonSet;
import jv.object.PsDebug;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.project.PjWorkshop;

public class PwZomeEditor
extends PjWorkshop {
    protected PnZomeSymmetry m_sym;
    protected PgZomeSet m_geom = null;
    protected String m_fullTreeFileName = "D:\\test\\zomeTree.txt";
    protected PwZomeSelect m_zomeSelect;
    protected PwSelectTransform m_selectTransform;
    protected boolean m_bLogOperation = true;
    protected PlZomeScript m_log;
    protected PiVector m_selectedVertexIndex;
    protected PiVector m_selectedEdgeIndex;
    protected PwZomeGeom m_pwZomeGeom = new PwZomeGeom("Zome Geometry Workshop");

    public PwZomeEditor(String name) {
        super(name);
        this.m_sym = new PnZomeSymmetry();
        this.m_zomeSelect = new PwZomeSelect("Direction Selector");
        this.m_selectTransform = new PwSelectTransform("Transformation Selector");
        this.m_log = new PlZomeScript(this);
        if (((Object)((Object)this)).getClass() == PwZomeEditor.class) {
            this.init();
        }
    }

    public PwZomeEditor(String name, PgPolygonSet geom) {
        this(name);
        this.setGeometry((PgGeometry)geom);
    }

    public void init() {
        super.init();
    }

    public void setGeometry(PgGeometry geom) {
        if (geom == null || !(geom instanceof PgPolygonSet)) {
            PsDebug.warning((String)"Geom is not a PgPolygonSet.");
            return;
        }
        super.setGeometry(geom);
        this.m_geom = (PgZomeSet)geom;
        this.m_geom.buildFromTree();
        this.m_geom.setTagVertex(0, 1);
        this.m_geom.update((Object)this.m_geom);
        this.update((Object)this);
    }

    protected void setTarget(PiVector edge, PiVector position) {
        edge.m_data[4] = this.m_geom.assurePosition(position);
    }

    public boolean update(Object event) {
        return super.update(event);
    }

    public String getName() {
        return "Zome Tool Editor Workshop";
    }

    protected int findSelectedVertices() {
        this.m_selectedVertexIndex = new PiVector(0);
        int nov = this.m_geom.getNumVertices();
        int numSelected = 0;
        int i = 0;
        while (i < nov) {
            if (this.m_geom.hasTagVertex(i, 1)) {
                this.m_selectedVertexIndex.setSize(++numSelected);
                this.m_selectedVertexIndex.m_data[numSelected - 1] = i;
            }
            ++i;
        }
        return numSelected;
    }

    protected int findSelectedEdges() {
        this.m_selectedEdgeIndex = new PiVector(0);
        int nop = this.m_geom.getNumPolygons();
        int numSelected = 0;
        int i = 0;
        while (i < nop) {
            if (this.m_geom.hasTagPolygon(i, 1)) {
                this.m_selectedEdgeIndex.setSize(++numSelected);
                this.m_selectedEdgeIndex.m_data[numSelected - 1] = i;
            }
            ++i;
        }
        return numSelected;
    }

    protected int findOneSelectedEdge() {
        int numSelectedEdges = this.findSelectedEdges();
        if (numSelectedEdges == 0) {
            PsDebug.message((String)"Missing selected edge.");
            return -1;
        }
        if (numSelectedEdges > 1) {
            PsDebug.message((String)"More than one selected edge.");
            return -1;
        }
        return this.m_selectedEdgeIndex.m_data[0];
    }

    protected int findOneSelectedVertex() {
        int numSelectedVertices = this.findSelectedVertices();
        if (numSelectedVertices == 0) {
            PsDebug.message((String)"Missing selected edge.");
            return -1;
        }
        if (numSelectedVertices > 1) {
            PsDebug.message((String)"More than one selected edge.");
            return -1;
        }
        return this.m_selectedVertexIndex.m_data[0];
    }

    protected PiVector findTwoSelectedEdges() {
        int numSelectedEdges = this.findSelectedEdges();
        if (numSelectedEdges < 2) {
            PsDebug.message((String)"Less than two selected edges.");
            return null;
        }
        if (numSelectedEdges > 2) {
            PsDebug.message((String)"More than two selected edges.");
            return null;
        }
        return this.m_selectedEdgeIndex;
    }

    protected PiVector findTwoSelectedVertices() {
        int numSelectedVertices = this.findSelectedVertices();
        if (numSelectedVertices < 2) {
            PsDebug.message((String)"Less than two selected vertices.");
            return null;
        }
        if (numSelectedVertices > 2) {
            PsDebug.message((String)"More than two selected vertices.");
            return null;
        }
        return this.m_selectedVertexIndex;
    }

    protected void addEdgeAtSelectedVertices(PiVector[] edge) {
        int numSelEdges = edge.length;
        PiVector targetPosition = new PiVector(6);
        int numSelVertices = this.m_selectedVertexIndex.getSize();
        int i = 0;
        while (i < numSelEdges) {
            int j = 0;
            while (j < numSelVertices) {
                edge[i].m_data[0] = this.findEdgeTo(this.m_selectedVertexIndex.m_data[j]);
                targetPosition.copy(this.m_geom.getIntPosition(this.m_selectedVertexIndex.m_data[j]));
                targetPosition.add(this.m_geom.getEdgeDir(edge[i]));
                this.setTarget(edge[i], targetPosition);
                int index = this.m_geom.getEdgeIndex(this.m_selectedVertexIndex.m_data[j], edge[i].m_data[4]);
                if (index == -1) {
                    int len = this.m_geom.getNumPolygons();
                    this.m_geom.setNumPolygons(len + 1);
                    this.m_geom.getEdgeInformation(len).copy(edge[i]);
                    this.m_geom.registerEdge(len);
                }
                ++j;
            }
            ++i;
        }
        this.m_geom.computePolygonSet();
        this.m_geom.update((Object)this.m_geom);
    }

    protected void splitSelectedEdges() {
        int numEdges = this.m_geom.getNumPolygons();
        if (this.m_bLogOperation) {
            this.findSelectedEdges();
            this.m_log.logOperationE(17, this.m_selectedEdgeIndex);
        }
        int i = 0;
        while (i < numEdges) {
            if (this.m_geom.hasTagPolygon(i, 1)) {
                this.splitEdge(i, false);
                this.m_geom.clearTagPolygon(i + 1, 1);
                ++numEdges;
                ++i;
            }
            ++i;
        }
        this.m_geom.computePolygonSet();
        this.m_geom.update((Object)this.m_geom);
    }

    protected void splitEdge(int edgeIndex, boolean shortFirst) {
        PiVector edge;
        PiVector newEdge;
        int numEdges = this.m_geom.getNumPolygons();
        this.m_geom.setNumPolygons(numEdges + 1);
        int i = numEdges;
        while (i > edgeIndex) {
            newEdge = this.m_geom.getEdgeInformation(i);
            edge = this.m_geom.getEdgeInformation(i - 1);
            newEdge.copy(edge);
            if (newEdge.m_data[0] >= edgeIndex) {
                newEdge.m_data[0] = newEdge.m_data[0] + 1;
            }
            --i;
        }
        edge = this.m_geom.getEdgeInformation(edgeIndex);
        edge.m_data[2] = edge.m_data[2] - 1;
        newEdge = this.m_geom.getEdgeInformation(edgeIndex + 1);
        newEdge.m_data[2] = newEdge.m_data[2] - 1;
        newEdge.m_data[0] = edgeIndex;
        if (shortFirst) {
            edge.m_data[2] = edge.m_data[2] - 1;
        } else {
            newEdge.m_data[2] = newEdge.m_data[2] - 1;
        }
        this.m_geom.buildFromTree();
    }

    public void addEdgeSymmetry(int color, int direction, boolean bOrientedOnly) {
        this.addEdgeSymmetry(color, direction, -1, bOrientedOnly);
    }

    public void addEdgeSymmetry(boolean bOrientedOnly) {
        int numSelEdges = this.findSelectedEdges();
        if (numSelEdges != 1) {
            PsDebug.message((String)"Selection not clear - no symmetry is added.");
            return;
        }
        int edgeIndex = this.m_selectedEdgeIndex.m_data[0];
        int direction = this.m_geom.getEdgeDirection(edgeIndex);
        int color = this.m_geom.getEdgeColor(edgeIndex);
        this.addEdgeSymmetry(color, direction, edgeIndex, bOrientedOnly);
    }

    protected void addEdgeSymmetry(int color, int direction, int edgeIndex, boolean bOrientedOnly) {
        int numSelVertices = this.findSelectedVertices();
        if (numSelVertices > 1) {
            PsDebug.message((String)"Selection not clear - no symmetry is added.");
            return;
        }
        if (edgeIndex != -1) {
            this.m_geom.clearTagPolygon(edgeIndex, 1);
        }
        int vertexIndex = 0;
        int oldRoot = 0;
        if (numSelVertices == 1) {
            vertexIndex = this.m_selectedVertexIndex.m_data[0];
            if (this.m_bLogOperation) {
                if (bOrientedOnly) {
                    if (edgeIndex != -1) {
                        this.m_log.logOperationVE(7, vertexIndex, edgeIndex);
                    } else {
                        this.m_log.logOperationCDV(7, color, direction, vertexIndex);
                    }
                } else if (edgeIndex != -1) {
                    this.m_log.logOperationVE(8, vertexIndex, edgeIndex);
                } else {
                    this.m_log.logOperationCDV(8, color, direction, vertexIndex);
                }
            }
            this.m_geom.clearTagVertex(vertexIndex, 1);
            oldRoot = this.changeRoot(vertexIndex);
        } else if (edgeIndex != -1) {
            if (this.m_bLogOperation) {
                if (bOrientedOnly) {
                    this.m_log.logOperationE(7, edgeIndex);
                } else {
                    this.m_log.logOperationE(8, edgeIndex);
                }
            }
            int numEdges = this.m_geom.getNumPolygons();
            int rootVertex = this.m_geom.getStartVertexIndex(this.m_geom.getEdgeInformation(edgeIndex));
            PiVector replaceIndex = new PiVector(numEdges);
            oldRoot = this.changeRoot(rootVertex, replaceIndex);
        } else if (this.m_bLogOperation) {
            if (bOrientedOnly) {
                this.m_log.logOperationCDV(7, color, direction, 0);
            } else {
                this.m_log.logOperationCDV(8, color, direction, 0);
            }
        }
        this.addFixedEdgeSymmetry(direction, color, bOrientedOnly);
        this.changeRoot(oldRoot);
        this.m_geom.computePolygonSet();
        this.m_geom.update((Object)this.m_geom);
    }

    public void addFixedEdgeSymmetry(int direction, int color, boolean bOrientedOnly) {
        if (bOrientedOnly) {
            if (color == 3 || color == 4) {
                PsDebug.message((String)"There are no oriented symmetries keeping green directions fixed.");
                return;
            }
            this.addPermutations(PnZomeSymmetry.fixEdgeRotationIndex[color][direction]);
        } else {
            this.addPermutations(PnZomeSymmetry.fixEdgeSymmetryIndex[color][direction]);
        }
    }

    public void addPointReflection() {
        int numSelVertices = this.findSelectedVertices();
        int numSelEdges = this.findSelectedEdges();
        if (numSelEdges > 0 && numSelVertices > 0 || numSelEdges > 1 || numSelVertices > 2) {
            PsDebug.message((String)"Selection not clear - no reflection is added.");
            return;
        }
        if (numSelEdges == 1) {
            int edgeIndex = this.m_selectedEdgeIndex.m_data[0];
            if (this.m_bLogOperation) {
                this.m_log.logOperationE(11, edgeIndex);
            }
            int numEdges = this.m_geom.getNumPolygons();
            this.m_geom.clearTagPolygon(edgeIndex, 1);
            int rootVertex = this.m_geom.getStartVertexIndex(this.m_geom.getEdgeInformation(edgeIndex));
            PiVector replaceIndex = new PiVector(numEdges);
            int oldRoot = this.changeRoot(rootVertex, replaceIndex);
            edgeIndex = replaceIndex.m_data[edgeIndex];
            this.addPermutations(new int[]{79}, edgeIndex);
            this.changeRoot(oldRoot);
        } else {
            if (numSelVertices == 2) {
                this.m_geom.clearTagVertex(this.m_selectedVertexIndex.m_data[0], 1);
                this.m_geom.clearTagVertex(this.m_selectedVertexIndex.m_data[1], 1);
                if (this.m_bLogOperation) {
                    this.m_log.logOperationV(11, this.m_selectedVertexIndex);
                }
                this.addOffsetPermutation(this.m_selectedVertexIndex.m_data[0], this.m_selectedVertexIndex.m_data[1], 79);
                return;
            }
            int vertexIndex = 0;
            if (numSelVertices == 1) {
                vertexIndex = this.m_selectedVertexIndex.m_data[0];
                this.m_geom.clearTagVertex(vertexIndex, 1);
            }
            if (this.m_bLogOperation) {
                this.m_log.logOperationV(11, vertexIndex);
            }
            int oldRoot = this.changeRoot(vertexIndex);
            this.addPermutations(new int[]{79});
            this.changeRoot(oldRoot);
        }
        this.m_geom.computePolygonSet();
        this.m_geom.update((Object)this.m_geom);
    }

    public void addOffsetCopyTwoPoints() {
        int permutationIndex = 0;
        int numSelectedVertices = this.findSelectedVertices();
        if (numSelectedVertices != 2) {
            PsDebug.message((String)"Selecting failed");
            return;
        }
        if (this.m_bLogOperation) {
            this.m_log.logOperationV(13, this.m_selectedVertexIndex);
        }
        this.m_geom.clearTagVertex(this.m_selectedVertexIndex.m_data[0], 1);
        this.m_geom.clearTagVertex(this.m_selectedVertexIndex.m_data[1], 1);
        this.addOffsetPermutation(this.m_selectedVertexIndex.m_data[0], this.m_selectedVertexIndex.m_data[1], permutationIndex);
    }

    public void addOffsetPermutation(int rootIndex, int targetIndex, int permutationIndex) {
        int numEdges = this.m_geom.getNumPolygons();
        if (targetIndex == 0) {
            if (rootIndex == 0) {
                this.addPermutations(new int[]{permutationIndex});
            } else {
                PiVector replaceIndex = new PiVector(numEdges);
                int oldRoot = this.changeRoot(rootIndex, replaceIndex);
                int edgeToPoint = this.findEdgeTo(oldRoot);
                this.addPermutations(new int[]{permutationIndex}, edgeToPoint);
                this.changeRoot(oldRoot);
            }
        } else {
            int edgeToPoint = this.findEdgeTo(targetIndex);
            if (edgeToPoint == -1) {
                PsDebug.warning((String)("Unexpected error, no edge pointing to vertex " + targetIndex + " was found"));
                return;
            }
            PiVector replaceIndex = new PiVector(numEdges);
            int oldRoot = this.changeRoot(rootIndex, replaceIndex);
            edgeToPoint = replaceIndex.m_data[edgeToPoint];
            this.addPermutations(new int[]{permutationIndex}, edgeToPoint);
            this.changeRoot(oldRoot);
        }
        this.m_geom.computePolygonSet();
        this.m_geom.update((Object)this.m_geom);
    }

    public void addPlaneReflection(int direction) {
        this.addPlaneReflection(direction, -1);
    }

    public void addPlaneReflection() {
        int numSelEdges = this.findSelectedEdges();
        if (numSelEdges != 1) {
            PsDebug.message((String)"Selection not clear - no reflection is added.");
            return;
        }
        int edgeIndex = this.m_selectedEdgeIndex.m_data[0];
        if (this.m_geom.getEdgeColor(edgeIndex) != 2) {
            PsDebug.message((String)"Selected edge is not blue.");
            return;
        }
        int direction = this.m_geom.getEdgeDirection(edgeIndex);
        this.addPlaneReflection(direction, edgeIndex);
    }

    protected void addPlaneReflection(int direction, int edgeIndex) {
        int numSelVertices = this.findSelectedVertices();
        if (numSelVertices > 2) {
            PsDebug.message((String)"Selection not clear - no reflection is added.");
            return;
        }
        if (edgeIndex != -1) {
            this.m_geom.clearTagPolygon(edgeIndex, 1);
        }
        int vertexIndex = 0;
        if (numSelVertices == 2) {
            this.m_geom.clearTagVertex(this.m_selectedVertexIndex.m_data[0], 1);
            this.m_geom.clearTagVertex(this.m_selectedVertexIndex.m_data[1], 1);
            if (this.m_bLogOperation) {
                if (edgeIndex == -1) {
                    this.m_log.logOperationDV(12, direction, this.m_selectedVertexIndex);
                } else {
                    this.m_log.logOperationEV(12, edgeIndex, this.m_selectedVertexIndex);
                }
            }
            this.addOffsetPermutation(this.m_selectedVertexIndex.m_data[0], this.m_selectedVertexIndex.m_data[1], PnZomeSymmetry.blueReflectIndex[direction][0]);
        } else if (numSelVertices == 1) {
            vertexIndex = this.m_selectedVertexIndex.m_data[0];
            this.m_geom.clearTagVertex(vertexIndex, 1);
            if (this.m_bLogOperation) {
                if (edgeIndex == -1) {
                    this.m_log.logOperationDV(12, direction, vertexIndex);
                } else {
                    this.m_log.logOperationEV(12, edgeIndex, vertexIndex);
                }
            }
            int oldRoot = this.changeRoot(vertexIndex);
            this.addPermutations(PnZomeSymmetry.blueReflectIndex[direction]);
            this.changeRoot(oldRoot);
        } else if (numSelVertices == 0 && edgeIndex < 0) {
            if (this.m_bLogOperation) {
                this.m_log.logOperationDV(12, direction, 0);
            }
            this.addPermutations(PnZomeSymmetry.blueReflectIndex[direction]);
        } else {
            if (this.m_bLogOperation) {
                this.m_log.logOperationE(12, edgeIndex);
            }
            int numEdges = this.m_geom.getNumPolygons();
            int rootVertex = this.m_geom.getStartVertexIndex(this.m_geom.getEdgeInformation(edgeIndex));
            PiVector replaceIndex = new PiVector(numEdges);
            int oldRoot = this.changeRoot(rootVertex, replaceIndex);
            int edgeNewIndex = replaceIndex.m_data[edgeIndex];
            this.addPermutations(PnZomeSymmetry.blueReflectIndex[direction], edgeNewIndex);
            this.changeRoot(oldRoot);
        }
        this.m_geom.computePolygonSet();
        this.m_geom.update((Object)this.m_geom);
    }

    public void addFullOrientedSymmetry() {
        int numSelectedVertices = this.findSelectedVertices();
        if (numSelectedVertices > 1) {
            PsDebug.message((String)"More than one selected vertex.");
            return;
        }
        int vertexIndex = 0;
        if (numSelectedVertices == 1) {
            vertexIndex = this.m_selectedVertexIndex.m_data[0];
            this.m_geom.clearTagVertex(vertexIndex, 1);
        }
        if (this.m_bLogOperation) {
            this.m_log.logOperationV(9, vertexIndex);
        }
        int[] allPermutations = new int[59];
        int i = 0;
        while (i < 59) {
            allPermutations[i] = i + 1;
            ++i;
        }
        int oldRoot = this.changeRoot(vertexIndex);
        this.addPermutations(allPermutations);
        this.changeRoot(oldRoot);
        this.m_geom.computePolygonSet();
        this.m_geom.update((Object)this.m_geom);
    }

    public void addFull120Symmetry() {
        int numSelectedVertices = this.findSelectedVertices();
        if (numSelectedVertices > 1) {
            PsDebug.message((String)"More than one selected vertex.");
            return;
        }
        int vertexIndex = 0;
        if (numSelectedVertices == 1) {
            vertexIndex = this.m_selectedVertexIndex.m_data[0];
            this.m_geom.clearTagVertex(vertexIndex, 1);
        }
        if (this.m_bLogOperation) {
            this.m_log.logOperationV(10, vertexIndex);
        }
        int[] allPermutations = new int[119];
        int i = 0;
        while (i < 119) {
            allPermutations[i] = i + 1;
            ++i;
        }
        int oldRoot = this.changeRoot(vertexIndex);
        this.addPermutations(allPermutations);
        this.changeRoot(oldRoot);
        this.m_geom.computePolygonSet();
        this.m_geom.update((Object)this.m_geom);
    }

    public void addPermutations(int[] pIndex) {
        this.addPermutations(pIndex, -1);
    }

    public void addPermutations(int[] pIndex, int rootEdgeIndex) {
        int numPermutations = pIndex.length;
        int numEdges = this.m_geom.getNumPolygons();
        int newNumEdges = numEdges * (numPermutations + 1);
        this.m_geom.setNumPolygons(newNumEdges);
        PiVector replaceIndex = new PiVector(newNumEdges);
        int i = 0;
        while (i < numEdges) {
            replaceIndex.m_data[i] = i;
            ++i;
        }
        int nextEdgeIndex = numEdges;
        PiVector locReplaceIndex = new PiVector(numEdges);
        int novStart = this.m_geom.getNumVertices();
        int i2 = 0;
        while (i2 < numPermutations) {
            int novCurrent = this.m_geom.getNumVertices();
            this.m_geom.setNumVertices(novCurrent + novStart - 1);
            this.m_geom.setNumVertices(novCurrent);
            int j = 0;
            while (j < numEdges) {
                PiVector edge = this.m_geom.getEdgeInformation(nextEdgeIndex);
                edge.copy(this.m_geom.getEdgeInformation(j));
                edge.clearTag(1);
                int si = this.m_geom.getPreviousEdgeIndex(nextEdgeIndex);
                edge.m_data[0] = si != -1 ? locReplaceIndex.m_data[si] : rootEdgeIndex;
                edge.m_data[3] = PnZomeSymmetry.m_symmetry[this.m_geom.getEdgeColor((int)nextEdgeIndex)][pIndex[i2]].m_data[edge.m_data[3]];
                PiVector startPoint = this.getIntStartPoint(nextEdgeIndex);
                PiVector endPoint = new PiVector(6);
                endPoint.copy(startPoint);
                endPoint.add(this.m_geom.getEdgeDir(nextEdgeIndex));
                replaceIndex.m_data[nextEdgeIndex] = nextEdgeIndex;
                this.setTarget(edge, endPoint);
                this.getEdgeIndex(this.m_geom.getStartVertexIndex(edge), edge.m_data[4], replaceIndex, nextEdgeIndex);
                if (replaceIndex.m_data[nextEdgeIndex] == nextEdgeIndex) {
                    locReplaceIndex.m_data[j] = nextEdgeIndex;
                    this.m_geom.registerEdge(nextEdgeIndex);
                    ++nextEdgeIndex;
                } else {
                    locReplaceIndex.m_data[j] = replaceIndex.m_data[nextEdgeIndex];
                    --newNumEdges;
                }
                ++j;
            }
            ++i2;
        }
        this.m_geom.setNumPolygons(newNumEdges);
    }

    protected PiVector getIntStartPoint(int index) {
        if (this.m_geom.getPreviousEdgeIndex(index) == -1) {
            return this.m_geom.getIntPosition(0);
        }
        return this.m_geom.getIntPosition(this.m_geom.getEdgeTarget(this.m_geom.getPreviousEdgeIndex(index)));
    }

    protected void getEdgeIndex(int startIndex, int endIndex, PiVector replaceIndex, int maxIndex) {
        int edgeIndex = this.m_geom.getEdgeIndex(startIndex, endIndex);
        if (edgeIndex == -1 || edgeIndex >= maxIndex) {
            return;
        }
        replaceIndex.m_data[maxIndex] = endIndex == this.m_geom.getEdgeTarget(edgeIndex) ? edgeIndex : this.m_geom.getPreviousEdgeIndex(edgeIndex);
        while (replaceIndex.m_data[maxIndex] != -1 && replaceIndex.m_data[replaceIndex.m_data[maxIndex]] != replaceIndex.m_data[maxIndex]) {
            replaceIndex.m_data[maxIndex] = replaceIndex.m_data[replaceIndex.m_data[maxIndex]];
        }
    }

    protected void removeDuplicateEdges() {
        int numEdges = this.m_geom.getNumPolygons();
        PiVector replaceIndex = new PiVector(numEdges);
        PiVector newIndex = new PiVector(numEdges);
        int nextFreeIndex = 0;
        int newNumEdges = numEdges;
        int i = 0;
        while (i < numEdges) {
            replaceIndex.m_data[i] = i;
            PiVector startPoint = this.getIntStartPoint(i);
            PiVector endPoint = this.m_geom.getEdgeDir(i);
            endPoint.add(startPoint);
            this.getEdgeIndex(this.m_geom.getStartVertexIndex(this.m_geom.getEdgeInformation(i)), this.m_geom.getEdgeTarget(i), replaceIndex, i);
            if (replaceIndex.m_data[i] != i) {
                --newNumEdges;
            } else {
                newIndex.m_data[i] = nextFreeIndex++;
            }
            ++i;
        }
        PiVector[] newBuildTree = new PiVector[newNumEdges];
        newNumEdges = 0;
        int i2 = 0;
        while (i2 < numEdges) {
            if (replaceIndex.m_data[i2] == i2) {
                int si = this.m_geom.getPreviousEdgeIndex(i2);
                if (si != -1) {
                    this.m_geom.getEdgeInformation((int)i2).m_data[0] = replaceIndex.m_data[si] == -1 ? -1 : newIndex.m_data[replaceIndex.m_data[si]];
                }
                newBuildTree[newNumEdges] = this.m_geom.getEdgeInformation(i2);
                ++newNumEdges;
            }
            ++i2;
        }
        this.m_geom.setNumPolygons(newNumEdges);
        this.m_geom.setBuildTree(newBuildTree);
        this.m_geom.computeEdgeAtVertexInformation();
    }

    protected boolean connectSelectedPoints() {
        int numSelectedVertices = this.findSelectedVertices();
        if (numSelectedVertices != 2) {
            PsDebug.message((String)"Selection failed.");
            return false;
        }
        int edgeIndex = this.m_geom.getEdgeIndex(this.m_selectedVertexIndex.m_data[0], this.m_selectedVertexIndex.m_data[1]);
        this.m_geom.clearTagVertex(this.m_selectedVertexIndex.m_data[0], 1);
        this.m_geom.clearTagVertex(this.m_selectedVertexIndex.m_data[1], 1);
        if (edgeIndex != -1) {
            PsDebug.message((String)("Selected vertices are already connected by edge " + edgeIndex));
            return false;
        }
        PiVector edge = new PiVector(6);
        if (!this.connectPoints(this.m_selectedVertexIndex.m_data[0], this.m_selectedVertexIndex.m_data[1], edge)) {
            this.m_geom.update((Object)this.m_geom);
            return false;
        }
        if (this.m_bLogOperation) {
            this.m_log.logOperationV(15, this.m_selectedVertexIndex);
        }
        int numEdges = this.m_geom.getNumPolygons();
        this.m_geom.setNumPolygons(numEdges + 1);
        this.m_geom.getEdgeInformation(numEdges).copy(edge);
        this.m_geom.registerEdge(numEdges);
        this.m_geom.computePolygonSet();
        this.m_geom.update((Object)this.m_geom);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean connectPoints(int index0, int index1, PiVector edge) {
        edge.m_data[0] = this.findEdgeTo(index0);
        edge.m_data[4] = index1;
        edge.m_data[5] = 0;
        direction = PiVector.subNew((PiVector)this.m_geom.getIntPosition(index1), (PiVector)this.m_geom.getIntPosition(index0));
        edge.m_data[1] = -1;
        i = 0;
        while (i < 4) {
            j = 0;
            while (j < PnZomeSymmetry.m_numColDirs[i]) {
                if (this.checkDirection(direction, PnZomeSymmetry.m_intDir[i][j])) {
                    edge.m_data[1] = i;
                    edge.m_data[3] = j;
                    break;
                }
                ++j;
            }
            if (edge.m_data[1] != -1) break;
            ++i;
        }
        if (edge.m_data[1] == -1) {
            PsDebug.message((String)("No valid direction between vertices " + index0 + " and " + index1));
            return false;
        }
        sqrLengthOriginal = new PiVector(2);
        currentSqrLength = new PiVector(2);
        this.scalarProduct(direction, direction, currentSqrLength);
        this.scalarProduct(PnZomeSymmetry.m_intDir[edge.m_data[1]][edge.m_data[3]], PnZomeSymmetry.m_intDir[edge.m_data[1]][edge.m_data[3]], sqrLengthOriginal);
        diff = PiVector.subNew((PiVector)sqrLengthOriginal, (PiVector)currentSqrLength);
        edge.m_data[2] = 0;
        if (this.sign(diff.m_data[0], diff.m_data[1]) != 0) ** GOTO lbl36
        return true;
lbl-1000:
        // 1 sources

        {
            PnZomeSymmetry.scale(currentSqrLength, PnZomeSymmetry.PHI);
            PnZomeSymmetry.scale(currentSqrLength, PnZomeSymmetry.PHI);
            edge.m_data[2] = edge.m_data[2] - 1;
            diff.sub(sqrLengthOriginal, currentSqrLength);
            if (this.sign(diff.m_data[0], diff.m_data[1]) != 0) continue;
            return true;
lbl36:
            // 2 sources

            ** while (this.sign((int)diff.m_data[0], (int)diff.m_data[1]) == 1)
        }
lbl37:
        // 2 sources

        while (this.sign(diff.m_data[0], diff.m_data[1]) == -1) {
            PnZomeSymmetry.scale(currentSqrLength, PnZomeSymmetry.INV_PHI);
            PnZomeSymmetry.scale(currentSqrLength, PnZomeSymmetry.INV_PHI);
            edge.m_data[2] = edge.m_data[2] + 1;
            diff.sub(sqrLengthOriginal, currentSqrLength);
            if (this.sign(diff.m_data[0], diff.m_data[1]) != 0) continue;
            return true;
        }
        if (edge.m_data[1] == 3) {
            edge.m_data[1] = 4;
            currentSqrLength.multScalar(4);
            diff.sub(sqrLengthOriginal, currentSqrLength);
            while (this.sign(diff.m_data[0], diff.m_data[1]) == -1) {
                PnZomeSymmetry.scale(currentSqrLength, PnZomeSymmetry.INV_PHI);
                PnZomeSymmetry.scale(currentSqrLength, PnZomeSymmetry.INV_PHI);
                edge.m_data[2] = edge.m_data[2] + 1;
                diff.sub(sqrLengthOriginal, currentSqrLength);
                if (this.sign(diff.m_data[0], diff.m_data[1]) == 0) {
                    return true;
                }
                diff.sub(sqrLengthOriginal, currentSqrLength);
            }
        }
        if (edge.m_data[1] == 0) {
            PsDebug.message((String)("Red direction - no valid distance found between vertices " + index0 + " and " + index1));
        } else if (edge.m_data[1] == 1) {
            PsDebug.message((String)("Yellow direction - no valid distance found between vertices " + index0 + " and " + index1));
        } else if (edge.m_data[1] == 2) {
            PsDebug.message((String)("Blue direction - no valid distance found between vertices " + index0 + " and " + index1));
        } else {
            PsDebug.message((String)("Green direction - no valid distance found between vertices " + index0 + " and " + index1));
        }
        return false;
    }

    protected boolean checkDirection(PiVector dir0, PiVector dir1) {
        int i = 0;
        while (i < 3) {
            if (dir0.m_data[(2 * i + 2) % 6] * dir1.m_data[(2 * i + 4) % 6] + 5 * dir0.m_data[(2 * i + 3) % 6] * dir1.m_data[(2 * i + 5) % 6] - (dir1.m_data[(2 * i + 2) % 6] * dir0.m_data[(2 * i + 4) % 6] + 5 * dir1.m_data[(2 * i + 3) % 6] * dir0.m_data[(2 * i + 5) % 6]) != 0) {
                return false;
            }
            if (dir0.m_data[(2 * i + 2) % 6] * dir1.m_data[(2 * i + 5) % 6] + dir0.m_data[(2 * i + 3) % 6] * dir1.m_data[(2 * i + 4) % 6] - (dir1.m_data[(2 * i + 2) % 6] * dir0.m_data[(2 * i + 5) % 6] + dir1.m_data[(2 * i + 3) % 6] * dir0.m_data[(2 * i + 4) % 6]) != 0) {
                return false;
            }
            ++i;
        }
        PiVector sp = new PiVector(2);
        this.scalarProduct(dir0, dir1, sp);
        return this.sign(sp.m_data[0], sp.m_data[1]) == 1;
    }

    protected void scalarProduct(PiVector dir0, PiVector dir1, PiVector out) {
        out.m_data[0] = dir0.m_data[0] * dir1.m_data[0] + 5 * dir0.m_data[1] * dir1.m_data[1] + dir0.m_data[2] * dir1.m_data[2] + 5 * dir0.m_data[3] * dir1.m_data[3] + dir0.m_data[4] * dir1.m_data[4] + 5 * dir0.m_data[5] * dir1.m_data[5];
        out.m_data[1] = dir0.m_data[0] * dir1.m_data[1] + dir0.m_data[1] * dir1.m_data[0] + dir0.m_data[2] * dir1.m_data[3] + dir0.m_data[3] * dir1.m_data[2] + dir0.m_data[4] * dir1.m_data[5] + dir0.m_data[5] * dir1.m_data[4];
    }

    protected int sign(int a, int b) {
        if (a == 0 && b == 0) {
            return 0;
        }
        if (a * a > 5 * b * b && a > 0 || a * a < 5 * b * b && b > 0) {
            return 1;
        }
        return -1;
    }

    protected int findEdgeTo(int index) {
        if (index == 0) {
            return -1;
        }
        int numEdges = this.m_geom.getNumPolygons();
        int i = 0;
        while (i < numEdges) {
            if (this.m_geom.getEdgeTarget(i) == index) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void setSelectedVertexToRoot() {
        int numVertices = this.m_geom.getNumVertices();
        int i = 0;
        while (i < numVertices) {
            if (this.m_geom.hasTagVertex(i, 1)) {
                int oldRoot = this.changeRoot(i);
                this.m_geom.clearTagVertex(i, 1);
                this.m_geom.setTagVertex(oldRoot, 1);
                this.m_geom.computePolygonSet();
                this.m_geom.update((Object)this.m_geom);
                return;
            }
            ++i;
        }
    }

    protected int changeRoot(int rootIndex) {
        return this.changeRoot(rootIndex, null);
    }

    protected int changeRoot(int rootIndex, PiVector replaceEdgeIndex) {
        if (rootIndex == 0) {
            if (replaceEdgeIndex != null) {
                int numEdges = this.m_geom.getNumPolygons();
                if (replaceEdgeIndex.getSize() == numEdges) {
                    int i = 0;
                    while (i < numEdges) {
                        replaceEdgeIndex.m_data[i] = i;
                        ++i;
                    }
                }
            }
            return 0;
        }
        int numEdges = this.m_geom.getNumPolygons();
        int numVertices = this.m_geom.getNumVertices();
        PiVector edgeToPoint = new PiVector(numVertices);
        edgeToPoint.setConstant(-2);
        edgeToPoint.m_data[0] = -1;
        int i = 0;
        while (i < numEdges) {
            if (edgeToPoint.m_data[this.m_geom.getEdgeTarget(i)] == -2) {
                edgeToPoint.m_data[this.m_geom.getEdgeTarget((int)i)] = i;
            }
            ++i;
        }
        PiVector[] newBuildTree = PiVector.realloc(null, (int)numEdges, (int)6);
        if (replaceEdgeIndex == null || replaceEdgeIndex.getSize() != numEdges) {
            replaceEdgeIndex = new PiVector(numEdges);
        }
        replaceEdgeIndex.setConstant(-2);
        PiVector replaceVertexIndex = new PiVector(numVertices);
        replaceVertexIndex.setConstant(-1);
        int currentEdgeIndex = edgeToPoint.m_data[rootIndex];
        replaceVertexIndex.m_data[rootIndex] = 0;
        int nextVertexIndex = 1;
        int nextEdgeIndex = 0;
        while (currentEdgeIndex != -1) {
            newBuildTree[nextEdgeIndex].copy(this.m_geom.getEdgeInformation(currentEdgeIndex));
            newBuildTree[nextEdgeIndex].m_data[3] = this.invertDirection(newBuildTree[nextEdgeIndex].m_data[1], newBuildTree[nextEdgeIndex].m_data[3]);
            newBuildTree[nextEdgeIndex].m_data[4] = nextVertexIndex;
            int previousVertex = this.m_geom.getStartVertexIndex(this.m_geom.getEdgeInformation(currentEdgeIndex));
            replaceVertexIndex.m_data[previousVertex] = nextVertexIndex++;
            newBuildTree[nextEdgeIndex].m_data[0] = nextEdgeIndex - 1;
            replaceEdgeIndex.m_data[currentEdgeIndex] = nextEdgeIndex - 1;
            currentEdgeIndex = edgeToPoint.m_data[previousVertex];
            ++nextEdgeIndex;
        }
        int lastInPath = nextEdgeIndex - 1;
        int i2 = 0;
        while (i2 < numEdges) {
            if (replaceEdgeIndex.m_data[i2] == -2) {
                newBuildTree[nextEdgeIndex].copy(this.m_geom.getEdgeInformation(i2));
                newBuildTree[nextEdgeIndex].m_data[0] = newBuildTree[nextEdgeIndex].m_data[0] == -1 ? lastInPath : replaceEdgeIndex.m_data[newBuildTree[nextEdgeIndex].m_data[0]];
                replaceEdgeIndex.m_data[i2] = nextEdgeIndex;
                if (replaceVertexIndex.m_data[newBuildTree[nextEdgeIndex].m_data[4]] == -1) {
                    replaceVertexIndex.m_data[newBuildTree[nextEdgeIndex].m_data[4]] = nextVertexIndex++;
                }
                newBuildTree[nextEdgeIndex].m_data[4] = replaceVertexIndex.m_data[newBuildTree[nextEdgeIndex].m_data[4]];
                ++nextEdgeIndex;
            }
            ++i2;
        }
        PiVector[] newIntVertex = PiVector.realloc(null, (int)numVertices, (int)6);
        int i3 = 0;
        while (i3 < numVertices) {
            newIntVertex[replaceVertexIndex.m_data[i3]].copy(this.m_geom.getIntPosition(i3));
            newIntVertex[replaceVertexIndex.m_data[i3]].sub(this.m_geom.getIntPosition(rootIndex));
            ++i3;
        }
        this.m_geom.setIntVertices(newIntVertex);
        this.m_geom.setBuildTree(newBuildTree);
        this.m_geom.computeEdgeAtVertexInformation();
        return replaceVertexIndex.m_data[0];
    }

    protected int invertDirection(int color, int direction) {
        return (direction + PnZomeSymmetry.m_numColDirs[color] / 2) % PnZomeSymmetry.m_numColDirs[color];
    }

    public void storeTree() {
        int numEdges = this.m_geom.getNumPolygons();
        String fileName = this.m_fullTreeFileName;
        File treeFile = new File(fileName);
        try {
            FileWriter fw = new FileWriter(treeFile, false);
            BufferedWriter bw = new BufferedWriter(fw);
            int i = 0;
            while (i < numEdges) {
                bw.write(i + " " + this.m_geom.getPreviousEdgeIndex(i) + " " + this.m_geom.getEdgeColor(i) + " " + this.m_geom.getEdgeLength(i) + " " + this.m_geom.getEdgeDirection(i) + " " + this.m_geom.getEdgeTarget(i) + " " + this.m_geom.getEdgeInformation((int)i).m_data[5] + "\r\n");
                ++i;
            }
            bw.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void loadTree() {
        String fileName = this.m_fullTreeFileName;
        File treeFile = new File(fileName);
        Vector<PiVector> ev = new Vector<PiVector>();
        try {
            FileReader fr = new FileReader(treeFile);
            BufferedReader br = new BufferedReader(fr);
            StreamTokenizer st = new StreamTokenizer(br);
            st.nextToken();
            while (st.ttype != -1) {
                PiVector edge = new PiVector(6);
                st.nextToken();
                int i = 0;
                while (i < 6) {
                    edge.m_data[i] = (int)st.nval;
                    st.nextToken();
                    ++i;
                }
                ev.addElement(edge);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        int numEdges = ev.size();
        this.m_geom.setNumPolygons(numEdges);
        int i = 0;
        while (i < numEdges) {
            this.m_geom.getEdgeInformation(i).copy((PiVector)ev.elementAt(i));
            ++i;
        }
        this.m_geom.buildFromTree();
        this.m_geom.computeEdgeAtVertexInformation();
        this.m_geom.update((Object)this.m_geom);
    }

    public void selectEdges(int col, int dir, int length) {
        int numEdges = this.m_geom.getNumPolygons();
        int i = 0;
        while (i < numEdges) {
            if (this.m_geom.getEdgeColor(i) == col && this.m_geom.getEdgeLength(i) == length && (this.m_geom.getEdgeDirection(i) == dir || this.invertDirection(col, this.m_geom.getEdgeDirection(i)) == dir)) {
                this.m_geom.setTagPolygon(i, 1);
            }
            ++i;
        }
        this.m_geom.update((Object)this.m_geom);
    }

    public void scaleSelectedEdges(int scale) {
        int numEdges = this.findSelectedEdges();
        if (numEdges == 0) {
            PsDebug.message((String)"No selected edges were found.");
            return;
        }
        int i = 0;
        while (i < numEdges) {
            this.m_geom.getEdgeInformation((int)this.m_selectedEdgeIndex.m_data[i]).m_data[2] = this.m_geom.getEdgeInformation((int)this.m_selectedEdgeIndex.m_data[i]).m_data[2] + scale;
            ++i;
        }
        if (this.m_bLogOperation) {
            if (scale == 1) {
                this.m_log.logOperationE(5, this.m_selectedEdgeIndex);
            } else if (scale == -1) {
                this.m_log.logOperationE(6, this.m_selectedEdgeIndex);
            }
        }
        this.m_geom.buildFromTree();
        this.m_geom.computePolygonSet();
        this.m_geom.update((Object)this.m_geom);
    }

    public void closeCycle() {
        int currentEdgeIndex;
        int numEdges = this.m_geom.getNumPolygons();
        int nov = this.m_geom.getNumVertices();
        PiVector[] selectedEdgeAtVertex = new PiVector[nov];
        int[] vertexIndex = new int[2];
        int numSingle = 0;
        int numDouble = 0;
        int numSelectedEdges = this.findSelectedEdges();
        if (numSelectedEdges < 2) {
            PsDebug.message((String)"Less than two selected edges were found.");
            return;
        }
        int i = 0;
        while (i < numSelectedEdges) {
            vertexIndex[0] = this.m_geom.getStartVertexIndex(this.m_geom.getEdgeInformation(this.m_selectedEdgeIndex.m_data[i]));
            vertexIndex[1] = this.m_geom.getEdgeTarget(this.m_selectedEdgeIndex.m_data[i]);
            int j = 0;
            while (j < 2) {
                if (selectedEdgeAtVertex[vertexIndex[j]] == null) {
                    selectedEdgeAtVertex[vertexIndex[j]] = new PiVector(1);
                    selectedEdgeAtVertex[vertexIndex[j]].m_data[0] = this.m_selectedEdgeIndex.m_data[i];
                    ++numSingle;
                } else {
                    if (selectedEdgeAtVertex[vertexIndex[j]].getSize() == 2) {
                        PsDebug.message((String)"Cannot close cycle, there is a vertex with more than two selected adjacent edges.");
                        return;
                    }
                    selectedEdgeAtVertex[vertexIndex[j]].setSize(2);
                    selectedEdgeAtVertex[vertexIndex[j]].m_data[1] = this.m_selectedEdgeIndex.m_data[i];
                    --numSingle;
                    ++numDouble;
                }
                ++j;
            }
            ++i;
        }
        if (numSingle == 0) {
            PsDebug.message((String)"Cannot close cycle, no vertex with just one selected adjacent edge was found.");
            return;
        }
        if (numSingle > 2) {
            PsDebug.message((String)"Cannot close cycle, more than two vertices with just one selected adjacent edge were found.");
            return;
        }
        int startPoint = -1;
        int endPoint = -1;
        int i2 = 0;
        while (i2 < nov) {
            if (selectedEdgeAtVertex[i2] != null && selectedEdgeAtVertex[i2].getSize() != 2) {
                if (startPoint == -1) {
                    startPoint = i2;
                } else {
                    endPoint = i2;
                }
            }
            ++i2;
        }
        PiVector edgeIndex = new PiVector(numDouble + 1);
        boolean[] invert = new boolean[numDouble + 1];
        edgeIndex.m_data[0] = currentEdgeIndex = selectedEdgeAtVertex[startPoint].m_data[0];
        int currentVertexIndex = startPoint;
        int i3 = 0;
        while (i3 < numDouble) {
            invert[i3] = this.m_geom.getEdgeTarget(currentEdgeIndex) == currentVertexIndex;
            currentVertexIndex = invert[i3] ? this.m_geom.getStartVertexIndex(this.m_geom.getEdgeInformation(currentEdgeIndex)) : this.m_geom.getEdgeTarget(currentEdgeIndex);
            if (currentVertexIndex == endPoint) {
                PsDebug.message((String)"Cannot close cycle, the selected edges are not an edge path.");
                return;
            }
            currentEdgeIndex = selectedEdgeAtVertex[currentVertexIndex].m_data[0] == currentEdgeIndex ? selectedEdgeAtVertex[currentVertexIndex].m_data[1] : selectedEdgeAtVertex[currentVertexIndex].m_data[0];
            edgeIndex.m_data[i3 + 1] = currentEdgeIndex;
            ++i3;
        }
        invert[numDouble] = this.m_geom.getEdgeTarget(currentEdgeIndex) != endPoint;
        int previousEdge = -1;
        previousEdge = invert[numDouble] ? this.m_geom.getPreviousEdgeIndex(currentEdgeIndex) : currentEdgeIndex;
        if (this.m_bLogOperation) {
            this.m_log.logOperationE(16, this.m_selectedEdgeIndex);
        }
        this.m_geom.setNumPolygons(numEdges + numDouble + 1);
        int numNewEdges = 0;
        int i4 = 0;
        while (i4 < numDouble + 1) {
            this.m_geom.clearTagPolygon(edgeIndex.m_data[i4], 1);
            this.m_geom.getEdgeInformation(numEdges + numNewEdges).copy(this.m_geom.getEdgeInformation(edgeIndex.m_data[i4]));
            if (!invert[i4]) {
                this.m_geom.getEdgeInformation((int)(numEdges + numNewEdges)).m_data[3] = this.invertDirection(this.m_geom.getEdgeColor(numEdges + numNewEdges), this.m_geom.getEdgeDirection(numEdges + numNewEdges));
            }
            this.m_geom.getEdgeInformation((int)(numEdges + numNewEdges)).m_data[0] = previousEdge;
            int startInd = this.m_geom.getStartVertexIndex(this.m_geom.getEdgeInformation(numEdges + numNewEdges));
            PiVector position = PiVector.copyNew((PiVector)this.m_geom.getIntPosition(startInd));
            PiVector direction = this.m_geom.getEdgeDir(numEdges + numNewEdges);
            position.add(direction);
            this.setTarget(this.m_geom.getEdgeInformation(numEdges + numNewEdges), position);
            int edgeInd = this.m_geom.getEdgeIndex(startInd, this.m_geom.getEdgeTarget(numEdges + numNewEdges));
            if (edgeInd == -1) {
                this.m_geom.registerEdge(numEdges + numNewEdges);
                previousEdge = numEdges + numNewEdges;
                ++numNewEdges;
            } else {
                previousEdge = this.m_geom.getEdgeTarget(edgeInd) == this.m_geom.getEdgeTarget(numEdges + numNewEdges) ? edgeInd : this.m_geom.getPreviousEdgeIndex(edgeInd);
            }
            ++i4;
        }
        this.m_geom.setNumPolygons(numEdges + numNewEdges);
        this.m_geom.computePolygonSet();
        this.m_geom.update((Object)this.m_geom);
    }

    public void partList() {
        int numEdges = this.m_geom.getNumPolygons();
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        int i = 0;
        while (i < numEdges) {
            if (this.m_geom.getEdgeLength(i) > max) {
                max = this.m_geom.getEdgeLength(i);
            }
            if (this.m_geom.getEdgeLength(i) < min) {
                min = this.m_geom.getEdgeLength(i);
            }
            ++i;
        }
        PiVector[] numSolidParts = PiVector.realloc(null, (int)5, (int)(max + 1 - min));
        PiVector[] numVirtualParts = PiVector.realloc(null, (int)5, (int)(max + 1 - min));
        int i2 = 0;
        while (i2 < 5) {
            numSolidParts[i2].setConstant(0);
            numVirtualParts[i2].setConstant(0);
            ++i2;
        }
        i2 = 0;
        while (i2 < numEdges) {
            if (this.m_geom.edgeIsVirtual(i2)) {
                int n = this.m_geom.getEdgeLength(i2) - min;
                numVirtualParts[this.m_geom.getEdgeColor((int)i2)].m_data[n] = numVirtualParts[this.m_geom.getEdgeColor((int)i2)].m_data[n] + 1;
            } else {
                int n = this.m_geom.getEdgeLength(i2) - min;
                numSolidParts[this.m_geom.getEdgeColor((int)i2)].m_data[n] = numSolidParts[this.m_geom.getEdgeColor((int)i2)].m_data[n] + 1;
            }
            ++i2;
        }
        int nov = this.m_geom.getNumVertices();
        int numBalls = 0;
        int i3 = 0;
        while (i3 < nov) {
            if (!this.m_geom.vertexIsVirtual(i3)) {
                ++numBalls;
            }
            ++i3;
        }
        PsDebug.message((String)"+------------------------- +");
        PsDebug.message((String)"|      List of Parts       |");
        PsDebug.message((String)"+------------------------- +");
        PsDebug.message((String)"    - V E R T I C E S -     ");
        PsDebug.message((String)"+------------------------- +");
        PsDebug.message((String)("| Solid Vertices:   " + String.format("%6d", numBalls) + " |"));
        PsDebug.message((String)("| Virtual Vertices: " + String.format("%6d", nov - numBalls) + " |"));
        PsDebug.message((String)"+------------------------- +");
        PsDebug.message((String)"       - E D G E S -        ");
        String line = "+--------------------+";
        String len = "| Length             |";
        int j = 0;
        while (j < max + 1 - min) {
            line = String.valueOf(line) + "--------+";
            len = j + min == 0 ? String.valueOf(len) + "      0 |" : String.valueOf(len) + " " + String.format("%6d", j + min) + " |";
            ++j;
        }
        PsDebug.message((String)line);
        PsDebug.message((String)len);
        PsDebug.message((String)line);
        String[] solid = new String[]{"| Solid Red          |", "| Solid Yellow       |", "| Solid Blue         |", "| Solid Green        |", "| Solid Half Green   |"};
        String[] virtual = new String[]{"| Virtual Red        |", "| Virtual Yellow     |", "| Virtual Blue       |", "| Virtual Green      |", "| Virtual Half Green |"};
        int i4 = 0;
        while (i4 < 5) {
            int j2 = 0;
            while (j2 < max + 1 - min) {
                if (numSolidParts[i4].m_data[j2] == 0) {
                    int n = i4;
                    solid[n] = String.valueOf(solid[n]) + "      0 |";
                } else {
                    int n = i4;
                    solid[n] = String.valueOf(solid[n]) + " " + String.format("%6d", numSolidParts[i4].m_data[j2]) + " |";
                }
                if (numVirtualParts[i4].m_data[j2] == 0) {
                    int n = i4;
                    virtual[n] = String.valueOf(virtual[n]) + "      0 |";
                } else {
                    int n = i4;
                    virtual[n] = String.valueOf(virtual[n]) + " " + String.format("%6d", numVirtualParts[i4].m_data[j2]) + " |";
                }
                ++j2;
            }
            PsDebug.message((String)solid[i4]);
            PsDebug.message((String)virtual[i4]);
            PsDebug.message((String)line);
            ++i4;
        }
    }

    public void setSolidSelectedEdges(boolean flag) {
        int numEdges = this.findSelectedEdges();
        if (numEdges == 0) {
            PsDebug.message((String)"No selected edges found.");
            return;
        }
        if (this.m_bLogOperation) {
            if (flag) {
                this.m_log.logOperationE(4, this.m_selectedEdgeIndex);
            } else {
                this.m_log.logOperationE(3, this.m_selectedEdgeIndex);
            }
        }
        this.m_geom.setSolidSelectedEdges(flag);
    }

    public void removeAllSelections() {
        int nov = this.m_geom.getNumVertices();
        int i = 0;
        while (i < nov) {
            this.m_geom.clearTagVertex(i, 1);
            ++i;
        }
        int nop = this.m_geom.getNumPolygons();
        int i2 = 0;
        while (i2 < nop) {
            this.m_geom.clearTagPolygon(i2, 1);
            ++i2;
        }
        this.m_geom.update((Object)this.m_geom);
    }

    public void clearZomeSet() {
        this.removeAllSelections();
        this.m_geom.setNumPolygons(0);
        this.m_geom.setNumVertices(1);
        this.m_geom.buildFromTree();
        this.m_geom.computePolygonSet();
        this.m_geom.update((Object)this.m_geom);
    }

    protected void select(int[] vertexIndex, int[] edgeIndex) {
        int i;
        int numSelected;
        this.removeAllSelections();
        if (vertexIndex != null) {
            int nov = this.m_geom.getNumVertices();
            numSelected = vertexIndex.length;
            if (this.m_selectedVertexIndex == null) {
                this.m_selectedVertexIndex = new PiVector(numSelected);
            }
            this.m_selectedVertexIndex.setSize(numSelected);
            i = 0;
            while (i < numSelected) {
                if (vertexIndex[i] >= nov || vertexIndex[i] < 0) {
                    PsDebug.message((String)"Invalid vertex index.");
                    return;
                }
                this.m_geom.setTagVertex(vertexIndex[i], 1);
                this.m_selectedVertexIndex.m_data[i] = vertexIndex[i];
                ++i;
            }
        }
        if (edgeIndex != null) {
            int nop = this.m_geom.getNumPolygons();
            numSelected = edgeIndex.length;
            if (this.m_selectedEdgeIndex == null) {
                this.m_selectedEdgeIndex = new PiVector(numSelected);
            }
            this.m_selectedEdgeIndex.setSize(numSelected);
            i = 0;
            while (i < numSelected) {
                if (edgeIndex[i] >= nop || edgeIndex[i] < 0) {
                    PsDebug.message((String)"Invalid edge index.");
                    return;
                }
                this.m_geom.setTagPolygon(edgeIndex[i], 1);
                this.m_selectedEdgeIndex.m_data[i] = edgeIndex[i];
                ++i;
            }
        }
    }

    public void setDisplay(PvDisplayIf display) {
        super.setDisplay(display);
        if (this.m_zomeSelect != null) {
            this.m_zomeSelect.setDisplay(display);
        }
        if (this.m_selectTransform != null) {
            this.m_selectTransform.setDisplay(display);
        }
    }

    protected boolean showSelectorAtVertex() {
        int numSelected = this.findSelectedVertices();
        if (numSelected == 0) {
            return false;
        }
        this.m_zomeSelect.setCenter(this.m_geom.getVertex(this.m_selectedVertexIndex.m_data[0]));
        this.m_zomeSelect.computeEdges();
        this.m_zomeSelect.setVisibleGeom(true);
        return true;
    }

    protected boolean showSelectorAtEdge() {
        int numSelected = this.findSelectedEdges();
        if (numSelected == 0) {
            return false;
        }
        int edgeInd = this.m_selectedEdgeIndex.m_data[0];
        PiVector edge = this.m_geom.getEdgeInformation(edgeInd);
        int startInd = this.m_geom.getStartVertexIndex(edge);
        PdVector center = this.m_geom.getVertex(startInd);
        this.m_zomeSelect.setCenter(center);
        this.m_zomeSelect.computeEdges();
        this.m_zomeSelect.setVisibleGeom(true);
        return true;
    }

    protected boolean showSelectorAtRootVertex() {
        this.m_zomeSelect.setCenter(this.m_geom.getVertex(0));
        this.m_zomeSelect.computeEdges();
        this.m_zomeSelect.setVisibleGeom(true);
        return true;
    }

    public void addEdgeBySelector() {
        PiVector[] edge = this.m_zomeSelect.getEdgeSelection();
        this.m_zomeSelect.setVisibleGeom(false);
        if (edge == null) {
            PsDebug.message((String)"Selecting failed.", (boolean)false);
            return;
        }
        int numSelEdges = edge.length;
        if (numSelEdges == 0) {
            PsDebug.message((String)"No edges to add were selected.");
            return;
        }
        if (this.m_bLogOperation) {
            int[] dir = new int[numSelEdges];
            int i = 0;
            while (i < numSelEdges) {
                dir[i] = edge[i].m_data[3];
                ++i;
            }
            this.m_log.logOperationCDLV(0, edge[0].m_data[1], dir, edge[0].m_data[2], this.m_selectedVertexIndex);
        }
        this.addEdgeAtSelectedVertices(edge);
    }

    public void addPlaneReflectionBySelector() {
        PiVector[] edge = this.m_zomeSelect.getEdgeSelection();
        this.m_zomeSelect.setVisibleGeom(false);
        if (edge == null) {
            PsDebug.message((String)"Selecting failed.", (boolean)false);
            return;
        }
        int numDirections = edge.length;
        if (numDirections != 1) {
            PsDebug.message((String)"Selecting failed.", (boolean)false);
            return;
        }
        this.addPlaneReflection(edge[0].m_data[3]);
    }

    public void addEdgeSymmetryBySelector(boolean bOrientedOnly) {
        PiVector[] edge = this.m_zomeSelect.getEdgeSelection();
        this.m_zomeSelect.setVisibleGeom(false);
        if (edge == null) {
            PsDebug.message((String)"Selecting failed.", (boolean)false);
            return;
        }
        int numDirections = edge.length;
        if (numDirections != 1) {
            PsDebug.message((String)"Selecting failed.", (boolean)false);
            return;
        }
        this.addEdgeSymmetry(edge[0].m_data[1], edge[0].m_data[3], -1, bOrientedOnly);
    }

    public void parallelConnectedCopySelectedBySelector() {
        int ne;
        int nv = this.findSelectedVertices();
        if (nv + (ne = this.findSelectedEdges()) == 0) {
            PsDebug.message((String)"No selection was found.");
            return;
        }
        int nov = this.m_geom.getNumVertices();
        boolean[] bVertexSelected = new boolean[nov];
        int i = 0;
        while (i < nov) {
            bVertexSelected[i] = this.m_geom.hasTagVertex(i, 1);
            this.m_geom.clearTagVertex(i, 1);
            ++i;
        }
        int nop = this.m_geom.getNumPolygons();
        boolean[] bEdgeSelected = new boolean[nop];
        int i2 = 0;
        while (i2 < nop) {
            bEdgeSelected[i2] = this.m_geom.hasTagPolygon(i2, 1);
            this.m_geom.clearTagPolygon(i2, 1);
            ++i2;
        }
        PiVector[] edge = this.m_zomeSelect.getEdgeSelection();
        this.m_zomeSelect.setVisibleGeom(false);
        if (edge == null) {
            PsDebug.message((String)"Selecting failed.", (boolean)false);
            return;
        }
        if (this.m_bLogOperation) {
            int numNewDirections = edge.length;
            int[] dir = new int[numNewDirections];
            int i3 = 0;
            while (i3 < numNewDirections) {
                dir[i3] = edge[i3].m_data[3];
                ++i3;
            }
            this.m_log.logOperationCDLVE(2, edge[0].m_data[1], dir, edge[0].m_data[2], this.m_selectedVertexIndex, this.m_selectedEdgeIndex);
        }
        this.parallelConnectedCopy(bVertexSelected, bEdgeSelected, edge);
    }

    public void parallelConnectedCopyAllBySelector() {
        int nov = this.m_geom.getNumVertices();
        boolean[] bVertexSelected = new boolean[nov];
        int i = 0;
        while (i < nov) {
            bVertexSelected[i] = true;
            ++i;
        }
        int nop = this.m_geom.getNumPolygons();
        boolean[] bEdgeSelected = new boolean[nop];
        int i2 = 0;
        while (i2 < nop) {
            bEdgeSelected[i2] = true;
            ++i2;
        }
        PiVector[] edge = this.m_zomeSelect.getEdgeSelection();
        this.m_zomeSelect.setVisibleGeom(false);
        if (edge == null) {
            PsDebug.message((String)"Selecting failed.", (boolean)false);
            return;
        }
        if (this.m_bLogOperation) {
            int numNewDirections = edge.length;
            int[] dir = new int[numNewDirections];
            int i3 = 0;
            while (i3 < numNewDirections) {
                dir[i3] = edge[i3].m_data[3];
                ++i3;
            }
            this.m_log.logOperationCDL(2, edge[0].m_data[1], dir, edge[0].m_data[2]);
        }
        this.parallelConnectedCopy(bVertexSelected, bEdgeSelected, edge);
    }

    protected void parallelConnectedCopy(boolean[] bVertexSelected, boolean[] bEdgeSelected, PiVector[] edge) {
        int numNewDirections = edge.length;
        int nov = this.m_geom.getNumVertices();
        int numEdges = this.m_geom.getNumPolygons();
        PiVector newEdgeAtVert = new PiVector(nov);
        newEdgeAtVert.setConstant(-2);
        int i = 0;
        while (i < nov) {
            if (bVertexSelected[i]) {
                newEdgeAtVert.m_data[i] = -1;
            }
            ++i;
        }
        int numSelEdges = 0;
        PiVector edgeToVertex = new PiVector(nov);
        edgeToVertex.setConstant(-1);
        int i2 = 0;
        while (i2 < numEdges) {
            int target = this.m_geom.getEdgeTarget(i2);
            if (target != 0 && edgeToVertex.m_data[target] == -1) {
                edgeToVertex.m_data[target] = i2;
            }
            if (bEdgeSelected[i2]) {
                newEdgeAtVert.m_data[this.m_geom.getStartVertexIndex((PiVector)this.m_geom.getEdgeInformation((int)i2))] = -1;
                newEdgeAtVert.m_data[this.m_geom.getEdgeTarget((int)i2)] = -1;
                ++numSelEdges;
            }
            ++i2;
        }
        int numSelVertices = 0;
        int i3 = 0;
        while (i3 < nov) {
            if (newEdgeAtVert.m_data[i3] != -2) {
                ++numSelVertices;
            }
            ++i3;
        }
        int currentNumEdges = numEdges;
        PiVector targetPosition = new PiVector(6);
        int i4 = 0;
        while (i4 < numNewDirections) {
            this.m_geom.setNumPolygons(currentNumEdges + numSelVertices + numSelEdges);
            int numVE = 0;
            int j = 0;
            while (j < nov) {
                int newEdgeInd = newEdgeAtVert.m_data[j];
                if (newEdgeInd != -2) {
                    newEdgeAtVert.m_data[j] = newEdgeInd = currentNumEdges + numVE;
                    this.m_geom.getEdgeInformation(newEdgeInd).copy(edge[i4]);
                    this.m_geom.getEdgeInformation((int)newEdgeInd).m_data[0] = edgeToVertex.m_data[j];
                    targetPosition.copy(this.getIntStartPoint(newEdgeInd));
                    targetPosition.add(this.m_geom.getEdgeDir(newEdgeInd));
                    this.setTarget(this.m_geom.getEdgeInformation(newEdgeInd), targetPosition);
                    int edgeIndex = this.m_geom.getEdgeIndex(j, this.m_geom.getEdgeTarget(newEdgeInd));
                    if (edgeIndex == -1) {
                        this.m_geom.registerEdge(newEdgeInd);
                        ++numVE;
                    } else {
                        newEdgeAtVert.m_data[j] = this.m_geom.getEdgeTarget(edgeIndex) == this.m_geom.getEdgeTarget(newEdgeInd) ? edgeIndex : this.m_geom.getPreviousEdgeIndex(edgeIndex);
                    }
                }
                ++j;
            }
            int numEE = 0;
            int j2 = 0;
            while (j2 < numEdges) {
                if (bEdgeSelected[j2]) {
                    int startVertex = this.m_geom.getStartVertexIndex(this.m_geom.getEdgeInformation(j2));
                    int idx = currentNumEdges + numVE + numEE;
                    this.m_geom.getEdgeInformation(idx).copy(this.m_geom.getEdgeInformation(j2));
                    this.m_geom.getEdgeInformation((int)idx).m_data[0] = newEdgeAtVert.m_data[startVertex];
                    targetPosition.copy(this.getIntStartPoint(idx));
                    targetPosition.add(this.m_geom.getEdgeDir(idx));
                    this.setTarget(this.m_geom.getEdgeInformation(idx), targetPosition);
                    startVertex = this.m_geom.getStartVertexIndex(this.m_geom.getEdgeInformation(idx));
                    int edgeIndex = this.m_geom.getEdgeIndex(startVertex, this.m_geom.getEdgeTarget(idx));
                    if (edgeIndex == -1) {
                        this.m_geom.registerEdge(idx);
                        ++numEE;
                    }
                }
                ++j2;
            }
            currentNumEdges += numVE + numEE;
            ++i4;
        }
        this.m_geom.setNumPolygons(currentNumEdges);
        this.m_geom.computePolygonSet();
        this.m_geom.update((Object)this.m_geom);
    }

    protected boolean findTransformationsTwoEdges() {
        this.findTwoSelectedEdges();
        if (this.m_selectedEdgeIndex.getSize() != 2) {
            PsDebug.message((String)"There should be exactly two selected edges.");
            return false;
        }
        this.m_selectTransform.setEdges(new PiVector[]{this.m_geom.getEdgeInformation(this.m_selectedEdgeIndex.m_data[0]), this.m_geom.getEdgeInformation(this.m_selectedEdgeIndex.m_data[1])});
        PdVector pt0 = PdVector.blendNew((double)0.5, (PdVector)this.m_geom.getVertex(this.m_geom.getPolygon((int)this.m_selectedEdgeIndex.m_data[0]).m_data[0]), (double)0.5, (PdVector)this.m_geom.getVertex(this.m_geom.getPolygon((int)this.m_selectedEdgeIndex.m_data[0]).m_data[1]));
        PdVector pt1 = PdVector.blendNew((double)0.5, (PdVector)this.m_geom.getVertex(this.m_geom.getPolygon((int)this.m_selectedEdgeIndex.m_data[1]).m_data[0]), (double)0.5, (PdVector)this.m_geom.getVertex(this.m_geom.getPolygon((int)this.m_selectedEdgeIndex.m_data[1]).m_data[1]));
        this.m_selectTransform.setPoints(new PdVector[]{pt0, pt1});
        this.m_selectTransform.setMode(0);
        this.m_selectTransform.computeTransformationsTwoEdges();
        this.m_selectTransform.computeGeometry();
        this.m_selectTransform.setVisibleGeom(true);
        return true;
    }

    protected void addOffsetTransformBySelector() {
        this.m_selectTransform.setVisibleGeom(false);
        PiVector transform = this.m_selectTransform.getCurrentTransformation();
        int color = transform.m_data[0];
        int direction = transform.m_data[1];
        int index = transform.m_data[2];
        int orientation = transform.m_data[3];
        int rootIndex = this.m_geom.getStartVertexIndex(this.m_geom.getEdgeInformation(this.m_selectedEdgeIndex.m_data[0]));
        int targetIndex = orientation == 0 ? this.m_geom.getStartVertexIndex(this.m_geom.getEdgeInformation(this.m_selectedEdgeIndex.m_data[1])) : this.m_geom.getEdgeTarget(this.m_selectedEdgeIndex.m_data[1]);
        int permutationIndex = PnZomeSymmetry.fixEdgeRotationIndex[color][direction][index];
        if (this.m_bLogOperation) {
            this.m_log.logOperationCDVI(14, color, direction, new PiVector(rootIndex, targetIndex), index + 1);
        }
        this.addOffsetPermutation(rootIndex, targetIndex, permutationIndex);
        this.m_geom.update((Object)this.m_geom);
    }

    protected void displayAsElementSet(boolean flag) {
        if (flag) {
            PgElementSet geom = this.m_pwZomeGeom.computeGeometry(this.m_geom);
            if (this.m_display != null) {
                if (!this.m_display.containsGeometry((PgGeometryIf)this.m_pwZomeGeom.getGeometry())) {
                    this.m_display.addGeometry((PgGeometryIf)geom);
                }
                if (this.m_display.containsGeometry((PgGeometryIf)this.m_geom)) {
                    this.m_display.removeGeometry((PgGeometryIf)this.m_geom);
                }
                this.m_display.setEnabled3DLook(false);
                this.m_display.setEnabledAdaptiveSize(false);
            }
            geom.update((Object)geom);
        } else if (this.m_display != null) {
            if (this.m_display.containsGeometry((PgGeometryIf)this.m_pwZomeGeom.getGeometry())) {
                this.m_display.removeGeometry((PgGeometryIf)this.m_pwZomeGeom.getGeometry());
            }
            if (!this.m_display.containsGeometry((PgGeometryIf)this.m_geom)) {
                this.m_display.addGeometry((PgGeometryIf)this.m_geom);
            }
            this.m_display.setEnabled3DLook(true);
            this.m_display.setEnabledAdaptiveSize(true);
            this.m_geom.update((Object)this.m_geom);
        }
    }
}

