/*
 * Decompiled with CFR 0.152.
 */
package devZomeView;

import devZomeView.PgZomeSet;
import devZomeView.PnZomeSymmetry;
import devZomeView.PwZomeSelect;
import java.awt.Color;
import jv.geom.PgPolygonSet;
import jv.object.PsDebug;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.project.PjWorkshop;

public class PwSelectTransform
extends PjWorkshop {
    public static final int MODE_TWO_EDGES = 0;
    protected int m_mode = 0;
    PgPolygonSet m_polySet;
    protected PdVector m_center;
    protected PiVector[] m_transform;
    protected int m_numTransformations;
    protected int m_currentIndex;
    protected PdVector[] m_point;
    protected PiVector[] m_edge;
    protected int m_color;
    protected static final int ROTATION_COLOR = 0;
    protected static final int ROTATION_DIRECTION = 1;
    protected static final int ROTATION_INDEX = 2;
    protected static final int ROTATION_ORIENTATION = 3;

    public PwSelectTransform(String name) {
        super(name);
        this.m_geom = null;
        this.setGeometry((PgGeometry)new PgPolygonSet(3));
        this.m_polySet.setName("Selector Geometry");
        this.m_polySet.setGlobalVertexColor(new Color(127, 127, 127));
        if (((Object)((Object)this)).getClass() == PwSelectTransform.class) {
            this.init();
        }
    }

    public PwSelectTransform(String name, PgPolygonSet geom) {
        this(name);
        this.setGeometry((PgGeometry)geom);
    }

    public void init() {
        super.init();
    }

    public void setGeometry(PgGeometry geom) {
        if (geom == null || !(geom instanceof PgPolygonSet)) {
            PsDebug.warning((String)"Geom is not a PgPolygonSet.");
            return;
        }
        super.setGeometry(geom);
        this.m_polySet = (PgPolygonSet)geom;
    }

    public boolean update(Object event) {
        return super.update(event);
    }

    public String getName() {
        return "Transform Selector Workshop";
    }

    public void setVisibleGeom(boolean flag) {
        if (this.m_display == null) {
            PsDebug.message((String)"Missing display");
            return;
        }
        if (!flag && this.m_display.containsGeometry((PgGeometryIf)this.m_polySet)) {
            this.m_display.removeGeometry((PgGeometryIf)this.m_polySet);
        }
        if (flag && !this.m_display.containsGeometry((PgGeometryIf)this.m_polySet)) {
            this.m_display.addGeometry((PgGeometryIf)this.m_polySet);
            this.m_display.selectGeometry((PgGeometryIf)this.m_polySet);
            this.m_polySet.update((Object)this.m_polySet);
        }
    }

    public void setMode(int mode) {
        this.m_mode = mode;
    }

    protected boolean setPoints(PdVector[] point) {
        if (this.m_mode == 0 && point.length != 2) {
            return false;
        }
        this.m_point = point;
        return true;
    }

    protected boolean setEdges(PiVector[] edge) {
        boolean bEqual;
        if (this.m_mode == 0 && edge.length != 2) {
            return false;
        }
        if (this.m_mode == 0 && edge[0].m_data[1] != edge[1].m_data[1]) {
            PsDebug.message((String)"Edges should have the same color!");
            return false;
        }
        if (this.m_mode == 0 && edge[0].m_data[2] != edge[1].m_data[2]) {
            PsDebug.message((String)"Edges should have the same length!");
            return false;
        }
        this.m_edge = edge;
        this.m_color = edge[0].m_data[1];
        int nd = PnZomeSymmetry.m_numColDirs[this.m_color];
        boolean bl = bEqual = edge[0].m_data[3] % (nd / 2) == edge[1].m_data[3] % (nd / 2);
        if (this.m_mode == 0) {
            if (this.m_color == 0) {
                this.m_numTransformations = bEqual ? 9 : 10;
            } else if (this.m_color == 1) {
                this.m_numTransformations = bEqual ? 5 : 6;
            } else if (this.m_color == 2) {
                this.m_numTransformations = bEqual ? 3 : 4;
            } else if (this.m_color == 3 || this.m_color == 4) {
                this.m_numTransformations = bEqual ? 1 : 2;
            }
        }
        return true;
    }

    public void computeTransformationsTwoEdges() {
        this.m_currentIndex = 0;
        this.m_transform = PiVector.realloc((PiVector[])this.m_transform, (int)this.m_numTransformations, (int)4);
        int dir0 = this.m_edge[0].m_data[3];
        int dirPos = this.m_edge[1].m_data[3];
        int nd = PnZomeSymmetry.m_numColDirs[this.m_color];
        int dirNeg = (this.m_edge[1].m_data[3] + nd / 2) % nd;
        int numColors = 4;
        int i = 0;
        while (i < numColors) {
            int numDirs = PnZomeSymmetry.m_numColDirs[i];
            if (i == 2) {
                numDirs /= 2;
            }
            int j = 0;
            while (j < numDirs) {
                int numSym = (PnZomeSymmetry.fixEdgeRotationIndex[i][j].length + 1) / 2;
                int k = 0;
                while (k < numSym) {
                    int d = PnZomeSymmetry.m_symmetry[this.m_color][PnZomeSymmetry.fixEdgeRotationIndex[i][j][k]].m_data[dir0];
                    if (d == dirPos || d == dirNeg) {
                        if (this.m_currentIndex >= this.m_numTransformations) {
                            PsDebug.message((String)"Too many symmetries were found.");
                        } else if (d == dirPos) {
                            this.m_transform[this.m_currentIndex].set(i, j, k, 0);
                        } else {
                            this.m_transform[this.m_currentIndex].set(i, j, k, 1);
                        }
                        ++this.m_currentIndex;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        if (this.m_currentIndex < this.m_numTransformations) {
            PsDebug.message((String)"Not enough symmetries were found.");
        }
        this.m_currentIndex = 0;
    }

    public PiVector getCurrentTransformation() {
        return this.m_transform[this.m_currentIndex];
    }

    public void nextTransformation() {
        this.m_currentIndex = (this.m_currentIndex + 1) % this.m_numTransformations;
        this.computeGeometry();
    }

    public void previousTransformation() {
        this.m_currentIndex = (this.m_currentIndex + this.m_numTransformations - 1) % this.m_numTransformations;
        this.computeGeometry();
    }

    public void computeGeometry() {
        if (this.m_mode == 0) {
            int col = this.m_transform[this.m_currentIndex].m_data[0];
            int dir = this.m_transform[this.m_currentIndex].m_data[1];
            double angle = this.m_transform[this.m_currentIndex].m_data[2];
            int numArcVertices = 73;
            this.m_polySet.setNumVertices(2 * numArcVertices + 2);
            this.m_polySet.setGlobalPolygonColor(PgZomeSet.EDGE_COLOR[col]);
            int numPolygons = numArcVertices + 2;
            this.m_polySet.setNumPolygons(numPolygons);
            this.m_polySet.assurePolygonSizes();
            this.m_polySet.showPolygonSizes(true);
            this.m_polySet.assurePolygonColors();
            this.m_polySet.showPolygonColors(true);
            PiVector arc = new PiVector(numArcVertices);
            Color pCol = new Color(0, 0, 0);
            int i = 0;
            while (i < numArcVertices) {
                arc.m_data[i] = i;
                this.m_polySet.setPolygon(i + 2, new PiVector(i, numArcVertices + i));
                this.m_polySet.setPolygonSize(i + 2, 0.1);
                this.m_polySet.setPolygonColor(i + 2, pCol);
                ++i;
            }
            this.m_polySet.setPolygon(0, arc);
            this.m_polySet.setPolygonSize(0, 1.0);
            this.m_polySet.setPolygonColor(0, PwZomeSelect.EDGE_COLOR[col]);
            this.m_polySet.setPolygon(1, new PiVector(2 * numArcVertices, 2 * numArcVertices + 1));
            this.m_polySet.setPolygonSize(1, 1.0);
            this.m_polySet.setPolygonColor(1, PwZomeSelect.EDGE_COLOR[col]);
            this.m_polySet.showVertices(false);
            PdVector direction = new PdVector(3);
            PgZomeSet.setIntPosition(direction, PnZomeSymmetry.m_intDir[col][dir]);
            PdVector edge = PdVector.subNew((PdVector)this.m_point[1], (PdVector)this.m_point[0]);
            double dirLength = direction.sqrLength();
            PdVector frame0 = PdVector.blendNew((double)1.0, (PdVector)edge, (double)(-PdVector.dot((PdVector)edge, (PdVector)direction) / dirLength), (PdVector)direction);
            PdVector projection = PdVector.subNew((PdVector)edge, (PdVector)frame0);
            PdVector frame1 = PdVector.crossNew((PdVector)frame0, (PdVector)direction);
            dirLength = Math.sqrt(dirLength);
            frame1.multScalar(-1.0 / dirLength);
            angle += 1.0;
            if (col == 0) {
                angle *= 72.0;
            } else if (col == 1) {
                angle *= 120.0;
            } else if (col == 2) {
                angle *= 180.0;
            }
            PdVector center = PdVector.blendNew((double)1.0, (PdVector)this.m_point[0], (double)0.5, (PdVector)frame0);
            center.blendBase(center, 0.5 * Math.tan(1.5707963267948966 - (angle *= Math.PI / 180) / 2.0), frame1);
            frame0.sub(this.m_point[0], center);
            if (frame0.sqrLength() < 1.0E-10) {
                PgZomeSet.setIntPosition(frame0, PnZomeSymmetry.m_intDir[this.m_edge[0].m_data[1]][this.m_edge[0].m_data[3]]);
                frame0.blendBase(frame0, -PdVector.dot((PdVector)direction, (PdVector)frame0) / direction.sqrLength(), direction);
            }
            if (frame0.sqrLength() < 1.0E-10) {
                PgZomeSet.setIntPosition(frame0, PnZomeSymmetry.m_intDir[this.m_edge[0].m_data[1]][this.m_edge[1].m_data[3]]);
                frame0.blendBase(frame0, -PdVector.dot((PdVector)direction, (PdVector)frame0) / direction.sqrLength(), direction);
            }
            if (frame0.sqrLength() < 1.0E-10) {
                int dirIndex = (this.m_edge[0].m_data[3] + 1) % PnZomeSymmetry.m_numColDirs[this.m_edge[0].m_data[1]];
                PgZomeSet.setIntPosition(frame0, PnZomeSymmetry.m_intDir[this.m_edge[0].m_data[1]][dirIndex]);
                frame0.blendBase(frame0, -PdVector.dot((PdVector)direction, (PdVector)frame0) / direction.sqrLength(), direction);
            }
            frame1.cross(frame0, direction);
            frame1.multScalar(1.0 / dirLength);
            int i2 = 0;
            while (i2 < numArcVertices) {
                this.m_polySet.setVertex(i2, PdVector.blendNew((double)Math.cos(angle * (double)i2 / ((double)numArcVertices - 1.0)), (PdVector)frame0, (double)(-Math.sin(angle * (double)i2 / ((double)numArcVertices - 1.0))), (PdVector)frame1, (double)(1.0 * (double)i2 / ((double)numArcVertices - 1.0)), (PdVector)projection, (double)1.0, (PdVector)center));
                this.m_polySet.setVertex(numArcVertices + i2, PdVector.blendNew((double)(1.0 * (double)i2 / ((double)numArcVertices - 1.0)), (PdVector)projection, (double)1.0, (PdVector)center));
                ++i2;
            }
            center.blendBase(center, 0.5, projection);
            direction.multScalar((dirLength + projection.length()) / dirLength);
            this.m_polySet.setVertex(2 * numArcVertices, PdVector.blendNew((double)1.0, (PdVector)center, (double)-0.5, (PdVector)direction));
            this.m_polySet.setVertex(2 * numArcVertices + 1, PdVector.blendNew((double)1.0, (PdVector)center, (double)0.5, (PdVector)direction));
        }
        this.m_polySet.update((Object)this.m_polySet);
    }
}

