/*
 * Decompiled with CFR 0.152.
 */
package devZomeView;

import devZomeView.PnZomeSymmetry;
import devZomeView.PwZomeEditor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import jv.object.PsDebug;
import jv.vecmath.PiVector;

public class PlZomeScript {
    protected String m_fullScriptFileName = "D:\\test\\testScript.txt";
    protected int m_numOperations;
    protected int m_numPerformedSteps;
    protected String[] m_operation;
    protected PwZomeEditor m_pwEditor;
    private String[] m_colorString = new String[]{"Red", "Yellow", "Blue", "Green", "HalfGreen"};
    private String[] m_eventString = new String[]{"AddEdge", "ParallelCopyAll", "ParallelCopy", "SetVirtual", "SetSolid", "ScaleUp", "ScaleDown", "OrientedEdgeSymmetry", "AllEdgeSymmetry", "OrientedVertexSymmetry", "AllVertexSymmetry", "PointReflection", "PlaneReflection", "OffsetCopy", "OffsetTransform", "Connect", "CloseCycle", "SplitEdge"};
    protected static final int EVENT_ADD_EDGE = 0;
    protected static final int EVENT_PARALLEL_COPY_ALL = 1;
    protected static final int EVENT_PARALLEL_COPY_SEL = 2;
    protected static final int EVENT_SET_VIRTUAL = 3;
    protected static final int EVENT_SET_SOLID = 4;
    protected static final int EVENT_SCALE_UP = 5;
    protected static final int EVENT_SCALE_DOWN = 6;
    protected static final int EVENT_ORIENTED_EDGE_SYMMETRY = 7;
    protected static final int EVENT_ALL_EDGE_SYMMETRY = 8;
    protected static final int EVENT_ORIENTED_VERTEX_SYMMETRY = 9;
    protected static final int EVENT_ALL_VERTEX_SYMMETRY = 10;
    protected static final int EVENT_POINT_REFLECTION = 11;
    protected static final int EVENT_PLANE_REFLECTION = 12;
    protected static final int EVENT_OFFSET_COPY = 13;
    protected static final int EVENT_OFFSET_TRANSFORM = 14;
    protected static final int EVENT_CONNECT = 15;
    protected static final int EVENT_CLOSE_CYCLE = 16;
    protected static final int EVENT_SPLIT_EDGES = 17;
    private static final int m_numTypes = 18;

    public PlZomeScript(PwZomeEditor editor) {
        this.m_pwEditor = editor;
        this.m_numOperations = 0;
        this.m_numPerformedSteps = 0;
        this.m_operation = new String[0];
    }

    public void clearLog() {
        this.m_numOperations = 0;
        this.m_numPerformedSteps = 0;
        this.m_operation = new String[0];
    }

    public void rebuildToStep(int stepIndex) {
        if (stepIndex >= this.m_numOperations) {
            PsDebug.message((String)"Step index > num Operations.");
            return;
        }
        this.m_pwEditor.clearZomeSet();
        int i = 0;
        while (i < stepIndex + 1) {
            this.performStep(i);
            ++i;
        }
        this.m_numPerformedSteps = stepIndex + 1;
    }

    public void stepBack() {
        this.m_pwEditor.m_bLogOperation = false;
        if (this.m_numPerformedSteps > 0) {
            this.rebuildToStep(this.m_numPerformedSteps - 2);
        } else {
            PsDebug.message((String)"Can't step back");
        }
        this.m_pwEditor.m_bLogOperation = true;
    }

    public void stepForward() {
        this.m_pwEditor.m_bLogOperation = false;
        if (this.m_numPerformedSteps < this.m_numOperations) {
            this.performStep(this.m_numPerformedSteps);
            ++this.m_numPerformedSteps;
        } else {
            PsDebug.message((String)"Can't step forward");
        }
        this.m_pwEditor.m_bLogOperation = true;
    }

    public void logOperationVE(int type, int vertexIndex, int edgeIndex) {
        this.logOperation(type, -1, null, null, new int[]{vertexIndex}, new int[]{edgeIndex}, -1);
    }

    public void logOperationCDV(int type, int color, int direction, int vertexIndex) {
        this.logOperation(type, color, new int[]{direction}, null, new int[]{vertexIndex}, null, -1);
    }

    public void logOperationDV(int type, int direction, PiVector vertexIndex) {
        int nov = vertexIndex.getSize();
        int[] vi = new int[nov];
        int i = 0;
        while (i < nov) {
            vi[i] = vertexIndex.m_data[i];
            ++i;
        }
        this.logOperation(type, -1, new int[]{direction}, null, vi, null, -1);
    }

    public void logOperationDV(int type, int direction, int vertexIndex) {
        this.logOperation(type, -1, new int[]{direction}, null, new int[]{vertexIndex}, null, -1);
    }

    public void logOperationE(int type, int edgeIndex) {
        this.logOperation(type, -1, null, null, null, new int[]{edgeIndex}, -1);
    }

    public void logOperationE(int type, PiVector edgeIndex) {
        int nop = edgeIndex.getSize();
        int[] pi = new int[nop];
        int i = 0;
        while (i < nop) {
            pi[i] = edgeIndex.m_data[i];
            ++i;
        }
        this.logOperation(type, -1, null, null, null, pi, -1);
    }

    public void logOperationEV(int type, int edgeIndex, PiVector vertexIndex) {
        int nov = vertexIndex.getSize();
        int[] vi = new int[nov];
        int i = 0;
        while (i < nov) {
            vi[i] = vertexIndex.m_data[i];
            ++i;
        }
        this.logOperation(type, -1, null, null, vi, new int[]{edgeIndex}, -1);
    }

    public void logOperationEV(int type, int edgeIndex, int vertexIndex) {
        this.logOperation(type, -1, null, null, new int[]{vertexIndex}, new int[]{edgeIndex}, -1);
    }

    public void logOperationV(int type, int vertexIndex) {
        this.logOperation(type, -1, null, null, new int[]{vertexIndex}, null, -1);
    }

    public void logOperationV(int type, PiVector vertexIndex) {
        int nov = vertexIndex.getSize();
        int[] vi = new int[nov];
        int i = 0;
        while (i < nov) {
            vi[i] = vertexIndex.m_data[i];
            ++i;
        }
        this.logOperation(type, -1, null, null, vi, null, -1);
    }

    public void logOperationCDL(int type, int color, int[] direction, int length) {
        this.logOperation(type, color, direction, new int[]{length}, null, null, -1);
    }

    public void logOperationCDLV(int type, int color, int[] direction, int length, PiVector vertexIndex) {
        int nov = vertexIndex.getSize();
        int[] vi = new int[nov];
        int i = 0;
        while (i < nov) {
            vi[i] = vertexIndex.m_data[i];
            ++i;
        }
        this.logOperation(type, color, direction, new int[]{length}, vi, null, -1);
    }

    public void logOperationCDVI(int type, int color, int direction, PiVector vertexIndex, int index) {
        int nov = vertexIndex.getSize();
        int[] vi = new int[nov];
        int i = 0;
        while (i < nov) {
            vi[i] = vertexIndex.m_data[i];
            ++i;
        }
        this.logOperation(type, color, new int[]{direction}, null, vi, null, index);
    }

    public void logOperationCDLVE(int type, int color, int[] direction, int length, PiVector vertexIndex, PiVector edgeIndex) {
        int nov = vertexIndex.getSize();
        int[] vi = new int[nov];
        int i = 0;
        while (i < nov) {
            vi[i] = vertexIndex.m_data[i];
            ++i;
        }
        int nop = edgeIndex.getSize();
        int[] pi = new int[nop];
        int i2 = 0;
        while (i2 < nop) {
            pi[i2] = edgeIndex.m_data[i2];
            ++i2;
        }
        this.logOperation(type, color, direction, new int[]{length}, vi, pi, -1);
    }

    private void logOperation(int type, int color, int[] direction, int[] length, int[] vertexList, int[] edgeList, int index) {
        this.m_numOperations = this.m_numPerformedSteps;
        String[] operation = new String[this.m_numOperations + 1];
        int i = 0;
        while (i < this.m_numOperations) {
            operation[i] = this.m_operation[i];
            ++i;
        }
        operation[this.m_numOperations] = this.getEventString(type);
        if (color != -1) {
            int n = this.m_numOperations;
            operation[n] = String.valueOf(operation[n]) + " " + this.getColorString(color);
        }
        if (direction != null && direction.length > 0) {
            int n = this.m_numOperations;
            operation[n] = String.valueOf(operation[n]) + " " + this.getDirectionString(direction);
        }
        if (length != null && length.length > 0) {
            int n = this.m_numOperations;
            operation[n] = String.valueOf(operation[n]) + " " + this.getLengthString(length);
        }
        if (vertexList != null && vertexList.length > 0) {
            int n = this.m_numOperations;
            operation[n] = String.valueOf(operation[n]) + " " + this.getVertexString(vertexList);
        }
        if (edgeList != null && edgeList.length > 0) {
            int n = this.m_numOperations;
            operation[n] = String.valueOf(operation[n]) + " " + this.getEdgeString(edgeList);
        }
        if (index != -1) {
            int n = this.m_numOperations;
            operation[n] = String.valueOf(operation[n]) + " " + this.getIndexString(index);
        }
        ++this.m_numPerformedSteps;
        ++this.m_numOperations;
        this.m_operation = operation;
    }

    public void performStep(int index) {
        if (index < 0 || index >= this.m_numOperations) {
            PsDebug.message((String)"Invalid index");
            return;
        }
        String operation = this.m_operation[index];
        String[] information = operation.split(" ");
        int numParts = information.length;
        int type = -1;
        int i = 0;
        while (i < 18) {
            if (information[0].compareTo(this.m_eventString[i]) == 0) {
                type = i;
                break;
            }
            ++i;
        }
        int color = -1;
        int[] direction = null;
        int[] length = null;
        int[] vertex = null;
        int[] edge = null;
        int rotationIndex = -1;
        int i2 = 1;
        while (i2 < numParts) {
            if (information[i2].startsWith("C{")) {
                String colString = information[i2].substring(2, information[i2].length() - 1);
                int j = 0;
                while (j < this.m_colorString.length) {
                    if (colString.compareTo(this.m_colorString[j]) == 0) {
                        color = j;
                        break;
                    }
                    ++j;
                }
            } else if (information[i2].startsWith("D{")) {
                direction = this.parseList(information[i2].substring(2, information[i2].length() - 1));
            } else if (information[i2].startsWith("L{")) {
                length = this.parseList(information[i2].substring(2, information[i2].length() - 1));
            } else if (information[i2].startsWith("V{")) {
                vertex = this.parseList(information[i2].substring(2, information[i2].length() - 1));
            } else if (information[i2].startsWith("E{")) {
                edge = this.parseList(information[i2].substring(2, information[i2].length() - 1));
            } else if (information[i2].startsWith("I{")) {
                String indString = information[i2].substring(2, information[i2].length() - 1);
                rotationIndex = Integer.valueOf(indString);
            }
            ++i2;
        }
        switch (type) {
            case 0: {
                if (direction == null || length == null || vertex == null) {
                    PsDebug.warning((String)"Missing data.");
                    return;
                }
                int numDirections = direction.length;
                PiVector[] edgeInformation = PiVector.realloc(null, (int)numDirections, (int)6);
                int i3 = 0;
                while (i3 < numDirections) {
                    edgeInformation[i3].m_data[1] = color;
                    edgeInformation[i3].m_data[2] = length[0];
                    edgeInformation[i3].m_data[3] = direction[i3];
                    ++i3;
                }
                this.m_pwEditor.select(vertex, null);
                this.m_pwEditor.addEdgeAtSelectedVertices(edgeInformation);
                break;
            }
            case 1: {
                if (direction == null || length == null) {
                    PsDebug.warning((String)"Missing data.");
                    return;
                }
                int numDirections = direction.length;
                PiVector[] edgeInformation = PiVector.realloc(null, (int)numDirections, (int)6);
                int i3 = 0;
                while (i3 < numDirections) {
                    edgeInformation[i3].m_data[1] = color;
                    edgeInformation[i3].m_data[2] = length[0];
                    edgeInformation[i3].m_data[3] = direction[i3];
                    ++i3;
                }
                int nov = this.m_pwEditor.m_geom.getNumVertices();
                boolean[] bVertexSelected = new boolean[nov];
                int i4 = 0;
                while (i4 < nov) {
                    bVertexSelected[i4] = true;
                    ++i4;
                }
                int nop = this.m_pwEditor.m_geom.getNumPolygons();
                boolean[] bEdgeSelected = new boolean[nop];
                int i5 = 0;
                while (i5 < nop) {
                    bEdgeSelected[i5] = true;
                    ++i5;
                }
                this.m_pwEditor.parallelConnectedCopy(bVertexSelected, bEdgeSelected, edgeInformation);
                break;
            }
            case 2: {
                if (direction == null || length == null) {
                    PsDebug.warning((String)"Missing data.");
                    return;
                }
                int numDirections = direction.length;
                PiVector[] edgeInformation = PiVector.realloc(null, (int)numDirections, (int)6);
                int i3 = 0;
                while (i3 < numDirections) {
                    edgeInformation[i3].m_data[1] = color;
                    edgeInformation[i3].m_data[2] = length[0];
                    edgeInformation[i3].m_data[3] = direction[i3];
                    ++i3;
                }
                int nov = this.m_pwEditor.m_geom.getNumVertices();
                this.m_pwEditor.select(vertex, edge);
                boolean[] bVertexSelected = new boolean[nov];
                int i6 = 0;
                while (i6 < nov) {
                    bVertexSelected[i6] = this.m_pwEditor.m_geom.hasTagVertex(i6, 1);
                    ++i6;
                }
                int nop = this.m_pwEditor.m_geom.getNumPolygons();
                boolean[] bEdgeSelected = new boolean[nop];
                int i7 = 0;
                while (i7 < nop) {
                    bEdgeSelected[i7] = this.m_pwEditor.m_geom.hasTagPolygon(i7, 1);
                    ++i7;
                }
                this.m_pwEditor.parallelConnectedCopy(bVertexSelected, bEdgeSelected, edgeInformation);
                break;
            }
            case 3: {
                this.m_pwEditor.select(null, edge);
                this.m_pwEditor.m_geom.setSolidSelectedEdges(false);
                break;
            }
            case 4: {
                this.m_pwEditor.select(null, edge);
                this.m_pwEditor.m_geom.setSolidSelectedEdges(true);
                break;
            }
            case 5: {
                this.m_pwEditor.select(null, edge);
                this.m_pwEditor.scaleSelectedEdges(1);
                break;
            }
            case 6: {
                this.m_pwEditor.select(null, edge);
                this.m_pwEditor.scaleSelectedEdges(-1);
                break;
            }
            case 7: {
                int dir = -1;
                if (direction != null && direction.length > 0) {
                    dir = direction[0];
                }
                int edgeIndex = -1;
                if (edge != null && edge.length > 0) {
                    edgeIndex = edge[0];
                    if (dir == -1) {
                        dir = this.m_pwEditor.m_geom.getEdgeDirection(edgeIndex);
                    }
                    if (color == -1) {
                        color = this.m_pwEditor.m_geom.getEdgeColor(edgeIndex);
                    }
                }
                this.m_pwEditor.select(vertex, edge);
                this.m_pwEditor.addEdgeSymmetry(color, dir, edgeIndex, true);
                break;
            }
            case 8: {
                int dir = -1;
                if (direction != null && direction.length > 0) {
                    dir = direction[0];
                }
                int edgeIndex = -1;
                if (edge != null && edge.length > 0) {
                    edgeIndex = edge[0];
                    if (dir == -1) {
                        dir = this.m_pwEditor.m_geom.getEdgeDirection(edgeIndex);
                    }
                    if (color == -1) {
                        color = this.m_pwEditor.m_geom.getEdgeColor(edgeIndex);
                    }
                }
                this.m_pwEditor.select(vertex, edge);
                this.m_pwEditor.addEdgeSymmetry(color, dir, edgeIndex, false);
                break;
            }
            case 9: {
                this.m_pwEditor.select(vertex, null);
                this.m_pwEditor.addFullOrientedSymmetry();
                break;
            }
            case 10: {
                this.m_pwEditor.select(vertex, null);
                this.m_pwEditor.addFull120Symmetry();
                break;
            }
            case 11: {
                this.m_pwEditor.select(vertex, edge);
                this.m_pwEditor.addPointReflection();
                break;
            }
            case 12: {
                int dir = -1;
                if (direction != null && direction.length > 0) {
                    dir = direction[0];
                }
                int edgeIndex = -1;
                if (edge != null && edge.length > 0) {
                    edgeIndex = edge[0];
                    if (dir == -1) {
                        dir = this.m_pwEditor.m_geom.getEdgeDirection(edgeIndex);
                    }
                }
                this.m_pwEditor.select(vertex, edge);
                this.m_pwEditor.addPlaneReflection(dir, edgeIndex);
                break;
            }
            case 13: {
                this.m_pwEditor.select(vertex, null);
                this.m_pwEditor.addOffsetCopyTwoPoints();
                break;
            }
            case 14: {
                int dir = -1;
                if (direction == null || direction.length <= 0) {
                    PsDebug.message((String)"Missing data.");
                    return;
                }
                dir = direction[0];
                int permutationIndex = PnZomeSymmetry.fixEdgeRotationIndex[color][dir][rotationIndex - 1];
                int rootIndex = -1;
                int targetIndex = -1;
                if (vertex == null || vertex.length <= 1) {
                    PsDebug.message((String)"Missing data.");
                    return;
                }
                rootIndex = vertex[0];
                targetIndex = vertex[1];
                this.m_pwEditor.addOffsetPermutation(rootIndex, targetIndex, permutationIndex);
                break;
            }
            case 15: {
                this.m_pwEditor.select(vertex, null);
                this.m_pwEditor.connectSelectedPoints();
                break;
            }
            case 16: {
                this.m_pwEditor.select(null, edge);
                this.m_pwEditor.closeCycle();
                break;
            }
            case 17: {
                this.m_pwEditor.select(null, edge);
                this.m_pwEditor.splitSelectedEdges();
                break;
            }
            default: {
                PsDebug.message((String)"Type not found.");
            }
        }
    }

    private int[] parseList(String list) {
        String[] item = list.split(",");
        int num = item.length;
        int[] index = new int[num];
        int i = 0;
        while (i < num) {
            index[i] = Integer.valueOf(item[i]);
            ++i;
        }
        return index;
    }

    private String getEventString(int index) {
        return this.m_eventString[index];
    }

    private String getColorString(int color) {
        return "C{" + this.m_colorString[color] + "}";
    }

    private String getDirectionString(int[] direction) {
        String ds = "D{";
        int numDir = direction.length;
        int i = 0;
        while (i < numDir) {
            if (i != 0) {
                ds = String.valueOf(ds) + ",";
            }
            ds = String.valueOf(ds) + direction[i];
            ++i;
        }
        ds = String.valueOf(ds) + "}";
        return ds;
    }

    private String getLengthString(int[] length) {
        String ls = "L{";
        int numLength = length.length;
        int i = 0;
        while (i < numLength) {
            if (i != 0) {
                ls = String.valueOf(ls) + ",";
            }
            ls = String.valueOf(ls) + length[i];
            ++i;
        }
        ls = String.valueOf(ls) + "}";
        return ls;
    }

    private String getIndexString(int index) {
        return "I{" + index + "}";
    }

    private String getVertexString(int[] index) {
        String vs = "V{";
        int numSel = index.length;
        int i = 0;
        while (i < numSel) {
            if (i != 0) {
                vs = String.valueOf(vs) + ",";
            }
            vs = String.valueOf(vs) + index[i];
            ++i;
        }
        vs = String.valueOf(vs) + "}";
        return vs;
    }

    private String getEdgeString(int[] index) {
        String es = "E{";
        int numSel = index.length;
        int i = 0;
        while (i < numSel) {
            if (i != 0) {
                es = String.valueOf(es) + ",";
            }
            es = String.valueOf(es) + index[i];
            ++i;
        }
        es = String.valueOf(es) + "}";
        return es;
    }

    public void storeScript() {
        String fileName = this.m_fullScriptFileName;
        File scriptFile = new File(fileName);
        try {
            FileWriter fw = new FileWriter(scriptFile, false);
            BufferedWriter bw = new BufferedWriter(fw);
            int i = 0;
            while (i < this.m_numPerformedSteps) {
                bw.write(String.valueOf(this.m_operation[i]) + "\r\n");
                ++i;
            }
            bw.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void loadScript() {
        String fileName = this.m_fullScriptFileName;
        File scriptFile = new File(fileName);
        Vector<String> lv = new Vector<String>();
        try {
            FileReader fr = new FileReader(scriptFile);
            BufferedReader br = new BufferedReader(fr);
            String line = br.readLine();
            while (line != null) {
                lv.addElement(line);
                line = br.readLine();
            }
            fr.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.m_numOperations = lv.size();
        this.m_operation = new String[this.m_numOperations];
        int i = 0;
        while (i < this.m_numOperations) {
            this.m_operation[i] = (String)lv.elementAt(i);
            ++i;
        }
        this.m_pwEditor.m_bLogOperation = false;
        this.rebuildToStep(this.m_numOperations - 1);
        this.m_pwEditor.m_bLogOperation = true;
    }
}

