/*
 * Decompiled with CFR 0.152.
 */
package devZomeView;

import devZomeView.PnZomeSymmetry;
import java.awt.Color;
import java.util.Comparator;
import java.util.TreeSet;
import jv.geom.PgPolygonSet;
import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PgZomeSet
extends PgPolygonSet {
    public static final Color[] EDGE_COLOR = new Color[]{new Color(223, 0, 0), new Color(255, 223, 0), new Color(0, 127, 255), new Color(0, 159, 31), new Color(0, 159, 31)};
    public static final Color virtualColor = new Color(191, 191, 191);
    protected double m_solidVertexSize = 1.0;
    protected double m_virtualVertexSize = 0.1;
    protected double m_solidEdgeSize = 1.0;
    protected double m_virtualEdgeSize = 0.1;
    private static final double SQRT5 = Math.sqrt(5.0);
    private PiVector[] m_intVertex;
    protected TreeSet<Integer> m_vertexTree;
    protected PiVector m_newPosition;
    protected static final int SOLID_EDGE = 0;
    protected static final int VIRTUAL_EDGE = 1;
    protected static final int EDGE_INFO_LENGTH = 6;
    protected static final int START_INDEX = 0;
    protected static final int COLOR = 1;
    protected static final int LENGTH = 2;
    protected static final int DIRECTION = 3;
    protected static final int TARGET = 4;
    protected static final int VIRTUAL = 5;
    protected PiVector[] m_buildTree;
    private PiVector[] m_edgeAtVertex;

    public PgZomeSet() {
        super(3);
        this.setDimOfPolygons(2);
        this.m_vertexTree = new TreeSet<Integer>(new Comparator<Integer>(){

            @Override
            public int compare(Integer i0, Integer i1) {
                PiVector v0 = i0 == -1 ? PgZomeSet.this.m_newPosition : PgZomeSet.this.getIntPosition(i0);
                PiVector v1 = i1 == -1 ? PgZomeSet.this.m_newPosition : PgZomeSet.this.getIntPosition(i1);
                int i = 0;
                while (i < 6) {
                    if (v0.m_data[i] < v1.m_data[i]) {
                        return -1;
                    }
                    if (v0.m_data[i] > v1.m_data[i]) {
                        return 1;
                    }
                    ++i;
                }
                return 0;
            }
        });
        this.m_buildTree = PiVector.realloc((PiVector[])this.m_buildTree, (int)0, (int)6);
        if (((Object)((Object)this)).getClass() == PgZomeSet.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
    }

    public void setNumVertices(int nov) {
        if (this.m_numVertices > nov) {
            this.m_vertexTree.clear();
            int i = 0;
            while (i < nov) {
                this.m_vertexTree.add(i);
                ++i;
            }
        }
        super.setNumVertices(nov);
    }

    public void setMaxNumVertices(int numVertices) {
        super.setMaxNumVertices(numVertices);
        this.m_intVertex = PiVector.realloc((PiVector[])this.m_intVertex, (int)this.m_maxNumVertices, (int)6);
        this.m_edgeAtVertex = PiVector.realloc((PiVector[])this.m_edgeAtVertex, (int)this.m_maxNumVertices);
    }

    public void setTagPolygon(int ind, int aTag) {
        super.setTagPolygon(ind, aTag);
        if (aTag == 1 && ind < this.m_buildTree.length) {
            this.m_buildTree[ind].setTag(1);
        }
    }

    public void clearTagPolygon(int ind, int aTag) {
        super.clearTagPolygon(ind, aTag);
        if (aTag == 1 && ind < this.m_buildTree.length) {
            this.m_buildTree[ind].clearTag(1);
        }
    }

    public void setIntVertices(PiVector[] iv) {
        int i = 0;
        while (i < this.m_numVertices) {
            this.m_intVertex[i] = iv[i];
            ++i;
        }
        this.rebuildVertexTree();
    }

    public void setNumPolygons(int nop) {
        super.setNumPolygons(nop);
    }

    public void setMaxNumPolygons(int numPolygons) {
        if (this.m_maxNumPolygons == numPolygons) {
            return;
        }
        super.setMaxNumPolygons(numPolygons);
        this.m_buildTree = PiVector.realloc((PiVector[])this.m_buildTree, (int)numPolygons, (int)6);
    }

    public void setBuildTree(PiVector[] newBuildTree) {
        int i = 0;
        while (i < this.m_numPolygons) {
            this.m_buildTree[i].copy(newBuildTree[i]);
            ++i;
        }
    }

    public int assurePosition(PiVector position) {
        this.m_newPosition = position;
        Integer index = this.m_vertexTree.floor(-1);
        if (index != null && this.m_intVertex[index].equals(position)) {
            return index;
        }
        this.setNumVertices(this.m_numVertices + 1);
        this.m_intVertex[this.m_numVertices - 1].copy(position);
        this.m_vertexTree.add(this.m_numVertices - 1);
        return this.m_numVertices - 1;
    }

    protected void rebuildVertexTree() {
        this.m_vertexTree.clear();
        int i = 0;
        while (i < this.m_numVertices) {
            this.m_vertexTree.add(i);
            ++i;
        }
    }

    public void buildFromTree() {
        this.setNumVertices(0);
        PiVector rootPosition = new PiVector(6);
        rootPosition.setConstant(0);
        this.assurePosition(rootPosition);
        PiVector position = new PiVector(6);
        int i = 0;
        while (i < this.m_numPolygons) {
            int startVertexInd = this.getStartVertexIndex(this.m_buildTree[i]);
            position.copy(this.getIntPosition(startVertexInd));
            position.add(this.getEdgeDir(i));
            this.m_buildTree[i].m_data[4] = this.assurePosition(position);
            ++i;
        }
        this.computeEdgeAtVertexInformation();
        this.computePolygonSet();
    }

    protected PiVector getEdgeDir(int index) {
        return this.getEdgeDir(this.m_buildTree[index]);
    }

    protected PiVector getEdgeDir(PiVector edge) {
        PiVector direction = new PiVector(6);
        if (edge.m_data[3] >= PnZomeSymmetry.m_numColDirs[edge.m_data[1]] || edge.m_data[3] < 0) {
            edge.m_data[3] = 0;
        }
        direction.copy(PnZomeSymmetry.m_intDir[edge.m_data[1]][edge.m_data[3]]);
        int j = edge.m_data[2];
        while (j < 0) {
            PnZomeSymmetry.divByPhi(direction);
            ++j;
        }
        j = 0;
        while (j < edge.m_data[2]) {
            PnZomeSymmetry.multByPhi(direction);
            ++j;
        }
        return direction;
    }

    public void computePolygonSet() {
        this.assurePolygonSizes();
        this.showPolygonSizes(true);
        this.assureVertexSizes();
        this.showVertexSizes(true);
        boolean[] hasSolidEdge = new boolean[this.m_numVertices];
        int i = 0;
        while (i < this.m_numVertices) {
            hasSolidEdge[i] = false;
            ++i;
        }
        i = 0;
        while (i < this.m_numPolygons) {
            int startEdgeInd = this.m_buildTree[i].m_data[0];
            int startVertexInd = 0;
            if (this.m_buildTree[i].m_data[0] < 0) {
                startVertexInd = 0;
            } else if (this.m_buildTree[i].m_data[0] < i) {
                startVertexInd = this.m_buildTree[startEdgeInd].m_data[4];
            }
            this.setPolygonSize(i, 2.0);
            int endVertexInd = this.m_buildTree[i].m_data[4];
            this.m_polygon[i].set(startVertexInd, endVertexInd);
            if (this.m_buildTree[i].hasTag(1)) {
                this.setTagPolygon(i, 1);
            } else {
                this.clearTagPolygon(i, 1);
            }
            this.m_polygonColor[i] = this.m_buildTree[i].m_data[5] == 1 ? virtualColor : EDGE_COLOR[this.m_buildTree[i].m_data[1]];
            if (this.m_buildTree[i].m_data[5] == 1) {
                this.m_polygonSize.m_data[i] = this.m_virtualEdgeSize;
            } else {
                this.m_polygonSize.m_data[i] = this.m_solidEdgeSize;
                hasSolidEdge[startVertexInd] = true;
                hasSolidEdge[endVertexInd] = true;
            }
            ++i;
        }
        i = 0;
        while (i < this.m_numVertices) {
            PgZomeSet.setIntPosition(this.m_vertex[i], this.m_intVertex[i]);
            this.m_vertexSize.m_data[i] = hasSolidEdge[i] ? this.m_solidVertexSize : this.m_virtualVertexSize;
            ++i;
        }
    }

    protected static void setIntPosition(PdVector vertex, PiVector intPosition) {
        int i = 0;
        while (i < 3) {
            vertex.m_data[i] = (double)intPosition.m_data[2 * i] + SQRT5 * (double)intPosition.m_data[2 * i + 1];
            ++i;
        }
    }

    protected PiVector getIntPosition(int index) {
        return this.m_intVertex[index];
    }

    public PiVector getEdgeInformation(int index) {
        return this.m_buildTree[index];
    }

    public int getPreviousEdgeIndex(int edgeIndex) {
        return this.m_buildTree[edgeIndex].m_data[0];
    }

    public int getEdgeColor(int edgeIndex) {
        return this.m_buildTree[edgeIndex].m_data[1];
    }

    public int getEdgeLength(int edgeIndex) {
        return this.m_buildTree[edgeIndex].m_data[2];
    }

    public int getEdgeDirection(int edgeIndex) {
        return this.m_buildTree[edgeIndex].m_data[3];
    }

    public int getEdgeTarget(int edgeIndex) {
        return this.m_buildTree[edgeIndex].m_data[4];
    }

    public boolean edgeIsVirtual(int edgeIndex) {
        return this.m_buildTree[edgeIndex].m_data[5] == 1;
    }

    public boolean vertexIsVirtual(int vertexIndex) {
        return this.getVertexSize(vertexIndex) == this.m_virtualVertexSize;
    }

    public int getStartVertexIndex(PiVector edge) {
        if (edge.m_data[0] < 0) {
            return 0;
        }
        return this.m_buildTree[edge.m_data[0]].m_data[4];
    }

    public void registerEdge(int index) {
        int[] vertexIndex = new int[]{this.getStartVertexIndex(this.m_buildTree[index]), this.m_buildTree[index].m_data[4]};
        int i = 0;
        while (i < 2) {
            int num = this.m_edgeAtVertex[vertexIndex[i]].getSize();
            this.m_edgeAtVertex[vertexIndex[i]].setSize(num + 1);
            this.m_edgeAtVertex[vertexIndex[i]].m_data[num] = index;
            ++i;
        }
    }

    public void computeEdgeAtVertexInformation() {
        this.m_edgeAtVertex = PiVector.realloc((PiVector[])this.m_edgeAtVertex, (int)this.m_maxNumVertices, (int)0);
        int i = 0;
        while (i < this.m_numPolygons) {
            this.registerEdge(i);
            ++i;
        }
    }

    public int getEdgeIndex(int startIndex, int endIndex) {
        int numEdges = this.m_edgeAtVertex[startIndex].getSize();
        int i = 0;
        while (i < numEdges) {
            if (this.m_buildTree[this.m_edgeAtVertex[startIndex].m_data[i]].m_data[4] != startIndex && this.getStartVertexIndex(this.m_buildTree[this.m_edgeAtVertex[startIndex].m_data[i]]) != startIndex) {
                PsDebug.message((String)"Error in PgZomeSet.m_edgeAtVertex information.");
            }
            if (this.m_buildTree[this.m_edgeAtVertex[startIndex].m_data[i]].m_data[4] == endIndex) {
                return this.m_edgeAtVertex[startIndex].m_data[i];
            }
            if (this.getStartVertexIndex(this.m_buildTree[this.m_edgeAtVertex[startIndex].m_data[i]]) == endIndex) {
                return this.m_edgeAtVertex[startIndex].m_data[i];
            }
            ++i;
        }
        return -1;
    }

    public void setSolidSelectedEdges(boolean flag) {
        int i = 0;
        while (i < this.m_numPolygons) {
            if (this.hasTagPolygon(i, 1)) {
                this.m_buildTree[i].m_data[5] = flag ? 0 : 1;
                this.clearTagPolygon(i, 1);
            }
            ++i;
        }
        this.computePolygonSet();
        this.update((Object)this);
    }
}

