/*
 * Decompiled with CFR 0.152.
 */
package devRiemannSurface.branchgraph;

import devRiemannSurface.branchgraph.PdBranchDescription;
import devRiemannSurface.branchgraph.PgBranchCut;
import devRiemannSurface.branchgraph.PgBranchGraph;
import java.util.LinkedList;
import java.util.List;
import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgVertexStar;

public class PnBranchGraphAnalyzer {
    public static final double PRECISION = Math.pow(10.0, -4.0);
    public static final int LEFT = 1;
    public static final int RIGHT = -1;

    public static List<PdBranchDescription> analyze(int vertex, PgElementSet geom, PgBranchGraph bg) {
        LinkedList<PdBranchDescription> l = new LinkedList<PdBranchDescription>();
        PgBranchCut[] branchCuts = bg.getBranchCuts();
        int length = branchCuts.length;
        int i = 0;
        while (i < length) {
            PdBranchDescription d = PnBranchGraphAnalyzer.analyze(vertex, branchCuts[i], geom);
            l.add(d);
            ++i;
        }
        return l;
    }

    public static PdBranchDescription analyze(int vertex, PgBranchCut pgBranchCut, PgElementSet geom) {
        PiVector vertices = pgBranchCut.getVertices();
        int minVertex = PnBranchGraphAnalyzer.computeMinVertexInd(vertex, vertices, geom);
        double minDist = Double.NaN;
        PdVector vertexInCoords = geom.getVertex(vertex);
        PdVector minVertexInCoords = geom.getVertex(vertices.getEntry(minVertex));
        minDist = PdVector.dist((PdVector)vertexInCoords, (PdVector)minVertexInCoords);
        assert (Double.isNaN(minDist));
        if (vertex == 1916 || vertex == 1917 || vertex == 1918) {
            System.out.println("baosd");
        }
        double angle = Double.NaN;
        angle = PnBranchGraphAnalyzer.relAngleToLine(vertex, vertices, geom);
        int connectivity = PnBranchGraphAnalyzer.computeConnectivity(vertex, vertices, geom);
        return new PdBranchDescription(false, connectivity, minDist, pgBranchCut.getShift(), angle, minVertex);
    }

    public static double relAngleToLine(int vertex, PiVector line, PgElementSet geom) {
        int nov = line.getSize();
        PdVector vertexInCoords = geom.getVertex(vertex);
        int minVertex = -1;
        double minDist = Double.MAX_VALUE;
        int curVertex = 0;
        int i = 0;
        while (i < nov) {
            curVertex = line.getEntry(i);
            PdVector curVertexInCoords = geom.getVertex(curVertex);
            double curDist = PdVector.dist((PdVector)vertexInCoords, (PdVector)curVertexInCoords);
            if (curDist < minDist) {
                minVertex = i;
                minDist = curDist;
            }
            ++i;
        }
        assert (minVertex != -1);
        double angle = Double.NaN;
        if (vertex != line.getEntry(minVertex)) {
            PdVector minVertexInCoords = geom.getVertex(line.getEntry(minVertex));
            if (nov - 1 == minVertex) {
                PdVector preSpanVertexInCoords = geom.getVertex(line.getEntry(minVertex - 1));
                PdVector extension = PdVector.subNew((PdVector)minVertexInCoords, (PdVector)preSpanVertexInCoords);
                PdVector sucSpanVertexInCoords = PdVector.addNew((PdVector)minVertexInCoords, (PdVector)extension);
                double beta = PnBranchGraphAnalyzer.relAngleInTriangle(minVertexInCoords, sucSpanVertexInCoords, vertexInCoords);
                angle = Math.abs(beta) < 90.0 ? beta : (beta < PRECISION ? -90.0 : 90.0);
            } else if (minVertex == 0) {
                PdVector sucSpanVertexInCoords = geom.getVertex(line.getEntry(minVertex + 1));
                PdVector extension = PdVector.subNew((PdVector)sucSpanVertexInCoords, (PdVector)minVertexInCoords);
                PdVector preSpanVertexInCoords = PdVector.subNew((PdVector)minVertexInCoords, (PdVector)extension);
                double beta = PnBranchGraphAnalyzer.relAngleInTriangle(minVertexInCoords, sucSpanVertexInCoords, vertexInCoords);
                angle = Math.abs(beta) > 90.0 ? beta : (beta < PRECISION ? -90.0 : 90.0);
            } else {
                PdVector preSpanVertexInCoords = geom.getVertex(line.getEntry(minVertex - 1));
                PdVector sucSpanVertexInCoords = geom.getVertex(line.getEntry(minVertex + 1));
                double alpha = PnBranchGraphAnalyzer.relAngleInTriangle(preSpanVertexInCoords, minVertexInCoords, vertexInCoords);
                double beta = PnBranchGraphAnalyzer.relAngleInTriangle(minVertexInCoords, sucSpanVertexInCoords, vertexInCoords);
                if (Math.signum(alpha) != Math.signum(beta)) {
                    if (Math.signum(alpha) > 0.0 && Math.signum(beta) < 0.0) {
                        angle = -90.0;
                    } else if (Math.signum(alpha) < 0.0 && Math.signum(beta) > 0.0) {
                        angle = 90.0;
                    }
                }
                angle = 180.0 - Math.abs(beta) < PRECISION ? (alpha < 0.0 ? -90.0 : 90.0) : (180.0 - Math.abs(alpha) < PRECISION ? (beta < 0.0 ? -90.0 : 90.0) : (beta < PRECISION ? -90.0 : 90.0));
            }
        } else {
            angle = 0.0;
        }
        assert (!Double.isNaN(angle));
        return angle;
    }

    public static int computeMinVertexInd(int vertex, PiVector line, PgElementSet geom) {
        int nov = line.getSize();
        PdVector vertexInCoords = geom.getVertex(vertex);
        int minVertex = -1;
        double minDist = Double.MAX_VALUE;
        int curVertex = 0;
        int i = 0;
        while (i < nov) {
            curVertex = line.getEntry(i);
            PdVector curVertexInCoords = geom.getVertex(curVertex);
            double curDist = PdVector.dist((PdVector)vertexInCoords, (PdVector)curVertexInCoords);
            if (curDist < minDist) {
                minVertex = i;
                minDist = curDist;
            }
            ++i;
        }
        assert (minVertex != -1);
        return minVertex;
    }

    public static double relAngle(PdVector ref, PdVector rel) {
        PdVector orthRef = new PdVector(ref.m_data[1], -ref.m_data[0], 0.0);
        double alpha = PdVector.angle((PdVector)ref, (PdVector)rel);
        double beta = PdVector.angle((PdVector)orthRef, (PdVector)rel);
        if (beta >= 90.0) {
            return alpha;
        }
        return -alpha;
    }

    public static double relAngleInTriangle(PdVector p, PdVector a, PdVector b) {
        PdVector ref = PdVector.subNew((PdVector)a, (PdVector)p);
        PdVector rel = PdVector.subNew((PdVector)b, (PdVector)p);
        return PnBranchGraphAnalyzer.relAngle(ref, rel);
    }

    public static int computeConnectivity(int vertex, PiVector vertices, PgElementSet geom) {
        int connectivity = 0;
        if (vertex != vertices.getFirstEntry() && vertex != vertices.getLastEntry()) {
            PgVertexStar vs = new PgVertexStar();
            vs.makeVertexStar(geom, vertex, -1);
            PiVector elements = vs.getElement();
            if (elements.getSize() == 0) {
                PsDebug.warning((String)("No adjacent elements for vertex " + vertex));
                return 0;
            }
            PiVector nbElement = geom.getElement(elements.getFirstEntry());
            int nbElSize = nbElement.getSize();
            int k = 0;
            while (k < nbElSize) {
                PdVector locMinInCoords;
                int n = nbElement.getEntry(k);
                int locMin = PnBranchGraphAnalyzer.computeMinVertexInd(n, vertices, geom);
                PdVector neighInCoords = geom.getVertex(n);
                if (!(PdVector.dist((PdVector)neighInCoords, (PdVector)(locMinInCoords = geom.getVertex(vertices.getEntry(locMin)))) < PRECISION)) {
                    double locAngle = PnBranchGraphAnalyzer.relAngleToLine(n, vertices, geom);
                    if (locAngle < -PRECISION) {
                        connectivity = -1;
                        break;
                    }
                    if (locAngle > PRECISION) {
                        connectivity = 1;
                        break;
                    }
                }
                ++k;
            }
        }
        return connectivity;
    }
}

